/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import zombie.core.properties.PropertyContainer;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.RoomDef;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.areas.IsoRoom;
import zombie.iso.sprite.IsoSprite;

public final class IsoRoofFixer {
    private static final boolean PER_ROOM_MODE = true;
    private static final int MAX_Z = 8;
    private static final int SCAN_RANGE = 3;
    private static final boolean ALWAYS_INVIS_FLOORS = false;
    private static boolean roofTileGlassCacheDirty = true;
    private static boolean roofTileIsGlass = false;
    private static IsoSprite roofTileCache;
    private static int roofTilePlaceFloorIndexCache;
    private static String invisFloor;
    private static Map<Integer, String> roofGroups;
    private static PlaceFloorInfo[] placeFloorInfos;
    private static int floorInfoIndex;
    private static IsoGridSquare[] sqCache;
    private static IsoRoom workingRoom;
    private static int[] interiorAirSpaces;
    private static final int I_UNCHECKED = 0;
    private static final int I_TRUE = 1;
    private static final int I_FALSE = 2;

    private static void ensureCapacityFloorInfos() {
        if (floorInfoIndex == placeFloorInfos.length) {
            PlaceFloorInfo[] placeFloorInfoArray = placeFloorInfos;
            placeFloorInfos = new PlaceFloorInfo[placeFloorInfos.length + 400];
            System.arraycopy(placeFloorInfoArray, 0, placeFloorInfos, 0, placeFloorInfoArray.length);
        }
    }

    private static void setRoofTileCache(IsoObject isoObject) {
        IsoSprite isoSprite;
        IsoSprite isoSprite2 = isoSprite = isoObject != null ? isoObject.sprite : null;
        if (roofTileCache != isoSprite) {
            roofTileCache = isoSprite;
            roofTilePlaceFloorIndexCache = 0;
            if (isoSprite != null && isoSprite.getProperties() != null && isoSprite.getProperties().Val("RoofGroup") != null) {
                try {
                    int n = Integer.parseInt(isoSprite.getProperties().Val("RoofGroup"));
                    if (roofGroups.containsKey(n)) {
                        roofTilePlaceFloorIndexCache = n;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            roofTileGlassCacheDirty = true;
        }
    }

    private static boolean isRoofTileCacheGlass() {
        if (roofTileGlassCacheDirty) {
            PropertyContainer propertyContainer;
            roofTileIsGlass = false;
            if (roofTileCache != null && (propertyContainer = roofTileCache.getProperties()) != null) {
                String string = propertyContainer.Val("Material");
                roofTileIsGlass = string != null && string.equalsIgnoreCase("glass");
            }
            roofTileGlassCacheDirty = false;
        }
        return roofTileIsGlass;
    }

    public static void FixRoofsAt(IsoGridSquare isoGridSquare) {
        try {
            IsoRoofFixer.FixRoofsPerRoomAt(isoGridSquare);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void FixRoofsPerRoomAt(IsoGridSquare isoGridSquare) {
        IsoRoom isoRoom;
        floorInfoIndex = 0;
        if (isoGridSquare.getZ() > 0 && !isoGridSquare.TreatAsSolidFloor() && isoGridSquare.getRoom() == null && (isoRoom = IsoRoofFixer.getRoomBelow(isoGridSquare)) != null && !isoRoom.def.isRoofFixed()) {
            IsoRoofFixer.resetInteriorSpaceCache();
            workingRoom = isoRoom;
            ArrayList<IsoGridSquare> arrayList = isoRoom.getSquares();
            for (int i = 0; i < arrayList.size(); ++i) {
                IsoGridSquare isoGridSquare2 = arrayList.get(i);
                IsoGridSquare isoGridSquare3 = IsoRoofFixer.getRoofFloorForColumn(isoGridSquare2);
                if (isoGridSquare3 == null) continue;
                IsoRoofFixer.ensureCapacityFloorInfos();
                placeFloorInfos[floorInfoIndex++].set(isoGridSquare3, roofTilePlaceFloorIndexCache);
            }
            isoRoom.def.setRoofFixed(true);
        }
        for (int i = 0; i < floorInfoIndex; ++i) {
            IsoRoofFixer.placeFloorInfos[i].square.addFloor(roofGroups.get(IsoRoofFixer.placeFloorInfos[i].floorType));
        }
    }

    private static void clearSqCache() {
        for (int i = 0; i < sqCache.length; ++i) {
            IsoRoofFixer.sqCache[i] = null;
        }
    }

    private static IsoGridSquare getRoofFloorForColumn(IsoGridSquare isoGridSquare) {
        IsoGridSquare isoGridSquare2;
        if (isoGridSquare == null) {
            return null;
        }
        IsoCell isoCell = IsoCell.getInstance();
        int n = 0;
        boolean bl = false;
        for (int i = 7; i >= isoGridSquare.getZ() + 1; --i) {
            isoGridSquare2 = isoCell.getGridSquare(isoGridSquare.x, isoGridSquare.y, i);
            if (isoGridSquare2 == null) {
                if (i == isoGridSquare.getZ() + 1 && i > 0 && !IsoRoofFixer.isStairsBelow(isoGridSquare.x, isoGridSquare.y, i)) {
                    isoGridSquare2 = IsoGridSquare.getNew(isoCell, null, isoGridSquare.x, isoGridSquare.y, i);
                    isoCell.ConnectNewSquare(isoGridSquare2, false);
                    isoGridSquare2.EnsureSurroundNotNull();
                    isoGridSquare2.RecalcAllWithNeighbours(true);
                    IsoRoofFixer.sqCache[n++] = isoGridSquare2;
                }
                bl = true;
                continue;
            }
            if (isoGridSquare2.TreatAsSolidFloor()) {
                IsoGridSquare isoGridSquare3;
                PropertyContainer propertyContainer;
                if (isoGridSquare2.getRoom() != null) {
                    if (!bl) break;
                    isoGridSquare2 = IsoGridSquare.getNew(isoCell, null, isoGridSquare.x, isoGridSquare.y, i + 1);
                    isoCell.ConnectNewSquare(isoGridSquare2, false);
                    isoGridSquare2.EnsureSurroundNotNull();
                    isoGridSquare2.RecalcAllWithNeighbours(true);
                    IsoRoofFixer.sqCache[n++] = isoGridSquare2;
                    break;
                }
                IsoObject isoObject = isoGridSquare2.getFloor();
                if (isoObject != null && IsoRoofFixer.isObjectRoof(isoObject) && isoObject.getProperties() != null && !(propertyContainer = isoObject.getProperties()).Is(IsoFlagType.FloorHeightOneThird) && !propertyContainer.Is(IsoFlagType.FloorHeightTwoThirds) && (isoGridSquare3 = isoCell.getGridSquare(isoGridSquare.x, isoGridSquare.y, i - 1)) != null && isoGridSquare3.getRoom() == null) {
                    bl = false;
                    continue;
                }
                return null;
            }
            if (isoGridSquare2.HasStairsBelow()) break;
            bl = false;
            IsoRoofFixer.sqCache[n++] = isoGridSquare2;
        }
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            isoGridSquare2 = sqCache[i];
            if (isoGridSquare2.getRoom() == null && IsoRoofFixer.isInteriorAirSpace(isoGridSquare2.getX(), isoGridSquare2.getY(), isoGridSquare2.getZ())) {
                return null;
            }
            if (IsoRoofFixer.isRoofAt(isoGridSquare2, true)) {
                return isoGridSquare2;
            }
            for (int j = isoGridSquare2.x - 3; j <= isoGridSquare2.x + 3; ++j) {
                for (int k = isoGridSquare2.y - 3; k <= isoGridSquare2.y + 3; ++k) {
                    IsoGridSquare isoGridSquare4;
                    if (j == isoGridSquare2.x && k == isoGridSquare2.y || (isoGridSquare4 = isoCell.getGridSquare(j, k, isoGridSquare2.z)) == null) continue;
                    for (int i2 = 0; i2 < isoGridSquare4.getObjects().size(); ++i2) {
                        IsoObject isoObject = isoGridSquare4.getObjects().get(i2);
                        if (!IsoRoofFixer.isObjectRoofNonFlat(isoObject)) continue;
                        IsoRoofFixer.setRoofTileCache(isoObject);
                        return isoGridSquare2;
                    }
                    IsoGridSquare isoGridSquare5 = isoCell.getGridSquare(isoGridSquare4.x, isoGridSquare4.y, isoGridSquare4.z + 1);
                    if (isoGridSquare5 == null || isoGridSquare5.getObjects().size() <= 0) continue;
                    for (int i3 = 0; i3 < isoGridSquare5.getObjects().size(); ++i3) {
                        IsoObject isoObject = isoGridSquare5.getObjects().get(i3);
                        if (!IsoRoofFixer.isObjectRoofFlatFloor(isoObject)) continue;
                        IsoRoofFixer.setRoofTileCache(isoObject);
                        return isoGridSquare2;
                    }
                }
            }
        }
        return null;
    }

    private static void FixRoofsPerTileAt(IsoGridSquare isoGridSquare) {
        if (isoGridSquare.getZ() > 0 && !isoGridSquare.TreatAsSolidFloor() && isoGridSquare.getRoom() == null && IsoRoofFixer.hasRoomBelow(isoGridSquare) && (IsoRoofFixer.isRoofAt(isoGridSquare, true) || IsoRoofFixer.scanIsRoofAt(isoGridSquare, true))) {
            if (IsoRoofFixer.isRoofTileCacheGlass()) {
                isoGridSquare.addFloor(invisFloor);
            } else {
                isoGridSquare.addFloor("carpentry_02_58");
            }
        }
    }

    private static boolean scanIsRoofAt(IsoGridSquare isoGridSquare, boolean bl) {
        if (isoGridSquare == null) {
            return false;
        }
        for (int i = isoGridSquare.x - 3; i <= isoGridSquare.x + 3; ++i) {
            for (int j = isoGridSquare.y - 3; j <= isoGridSquare.y + 3; ++j) {
                IsoGridSquare isoGridSquare2;
                if (i == isoGridSquare.x && j == isoGridSquare.y || (isoGridSquare2 = isoGridSquare.getCell().getGridSquare(i, j, isoGridSquare.z)) == null || !IsoRoofFixer.isRoofAt(isoGridSquare2, bl)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isRoofAt(IsoGridSquare isoGridSquare, boolean bl) {
        IsoGridSquare isoGridSquare2;
        IsoObject isoObject;
        if (isoGridSquare == null) {
            return false;
        }
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            isoObject = isoGridSquare.getObjects().get(i);
            if (!IsoRoofFixer.isObjectRoofNonFlat(isoObject)) continue;
            IsoRoofFixer.setRoofTileCache(isoObject);
            return true;
        }
        if (bl && (isoGridSquare2 = isoGridSquare.getCell().getGridSquare(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z + 1)) != null && isoGridSquare2.getObjects().size() > 0) {
            for (int i = 0; i < isoGridSquare2.getObjects().size(); ++i) {
                isoObject = isoGridSquare2.getObjects().get(i);
                if (!IsoRoofFixer.isObjectRoofFlatFloor(isoObject)) continue;
                IsoRoofFixer.setRoofTileCache(isoObject);
                return true;
            }
        }
        return false;
    }

    private static boolean isObjectRoof(IsoObject isoObject) {
        return isoObject != null && (isoObject.getType() == IsoObjectType.WestRoofT || isoObject.getType() == IsoObjectType.WestRoofB || isoObject.getType() == IsoObjectType.WestRoofM);
    }

    private static boolean isObjectRoofNonFlat(IsoObject isoObject) {
        PropertyContainer propertyContainer;
        if (IsoRoofFixer.isObjectRoof(isoObject) && (propertyContainer = isoObject.getProperties()) != null) {
            return !propertyContainer.Is(IsoFlagType.solidfloor) || propertyContainer.Is(IsoFlagType.FloorHeightOneThird) || propertyContainer.Is(IsoFlagType.FloorHeightTwoThirds);
        }
        return false;
    }

    private static boolean isObjectRoofFlatFloor(IsoObject isoObject) {
        PropertyContainer propertyContainer;
        if (IsoRoofFixer.isObjectRoof(isoObject) && (propertyContainer = isoObject.getProperties()) != null && propertyContainer.Is(IsoFlagType.solidfloor)) {
            return !propertyContainer.Is(IsoFlagType.FloorHeightOneThird) && !propertyContainer.Is(IsoFlagType.FloorHeightTwoThirds);
        }
        return false;
    }

    private static boolean hasRoomBelow(IsoGridSquare isoGridSquare) {
        return IsoRoofFixer.getRoomBelow(isoGridSquare) != null;
    }

    private static IsoRoom getRoomBelow(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return null;
        }
        for (int i = isoGridSquare.z - 1; i >= 0; --i) {
            IsoGridSquare isoGridSquare2 = isoGridSquare.getCell().getGridSquare(isoGridSquare.x, isoGridSquare.y, i);
            if (isoGridSquare2 == null) continue;
            if (isoGridSquare2.TreatAsSolidFloor() && isoGridSquare2.getRoom() == null) {
                return null;
            }
            if (isoGridSquare2.getRoom() == null) continue;
            return isoGridSquare2.getRoom();
        }
        return null;
    }

    private static boolean isStairsBelow(int n, int n2, int n3) {
        if (n3 == 0) {
            return false;
        }
        IsoCell isoCell = IsoCell.getInstance();
        IsoGridSquare isoGridSquare = isoCell.getGridSquare(n, n2, n3 - 1);
        return isoGridSquare != null && isoGridSquare.HasStairs();
    }

    private static void resetInteriorSpaceCache() {
        for (int i = 0; i < interiorAirSpaces.length; ++i) {
            IsoRoofFixer.interiorAirSpaces[i] = 0;
        }
    }

    private static boolean isInteriorAirSpace(int n, int n2, int n3) {
        if (interiorAirSpaces[n3] != 0) {
            return interiorAirSpaces[n3] == 1;
        }
        ArrayList<IsoGridSquare> arrayList = workingRoom.getSquares();
        boolean bl = false;
        if (arrayList.size() > 0 && n3 > arrayList.get(0).getZ()) {
            block0: for (int i = 0; i < IsoRoofFixer.workingRoom.rects.size(); ++i) {
                int n4;
                RoomDef.RoomRect roomRect = IsoRoofFixer.workingRoom.rects.get(i);
                for (n4 = roomRect.getX(); n4 < roomRect.getX2(); ++n4) {
                    if (!IsoRoofFixer.hasRailing(n4, roomRect.getY(), n3, IsoDirections.N) && !IsoRoofFixer.hasRailing(n4, roomRect.getY2() - 1, n3, IsoDirections.S)) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
                for (n4 = roomRect.getY(); n4 < roomRect.getY2(); ++n4) {
                    if (!IsoRoofFixer.hasRailing(roomRect.getX(), n4, n3, IsoDirections.W) && !IsoRoofFixer.hasRailing(roomRect.getX2() - 1, n4, n3, IsoDirections.E)) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        IsoRoofFixer.interiorAirSpaces[n3] = bl ? 1 : 2;
        return bl;
    }

    private static boolean hasRailing(int n, int n2, int n3, IsoDirections isoDirections) {
        IsoCell isoCell = IsoCell.getInstance();
        IsoGridSquare isoGridSquare = isoCell.getGridSquare(n, n2, n3);
        if (isoGridSquare == null) {
            return false;
        }
        switch (isoDirections) {
            case N: {
                return isoGridSquare.isHoppableTo(isoCell.getGridSquare(n, n2 - 1, n3));
            }
            case E: {
                return isoGridSquare.isHoppableTo(isoCell.getGridSquare(n + 1, n2, n3));
            }
            case S: {
                return isoGridSquare.isHoppableTo(isoCell.getGridSquare(n, n2 + 1, n3));
            }
            case W: {
                return isoGridSquare.isHoppableTo(isoCell.getGridSquare(n - 1, n2, n3));
            }
        }
        return false;
    }

    static {
        roofTilePlaceFloorIndexCache = 0;
        invisFloor = "invisible_01_0";
        roofGroups = new HashMap<Integer, String>();
        placeFloorInfos = new PlaceFloorInfo[10000];
        floorInfoIndex = 0;
        roofGroups.put(0, "carpentry_02_57");
        roofGroups.put(1, "roofs_01_22");
        roofGroups.put(2, "roofs_01_54");
        roofGroups.put(3, "roofs_02_22");
        roofGroups.put(4, invisFloor);
        roofGroups.put(5, "roofs_03_22");
        roofGroups.put(6, "roofs_03_54");
        roofGroups.put(7, "roofs_04_22");
        roofGroups.put(8, "roofs_04_54");
        roofGroups.put(9, "roofs_05_22");
        roofGroups.put(10, "roofs_05_54");
        for (int i = 0; i < placeFloorInfos.length; ++i) {
            IsoRoofFixer.placeFloorInfos[i] = new PlaceFloorInfo();
        }
        sqCache = new IsoGridSquare[8];
        interiorAirSpaces = new int[8];
    }

    private static final class PlaceFloorInfo {
        private IsoGridSquare square;
        private int floorType;

        private PlaceFloorInfo() {
        }

        private void set(IsoGridSquare isoGridSquare, int n) {
            this.square = isoGridSquare;
            this.floorType = n;
        }
    }
}

