/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import zombie.core.Core;
import zombie.inventory.ItemContainer;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.objects.IsoWheelieBin;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;

public class IsoPushableObject
extends IsoMovingObject {
    public int carryCapacity = 100;
    public float emptyWeight = 4.5f;
    public ArrayList<IsoPushableObject> connectList = null;
    public float ox = 0.0f;
    public float oy = 0.0f;

    public IsoPushableObject(IsoCell isoCell) {
        super(isoCell);
        this.getCell().getPushableObjectList().add(this);
    }

    public IsoPushableObject(IsoCell isoCell, int n, int n2, int n3) {
        super(isoCell, true);
        this.getCell().getPushableObjectList().add(this);
    }

    public IsoPushableObject(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoCell, isoGridSquare, isoSprite, true);
        this.setX((float)isoGridSquare.getX() + 0.5f);
        this.setY((float)isoGridSquare.getY() + 0.5f);
        this.setZ(isoGridSquare.getZ());
        this.ox = this.getX();
        this.oy = this.getY();
        this.setNx(this.getX());
        this.setNy(this.getNy());
        this.offsetX = 6 * Core.TileScale;
        this.offsetY = -30 * Core.TileScale;
        this.setWeight(6.0f);
        this.square = isoGridSquare;
        this.setCurrent(isoGridSquare);
        this.getCurrentSquare().getMovingObjects().add(this);
        this.Collidable = true;
        this.solid = true;
        this.shootable = false;
        this.width = 0.5f;
        this.setAlphaAndTarget(0.0f);
        this.getCell().getPushableObjectList().add(this);
    }

    @Override
    public String getObjectName() {
        return "Pushable";
    }

    @Override
    public void update() {
        if (this.connectList != null) {
            Iterator<IsoPushableObject> iterator = this.connectList.iterator();
            float f = 0.0f;
            while (iterator.hasNext()) {
                IsoPushableObject isoPushableObject = iterator.next();
                float f2 = isoPushableObject.getAlpha();
                if (!(f2 > f)) continue;
                f = f2;
            }
            this.setAlphaAndTarget(f);
        }
        super.update();
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        if (!(this instanceof IsoWheelieBin)) {
            this.sprite = IsoSpriteManager.instance.getSprite(byteBuffer.getInt());
        }
        if (byteBuffer.get() == 1) {
            this.container = new ItemContainer();
            this.container.load(byteBuffer, n);
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        if (!(this instanceof IsoWheelieBin)) {
            byteBuffer.putInt(this.sprite.ID);
        }
        if (this.container != null) {
            byteBuffer.put((byte)1);
            this.container.save(byteBuffer);
        } else {
            byteBuffer.put((byte)0);
        }
    }

    @Override
    public float getWeight(float f, float f2) {
        if (this.container == null) {
            return this.emptyWeight;
        }
        float f3 = this.container.getContentsWeight() / (float)this.carryCapacity;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            return this.getWeight() * 8.0f;
        }
        float f4 = this.getWeight() * f3 + this.emptyWeight;
        return f4;
    }

    @Override
    public boolean Serialize() {
        return true;
    }

    @Override
    public void DoCollideNorS() {
        if (this.connectList == null) {
            super.DoCollideNorS();
            return;
        }
        for (IsoPushableObject isoPushableObject : this.connectList) {
            if (isoPushableObject == this) continue;
            if (isoPushableObject.ox < this.ox) {
                isoPushableObject.setNx(this.getNx() - 1.0f);
                isoPushableObject.setX(this.getX() - 1.0f);
            } else if (isoPushableObject.ox > this.ox) {
                isoPushableObject.setNx(this.getNx() + 1.0f);
                isoPushableObject.setX(this.getX() + 1.0f);
            } else {
                isoPushableObject.setNx(this.getNx());
                isoPushableObject.setX(this.getX());
            }
            if (isoPushableObject.oy < this.oy) {
                isoPushableObject.setNy(this.getNy() - 1.0f);
                isoPushableObject.setY(this.getY() - 1.0f);
            } else if (isoPushableObject.oy > this.oy) {
                isoPushableObject.setNy(this.getNy() + 1.0f);
                isoPushableObject.setY(this.getY() + 1.0f);
            } else {
                isoPushableObject.setNy(this.getNy());
                isoPushableObject.setY(this.getY());
            }
            isoPushableObject.setImpulsex(this.getImpulsex());
            isoPushableObject.setImpulsey(this.getImpulsey());
        }
    }

    @Override
    public void DoCollideWorE() {
        if (this.connectList == null) {
            super.DoCollideWorE();
            return;
        }
        for (IsoPushableObject isoPushableObject : this.connectList) {
            if (isoPushableObject == this) continue;
            if (isoPushableObject.ox < this.ox) {
                isoPushableObject.setNx(this.getNx() - 1.0f);
                isoPushableObject.setX(this.getX() - 1.0f);
            } else if (isoPushableObject.ox > this.ox) {
                isoPushableObject.setNx(this.getNx() + 1.0f);
                isoPushableObject.setX(this.getX() + 1.0f);
            } else {
                isoPushableObject.setNx(this.getNx());
                isoPushableObject.setX(this.getX());
            }
            if (isoPushableObject.oy < this.oy) {
                isoPushableObject.setNy(this.getNy() - 1.0f);
                isoPushableObject.setY(this.getY() - 1.0f);
            } else if (isoPushableObject.oy > this.oy) {
                isoPushableObject.setNy(this.getNy() + 1.0f);
                isoPushableObject.setY(this.getY() + 1.0f);
            } else {
                isoPushableObject.setNy(this.getNy());
                isoPushableObject.setY(this.getY());
            }
            isoPushableObject.setImpulsex(this.getImpulsex());
            isoPushableObject.setImpulsey(this.getImpulsey());
        }
    }
}

