/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.textures.Texture;
import zombie.input.Mouse;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoLightSwitch;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoWaveSignal;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;
import zombie.iso.sprite.IsoSprite;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class IsoObjectPicker {
    public static final IsoObjectPicker Instance = new IsoObjectPicker();
    static final ArrayList<ClickObject> choices = new ArrayList();
    static final Vector2 tempo = new Vector2();
    static final Vector2 tempo2 = new Vector2();
    static final Comparator<ClickObject> comp = new Comparator<ClickObject>(){

        @Override
        public int compare(ClickObject clickObject, ClickObject clickObject2) {
            int n;
            int n2 = clickObject.getScore();
            if (n2 > (n = clickObject2.getScore())) {
                return 1;
            }
            if (n2 < n) {
                return -1;
            }
            if (clickObject.tile != null && clickObject.tile.square != null && clickObject2.tile != null && clickObject.tile.square == clickObject2.tile.square) {
                return clickObject.tile.getObjectIndex() - clickObject2.tile.getObjectIndex();
            }
            return 0;
        }
    };
    public ClickObject[] ClickObjectStore = new ClickObject[15000];
    public int count = 0;
    public int counter = 0;
    public int maxcount = 0;
    public final ArrayList<ClickObject> ThisFrame = new ArrayList();
    public boolean dirty = true;
    public float xOffSinceDirty = 0.0f;
    public float yOffSinceDirty = 0.0f;
    public boolean wasDirty = false;
    ClickObject LastPickObject = null;
    float lx = 0.0f;
    float ly = 0.0f;

    public IsoObjectPicker getInstance() {
        return Instance;
    }

    public void Add(int n, int n2, int n3, int n4, IsoGridSquare isoGridSquare, IsoObject isoObject, boolean bl, float f, float f2) {
        boolean bl2;
        if ((float)(n + n3) <= this.lx - 32.0f || (float)n >= this.lx + 32.0f || (float)(n2 + n4) <= this.ly - 32.0f || (float)n2 >= this.ly + 32.0f) {
            return;
        }
        if (this.ThisFrame.size() >= 15000) {
            return;
        }
        if (isoObject.NoPicking) {
            return;
        }
        if (isoObject instanceof IsoSurvivor) {
            bl2 = false;
        }
        if (isoObject instanceof IsoDoor) {
            bl2 = false;
        }
        if (n > Core.getInstance().getOffscreenWidth(0)) {
            return;
        }
        if (n2 > Core.getInstance().getOffscreenHeight(0)) {
            return;
        }
        if (n + n3 < 0) {
            return;
        }
        if (n2 + n4 < 0) {
            return;
        }
        ClickObject clickObject = this.ClickObjectStore[this.ThisFrame.size()];
        this.ThisFrame.add(clickObject);
        this.count = this.ThisFrame.size();
        clickObject.x = n;
        clickObject.y = n2;
        clickObject.width = n3;
        clickObject.height = n4;
        clickObject.square = isoGridSquare;
        clickObject.tile = isoObject;
        clickObject.flip = bl;
        clickObject.scaleX = f;
        clickObject.scaleY = f2;
        if (clickObject.tile instanceof IsoGameCharacter) {
            clickObject.flip = false;
        }
        if (this.count > this.maxcount) {
            this.maxcount = this.count;
        }
    }

    public void Init() {
        this.ThisFrame.clear();
        this.LastPickObject = null;
        for (int i = 0; i < 15000; ++i) {
            this.ClickObjectStore[i] = new ClickObject();
        }
    }

    public ClickObject ContextPick(int n, int n2) {
        ClickObject clickObject;
        int n3;
        float f = (float)n * Core.getInstance().getZoom(0);
        float f2 = (float)n2 * Core.getInstance().getZoom(0);
        choices.clear();
        ++this.counter;
        for (n3 = this.ThisFrame.size() - 1; n3 >= 0; --n3) {
            clickObject = this.ThisFrame.get(n3);
            if (clickObject.tile instanceof IsoPlayer && clickObject.tile == IsoPlayer.players[0] || clickObject.tile.sprite != null && (clickObject.tile.getTargetAlpha(0) == 0.0f || (clickObject.tile.sprite.Properties.Is(IsoFlagType.cutW) || clickObject.tile.sprite.Properties.Is(IsoFlagType.cutN)) && !(clickObject.tile instanceof IsoWindow) && clickObject.tile.getTargetAlpha(0) < 1.0f)) continue;
            if (clickObject.tile == null || clickObject.tile.sprite != null) {
                // empty if block
            }
            if (!(f > (float)clickObject.x) || !(f2 > (float)clickObject.y) || !(f <= (float)(clickObject.x + clickObject.width)) || !(f2 <= (float)(clickObject.y + clickObject.height))) continue;
            if (clickObject.tile instanceof IsoPlayer) {
                if (clickObject.tile.sprite == null || clickObject.tile.sprite.def == null || clickObject.tile.sprite.CurrentAnim == null || clickObject.tile.sprite.CurrentAnim.Frames == null || clickObject.tile.sprite.def.Frame < 0.0f || clickObject.tile.sprite.def.Frame >= (float)clickObject.tile.sprite.CurrentAnim.Frames.size()) continue;
                int n4 = (int)(f - (float)clickObject.x);
                int n5 = (int)(f2 - (float)clickObject.y);
                Texture texture = clickObject.tile.sprite.CurrentAnim.Frames.get((int)((int)clickObject.tile.sprite.def.Frame)).directions[clickObject.tile.dir.index()];
                int n6 = Core.TileScale;
                if (clickObject.flip) {
                    n5 = (int)((float)n5 - texture.offsetY);
                    n4 = texture.getWidth() - n5;
                } else {
                    n4 = (int)((float)n4 - texture.offsetX * (float)n6);
                    n5 = (int)((float)n5 - texture.offsetY * (float)n6);
                }
                if (n4 >= 0 && n5 >= 0 && n4 <= texture.getWidth() * n6 && n5 <= texture.getHeight() * n6) {
                    clickObject.lx = (int)f - clickObject.x;
                    clickObject.ly = (int)f2 - clickObject.y;
                    this.LastPickObject = clickObject;
                    choices.clear();
                    choices.add(clickObject);
                    break;
                }
            }
            if (clickObject.scaleX != 1.0f || clickObject.scaleY != 1.0f) {
                float f3 = (float)clickObject.x + (f - (float)clickObject.x) / clickObject.scaleX;
                float f4 = (float)clickObject.y + (f2 - (float)clickObject.y) / clickObject.scaleY;
                if (!clickObject.tile.isMaskClicked((int)(f3 - (float)clickObject.x), (int)(f4 - (float)clickObject.y), clickObject.flip)) continue;
                if (clickObject.tile.rerouteMask != null) {
                    clickObject.tile = clickObject.tile.rerouteMask;
                }
                clickObject.lx = (int)f - clickObject.x;
                clickObject.ly = (int)f2 - clickObject.y;
                this.LastPickObject = clickObject;
                choices.add(clickObject);
                continue;
            }
            if (!clickObject.tile.isMaskClicked((int)(f - (float)clickObject.x), (int)(f2 - (float)clickObject.y), clickObject.flip)) continue;
            if (clickObject.tile.rerouteMask != null) {
                clickObject.tile = clickObject.tile.rerouteMask;
            }
            clickObject.lx = (int)f - clickObject.x;
            clickObject.ly = (int)f2 - clickObject.y;
            this.LastPickObject = clickObject;
            choices.add(clickObject);
        }
        if (choices.isEmpty()) {
            return null;
        }
        for (n3 = 0; n3 < choices.size(); ++n3) {
            clickObject = choices.get(n3);
            clickObject.score = clickObject.calculateScore();
        }
        try {
            Collections.sort(choices, comp);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (Core.bDebug) {
                ExceptionLogger.logException(illegalArgumentException);
            }
            return null;
        }
        ClickObject clickObject2 = choices.get(choices.size() - 1);
        return clickObject2;
    }

    public ClickObject Pick(int n, int n2) {
        float f = n;
        float f2 = n2;
        float f3 = Core.getInstance().getScreenWidth();
        float f4 = Core.getInstance().getScreenHeight();
        float f5 = f3 * Core.getInstance().getZoom(0);
        float f6 = f4 * Core.getInstance().getZoom(0);
        float f7 = Core.getInstance().getOffscreenWidth(0);
        float f8 = Core.getInstance().getOffscreenHeight(0);
        float f9 = f7 / f5;
        float f10 = f8 / f6;
        f -= f3 / 2.0f;
        f2 -= f4 / 2.0f;
        f /= f9;
        f2 /= f10;
        f += f3 / 2.0f;
        f2 += f4 / 2.0f;
        ++this.counter;
        for (int i = this.ThisFrame.size() - 1; i >= 0; --i) {
            ClickObject clickObject = this.ThisFrame.get(i);
            if (clickObject.tile.square != null) {
                // empty if block
            }
            if (clickObject.tile instanceof IsoPlayer || clickObject.tile.sprite != null && clickObject.tile.getTargetAlpha(0) == 0.0f) continue;
            if (clickObject.tile == null || clickObject.tile.sprite != null) {
                // empty if block
            }
            if (!(f > (float)clickObject.x) || !(f2 > (float)clickObject.y) || !(f <= (float)(clickObject.x + clickObject.width)) || !(f2 <= (float)(clickObject.y + clickObject.height))) continue;
            if (clickObject.tile instanceof IsoSurvivor) {
                boolean bl = false;
                continue;
            }
            if (!clickObject.tile.isMaskClicked((int)(f - (float)clickObject.x), (int)(f2 - (float)clickObject.y), clickObject.flip)) continue;
            if (clickObject.tile.rerouteMask != null) {
                clickObject.tile = clickObject.tile.rerouteMask;
            }
            clickObject.lx = (int)f - clickObject.x;
            clickObject.ly = (int)f2 - clickObject.y;
            this.LastPickObject = clickObject;
            return clickObject;
        }
        return null;
    }

    public void StartRender() {
        float f = Mouse.getX();
        float f2 = Mouse.getY();
        if (f != this.lx || f2 != this.ly) {
            this.dirty = true;
        }
        this.lx = f;
        this.ly = f2;
        if (this.dirty) {
            this.ThisFrame.clear();
            this.count = 0;
            this.wasDirty = true;
            this.dirty = false;
            this.xOffSinceDirty = 0.0f;
            this.yOffSinceDirty = 0.0f;
        } else {
            this.wasDirty = false;
        }
    }

    public IsoMovingObject PickTarget(int n, int n2) {
        float f = n;
        float f2 = n2;
        float f3 = Core.getInstance().getScreenWidth();
        float f4 = Core.getInstance().getScreenHeight();
        float f5 = f3 * Core.getInstance().getZoom(0);
        float f6 = f4 * Core.getInstance().getZoom(0);
        float f7 = Core.getInstance().getOffscreenWidth(0);
        float f8 = Core.getInstance().getOffscreenHeight(0);
        float f9 = f7 / f5;
        float f10 = f8 / f6;
        f -= f3 / 2.0f;
        f2 -= f4 / 2.0f;
        f /= f9;
        f2 /= f10;
        f += f3 / 2.0f;
        f2 += f4 / 2.0f;
        ++this.counter;
        for (int i = this.ThisFrame.size() - 1; i >= 0; --i) {
            ClickObject clickObject = this.ThisFrame.get(i);
            if (clickObject.tile.square != null) {
                // empty if block
            }
            if (clickObject.tile == IsoPlayer.getInstance() || clickObject.tile.sprite != null && clickObject.tile.getTargetAlpha() == 0.0f) continue;
            if (clickObject.tile == null || clickObject.tile.sprite != null) {
                // empty if block
            }
            if (!(f > (float)clickObject.x) || !(f2 > (float)clickObject.y) || !(f <= (float)(clickObject.x + clickObject.width)) || !(f2 <= (float)(clickObject.y + clickObject.height)) || !(clickObject.tile instanceof IsoMovingObject) || !clickObject.tile.isMaskClicked((int)(f - (float)clickObject.x), (int)(f2 - (float)clickObject.y), clickObject.flip)) continue;
            if (clickObject.tile.rerouteMask != null) {
                // empty if block
            }
            clickObject.lx = (int)(f - (float)clickObject.x);
            clickObject.ly = (int)(f2 - (float)clickObject.y);
            this.LastPickObject = clickObject;
            return (IsoMovingObject)clickObject.tile;
        }
        return null;
    }

    public IsoObject PickDoor(int n, int n2, boolean bl) {
        float f = (float)n * Core.getInstance().getZoom(0);
        float f2 = (float)n2 * Core.getInstance().getZoom(0);
        int n3 = IsoPlayer.getPlayerIndex();
        for (int i = this.ThisFrame.size() - 1; i >= 0; --i) {
            int n4;
            int n5;
            ClickObject clickObject = this.ThisFrame.get(i);
            if (!(clickObject.tile instanceof IsoDoor) || clickObject.tile.getTargetAlpha(n3) == 0.0f || bl != clickObject.tile.getTargetAlpha(n3) < 1.0f || !(f >= (float)clickObject.x) || !(f2 >= (float)clickObject.y) || !(f < (float)(clickObject.x + clickObject.width)) || !(f2 < (float)(clickObject.y + clickObject.height)) || !clickObject.tile.isMaskClicked(n5 = (int)(f - (float)clickObject.x), n4 = (int)(f2 - (float)clickObject.y), clickObject.flip)) continue;
            return clickObject.tile;
        }
        return null;
    }

    public IsoObject PickWindow(int n, int n2) {
        float f = (float)n * Core.getInstance().getZoom(0);
        float f2 = (float)n2 * Core.getInstance().getZoom(0);
        for (int i = this.ThisFrame.size() - 1; i >= 0; --i) {
            int n3;
            ClickObject clickObject = this.ThisFrame.get(i);
            if (!(clickObject.tile instanceof IsoWindow) && !(clickObject.tile instanceof IsoCurtain) || clickObject.tile.sprite != null && clickObject.tile.getTargetAlpha() == 0.0f || !(f >= (float)clickObject.x) || !(f2 >= (float)clickObject.y) || !(f < (float)(clickObject.x + clickObject.width)) || !(f2 < (float)(clickObject.y + clickObject.height))) continue;
            int n4 = (int)(f - (float)clickObject.x);
            int n5 = (int)(f2 - (float)clickObject.y);
            if (clickObject.tile.isMaskClicked(n4, n5, clickObject.flip)) {
                return clickObject.tile;
            }
            if (!(clickObject.tile instanceof IsoWindow)) continue;
            boolean bl = false;
            boolean bl2 = false;
            for (n3 = n5; n3 >= 0; --n3) {
                if (!clickObject.tile.isMaskClicked(n4, n3)) continue;
                bl = true;
                break;
            }
            for (n3 = n5; n3 < clickObject.height; ++n3) {
                if (!clickObject.tile.isMaskClicked(n4, n3)) continue;
                bl2 = true;
                break;
            }
            if (!bl || !bl2) continue;
            return clickObject.tile;
        }
        return null;
    }

    public IsoObject PickWindowFrame(int n, int n2) {
        float f = (float)n * Core.getInstance().getZoom(0);
        float f2 = (float)n2 * Core.getInstance().getZoom(0);
        for (int i = this.ThisFrame.size() - 1; i >= 0; --i) {
            int n3;
            ClickObject clickObject = this.ThisFrame.get(i);
            if (!IsoWindowFrame.isWindowFrame(clickObject.tile) || clickObject.tile.sprite != null && clickObject.tile.getTargetAlpha() == 0.0f || !(f >= (float)clickObject.x) || !(f2 >= (float)clickObject.y) || !(f < (float)(clickObject.x + clickObject.width)) || !(f2 < (float)(clickObject.y + clickObject.height))) continue;
            int n4 = (int)(f - (float)clickObject.x);
            int n5 = (int)(f2 - (float)clickObject.y);
            if (clickObject.tile.isMaskClicked(n4, n5, clickObject.flip)) {
                return clickObject.tile;
            }
            boolean bl = false;
            boolean bl2 = false;
            for (n3 = n5; n3 >= 0; --n3) {
                if (!clickObject.tile.isMaskClicked(n4, n3)) continue;
                bl = true;
                break;
            }
            for (n3 = n5; n3 < clickObject.height; ++n3) {
                if (!clickObject.tile.isMaskClicked(n4, n3)) continue;
                bl2 = true;
                break;
            }
            if (!bl || !bl2) continue;
            return clickObject.tile;
        }
        return null;
    }

    public IsoObject PickThumpable(int n, int n2) {
        float f = (float)n * Core.getInstance().getZoom(0);
        float f2 = (float)n2 * Core.getInstance().getZoom(0);
        for (int i = this.ThisFrame.size() - 1; i >= 0; --i) {
            int n3;
            int n4;
            ClickObject clickObject = this.ThisFrame.get(i);
            if (!(clickObject.tile instanceof IsoThumpable)) continue;
            IsoThumpable isoThumpable = (IsoThumpable)clickObject.tile;
            if (clickObject.tile.sprite != null && clickObject.tile.getTargetAlpha() == 0.0f || !(f >= (float)clickObject.x) || !(f2 >= (float)clickObject.y) || !(f < (float)(clickObject.x + clickObject.width)) || !(f2 < (float)(clickObject.y + clickObject.height)) || !clickObject.tile.isMaskClicked(n4 = (int)(f - (float)clickObject.x), n3 = (int)(f2 - (float)clickObject.y), clickObject.flip)) continue;
            return clickObject.tile;
        }
        return null;
    }

    public IsoObject PickHoppable(int n, int n2) {
        float f = (float)n * Core.getInstance().getZoom(0);
        float f2 = (float)n2 * Core.getInstance().getZoom(0);
        for (int i = this.ThisFrame.size() - 1; i >= 0; --i) {
            int n3;
            int n4;
            ClickObject clickObject = this.ThisFrame.get(i);
            if (!clickObject.tile.isHoppable() || clickObject.tile.sprite != null && clickObject.tile.getTargetAlpha() == 0.0f || !(f >= (float)clickObject.x) || !(f2 >= (float)clickObject.y) || !(f < (float)(clickObject.x + clickObject.width)) || !(f2 < (float)(clickObject.y + clickObject.height)) || !clickObject.tile.isMaskClicked(n4 = (int)(f - (float)clickObject.x), n3 = (int)(f2 - (float)clickObject.y), clickObject.flip)) continue;
            return clickObject.tile;
        }
        return null;
    }

    public IsoObject PickCorpse(int n, int n2) {
        float f = (float)n * Core.getInstance().getZoom(0);
        float f2 = (float)n2 * Core.getInstance().getZoom(0);
        for (int i = this.ThisFrame.size() - 1; i >= 0; --i) {
            ClickObject clickObject = this.ThisFrame.get(i);
            if (!(f >= (float)clickObject.x) || !(f2 >= (float)clickObject.y) || !(f < (float)(clickObject.x + clickObject.width)) || !(f2 < (float)(clickObject.y + clickObject.height)) || clickObject.tile.getTargetAlpha() < 1.0f) continue;
            if (clickObject.tile.isMaskClicked((int)(f - (float)clickObject.x), (int)(f2 - (float)clickObject.y), clickObject.flip) && !(clickObject.tile instanceof IsoWindow)) {
                return null;
            }
            if (!(clickObject.tile instanceof IsoDeadBody) || !((IsoDeadBody)clickObject.tile).isMouseOver(f, f2)) continue;
            return clickObject.tile;
        }
        return null;
    }

    public IsoObject PickTree(int n, int n2) {
        float f = (float)n * Core.getInstance().getZoom(0);
        float f2 = (float)n2 * Core.getInstance().getZoom(0);
        for (int i = this.ThisFrame.size() - 1; i >= 0; --i) {
            int n3;
            int n4;
            ClickObject clickObject = this.ThisFrame.get(i);
            if (!(clickObject.tile instanceof IsoTree) || clickObject.tile.sprite != null && clickObject.tile.getTargetAlpha() == 0.0f || !(f >= (float)clickObject.x) || !(f2 >= (float)clickObject.y) || !(f < (float)(clickObject.x + clickObject.width)) || !(f2 < (float)(clickObject.y + clickObject.height)) || !clickObject.tile.isMaskClicked(n4 = (int)(f - (float)clickObject.x), n3 = (int)(f2 - (float)clickObject.y), clickObject.flip)) continue;
            return clickObject.tile;
        }
        return null;
    }

    public BaseVehicle PickVehicle(int n, int n2) {
        float f = IsoUtils.XToIso(n, n2, 0.0f);
        float f2 = IsoUtils.YToIso(n, n2, 0.0f);
        for (int i = 0; i < IsoWorld.instance.CurrentCell.getVehicles().size(); ++i) {
            BaseVehicle baseVehicle = IsoWorld.instance.CurrentCell.getVehicles().get(i);
            if (!baseVehicle.isInBounds(f, f2)) continue;
            return baseVehicle;
        }
        return null;
    }

    public static final class ClickObject {
        public int height;
        public IsoGridSquare square;
        public IsoObject tile;
        public int width;
        public int x;
        public int y;
        public int lx;
        public int ly;
        public float scaleX;
        public float scaleY;
        private boolean flip;
        private int score;

        public int calculateScore() {
            float f = 1.0f;
            IsoPlayer isoPlayer = IsoPlayer.getInstance();
            IsoGridSquare isoGridSquare = isoPlayer.getCurrentSquare();
            IsoObjectPicker.tempo.x = (float)this.square.getX() + 0.5f;
            IsoObjectPicker.tempo.y = (float)this.square.getY() + 0.5f;
            IsoObjectPicker.tempo.x -= isoPlayer.getX();
            IsoObjectPicker.tempo.y -= isoPlayer.getY();
            tempo.normalize();
            Vector2 vector22 = isoPlayer.getVectorFromDirection(tempo2);
            float f2 = vector22.dot(tempo);
            f += Math.abs(f2 * 4.0f);
            IsoGridSquare isoGridSquare2 = this.square;
            IsoObject isoObject = this.tile;
            IsoSprite isoSprite = isoObject.sprite;
            IsoDoor isoDoor = Type.tryCastTo(isoObject, IsoDoor.class);
            IsoThumpable isoThumpable = Type.tryCastTo(isoObject, IsoThumpable.class);
            if (isoDoor != null || isoThumpable != null && isoThumpable.isDoor()) {
                f += 6.0f;
                if (isoDoor != null && isoDoor.isAdjacentToSquare(isoGridSquare) || isoThumpable != null && isoThumpable.isAdjacentToSquare(isoGridSquare)) {
                    f += 1.0f;
                }
                if (isoPlayer.getZ() > (float)isoGridSquare2.getZ()) {
                    f -= 1000.0f;
                }
            } else if (isoObject instanceof IsoWindow) {
                f += 4.0f;
                if (isoPlayer.getZ() > (float)isoGridSquare2.getZ()) {
                    f -= 1000.0f;
                }
            } else {
                f = isoGridSquare != null && isoGridSquare2.getRoom() == isoGridSquare.getRoom() ? (f += 1.0f) : (f -= 100000.0f);
                if (isoPlayer.getZ() > (float)isoGridSquare2.getZ()) {
                    f -= 1000.0f;
                }
                if (isoObject instanceof IsoPlayer) {
                    f -= 100000.0f;
                } else if (isoObject instanceof IsoThumpable && isoObject.getTargetAlpha() < 0.99f && (isoObject.getTargetAlpha() < 0.5f || isoObject.getContainer() == null)) {
                    f -= 100000.0f;
                }
                if (isoObject instanceof IsoCurtain) {
                    f += 3.0f;
                } else if (isoObject instanceof IsoLightSwitch) {
                    f += 20.0f;
                } else if (isoSprite.Properties.Is(IsoFlagType.bed)) {
                    f += 2.0f;
                } else if (isoObject.container != null) {
                    f += 10.0f;
                } else if (isoObject instanceof IsoWaveSignal) {
                    f += 20.0f;
                } else if (isoThumpable != null && isoThumpable.getLightSource() != null) {
                    f += 3.0f;
                } else if (isoSprite.Properties.Is(IsoFlagType.waterPiped)) {
                    f += 3.0f;
                } else if (isoSprite.Properties.Is(IsoFlagType.solidfloor)) {
                    f -= 100.0f;
                } else if (isoSprite.getType() == IsoObjectType.WestRoofB) {
                    f -= 100.0f;
                } else if (isoSprite.getType() == IsoObjectType.WestRoofM) {
                    f -= 100.0f;
                } else if (isoSprite.getType() == IsoObjectType.WestRoofT) {
                    f -= 100.0f;
                } else if (isoSprite.Properties.Is(IsoFlagType.cutW) || isoSprite.Properties.Is(IsoFlagType.cutN)) {
                    f -= 2.0f;
                }
            }
            float f3 = IsoUtils.DistanceManhatten((float)isoGridSquare2.getX() + 0.5f, (float)isoGridSquare2.getY() + 0.5f, isoPlayer.getX(), isoPlayer.getY());
            return (int)(f -= f3 / 2.0f);
        }

        public int getScore() {
            return this.score;
        }
    }
}

