/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import fmod.fmod.FMODManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.lwjgl.opengl.ARBShaderObjects;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.IndieGL;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.SystemDisabler;
import zombie.WorldSoundManager;
import zombie.ai.states.ThumpState;
import zombie.audio.BaseSoundEmitter;
import zombie.audio.ObjectAmbientEmitters;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoLivingCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.opengl.RenderSettings;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.opengl.ShaderProgram;
import zombie.core.properties.PropertyContainer;
import zombie.core.raknet.UdpConnection;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.core.utils.Bits;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemPickerJava;
import zombie.inventory.types.HandWeapon;
import zombie.iso.BrokenFences;
import zombie.iso.CellLoader;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoPhysicsObject;
import zombie.iso.IsoPushableObject;
import zombie.iso.IsoWallBloodSplat;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.objects.BSFurnace;
import zombie.iso.objects.IsoBarbecue;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoBrokenGlass;
import zombie.iso.objects.IsoCarBatteryCharger;
import zombie.iso.objects.IsoClothingDryer;
import zombie.iso.objects.IsoClothingWasher;
import zombie.iso.objects.IsoCombinationWasherDryer;
import zombie.iso.objects.IsoCompost;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoFire;
import zombie.iso.objects.IsoFireplace;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.objects.IsoJukebox;
import zombie.iso.objects.IsoLightSwitch;
import zombie.iso.objects.IsoMannequin;
import zombie.iso.objects.IsoMolotovCocktail;
import zombie.iso.objects.IsoRadio;
import zombie.iso.objects.IsoStackedWasherDryer;
import zombie.iso.objects.IsoStove;
import zombie.iso.objects.IsoTelevision;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoTrap;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoWheelieBin;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.objects.IsoZombieGiblets;
import zombie.iso.objects.ObjectRenderEffects;
import zombie.iso.objects.RenderEffectType;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteGrid;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.iso.sprite.shapers.FloorShaper;
import zombie.iso.sprite.shapers.WallShaper;
import zombie.iso.sprite.shapers.WallShaperN;
import zombie.iso.sprite.shapers.WallShaperW;
import zombie.iso.sprite.shapers.WallShaperWhole;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.ServerOptions;
import zombie.spnetwork.SinglePlayerServer;
import zombie.ui.ObjectTooltip;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.io.BitHeader;
import zombie.util.io.BitHeaderRead;
import zombie.util.io.BitHeaderWrite;
import zombie.util.list.PZArrayList;
import zombie.vehicles.BaseVehicle;
import zombie.world.WorldDictionary;

public class IsoObject
implements Serializable,
Thumpable {
    public static final byte OBF_Highlighted = 1;
    public static final byte OBF_HighlightRenderOnce = 2;
    public static final byte OBF_Blink = 4;
    public static final int MAX_WALL_SPLATS = 32;
    private static final String PropMoveWithWind = "MoveWithWind";
    public static IsoObject lastRendered = null;
    public static IsoObject lastRenderedRendered = null;
    private static final ColorInfo stCol = new ColorInfo();
    public static float rmod;
    public static float gmod;
    public static float bmod;
    public static boolean LowLightingQualityHack;
    private static int DefaultCondition;
    private static final ColorInfo stCol2;
    private static final ColorInfo colFxMask;
    public byte highlightFlags;
    public int keyId = -1;
    public BaseSoundEmitter emitter;
    public float sheetRopeHealth = 100.0f;
    public boolean sheetRope = false;
    public boolean bNeverDoneAlpha = true;
    public boolean bAlphaForced = false;
    public ArrayList<IsoSpriteInstance> AttachedAnimSprite;
    public ArrayList<IsoWallBloodSplat> wallBloodSplats;
    public ItemContainer container = null;
    public IsoDirections dir = IsoDirections.N;
    public short Damage = (short)100;
    public float partialThumpDmg = 0.0f;
    public boolean NoPicking = false;
    public float offsetX = 32 * Core.TileScale;
    public float offsetY = 96 * Core.TileScale;
    public boolean OutlineOnMouseover = false;
    public IsoObject rerouteMask = null;
    public IsoSprite sprite = null;
    public IsoSprite overlaySprite = null;
    public ColorInfo overlaySpriteColor = null;
    public IsoGridSquare square;
    private final float[] alpha = new float[4];
    private final float[] targetAlpha = new float[4];
    public IsoObject rerouteCollide = null;
    public KahluaTable table = null;
    public String name = null;
    public float tintr = 1.0f;
    public float tintg = 1.0f;
    public float tintb = 1.0f;
    public String spriteName = null;
    public float sx;
    public float sy;
    public boolean doNotSync = false;
    protected ObjectRenderEffects windRenderEffects;
    protected ObjectRenderEffects objectRenderEffects;
    protected IsoObject externalWaterSource = null;
    protected boolean usesExternalWaterSource = false;
    ArrayList<IsoObject> Children;
    String tile;
    private boolean specialTooltip = false;
    private ColorInfo highlightColor = new ColorInfo(0.9f, 1.0f, 0.0f, 1.0f);
    private ArrayList<ItemContainer> secondaryContainers;
    private ColorInfo customColor = null;
    private float renderYOffset = 0.0f;
    protected byte isOutlineHighlight = 0;
    protected byte isOutlineHlAttached = 0;
    protected byte isOutlineHlBlink = 0;
    protected final int[] outlineHighlightCol = new int[4];
    private float outlineThickness = 0.15f;
    protected boolean bMovedThumpable = false;
    private static final Map<Byte, IsoObjectFactory> byteToObjectMap;
    private static final Map<Integer, IsoObjectFactory> hashCodeToObjectMap;
    private static final Map<String, IsoObjectFactory> nameToObjectMap;
    private static IsoObjectFactory factoryIsoObject;
    private static IsoObjectFactory factoryVehicle;

    public IsoObject(IsoCell isoCell) {
        this();
    }

    public IsoObject() {
        for (int i = 0; i < 4; ++i) {
            this.setAlphaAndTarget(i, 1.0f);
            this.outlineHighlightCol[i] = -1;
        }
    }

    public IsoObject(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        this();
        this.sprite = isoSprite;
        this.square = isoGridSquare;
    }

    public IsoObject(IsoCell isoCell, IsoGridSquare isoGridSquare, String string) {
        this();
        this.sprite = IsoSpriteManager.instance.getSprite(string);
        this.square = isoGridSquare;
        this.tile = string;
    }

    public IsoObject(IsoGridSquare isoGridSquare, String string, String string2) {
        this();
        this.sprite = IsoSpriteManager.instance.getSprite(string);
        this.square = isoGridSquare;
        this.tile = string;
        this.spriteName = string;
        this.name = string2;
    }

    public IsoObject(IsoGridSquare isoGridSquare, String string, String string2, boolean bl) {
        this();
        if (bl) {
            this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
            this.sprite.LoadFramesNoDirPageSimple(string);
        } else {
            this.sprite = IsoSpriteManager.instance.NamedMap.get(string);
        }
        this.tile = string;
        this.square = isoGridSquare;
        this.name = string2;
    }

    public boolean isFloor() {
        if (this.getProperties() != null) {
            return this.getProperties().Is(IsoFlagType.solidfloor);
        }
        return false;
    }

    public IsoObject(IsoGridSquare isoGridSquare, String string, boolean bl) {
        this();
        if (bl) {
            this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
            this.sprite.LoadFramesNoDirPageSimple(string);
        } else {
            this.sprite = IsoSpriteManager.instance.NamedMap.get(string);
        }
        this.tile = string;
        this.square = isoGridSquare;
    }

    public IsoObject(IsoGridSquare isoGridSquare, String string) {
        this();
        this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.sprite.LoadFramesNoDirPageSimple(string);
        this.square = isoGridSquare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IsoObject getNew(IsoGridSquare isoGridSquare, String string, String string2, boolean bl) {
        IsoObject isoObject = null;
        ArrayDeque<IsoObject> arrayDeque = CellLoader.isoObjectCache;
        synchronized (arrayDeque) {
            if (CellLoader.isoObjectCache.isEmpty()) {
                isoObject = new IsoObject(isoGridSquare, string, string2, bl);
            } else {
                isoObject = CellLoader.isoObjectCache.pop();
                isoObject.reset();
                isoObject.tile = string;
            }
        }
        if (bl) {
            isoObject.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
            isoObject.sprite.LoadFramesNoDirPageSimple(isoObject.tile);
        } else {
            isoObject.sprite = IsoSpriteManager.instance.NamedMap.get(isoObject.tile);
        }
        isoObject.square = isoGridSquare;
        isoObject.name = string2;
        return isoObject;
    }

    public static IsoObject getLastRendered() {
        return lastRendered;
    }

    public static void setLastRendered(IsoObject isoObject) {
        lastRendered = isoObject;
    }

    public static IsoObject getLastRenderedRendered() {
        return lastRenderedRendered;
    }

    public static void setLastRenderedRendered(IsoObject isoObject) {
        lastRenderedRendered = isoObject;
    }

    public static void setDefaultCondition(int n) {
        DefaultCondition = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IsoObject getNew() {
        ArrayDeque<IsoObject> arrayDeque = CellLoader.isoObjectCache;
        synchronized (arrayDeque) {
            if (CellLoader.isoObjectCache.isEmpty()) {
                return new IsoObject();
            }
            return CellLoader.isoObjectCache.pop();
        }
    }

    private static IsoObjectFactory addIsoObjectFactory(IsoObjectFactory isoObjectFactory) {
        if (byteToObjectMap.containsKey(isoObjectFactory.classID)) {
            throw new RuntimeException("Class id already exists, " + isoObjectFactory.objectName);
        }
        byteToObjectMap.put(isoObjectFactory.classID, isoObjectFactory);
        if (hashCodeToObjectMap.containsKey(isoObjectFactory.hashCode)) {
            throw new RuntimeException("Hashcode already exists, " + isoObjectFactory.objectName);
        }
        hashCodeToObjectMap.put(isoObjectFactory.hashCode, isoObjectFactory);
        if (nameToObjectMap.containsKey(isoObjectFactory.objectName)) {
            throw new RuntimeException("ObjectName already exists, " + isoObjectFactory.objectName);
        }
        nameToObjectMap.put(isoObjectFactory.objectName, isoObjectFactory);
        return isoObjectFactory;
    }

    public static IsoObjectFactory getFactoryVehicle() {
        return factoryVehicle;
    }

    private static void initFactory() {
        factoryIsoObject = IsoObject.addIsoObjectFactory(new IsoObjectFactory(0, "IsoObject"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                IsoObject isoObject = IsoObject.getNew();
                isoObject.sx = 0.0f;
                return isoObject;
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(1, "Player"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoPlayer(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(2, "Survivor"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoSurvivor(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(3, "Zombie"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoZombie(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(4, "Pushable"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoPushableObject(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(5, "WheelieBin"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoWheelieBin(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(6, "WorldInventoryItem"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoWorldInventoryObject(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(7, "Jukebox"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoJukebox(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(8, "Curtain"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoCurtain(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(9, "Radio"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoRadio(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(10, "Television"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoTelevision(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(11, "DeadBody"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoDeadBody(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(12, "Barbecue"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoBarbecue(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(13, "ClothingDryer"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoClothingDryer(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(14, "ClothingWasher"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoClothingWasher(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(15, "Fireplace"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoFireplace(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(16, "Stove"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoStove(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(17, "Door"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoDoor(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(18, "Thumpable"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoThumpable(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(19, "IsoTrap"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoTrap(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(20, "IsoBrokenGlass"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoBrokenGlass(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(21, "IsoCarBatteryCharger"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoCarBatteryCharger(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(22, "IsoGenerator"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoGenerator(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(23, "IsoCompost"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoCompost(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(24, "Mannequin"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoMannequin(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(25, "StoneFurnace"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new BSFurnace(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(26, "Window"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoWindow(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(27, "Barricade"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoBarricade(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(28, "Tree"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return IsoTree.getNew();
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(29, "LightSwitch"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoLightSwitch(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(30, "ZombieGiblets"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoZombieGiblets(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(31, "MolotovCocktail"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoMolotovCocktail(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(32, "Fire"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoFire(isoCell);
            }
        });
        factoryVehicle = IsoObject.addIsoObjectFactory(new IsoObjectFactory(33, "Vehicle"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new BaseVehicle(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(34, "CombinationWasherDryer"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoCombinationWasherDryer(isoCell);
            }
        });
        IsoObject.addIsoObjectFactory(new IsoObjectFactory(35, "StackedWasherDryer"){

            @Override
            protected IsoObject InstantiateObject(IsoCell isoCell) {
                return new IsoStackedWasherDryer(isoCell);
            }
        });
    }

    public static byte factoryGetClassID(String string) {
        IsoObjectFactory isoObjectFactory = hashCodeToObjectMap.get(string.hashCode());
        if (isoObjectFactory != null) {
            return isoObjectFactory.classID;
        }
        return IsoObject.factoryIsoObject.classID;
    }

    public static IsoObject factoryFromFileInput(IsoCell isoCell, byte by) {
        IsoObjectFactory isoObjectFactory = byteToObjectMap.get(by);
        if (!(isoObjectFactory == null || isoObjectFactory.objectName.equals("Vehicle") && GameClient.bClient)) {
            return isoObjectFactory.InstantiateObject(isoCell);
        }
        if (isoObjectFactory == null && Core.bDebug) {
            throw new RuntimeException("Cannot get IsoObject from classID: " + by);
        }
        IsoObject isoObject = new IsoObject(isoCell);
        return isoObject;
    }

    @Deprecated
    public static IsoObject factoryFromFileInput_OLD(IsoCell isoCell, int n) {
        if (n == "IsoObject".hashCode()) {
            IsoObject isoObject = IsoObject.getNew();
            isoObject.sx = 0.0f;
            return isoObject;
        }
        if (n == "Player".hashCode()) {
            return new IsoPlayer(isoCell);
        }
        if (n == "Survivor".hashCode()) {
            return new IsoSurvivor(isoCell);
        }
        if (n == "Zombie".hashCode()) {
            return new IsoZombie(isoCell);
        }
        if (n == "Pushable".hashCode()) {
            return new IsoPushableObject(isoCell);
        }
        if (n == "WheelieBin".hashCode()) {
            return new IsoWheelieBin(isoCell);
        }
        if (n == "WorldInventoryItem".hashCode()) {
            return new IsoWorldInventoryObject(isoCell);
        }
        if (n == "Jukebox".hashCode()) {
            return new IsoJukebox(isoCell);
        }
        if (n == "Curtain".hashCode()) {
            return new IsoCurtain(isoCell);
        }
        if (n == "Radio".hashCode()) {
            return new IsoRadio(isoCell);
        }
        if (n == "Television".hashCode()) {
            return new IsoTelevision(isoCell);
        }
        if (n == "DeadBody".hashCode()) {
            return new IsoDeadBody(isoCell);
        }
        if (n == "Barbecue".hashCode()) {
            return new IsoBarbecue(isoCell);
        }
        if (n == "ClothingDryer".hashCode()) {
            return new IsoClothingDryer(isoCell);
        }
        if (n == "ClothingWasher".hashCode()) {
            return new IsoClothingWasher(isoCell);
        }
        if (n == "Fireplace".hashCode()) {
            return new IsoFireplace(isoCell);
        }
        if (n == "Stove".hashCode()) {
            return new IsoStove(isoCell);
        }
        if (n == "Door".hashCode()) {
            return new IsoDoor(isoCell);
        }
        if (n == "Thumpable".hashCode()) {
            return new IsoThumpable(isoCell);
        }
        if (n == "IsoTrap".hashCode()) {
            return new IsoTrap(isoCell);
        }
        if (n == "IsoBrokenGlass".hashCode()) {
            return new IsoBrokenGlass(isoCell);
        }
        if (n == "IsoCarBatteryCharger".hashCode()) {
            return new IsoCarBatteryCharger(isoCell);
        }
        if (n == "IsoGenerator".hashCode()) {
            return new IsoGenerator(isoCell);
        }
        if (n == "IsoCompost".hashCode()) {
            return new IsoCompost(isoCell);
        }
        if (n == "Mannequin".hashCode()) {
            return new IsoMannequin(isoCell);
        }
        if (n == "StoneFurnace".hashCode()) {
            return new BSFurnace(isoCell);
        }
        if (n == "Window".hashCode()) {
            return new IsoWindow(isoCell);
        }
        if (n == "Barricade".hashCode()) {
            return new IsoBarricade(isoCell);
        }
        if (n == "Tree".hashCode()) {
            return IsoTree.getNew();
        }
        if (n == "LightSwitch".hashCode()) {
            return new IsoLightSwitch(isoCell);
        }
        if (n == "ZombieGiblets".hashCode()) {
            return new IsoZombieGiblets(isoCell);
        }
        if (n == "MolotovCocktail".hashCode()) {
            return new IsoMolotovCocktail(isoCell);
        }
        if (n == "Fire".hashCode()) {
            return new IsoFire(isoCell);
        }
        if (n == "Vehicle".hashCode() && !GameClient.bClient) {
            return new BaseVehicle(isoCell);
        }
        IsoObject isoObject = new IsoObject(isoCell);
        return isoObject;
    }

    @Deprecated
    public static Class factoryClassFromFileInput(IsoCell isoCell, int n) {
        if (n == "IsoObject".hashCode()) {
            return IsoObject.class;
        }
        if (n == "Player".hashCode()) {
            return IsoPlayer.class;
        }
        if (n == "Survivor".hashCode()) {
            return IsoSurvivor.class;
        }
        if (n == "Zombie".hashCode()) {
            return IsoZombie.class;
        }
        if (n == "Pushable".hashCode()) {
            return IsoPushableObject.class;
        }
        if (n == "WheelieBin".hashCode()) {
            return IsoWheelieBin.class;
        }
        if (n == "WorldInventoryItem".hashCode()) {
            return IsoWorldInventoryObject.class;
        }
        if (n == "Jukebox".hashCode()) {
            return IsoJukebox.class;
        }
        if (n == "Curtain".hashCode()) {
            return IsoCurtain.class;
        }
        if (n == "Radio".hashCode()) {
            return IsoRadio.class;
        }
        if (n == "Television".hashCode()) {
            return IsoTelevision.class;
        }
        if (n == "DeadBody".hashCode()) {
            return IsoDeadBody.class;
        }
        if (n == "Barbecue".hashCode()) {
            return IsoBarbecue.class;
        }
        if (n == "ClothingDryer".hashCode()) {
            return IsoClothingDryer.class;
        }
        if (n == "ClothingWasher".hashCode()) {
            return IsoClothingWasher.class;
        }
        if (n == "Fireplace".hashCode()) {
            return IsoFireplace.class;
        }
        if (n == "Stove".hashCode()) {
            return IsoStove.class;
        }
        if (n == "Mannequin".hashCode()) {
            return IsoMannequin.class;
        }
        if (n == "Door".hashCode()) {
            return IsoDoor.class;
        }
        if (n == "Thumpable".hashCode()) {
            return IsoThumpable.class;
        }
        if (n == "Window".hashCode()) {
            return IsoWindow.class;
        }
        if (n == "Barricade".hashCode()) {
            return IsoBarricade.class;
        }
        if (n == "Tree".hashCode()) {
            return IsoTree.class;
        }
        if (n == "LightSwitch".hashCode()) {
            return IsoLightSwitch.class;
        }
        if (n == "ZombieGiblets".hashCode()) {
            return IsoZombieGiblets.class;
        }
        if (n == "MolotovCocktail".hashCode()) {
            return IsoMolotovCocktail.class;
        }
        if (n == "Vehicle".hashCode()) {
            return BaseVehicle.class;
        }
        return IsoObject.class;
    }

    @Deprecated
    static IsoObject factoryFromFileInput(IsoCell isoCell, DataInputStream dataInputStream) throws IOException {
        boolean bl = dataInputStream.readBoolean();
        if (!bl) {
            return null;
        }
        byte by = dataInputStream.readByte();
        IsoObject isoObject = IsoObject.factoryFromFileInput(isoCell, by);
        return isoObject;
    }

    public static IsoObject factoryFromFileInput(IsoCell isoCell, ByteBuffer byteBuffer) {
        boolean bl;
        boolean bl2 = bl = byteBuffer.get() != 0;
        if (!bl) {
            return null;
        }
        byte by = byteBuffer.get();
        IsoObject isoObject = IsoObject.factoryFromFileInput(isoCell, by);
        return isoObject;
    }

    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection, ByteBuffer byteBuffer) {
    }

    public void syncIsoObjectSend(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byteBufferWriter.putByte((byte)this.square.getObjects().indexOf(this));
        byteBufferWriter.putByte((byte)0);
        byteBufferWriter.putByte((byte)0);
    }

    public String getTextureName() {
        if (this.sprite == null) {
            return null;
        }
        return this.sprite.name;
    }

    public boolean Serialize() {
        return true;
    }

    public KahluaTable getModData() {
        if (this.table == null) {
            this.table = LuaManager.platform.newTable();
        }
        return this.table;
    }

    public boolean hasModData() {
        return this.table != null && !this.table.isEmpty();
    }

    public IsoGridSquare getSquare() {
        return this.square;
    }

    public void setSquare(IsoGridSquare isoGridSquare) {
        this.square = isoGridSquare;
    }

    public IsoChunk getChunk() {
        IsoGridSquare isoGridSquare = this.getSquare();
        return isoGridSquare == null ? null : isoGridSquare.getChunk();
    }

    public void update() {
    }

    public void renderlast() {
    }

    public void DirtySlice() {
    }

    public String getObjectName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.sprite != null && this.sprite.getParentObjectName() != null) {
            return this.sprite.getParentObjectName();
        }
        return "IsoObject";
    }

    public final void load(ByteBuffer byteBuffer, int n) throws IOException {
        this.load(byteBuffer, n, false);
    }

    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        BitHeaderRead bitHeaderRead;
        int n2 = byteBuffer.getInt();
        n2 = IsoChunk.Fix2x(this.square, n2);
        this.sprite = IsoSprite.getSprite(IsoSpriteManager.instance, n2);
        if (n2 == -1) {
            this.sprite = IsoSpriteManager.instance.getSprite("");
            assert (this.sprite != null);
            assert (this.sprite.ID == -1);
        }
        if (!(bitHeaderRead = BitHeader.allocRead(BitHeader.HeaderSize.Byte, byteBuffer)).equals(0)) {
            int n3;
            if (bitHeaderRead.hasFlags(1)) {
                n3 = bitHeaderRead.hasFlags(2) ? 1 : byteBuffer.get() & 0xFF;
                if (bl) {
                    String string = GameWindow.ReadStringUTF(byteBuffer);
                    DebugLog.log(string + ", read = " + n3);
                }
                for (int i = 0; i < n3; ++i) {
                    float f;
                    if (this.AttachedAnimSprite == null) {
                        this.AttachedAnimSprite = new ArrayList();
                    }
                    int n4 = byteBuffer.getInt();
                    IsoSprite isoSprite = IsoSprite.getSprite(IsoSpriteManager.instance, n4);
                    IsoSpriteInstance isoSpriteInstance = null;
                    if (isoSprite != null) {
                        isoSpriteInstance = isoSprite.newInstance();
                    } else if (Core.bDebug) {
                        DebugLog.General.warn("discarding attached sprite because it has no tile properties");
                    }
                    byte by = byteBuffer.get();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if ((by & 2) != 0) {
                        bl2 = true;
                    }
                    if ((by & 4) != 0 && isoSpriteInstance != null) {
                        isoSpriteInstance.Flip = true;
                    }
                    if ((by & 8) != 0 && isoSpriteInstance != null) {
                        isoSpriteInstance.bCopyTargetAlpha = true;
                    }
                    if ((by & 0x10) != 0) {
                        bl3 = true;
                        if (isoSpriteInstance != null) {
                            isoSpriteInstance.bMultiplyObjectAlpha = true;
                        }
                    }
                    if (bl2) {
                        f = byteBuffer.getFloat();
                        float f2 = byteBuffer.getFloat();
                        float f3 = byteBuffer.getFloat();
                        float f4 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                        float f5 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                        float f6 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                        if (isoSpriteInstance != null) {
                            isoSpriteInstance.offX = f;
                            isoSpriteInstance.offY = f2;
                            isoSpriteInstance.offZ = f3;
                            isoSpriteInstance.tintr = f4;
                            isoSpriteInstance.tintg = f5;
                            isoSpriteInstance.tintb = f6;
                        }
                    } else if (isoSpriteInstance != null) {
                        isoSpriteInstance.offX = 0.0f;
                        isoSpriteInstance.offY = 0.0f;
                        isoSpriteInstance.offZ = 0.0f;
                        isoSpriteInstance.tintr = 1.0f;
                        isoSpriteInstance.tintg = 1.0f;
                        isoSpriteInstance.tintb = 1.0f;
                        isoSpriteInstance.alpha = 1.0f;
                        isoSpriteInstance.targetAlpha = 1.0f;
                    }
                    if (bl3) {
                        f = byteBuffer.getFloat();
                        if (isoSpriteInstance != null) {
                            isoSpriteInstance.alpha = f;
                        }
                    }
                    if (isoSprite == null) continue;
                    if (isoSprite.name != null && isoSprite.name.startsWith("overlay_blood_")) {
                        f = (float)GameTime.getInstance().getWorldAgeHours();
                        IsoWallBloodSplat isoWallBloodSplat = new IsoWallBloodSplat(f, isoSprite);
                        if (this.wallBloodSplats == null) {
                            this.wallBloodSplats = new ArrayList();
                        }
                        this.wallBloodSplats.add(isoWallBloodSplat);
                        continue;
                    }
                    this.AttachedAnimSprite.add(isoSpriteInstance);
                }
            }
            if (bitHeaderRead.hasFlags(4)) {
                if (bl) {
                    String string = GameWindow.ReadStringUTF(byteBuffer);
                    DebugLog.log(string);
                }
                if (((n3 = (int)byteBuffer.get()) & 2) != 0) {
                    this.name = "Grass";
                } else if ((n3 & 4) != 0) {
                    this.name = WorldDictionary.getObjectNameFromID(byteBuffer.get());
                } else if ((n3 & 8) != 0) {
                    this.name = GameWindow.ReadString(byteBuffer);
                }
                if ((n3 & 0x10) != 0) {
                    this.spriteName = WorldDictionary.getSpriteNameFromID(byteBuffer.getInt());
                } else if ((n3 & 0x20) != 0) {
                    this.spriteName = GameWindow.ReadString(byteBuffer);
                }
            }
            if (bitHeaderRead.hasFlags(8)) {
                float f = Bits.unpackByteToFloatUnit(byteBuffer.get());
                float f7 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                float f8 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                this.customColor = new ColorInfo(f, f7, f8, 1.0f);
            }
            this.doNotSync = bitHeaderRead.hasFlags(16);
            this.setOutlineOnMouseover(bitHeaderRead.hasFlags(32));
            if (bitHeaderRead.hasFlags(64)) {
                int n5;
                BitHeaderRead bitHeaderRead2 = BitHeader.allocRead(BitHeader.HeaderSize.Short, byteBuffer);
                if (bitHeaderRead2.hasFlags(1) && (n5 = byteBuffer.get()) > 0) {
                    if (this.wallBloodSplats == null) {
                        this.wallBloodSplats = new ArrayList();
                    }
                    int n6 = 0;
                    if (GameClient.bClient || GameServer.bServer) {
                        n6 = ServerOptions.getInstance().BloodSplatLifespanDays.getValue();
                    }
                    float f = (float)GameTime.getInstance().getWorldAgeHours();
                    for (int i = 0; i < n5; ++i) {
                        IsoWallBloodSplat isoWallBloodSplat = new IsoWallBloodSplat();
                        isoWallBloodSplat.load(byteBuffer, n);
                        if (isoWallBloodSplat.worldAge > f) {
                            isoWallBloodSplat.worldAge = f;
                        }
                        if (n6 > 0 && f - isoWallBloodSplat.worldAge >= (float)(n6 * 24)) continue;
                        this.wallBloodSplats.add(isoWallBloodSplat);
                    }
                }
                if (bitHeaderRead2.hasFlags(2)) {
                    if (bl) {
                        String string = GameWindow.ReadStringUTF(byteBuffer);
                        DebugLog.log(string);
                    }
                    int n7 = byteBuffer.get();
                    for (int i = 0; i < n7; ++i) {
                        try {
                            ItemContainer itemContainer = new ItemContainer();
                            itemContainer.ID = 0;
                            itemContainer.parent = this;
                            itemContainer.parent.square = this.square;
                            itemContainer.SourceGrid = this.square;
                            itemContainer.load(byteBuffer, n);
                            if (i == 0) {
                                if (this instanceof IsoDeadBody) {
                                    itemContainer.Capacity = 8;
                                }
                                this.container = itemContainer;
                                continue;
                            }
                            this.addSecondaryContainer(itemContainer);
                            continue;
                        }
                        catch (Exception exception) {
                            if (this.container != null) {
                                DebugLog.log("Failed to stream in container ID: " + this.container.ID);
                            }
                            throw new RuntimeException(exception);
                        }
                    }
                }
                if (bitHeaderRead2.hasFlags(4)) {
                    if (this.table == null) {
                        this.table = LuaManager.platform.newTable();
                    }
                    this.table.load(byteBuffer, n);
                }
                this.setSpecialTooltip(bitHeaderRead2.hasFlags(8));
                if (bitHeaderRead2.hasFlags(16)) {
                    this.keyId = byteBuffer.getInt();
                }
                this.usesExternalWaterSource = bitHeaderRead2.hasFlags(32);
                if (bitHeaderRead2.hasFlags(64)) {
                    this.sheetRope = true;
                    this.sheetRopeHealth = byteBuffer.getFloat();
                } else {
                    this.sheetRope = false;
                }
                if (bitHeaderRead2.hasFlags(128)) {
                    this.renderYOffset = byteBuffer.getFloat();
                }
                if (bitHeaderRead2.hasFlags(256)) {
                    String string = null;
                    string = bitHeaderRead2.hasFlags(512) ? GameWindow.ReadString(byteBuffer) : WorldDictionary.getSpriteNameFromID(byteBuffer.getInt());
                    if (string != null && !string.isEmpty()) {
                        this.overlaySprite = IsoSpriteManager.instance.getSprite(string);
                        this.overlaySprite.name = string;
                    }
                }
                if (bitHeaderRead2.hasFlags(1024)) {
                    float f = Bits.unpackByteToFloatUnit(byteBuffer.get());
                    float f9 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                    float f10 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                    float f11 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                    if (this.overlaySprite != null) {
                        this.setOverlaySpriteColor(f, f9, f10, f11);
                    }
                }
                this.setMovedThumpable(bitHeaderRead2.hasFlags(2048));
                bitHeaderRead2.release();
            }
        }
        bitHeaderRead.release();
        if (this.sprite == null) {
            this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
            this.sprite.LoadFramesNoDirPageSimple(this.spriteName);
        }
    }

    public final void save(ByteBuffer byteBuffer) throws IOException {
        this.save(byteBuffer, false);
    }

    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        byte by;
        int n;
        int n2;
        byteBuffer.put(this.Serialize() ? (byte)1 : 0);
        if (!this.Serialize()) {
            return;
        }
        byteBuffer.put(IsoObject.factoryGetClassID(this.getObjectName()));
        byteBuffer.putInt(this.sprite == null ? -1 : this.sprite.ID);
        BitHeaderWrite bitHeaderWrite = BitHeader.allocWrite(BitHeader.HeaderSize.Byte, byteBuffer);
        if (this.AttachedAnimSprite != null) {
            bitHeaderWrite.addFlags(1);
            if (this.AttachedAnimSprite.size() == 1) {
                bitHeaderWrite.addFlags(2);
            }
            int n3 = n2 = this.AttachedAnimSprite.size() > 255 ? 255 : this.AttachedAnimSprite.size();
            if (n2 != 1) {
                byteBuffer.put((byte)n2);
            }
            if (bl) {
                GameWindow.WriteString(byteBuffer, "Writing attached sprites (" + n2 + ")");
            }
            for (n = 0; n < n2; ++n) {
                IsoSpriteInstance isoSpriteInstance = this.AttachedAnimSprite.get(n);
                byteBuffer.putInt(isoSpriteInstance.getID());
                by = 0;
                boolean bl2 = false;
                if (isoSpriteInstance.offX != 0.0f || isoSpriteInstance.offY != 0.0f || isoSpriteInstance.offZ != 0.0f || isoSpriteInstance.tintr != 1.0f || isoSpriteInstance.tintg != 1.0f || isoSpriteInstance.tintb != 1.0f) {
                    by = (byte)(by | 2);
                    bl2 = true;
                }
                if (isoSpriteInstance.Flip) {
                    by = (byte)(by | 4);
                }
                if (isoSpriteInstance.bCopyTargetAlpha) {
                    by = (byte)(by | 8);
                }
                if (isoSpriteInstance.bMultiplyObjectAlpha) {
                    by = (byte)(by | 0x10);
                }
                byteBuffer.put(by);
                if (bl2) {
                    byteBuffer.putFloat(isoSpriteInstance.offX);
                    byteBuffer.putFloat(isoSpriteInstance.offY);
                    byteBuffer.putFloat(isoSpriteInstance.offZ);
                    byteBuffer.put(Bits.packFloatUnitToByte(isoSpriteInstance.tintr));
                    byteBuffer.put(Bits.packFloatUnitToByte(isoSpriteInstance.tintg));
                    byteBuffer.put(Bits.packFloatUnitToByte(isoSpriteInstance.tintb));
                }
                if (!isoSpriteInstance.bMultiplyObjectAlpha) continue;
                byteBuffer.putFloat(isoSpriteInstance.alpha);
            }
        }
        if (this.name != null || this.spriteName != null) {
            bitHeaderWrite.addFlags(4);
            if (bl) {
                GameWindow.WriteString(byteBuffer, "Writing name");
            }
            n2 = 0;
            n = -1;
            int n4 = -1;
            if (this.name != null) {
                n2 = this.name.equals("Grass") ? (int)(n2 | 2) : (int)((n = (int)WorldDictionary.getIdForObjectName(this.name)) >= 0 ? (byte)(n2 | 4) : (byte)(n2 | 8));
            }
            if (this.spriteName != null) {
                n4 = WorldDictionary.getIdForSpriteName(this.spriteName);
                n2 = n4 >= 0 ? (byte)(n2 | 0x10) : (byte)(n2 | 0x20);
            }
            byteBuffer.put((byte)n2);
            if (this.name != null && !this.name.equals("Grass")) {
                if (n >= 0) {
                    byteBuffer.put((byte)n);
                } else {
                    GameWindow.WriteString(byteBuffer, this.name);
                }
            }
            if (this.spriteName != null) {
                if (n4 >= 0) {
                    byteBuffer.putInt(n4);
                } else {
                    GameWindow.WriteString(byteBuffer, this.spriteName);
                }
            }
        }
        if (this.customColor != null) {
            bitHeaderWrite.addFlags(8);
            byteBuffer.put(Bits.packFloatUnitToByte(this.customColor.r));
            byteBuffer.put(Bits.packFloatUnitToByte(this.customColor.g));
            byteBuffer.put(Bits.packFloatUnitToByte(this.customColor.b));
        }
        if (this.doNotSync) {
            bitHeaderWrite.addFlags(16);
        }
        if (this.isOutlineOnMouseover()) {
            bitHeaderWrite.addFlags(32);
        }
        BitHeaderWrite bitHeaderWrite2 = BitHeader.allocWrite(BitHeader.HeaderSize.Short, byteBuffer);
        if (this.wallBloodSplats != null) {
            bitHeaderWrite2.addFlags(1);
            n = Math.min(this.wallBloodSplats.size(), 32);
            byte by2 = this.wallBloodSplats.size() - n;
            byteBuffer.put((byte)n);
            for (by = by2; by < this.wallBloodSplats.size(); ++by) {
                this.wallBloodSplats.get(by).save(byteBuffer);
            }
        }
        if (this.getContainerCount() > 0) {
            bitHeaderWrite2.addFlags(2);
            if (bl) {
                GameWindow.WriteString(byteBuffer, "Writing container");
            }
            byteBuffer.put((byte)this.getContainerCount());
            for (n = 0; n < this.getContainerCount(); ++n) {
                this.getContainerByIndex(n).save(byteBuffer);
            }
        }
        if (this.table != null && !this.table.isEmpty()) {
            bitHeaderWrite2.addFlags(4);
            this.table.save(byteBuffer);
        }
        if (this.haveSpecialTooltip()) {
            bitHeaderWrite2.addFlags(8);
        }
        if (this.getKeyId() != -1) {
            bitHeaderWrite2.addFlags(16);
            byteBuffer.putInt(this.getKeyId());
        }
        if (this.usesExternalWaterSource) {
            bitHeaderWrite2.addFlags(32);
        }
        if (this.sheetRope) {
            bitHeaderWrite2.addFlags(64);
            byteBuffer.putFloat(this.sheetRopeHealth);
        }
        if (this.renderYOffset != 0.0f) {
            bitHeaderWrite2.addFlags(128);
            byteBuffer.putFloat(this.renderYOffset);
        }
        if (this.getOverlaySprite() != null) {
            bitHeaderWrite2.addFlags(256);
            n = WorldDictionary.getIdForSpriteName(this.getOverlaySprite().name);
            if (n < 0) {
                bitHeaderWrite2.addFlags(512);
                GameWindow.WriteString(byteBuffer, this.getOverlaySprite().name);
            } else {
                byteBuffer.putInt(n);
            }
            if (this.getOverlaySpriteColor() != null) {
                bitHeaderWrite2.addFlags(1024);
                byteBuffer.put(Bits.packFloatUnitToByte(this.getOverlaySpriteColor().r));
                byteBuffer.put(Bits.packFloatUnitToByte(this.getOverlaySpriteColor().g));
                byteBuffer.put(Bits.packFloatUnitToByte(this.getOverlaySpriteColor().b));
                byteBuffer.put(Bits.packFloatUnitToByte(this.getOverlaySpriteColor().a));
            }
        }
        if (this.isMovedThumpable()) {
            bitHeaderWrite2.addFlags(2048);
        }
        if (!bitHeaderWrite2.equals(0)) {
            bitHeaderWrite.addFlags(64);
            bitHeaderWrite2.write();
        } else {
            byteBuffer.position(bitHeaderWrite2.getStartPosition());
        }
        bitHeaderWrite.write();
        bitHeaderWrite.release();
        bitHeaderWrite2.release();
    }

    public void saveState(ByteBuffer byteBuffer) throws IOException {
    }

    public void loadState(ByteBuffer byteBuffer) throws IOException {
    }

    public void softReset() {
        if (this.container != null) {
            this.container.Items.clear();
            this.container.bExplored = false;
            this.setOverlaySprite(null, -1.0f, -1.0f, -1.0f, -1.0f, false);
        }
        if (this.AttachedAnimSprite != null && !this.AttachedAnimSprite.isEmpty()) {
            for (int i = 0; i < this.AttachedAnimSprite.size(); ++i) {
                IsoSprite isoSprite = this.AttachedAnimSprite.get((int)i).parentSprite;
                if (isoSprite.name == null || !isoSprite.name.contains("blood")) continue;
                this.AttachedAnimSprite.remove(i);
                --i;
            }
        }
    }

    public void AttackObject(IsoGameCharacter isoGameCharacter) {
        this.Damage = (short)(this.Damage - 10);
        HandWeapon handWeapon = (HandWeapon)isoGameCharacter.getPrimaryHandItem();
        SoundManager.instance.PlaySound(handWeapon.getDoorHitSound(), false, 2.0f);
        WorldSoundManager.instance.addSound(isoGameCharacter, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, false, 0.0f, 15.0f);
        if (this.Damage <= 0) {
            this.square.getObjects().remove(this);
            this.square.RecalcAllWithNeighbours(true);
            if (this.getType() == IsoObjectType.stairsBN || this.getType() == IsoObjectType.stairsMN || this.getType() == IsoObjectType.stairsTN || this.getType() == IsoObjectType.stairsBW || this.getType() == IsoObjectType.stairsMW || this.getType() == IsoObjectType.stairsTW) {
                this.square.RemoveAllWith(IsoFlagType.attachtostairs);
            }
            int n = 1;
            for (int i = 0; i < n; ++i) {
                InventoryItem inventoryItem = this.square.AddWorldInventoryItem("Base.Plank", Rand.Next(-1.0f, 1.0f), Rand.Next(-1.0f, 1.0f), 0.0f);
                inventoryItem.setUses(1);
            }
        }
    }

    public void onMouseRightClick(int n, int n2) {
    }

    public void onMouseRightReleased() {
    }

    public void Hit(Vector2 vector22, IsoObject isoObject, float f) {
        if (isoObject instanceof BaseVehicle) {
            this.HitByVehicle((BaseVehicle)isoObject, f);
            if (this.Damage <= 0 && BrokenFences.getInstance().isBreakableObject(this)) {
                PropertyContainer propertyContainer = this.getProperties();
                IsoDirections isoDirections = propertyContainer.Is(IsoFlagType.collideN) && propertyContainer.Is(IsoFlagType.collideW) ? (isoObject.getY() >= this.getY() ? IsoDirections.N : IsoDirections.S) : (propertyContainer.Is(IsoFlagType.collideN) ? (isoObject.getY() >= this.getY() ? IsoDirections.N : IsoDirections.S) : (isoObject.getX() >= this.getX() ? IsoDirections.W : IsoDirections.E));
                BrokenFences.getInstance().destroyFence(this, isoDirections);
            }
        }
    }

    public void Damage(float f) {
        this.Damage = (short)((double)this.Damage - (double)f * 0.1);
    }

    public void HitByVehicle(BaseVehicle baseVehicle, float f) {
        short s = this.Damage;
        this.Damage = (short)((double)this.Damage - (double)f * 0.1);
        BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter((float)this.square.x + 0.5f, (float)this.square.y + 0.5f, this.square.z);
        long l = baseSoundEmitter.playSound("VehicleHitObject");
        baseSoundEmitter.setParameterValue(l, FMODManager.instance.getParameterDescription("VehicleSpeed"), baseVehicle.getCurrentSpeedKmHour());
        WorldSoundManager.instance.addSound(null, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, true, 4.0f, 15.0f);
        if (this.getProperties().Is("HitByCar") && this.getSprite().getProperties().Val("DamagedSprite") != null && !this.getSprite().getProperties().Val("DamagedSprite").equals("") && this.Damage <= 90 && s > 90) {
            this.setSprite(IsoSpriteManager.instance.getSprite(this.getSprite().getProperties().Val("DamagedSprite")));
            if (this.getSprite().getProperties().Is("StopCar")) {
                this.getSprite().setType(IsoObjectType.isMoveAbleObject);
            } else {
                this.getSprite().setType(IsoObjectType.MAX);
            }
            if (this instanceof IsoThumpable) {
                ((IsoThumpable)this).setBlockAllTheSquare(false);
            }
            if (GameServer.bServer) {
                this.transmitUpdatedSpriteToClients();
            }
            this.getSquare().RecalcProperties();
            this.Damage = (short)50;
        }
        if (this.Damage <= 40 && this.getProperties().Is("HitByCar") && !BrokenFences.getInstance().isBreakableObject(this)) {
            this.getSquare().transmitRemoveItemFromSquare(this);
        }
    }

    public void Collision(Vector2 vector22, IsoObject isoObject) {
        if (isoObject instanceof BaseVehicle) {
            Object object;
            if (this.getProperties().Is("CarSlowFactor")) {
                int n = Integer.parseInt(this.getProperties().Val("CarSlowFactor"));
                object = (BaseVehicle)isoObject;
                ((BaseVehicle)object).ApplyImpulse(this, Math.abs(((BaseVehicle)object).getFudgedMass() * ((BaseVehicle)object).getCurrentSpeedKmHour() * (float)n / 100.0f));
            }
            if (this.getProperties().Is("HitByCar")) {
                BaseVehicle baseVehicle = (BaseVehicle)isoObject;
                object = this.getSprite().getProperties().Val("MinimumCarSpeedDmg");
                if (object == null) {
                    object = "150";
                }
                if (Math.abs(baseVehicle.getCurrentSpeedKmHour()) > (float)Integer.parseInt((String)object)) {
                    this.HitByVehicle(baseVehicle, Math.abs(baseVehicle.getFudgedMass() * baseVehicle.getCurrentSpeedKmHour()) / 300.0f);
                    if (this.Damage <= 0 && BrokenFences.getInstance().isBreakableObject(this)) {
                        PropertyContainer propertyContainer = this.getProperties();
                        IsoDirections isoDirections = propertyContainer.Is(IsoFlagType.collideN) && propertyContainer.Is(IsoFlagType.collideW) ? (baseVehicle.getY() >= this.getY() ? IsoDirections.N : IsoDirections.S) : (propertyContainer.Is(IsoFlagType.collideN) ? (baseVehicle.getY() >= this.getY() ? IsoDirections.N : IsoDirections.S) : (baseVehicle.getX() >= this.getX() ? IsoDirections.W : IsoDirections.E));
                        BrokenFences.getInstance().destroyFence(this, isoDirections);
                    }
                } else if (!this.square.getProperties().Is(IsoFlagType.collideN) && !this.square.getProperties().Is(IsoFlagType.collideW)) {
                    baseVehicle.ApplyImpulse(this, Math.abs(baseVehicle.getFudgedMass() * baseVehicle.getCurrentSpeedKmHour() * 10.0f / 200.0f));
                    if (baseVehicle.getCurrentSpeedKmHour() > 3.0f) {
                        baseVehicle.ApplyImpulse(this, Math.abs(baseVehicle.getFudgedMass() * baseVehicle.getCurrentSpeedKmHour() * 10.0f / 150.0f));
                    }
                    baseVehicle.jniSpeed = 0.0f;
                }
            }
        }
    }

    public void UnCollision(IsoObject isoObject) {
    }

    public float GetVehicleSlowFactor(BaseVehicle baseVehicle) {
        if (this.getProperties().Is("CarSlowFactor")) {
            int n = Integer.parseInt(this.getProperties().Val("CarSlowFactor"));
            return 33.0f - (float)(10 - n);
        }
        return 0.0f;
    }

    public IsoObject getRerouteCollide() {
        return this.rerouteCollide;
    }

    public void setRerouteCollide(IsoObject isoObject) {
        this.rerouteCollide = isoObject;
    }

    public KahluaTable getTable() {
        return this.table;
    }

    public void setTable(KahluaTable kahluaTable) {
        this.table = kahluaTable;
    }

    public void setAlpha(float f) {
        this.setAlpha(IsoPlayer.getPlayerIndex(), f);
    }

    public void setAlpha(int n, float f) {
        this.alpha[n] = PZMath.clamp(f, 0.0f, 1.0f);
    }

    public void setAlphaToTarget(int n) {
        this.setAlpha(n, this.getTargetAlpha(n));
    }

    public void setAlphaAndTarget(float f) {
        int n = IsoPlayer.getPlayerIndex();
        this.setAlphaAndTarget(n, f);
    }

    public void setAlphaAndTarget(int n, float f) {
        this.setAlpha(n, f);
        this.setTargetAlpha(n, f);
    }

    public float getAlpha() {
        return this.getAlpha(IsoPlayer.getPlayerIndex());
    }

    public float getAlpha(int n) {
        return this.alpha[n];
    }

    public ArrayList<IsoSpriteInstance> getAttachedAnimSprite() {
        return this.AttachedAnimSprite;
    }

    public void setAttachedAnimSprite(ArrayList<IsoSpriteInstance> arrayList) {
        this.AttachedAnimSprite = arrayList;
    }

    public IsoCell getCell() {
        return IsoWorld.instance.CurrentCell;
    }

    public ArrayList<IsoSpriteInstance> getChildSprites() {
        return this.AttachedAnimSprite;
    }

    public void setChildSprites(ArrayList<IsoSpriteInstance> arrayList) {
        this.AttachedAnimSprite = arrayList;
    }

    public void clearAttachedAnimSprite() {
        if (this.AttachedAnimSprite == null) {
            return;
        }
        for (int i = 0; i < this.AttachedAnimSprite.size(); ++i) {
            IsoSpriteInstance.add(this.AttachedAnimSprite.get(i));
        }
        this.AttachedAnimSprite.clear();
    }

    public ItemContainer getContainer() {
        return this.container;
    }

    public void setContainer(ItemContainer itemContainer) {
        itemContainer.parent = this;
        this.container = itemContainer;
    }

    public IsoDirections getDir() {
        return this.dir;
    }

    public void setDir(IsoDirections isoDirections) {
        this.dir = isoDirections;
    }

    public void setDir(int n) {
        this.dir = IsoDirections.fromIndex(n);
    }

    public short getDamage() {
        return this.Damage;
    }

    public void setDamage(short s) {
        this.Damage = s;
    }

    public boolean isNoPicking() {
        return this.NoPicking;
    }

    public void setNoPicking(boolean bl) {
        this.NoPicking = bl;
    }

    public boolean isOutlineOnMouseover() {
        return this.OutlineOnMouseover;
    }

    public void setOutlineOnMouseover(boolean bl) {
        this.OutlineOnMouseover = bl;
    }

    public IsoObject getRerouteMask() {
        return this.rerouteMask;
    }

    public void setRerouteMask(IsoObject isoObject) {
        this.rerouteMask = isoObject;
    }

    public IsoSprite getSprite() {
        return this.sprite;
    }

    public void setSprite(IsoSprite isoSprite) {
        this.sprite = isoSprite;
        this.windRenderEffects = null;
        this.checkMoveWithWind();
    }

    public void setSprite(String string) {
        this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.sprite.LoadFramesNoDirPageSimple(string);
        this.tile = string;
        this.spriteName = string;
        this.windRenderEffects = null;
        this.checkMoveWithWind();
    }

    public void setSpriteFromName(String string) {
        this.sprite = IsoSpriteManager.instance.getSprite(string);
        this.windRenderEffects = null;
        this.checkMoveWithWind();
    }

    public float getTargetAlpha() {
        return this.getTargetAlpha(IsoPlayer.getPlayerIndex());
    }

    public void setTargetAlpha(float f) {
        this.setTargetAlpha(IsoPlayer.getPlayerIndex(), f);
    }

    public void setTargetAlpha(int n, float f) {
        this.targetAlpha[n] = PZMath.clamp(f, 0.0f, 1.0f);
    }

    public float getTargetAlpha(int n) {
        return this.targetAlpha[n];
    }

    public boolean isAlphaAndTargetZero() {
        int n = IsoPlayer.getPlayerIndex();
        return this.isAlphaAndTargetZero(n);
    }

    public boolean isAlphaAndTargetZero(int n) {
        return this.isAlphaZero(n) && this.isTargetAlphaZero(n);
    }

    public boolean isAlphaZero() {
        int n = IsoPlayer.getPlayerIndex();
        return this.isAlphaZero(n);
    }

    public boolean isAlphaZero(int n) {
        return this.alpha[n] <= 0.001f;
    }

    public boolean isTargetAlphaZero(int n) {
        return this.targetAlpha[n] <= 0.001f;
    }

    public IsoObjectType getType() {
        if (this.sprite == null) {
            return IsoObjectType.MAX;
        }
        return this.sprite.getType();
    }

    public void setType(IsoObjectType isoObjectType) {
        if (this.sprite != null) {
            this.sprite.setType(isoObjectType);
        }
    }

    public void addChild(IsoObject isoObject) {
        if (this.Children == null) {
            this.Children = new ArrayList(4);
        }
        this.Children.add(isoObject);
    }

    public void debugPrintout() {
        System.out.println(this.getClass().toString());
        System.out.println(this.getObjectName());
    }

    protected void checkMoveWithWind() {
        this.checkMoveWithWind(this.sprite != null && this.sprite.isBush);
    }

    protected void checkMoveWithWind(boolean bl) {
        if (GameServer.bServer) {
            return;
        }
        if (this.sprite != null && this.windRenderEffects == null && this.sprite.moveWithWind) {
            if (this.getSquare() != null) {
                IsoGridSquare isoGridSquare;
                IsoGridSquare isoGridSquare2;
                IsoGridSquare isoGridSquare3 = this.getCell().getGridSquare(this.getSquare().x - 1, this.getSquare().y, this.getSquare().z);
                if (isoGridSquare3 != null && (isoGridSquare2 = this.getCell().getGridSquare(isoGridSquare3.x, isoGridSquare3.y + 1, isoGridSquare3.z)) != null && !isoGridSquare2.isExteriorCache && isoGridSquare2.getWall(true) != null) {
                    this.windRenderEffects = null;
                    return;
                }
                isoGridSquare2 = this.getCell().getGridSquare(this.getSquare().x, this.getSquare().y - 1, this.getSquare().z);
                if (isoGridSquare2 != null && (isoGridSquare = this.getCell().getGridSquare(isoGridSquare2.x + 1, isoGridSquare2.y, isoGridSquare2.z)) != null && !isoGridSquare.isExteriorCache && isoGridSquare.getWall(false) != null) {
                    this.windRenderEffects = null;
                    return;
                }
            }
            this.windRenderEffects = ObjectRenderEffects.getNextWindEffect(this.sprite.windType, bl);
            return;
        }
        if (!(this.windRenderEffects == null || this.sprite != null && this.sprite.moveWithWind)) {
            this.windRenderEffects = null;
        }
    }

    public void reset() {
        Object object;
        int n;
        this.tintr = 1.0f;
        this.tintg = 1.0f;
        this.tintb = 1.0f;
        this.name = null;
        this.table = null;
        this.rerouteCollide = null;
        if (this.AttachedAnimSprite != null) {
            for (n = 0; n < this.AttachedAnimSprite.size(); ++n) {
                object = this.AttachedAnimSprite.get(n);
                IsoSpriteInstance.add((IsoSpriteInstance)object);
            }
            this.AttachedAnimSprite.clear();
        }
        if (this.wallBloodSplats != null) {
            this.wallBloodSplats.clear();
        }
        this.overlaySprite = null;
        this.overlaySpriteColor = null;
        this.customColor = null;
        if (this.container != null) {
            this.container.Items.clear();
            this.container.IncludingObsoleteItems.clear();
            this.container.setParent(null);
            this.container.setSourceGrid(null);
            this.container.vehiclePart = null;
        }
        this.container = null;
        this.dir = IsoDirections.N;
        this.Damage = (short)100;
        this.partialThumpDmg = 0.0f;
        this.NoPicking = false;
        this.offsetX = 32 * Core.TileScale;
        this.offsetY = 96 * Core.TileScale;
        this.OutlineOnMouseover = false;
        this.rerouteMask = null;
        this.sprite = null;
        this.square = null;
        for (n = 0; n < 4; ++n) {
            this.setAlphaAndTarget(n, 1.0f);
        }
        this.bNeverDoneAlpha = true;
        this.bAlphaForced = false;
        this.highlightFlags = 0;
        this.tile = null;
        this.spriteName = null;
        this.specialTooltip = false;
        this.usesExternalWaterSource = false;
        this.externalWaterSource = null;
        if (this.secondaryContainers != null) {
            for (n = 0; n < this.secondaryContainers.size(); ++n) {
                object = this.secondaryContainers.get(n);
                ((ItemContainer)object).Items.clear();
                ((ItemContainer)object).IncludingObsoleteItems.clear();
                ((ItemContainer)object).setParent(null);
                ((ItemContainer)object).setSourceGrid(null);
                ((ItemContainer)object).vehiclePart = null;
            }
            this.secondaryContainers.clear();
        }
        this.renderYOffset = 0.0f;
        this.sx = 0.0f;
        this.windRenderEffects = null;
        this.objectRenderEffects = null;
        this.sheetRope = false;
        this.sheetRopeHealth = 100.0f;
        this.bMovedThumpable = false;
    }

    public long customHashCode() {
        if (this.doNotSync) {
            return 0L;
        }
        try {
            long l = 1L;
            if (this.getObjectName() != null) {
                l = l * 3L + (long)this.getObjectName().hashCode();
            }
            if (this.name != null) {
                l = l * 2L + (long)this.name.hashCode();
            }
            if (this.container != null) {
                ++l;
                l += (long)this.container.Items.size();
                for (int i = 0; i < this.container.Items.size(); ++i) {
                    l += (long)(this.container.Items.get(i).getModule().hashCode() + this.container.Items.get(i).getType().hashCode() + this.container.Items.get((int)i).id);
                }
            }
            return l += (long)this.square.getObjects().indexOf(this);
        }
        catch (Throwable throwable) {
            DebugLog.log("ERROR: " + throwable.getMessage());
            return 0L;
        }
    }

    public void SetName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getSpriteName() {
        return this.spriteName;
    }

    public String getTile() {
        return this.tile;
    }

    public boolean isCharacter() {
        return this instanceof IsoLivingCharacter;
    }

    public boolean isZombie() {
        return false;
    }

    public String getScriptName() {
        return "none";
    }

    public void AttachAnim(String string, String string2, int n, float f, int n2, int n3, boolean bl, int n4, boolean bl2, float f2, ColorInfo colorInfo) {
        if (this.AttachedAnimSprite == null) {
            this.AttachedAnimSprite = new ArrayList(4);
        }
        IsoSprite isoSprite = IsoSprite.CreateSpriteUsingCache(string, string2, n);
        isoSprite.TintMod.set(colorInfo);
        isoSprite.soffX = (short)(-n2);
        isoSprite.soffY = (short)(-n3);
        isoSprite.Animate = true;
        isoSprite.Loop = bl;
        isoSprite.DeleteWhenFinished = bl2;
        isoSprite.PlayAnim(string2);
        IsoSpriteInstance isoSpriteInstance = isoSprite.def;
        isoSpriteInstance.AnimFrameIncrease = f;
        isoSpriteInstance.Frame = 0.0f;
        this.AttachedAnimSprite.add(isoSpriteInstance);
    }

    public void AttachExistingAnim(IsoSprite isoSprite, int n, int n2, boolean bl, int n3, boolean bl2, float f, ColorInfo colorInfo) {
        if (this.AttachedAnimSprite == null) {
            this.AttachedAnimSprite = new ArrayList(4);
        }
        IsoSprite isoSprite2 = isoSprite;
        isoSprite2.TintMod.r = colorInfo.r;
        isoSprite2.TintMod.g = colorInfo.g;
        isoSprite2.TintMod.b = colorInfo.b;
        isoSprite2.TintMod.a = colorInfo.a;
        Integer n4 = n;
        Integer n5 = n2;
        isoSprite2.soffX = (short)(-n4.intValue());
        isoSprite2.soffY = (short)(-n5.intValue());
        isoSprite2.Animate = true;
        isoSprite2.Loop = bl;
        isoSprite2.DeleteWhenFinished = bl2;
        IsoSpriteInstance isoSpriteInstance = IsoSpriteInstance.get(isoSprite2);
        this.AttachedAnimSprite.add(isoSpriteInstance);
    }

    public void AttachExistingAnim(IsoSprite isoSprite, int n, int n2, boolean bl, int n3, boolean bl2, float f) {
        this.AttachExistingAnim(isoSprite, n, n2, bl, n3, bl2, f, new ColorInfo());
    }

    public void DoTooltip(ObjectTooltip objectTooltip) {
    }

    public void DoSpecialTooltip(ObjectTooltip objectTooltip, IsoGridSquare isoGridSquare) {
        if (this.haveSpecialTooltip()) {
            objectTooltip.setHeight(0.0);
            LuaEventManager.triggerEvent("DoSpecialTooltip", objectTooltip, isoGridSquare);
            if (objectTooltip.getHeight() == 0.0) {
                objectTooltip.hide();
            }
        }
    }

    public ItemContainer getItemContainer() {
        return this.container;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(float f) {
        this.offsetX = f;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(float f) {
        this.offsetY = f;
    }

    public IsoObject getRerouteMaskObject() {
        return this.rerouteMask;
    }

    public boolean HasTooltip() {
        return false;
    }

    public boolean getUsesExternalWaterSource() {
        return this.usesExternalWaterSource;
    }

    public void setUsesExternalWaterSource(boolean bl) {
        this.usesExternalWaterSource = bl;
    }

    public boolean hasExternalWaterSource() {
        return this.externalWaterSource != null;
    }

    public void doFindExternalWaterSource() {
        this.externalWaterSource = IsoObject.FindExternalWaterSource(this.getSquare());
    }

    public static IsoObject FindExternalWaterSource(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return null;
        }
        return IsoObject.FindExternalWaterSource(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ());
    }

    public static IsoObject FindExternalWaterSource(int n, int n2, int n3) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3 + 1);
        IsoObject isoObject = null;
        IsoObject isoObject2 = IsoObject.FindWaterSourceOnSquare(isoGridSquare);
        if (isoObject2 != null) {
            if (isoObject2.hasWater()) {
                return isoObject2;
            }
            isoObject = isoObject2;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (j == 0 && i == 0 || (isoObject2 = IsoObject.FindWaterSourceOnSquare(isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n + j, n2 + i, n3 + 1))) == null) continue;
                if (isoObject2.hasWater()) {
                    return isoObject2;
                }
                if (isoObject != null) continue;
                isoObject = isoObject2;
            }
        }
        return isoObject;
    }

    public static IsoObject FindWaterSourceOnSquare(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return null;
        }
        PZArrayList<IsoObject> pZArrayList = isoGridSquare.getObjects();
        for (int i = 0; i < pZArrayList.size(); ++i) {
            IsoObject isoObject = pZArrayList.get(i);
            if (!(isoObject instanceof IsoThumpable) || isoObject.getSprite() != null && isoObject.getSprite().solidfloor || isoObject.getUsesExternalWaterSource() || isoObject.getWaterMax() <= 0) continue;
            return isoObject;
        }
        return null;
    }

    public int getPipedFuelAmount() {
        Object object;
        if (this.sprite == null) {
            return 0;
        }
        double d = 0.0;
        if (this.hasModData() && !this.getModData().isEmpty() && (object = this.getModData().rawget((Object)"fuelAmount")) != null) {
            d = (Double)object;
        }
        if (this.sprite.getProperties().Is("fuelAmount")) {
            if (SandboxOptions.instance.FuelStationGas.getValue() == 7) {
                return 1000;
            }
            if (d == 0.0 && (SandboxOptions.getInstance().AllowExteriorGenerator.getValue() && this.getSquare().haveElectricity() || IsoWorld.instance.isHydroPowerOn())) {
                float f = 0.8f;
                float f2 = 1.0f;
                switch (SandboxOptions.getInstance().FuelStationGas.getValue()) {
                    case 1: {
                        f2 = 0.0f;
                        f = 0.0f;
                        break;
                    }
                    case 2: {
                        f = 0.0f;
                        f2 = 0.01f;
                        break;
                    }
                    case 3: {
                        f = 0.01f;
                        f2 = 0.1f;
                        break;
                    }
                    case 4: {
                        f = 0.1f;
                        f2 = 0.5f;
                        break;
                    }
                    case 5: {
                        f = 0.5f;
                        f2 = 0.7f;
                        break;
                    }
                    case 6: {
                        f = 0.7f;
                        f2 = 0.8f;
                        break;
                    }
                    case 7: {
                        f = 0.8f;
                        f2 = 0.9f;
                        break;
                    }
                    case 8: {
                        f2 = 1.0f;
                        f = 1.0f;
                    }
                }
                d = (int)Rand.Next((float)Integer.parseInt(this.sprite.getProperties().Val("fuelAmount")) * f, (float)Integer.parseInt(this.sprite.getProperties().Val("fuelAmount")) * f2);
                this.getModData().rawset((Object)"fuelAmount", (Object)d);
                this.transmitModData();
                return (int)d;
            }
        }
        return (int)d;
    }

    public void setPipedFuelAmount(int n) {
        int n2;
        if ((n = Math.max(0, n)) != (n2 = this.getPipedFuelAmount())) {
            if (n == 0 && n2 != 0) {
                n = -1;
            }
            this.getModData().rawset((Object)"fuelAmount", (Object)n);
            this.transmitModData();
        }
    }

    private boolean isWaterInfinite() {
        if (this.sprite == null) {
            return false;
        }
        if (this.square == null || this.square.getRoom() == null) {
            return false;
        }
        if (!this.sprite.getProperties().Is(IsoFlagType.waterPiped)) {
            return false;
        }
        if (GameTime.getInstance().getNightsSurvived() >= SandboxOptions.instance.getWaterShutModifier()) {
            return false;
        }
        return !this.hasModData() || !(this.getModData().rawget((Object)"canBeWaterPiped") instanceof Boolean) || (Boolean)this.getModData().rawget((Object)"canBeWaterPiped") == false;
    }

    private IsoObject checkExternalWaterSource() {
        if (!this.usesExternalWaterSource) {
            return null;
        }
        if (this.externalWaterSource == null || !this.externalWaterSource.hasWater()) {
            this.doFindExternalWaterSource();
        }
        return this.externalWaterSource;
    }

    public int getWaterAmount() {
        Object object;
        if (this.sprite == null) {
            return 0;
        }
        if (this.usesExternalWaterSource) {
            if (this.isWaterInfinite()) {
                return 10000;
            }
            IsoObject isoObject = this.checkExternalWaterSource();
            if (isoObject == null) {
                return 0;
            }
            return isoObject.getWaterAmount();
        }
        if (this.isWaterInfinite()) {
            return 10000;
        }
        if (this.hasModData() && !this.getModData().isEmpty() && (object = this.getModData().rawget((Object)"waterAmount")) != null) {
            if (object instanceof Double) {
                return (int)Math.max(0.0, (Double)object);
            }
            if (object instanceof String) {
                return Math.max(0, Integer.parseInt((String)object));
            }
            return 0;
        }
        if (this.square != null && !this.square.getProperties().Is(IsoFlagType.water) && this.sprite != null && this.sprite.getProperties().Is(IsoFlagType.solidfloor) && this.square.getPuddlesInGround() > 0.09f) {
            return (int)(this.square.getPuddlesInGround() * 10.0f);
        }
        if (!this.sprite.Properties.Is("waterAmount")) {
            return 0;
        }
        int n = Integer.parseInt(this.sprite.getProperties().Val("waterAmount"));
        return n;
    }

    public void setWaterAmount(int n) {
        int n2;
        if (this.usesExternalWaterSource) {
            if (this.isWaterInfinite()) {
                return;
            }
            IsoObject isoObject = this.checkExternalWaterSource();
            if (isoObject != null) {
                isoObject.setWaterAmount(n);
            }
            return;
        }
        if ((n = Math.max(0, n)) != (n2 = this.getWaterAmount())) {
            boolean bl = true;
            if (this.hasModData() && !this.getModData().isEmpty()) {
                boolean bl2 = bl = this.getModData().rawget((Object)"waterAmount") == null;
            }
            if (bl) {
                this.getModData().rawset((Object)"waterMax", (Object)n2);
            }
            this.getModData().rawset((Object)"waterAmount", (Object)n);
            if (n <= 0) {
                this.setTaintedWater(false);
            }
            LuaEventManager.triggerEvent("OnWaterAmountChange", this, n2);
        }
    }

    public int getWaterMax() {
        Object object;
        if (this.sprite == null) {
            return 0;
        }
        if (this.usesExternalWaterSource) {
            if (this.isWaterInfinite()) {
                return 10000;
            }
            IsoObject isoObject = this.checkExternalWaterSource();
            if (isoObject != null) {
                return isoObject.getWaterMax();
            }
            return 0;
        }
        if (this.isWaterInfinite()) {
            return 10000;
        }
        if (this.hasModData() && !this.getModData().isEmpty() && (object = this.getModData().rawget((Object)"waterMax")) != null) {
            if (object instanceof Double) {
                return (int)Math.max(0.0, (Double)object);
            }
            if (object instanceof String) {
                return Math.max(0, Integer.parseInt((String)object));
            }
            return 0;
        }
        if (this.square != null && !this.square.getProperties().Is(IsoFlagType.water) && this.sprite != null && this.sprite.getProperties().Is(IsoFlagType.solidfloor) && this.square.getPuddlesInGround() > 0.09f) {
            return (int)(this.square.getPuddlesInGround() * 10.0f);
        }
        if (this.sprite.Properties.Is("waterMaxAmount")) {
            return Integer.parseInt(this.sprite.getProperties().Val("waterMaxAmount"));
        }
        if (this.sprite.Properties.Is("waterAmount")) {
            return Integer.parseInt(this.sprite.getProperties().Val("waterAmount"));
        }
        return 0;
    }

    public int useWater(int n) {
        if (this.sprite == null) {
            return 0;
        }
        int n2 = this.getWaterAmount();
        int n3 = 0;
        n3 = n2 >= n ? n : n2;
        if (this.square != null && this.sprite != null && this.sprite.getProperties().Is(IsoFlagType.solidfloor) && this.square.getPuddlesInGround() > 0.09f) {
            return n3;
        }
        if (!this.usesExternalWaterSource) {
            if (this.sprite.getProperties().Is(IsoFlagType.water)) {
                return n3;
            }
            if (this.isWaterInfinite()) {
                return n3;
            }
        }
        this.setWaterAmount(n2 - n3);
        return n3;
    }

    public boolean hasWater() {
        if (this.square != null && this.sprite != null && this.sprite.getProperties().Is(IsoFlagType.solidfloor) && this.square.getPuddlesInGround() > 0.09f) {
            return true;
        }
        return this.getWaterAmount() > 0;
    }

    public boolean isTaintedWater() {
        Object object;
        if (this.square != null && this.sprite != null && this.sprite.getProperties().Is(IsoFlagType.solidfloor) && this.square.getPuddlesInGround() > 0.09f) {
            return true;
        }
        if (this.hasModData() && (object = this.getModData().rawget((Object)"taintedWater")) instanceof Boolean) {
            return (Boolean)object;
        }
        return this.sprite != null && this.sprite.getProperties().Is(IsoFlagType.taintedWater);
    }

    public void setTaintedWater(boolean bl) {
        this.getModData().rawset((Object)"taintedWater", (Object)bl);
    }

    public InventoryItem replaceItem(InventoryItem inventoryItem) {
        String string = null;
        InventoryItem inventoryItem2 = null;
        if (inventoryItem != null) {
            if (inventoryItem.hasReplaceType(this.getObjectName())) {
                string = inventoryItem.getReplaceType(this.getObjectName());
            } else if (inventoryItem.hasReplaceType("WaterSource")) {
                string = inventoryItem.getReplaceType("WaterSource");
            }
        }
        if (string != null) {
            inventoryItem2 = inventoryItem.getContainer().AddItem(InventoryItemFactory.CreateItem(string));
            if (inventoryItem.getContainer().getParent() instanceof IsoGameCharacter) {
                IsoGameCharacter isoGameCharacter = (IsoGameCharacter)inventoryItem.getContainer().getParent();
                if (isoGameCharacter.getPrimaryHandItem() == inventoryItem) {
                    isoGameCharacter.setPrimaryHandItem(inventoryItem2);
                }
                if (isoGameCharacter.getSecondaryHandItem() == inventoryItem) {
                    isoGameCharacter.setSecondaryHandItem(inventoryItem2);
                }
            }
            inventoryItem.getContainer().Remove(inventoryItem);
        }
        return inventoryItem2;
    }

    @Deprecated
    public void useItemOn(InventoryItem inventoryItem) {
        String string = null;
        if (inventoryItem != null) {
            if (inventoryItem.hasReplaceType(this.getObjectName())) {
                string = inventoryItem.getReplaceType(this.getObjectName());
            } else if (inventoryItem.hasReplaceType("WaterSource")) {
                string = inventoryItem.getReplaceType("WaterSource");
                this.useWater(10);
            }
        }
        if (string != null) {
            InventoryItem inventoryItem2 = inventoryItem.getContainer().AddItem(InventoryItemFactory.CreateItem(string));
            inventoryItem.setUses(inventoryItem.getUses() - 1);
            if (inventoryItem.getUses() <= 0 && inventoryItem.getContainer() != null) {
                inventoryItem.getContainer().Items.remove(inventoryItem);
            }
        }
    }

    public float getX() {
        return this.square.getX();
    }

    public float getY() {
        return this.square.getY();
    }

    public float getZ() {
        return this.square.getZ();
    }

    public boolean onMouseLeftClick(int n, int n2) {
        return false;
    }

    public PropertyContainer getProperties() {
        if (this.sprite == null) {
            return null;
        }
        return this.sprite.getProperties();
    }

    public void RemoveAttachedAnims() {
        if (this.AttachedAnimSprite == null) {
            return;
        }
        for (int i = 0; i < this.AttachedAnimSprite.size(); ++i) {
            this.AttachedAnimSprite.get(i).Dispose();
        }
        this.AttachedAnimSprite.clear();
    }

    public void RemoveAttachedAnim(int n) {
        if (this.AttachedAnimSprite == null) {
            return;
        }
        if (n < 0 || n >= this.AttachedAnimSprite.size()) {
            return;
        }
        this.AttachedAnimSprite.get(n).Dispose();
        this.AttachedAnimSprite.remove(n);
    }

    public Vector2 getFacingPosition(Vector2 vector22) {
        if (this.square == null) {
            return vector22.set(0.0f, 0.0f);
        }
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer != null) {
            if (this.getType() == IsoObjectType.wall) {
                if (propertyContainer.Is(IsoFlagType.collideN) && propertyContainer.Is(IsoFlagType.collideW)) {
                    return vector22.set(this.getX(), this.getY());
                }
                if (propertyContainer.Is(IsoFlagType.collideN)) {
                    return vector22.set(this.getX() + 0.5f, this.getY());
                }
                if (propertyContainer.Is(IsoFlagType.collideW)) {
                    return vector22.set(this.getX(), this.getY() + 0.5f);
                }
                if (propertyContainer.Is(IsoFlagType.DoorWallN)) {
                    return vector22.set(this.getX() + 0.5f, this.getY());
                }
                if (propertyContainer.Is(IsoFlagType.DoorWallW)) {
                    return vector22.set(this.getX(), this.getY() + 0.5f);
                }
            } else {
                if (propertyContainer.Is(IsoFlagType.attachedN)) {
                    return vector22.set(this.getX() + 0.5f, this.getY());
                }
                if (propertyContainer.Is(IsoFlagType.attachedS)) {
                    return vector22.set(this.getX() + 0.5f, this.getY() + 1.0f);
                }
                if (propertyContainer.Is(IsoFlagType.attachedW)) {
                    return vector22.set(this.getX(), this.getY() + 0.5f);
                }
                if (propertyContainer.Is(IsoFlagType.attachedE)) {
                    return vector22.set(this.getX() + 1.0f, this.getY() + 0.5f);
                }
            }
        }
        return vector22.set(this.getX() + 0.5f, this.getY() + 0.5f);
    }

    public Vector2 getFacingPositionAlt(Vector2 vector22) {
        return this.getFacingPosition(vector22);
    }

    public float getRenderYOffset() {
        return this.renderYOffset;
    }

    public void setRenderYOffset(float f) {
        this.renderYOffset = f;
        this.sx = 0.0f;
    }

    public boolean isTableSurface() {
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer != null) {
            return propertyContainer.isTable();
        }
        return false;
    }

    public boolean isTableTopObject() {
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer != null) {
            return propertyContainer.isTableTop();
        }
        return false;
    }

    public boolean getIsSurfaceNormalOffset() {
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer != null) {
            return propertyContainer.isSurfaceOffset();
        }
        return false;
    }

    public float getSurfaceNormalOffset() {
        float f = 0.0f;
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer.isSurfaceOffset()) {
            f = propertyContainer.getSurface();
        }
        return f;
    }

    public float getSurfaceOffsetNoTable() {
        float f = 0.0f;
        int n = 0;
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer != null) {
            f = propertyContainer.getSurface();
            n = propertyContainer.getItemHeight();
        }
        return f + this.getRenderYOffset() + (float)n;
    }

    public float getSurfaceOffset() {
        PropertyContainer propertyContainer;
        float f = 0.0f;
        if (this.isTableSurface() && (propertyContainer = this.getProperties()) != null) {
            f = propertyContainer.getSurface();
        }
        return f;
    }

    public boolean isStairsNorth() {
        return this.getType() == IsoObjectType.stairsTN || this.getType() == IsoObjectType.stairsMN || this.getType() == IsoObjectType.stairsBN;
    }

    public boolean isStairsWest() {
        return this.getType() == IsoObjectType.stairsTW || this.getType() == IsoObjectType.stairsMW || this.getType() == IsoObjectType.stairsBW;
    }

    public boolean isStairsObject() {
        return this.isStairsNorth() || this.isStairsWest();
    }

    public boolean isHoppable() {
        return this.sprite != null && (this.sprite.getProperties().Is(IsoFlagType.HoppableN) || this.sprite.getProperties().Is(IsoFlagType.HoppableW));
    }

    public boolean isNorthHoppable() {
        return this.sprite != null && this.isHoppable() && this.sprite.getProperties().Is(IsoFlagType.HoppableN);
    }

    public boolean haveSheetRope() {
        return IsoWindow.isTopOfSheetRopeHere(this.square, this.isNorthHoppable());
    }

    public int countAddSheetRope() {
        return IsoWindow.countAddSheetRope(this.square, this.isNorthHoppable());
    }

    public boolean canAddSheetRope() {
        return IsoWindow.canAddSheetRope(this.square, this.isNorthHoppable());
    }

    public boolean addSheetRope(IsoPlayer isoPlayer, String string) {
        if (!this.canAddSheetRope()) {
            return false;
        }
        return IsoWindow.addSheetRope(isoPlayer, this.square, this.isNorthHoppable(), string);
    }

    public boolean removeSheetRope(IsoPlayer isoPlayer) {
        if (this.haveSheetRope()) {
            return IsoWindow.removeSheetRope(isoPlayer, this.square, this.isNorthHoppable());
        }
        return false;
    }

    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        Texture texture;
        float f4;
        float f5;
        float f6;
        int n;
        if (this.isSpriteInvisible()) {
            return;
        }
        this.prepareToRender(colorInfo);
        int n2 = IsoCamera.frameState.playerIndex;
        if (this.shouldDrawMainSprite()) {
            this.sprite.render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, stCol, !this.isBlink());
            if (this.isOutlineHighlight(n2) && !this.isOutlineHlAttached(n2) && OutlineShader.instance.StartShader()) {
                n = this.outlineHighlightCol[n2];
                f6 = Color.getRedChannelFromABGR(n);
                f5 = Color.getGreenChannelFromABGR(n);
                f4 = Color.getBlueChannelFromABGR(n);
                OutlineShader.instance.setOutlineColor(f6, f5, f4, this.isOutlineHlBlink(n2) ? Core.blinkAlpha : 1.0f);
                texture = this.sprite.getTextureForCurrentFrame(this.dir);
                if (texture != null) {
                    OutlineShader.instance.setStepSize(this.outlineThickness, texture.getWidth(), texture.getHeight());
                }
                this.sprite.render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, stCol, !this.isBlink());
                IndieGL.EndShader();
            }
        }
        this.renderAttachedAndOverlaySpritesInternal(f, f2, f3, colorInfo, bl, bl2, shader, null);
        if (this.isOutlineHighlight(n2) && this.isOutlineHlAttached(n2) && OutlineShader.instance.StartShader()) {
            n = this.outlineHighlightCol[n2];
            f6 = Color.getRedChannelFromABGR(n);
            f5 = Color.getGreenChannelFromABGR(n);
            f4 = Color.getBlueChannelFromABGR(n);
            OutlineShader.instance.setOutlineColor(f6, f5, f4, this.isOutlineHlBlink(n2) ? Core.blinkAlpha : 1.0f);
            texture = this.sprite.getTextureForCurrentFrame(this.dir);
            if (texture != null) {
                OutlineShader.instance.setStepSize(this.outlineThickness, texture.getWidth(), texture.getHeight());
            }
            if (this.shouldDrawMainSprite()) {
                this.sprite.render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, stCol, !this.isBlink());
            }
            this.renderAttachedAndOverlaySpritesInternal(f, f2, f3, colorInfo, bl, bl2, shader, null);
            IndieGL.EndShader();
        }
        if (!this.bAlphaForced && this.isUpdateAlphaDuringRender()) {
            this.updateAlpha(n2);
        }
        this.debugRenderItemHeight(f, f2, f3);
        this.debugRenderSurface(f, f2, f3);
    }

    private void debugRenderItemHeight(float f, float f2, float f3) {
        if (!DebugOptions.instance.IsoSprite.ItemHeight.getValue()) {
            return;
        }
        if (this.square == null || IsoCamera.frameState.CamCharacterSquare == null || this.square.z != IsoCamera.frameState.CamCharacterSquare.z) {
            return;
        }
        int n = this.sprite.getProperties().getItemHeight();
        if (n > 0) {
            int n2 = 0;
            if (this.sprite != null && this.sprite.getProperties().getSurface() > 0 && this.sprite.getProperties().isSurfaceOffset()) {
                n2 = this.sprite.getProperties().getSurface();
            }
            LineDrawer.addRectYOffset(f, f2, f3, 1.0f, 1.0f, (int)this.getRenderYOffset() + n2 + n, 0.66f, 0.66f, 0.66f);
        }
    }

    private void debugRenderSurface(float f, float f2, float f3) {
        if (!DebugOptions.instance.IsoSprite.Surface.getValue()) {
            return;
        }
        if (this.square == null || IsoCamera.frameState.CamCharacterSquare == null || this.square.z != IsoCamera.frameState.CamCharacterSquare.z) {
            return;
        }
        int n = 0;
        if (this.sprite != null && this.sprite.getProperties().getSurface() > 0 && !this.sprite.getProperties().isSurfaceOffset()) {
            n = this.sprite.getProperties().getSurface();
        }
        if (n > 0) {
            LineDrawer.addRectYOffset(f, f2, f3, 1.0f, 1.0f, (int)this.getRenderYOffset() + n, 1.0f, 1.0f, 1.0f);
        }
    }

    public void renderFloorTile(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader, Consumer<TextureDraw> consumer, Consumer<TextureDraw> consumer2) {
        if (this.isSpriteInvisible()) {
            return;
        }
        this.prepareToRender(colorInfo);
        FloorShaper floorShaper = Type.tryCastTo(consumer, FloorShaper.class);
        FloorShaper floorShaper2 = Type.tryCastTo(consumer2, FloorShaper.class);
        if ((floorShaper != null || floorShaper2 != null) && this.isHighlighted() && this.getHighlightColor() != null) {
            ColorInfo colorInfo2 = this.getHighlightColor();
            float f4 = colorInfo2.a * (this.isBlink() ? Core.blinkAlpha : 1.0f);
            int n = Color.colorToABGR(colorInfo2.r, colorInfo2.g, colorInfo2.b, f4);
            if (floorShaper != null) {
                floorShaper.setTintColor(n);
            }
            if (floorShaper2 != null) {
                floorShaper2.setTintColor(n);
            }
        }
        if (this.shouldDrawMainSprite()) {
            IndieGL.shaderSetValue(shader, "floorLayer", 0);
            this.sprite.render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, stCol, !this.isBlink(), consumer);
        }
        this.renderAttachedAndOverlaySpritesInternal(f, f2, f3, colorInfo, bl, bl2, shader, consumer2);
        if (floorShaper != null) {
            floorShaper.setTintColor(0);
        }
        if (floorShaper2 != null) {
            floorShaper2.setTintColor(0);
        }
    }

    public void renderWallTile(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader, Consumer<TextureDraw> consumer) {
        if (this.isSpriteInvisible()) {
            return;
        }
        this.renderWallTileOnly(f, f2, f3, colorInfo, shader, consumer);
        this.renderAttachedAndOverlaySpritesInternal(f, f2, f3, colorInfo, bl, bl2, shader, consumer);
        int n = IsoCamera.frameState.playerIndex;
        if (this.isOutlineHighlight(n) && !this.isOutlineHlAttached(n) && OutlineShader.instance.StartShader()) {
            int n2 = this.outlineHighlightCol[n];
            float f4 = Color.getRedChannelFromABGR(n2);
            float f5 = Color.getGreenChannelFromABGR(n2);
            float f6 = Color.getBlueChannelFromABGR(n2);
            OutlineShader.instance.setOutlineColor(f4, f5, f6, this.isOutlineHlBlink(n) ? Core.blinkAlpha : 1.0f);
            Texture texture = this.sprite.getTextureForCurrentFrame(this.dir);
            if (texture != null) {
                OutlineShader.instance.setStepSize(this.outlineThickness, texture.getWidth(), texture.getHeight());
            }
            this.sprite.render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, stCol, !this.isBlink());
            IndieGL.EndShader();
        }
    }

    public void renderWallTileOnly(float f, float f2, float f3, ColorInfo colorInfo, Shader shader, Consumer<TextureDraw> consumer) {
        if (this.isSpriteInvisible()) {
            return;
        }
        this.prepareToRender(colorInfo);
        WallShaper wallShaper = Type.tryCastTo(consumer, WallShaper.class);
        if (wallShaper != null && this.isHighlighted() && this.getHighlightColor() != null) {
            ColorInfo colorInfo2 = this.getHighlightColor();
            float f4 = colorInfo2.a * (this.isBlink() ? Core.blinkAlpha : 1.0f);
            int n = Color.colorToABGR(colorInfo2.r, colorInfo2.g, colorInfo2.b, f4);
            wallShaper.setTintColor(n);
        }
        if (this.shouldDrawMainSprite()) {
            IndieGL.pushShader(shader);
            this.sprite.render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, stCol, !this.isBlink(), consumer);
            IndieGL.popShader(shader);
        }
        if (wallShaper != null) {
            wallShaper.setTintColor(0);
        }
    }

    private boolean shouldDrawMainSprite() {
        if (this.sprite == null) {
            return false;
        }
        return DebugOptions.instance.Terrain.RenderTiles.RenderSprites.getValue();
    }

    public void renderAttachedAndOverlaySprites(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader, Consumer<TextureDraw> consumer) {
        if (this.isSpriteInvisible()) {
            return;
        }
        this.renderAttachedAndOverlaySpritesInternal(f, f2, f3, colorInfo, bl, bl2, shader, consumer);
    }

    private void renderAttachedAndOverlaySpritesInternal(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader, Consumer<TextureDraw> consumer) {
        if (this.isHighlighted()) {
            colorInfo = stCol;
        }
        this.renderOverlaySprites(f, f2, f3, colorInfo);
        if (bl) {
            this.renderAttachedSprites(f, f2, f3, colorInfo, bl2, shader, consumer);
        }
    }

    private void prepareToRender(ColorInfo colorInfo) {
        float f;
        float f2;
        float f3;
        stCol.set(colorInfo);
        if (this.isHighlighted()) {
            stCol.set(this.getHighlightColor());
            IsoObject.stCol.a = this.isBlink() ? Core.blinkAlpha : 1.0f;
            IsoObject.stCol.r = colorInfo.r * (1.0f - IsoObject.stCol.a) + this.getHighlightColor().r * IsoObject.stCol.a;
            IsoObject.stCol.g = colorInfo.g * (1.0f - IsoObject.stCol.a) + this.getHighlightColor().g * IsoObject.stCol.a;
            IsoObject.stCol.b = colorInfo.b * (1.0f - IsoObject.stCol.a) + this.getHighlightColor().b * IsoObject.stCol.a;
            IsoObject.stCol.a = colorInfo.a;
        }
        if (this.customColor != null) {
            float f4 = f3 = this.square != null ? this.square.getDarkMulti(IsoPlayer.getPlayerIndex()) : 1.0f;
            if (this.isHighlighted()) {
                IsoObject.stCol.r *= this.customColor.r * f3;
                IsoObject.stCol.g *= this.customColor.g * f3;
                IsoObject.stCol.b *= this.customColor.b * f3;
            } else {
                IsoObject.stCol.r = this.customColor.r * f3;
                IsoObject.stCol.g = this.customColor.g * f3;
                IsoObject.stCol.b = this.customColor.b * f3;
            }
        }
        if (this.sprite != null && this.sprite.forceAmbient) {
            f3 = rmod * this.tintr;
            f2 = gmod * this.tintg;
            f = bmod * this.tintb;
            if (!this.isHighlighted()) {
                IsoObject.stCol.r = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * f3;
                IsoObject.stCol.g = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * f2;
                IsoObject.stCol.b = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * f;
            }
        }
        int n = IsoPlayer.getPlayerIndex();
        f2 = IsoCamera.frameState.CamCharacterX;
        f = IsoCamera.frameState.CamCharacterY;
        float f5 = IsoCamera.frameState.CamCharacterZ;
        if (IsoWorld.instance.CurrentCell.IsPlayerWindowPeeking(n)) {
            IsoPlayer isoPlayer = IsoPlayer.players[n];
            IsoDirections isoDirections = IsoDirections.fromAngle(isoPlayer.getForwardDirection());
            if (isoDirections == IsoDirections.N || isoDirections == IsoDirections.NW) {
                f = (float)((double)f - 1.0);
            }
            if (isoDirections == IsoDirections.W || isoDirections == IsoDirections.NW) {
                f2 = (float)((double)f2 - 1.0);
            }
        }
        if (this == IsoCamera.CamCharacter) {
            this.setAlphaAndTarget(n, 1.0f);
        }
        lastRenderedRendered = lastRendered;
        lastRendered = this;
        if (this.sprite != null && !(this instanceof IsoPhysicsObject) && IsoCamera.CamCharacter != null) {
            boolean bl;
            boolean bl2 = bl = this instanceof IsoWindow || this.sprite.getType() == IsoObjectType.doorW || this.sprite.getType() == IsoObjectType.doorN;
            if (this.sprite.getProperties().Is("GarageDoor")) {
                bl = false;
            }
            if (!bl && ((float)this.square.getX() > f2 || (float)this.square.getY() > f) && (int)f5 <= this.square.getZ()) {
                boolean bl3;
                boolean bl4 = false;
                float f6 = 0.2f;
                boolean bl5 = (this.sprite.cutW || this.sprite.getProperties().Is(IsoFlagType.doorW)) && (float)this.square.getX() > f2;
                boolean bl6 = bl3 = (this.sprite.cutN || this.sprite.getProperties().Is(IsoFlagType.doorN)) && (float)this.square.getY() > f;
                if (bl5 && this.square.getProperties().Is(IsoFlagType.WallSE) && (float)this.square.getY() <= f) {
                    bl5 = false;
                }
                if (bl5 || bl3) {
                    bl4 = true;
                } else {
                    boolean bl7;
                    boolean bl8 = this.getType() == IsoObjectType.WestRoofB || this.getType() == IsoObjectType.WestRoofM || this.getType() == IsoObjectType.WestRoofT;
                    boolean bl9 = bl7 = bl8 && (int)f5 == this.square.getZ() && this.square.getBuilding() == null;
                    if (bl7 && IsoWorld.instance.CurrentCell.CanBuildingSquareOccludePlayer(this.square, n)) {
                        bl4 = true;
                        f6 = 0.05f;
                    }
                }
                if (this.sprite.getProperties().Is(IsoFlagType.halfheight)) {
                    bl4 = false;
                }
                if (bl4) {
                    if (bl3 && this.sprite.getProperties().Is(IsoFlagType.HoppableN)) {
                        f6 = 0.25f;
                    }
                    if (bl5 && this.sprite.getProperties().Is(IsoFlagType.HoppableW)) {
                        f6 = 0.25f;
                    }
                    if (this.bAlphaForced) {
                        if (this.getTargetAlpha(n) == 1.0f) {
                            this.setAlphaAndTarget(n, 0.99f);
                        }
                    } else {
                        this.setTargetAlpha(n, f6);
                    }
                    LowLightingQualityHack = true;
                    this.NoPicking = this.rerouteMask == null && !(this instanceof IsoThumpable) && !IsoWindowFrame.isWindowFrame(this) && !this.sprite.getProperties().Is(IsoFlagType.doorN) && !this.sprite.getProperties().Is(IsoFlagType.doorW) && !this.sprite.getProperties().Is(IsoFlagType.HoppableN) && !this.sprite.getProperties().Is(IsoFlagType.HoppableW);
                } else {
                    this.NoPicking = false;
                }
            } else {
                this.NoPicking = false;
            }
        }
        if (this == IsoCamera.CamCharacter) {
            this.setTargetAlpha(n, 1.0f);
        }
    }

    protected float getAlphaUpdateRateDiv() {
        float f = 14.0f;
        return f;
    }

    protected float getAlphaUpdateRateMul() {
        float f = 0.25f;
        if (this.square != null && this.square.room != null) {
            f *= 2.0f;
        }
        return f;
    }

    protected boolean isUpdateAlphaEnabled() {
        return true;
    }

    protected boolean isUpdateAlphaDuringRender() {
        return true;
    }

    protected final void updateAlpha() {
        if (GameServer.bServer) {
            return;
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            if (IsoPlayer.players[i] == null) continue;
            this.updateAlpha(i);
        }
    }

    protected final void updateAlpha(int n) {
        if (GameServer.bServer) {
            return;
        }
        float f = this.getAlphaUpdateRateMul();
        float f2 = this.getAlphaUpdateRateDiv();
        this.updateAlpha(n, f, f2);
    }

    protected void updateAlpha(int n, float f, float f2) {
        float f3;
        if (!this.isUpdateAlphaEnabled()) {
            return;
        }
        if (!DebugOptions.instance.Character.Debug.UpdateAlpha.getValue()) {
            this.setAlphaToTarget(n);
            return;
        }
        if (this.bNeverDoneAlpha) {
            this.setAlpha(0.0f);
            this.bNeverDoneAlpha = false;
        }
        if (DebugOptions.instance.Character.Debug.UpdateAlphaEighthSpeed.getValue()) {
            f /= 8.0f;
            f2 *= 8.0f;
        }
        float f4 = GameTime.getInstance().getMultiplier();
        float f5 = f4 * 0.28f;
        float f6 = this.getAlpha(n);
        if (f6 < (f3 = this.targetAlpha[n])) {
            if ((f6 += f5 * f) > f3) {
                f6 = f3;
            }
        } else if (f6 > f3 && (f6 -= f5 / f2) < f3) {
            f6 = f3;
        }
        this.setAlpha(n, f6);
    }

    private void renderOverlaySprites(float f, float f2, float f3, ColorInfo colorInfo) {
        if (this.getOverlaySprite() == null || !DebugOptions.instance.Terrain.RenderTiles.OverlaySprites.getValue()) {
            return;
        }
        ColorInfo colorInfo2 = stCol2;
        colorInfo2.set(colorInfo);
        if (this.overlaySpriteColor != null) {
            colorInfo2.set(this.overlaySpriteColor);
        }
        if (colorInfo2.a != 1.0f && this.overlaySprite.def != null && this.overlaySprite.def.bCopyTargetAlpha) {
            int n = IsoPlayer.getPlayerIndex();
            float f4 = this.alpha[n];
            int n2 = n;
            this.alpha[n2] = this.alpha[n2] * colorInfo2.a;
            this.getOverlaySprite().render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, colorInfo2, true);
            this.alpha[n] = f4;
        } else {
            this.getOverlaySprite().render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, colorInfo2, true);
        }
    }

    private void renderAttachedSprites(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, Shader shader, Consumer<TextureDraw> wallShaperWhole) {
        Object object;
        int n;
        int n2;
        if (this.AttachedAnimSprite != null && DebugOptions.instance.Terrain.RenderTiles.AttachedAnimSprites.getValue()) {
            n2 = this.AttachedAnimSprite.size();
            for (n = 0; n < n2; ++n) {
                object = this.AttachedAnimSprite.get(n);
                if (bl && ((IsoSpriteInstance)object).parentSprite.Properties.Is(IsoFlagType.NoWallLighting)) continue;
                float f4 = colorInfo.a;
                IndieGL.shaderSetValue(shader, "floorLayer", 1);
                colorInfo.a = ((IsoSpriteInstance)object).alpha;
                WallShaperWhole wallShaperWhole2 = wallShaperWhole;
                if (wallShaperWhole == WallShaperW.instance) {
                    Texture texture;
                    if (((IsoSpriteInstance)object).parentSprite.getProperties().Is(IsoFlagType.attachedN) && (texture = ((IsoSpriteInstance)object).parentSprite.getTextureForCurrentFrame(this.dir)) != null && texture.getWidth() < 32 * Core.TileScale) continue;
                    if (((IsoSpriteInstance)object).parentSprite.getProperties().Is(IsoFlagType.attachedW)) {
                        wallShaperWhole2 = WallShaperWhole.instance;
                    }
                } else if (wallShaperWhole == WallShaperN.instance) {
                    if (((IsoSpriteInstance)object).parentSprite.getProperties().Is(IsoFlagType.attachedW)) continue;
                    if (((IsoSpriteInstance)object).parentSprite.getProperties().Is(IsoFlagType.attachedN)) {
                        wallShaperWhole2 = WallShaperWhole.instance;
                    }
                }
                ((IsoSpriteInstance)object).parentSprite.render((IsoSpriteInstance)object, this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, colorInfo, true, wallShaperWhole2);
                colorInfo.a = f4;
                ((IsoSpriteInstance)object).update();
            }
        }
        if (this.Children != null && DebugOptions.instance.Terrain.RenderTiles.AttachedChildren.getValue()) {
            n2 = this.Children.size();
            for (n = 0; n < n2; ++n) {
                object = this.Children.get(n);
                if (!(object instanceof IsoMovingObject)) continue;
                IndieGL.shaderSetValue(shader, "floorLayer", 1);
                ((IsoObject)object).render(((IsoMovingObject)object).x, ((IsoMovingObject)object).y, ((IsoMovingObject)object).z, colorInfo, true, false, null);
            }
        }
        if (this.wallBloodSplats != null && DebugOptions.instance.Terrain.RenderTiles.AttachedWallBloodSplats.getValue()) {
            if (Core.OptionBloodDecals == 0) {
                return;
            }
            IndieGL.shaderSetValue(shader, "floorLayer", 0);
            for (n2 = 0; n2 < this.wallBloodSplats.size(); ++n2) {
                this.wallBloodSplats.get(n2).render(f, f2, f3, colorInfo);
            }
        }
    }

    public boolean isSpriteInvisible() {
        return this.sprite != null && this.sprite.getProperties().Is(IsoFlagType.invisible);
    }

    public void renderFxMask(float f, float f2, float f3, boolean bl) {
        if (this.sprite != null) {
            if (this.getType() == IsoObjectType.wall) {
                // empty if block
            }
            this.sprite.render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, colFxMask, false);
        }
        if (this.getOverlaySprite() != null) {
            this.getOverlaySprite().render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, colFxMask, false);
        }
        if (bl) {
            Object object;
            int n;
            int n2;
            if (this.AttachedAnimSprite != null) {
                n2 = this.AttachedAnimSprite.size();
                for (n = 0; n < n2; ++n) {
                    object = this.AttachedAnimSprite.get(n);
                    ((IsoSpriteInstance)object).render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY + this.renderYOffset * (float)Core.TileScale, colFxMask);
                }
            }
            if (this.Children != null) {
                n2 = this.Children.size();
                for (n = 0; n < n2; ++n) {
                    object = this.Children.get(n);
                    if (!(object instanceof IsoMovingObject)) continue;
                    ((IsoObject)object).render(((IsoMovingObject)object).x, ((IsoMovingObject)object).y, ((IsoMovingObject)object).z, colFxMask, bl, false, null);
                }
            }
            if (this.wallBloodSplats != null) {
                if (Core.OptionBloodDecals == 0) {
                    return;
                }
                for (n2 = 0; n2 < this.wallBloodSplats.size(); ++n2) {
                    this.wallBloodSplats.get(n2).render(f, f2, f3, colFxMask);
                }
            }
        }
    }

    public void renderObjectPicker(float f, float f2, float f3, ColorInfo colorInfo) {
        if (this.sprite == null) {
            return;
        }
        if (this.sprite.getProperties().Is(IsoFlagType.invisible)) {
            return;
        }
        this.sprite.renderObjectPicker(this.sprite.def, this, this.dir);
    }

    public boolean TestPathfindCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        return false;
    }

    public boolean TestCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        return false;
    }

    public VisionResult TestVision(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        return VisionResult.Unblocked;
    }

    Texture getCurrentFrameTex() {
        if (this.sprite == null) {
            return null;
        }
        if (this.sprite.CurrentAnim == null) {
            return null;
        }
        if ((float)this.sprite.CurrentAnim.Frames.size() <= this.sprite.def.Frame) {
            return null;
        }
        return this.sprite.CurrentAnim.Frames.get((int)this.sprite.def.Frame).getTexture(this.dir);
    }

    public boolean isMaskClicked(int n, int n2) {
        if (this.sprite == null) {
            return false;
        }
        return this.sprite.isMaskClicked(this.dir, n, n2);
    }

    public boolean isMaskClicked(int n, int n2, boolean bl) {
        if (this.sprite == null) {
            return false;
        }
        if (this.overlaySprite != null && this.overlaySprite.isMaskClicked(this.dir, n, n2, bl)) {
            return true;
        }
        return this.sprite.isMaskClicked(this.dir, n, n2, bl);
    }

    public float getMaskClickedY(int n, int n2, boolean bl) {
        if (this.sprite == null) {
            return 10000.0f;
        }
        return this.sprite.getMaskClickedY(this.dir, n, n2, bl);
    }

    public ColorInfo getCustomColor() {
        return this.customColor;
    }

    public void setCustomColor(ColorInfo colorInfo) {
        this.customColor = colorInfo;
    }

    public void setCustomColor(float f, float f2, float f3, float f4) {
        ColorInfo colorInfo;
        this.customColor = colorInfo = new ColorInfo(f, f2, f3, f4);
    }

    public void loadFromRemoteBuffer(ByteBuffer byteBuffer) {
        this.loadFromRemoteBuffer(byteBuffer, true);
    }

    public void loadFromRemoteBuffer(ByteBuffer byteBuffer, boolean bl) {
        int n;
        try {
            this.load(byteBuffer, 195);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (this instanceof IsoWorldInventoryObject && ((IsoWorldInventoryObject)this).getItem() == null) {
            DebugLog.log("loadFromRemoteBuffer() failed due to an unknown item type");
            return;
        }
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.getInt();
        boolean bl2 = byteBuffer.get() != 0;
        boolean bl3 = byteBuffer.get() != 0;
        IsoWorld.instance.CurrentCell.EnsureSurroundNotNull(n2, n3, n4);
        this.square = IsoWorld.instance.CurrentCell.getGridSquare(n2, n3, n4);
        if (this.square == null) {
            return;
        }
        if (GameServer.bServer && !(this instanceof IsoWorldInventoryObject)) {
            IsoRegions.setPreviousFlags(this.square);
        }
        if (bl2) {
            this.square.getSpecialObjects().add(this);
        }
        if (bl3 && this instanceof IsoWorldInventoryObject) {
            this.square.getWorldObjects().add((IsoWorldInventoryObject)this);
            this.square.chunk.recalcHashCodeObjects();
        }
        if (bl) {
            if (n5 != -1 && n5 >= 0 && n5 <= this.square.getObjects().size()) {
                this.square.getObjects().add(n5, this);
            } else {
                this.square.getObjects().add(this);
            }
        }
        for (n = 0; n < this.getContainerCount(); ++n) {
            ItemContainer itemContainer = this.getContainerByIndex(n);
            itemContainer.parent = this;
            itemContainer.parent.square = this.square;
            itemContainer.SourceGrid = this.square;
        }
        for (n = -1; n <= 1; ++n) {
            for (int i = -1; i <= 1; ++i) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n + n2, i + n3, n4);
                if (isoGridSquare == null) continue;
                isoGridSquare.RecalcAllWithNeighbours(true);
            }
        }
    }

    protected boolean hasObjectAmbientEmitter() {
        IsoChunk isoChunk = this.getChunk();
        if (isoChunk == null) {
            return false;
        }
        return isoChunk.hasObjectAmbientEmitter(this);
    }

    protected void addObjectAmbientEmitter(ObjectAmbientEmitters.PerObjectLogic perObjectLogic) {
        IsoChunk isoChunk = this.getChunk();
        if (isoChunk == null) {
            return;
        }
        isoChunk.addObjectAmbientEmitter(this, perObjectLogic);
    }

    public void addToWorld() {
        ItemContainer itemContainer;
        for (int i = 0; i < this.getContainerCount(); ++i) {
            itemContainer = this.getContainerByIndex(i);
            itemContainer.addItemsToProcessItems();
        }
        if (GameServer.bServer) {
            return;
        }
        String string = null;
        itemContainer = this.getContainerByEitherType("fridge", "freezer");
        if (itemContainer != null && itemContainer.isPowered()) {
            this.addObjectAmbientEmitter(new ObjectAmbientEmitters.FridgeHumLogic().init(this));
            string = "FridgeHum";
            IsoWorld.instance.getCell().addToProcessIsoObject(this);
        } else if (this.sprite != null && this.sprite.getProperties().Is(IsoFlagType.waterPiped) && (float)this.getWaterAmount() > 0.0f && Rand.Next(15) == 0) {
            this.addObjectAmbientEmitter(new ObjectAmbientEmitters.WaterDripLogic().init(this));
            string = "WaterDrip";
        } else if (this.sprite != null && this.sprite.getName() != null && this.sprite.getName().startsWith("camping_01") && (this.sprite.tileSheetIndex == 0 || this.sprite.tileSheetIndex == 3)) {
            this.addObjectAmbientEmitter(new ObjectAmbientEmitters.TentAmbianceLogic().init(this));
            string = "TentAmbiance";
        } else if (this instanceof IsoDoor) {
            if (((IsoDoor)this).isExterior()) {
                this.addObjectAmbientEmitter(new ObjectAmbientEmitters.DoorLogic().init(this));
            }
        } else if (this instanceof IsoWindow) {
            if (((IsoWindow)this).isExterior()) {
                this.addObjectAmbientEmitter(new ObjectAmbientEmitters.WindowLogic().init(this));
            }
        } else if (this instanceof IsoTree && Rand.Next(40) == 0) {
            this.addObjectAmbientEmitter(new ObjectAmbientEmitters.TreeAmbianceLogic().init(this));
            string = "TreeAmbiance";
        }
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer != null && propertyContainer.Is("AmbientSound")) {
            this.addObjectAmbientEmitter(new ObjectAmbientEmitters.AmbientSoundLogic().init(this));
            string = propertyContainer.Val("AmbientSound");
        }
        this.checkMoveWithWind();
    }

    public void removeFromWorld() {
        IsoCell isoCell = this.getCell();
        isoCell.addToProcessIsoObjectRemove(this);
        isoCell.getStaticUpdaterObjectList().remove(this);
        for (int i = 0; i < this.getContainerCount(); ++i) {
            ItemContainer itemContainer = this.getContainerByIndex(i);
            itemContainer.removeItemsFromProcessItems();
        }
        if (this.emitter != null) {
            this.emitter.stopAll();
            this.emitter = null;
        }
        if (this.getChunk() != null) {
            this.getChunk().removeObjectAmbientEmitter(this);
        }
    }

    public void reuseGridSquare() {
    }

    public void removeFromSquare() {
        if (this.square != null) {
            this.square.getObjects().remove(this);
            this.square.getSpecialObjects().remove(this);
        }
    }

    public void transmitCustomColor() {
        if (GameClient.bClient && this.getCustomColor() != null) {
            GameClient.instance.sendCustomColor(this);
        }
    }

    public void transmitCompleteItemToClients() {
        if (GameServer.bServer) {
            if (GameServer.udpEngine == null) {
                return;
            }
            if (SystemDisabler.doWorldSyncEnable) {
                for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                    UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                    if (!udpConnection.RelevantTo(this.square.x, this.square.y)) continue;
                    GameServer.SyncObjectChunkHashes(this.square.chunk, udpConnection);
                }
                return;
            }
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                if (udpConnection == null || this.square == null || !udpConnection.RelevantTo(this.square.x, this.square.y)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AddItemToMap.doPacket(byteBufferWriter);
                this.writeToRemoteBuffer(byteBufferWriter);
                PacketTypes.PacketType.AddItemToMap.send(udpConnection);
            }
        }
    }

    public void transmitUpdatedSpriteToClients(UdpConnection udpConnection) {
        if (GameServer.bServer) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2 == null || this.square == null || udpConnection != null && udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || !udpConnection2.RelevantTo(this.square.x, this.square.y)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.UpdateItemSprite.doPacket(byteBufferWriter);
                byteBufferWriter.putInt(this.getSprite().ID);
                GameWindow.WriteStringUTF(byteBufferWriter.bb, this.spriteName);
                byteBufferWriter.putInt(this.getSquare().getX());
                byteBufferWriter.putInt(this.getSquare().getY());
                byteBufferWriter.putInt(this.getSquare().getZ());
                byteBufferWriter.putInt(this.getSquare().getObjects().indexOf(this));
                if (this.AttachedAnimSprite != null) {
                    byteBufferWriter.putByte((byte)this.AttachedAnimSprite.size());
                    for (int j = 0; j < this.AttachedAnimSprite.size(); ++j) {
                        IsoSpriteInstance isoSpriteInstance = this.AttachedAnimSprite.get(j);
                        byteBufferWriter.putInt(isoSpriteInstance.parentSprite.ID);
                    }
                } else {
                    byteBufferWriter.putByte((byte)0);
                }
                PacketTypes.PacketType.UpdateItemSprite.send(udpConnection2);
            }
        }
    }

    public void transmitUpdatedSpriteToClients() {
        this.transmitUpdatedSpriteToClients(null);
    }

    public void transmitUpdatedSprite() {
        if (GameClient.bClient) {
            this.transmitUpdatedSpriteToServer();
        }
        if (GameServer.bServer) {
            this.transmitUpdatedSpriteToClients();
        }
    }

    public void sendObjectChange(String string) {
        if (GameServer.bServer) {
            GameServer.sendObjectChange(this, string, null);
        } else if (GameClient.bClient) {
            DebugLog.log("sendObjectChange() can only be called on the server");
        } else {
            SinglePlayerServer.sendObjectChange(this, string, null);
        }
    }

    public void sendObjectChange(String string, KahluaTable kahluaTable) {
        if (GameServer.bServer) {
            GameServer.sendObjectChange(this, string, kahluaTable);
        } else if (GameClient.bClient) {
            DebugLog.log("sendObjectChange() can only be called on the server");
        } else {
            SinglePlayerServer.sendObjectChange(this, string, kahluaTable);
        }
    }

    public void sendObjectChange(String string, Object ... objectArray) {
        if (GameServer.bServer) {
            GameServer.sendObjectChange(this, string, objectArray);
        } else if (GameClient.bClient) {
            DebugLog.log("sendObjectChange() can only be called on the server");
        } else {
            SinglePlayerServer.sendObjectChange(this, string, objectArray);
        }
    }

    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("containers".equals(string)) {
            byteBuffer.put((byte)this.getContainerCount());
            for (int i = 0; i < this.getContainerCount(); ++i) {
                ItemContainer itemContainer = this.getContainerByIndex(i);
                try {
                    itemContainer.save(byteBuffer);
                    continue;
                }
                catch (Throwable throwable) {
                    ExceptionLogger.logException(throwable);
                }
            }
        } else if ("container.customTemperature".equals(string)) {
            if (this.getContainer() != null) {
                byteBuffer.putFloat(this.getContainer().getCustomTemperature());
            } else {
                byteBuffer.putFloat(0.0f);
            }
        } else if ("name".equals(string)) {
            GameWindow.WriteStringUTF(byteBuffer, this.getName());
        } else if ("replaceWith".equals(string)) {
            if (kahluaTable != null && kahluaTable.rawget((Object)"object") instanceof IsoObject) {
                IsoObject isoObject = (IsoObject)kahluaTable.rawget((Object)"object");
                try {
                    isoObject.save(byteBuffer);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else if ("usesExternalWaterSource".equals(string)) {
            boolean bl = kahluaTable != null && Boolean.TRUE.equals(kahluaTable.rawget((Object)"value"));
            byteBuffer.put(bl ? (byte)1 : 0);
        } else if ("sprite".equals(string)) {
            if (this.sprite == null) {
                byteBuffer.putInt(0);
            } else {
                byteBuffer.putInt(this.sprite.ID);
                GameWindow.WriteStringUTF(byteBuffer, this.spriteName);
            }
        }
    }

    public void loadChange(String string, ByteBuffer byteBuffer) {
        block28: {
            if ("containers".equals(string)) {
                int n;
                for (n = 0; n < this.getContainerCount(); ++n) {
                    ItemContainer itemContainer = this.getContainerByIndex(n);
                    itemContainer.removeItemsFromProcessItems();
                    itemContainer.removeAllItems();
                }
                this.removeAllContainers();
                n = byteBuffer.get();
                for (int i = 0; i < n; ++i) {
                    ItemContainer itemContainer = new ItemContainer();
                    itemContainer.ID = 0;
                    itemContainer.parent = this;
                    itemContainer.SourceGrid = this.square;
                    try {
                        itemContainer.load(byteBuffer, 195);
                        if (i == 0) {
                            if (this instanceof IsoDeadBody) {
                                itemContainer.Capacity = 8;
                            }
                            this.container = itemContainer;
                            continue;
                        }
                        this.addSecondaryContainer(itemContainer);
                        continue;
                    }
                    catch (Throwable throwable) {
                        ExceptionLogger.logException(throwable);
                    }
                }
            } else if ("container.customTemperature".equals(string)) {
                float f = byteBuffer.getFloat();
                if (this.getContainer() != null) {
                    this.getContainer().setCustomTemperature(f);
                }
            } else if ("name".equals(string)) {
                String string2 = GameWindow.ReadStringUTF(byteBuffer);
                this.setName(string2);
            } else if ("replaceWith".equals(string)) {
                try {
                    int n = this.getObjectIndex();
                    if (n < 0) break block28;
                    IsoObject isoObject = IsoObject.factoryFromFileInput(this.getCell(), byteBuffer);
                    isoObject.load(byteBuffer, 195);
                    isoObject.setSquare(this.square);
                    this.square.getObjects().set(n, isoObject);
                    this.square.getSpecialObjects().remove(this);
                    this.square.RecalcAllWithNeighbours(true);
                    if (this.getContainerCount() > 0) {
                        for (int i = 0; i < this.getContainerCount(); ++i) {
                            ItemContainer itemContainer = this.getContainerByIndex(i);
                            itemContainer.removeItemsFromProcessItems();
                        }
                        LuaEventManager.triggerEvent("OnContainerUpdate");
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if ("usesExternalWaterSource".equals(string)) {
                this.usesExternalWaterSource = byteBuffer.get() == 1;
            } else if ("sprite".equals(string)) {
                int n = byteBuffer.getInt();
                if (n == 0) {
                    this.sprite = null;
                    this.spriteName = null;
                    this.tile = null;
                } else {
                    this.spriteName = GameWindow.ReadString(byteBuffer);
                    this.sprite = IsoSprite.getSprite(IsoSpriteManager.instance, n);
                    if (this.sprite == null) {
                        this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
                        this.sprite.LoadFramesNoDirPageSimple(this.spriteName);
                    }
                }
            } else if ("emptyTrash".equals(string)) {
                this.getContainer().clear();
                if (this.getOverlaySprite() != null) {
                    ItemPickerJava.updateOverlaySprite(this);
                }
            }
        }
        this.checkMoveWithWind();
    }

    public void transmitUpdatedSpriteToServer() {
        if (GameClient.bClient) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.UpdateItemSprite.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(this.getSprite().ID);
            GameWindow.WriteStringUTF(byteBufferWriter.bb, this.spriteName);
            byteBufferWriter.putInt(this.getSquare().getX());
            byteBufferWriter.putInt(this.getSquare().getY());
            byteBufferWriter.putInt(this.getSquare().getZ());
            byteBufferWriter.putInt(this.getSquare().getObjects().indexOf(this));
            if (this.AttachedAnimSprite != null) {
                byteBufferWriter.putByte((byte)this.AttachedAnimSprite.size());
                for (int i = 0; i < this.AttachedAnimSprite.size(); ++i) {
                    IsoSpriteInstance isoSpriteInstance = this.AttachedAnimSprite.get(i);
                    byteBufferWriter.putInt(isoSpriteInstance.parentSprite.ID);
                }
            } else {
                byteBufferWriter.putByte((byte)0);
            }
            PacketTypes.PacketType.UpdateItemSprite.send(GameClient.connection);
        }
    }

    public void transmitCompleteItemToServer() {
        if (GameClient.bClient) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.AddItemToMap.doPacket(byteBufferWriter);
            this.writeToRemoteBuffer(byteBufferWriter);
            PacketTypes.PacketType.AddItemToMap.send(GameClient.connection);
        }
    }

    public void transmitModData() {
        if (this.square == null) {
            return;
        }
        if (GameClient.bClient) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.ObjectModData.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(this.getSquare().getX());
            byteBufferWriter.putInt(this.getSquare().getY());
            byteBufferWriter.putInt(this.getSquare().getZ());
            byteBufferWriter.putInt(this.getSquare().getObjects().indexOf(this));
            if (this.getModData().isEmpty()) {
                byteBufferWriter.putByte((byte)0);
            } else {
                byteBufferWriter.putByte((byte)1);
                try {
                    this.getModData().save(byteBufferWriter.bb);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            PacketTypes.PacketType.ObjectModData.send(GameClient.connection);
        } else if (GameServer.bServer) {
            GameServer.sendObjectModData(this);
        }
    }

    public void writeToRemoteBuffer(ByteBufferWriter byteBufferWriter) {
        try {
            this.save(byteBufferWriter.bb);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byteBufferWriter.putInt(this.getObjectIndex());
        byteBufferWriter.putBoolean(this.square.getSpecialObjects().contains(this));
        byteBufferWriter.putBoolean(this.square.getWorldObjects().contains(this));
    }

    public int getObjectIndex() {
        if (this.square == null) {
            return -1;
        }
        return this.square.getObjects().indexOf(this);
    }

    public int getMovingObjectIndex() {
        if (this.square == null) {
            return -1;
        }
        return this.square.getMovingObjects().indexOf(this);
    }

    public int getSpecialObjectIndex() {
        if (this.square == null) {
            return -1;
        }
        return this.square.getSpecialObjects().indexOf(this);
    }

    public int getStaticMovingObjectIndex() {
        if (this.square == null) {
            return -1;
        }
        return this.square.getStaticMovingObjects().indexOf(this);
    }

    public int getWorldObjectIndex() {
        if (this.square == null) {
            return -1;
        }
        return this.square.getWorldObjects().indexOf(this);
    }

    public IsoSprite getOverlaySprite() {
        return this.overlaySprite;
    }

    public void setOverlaySprite(String string) {
        this.setOverlaySprite(string, -1.0f, -1.0f, -1.0f, -1.0f, true);
    }

    public void setOverlaySprite(String string, boolean bl) {
        this.setOverlaySprite(string, -1.0f, -1.0f, -1.0f, -1.0f, bl);
    }

    public void setOverlaySpriteColor(float f, float f2, float f3, float f4) {
        this.overlaySpriteColor = new ColorInfo(f, f2, f3, f4);
    }

    public ColorInfo getOverlaySpriteColor() {
        return this.overlaySpriteColor;
    }

    public void setOverlaySprite(String string, float f, float f2, float f3, float f4) {
        this.setOverlaySprite(string, f, f2, f3, f4, true);
    }

    public boolean setOverlaySprite(String string, float f, float f2, float f3, float f4, boolean bl) {
        if (StringUtils.isNullOrWhitespace(string)) {
            if (this.overlaySprite == null) {
                return false;
            }
            this.overlaySprite = null;
            string = "";
        } else {
            boolean bl2;
            if (f > -1.0f) {
                bl2 = this.overlaySpriteColor != null && this.overlaySpriteColor.r == f && this.overlaySpriteColor.g == f2 && this.overlaySpriteColor.b == f3 && this.overlaySpriteColor.a == f4;
            } else {
                boolean bl3 = bl2 = this.overlaySpriteColor == null;
            }
            if (this.overlaySprite != null && string.equals(this.overlaySprite.name) && bl2) {
                return false;
            }
            this.overlaySprite = IsoSpriteManager.instance.getSprite(string);
            this.overlaySprite.name = string;
        }
        this.overlaySpriteColor = f > -1.0f ? new ColorInfo(f, f2, f3, f4) : null;
        if (!bl) {
            return true;
        }
        if (GameServer.bServer) {
            GameServer.updateOverlayForClients(this, string, f, f2, f3, f4, null);
        } else if (GameClient.bClient) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.UpdateOverlaySprite.doPacket(byteBufferWriter);
            GameWindow.WriteStringUTF(byteBufferWriter.bb, string);
            byteBufferWriter.putInt(this.getSquare().getX());
            byteBufferWriter.putInt(this.getSquare().getY());
            byteBufferWriter.putInt(this.getSquare().getZ());
            byteBufferWriter.putFloat(f);
            byteBufferWriter.putFloat(f2);
            byteBufferWriter.putFloat(f3);
            byteBufferWriter.putFloat(f4);
            byteBufferWriter.putInt(this.getSquare().getObjects().indexOf(this));
            PacketTypes.PacketType.UpdateOverlaySprite.send(GameClient.connection);
        }
        return true;
    }

    public boolean haveSpecialTooltip() {
        return this.specialTooltip;
    }

    public void setSpecialTooltip(boolean bl) {
        this.specialTooltip = bl;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public void setKeyId(int n) {
        this.keyId = n;
    }

    public boolean isHighlighted() {
        return (this.highlightFlags & 1) != 0;
    }

    public void setHighlighted(boolean bl) {
        this.setHighlighted(bl, true);
    }

    public void setHighlighted(boolean bl, boolean bl2) {
        this.highlightFlags = bl ? (byte)(this.highlightFlags | 1) : (byte)(this.highlightFlags & 0xFFFFFFFE);
        this.highlightFlags = bl2 ? (byte)(this.highlightFlags | 2) : (byte)(this.highlightFlags & 0xFFFFFFFD);
    }

    public ColorInfo getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(ColorInfo colorInfo) {
        this.highlightColor.set(colorInfo);
    }

    public void setHighlightColor(float f, float f2, float f3, float f4) {
        if (this.highlightColor == null) {
            this.highlightColor = new ColorInfo(f, f2, f3, f4);
        } else {
            this.highlightColor.set(f, f2, f3, f4);
        }
    }

    public boolean isBlink() {
        return (this.highlightFlags & 4) != 0;
    }

    public void setBlink(boolean bl) {
        this.highlightFlags = bl ? (byte)(this.highlightFlags | 4) : (byte)(this.highlightFlags & 0xFFFFFFFB);
    }

    public void checkHaveElectricity() {
        if (GameServer.bServer) {
            return;
        }
        ItemContainer itemContainer = this.getContainerByEitherType("fridge", "freezer");
        if (itemContainer != null && itemContainer.isPowered()) {
            IsoWorld.instance.getCell().addToProcessIsoObject(this);
            if (this.getChunk() != null && !this.hasObjectAmbientEmitter()) {
                this.getChunk().addObjectAmbientEmitter(this, new ObjectAmbientEmitters.FridgeHumLogic().init(this));
            }
        }
        this.checkAmbientSound();
    }

    public void checkAmbientSound() {
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer != null && propertyContainer.Is("AmbientSound") && this.getChunk() != null && !this.hasObjectAmbientEmitter()) {
            this.getChunk().addObjectAmbientEmitter(this, new ObjectAmbientEmitters.AmbientSoundLogic().init(this));
        }
    }

    public int getContainerCount() {
        int n = this.container == null ? 0 : 1;
        int n2 = this.secondaryContainers == null ? 0 : this.secondaryContainers.size();
        return n + n2;
    }

    public ItemContainer getContainerByIndex(int n) {
        if (this.container != null) {
            if (n == 0) {
                return this.container;
            }
            if (this.secondaryContainers == null) {
                return null;
            }
            if (n < 1 || n > this.secondaryContainers.size()) {
                return null;
            }
            return this.secondaryContainers.get(n - 1);
        }
        if (this.secondaryContainers == null) {
            return null;
        }
        if (n < 0 || n >= this.secondaryContainers.size()) {
            return null;
        }
        return this.secondaryContainers.get(n);
    }

    public ItemContainer getContainerByType(String string) {
        for (int i = 0; i < this.getContainerCount(); ++i) {
            ItemContainer itemContainer = this.getContainerByIndex(i);
            if (!itemContainer.getType().equals(string)) continue;
            return itemContainer;
        }
        return null;
    }

    public ItemContainer getContainerByEitherType(String string, String string2) {
        for (int i = 0; i < this.getContainerCount(); ++i) {
            ItemContainer itemContainer = this.getContainerByIndex(i);
            if (!itemContainer.getType().equals(string) && !itemContainer.getType().equals(string2)) continue;
            return itemContainer;
        }
        return null;
    }

    public void addSecondaryContainer(ItemContainer itemContainer) {
        if (this.secondaryContainers == null) {
            this.secondaryContainers = new ArrayList();
        }
        this.secondaryContainers.add(itemContainer);
        itemContainer.parent = this;
    }

    public int getContainerIndex(ItemContainer itemContainer) {
        if (itemContainer == this.container) {
            return 0;
        }
        if (this.secondaryContainers == null) {
            return -1;
        }
        for (int i = 0; i < this.secondaryContainers.size(); ++i) {
            if (this.secondaryContainers.get(i) != itemContainer) continue;
            return (this.container == null ? 0 : 1) + i;
        }
        return -1;
    }

    public void removeAllContainers() {
        this.container = null;
        if (this.secondaryContainers != null) {
            this.secondaryContainers.clear();
        }
    }

    public void createContainersFromSpriteProperties() {
        if (this.sprite == null) {
            return;
        }
        if (this.container != null) {
            return;
        }
        if (this.sprite.getProperties().Is(IsoFlagType.container) && this.container == null) {
            this.container = new ItemContainer(this.sprite.getProperties().Val("container"), this.square, this);
            this.container.parent = this;
            this.OutlineOnMouseover = true;
            if (this.sprite.getProperties().Is("ContainerCapacity")) {
                this.container.Capacity = Integer.parseInt(this.sprite.getProperties().Val("ContainerCapacity"));
            }
            if (this.sprite.getProperties().Is("ContainerPosition")) {
                this.container.setContainerPosition(this.sprite.getProperties().Val("ContainerPosition"));
            }
        }
        if (this.getSprite().getProperties().Is("Freezer")) {
            ItemContainer itemContainer = new ItemContainer("freezer", this.square, this);
            itemContainer.Capacity = this.getSprite().getProperties().Is("FreezerCapacity") ? Integer.parseInt(this.sprite.getProperties().Val("FreezerCapacity")) : 15;
            if (this.container == null) {
                this.container = itemContainer;
                this.container.parent = this;
            } else {
                this.addSecondaryContainer(itemContainer);
            }
            if (this.sprite.getProperties().Is("FreezerPosition")) {
                itemContainer.setFreezerPosition(this.sprite.getProperties().Val("FreezerPosition"));
            }
        }
    }

    public boolean isItemAllowedInContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        return true;
    }

    public boolean isRemoveItemAllowedFromContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        return true;
    }

    public void cleanWallBlood() {
        this.square.removeBlood(false, true);
    }

    public ObjectRenderEffects getWindRenderEffects() {
        return this.windRenderEffects;
    }

    public ObjectRenderEffects getObjectRenderEffects() {
        return this.objectRenderEffects;
    }

    public void setRenderEffect(RenderEffectType renderEffectType) {
        this.setRenderEffect(renderEffectType, false);
    }

    public IsoObject getRenderEffectMaster() {
        return this;
    }

    public void setRenderEffect(RenderEffectType renderEffectType, boolean bl) {
        if (GameServer.bServer) {
            return;
        }
        IsoObject isoObject = this.getRenderEffectMaster();
        if (isoObject.objectRenderEffects == null || bl) {
            isoObject.objectRenderEffects = ObjectRenderEffects.getNew(this, renderEffectType, bl);
        }
    }

    public void removeRenderEffect(ObjectRenderEffects objectRenderEffects) {
        IsoObject isoObject = this.getRenderEffectMaster();
        if (isoObject.objectRenderEffects != null && isoObject.objectRenderEffects == objectRenderEffects) {
            isoObject.objectRenderEffects = null;
        }
    }

    public ObjectRenderEffects getObjectRenderEffectsToApply() {
        IsoObject isoObject = this.getRenderEffectMaster();
        if (isoObject.objectRenderEffects != null) {
            return isoObject.objectRenderEffects;
        }
        if (Core.getInstance().getOptionDoWindSpriteEffects() && isoObject.windRenderEffects != null) {
            return isoObject.windRenderEffects;
        }
        return null;
    }

    public void destroyFence(IsoDirections isoDirections) {
        BrokenFences.getInstance().destroyFence(this, isoDirections);
    }

    public void getSpriteGridObjects(ArrayList<IsoObject> arrayList) {
        arrayList.clear();
        IsoSprite isoSprite = this.getSprite();
        if (isoSprite == null) {
            return;
        }
        IsoSpriteGrid isoSpriteGrid = isoSprite.getSpriteGrid();
        if (isoSpriteGrid == null) {
            return;
        }
        int n = isoSpriteGrid.getSpriteGridPosX(isoSprite);
        int n2 = isoSpriteGrid.getSpriteGridPosY(isoSprite);
        int n3 = this.getSquare().getX();
        int n4 = this.getSquare().getY();
        int n5 = this.getSquare().getZ();
        for (int i = n4 - n2; i < n4 - n2 + isoSpriteGrid.getHeight(); ++i) {
            for (int j = n3 - n; j < n3 - n + isoSpriteGrid.getWidth(); ++j) {
                IsoGridSquare isoGridSquare = this.getCell().getGridSquare(j, i, n5);
                if (isoGridSquare == null) continue;
                for (int k = 0; k < isoGridSquare.getObjects().size(); ++k) {
                    IsoObject isoObject = isoGridSquare.getObjects().get(k);
                    if (isoObject.getSprite() == null || isoObject.getSprite().getSpriteGrid() != isoSpriteGrid) continue;
                    arrayList.add(isoObject);
                }
            }
        }
    }

    public final int getOutlineHighlightCol() {
        return this.outlineHighlightCol[0];
    }

    public final void setOutlineHighlightCol(ColorInfo colorInfo) {
        if (colorInfo == null) {
            return;
        }
        for (int i = 0; i < this.outlineHighlightCol.length; ++i) {
            this.outlineHighlightCol[i] = Color.colorToABGR(colorInfo.r, colorInfo.g, colorInfo.b, colorInfo.a);
        }
    }

    public final int getOutlineHighlightCol(int n) {
        return this.outlineHighlightCol[n];
    }

    public final void setOutlineHighlightCol(int n, ColorInfo colorInfo) {
        if (colorInfo == null) {
            return;
        }
        this.outlineHighlightCol[n] = Color.colorToABGR(colorInfo.r, colorInfo.g, colorInfo.b, colorInfo.a);
    }

    public final void setOutlineHighlightCol(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.outlineHighlightCol.length; ++i) {
            this.outlineHighlightCol[i] = Color.colorToABGR(f, f2, f3, f4);
        }
    }

    public final void setOutlineHighlightCol(int n, float f, float f2, float f3, float f4) {
        this.outlineHighlightCol[n] = Color.colorToABGR(f, f2, f3, f4);
    }

    public final boolean isOutlineHighlight() {
        return this.isOutlineHighlight != 0;
    }

    public final boolean isOutlineHighlight(int n) {
        return (this.isOutlineHighlight & 1 << n) != 0;
    }

    public final void setOutlineHighlight(boolean bl) {
        this.isOutlineHighlight = (byte)(bl ? -1 : 0);
    }

    public final void setOutlineHighlight(int n, boolean bl) {
        this.isOutlineHighlight = bl ? (byte)(this.isOutlineHighlight | 1 << n) : (byte)(this.isOutlineHighlight & ~(1 << n));
    }

    public final boolean isOutlineHlAttached() {
        return this.isOutlineHlAttached != 0;
    }

    public final boolean isOutlineHlAttached(int n) {
        return (this.isOutlineHlAttached & 1 << n) != 0;
    }

    public void setOutlineHlAttached(boolean bl) {
        this.isOutlineHlAttached = (byte)(bl ? -1 : 0);
    }

    public final void setOutlineHlAttached(int n, boolean bl) {
        this.isOutlineHlAttached = bl ? (byte)(this.isOutlineHlAttached | 1 << n) : (byte)(this.isOutlineHlAttached & ~(1 << n));
    }

    public boolean isOutlineHlBlink() {
        return this.isOutlineHlBlink != 0;
    }

    public final boolean isOutlineHlBlink(int n) {
        return (this.isOutlineHlBlink & 1 << n) != 0;
    }

    public void setOutlineHlBlink(boolean bl) {
        this.isOutlineHlBlink = (byte)(bl ? -1 : 0);
    }

    public final void setOutlineHlBlink(int n, boolean bl) {
        this.isOutlineHlBlink = bl ? (byte)(this.isOutlineHlBlink | 1 << n) : (byte)(this.isOutlineHlBlink & ~(1 << n));
    }

    public void unsetOutlineHighlight() {
        this.isOutlineHighlight = 0;
        this.isOutlineHlBlink = 0;
        this.isOutlineHlAttached = 0;
    }

    public float getOutlineThickness() {
        return this.outlineThickness;
    }

    public void setOutlineThickness(float f) {
        this.outlineThickness = f;
    }

    protected void addItemsFromProperties() {
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer == null) {
            return;
        }
        String string = propertyContainer.Val("Material");
        String string2 = propertyContainer.Val("Material2");
        String string3 = propertyContainer.Val("Material3");
        if ("Wood".equals(string) || "Wood".equals(string2) || "Wood".equals(string3)) {
            this.square.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.UnusableWood"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
            if (Rand.NextBool(5)) {
                this.square.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.UnusableWood"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
            }
        }
        if (("MetalBars".equals(string) || "MetalBars".equals(string2) || "MetalBars".equals(string3)) && Rand.NextBool(2)) {
            this.square.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.MetalBar"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
        if (("MetalPlates".equals(string) || "MetalPlates".equals(string2) || "MetalPlates".equals(string3)) && Rand.NextBool(2)) {
            this.square.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.SheetMetal"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
        if (("MetalPipe".equals(string) || "MetalPipe".equals(string2) || "MetalPipe".equals(string3)) && Rand.NextBool(2)) {
            this.square.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.MetalPipe"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
        if (("MetalWire".equals(string) || "MetalWire".equals(string2) || "MetalWire".equals(string3)) && Rand.NextBool(3)) {
            this.square.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.Wire"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
        if (("Nails".equals(string) || "Nails".equals(string2) || "Nails".equals(string3)) && Rand.NextBool(2)) {
            this.square.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.Nails"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
        if (("Screws".equals(string) || "Screws".equals(string2) || "Screws".equals(string3)) && Rand.NextBool(2)) {
            this.square.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.Screws"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.Damage <= 0;
    }

    @Override
    public void Thump(IsoMovingObject isoMovingObject) {
        int n;
        IsoGameCharacter isoGameCharacter = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class);
        if (isoGameCharacter != null) {
            Thumpable thumpable = this.getThumpableFor(isoGameCharacter);
            if (thumpable == null) {
                return;
            }
            if (thumpable != this) {
                thumpable.Thump(isoMovingObject);
                return;
            }
        }
        boolean bl = BrokenFences.getInstance().isBreakableObject(this);
        int n2 = 8;
        if (isoMovingObject instanceof IsoZombie) {
            int n3;
            int n4 = isoMovingObject.getCurrentSquare().getMovingObjects().size();
            if (isoMovingObject.getCurrentSquare().getW() != null) {
                n4 += isoMovingObject.getCurrentSquare().getW().getMovingObjects().size();
            }
            if (isoMovingObject.getCurrentSquare().getE() != null) {
                n4 += isoMovingObject.getCurrentSquare().getE().getMovingObjects().size();
            }
            if (isoMovingObject.getCurrentSquare().getS() != null) {
                n4 += isoMovingObject.getCurrentSquare().getS().getMovingObjects().size();
            }
            if (isoMovingObject.getCurrentSquare().getN() != null) {
                n4 += isoMovingObject.getCurrentSquare().getN().getMovingObjects().size();
            }
            if (n4 >= (n3 = n2)) {
                n = 1 * ThumpState.getFastForwardDamageMultiplier();
                this.Damage = (short)(this.Damage - n);
            } else {
                this.partialThumpDmg += (float)n4 / (float)n3 * (float)ThumpState.getFastForwardDamageMultiplier();
                if ((int)this.partialThumpDmg > 0) {
                    n = (int)this.partialThumpDmg;
                    this.Damage = (short)(this.Damage - n);
                    this.partialThumpDmg -= (float)n;
                }
            }
            WorldSoundManager.instance.addSound(isoMovingObject, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, true, 4.0f, 15.0f);
        }
        if (this.Damage <= 0) {
            String string = "BreakObject";
            if (isoGameCharacter != null) {
                isoGameCharacter.getEmitter().playSound(string, this);
            }
            if (GameServer.bServer) {
                GameServer.PlayWorldSoundServer(string, false, isoMovingObject.getCurrentSquare(), 0.2f, 20.0f, 1.1f, true);
            }
            WorldSoundManager.instance.addSound(null, this.square.getX(), this.square.getY(), this.square.getZ(), 10, 20, true, 4.0f, 15.0f);
            isoMovingObject.setThumpTarget(null);
            if (bl) {
                PropertyContainer propertyContainer = this.getProperties();
                IsoDirections isoDirections = propertyContainer.Is(IsoFlagType.collideN) && propertyContainer.Is(IsoFlagType.collideW) ? (isoMovingObject.getY() >= this.getY() ? IsoDirections.N : IsoDirections.S) : (propertyContainer.Is(IsoFlagType.collideN) ? (isoMovingObject.getY() >= this.getY() ? IsoDirections.N : IsoDirections.S) : (isoMovingObject.getX() >= this.getX() ? IsoDirections.W : IsoDirections.E));
                BrokenFences.getInstance().destroyFence(this, isoDirections);
                return;
            }
            ArrayList<InventoryItem> arrayList = new ArrayList<InventoryItem>();
            for (n = 0; n < this.getContainerCount(); ++n) {
                ItemContainer itemContainer = this.getContainerByIndex(n);
                arrayList.clear();
                arrayList.addAll(itemContainer.getItems());
                itemContainer.removeItemsFromProcessItems();
                itemContainer.removeAllItems();
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.getSquare().AddWorldInventoryItem((InventoryItem)arrayList.get(i), 0.0f, 0.0f, 0.0f);
                }
            }
            this.square.transmitRemoveItemFromSquare(this);
        }
    }

    public void setMovedThumpable(boolean bl) {
        this.bMovedThumpable = bl;
    }

    public boolean isMovedThumpable() {
        return this.bMovedThumpable;
    }

    @Override
    public void WeaponHit(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon) {
    }

    @Override
    public Thumpable getThumpableFor(IsoGameCharacter isoGameCharacter) {
        if (this.isDestroyed()) {
            return null;
        }
        if (this.isMovedThumpable()) {
            return this;
        }
        if (BrokenFences.getInstance().isBreakableObject(this)) {
            IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
            return isoZombie != null && isoZombie.isCrawling() ? this : null;
        }
        return null;
    }

    public boolean isExistInTheWorld() {
        return this.square.getMovingObjects().contains(this);
    }

    @Override
    public float getThumpCondition() {
        return (float)PZMath.clamp(this.getDamage(), 0, 100) / 100.0f;
    }

    static {
        LowLightingQualityHack = false;
        DefaultCondition = 0;
        stCol2 = new ColorInfo();
        colFxMask = new ColorInfo(1.0f, 1.0f, 1.0f, 1.0f);
        byteToObjectMap = new HashMap<Byte, IsoObjectFactory>();
        hashCodeToObjectMap = new HashMap<Integer, IsoObjectFactory>();
        nameToObjectMap = new HashMap<String, IsoObjectFactory>();
        IsoObject.initFactory();
    }

    public static class IsoObjectFactory {
        private final byte classID;
        private final String objectName;
        private final int hashCode;

        public IsoObjectFactory(byte by, String string) {
            this.classID = by;
            this.objectName = string;
            this.hashCode = string.hashCode();
        }

        protected IsoObject InstantiateObject(IsoCell isoCell) {
            return new IsoObject(isoCell);
        }

        public byte getClassID() {
            return this.classID;
        }

        public String getObjectName() {
            return this.objectName;
        }
    }

    public static class OutlineShader {
        public static final OutlineShader instance = new OutlineShader();
        private ShaderProgram shaderProgram;
        private int stepSize;
        private int outlineColor;

        public void initShader() {
            this.shaderProgram = ShaderProgram.createShaderProgram("outline", false, true);
            if (this.shaderProgram.isCompiled()) {
                this.stepSize = ARBShaderObjects.glGetUniformLocationARB((int)this.shaderProgram.getShaderID(), (CharSequence)"stepSize");
                this.outlineColor = ARBShaderObjects.glGetUniformLocationARB((int)this.shaderProgram.getShaderID(), (CharSequence)"outlineColor");
                ARBShaderObjects.glUseProgramObjectARB((int)this.shaderProgram.getShaderID());
                ARBShaderObjects.glUniform2fARB((int)this.stepSize, (float)0.001f, (float)0.001f);
                ARBShaderObjects.glUseProgramObjectARB((int)0);
            }
        }

        public void setOutlineColor(float f, float f2, float f3, float f4) {
            SpriteRenderer.instance.ShaderUpdate4f(this.shaderProgram.getShaderID(), this.outlineColor, f, f2, f3, f4);
        }

        public void setStepSize(float f, int n, int n2) {
            SpriteRenderer.instance.ShaderUpdate2f(this.shaderProgram.getShaderID(), this.stepSize, f / (float)n, f / (float)n2);
        }

        public boolean StartShader() {
            if (this.shaderProgram == null) {
                RenderThread.invokeOnRenderContext(this::initShader);
            }
            if (this.shaderProgram.isCompiled()) {
                IndieGL.StartShader(this.shaderProgram.getShaderID(), 0);
                return true;
            }
            return false;
        }
    }

    public static enum VisionResult {
        NoEffect,
        Blocked,
        Unblocked;

    }
}

