/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import fmod.fmod.Audio;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.joml.Vector2f;
import zombie.CollisionManager;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.MovingObjectUpdateScheduler;
import zombie.SoundManager;
import zombie.ai.State;
import zombie.ai.astar.Mover;
import zombie.ai.states.AttackState;
import zombie.ai.states.ClimbOverFenceState;
import zombie.ai.states.ClimbThroughWindowState;
import zombie.ai.states.CollideWithWallState;
import zombie.ai.states.CrawlingZombieTurnState;
import zombie.ai.states.PathFindState;
import zombie.ai.states.StaggerBackState;
import zombie.ai.states.WalkTowardState;
import zombie.ai.states.ZombieFallDownState;
import zombie.ai.states.ZombieIdleState;
import zombie.audio.BaseSoundEmitter;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.characters.skills.PerkFactory;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.textures.ColorInfo;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.WeaponType;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;
import zombie.iso.IsoPhysicsObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.Vector3;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.areas.IsoRoom;
import zombie.iso.areas.isoregion.regions.IWorldRegion;
import zombie.iso.objects.IsoMolotovCocktail;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoZombieGiblets;
import zombie.iso.objects.RenderEffectType;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.popman.ZombiePopulationManager;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PathFindBehavior2;
import zombie.vehicles.PolygonalMap2;

public class IsoMovingObject
extends IsoObject
implements Mover {
    public static TreeSoundManager treeSoundMgr = new TreeSoundManager();
    public static final int MAX_ZOMBIES_EATING = 3;
    private static int IDCount = 0;
    private static final Vector2 tempo = new Vector2();
    public boolean noDamage = false;
    public IsoGridSquare last = null;
    public float lx;
    public float ly;
    public float lz;
    public float nx;
    public float ny;
    public float x;
    public float y;
    public float z;
    public IsoSpriteInstance def = null;
    protected IsoGridSquare current = null;
    protected Vector2 hitDir = new Vector2();
    protected int ID = 0;
    protected IsoGridSquare movingSq = null;
    protected boolean solid = true;
    protected float width = 0.24f;
    protected boolean shootable = true;
    protected boolean Collidable = true;
    protected float scriptnx = 0.0f;
    protected float scriptny = 0.0f;
    protected String ScriptModule = "none";
    protected Vector2 movementLastFrame = new Vector2();
    protected float weight = 1.0f;
    boolean bOnFloor = false;
    private boolean closeKilled = false;
    private String collideType = null;
    private float lastCollideTime = 0.0f;
    private int TimeSinceZombieAttack = 1000000;
    private boolean collidedE = false;
    private boolean collidedN = false;
    private IsoObject CollidedObject = null;
    private boolean collidedS = false;
    private boolean collidedThisFrame = false;
    private boolean collidedW = false;
    private boolean CollidedWithDoor = false;
    private boolean collidedWithVehicle = false;
    private boolean destroyed = false;
    private boolean firstUpdate = true;
    private float impulsex = 0.0f;
    private float impulsey = 0.0f;
    private float limpulsex = 0.0f;
    private float limpulsey = 0.0f;
    private float hitForce = 0.0f;
    private float hitFromAngle;
    private int PathFindIndex = -1;
    private float StateEventDelayTimer = 0.0f;
    private Thumpable thumpTarget = null;
    private boolean bAltCollide = false;
    private IsoZombie lastTargettedBy = null;
    private float feelersize = 0.5f;
    public final boolean[] bOutline = new boolean[4];
    public final ColorInfo[] outlineColor = new ColorInfo[4];
    private final ArrayList<IsoZombie> eatingZombies = new ArrayList();
    private boolean zombiesDontAttack = false;

    public IsoMovingObject(IsoCell isoCell) {
        this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        if (isoCell == null) {
            return;
        }
        this.ID = IDCount++;
        if (this.getCell().isSafeToAdd()) {
            this.getCell().getObjectList().add(this);
        } else {
            this.getCell().getAddList().add(this);
        }
    }

    public IsoMovingObject(IsoCell isoCell, boolean bl) {
        this.ID = IDCount++;
        this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        if (bl) {
            if (this.getCell().isSafeToAdd()) {
                this.getCell().getObjectList().add(this);
            } else {
                this.getCell().getAddList().add(this);
            }
        }
    }

    public IsoMovingObject(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite, boolean bl) {
        this.ID = IDCount++;
        this.sprite = isoSprite;
        if (bl) {
            if (this.getCell().isSafeToAdd()) {
                this.getCell().getObjectList().add(this);
            } else {
                this.getCell().getAddList().add(this);
            }
        }
    }

    public IsoMovingObject() {
        this.ID = IDCount++;
        this.getCell().getAddList().add(this);
    }

    public static int getIDCount() {
        return IDCount;
    }

    public static void setIDCount(int n) {
        IDCount = n;
    }

    public IsoBuilding getBuilding() {
        if (this.current == null) {
            return null;
        }
        IsoRoom isoRoom = this.current.getRoom();
        if (isoRoom == null) {
            return null;
        }
        return isoRoom.building;
    }

    public IWorldRegion getMasterRegion() {
        if (this.current != null) {
            return this.current.getIsoWorldRegion();
        }
        return null;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public float getWeight(float f, float f2) {
        return this.weight;
    }

    @Override
    public void onMouseRightClick(int n, int n2) {
        if (this.square.getZ() == (int)IsoPlayer.getInstance().getZ() && this.DistToProper(IsoPlayer.getInstance()) <= 2.0f) {
            IsoPlayer.getInstance().setDragObject(this);
        }
    }

    @Override
    public String getObjectName() {
        return "IsoMovingObject";
    }

    @Override
    public void onMouseRightReleased() {
    }

    public void collideWith(IsoObject isoObject) {
        if (this instanceof IsoGameCharacter && isoObject instanceof IsoGameCharacter) {
            LuaEventManager.triggerEvent("OnCharacterCollide", this, isoObject);
        } else {
            LuaEventManager.triggerEvent("OnObjectCollide", this, isoObject);
        }
    }

    public void doStairs() {
        State state;
        IsoGridSquare isoGridSquare;
        if (this.current == null) {
            return;
        }
        if (this.last == null) {
            return;
        }
        if (this instanceof IsoPhysicsObject) {
            return;
        }
        IsoGridSquare isoGridSquare2 = this.current;
        if (isoGridSquare2.z > 0 && (isoGridSquare2.Has(IsoObjectType.stairsTN) || isoGridSquare2.Has(IsoObjectType.stairsTW)) && this.z - (float)((int)this.z) < 0.1f && (isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare2.x, isoGridSquare2.y, isoGridSquare2.z - 1)) != null && (isoGridSquare.Has(IsoObjectType.stairsTN) || isoGridSquare.Has(IsoObjectType.stairsTW))) {
            isoGridSquare2 = isoGridSquare;
        }
        if (this instanceof IsoGameCharacter && (this.last.Has(IsoObjectType.stairsTN) || this.last.Has(IsoObjectType.stairsTW))) {
            this.z = Math.round(this.z);
        }
        float f = this.z;
        if (isoGridSquare2.HasStairs()) {
            f = isoGridSquare2.getApparentZ(this.x - (float)isoGridSquare2.getX(), this.y - (float)isoGridSquare2.getY());
        }
        if (this instanceof IsoGameCharacter && ((state = ((IsoGameCharacter)this).getCurrentState()) == ClimbOverFenceState.instance() || state == ClimbThroughWindowState.instance())) {
            if (isoGridSquare2.HasStairs() && this.z > f) {
                this.z = Math.max(f, this.z - 0.075f * GameTime.getInstance().getMultiplier());
            }
            return;
        }
        if (Math.abs(f - this.z) < 0.95f) {
            this.z = f;
        }
    }

    @Override
    public int getID() {
        return this.ID;
    }

    public void setID(int n) {
        this.ID = n;
    }

    @Override
    public int getPathFindIndex() {
        return this.PathFindIndex;
    }

    public void setPathFindIndex(int n) {
        this.PathFindIndex = n;
    }

    public float getScreenX() {
        return IsoUtils.XToScreen(this.x, this.y, this.z, 0);
    }

    public float getScreenY() {
        return IsoUtils.YToScreen(this.x, this.y, this.z, 0);
    }

    public Thumpable getThumpTarget() {
        return this.thumpTarget;
    }

    public void setThumpTarget(Thumpable thumpable) {
        this.thumpTarget = thumpable;
    }

    public Vector2 getVectorFromDirection(Vector2 vector22) {
        return IsoMovingObject.getVectorFromDirection(vector22, this.dir);
    }

    public static Vector2 getVectorFromDirection(Vector2 vector22, IsoDirections isoDirections) {
        if (vector22 == null) {
            DebugLog.General.warn("Supplied vector2 is null. Cannot be processed. Using fail-safe fallback.");
            vector22 = new Vector2();
        }
        vector22.x = 0.0f;
        vector22.y = 0.0f;
        switch (isoDirections) {
            case S: {
                vector22.x = 0.0f;
                vector22.y = 1.0f;
                break;
            }
            case N: {
                vector22.x = 0.0f;
                vector22.y = -1.0f;
                break;
            }
            case E: {
                vector22.x = 1.0f;
                vector22.y = 0.0f;
                break;
            }
            case W: {
                vector22.x = -1.0f;
                vector22.y = 0.0f;
                break;
            }
            case NW: {
                vector22.x = -1.0f;
                vector22.y = -1.0f;
                break;
            }
            case NE: {
                vector22.x = 1.0f;
                vector22.y = -1.0f;
                break;
            }
            case SW: {
                vector22.x = -1.0f;
                vector22.y = 1.0f;
                break;
            }
            case SE: {
                vector22.x = 1.0f;
                vector22.y = 1.0f;
            }
        }
        vector22.normalize();
        return vector22;
    }

    public Vector3 getPosition(Vector3 vector3) {
        vector3.set(this.getX(), this.getY(), this.getZ());
        return vector3;
    }

    @Override
    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
        this.nx = f;
        this.scriptnx = f;
    }

    @Override
    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
        this.ny = f;
        this.scriptny = f;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    public void setZ(float f) {
        this.z = f;
        this.lz = f;
    }

    @Override
    public IsoGridSquare getSquare() {
        if (this.current != null) {
            return this.current;
        }
        return this.square;
    }

    public IsoBuilding getCurrentBuilding() {
        if (this.current == null) {
            return null;
        }
        if (this.current.getRoom() == null) {
            return null;
        }
        return this.current.getRoom().building;
    }

    public float Hit(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter, float f, boolean bl, float f2) {
        return 0.0f;
    }

    public void Move(Vector2 vector22) {
        this.nx += vector22.x * GameTime.instance.getMultiplier();
        this.ny += vector22.y * GameTime.instance.getMultiplier();
        if (this instanceof IsoPlayer) {
            this.current = IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y, (double)((int)this.z));
        }
    }

    public void MoveUnmodded(Vector2 vector22) {
        this.nx += vector22.x;
        this.ny += vector22.y;
        if (this instanceof IsoPlayer) {
            this.current = IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y, (double)((int)this.z));
        }
    }

    @Override
    public boolean isCharacter() {
        return this instanceof IsoGameCharacter;
    }

    public float DistTo(int n, int n2) {
        return IsoUtils.DistanceManhatten(n, n2, this.x, this.y);
    }

    public float DistTo(IsoMovingObject isoMovingObject) {
        return IsoUtils.DistanceManhatten(this.x, this.y, isoMovingObject.x, isoMovingObject.y);
    }

    public float DistToProper(IsoObject isoObject) {
        return IsoUtils.DistanceTo(this.x, this.y, isoObject.getX(), isoObject.getY());
    }

    public float DistToSquared(IsoMovingObject isoMovingObject) {
        return IsoUtils.DistanceToSquared(this.x, this.y, isoMovingObject.x, isoMovingObject.y);
    }

    public float DistToSquared(float f, float f2) {
        return IsoUtils.DistanceToSquared(f, f2, this.x, this.y);
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        this.nx = this.scriptnx = byteBuffer.getFloat() + (float)(IsoWorld.saveoffsetx * 300);
        this.lx = this.scriptnx;
        this.x = this.scriptnx;
        this.ny = this.scriptny = byteBuffer.getFloat() + (float)(IsoWorld.saveoffsety * 300);
        this.ly = this.scriptny;
        this.y = this.scriptny;
        this.z = this.lz = byteBuffer.getFloat();
        this.dir = IsoDirections.fromIndex(byteBuffer.getInt());
        if (byteBuffer.get() != 0) {
            if (this.table == null) {
                this.table = LuaManager.platform.newTable();
            }
            this.table.load(byteBuffer, n);
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        byteBuffer.put(this.Serialize() ? (byte)1 : 0);
        byteBuffer.put(IsoObject.factoryGetClassID(this.getObjectName()));
        byteBuffer.putFloat(this.offsetX);
        byteBuffer.putFloat(this.offsetY);
        byteBuffer.putFloat(this.x);
        byteBuffer.putFloat(this.y);
        byteBuffer.putFloat(this.z);
        byteBuffer.putInt(this.dir.index());
        if (this.table != null && !this.table.isEmpty()) {
            byteBuffer.put((byte)1);
            this.table.save(byteBuffer);
        } else {
            byteBuffer.put((byte)0);
        }
    }

    @Override
    public void removeFromWorld() {
        IsoCell isoCell = this.getCell();
        if (isoCell.isSafeToAdd()) {
            isoCell.getObjectList().remove(this);
            isoCell.getRemoveList().remove(this);
        } else {
            isoCell.getRemoveList().add(this);
        }
        isoCell.getAddList().remove(this);
        MovingObjectUpdateScheduler.instance.removeObject(this);
        super.removeFromWorld();
    }

    @Override
    public void removeFromSquare() {
        if (this.current != null) {
            this.current.getMovingObjects().remove(this);
        }
        if (this.last != null) {
            this.last.getMovingObjects().remove(this);
        }
        if (this.movingSq != null) {
            this.movingSq.getMovingObjects().remove(this);
        }
        this.movingSq = null;
        this.last = null;
        this.current = null;
        if (this.square != null) {
            this.square.getStaticMovingObjects().remove(this);
        }
        super.removeFromSquare();
    }

    public IsoGridSquare getFuturWalkedSquare() {
        IsoGridSquare isoGridSquare;
        if (this.current != null && (isoGridSquare = this.getFeelerTile(this.feelersize)) != null && isoGridSquare != this.current) {
            return isoGridSquare;
        }
        return null;
    }

    public float getGlobalMovementMod() {
        return this.getGlobalMovementMod(true);
    }

    public float getGlobalMovementMod(boolean bl) {
        if (this.current != null && this.z - (float)((int)this.z) < 0.5f) {
            IsoGridSquare isoGridSquare;
            if (this.current.Has(IsoObjectType.tree) || this.current.getProperties() != null && this.current.getProperties().Is("Bush")) {
                if (bl) {
                    this.doTreeNoises();
                }
                for (int i = 1; i < this.current.getObjects().size(); ++i) {
                    IsoObject isoObject = this.current.getObjects().get(i);
                    if (isoObject instanceof IsoTree) {
                        isoObject.setRenderEffect(RenderEffectType.Vegetation_Rustle);
                        continue;
                    }
                    if (isoObject.getProperties() == null || !isoObject.getProperties().Is("Bush")) continue;
                    isoObject.setRenderEffect(RenderEffectType.Vegetation_Rustle);
                }
            }
            if ((isoGridSquare = this.getFeelerTile(this.feelersize)) != null && isoGridSquare != this.current && (isoGridSquare.Has(IsoObjectType.tree) || isoGridSquare.getProperties() != null && isoGridSquare.getProperties().Is("Bush"))) {
                if (bl) {
                    this.doTreeNoises();
                }
                for (int i = 1; i < isoGridSquare.getObjects().size(); ++i) {
                    IsoObject isoObject = isoGridSquare.getObjects().get(i);
                    if (isoObject instanceof IsoTree) {
                        isoObject.setRenderEffect(RenderEffectType.Vegetation_Rustle);
                        continue;
                    }
                    if (isoObject.getSprite() == null || !isoObject.getProperties().Is("Bush")) continue;
                    isoObject.setRenderEffect(RenderEffectType.Vegetation_Rustle);
                }
            }
        }
        if (this.current != null && this.current.HasStairs()) {
            return 0.75f;
        }
        return 1.0f;
    }

    private void doTreeNoises() {
        if (GameServer.bServer) {
            return;
        }
        if (this instanceof IsoPhysicsObject) {
            return;
        }
        if (this.current == null) {
            return;
        }
        if (Rand.Next(Rand.AdjustForFramerate(50)) != 0) {
            return;
        }
        treeSoundMgr.addSquare(this.current);
    }

    public void postupdate() {
        float f;
        int n;
        IsoGameCharacter isoGameCharacter = Type.tryCastTo(this, IsoGameCharacter.class);
        IsoPlayer isoPlayer = Type.tryCastTo(this, IsoPlayer.class);
        IsoZombie isoZombie = Type.tryCastTo(this, IsoZombie.class);
        this.slideAwayFromWalls();
        if (isoZombie != null && GameServer.bServer && !isoZombie.isCurrentState(ZombieIdleState.instance())) {
            boolean bl = false;
        }
        if (isoPlayer != null && isoPlayer.isLocalPlayer()) {
            IsoPlayer.setInstance(isoPlayer);
            IsoCamera.CamCharacter = isoPlayer;
        }
        this.ensureOnTile();
        if (this.lastTargettedBy != null && this.lastTargettedBy.isDead()) {
            this.lastTargettedBy = null;
        }
        if (this.lastTargettedBy != null && this.TimeSinceZombieAttack > 120) {
            this.lastTargettedBy = null;
        }
        ++this.TimeSinceZombieAttack;
        if (isoPlayer != null) {
            isoPlayer.setLastCollidedW(this.collidedW);
            isoPlayer.setLastCollidedN(this.collidedN);
        }
        if (this.destroyed) {
            return;
        }
        this.collidedThisFrame = false;
        this.collidedN = false;
        this.collidedS = false;
        this.collidedW = false;
        this.collidedE = false;
        this.CollidedWithDoor = false;
        this.last = this.current;
        this.CollidedObject = null;
        this.nx += this.impulsex;
        this.ny += this.impulsey;
        if (this.nx < 0.0f) {
            this.nx = 0.0f;
        }
        if (this.ny < 0.0f) {
            this.ny = 0.0f;
        }
        tempo.set(this.nx - this.x, this.ny - this.y);
        if (tempo.getLength() > 1.0f) {
            tempo.normalize();
            this.nx = this.x + tempo.getX();
            this.ny = this.y + tempo.getY();
        }
        this.impulsex = 0.0f;
        this.impulsey = 0.0f;
        if (isoZombie != null && (int)this.z == 0 && this.getCurrentBuilding() == null && !this.isInLoadedArea((int)this.nx, (int)this.ny) && (isoZombie.isCurrentState(PathFindState.instance()) || isoZombie.isCurrentState(WalkTowardState.instance()))) {
            ZombiePopulationManager.instance.virtualizeZombie(isoZombie);
            return;
        }
        float f2 = this.nx;
        float f3 = this.ny;
        this.collidedWithVehicle = false;
        if (!(isoGameCharacter == null || this.isOnFloor() || isoGameCharacter.getVehicle() != null || !this.isCollidable() || isoPlayer != null && isoPlayer.isNoClip())) {
            int n2;
            int n3 = (int)this.x;
            int n4 = (int)this.y;
            int n5 = (int)this.nx;
            n = (int)this.ny;
            int n6 = n2 = (int)this.z;
            if (isoGameCharacter.getCurrentState() == null || !isoGameCharacter.getCurrentState().isIgnoreCollide(isoGameCharacter, n3, n4, n2, n5, n, n6)) {
                Vector2f vector2f = PolygonalMap2.instance.resolveCollision(isoGameCharacter, this.nx, this.ny, L_postUpdate.vector2f);
                if (vector2f.x != this.nx || vector2f.y != this.ny) {
                    this.nx = vector2f.x;
                    this.ny = vector2f.y;
                    this.collidedWithVehicle = true;
                }
            }
        }
        float f4 = this.nx;
        float f5 = this.ny;
        float f6 = 0.0f;
        n = 0;
        if (this.Collidable) {
            if (this.bAltCollide) {
                this.DoCollide(2);
            } else {
                this.DoCollide(1);
            }
            if (this.collidedN || this.collidedS) {
                this.ny = this.ly;
                this.DoCollideNorS();
            }
            if (this.collidedW || this.collidedE) {
                this.nx = this.lx;
                this.DoCollideWorE();
            }
            if (this.bAltCollide) {
                this.DoCollide(1);
            } else {
                this.DoCollide(2);
            }
            boolean bl = this.bAltCollide = !this.bAltCollide;
            if (this.collidedN || this.collidedS) {
                this.ny = this.ly;
                this.DoCollideNorS();
                n = 1;
            }
            if (this.collidedW || this.collidedE) {
                this.nx = this.lx;
                this.DoCollideWorE();
                n = 1;
            }
            f6 = Math.abs(this.nx - this.lx) + Math.abs(this.ny - this.ly);
            float f7 = this.nx;
            float f8 = this.ny;
            this.nx = f4;
            this.ny = f5;
            if (this.Collidable && n != 0) {
                if (this.bAltCollide) {
                    this.DoCollide(2);
                } else {
                    this.DoCollide(1);
                }
                if (this.collidedN || this.collidedS) {
                    this.ny = this.ly;
                    this.DoCollideNorS();
                }
                if (this.collidedW || this.collidedE) {
                    this.nx = this.lx;
                    this.DoCollideWorE();
                }
                if (this.bAltCollide) {
                    this.DoCollide(1);
                } else {
                    this.DoCollide(2);
                }
                if (this.collidedN || this.collidedS) {
                    this.ny = this.ly;
                    this.DoCollideNorS();
                    n = 1;
                }
                if (this.collidedW || this.collidedE) {
                    this.nx = this.lx;
                    this.DoCollideWorE();
                    n = 1;
                }
                if (Math.abs(this.nx - this.lx) + Math.abs(this.ny - this.ly) < f6) {
                    this.nx = f7;
                    this.ny = f8;
                }
            }
        }
        if (this.collidedThisFrame) {
            this.current = this.last;
        }
        this.checkHitWall();
        if (!(isoPlayer == null || isoPlayer.isCurrentState(CollideWithWallState.instance()) || this.collidedN || this.collidedS || this.collidedW || this.collidedE)) {
            this.setCollideType(null);
        }
        float f9 = this.nx - this.x;
        float f10 = this.ny - this.y;
        float f11 = f = Math.abs(f9) > 0.0f || Math.abs(f10) > 0.0f ? this.getGlobalMovementMod() : 0.0f;
        if (Math.abs(f9) > 0.01f || Math.abs(f10) > 0.01f) {
            f9 *= f;
            f10 *= f;
        }
        this.x += f9;
        this.y += f10;
        this.doStairs();
        this.current = this.getCell().getGridSquare((int)this.x, (int)this.y, (int)this.z);
        if (this.current == null) {
            for (int i = (int)this.z; i >= 0; --i) {
                this.current = this.getCell().getGridSquare((int)this.x, (int)this.y, i);
                if (this.current != null) break;
            }
            if (this.current == null && this.last != null) {
                this.current = this.last;
                this.nx = this.scriptnx = (float)this.current.getX() + 0.5f;
                this.x = this.scriptnx;
                this.ny = this.scriptny = (float)this.current.getY() + 0.5f;
                this.y = this.scriptny;
            }
        }
        if (this.movingSq != null) {
            this.movingSq.getMovingObjects().remove(this);
            this.movingSq = null;
        }
        if (this.current != null && !this.current.getMovingObjects().contains(this)) {
            this.current.getMovingObjects().add(this);
            this.movingSq = this.current;
        }
        this.ensureOnTile();
        this.square = this.current;
        this.scriptnx = this.nx;
        this.scriptny = this.ny;
        this.firstUpdate = false;
    }

    public void ensureOnTile() {
        if (this.current == null) {
            if (!(this instanceof IsoPlayer)) {
                if (this instanceof IsoSurvivor) {
                    IsoWorld.instance.CurrentCell.Remove(this);
                    IsoWorld.instance.CurrentCell.getSurvivorList().remove(this);
                }
                return;
            }
            boolean bl = true;
            boolean bl2 = false;
            if (this.last != null && (this.last.Has(IsoObjectType.stairsTN) || this.last.Has(IsoObjectType.stairsTW))) {
                this.current = this.getCell().getGridSquare((int)this.x, (int)this.y, (int)this.z + 1);
                bl = false;
            }
            if (this.current == null) {
                this.current = this.getCell().getGridSquare((int)this.x, (int)this.y, (int)this.z);
                return;
            }
            if (bl) {
                this.nx = this.scriptnx = (float)this.current.getX() + 0.5f;
                this.x = this.scriptnx;
                this.ny = this.scriptny = (float)this.current.getY() + 0.5f;
                this.y = this.scriptny;
            }
            this.z = this.current.getZ();
        }
    }

    public void preupdate() {
        this.nx = this.x;
        this.ny = this.y;
    }

    @Override
    public void renderlast() {
        this.bOutline[IsoCamera.frameState.playerIndex] = false;
    }

    public void spotted(IsoMovingObject isoMovingObject, boolean bl) {
    }

    @Override
    public void update() {
        if (this.def == null) {
            this.def = IsoSpriteInstance.get(this.sprite);
        }
        this.movementLastFrame.x = this.x - this.lx;
        this.movementLastFrame.y = this.y - this.ly;
        this.lx = this.x;
        this.ly = this.y;
        this.lz = this.z;
        this.square = this.current;
        if (this.sprite != null) {
            this.sprite.update(this.def);
        }
        this.StateEventDelayTimer -= GameTime.instance.getMultiplier();
    }

    private void Collided() {
        this.collidedThisFrame = true;
    }

    public int compareToY(IsoMovingObject isoMovingObject) {
        float f;
        if (this.sprite == null && isoMovingObject.sprite == null) {
            return 0;
        }
        if (this.sprite != null && isoMovingObject.sprite == null) {
            return -1;
        }
        if (this.sprite == null) {
            return 1;
        }
        float f2 = IsoUtils.YToScreen(this.x, this.y, this.z, 0);
        if ((double)f2 > (double)(f = IsoUtils.YToScreen(isoMovingObject.x, isoMovingObject.y, isoMovingObject.z, 0))) {
            return 1;
        }
        if ((double)f2 < (double)f) {
            return -1;
        }
        return 0;
    }

    public float distToNearestCamCharacter() {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null) continue;
            f = Math.min(f, this.DistTo(isoPlayer));
        }
        return f;
    }

    public boolean isSolidForSeparate() {
        if (this instanceof IsoZombieGiblets) {
            return false;
        }
        if (this.current == null) {
            return false;
        }
        if (!this.solid) {
            return false;
        }
        return !this.isOnFloor();
    }

    public boolean isPushableForSeparate() {
        return true;
    }

    public boolean isPushedByForSeparate(IsoMovingObject isoMovingObject) {
        return true;
    }

    public void separate() {
        if (!this.isSolidForSeparate()) {
            return;
        }
        if (!this.isPushableForSeparate()) {
            return;
        }
        IsoGameCharacter isoGameCharacter = Type.tryCastTo(this, IsoGameCharacter.class);
        IsoPlayer isoPlayer = Type.tryCastTo(this, IsoPlayer.class);
        if (this.z < 0.0f) {
            this.z = 0.0f;
        }
        for (int i = 0; i <= 8; ++i) {
            IsoGridSquare isoGridSquare;
            IsoGridSquare isoGridSquare2 = isoGridSquare = i == 8 ? this.current : this.current.nav[i];
            if (isoGridSquare == null || isoGridSquare.getMovingObjects().isEmpty() || isoGridSquare != this.current && this.current.isBlockedTo(isoGridSquare)) continue;
            float f = isoPlayer != null && isoPlayer.getPrimaryHandItem() instanceof HandWeapon ? ((HandWeapon)isoPlayer.getPrimaryHandItem()).getMaxRange() : 0.3f;
            int n = isoGridSquare.getMovingObjects().size();
            for (int j = 0; j < n; ++j) {
                IsoMovingObject isoMovingObject = isoGridSquare.getMovingObjects().get(j);
                if (isoMovingObject == this || !isoMovingObject.isSolidForSeparate() || Math.abs(this.z - isoMovingObject.z) > 0.3f) continue;
                IsoGameCharacter isoGameCharacter2 = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class);
                IsoPlayer isoPlayer2 = Type.tryCastTo(isoMovingObject, IsoPlayer.class);
                float f2 = this.width + isoMovingObject.width;
                Vector2 vector22 = tempo;
                vector22.x = this.nx - isoMovingObject.nx;
                vector22.y = this.ny - isoMovingObject.ny;
                float f3 = vector22.getLength();
                if (isoGameCharacter == null || isoGameCharacter2 == null && !(isoMovingObject instanceof BaseVehicle)) {
                    if (f3 < f2) {
                        CollisionManager.instance.AddContact(this, isoMovingObject);
                    }
                    return;
                }
                if (isoGameCharacter2 == null) continue;
                if (isoPlayer != null && isoPlayer.getBumpedChr() != isoMovingObject && f3 < f2 + f && (double)isoPlayer.getForwardDirection().angleBetween(vector22) > 2.6179938155736564 && isoPlayer.getBeenSprintingFor() >= 70.0f && WeaponType.getWeaponType(isoPlayer) == WeaponType.spear) {
                    isoPlayer.reportEvent("ChargeSpearConnect");
                    isoPlayer.setAttackType("charge");
                    isoPlayer.attackStarted = true;
                    isoPlayer.setVariable("StartedAttackWhileSprinting", true);
                    isoPlayer.setBeenSprintingFor(0.0f);
                    return;
                }
                if (f3 >= f2) continue;
                boolean bl = false;
                if (isoPlayer != null && isoPlayer.getVariableFloat("WalkSpeed", 0.0f) > 0.2f && isoPlayer.runningTime > 0.5f && isoPlayer.getBumpedChr() != isoMovingObject) {
                    bl = true;
                }
                if (GameClient.bClient && isoPlayer != null && isoGameCharacter2 instanceof IsoPlayer && !ServerOptions.getInstance().PlayerBumpPlayer.getValue()) {
                    bl = false;
                }
                if (bl && !"charge".equals(isoPlayer.getAttackType())) {
                    Object object;
                    int n2;
                    boolean bl2;
                    boolean bl3 = bl2 = !(this.isOnFloor() || isoGameCharacter.getBumpedChr() == null && (System.currentTimeMillis() - isoPlayer.getLastBump()) / 100L >= 15L && !isoPlayer.isSprinting() || isoPlayer2 != null && isoPlayer2.isNPC());
                    if (bl2) {
                        ++isoGameCharacter.bumpNbr;
                        n2 = 10 - isoGameCharacter.bumpNbr * 3;
                        n2 += isoGameCharacter.getPerkLevel(PerkFactory.Perks.Fitness);
                        n2 += isoGameCharacter.getPerkLevel(PerkFactory.Perks.Strength);
                        if (isoGameCharacter.Traits.Clumsy.isSet()) {
                            n2 -= 5;
                        }
                        if (isoGameCharacter.Traits.Graceful.isSet()) {
                            n2 += 5;
                        }
                        if (isoGameCharacter.Traits.VeryUnderweight.isSet()) {
                            n2 -= 8;
                        }
                        if (isoGameCharacter.Traits.Underweight.isSet()) {
                            n2 -= 4;
                        }
                        if (isoGameCharacter.Traits.Obese.isSet()) {
                            n2 -= 8;
                        }
                        if (isoGameCharacter.Traits.Overweight.isSet()) {
                            n2 -= 4;
                        }
                        if (((BodyPart)(object = isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.Torso_Lower))).getAdditionalPain(true) > 20.0f) {
                            n2 = (int)((float)n2 - (((BodyPart)object).getAdditionalPain(true) - 20.0f) / 20.0f);
                        }
                        n2 = Math.min(80, n2);
                        if (Rand.Next(n2 = Math.max(1, n2)) == 0 || isoGameCharacter.isSprinting()) {
                            isoGameCharacter.setVariable("BumpDone", false);
                            isoGameCharacter.setBumpFall(true);
                            isoGameCharacter.setVariable("TripObstacleType", "zombie");
                        }
                    } else {
                        isoGameCharacter.bumpNbr = 0;
                    }
                    isoGameCharacter.setLastBump(System.currentTimeMillis());
                    isoGameCharacter.setBumpedChr(isoGameCharacter2);
                    isoGameCharacter.setBumpType(this.getBumpedType(isoGameCharacter2));
                    n2 = isoGameCharacter.isBehind(isoGameCharacter2) ? 1 : 0;
                    object = isoGameCharacter.getBumpType();
                    if (n2 != 0) {
                        object = ((String)object).equals("left") ? "right" : "left";
                    }
                    isoGameCharacter2.setBumpType((String)object);
                    isoGameCharacter2.setHitFromBehind(n2 != 0);
                    if (bl2 | GameClient.bClient) {
                        isoGameCharacter.actionContext.reportEvent("wasBumped");
                    }
                }
                if (!GameServer.bServer && !(this.distToNearestCamCharacter() < 60.0f)) continue;
                if (this.isPushedByForSeparate(isoMovingObject)) {
                    vector22.setLength((f3 - f2) / 8.0f);
                    this.nx -= vector22.x;
                    this.ny -= vector22.y;
                }
                this.collideWith(isoMovingObject);
            }
        }
    }

    public String getBumpedType(IsoGameCharacter isoGameCharacter) {
        float f = this.x - isoGameCharacter.x;
        float f2 = this.y - isoGameCharacter.y;
        String string = "left";
        if (this.dir == IsoDirections.S || this.dir == IsoDirections.SE || this.dir == IsoDirections.SW) {
            string = f < 0.0f ? "left" : "right";
        }
        if (this.dir == IsoDirections.N || this.dir == IsoDirections.NE || this.dir == IsoDirections.NW) {
            string = f > 0.0f ? "left" : "right";
        }
        if (this.dir == IsoDirections.E) {
            string = f2 > 0.0f ? "left" : "right";
        }
        if (this.dir == IsoDirections.W) {
            string = f2 < 0.0f ? "left" : "right";
        }
        return string;
    }

    private void slideAwayFromWalls() {
        Object object;
        if (this.current == null) {
            return;
        }
        IsoZombie isoZombie = Type.tryCastTo(this, IsoZombie.class);
        if (isoZombie == null || !this.isOnFloor() && !isoZombie.isKnockedDown()) {
            return;
        }
        if (isoZombie.isCrawling() && (isoZombie.getPath2() != null || isoZombie.isMoving())) {
            return;
        }
        if (isoZombie.isCurrentState(ClimbOverFenceState.instance()) || isoZombie.isCurrentState(ClimbThroughWindowState.instance())) {
            return;
        }
        if (!isoZombie.hasAnimationPlayer() || !isoZombie.getAnimationPlayer().isReady()) {
            return;
        }
        Vector3 vector3 = L_slideAwayFromWalls.vector3;
        Model.BoneToWorldCoords(isoZombie, isoZombie.getAnimationPlayer().getSkinningBoneIndex("Bip01_Head", -1), vector3);
        if (Core.bDebug && DebugOptions.instance.CollideWithObstaclesRenderRadius.getValue()) {
            LineDrawer.DrawIsoCircle(vector3.x, vector3.y, this.z, 0.3f, 16, 1.0f, 1.0f, 0.0f, 1.0f);
        }
        Vector2 vector22 = L_slideAwayFromWalls.vector2.set(vector3.x - this.x, vector3.y - this.y);
        vector22.normalize();
        vector3.x += vector22.x * 0.3f;
        vector3.y += vector22.y * 0.3f;
        if (isoZombie.isKnockedDown() && (isoZombie.isCurrentState(ZombieFallDownState.instance()) || isoZombie.isCurrentState(StaggerBackState.instance()))) {
            object = PolygonalMap2.instance.resolveCollision(isoZombie, vector3.x, vector3.y, L_slideAwayFromWalls.vector2f);
            if (object.x != vector3.x || object.y != vector3.y) {
                float f = GameTime.getInstance().getMultiplier() / 5.0f;
                this.nx += (object.x - vector3.x) * f;
                this.ny += (object.y - vector3.y) * f;
                return;
            }
        }
        if ((int)vector3.x == this.current.x && (int)vector3.y == this.current.y) {
            return;
        }
        object = this.getCell().getGridSquare((int)vector3.x, (int)vector3.y, (int)this.z);
        if (object == null) {
            return;
        }
        if (!this.current.testCollideAdjacent(this, object.x - this.current.x, object.y - this.current.y, 0)) {
            return;
        }
        float f = GameTime.getInstance().getMultiplier() / 5.0f;
        if (object.x < this.current.x) {
            this.nx += ((float)this.current.x - vector3.x) * f;
        } else if (object.x > this.current.x) {
            this.nx += ((float)object.x - vector3.x) * f;
        }
        if (object.y < this.current.y) {
            this.ny += ((float)this.current.y - vector3.y) * f;
        } else if (object.y > this.current.y) {
            this.ny += ((float)object.y - vector3.y) * f;
        }
    }

    private boolean DoCollide(int n) {
        int n2;
        int n3;
        int n4;
        IsoGameCharacter isoGameCharacter = Type.tryCastTo(this, IsoGameCharacter.class);
        this.current = this.getCell().getGridSquare((int)this.nx, (int)this.ny, (int)this.z);
        if (this instanceof IsoMolotovCocktail) {
            for (n4 = (int)this.z; n4 > 0; --n4) {
                for (n3 = -1; n3 <= 1; ++n3) {
                    for (n2 = -1; n2 <= 1; ++n2) {
                        IsoGridSquare isoGridSquare = this.getCell().createNewGridSquare((int)this.nx + n2, (int)this.ny + n3, n4, false);
                        if (isoGridSquare == null) continue;
                        isoGridSquare.RecalcAllWithNeighbours(true);
                    }
                }
            }
        }
        if (this.current != null) {
            if (!this.current.TreatAsSolidFloor()) {
                this.current = this.getCell().getGridSquare((int)this.nx, (int)this.ny, (int)this.z);
            }
            if (this.current == null) {
                return false;
            }
            this.current = this.getCell().getGridSquare((int)this.nx, (int)this.ny, (int)this.z);
        }
        if (this.current != this.last && this.last != null && this.current != null) {
            if (isoGameCharacter != null && isoGameCharacter.getCurrentState() != null && isoGameCharacter.getCurrentState().isIgnoreCollide(isoGameCharacter, this.last.x, this.last.y, this.last.z, this.current.x, this.current.y, this.current.z)) {
                return false;
            }
            if (this == IsoCamera.CamCharacter) {
                IsoWorld.instance.CurrentCell.lightUpdateCount = 10;
            }
            n4 = this.current.getX() - this.last.getX();
            n3 = this.current.getY() - this.last.getY();
            n2 = this.current.getZ() - this.last.getZ();
            boolean bl = false;
            if (this.last.testCollideAdjacent(this, n4, n3, n2) || this.current == null) {
                bl = true;
            }
            if (bl) {
                if (this.last.getX() < this.current.getX()) {
                    this.collidedE = true;
                }
                if (this.last.getX() > this.current.getX()) {
                    this.collidedW = true;
                }
                if (this.last.getY() < this.current.getY()) {
                    this.collidedS = true;
                }
                if (this.last.getY() > this.current.getY()) {
                    this.collidedN = true;
                }
                this.current = this.last;
                this.checkBreakHoppable();
                this.checkHitHoppable();
                if (n == 2) {
                    if ((this.collidedS || this.collidedN) && (this.collidedE || this.collidedW)) {
                        this.collidedS = false;
                        this.collidedN = false;
                    }
                } else if (n == 1 && (this.collidedS || this.collidedN) && (this.collidedE || this.collidedW)) {
                    this.collidedW = false;
                    this.collidedE = false;
                }
                this.Collided();
                return true;
            }
        } else if (this.nx != this.lx || this.ny != this.ly) {
            PathFindBehavior2 pathFindBehavior2;
            if (this instanceof IsoZombie && Core.GameMode.equals("Tutorial")) {
                return true;
            }
            if (this.current == null) {
                if (this.nx < this.lx) {
                    this.collidedW = true;
                }
                if (this.nx > this.lx) {
                    this.collidedE = true;
                }
                if (this.ny < this.ly) {
                    this.collidedN = true;
                }
                if (this.ny > this.ly) {
                    this.collidedS = true;
                }
                this.nx = this.lx;
                this.ny = this.ly;
                this.current = this.last;
                this.Collided();
                return true;
            }
            if (isoGameCharacter != null && isoGameCharacter.getPath2() != null && (int)(pathFindBehavior2 = isoGameCharacter.getPathFindBehavior2()).getTargetX() == (int)this.x && (int)pathFindBehavior2.getTargetY() == (int)this.y && (int)pathFindBehavior2.getTargetZ() == (int)this.z) {
                return false;
            }
            IsoGridSquare isoGridSquare = this.getFeelerTile(this.feelersize);
            if (isoGameCharacter != null) {
                if (isoGameCharacter.isClimbing()) {
                    isoGridSquare = this.current;
                }
                if (isoGridSquare != null && isoGridSquare != this.current && isoGameCharacter.getPath2() != null && !isoGameCharacter.getPath2().crossesSquare(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z)) {
                    isoGridSquare = this.current;
                }
            }
            if (isoGridSquare != null && isoGridSquare != this.current && this.current != null) {
                if (isoGameCharacter != null && isoGameCharacter.getCurrentState() != null && isoGameCharacter.getCurrentState().isIgnoreCollide(isoGameCharacter, this.current.x, this.current.y, this.current.z, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z)) {
                    return false;
                }
                if (this.current.testCollideAdjacent(this, isoGridSquare.getX() - this.current.getX(), isoGridSquare.getY() - this.current.getY(), isoGridSquare.getZ() - this.current.getZ())) {
                    if (this.last != null) {
                        if (this.current.getX() < isoGridSquare.getX()) {
                            this.collidedE = true;
                        }
                        if (this.current.getX() > isoGridSquare.getX()) {
                            this.collidedW = true;
                        }
                        if (this.current.getY() < isoGridSquare.getY()) {
                            this.collidedS = true;
                        }
                        if (this.current.getY() > isoGridSquare.getY()) {
                            this.collidedN = true;
                        }
                        this.checkBreakHoppable();
                        this.checkHitHoppable();
                        if (n == 2 && (this.collidedS || this.collidedN) && (this.collidedE || this.collidedW)) {
                            this.collidedS = false;
                            this.collidedN = false;
                        }
                        if (n == 1 && (this.collidedS || this.collidedN) && (this.collidedE || this.collidedW)) {
                            this.collidedW = false;
                            this.collidedE = false;
                        }
                    }
                    this.Collided();
                    return true;
                }
            }
        }
        return false;
    }

    private void checkHitHoppable() {
        IsoGridSquare isoGridSquare;
        IsoZombie isoZombie = Type.tryCastTo(this, IsoZombie.class);
        if (isoZombie == null || isoZombie.bCrawling) {
            return;
        }
        if (isoZombie.isCurrentState(AttackState.instance()) || isoZombie.isCurrentState(StaggerBackState.instance()) || isoZombie.isCurrentState(ClimbOverFenceState.instance()) || isoZombie.isCurrentState(ClimbThroughWindowState.instance())) {
            return;
        }
        if (this.collidedW && !this.collidedN && !this.collidedS && this.last.Is(IsoFlagType.HoppableW)) {
            isoZombie.climbOverFence(IsoDirections.W);
        }
        if (this.collidedN && !this.collidedE && !this.collidedW && this.last.Is(IsoFlagType.HoppableN)) {
            isoZombie.climbOverFence(IsoDirections.N);
        }
        if (this.collidedS && !this.collidedE && !this.collidedW && (isoGridSquare = this.last.nav[IsoDirections.S.index()]) != null && isoGridSquare.Is(IsoFlagType.HoppableN)) {
            isoZombie.climbOverFence(IsoDirections.S);
        }
        if (this.collidedE && !this.collidedN && !this.collidedS && (isoGridSquare = this.last.nav[IsoDirections.E.index()]) != null && isoGridSquare.Is(IsoFlagType.HoppableW)) {
            isoZombie.climbOverFence(IsoDirections.E);
        }
    }

    private void checkBreakHoppable() {
        IsoZombie isoZombie = Type.tryCastTo(this, IsoZombie.class);
        if (isoZombie == null || !isoZombie.bCrawling) {
            return;
        }
        if (isoZombie.isCurrentState(AttackState.instance()) || isoZombie.isCurrentState(StaggerBackState.instance()) || isoZombie.isCurrentState(CrawlingZombieTurnState.instance())) {
            return;
        }
        IsoDirections isoDirections = IsoDirections.Max;
        if (this.collidedW && !this.collidedN && !this.collidedS) {
            isoDirections = IsoDirections.W;
        }
        if (this.collidedN && !this.collidedE && !this.collidedW) {
            isoDirections = IsoDirections.N;
        }
        if (this.collidedS && !this.collidedE && !this.collidedW) {
            isoDirections = IsoDirections.S;
        }
        if (this.collidedE && !this.collidedN && !this.collidedS) {
            isoDirections = IsoDirections.E;
        }
        if (isoDirections == IsoDirections.Max) {
            return;
        }
        IsoObject isoObject = this.last.getHoppableTo(this.last.getAdjacentSquare(isoDirections));
        IsoThumpable isoThumpable = Type.tryCastTo(isoObject, IsoThumpable.class);
        if (isoThumpable != null && !isoThumpable.isThumpable()) {
            isoZombie.setThumpTarget(isoThumpable);
        } else if (isoObject != null && isoObject.getThumpableFor(isoZombie) != null) {
            isoZombie.setThumpTarget(isoObject);
        }
    }

    private void checkHitWall() {
        if (!(this.collidedN || this.collidedS || this.collidedE || this.collidedW)) {
            return;
        }
        if (this.current == null) {
            return;
        }
        IsoPlayer isoPlayer = Type.tryCastTo(this, IsoPlayer.class);
        if (isoPlayer == null) {
            return;
        }
        if (!StringUtils.isNullOrEmpty(this.getCollideType())) {
            return;
        }
        boolean bl = false;
        int n = this.current.getWallType();
        if ((n & 1) != 0 && this.collidedN && this.getDir() == IsoDirections.N) {
            bl = true;
        }
        if ((n & 2) != 0 && this.collidedS && this.getDir() == IsoDirections.S) {
            bl = true;
        }
        if ((n & 4) != 0 && this.collidedW && this.getDir() == IsoDirections.W) {
            bl = true;
        }
        if ((n & 8) != 0 && this.collidedE && this.getDir() == IsoDirections.E) {
            bl = true;
        }
        if (this.checkVaultOver()) {
            bl = false;
        }
        if (bl && isoPlayer.isSprinting() && isoPlayer.isLocalPlayer()) {
            this.setCollideType("wall");
            isoPlayer.getActionContext().reportEvent("collideWithWall");
            this.lastCollideTime = 70.0f;
        }
    }

    private boolean checkVaultOver() {
        IsoPlayer isoPlayer = (IsoPlayer)this;
        if (isoPlayer.isCurrentState(ClimbOverFenceState.instance()) || isoPlayer.isIgnoreAutoVault()) {
            return false;
        }
        if (!isoPlayer.IsRunning() && !isoPlayer.isSprinting() && isoPlayer.isLocalPlayer()) {
            return false;
        }
        IsoDirections isoDirections = this.getDir();
        IsoGridSquare isoGridSquare = this.current.getAdjacentSquare(IsoDirections.SE);
        if (isoDirections == IsoDirections.SE && isoGridSquare != null && isoGridSquare.Is(IsoFlagType.HoppableN) && isoGridSquare.Is(IsoFlagType.HoppableW)) {
            return false;
        }
        IsoGridSquare isoGridSquare2 = this.current;
        if (this.collidedS) {
            isoGridSquare2 = this.current.getAdjacentSquare(IsoDirections.S);
        } else if (this.collidedE) {
            isoGridSquare2 = this.current.getAdjacentSquare(IsoDirections.E);
        }
        if (isoGridSquare2 == null) {
            return false;
        }
        boolean bl = false;
        if (this.current.getProperties().Is(IsoFlagType.HoppableN) && this.collidedN && !this.collidedW && !this.collidedE && (isoDirections == IsoDirections.NW || isoDirections == IsoDirections.N || isoDirections == IsoDirections.NE)) {
            isoDirections = IsoDirections.N;
            bl = true;
        }
        if (isoGridSquare2.getProperties().Is(IsoFlagType.HoppableN) && this.collidedS && !this.collidedW && !this.collidedE && (isoDirections == IsoDirections.SW || isoDirections == IsoDirections.S || isoDirections == IsoDirections.SE)) {
            isoDirections = IsoDirections.S;
            bl = true;
        }
        if (this.current.getProperties().Is(IsoFlagType.HoppableW) && this.collidedW && !this.collidedN && !this.collidedS && (isoDirections == IsoDirections.NW || isoDirections == IsoDirections.W || isoDirections == IsoDirections.SW)) {
            isoDirections = IsoDirections.W;
            bl = true;
        }
        if (isoGridSquare2.getProperties().Is(IsoFlagType.HoppableW) && this.collidedE && !this.collidedN && !this.collidedS && (isoDirections == IsoDirections.NE || isoDirections == IsoDirections.E || isoDirections == IsoDirections.SE)) {
            isoDirections = IsoDirections.E;
            bl = true;
        }
        if (bl && isoPlayer.isSafeToClimbOver(isoDirections)) {
            ClimbOverFenceState.instance().setParams(isoPlayer, isoDirections);
            isoPlayer.getActionContext().reportEvent("EventClimbFence");
            return true;
        }
        return false;
    }

    public void setMovingSquareNow() {
        if (this.movingSq != null) {
            this.movingSq.getMovingObjects().remove(this);
            this.movingSq = null;
        }
        if (this.current != null && !this.current.getMovingObjects().contains(this)) {
            this.current.getMovingObjects().add(this);
            this.movingSq = this.current;
        }
    }

    public IsoGridSquare getFeelerTile(float f) {
        Vector2 vector22 = tempo;
        vector22.x = this.nx - this.lx;
        vector22.y = this.ny - this.ly;
        vector22.setLength(f);
        return this.getCell().getGridSquare((int)(this.x + vector22.x), (int)(this.y + vector22.y), (int)this.z);
    }

    public void DoCollideNorS() {
        this.ny = this.ly;
    }

    public void DoCollideWorE() {
        this.nx = this.lx;
    }

    public int getTimeSinceZombieAttack() {
        return this.TimeSinceZombieAttack;
    }

    public void setTimeSinceZombieAttack(int n) {
        this.TimeSinceZombieAttack = n;
    }

    public boolean isCollidedE() {
        return this.collidedE;
    }

    public void setCollidedE(boolean bl) {
        this.collidedE = bl;
    }

    public boolean isCollidedN() {
        return this.collidedN;
    }

    public void setCollidedN(boolean bl) {
        this.collidedN = bl;
    }

    public IsoObject getCollidedObject() {
        return this.CollidedObject;
    }

    public void setCollidedObject(IsoObject isoObject) {
        this.CollidedObject = isoObject;
    }

    public boolean isCollidedS() {
        return this.collidedS;
    }

    public void setCollidedS(boolean bl) {
        this.collidedS = bl;
    }

    public boolean isCollidedThisFrame() {
        return this.collidedThisFrame;
    }

    public void setCollidedThisFrame(boolean bl) {
        this.collidedThisFrame = bl;
    }

    public boolean isCollidedW() {
        return this.collidedW;
    }

    public void setCollidedW(boolean bl) {
        this.collidedW = bl;
    }

    public boolean isCollidedWithDoor() {
        return this.CollidedWithDoor;
    }

    public void setCollidedWithDoor(boolean bl) {
        this.CollidedWithDoor = bl;
    }

    public boolean isCollidedWithVehicle() {
        return this.collidedWithVehicle;
    }

    public IsoGridSquare getCurrentSquare() {
        return this.current;
    }

    public IsoMetaGrid.Zone getCurrentZone() {
        if (this.current != null) {
            return this.current.getZone();
        }
        return null;
    }

    public void setCurrent(IsoGridSquare isoGridSquare) {
        this.current = isoGridSquare;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    public boolean isFirstUpdate() {
        return this.firstUpdate;
    }

    public void setFirstUpdate(boolean bl) {
        this.firstUpdate = bl;
    }

    public Vector2 getHitDir() {
        return this.hitDir;
    }

    public void setHitDir(Vector2 vector22) {
        this.hitDir.set(vector22);
    }

    public float getImpulsex() {
        return this.impulsex;
    }

    public void setImpulsex(float f) {
        this.impulsex = f;
    }

    public float getImpulsey() {
        return this.impulsey;
    }

    public void setImpulsey(float f) {
        this.impulsey = f;
    }

    public float getLimpulsex() {
        return this.limpulsex;
    }

    public void setLimpulsex(float f) {
        this.limpulsex = f;
    }

    public float getLimpulsey() {
        return this.limpulsey;
    }

    public void setLimpulsey(float f) {
        this.limpulsey = f;
    }

    public float getHitForce() {
        return this.hitForce;
    }

    public void setHitForce(float f) {
        this.hitForce = f;
    }

    public float getHitFromAngle() {
        return this.hitFromAngle;
    }

    public void setHitFromAngle(float f) {
        this.hitFromAngle = f;
    }

    public IsoGridSquare getLastSquare() {
        return this.last;
    }

    public void setLast(IsoGridSquare isoGridSquare) {
        this.last = isoGridSquare;
    }

    public float getLx() {
        return this.lx;
    }

    public void setLx(float f) {
        this.lx = f;
    }

    public float getLy() {
        return this.ly;
    }

    public void setLy(float f) {
        this.ly = f;
    }

    public float getLz() {
        return this.lz;
    }

    public void setLz(float f) {
        this.lz = f;
    }

    public float getNx() {
        return this.nx;
    }

    public void setNx(float f) {
        this.nx = f;
    }

    public float getNy() {
        return this.ny;
    }

    public void setNy(float f) {
        this.ny = f;
    }

    public boolean getNoDamage() {
        return this.noDamage;
    }

    public void setNoDamage(boolean bl) {
        this.noDamage = bl;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public void setSolid(boolean bl) {
        this.solid = bl;
    }

    public float getStateEventDelayTimer() {
        return this.StateEventDelayTimer;
    }

    public void setStateEventDelayTimer(float f) {
        this.StateEventDelayTimer = f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public boolean isbAltCollide() {
        return this.bAltCollide;
    }

    public void setbAltCollide(boolean bl) {
        this.bAltCollide = bl;
    }

    public boolean isShootable() {
        return this.shootable;
    }

    public void setShootable(boolean bl) {
        this.shootable = bl;
    }

    public IsoZombie getLastTargettedBy() {
        return this.lastTargettedBy;
    }

    public void setLastTargettedBy(IsoZombie isoZombie) {
        this.lastTargettedBy = isoZombie;
    }

    public boolean isCollidable() {
        return this.Collidable;
    }

    public void setCollidable(boolean bl) {
        this.Collidable = bl;
    }

    public float getScriptnx() {
        return this.scriptnx;
    }

    public void setScriptnx(float f) {
        this.scriptnx = f;
    }

    public float getScriptny() {
        return this.scriptny;
    }

    public void setScriptny(float f) {
        this.scriptny = f;
    }

    public String getScriptModule() {
        return this.ScriptModule;
    }

    public void setScriptModule(String string) {
        this.ScriptModule = string;
    }

    public Vector2 getMovementLastFrame() {
        return this.movementLastFrame;
    }

    public void setMovementLastFrame(Vector2 vector22) {
        this.movementLastFrame = vector22;
    }

    public float getFeelersize() {
        return this.feelersize;
    }

    public void setFeelersize(float f) {
        this.feelersize = f;
    }

    public byte canHaveMultipleHits() {
        byte by = 0;
        ArrayList<IsoMovingObject> arrayList = IsoWorld.instance.CurrentCell.getObjectList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LosUtil.TestResults testResults;
            float f;
            float f2;
            IsoMovingObject isoMovingObject = arrayList.get(i);
            IsoPlayer isoPlayer = Type.tryCastTo(isoMovingObject, IsoPlayer.class);
            if (isoPlayer == null) continue;
            HandWeapon handWeapon = Type.tryCastTo(isoPlayer.getPrimaryHandItem(), HandWeapon.class);
            if (handWeapon == null || isoPlayer.bDoShove || isoPlayer.isForceShove()) {
                handWeapon = isoPlayer.bareHands;
            }
            if ((f2 = IsoUtils.DistanceTo(isoPlayer.x, isoPlayer.y, this.x, this.y)) > (f = handWeapon.getMaxRange() * handWeapon.getRangeMod(isoPlayer) + 2.0f)) continue;
            float f3 = isoPlayer.getDotWithForwardDirection(this.x, this.y);
            if ((double)f2 > 2.5 && f3 < 0.1f || (testResults = LosUtil.lineClear(isoPlayer.getCell(), (int)isoPlayer.getX(), (int)isoPlayer.getY(), (int)isoPlayer.getZ(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), false)) == LosUtil.TestResults.Blocked || testResults == LosUtil.TestResults.ClearThroughClosedDoor || (by = (byte)(by + 1)) < 2) continue;
            return by;
        }
        return by;
    }

    public boolean isOnFloor() {
        return this.bOnFloor;
    }

    public void setOnFloor(boolean bl) {
        this.bOnFloor = bl;
    }

    public void Despawn() {
    }

    public boolean isCloseKilled() {
        return this.closeKilled;
    }

    public void setCloseKilled(boolean bl) {
        this.closeKilled = bl;
    }

    @Override
    public Vector2 getFacingPosition(Vector2 vector22) {
        vector22.set(this.getX(), this.getY());
        return vector22;
    }

    private boolean isInLoadedArea(int n, int n2) {
        if (GameServer.bServer) {
            for (int i = 0; i < ServerMap.instance.LoadedCells.size(); ++i) {
                ServerMap.ServerCell serverCell = ServerMap.instance.LoadedCells.get(i);
                if (n < serverCell.WX * 50 || n >= (serverCell.WX + 1) * 50 || n2 < serverCell.WY * 50 || n2 >= (serverCell.WY + 1) * 50) continue;
                return true;
            }
        } else {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[i];
                if (isoChunkMap.ignore || n < isoChunkMap.getWorldXMinTiles() || n >= isoChunkMap.getWorldXMaxTiles() || n2 < isoChunkMap.getWorldYMinTiles() || n2 >= isoChunkMap.getWorldYMaxTiles()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCollided() {
        return !StringUtils.isNullOrWhitespace(this.getCollideType());
    }

    public String getCollideType() {
        return this.collideType;
    }

    public void setCollideType(String string) {
        this.collideType = string;
    }

    public float getLastCollideTime() {
        return this.lastCollideTime;
    }

    public void setLastCollideTime(float f) {
        this.lastCollideTime = f;
    }

    public ArrayList<IsoZombie> getEatingZombies() {
        return this.eatingZombies;
    }

    public void setEatingZombies(ArrayList<IsoZombie> arrayList) {
        this.eatingZombies.clear();
        this.eatingZombies.addAll(arrayList);
    }

    public boolean isEatingOther(IsoMovingObject isoMovingObject) {
        if (isoMovingObject == null) {
            return false;
        }
        return isoMovingObject.eatingZombies.contains(this);
    }

    public float getDistanceSq(IsoMovingObject isoMovingObject) {
        float f = this.x - isoMovingObject.x;
        float f2 = this.y - isoMovingObject.y;
        f *= f;
        f2 *= f2;
        return f + f2;
    }

    public void setZombiesDontAttack(boolean bl) {
        this.zombiesDontAttack = bl;
    }

    public boolean isZombiesDontAttack() {
        return this.zombiesDontAttack;
    }

    public static class TreeSoundManager {
        private ArrayList<IsoGridSquare> squares = new ArrayList();
        private long[] soundTime = new long[6];
        private Comparator<IsoGridSquare> comp = (isoGridSquare, isoGridSquare2) -> {
            float f;
            float f2 = this.getClosestListener((float)isoGridSquare.x + 0.5f, (float)isoGridSquare.y + 0.5f, isoGridSquare.z);
            if (f2 > (f = this.getClosestListener((float)isoGridSquare2.x + 0.5f, (float)isoGridSquare2.y + 0.5f, isoGridSquare2.z))) {
                return 1;
            }
            if (f2 < f) {
                return -1;
            }
            return 0;
        };

        public void addSquare(IsoGridSquare isoGridSquare) {
            if (!this.squares.contains(isoGridSquare)) {
                this.squares.add(isoGridSquare);
            }
        }

        public void update() {
            if (this.squares.isEmpty()) {
                return;
            }
            Collections.sort(this.squares, this.comp);
            long l = System.currentTimeMillis();
            for (int i = 0; i < this.soundTime.length && i < this.squares.size(); ++i) {
                IsoGridSquare isoGridSquare = this.squares.get(i);
                if (this.getClosestListener((float)isoGridSquare.x + 0.5f, (float)isoGridSquare.y + 0.5f, isoGridSquare.z) > 20.0f) continue;
                int n = this.getFreeSoundSlot(l);
                if (n == -1) break;
                Audio audio = null;
                float f = 0.05f;
                float f2 = 16.0f;
                float f3 = 0.29999998f;
                if (GameClient.bClient) {
                    audio = SoundManager.instance.PlayWorldSoundImpl("Bushes", false, isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ(), f, f2, f3, false);
                } else {
                    BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter((float)isoGridSquare.x + 0.5f, (float)isoGridSquare.y + 0.5f, isoGridSquare.z);
                    if (baseSoundEmitter.playSound("Bushes") != 0L) {
                        this.soundTime[n] = l;
                    }
                }
                if (audio == null) continue;
                this.soundTime[n] = l;
            }
            this.squares.clear();
        }

        private float getClosestListener(float f, float f2, float f3) {
            float f4 = Float.MAX_VALUE;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.getCurrentSquare() == null) continue;
                float f5 = isoPlayer.getX();
                float f6 = isoPlayer.getY();
                float f7 = isoPlayer.getZ();
                float f8 = IsoUtils.DistanceTo(f5, f6, f7 * 3.0f, f, f2, f3 * 3.0f);
                if (isoPlayer.Traits.HardOfHearing.isSet()) {
                    f8 *= 4.5f;
                }
                if (!(f8 < f4)) continue;
                f4 = f8;
            }
            return f4;
        }

        private int getFreeSoundSlot(long l) {
            long l2 = Long.MAX_VALUE;
            int n = -1;
            for (int i = 0; i < this.soundTime.length; ++i) {
                if (this.soundTime[i] >= l2) continue;
                l2 = this.soundTime[i];
                n = i;
            }
            if (l - l2 < 1000L) {
                return -1;
            }
            return n;
        }
    }

    private static final class L_postUpdate {
        static final Vector2f vector2f = new Vector2f();

        private L_postUpdate() {
        }
    }

    private static final class L_slideAwayFromWalls {
        static final Vector2f vector2f = new Vector2f();
        static final Vector2 vector2 = new Vector2();
        static final Vector3 vector3 = new Vector3();

        private L_slideAwayFromWalls() {
        }
    }
}

