/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.joml.Vector2f;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.MapGroups;
import zombie.SandboxOptions;
import zombie.ZomboidFileSystem;
import zombie.characters.Faction;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.stash.StashSystem;
import zombie.debug.DebugLog;
import zombie.gameStates.ChooseGameInfo;
import zombie.iso.BuildingDef;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLot;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaChunk;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LotHeader;
import zombie.iso.MetaObject;
import zombie.iso.RoomDef;
import zombie.iso.SliceY;
import zombie.iso.Vector2;
import zombie.iso.areas.NonPvpZone;
import zombie.iso.areas.SafeHouse;
import zombie.iso.objects.IsoMannequin;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.randomizedWorld.randomizedBuilding.RBBasic;
import zombie.randomizedWorld.randomizedZoneStory.RandomizedZoneStoryBase;
import zombie.util.BufferedRandomAccessFile;
import zombie.util.SharedStrings;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.Clipper;
import zombie.vehicles.ClipperOffset;
import zombie.vehicles.PolygonalMap2;

public final class IsoMetaGrid {
    private static final int NUM_LOADER_THREADS = 8;
    private static ArrayList<String> s_PreferredZoneTypes = new ArrayList();
    private static Clipper s_clipper = null;
    private static ClipperOffset s_clipperOffset = null;
    private static ByteBuffer s_clipperBuffer = null;
    private static final ThreadLocal<IsoGameCharacter.Location> TL_Location = ThreadLocal.withInitial(IsoGameCharacter.Location::new);
    private static final ThreadLocal<ArrayList<Zone>> TL_ZoneList = ThreadLocal.withInitial(ArrayList::new);
    static Rectangle a = new Rectangle();
    static Rectangle b = new Rectangle();
    static ArrayList<RoomDef> roomChoices = new ArrayList(50);
    private final ArrayList<RoomDef> tempRooms = new ArrayList();
    private final ArrayList<Zone> tempZones1 = new ArrayList();
    private final ArrayList<Zone> tempZones2 = new ArrayList();
    private final MetaGridLoaderThread[] threads = new MetaGridLoaderThread[8];
    public int minX = 10000000;
    public int minY = 10000000;
    public int maxX = -10000000;
    public int maxY = -10000000;
    public final ArrayList<Zone> Zones = new ArrayList();
    public final ArrayList<BuildingDef> Buildings = new ArrayList();
    public final ArrayList<VehicleZone> VehiclesZones = new ArrayList();
    public IsoMetaCell[][] Grid;
    public final ArrayList<IsoGameCharacter> MetaCharacters = new ArrayList();
    final ArrayList<Vector2> HighZombieList = new ArrayList();
    private int width;
    private int height;
    private final SharedStrings sharedStrings = new SharedStrings();
    private long createStartTime;

    public void AddToMeta(IsoGameCharacter isoGameCharacter) {
        IsoWorld.instance.CurrentCell.Remove(isoGameCharacter);
        if (!this.MetaCharacters.contains(isoGameCharacter)) {
            this.MetaCharacters.add(isoGameCharacter);
        }
    }

    public void RemoveFromMeta(IsoPlayer isoPlayer) {
        this.MetaCharacters.remove(isoPlayer);
        if (!IsoWorld.instance.CurrentCell.getObjectList().contains(isoPlayer)) {
            IsoWorld.instance.CurrentCell.getObjectList().add(isoPlayer);
        }
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public Zone getZoneAt(int n, int n2, int n3) {
        IsoMetaChunk isoMetaChunk = this.getChunkDataFromTile(n, n2);
        if (isoMetaChunk != null) {
            return isoMetaChunk.getZoneAt(n, n2, n3);
        }
        return null;
    }

    public ArrayList<Zone> getZonesAt(int n, int n2, int n3) {
        return this.getZonesAt(n, n2, n3, new ArrayList<Zone>());
    }

    public ArrayList<Zone> getZonesAt(int n, int n2, int n3, ArrayList<Zone> arrayList) {
        IsoMetaChunk isoMetaChunk = this.getChunkDataFromTile(n, n2);
        if (isoMetaChunk != null) {
            return isoMetaChunk.getZonesAt(n, n2, n3, arrayList);
        }
        return arrayList;
    }

    public ArrayList<Zone> getZonesIntersecting(int n, int n2, int n3, int n4, int n5) {
        ArrayList<Zone> arrayList = new ArrayList<Zone>();
        return this.getZonesIntersecting(n, n2, n3, n4, n5, arrayList);
    }

    public ArrayList<Zone> getZonesIntersecting(int n, int n2, int n3, int n4, int n5, ArrayList<Zone> arrayList) {
        for (int i = n2 / 300; i <= (n2 + n5) / 300; ++i) {
            for (int j = n / 300; j <= (n + n4) / 300; ++j) {
                if (j < this.minX || j > this.maxX || i < this.minY || i > this.maxY || this.Grid[j - this.minX][i - this.minY] == null) continue;
                this.Grid[j - this.minX][i - this.minY].getZonesIntersecting(n, n2, n3, n4, n5, arrayList);
            }
        }
        return arrayList;
    }

    public Zone getZoneWithBoundsAndType(int n, int n2, int n3, int n4, int n5, String string) {
        ArrayList<Zone> arrayList = TL_ZoneList.get();
        arrayList.clear();
        this.getZonesIntersecting(n, n2, n3, n4, n5, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Zone zone = arrayList.get(i);
            if (zone.x != n || zone.y != n2 || zone.z != n3 || zone.w != n4 || zone.h != n5 || !StringUtils.equalsIgnoreCase(zone.type, string)) continue;
            return zone;
        }
        return null;
    }

    public VehicleZone getVehicleZoneAt(int n, int n2, int n3) {
        IsoMetaCell isoMetaCell = this.getMetaGridFromTile(n, n2);
        if (isoMetaCell == null || isoMetaCell.vehicleZones.isEmpty()) {
            return null;
        }
        for (int i = 0; i < isoMetaCell.vehicleZones.size(); ++i) {
            VehicleZone vehicleZone = isoMetaCell.vehicleZones.get(i);
            if (!vehicleZone.contains(n, n2, n3)) continue;
            return vehicleZone;
        }
        return null;
    }

    public BuildingDef getBuildingAt(int n, int n2) {
        for (int i = 0; i < this.Buildings.size(); ++i) {
            BuildingDef buildingDef = this.Buildings.get(i);
            if (buildingDef.x > n || buildingDef.y > n2 || buildingDef.getW() <= n - buildingDef.x || buildingDef.getH() <= n2 - buildingDef.y) continue;
            return buildingDef;
        }
        return null;
    }

    public BuildingDef getBuildingAtRelax(int n, int n2) {
        for (int i = 0; i < this.Buildings.size(); ++i) {
            BuildingDef buildingDef = this.Buildings.get(i);
            if (buildingDef.x > n + 1 || buildingDef.y > n2 + 1 || buildingDef.getW() <= n - buildingDef.x - 1 || buildingDef.getH() <= n2 - buildingDef.y - 1) continue;
            return buildingDef;
        }
        return null;
    }

    public RoomDef getRoomAt(int n, int n2, int n3) {
        IsoMetaChunk isoMetaChunk = this.getChunkDataFromTile(n, n2);
        if (isoMetaChunk != null) {
            return isoMetaChunk.getRoomAt(n, n2, n3);
        }
        return null;
    }

    public RoomDef getEmptyOutsideAt(int n, int n2, int n3) {
        IsoMetaChunk isoMetaChunk = this.getChunkDataFromTile(n, n2);
        if (isoMetaChunk != null) {
            return isoMetaChunk.getEmptyOutsideAt(n, n2, n3);
        }
        return null;
    }

    public void getRoomsIntersecting(int n, int n2, int n3, int n4, ArrayList<RoomDef> arrayList) {
        for (int i = n2 / 300; i <= (n2 + this.height) / 300; ++i) {
            for (int j = n / 300; j <= (n + this.width) / 300; ++j) {
                IsoMetaCell isoMetaCell;
                if (j < this.minX || j > this.maxX || i < this.minY || i > this.maxY || (isoMetaCell = this.Grid[j - this.minX][i - this.minY]) == null) continue;
                isoMetaCell.getRoomsIntersecting(n, n2, n3, n4, arrayList);
            }
        }
    }

    public int countRoomsIntersecting(int n, int n2, int n3, int n4) {
        this.tempRooms.clear();
        for (int i = n2 / 300; i <= (n2 + this.height) / 300; ++i) {
            for (int j = n / 300; j <= (n + this.width) / 300; ++j) {
                IsoMetaCell isoMetaCell;
                if (j < this.minX || j > this.maxX || i < this.minY || i > this.maxY || (isoMetaCell = this.Grid[j - this.minX][i - this.minY]) == null) continue;
                isoMetaCell.getRoomsIntersecting(n, n2, n3, n4, this.tempRooms);
            }
        }
        return this.tempRooms.size();
    }

    public int countNearbyBuildingsRooms(IsoPlayer isoPlayer) {
        int n = (int)isoPlayer.getX() - 20;
        int n2 = (int)isoPlayer.getY() - 20;
        int n3 = 40;
        int n4 = 40;
        int n5 = this.countRoomsIntersecting(n, n2, n3, n4);
        return n5;
    }

    private boolean isInside(Zone zone, BuildingDef buildingDef) {
        IsoMetaGrid.a.x = zone.x;
        IsoMetaGrid.a.y = zone.y;
        IsoMetaGrid.a.width = zone.w;
        IsoMetaGrid.a.height = zone.h;
        IsoMetaGrid.b.x = buildingDef.x;
        IsoMetaGrid.b.y = buildingDef.y;
        IsoMetaGrid.b.width = buildingDef.getW();
        IsoMetaGrid.b.height = buildingDef.getH();
        return a.contains(b);
    }

    private boolean isAdjacent(Zone zone, Zone zone2) {
        if (zone == zone2) {
            return false;
        }
        IsoMetaGrid.a.x = zone.x;
        IsoMetaGrid.a.y = zone.y;
        IsoMetaGrid.a.width = zone.w;
        IsoMetaGrid.a.height = zone.h;
        IsoMetaGrid.b.x = zone2.x;
        IsoMetaGrid.b.y = zone2.y;
        IsoMetaGrid.b.width = zone2.w;
        IsoMetaGrid.b.height = zone2.h;
        --IsoMetaGrid.a.x;
        --IsoMetaGrid.a.y;
        IsoMetaGrid.a.width += 2;
        IsoMetaGrid.a.height += 2;
        --IsoMetaGrid.b.x;
        --IsoMetaGrid.b.y;
        IsoMetaGrid.b.width += 2;
        IsoMetaGrid.b.height += 2;
        return a.intersects(b);
    }

    public Zone registerZone(String string, String string2, int n, int n2, int n3, int n4, int n5) {
        return this.registerZone(string, string2, n, n2, n3, n4, n5, ZoneGeometryType.INVALID, null, 0);
    }

    public Zone registerZone(String string, String string2, int n, int n2, int n3, int n4, int n5, ZoneGeometryType zoneGeometryType, TIntArrayList tIntArrayList, int n6) {
        string = this.sharedStrings.get(string);
        string2 = this.sharedStrings.get(string2);
        Zone zone = new Zone(string, string2, n, n2, n3, n4, n5);
        zone.geometryType = zoneGeometryType;
        if (tIntArrayList != null) {
            zone.points.addAll((TIntCollection)tIntArrayList);
            zone.polylineWidth = n6;
        }
        zone.isPreferredZoneForSquare = IsoMetaGrid.isPreferredZoneForSquare(string2);
        if (n < this.minX * 300 - 100 || n2 < this.minY * 300 - 100 || n + n4 > (this.maxX + 1) * 300 + 100 || n2 + n5 > (this.maxY + 1) * 300 + 100 || n3 < 0 || n3 >= 8 || n4 > 600 || n5 > 600) {
            return zone;
        }
        this.addZone(zone);
        return zone;
    }

    public Zone registerGeometryZone(String string, String string2, int n, String string3, KahluaTable kahluaTable, KahluaTable kahluaTable2) {
        Object object;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        TIntArrayList tIntArrayList = new TIntArrayList(kahluaTable.len());
        for (int i = 0; i < kahluaTable.len(); i += 2) {
            object = kahluaTable.rawget(i + 1);
            Object object2 = kahluaTable.rawget(i + 2);
            int n6 = ((Double)object).intValue();
            int n7 = ((Double)object2).intValue();
            tIntArrayList.add(n6);
            tIntArrayList.add(n7);
            n2 = Math.min(n2, n6);
            n3 = Math.min(n3, n7);
            n4 = Math.max(n4, n6);
            n5 = Math.max(n5, n7);
        }
        ZoneGeometryType zoneGeometryType = switch (string3) {
            case "point" -> ZoneGeometryType.Point;
            case "polygon" -> ZoneGeometryType.Polygon;
            case "polyline" -> ZoneGeometryType.Polyline;
            default -> throw new IllegalArgumentException("unknown zone geometry type");
        };
        Object object3 = object = zoneGeometryType != ZoneGeometryType.Polyline || kahluaTable2 == null ? null : Type.tryCastTo(kahluaTable2.rawget((Object)"LineWidth"), Double.class);
        if (object != null) {
            int[] nArray = new int[4];
            this.calculatePolylineOutlineBounds(tIntArrayList, ((Double)object).intValue(), nArray);
            n2 = nArray[0];
            n3 = nArray[1];
            n4 = nArray[2];
            n5 = nArray[3];
        }
        if (string2.equals("Vehicle") || string2.equals("ParkingStall")) {
            Zone zone = this.registerVehiclesZone(string, string2, n2, n3, n, n4 - n2 + 1, n5 - n3 + 1, kahluaTable2);
            if (zone != null) {
                zone.geometryType = zoneGeometryType;
                zone.points.addAll((TIntCollection)tIntArrayList);
                zone.polylineWidth = object == null ? 0 : ((Double)object).intValue();
            }
            return zone;
        }
        Zone zone = this.registerZone(string, string2, n2, n3, n, n4 - n2 + 1, n5 - n3 + 1, zoneGeometryType, tIntArrayList, object == null ? 0 : ((Double)object).intValue());
        tIntArrayList.clear();
        return zone;
    }

    private void calculatePolylineOutlineBounds(TIntArrayList tIntArrayList, int n, int[] nArray) {
        int n2;
        int n3;
        if (s_clipperOffset == null) {
            s_clipperOffset = new ClipperOffset();
            s_clipperBuffer = ByteBuffer.allocateDirect(3072);
        }
        s_clipperOffset.clear();
        s_clipperBuffer.clear();
        float f = n % 2 == 0 ? 0.0f : 0.5f;
        for (n3 = 0; n3 < tIntArrayList.size(); n3 += 2) {
            n2 = tIntArrayList.get(n3);
            int n4 = tIntArrayList.get(n3 + 1);
            s_clipperBuffer.putFloat((float)n2 + f);
            s_clipperBuffer.putFloat((float)n4 + f);
        }
        s_clipperBuffer.flip();
        s_clipperOffset.addPath(tIntArrayList.size() / 2, s_clipperBuffer, ClipperOffset.JoinType.jtMiter.ordinal(), ClipperOffset.EndType.etOpenButt.ordinal());
        s_clipperOffset.execute((float)n / 2.0f);
        n3 = s_clipperOffset.getPolygonCount();
        if (n3 < 1) {
            DebugLog.General.warn("Failed to generate polyline outline");
            return;
        }
        s_clipperBuffer.clear();
        s_clipperOffset.getPolygon(0, s_clipperBuffer);
        n2 = s_clipperBuffer.getShort();
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        float f4 = -3.4028235E38f;
        float f5 = -3.4028235E38f;
        for (int i = 0; i < n2; ++i) {
            float f6 = s_clipperBuffer.getFloat();
            float f7 = s_clipperBuffer.getFloat();
            f2 = PZMath.min(f2, f6);
            f3 = PZMath.min(f3, f7);
            f4 = PZMath.max(f4, f6);
            f5 = PZMath.max(f5, f7);
        }
        nArray[0] = (int)PZMath.floor(f2);
        nArray[1] = (int)PZMath.floor(f3);
        nArray[2] = (int)PZMath.ceil(f4);
        nArray[3] = (int)PZMath.ceil(f5);
    }

    @Deprecated
    public Zone registerZoneNoOverlap(String string, String string2, int n, int n2, int n3, int n4, int n5) {
        if (n < this.minX * 300 - 100 || n2 < this.minY * 300 - 100 || n + n4 > (this.maxX + 1) * 300 + 100 || n2 + n5 > (this.maxY + 1) * 300 + 100 || n3 < 0 || n3 >= 8 || n4 > 600 || n5 > 600) {
            return null;
        }
        return this.registerZone(string, string2, n, n2, n3, n4, n5);
    }

    private void addZone(Zone zone) {
        this.Zones.add(zone);
        for (int i = zone.y / 300; i <= (zone.y + zone.h) / 300; ++i) {
            for (int j = zone.x / 300; j <= (zone.x + zone.w) / 300; ++j) {
                if (j < this.minX || j > this.maxX || i < this.minY || i > this.maxY || this.Grid[j - this.minX][i - this.minY] == null) continue;
                this.Grid[j - this.minX][i - this.minY].addZone(zone, j * 300, i * 300);
            }
        }
    }

    public void removeZone(Zone zone) {
        this.Zones.remove(zone);
        for (int i = zone.y / 300; i <= (zone.y + zone.h) / 300; ++i) {
            for (int j = zone.x / 300; j <= (zone.x + zone.w) / 300; ++j) {
                if (j < this.minX || j > this.maxX || i < this.minY || i > this.maxY || this.Grid[j - this.minX][i - this.minY] == null) continue;
                this.Grid[j - this.minX][i - this.minY].removeZone(zone);
            }
        }
    }

    public void removeZonesForCell(int n, int n2) {
        int n3;
        IsoMetaCell isoMetaCell = this.getCellData(n, n2);
        if (isoMetaCell == null) {
            return;
        }
        ArrayList<Zone> arrayList = this.tempZones1;
        arrayList.clear();
        for (n3 = 0; n3 < 900; ++n3) {
            isoMetaCell.ChunkMap[n3].getZonesIntersecting(n * 300, n2 * 300, 0, 300, 300, arrayList);
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            ArrayList<Zone> arrayList2;
            Zone zone = arrayList.get(n3);
            if (!zone.difference(n * 300, n2 * 300, 0, 300, 300, arrayList2 = this.tempZones2)) continue;
            this.removeZone(zone);
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.addZone(arrayList2.get(i));
            }
        }
        if (!isoMetaCell.vehicleZones.isEmpty()) {
            isoMetaCell.vehicleZones.clear();
        }
        if (!isoMetaCell.mannequinZones.isEmpty()) {
            isoMetaCell.mannequinZones.clear();
        }
    }

    public void removeZonesForLotDirectory(String string) {
        if (this.Zones.isEmpty()) {
            return;
        }
        File file = new File(ZomboidFileSystem.instance.getString("media/maps/" + string + "/"));
        if (!file.isDirectory()) {
            return;
        }
        ChooseGameInfo.Map map = ChooseGameInfo.getMapDetails(string);
        if (map == null) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.endsWith(".lotheader")) continue;
            String[] stringArray2 = string2.split("_");
            stringArray2[1] = stringArray2[1].replace(".lotheader", "");
            int n = Integer.parseInt(stringArray2[0].trim());
            int n2 = Integer.parseInt(stringArray2[1].trim());
            this.removeZonesForCell(n, n2);
        }
    }

    public void processZones() {
        int n = 0;
        for (int i = this.minX; i <= this.maxX; ++i) {
            for (int j = this.minY; j <= this.maxY; ++j) {
                if (this.Grid[i - this.minX][j - this.minY] == null) continue;
                for (int k = 0; k < 30; ++k) {
                    for (int i2 = 0; i2 < 30; ++i2) {
                        n = Math.max(n, this.Grid[i - this.minX][j - this.minY].getChunk(i2, k).numZones());
                    }
                }
            }
        }
        DebugLog.log("Max #ZONES on one chunk is " + n);
    }

    public Zone registerVehiclesZone(String string, String string2, int n, int n2, int n3, int n4, int n5, KahluaTable kahluaTable) {
        if (string2.equals("Vehicle") || string2.equals("ParkingStall")) {
            string = this.sharedStrings.get(string);
            string2 = this.sharedStrings.get(string2);
            VehicleZone vehicleZone = new VehicleZone(string, string2, n, n2, n3, n4, n5, kahluaTable);
            this.VehiclesZones.add(vehicleZone);
            int n6 = (int)Math.ceil((float)(vehicleZone.x + vehicleZone.w) / 300.0f);
            int n7 = (int)Math.ceil((float)(vehicleZone.y + vehicleZone.h) / 300.0f);
            for (int i = vehicleZone.y / 300; i < n7; ++i) {
                for (int j = vehicleZone.x / 300; j < n6; ++j) {
                    if (j < this.minX || j > this.maxX || i < this.minY || i > this.maxY || this.Grid[j - this.minX][i - this.minY] == null) continue;
                    this.Grid[j - this.minX][i - this.minY].vehicleZones.add(vehicleZone);
                }
            }
            return vehicleZone;
        }
        return null;
    }

    public void checkVehiclesZones() {
        int n = 0;
        while (n < this.VehiclesZones.size()) {
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                Zone zone = this.VehiclesZones.get(n);
                Zone zone2 = this.VehiclesZones.get(i);
                if (zone.getX() != zone2.getX() || zone.getY() != zone2.getY() || zone.h != zone2.h || zone.w != zone2.w) continue;
                bl = false;
                DebugLog.log("checkVehiclesZones: ERROR! Zone '" + zone.name + "':'" + zone.type + "' (" + zone.x + ", " + zone.y + ") duplicate with Zone '" + zone2.name + "':'" + zone2.type + "' (" + zone2.x + ", " + zone2.y + ")");
                break;
            }
            if (bl) {
                ++n;
                continue;
            }
            this.VehiclesZones.remove(n);
        }
    }

    public Zone registerMannequinZone(String string, String string2, int n, int n2, int n3, int n4, int n5, KahluaTable kahluaTable) {
        if ("Mannequin".equals(string2)) {
            string = this.sharedStrings.get(string);
            string2 = this.sharedStrings.get(string2);
            IsoMannequin.MannequinZone mannequinZone = new IsoMannequin.MannequinZone(string, string2, n, n2, n3, n4, n5, kahluaTable);
            int n6 = (int)Math.ceil((float)(mannequinZone.x + mannequinZone.w) / 300.0f);
            int n7 = (int)Math.ceil((float)(mannequinZone.y + mannequinZone.h) / 300.0f);
            for (int i = mannequinZone.y / 300; i < n7; ++i) {
                for (int j = mannequinZone.x / 300; j < n6; ++j) {
                    if (j < this.minX || j > this.maxX || i < this.minY || i > this.maxY || this.Grid[j - this.minX][i - this.minY] == null) continue;
                    this.Grid[j - this.minX][i - this.minY].mannequinZones.add(mannequinZone);
                }
            }
            return mannequinZone;
        }
        return null;
    }

    public void registerRoomTone(String string, String string2, int n, int n2, int n3, int n4, int n5, KahluaTable kahluaTable) {
        if (!"RoomTone".equals(string2)) {
            return;
        }
        IsoMetaCell isoMetaCell = this.getCellData(n / 300, n2 / 300);
        if (isoMetaCell == null) {
            return;
        }
        RoomTone roomTone = new RoomTone();
        roomTone.x = n;
        roomTone.y = n2;
        roomTone.z = n3;
        roomTone.enumValue = kahluaTable.getString("RoomTone");
        roomTone.entireBuilding = Boolean.TRUE.equals(kahluaTable.rawget((Object)"EntireBuilding"));
        isoMetaCell.roomTones.add(roomTone);
    }

    public boolean isZoneAbove(Zone zone, Zone zone2, int n, int n2, int n3) {
        if (zone == null || zone == zone2) {
            return false;
        }
        ArrayList<Zone> arrayList = TL_ZoneList.get();
        arrayList.clear();
        this.getZonesAt(n, n2, n3, arrayList);
        return arrayList.indexOf(zone) > arrayList.indexOf(zone2);
    }

    public void save(ByteBuffer byteBuffer) {
        this.savePart(byteBuffer, 0, false);
        this.savePart(byteBuffer, 1, false);
    }

    public void savePart(ByteBuffer byteBuffer, int n, boolean bl) {
        int n2;
        if (n == 0) {
            byteBuffer.put((byte)77);
            byteBuffer.put((byte)69);
            byteBuffer.put((byte)84);
            byteBuffer.put((byte)65);
            byteBuffer.putInt(195);
            byteBuffer.putInt(this.minX);
            byteBuffer.putInt(this.minY);
            byteBuffer.putInt(this.maxX);
            byteBuffer.putInt(this.maxY);
            for (int i = 0; i < this.Grid.length; ++i) {
                for (int j = 0; j < this.Grid[0].length; ++j) {
                    IsoMetaCell isoMetaCell = this.Grid[i][j];
                    int n3 = 0;
                    if (isoMetaCell.info != null) {
                        n3 = isoMetaCell.info.Rooms.values().size();
                    }
                    byteBuffer.putInt(n3);
                    if (isoMetaCell.info != null) {
                        for (Map.Entry<Integer, RoomDef> entry : isoMetaCell.info.Rooms.entrySet()) {
                            RoomDef roomDef = entry.getValue();
                            byteBuffer.putLong(roomDef.metaID);
                            short s = 0;
                            if (roomDef.bExplored) {
                                s = (short)(s | 1);
                            }
                            if (roomDef.bLightsActive) {
                                s = (short)(s | 2);
                            }
                            if (roomDef.bDoneSpawn) {
                                s = (short)(s | 4);
                            }
                            if (roomDef.isRoofFixed()) {
                                s = (short)(s | 8);
                            }
                            byteBuffer.putShort(s);
                        }
                    }
                    if (isoMetaCell.info != null) {
                        byteBuffer.putInt(isoMetaCell.info.Buildings.size());
                    } else {
                        byteBuffer.putInt(0);
                    }
                    if (isoMetaCell.info == null) continue;
                    for (BuildingDef buildingDef : isoMetaCell.info.Buildings) {
                        byteBuffer.putLong(buildingDef.metaID);
                        byteBuffer.put(buildingDef.bAlarmed ? (byte)1 : 0);
                        byteBuffer.putInt(buildingDef.getKeyId());
                        byteBuffer.put(buildingDef.seen ? (byte)1 : 0);
                        byteBuffer.put(buildingDef.isHasBeenVisited() ? (byte)1 : 0);
                        byteBuffer.putInt(buildingDef.lootRespawnHour);
                    }
                }
            }
            return;
        }
        byteBuffer.putInt(SafeHouse.getSafehouseList().size());
        for (n2 = 0; n2 < SafeHouse.getSafehouseList().size(); ++n2) {
            SafeHouse.getSafehouseList().get(n2).save(byteBuffer);
        }
        byteBuffer.putInt(NonPvpZone.getAllZones().size());
        for (n2 = 0; n2 < NonPvpZone.getAllZones().size(); ++n2) {
            NonPvpZone.getAllZones().get(n2).save(byteBuffer);
        }
        byteBuffer.putInt(Faction.getFactions().size());
        for (n2 = 0; n2 < Faction.getFactions().size(); ++n2) {
            Faction.getFactions().get(n2).save(byteBuffer);
        }
        if (GameServer.bServer) {
            n2 = byteBuffer.position();
            byteBuffer.putInt(0);
            StashSystem.save(byteBuffer);
            byteBuffer.putInt(n2, byteBuffer.position());
        } else if (!GameClient.bClient) {
            StashSystem.save(byteBuffer);
        }
        byteBuffer.putInt(RBBasic.getUniqueRDSSpawned().size());
        for (n2 = 0; n2 < RBBasic.getUniqueRDSSpawned().size(); ++n2) {
            GameWindow.WriteString(byteBuffer, RBBasic.getUniqueRDSSpawned().get(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_meta.bin");
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                SliceY.SliceBuffer.clear();
                int n = bufferedInputStream.read(SliceY.SliceBuffer.array());
                SliceY.SliceBuffer.limit(n);
                this.load(SliceY.SliceBuffer);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public void load(ByteBuffer byteBuffer) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        IsoMetaCell isoMetaCell;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        byteBuffer.mark();
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        byte by3 = byteBuffer.get();
        byte by4 = byteBuffer.get();
        if (by == 77 && by2 == 69 && by3 == 84 && by4 == 65) {
            n10 = byteBuffer.getInt();
        } else {
            n10 = 33;
            byteBuffer.reset();
        }
        int n11 = this.minX;
        int n12 = this.minY;
        int n13 = this.maxX;
        int n14 = this.maxY;
        if (n10 >= 194) {
            n11 = byteBuffer.getInt();
            n12 = byteBuffer.getInt();
            n13 = byteBuffer.getInt();
            n14 = byteBuffer.getInt();
            n9 = n13 - n11 + 1;
            n8 = n14 - n12 + 1;
        } else {
            n9 = byteBuffer.getInt();
            n8 = byteBuffer.getInt();
            if (n9 == 40 && n8 == 42 && this.width == 66 && this.height == 53 && this.getLotDirectories().contains("Muldraugh, KY")) {
                n11 = 10;
                n12 = 3;
            }
            n13 = n11 + n9 - 1;
            n14 = n12 + n8 - 1;
        }
        if (n9 != this.Grid.length || n8 != this.Grid[0].length) {
            DebugLog.log("map_meta.bin world size (" + n9 + "x" + n8 + ") does not match the current map size (" + this.Grid.length + "x" + this.Grid[0].length + ")");
        }
        int n15 = 0;
        int n16 = 0;
        for (n7 = n11; n7 <= n13; ++n7) {
            for (n6 = n12; n6 <= n14; ++n6) {
                int n17;
                boolean bl;
                boolean bl2;
                int n18;
                boolean bl3;
                long l;
                isoMetaCell = this.getCellData(n7, n6);
                n5 = byteBuffer.getInt();
                for (n4 = 0; n4 < n5; ++n4) {
                    RoomDef roomDef;
                    n3 = n10 < 194 ? byteBuffer.getInt() : 0;
                    l = n10 >= 194 ? byteBuffer.getLong() : 0L;
                    bl3 = false;
                    n18 = 0;
                    bl2 = false;
                    bl = false;
                    if (n10 >= 160) {
                        n17 = byteBuffer.getShort();
                        bl3 = (n17 & 1) != 0;
                        n18 = (n17 & 2) != 0 ? 1 : 0;
                        bl2 = (n17 & 4) != 0;
                        bl = (n17 & 8) != 0;
                    } else {
                        boolean bl4 = bl3 = byteBuffer.get() == 1;
                        if (n10 >= 34) {
                            n18 = byteBuffer.get() == 1 ? 1 : 0;
                        } else {
                            int n19 = n18 = Rand.Next(2) == 0 ? 1 : 0;
                        }
                    }
                    if (isoMetaCell == null || isoMetaCell.info == null) continue;
                    RoomDef roomDef2 = roomDef = n10 < 194 ? isoMetaCell.info.Rooms.get(n3) : (RoomDef)isoMetaCell.info.RoomByMetaID.get(l);
                    if (roomDef != null) {
                        roomDef.setExplored(bl3);
                        roomDef.bLightsActive = n18;
                        roomDef.bDoneSpawn = bl2;
                        roomDef.setRoofFixed(bl);
                        continue;
                    }
                    if (n10 < 194) {
                        DebugLog.General.error("invalid room ID #" + n3 + " in cell " + n7 + "," + n6 + " while reading map_meta.bin");
                        continue;
                    }
                    DebugLog.General.error("invalid room metaID #" + l + " in cell " + n7 + "," + n6 + " while reading map_meta.bin");
                }
                n4 = byteBuffer.getInt();
                n15 += n4;
                for (n3 = 0; n3 < n4; ++n3) {
                    int n20;
                    l = n10 >= 194 ? byteBuffer.getLong() : 0L;
                    bl3 = byteBuffer.get() == 1;
                    int n21 = n18 = n10 >= 57 ? byteBuffer.getInt() : -1;
                    boolean bl5 = n10 >= 74 ? byteBuffer.get() == 1 : (bl2 = false);
                    bl = n10 >= 107 ? byteBuffer.get() == 1 : false;
                    n17 = n10 >= 111 && n10 < 121 ? byteBuffer.getInt() : 0;
                    int n22 = n20 = n10 >= 125 ? byteBuffer.getInt() : 0;
                    if (isoMetaCell == null || isoMetaCell.info == null) continue;
                    BuildingDef buildingDef = null;
                    if (n10 >= 194) {
                        buildingDef = (BuildingDef)isoMetaCell.info.BuildingByMetaID.get(l);
                    } else if (n3 < isoMetaCell.info.Buildings.size()) {
                        buildingDef = isoMetaCell.info.Buildings.get(n3);
                    }
                    if (buildingDef != null) {
                        if (bl3) {
                            ++n16;
                        }
                        buildingDef.bAlarmed = bl3;
                        buildingDef.setKeyId(n18);
                        if (n10 >= 74) {
                            buildingDef.seen = bl2;
                        }
                        buildingDef.hasBeenVisited = bl;
                        buildingDef.lootRespawnHour = n20;
                        continue;
                    }
                    if (n10 < 194) continue;
                    DebugLog.General.error("invalid building metaID #" + l + " in cell " + n7 + "," + n6 + " while reading map_meta.bin");
                }
            }
        }
        if (n10 <= 112) {
            this.Zones.clear();
            for (n7 = 0; n7 < this.height; ++n7) {
                for (n6 = 0; n6 < this.width; ++n6) {
                    isoMetaCell = this.Grid[n6][n7];
                    if (isoMetaCell == null) continue;
                    for (n5 = 0; n5 < 30; ++n5) {
                        for (n4 = 0; n4 < 30; ++n4) {
                            isoMetaCell.ChunkMap[n4 + n5 * 30].clearZones();
                        }
                    }
                }
            }
            this.loadZone(byteBuffer, n10);
        }
        SafeHouse.clearSafehouseList();
        n7 = byteBuffer.getInt();
        for (n6 = 0; n6 < n7; ++n6) {
            SafeHouse.load(byteBuffer, n10);
        }
        NonPvpZone.nonPvpZoneList.clear();
        n6 = byteBuffer.getInt();
        for (n2 = 0; n2 < n6; ++n2) {
            NonPvpZone nonPvpZone = new NonPvpZone();
            nonPvpZone.load(byteBuffer, n10);
            NonPvpZone.getAllZones().add(nonPvpZone);
        }
        Faction.factions = new ArrayList();
        n2 = byteBuffer.getInt();
        for (n = 0; n < n2; ++n) {
            Faction faction = new Faction();
            faction.load(byteBuffer, n10);
            Faction.getFactions().add(faction);
        }
        if (GameServer.bServer) {
            n = byteBuffer.getInt();
            StashSystem.load(byteBuffer, n10);
        } else if (GameClient.bClient) {
            n = byteBuffer.getInt();
            byteBuffer.position(n);
        } else {
            StashSystem.load(byteBuffer, n10);
        }
        ArrayList<String> arrayList = RBBasic.getUniqueRDSSpawned();
        arrayList.clear();
        int n23 = byteBuffer.getInt();
        for (n3 = 0; n3 < n23; ++n3) {
            arrayList.add(GameWindow.ReadString(byteBuffer));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public IsoMetaCell getCellData(int n, int n2) {
        if (n - this.minX < 0 || n2 - this.minY < 0 || n - this.minX >= this.width || n2 - this.minY >= this.height) {
            return null;
        }
        return this.Grid[n - this.minX][n2 - this.minY];
    }

    public IsoMetaCell getCellDataAbs(int n, int n2) {
        return this.Grid[n][n2];
    }

    public IsoMetaCell getCurrentCellData() {
        int n = IsoWorld.instance.CurrentCell.ChunkMap[IsoPlayer.getPlayerIndex()].WorldX;
        int n2 = IsoWorld.instance.CurrentCell.ChunkMap[IsoPlayer.getPlayerIndex()].WorldY;
        float f = n;
        float f2 = n2;
        f /= 30.0f;
        f2 /= 30.0f;
        if (f < 0.0f) {
            f = (int)f - 1;
        }
        if (f2 < 0.0f) {
            f2 = (int)f2 - 1;
        }
        n = (int)f;
        n2 = (int)f2;
        return this.getCellData(n, n2);
    }

    public IsoMetaCell getMetaGridFromTile(int n, int n2) {
        int n3 = n / 300;
        int n4 = n2 / 300;
        return this.getCellData(n3, n4);
    }

    public IsoMetaChunk getCurrentChunkData() {
        int n = IsoWorld.instance.CurrentCell.ChunkMap[IsoPlayer.getPlayerIndex()].WorldX;
        int n2 = IsoWorld.instance.CurrentCell.ChunkMap[IsoPlayer.getPlayerIndex()].WorldY;
        float f = n;
        float f2 = n2;
        f /= 30.0f;
        f2 /= 30.0f;
        if (f < 0.0f) {
            f = (int)f - 1;
        }
        if (f2 < 0.0f) {
            f2 = (int)f2 - 1;
        }
        n = (int)f;
        n2 = (int)f2;
        return this.getCellData(n, n2).getChunk(IsoWorld.instance.CurrentCell.ChunkMap[IsoPlayer.getPlayerIndex()].WorldX - n * 30, IsoWorld.instance.CurrentCell.ChunkMap[IsoPlayer.getPlayerIndex()].WorldY - n2 * 30);
    }

    public IsoMetaChunk getChunkData(int n, int n2) {
        IsoMetaCell isoMetaCell;
        int n3 = n;
        int n4 = n2;
        float f = n3;
        float f2 = n4;
        f /= 30.0f;
        f2 /= 30.0f;
        if (f < 0.0f) {
            f = (int)f - 1;
        }
        if (f2 < 0.0f) {
            f2 = (int)f2 - 1;
        }
        if ((isoMetaCell = this.getCellData(n3 = (int)f, n4 = (int)f2)) == null) {
            return null;
        }
        return isoMetaCell.getChunk(n - n3 * 30, n2 - n4 * 30);
    }

    public IsoMetaChunk getChunkDataFromTile(int n, int n2) {
        int n3 = n / 10;
        int n4 = n2 / 10;
        int n5 = (n3 -= this.minX * 30) / 30;
        int n6 = (n4 -= this.minY * 30) / 30;
        n3 += this.minX * 30;
        n4 += this.minY * 30;
        IsoMetaCell isoMetaCell = this.getCellData(n5 += this.minX, n6 += this.minY);
        if (isoMetaCell == null) {
            return null;
        }
        return isoMetaCell.getChunk(n3 - n5 * 30, n4 - n6 * 30);
    }

    public boolean isValidSquare(int n, int n2) {
        if (n < this.minX * 300) {
            return false;
        }
        if (n >= (this.maxX + 1) * 300) {
            return false;
        }
        if (n2 < this.minY * 300) {
            return false;
        }
        return n2 < (this.maxY + 1) * 300;
    }

    public boolean isValidChunk(int n, int n2) {
        n2 *= 10;
        if ((n *= 10) < this.minX * 300) {
            return false;
        }
        if (n >= (this.maxX + 1) * 300) {
            return false;
        }
        if (n2 < this.minY * 300) {
            return false;
        }
        if (n2 >= (this.maxY + 1) * 300) {
            return false;
        }
        return this.Grid[n / 300 - this.minX][n2 / 300 - this.minY].info != null;
    }

    public void Create() {
        this.CreateStep1();
        this.CreateStep2();
    }

    public void CreateStep1() {
        Object object;
        this.minX = 10000000;
        this.minY = 10000000;
        this.maxX = -10000000;
        this.maxY = -10000000;
        IsoLot.InfoHeaders.clear();
        IsoLot.InfoHeaderNames.clear();
        IsoLot.InfoFileNames.clear();
        long l = System.currentTimeMillis();
        DebugLog.log("IsoMetaGrid.Create: begin scanning directories");
        ArrayList<String> arrayList = this.getLotDirectories();
        DebugLog.log("Looking in these map folders:");
        for (String string : arrayList) {
            string = ZomboidFileSystem.instance.getString("media/maps/" + string + "/");
            DebugLog.log("    " + new File(string).getAbsolutePath());
        }
        DebugLog.log("<End of map-folders list>");
        for (String string : arrayList) {
            File file = new File(ZomboidFileSystem.instance.getString("media/maps/" + string + "/"));
            if (!file.isDirectory()) continue;
            ChooseGameInfo.Map map = ChooseGameInfo.getMapDetails(string);
            object = file.list();
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (IsoLot.InfoFileNames.containsKey(object[i])) continue;
                if (object[i].endsWith(".lotheader")) {
                    String[] stringArray = object[i].split("_");
                    stringArray[1] = stringArray[1].replace(".lotheader", "");
                    int n = Integer.parseInt(stringArray[0].trim());
                    int n2 = Integer.parseInt(stringArray[1].trim());
                    if (n < this.minX) {
                        this.minX = n;
                    }
                    if (n2 < this.minY) {
                        this.minY = n2;
                    }
                    if (n > this.maxX) {
                        this.maxX = n;
                    }
                    if (n2 > this.maxY) {
                        this.maxY = n2;
                    }
                    IsoLot.InfoFileNames.put((String)object[i], file.getAbsolutePath() + File.separator + (String)object[i]);
                    LotHeader lotHeader = new LotHeader();
                    lotHeader.cellX = n;
                    lotHeader.cellY = n2;
                    lotHeader.bFixed2x = map.isFixed2x();
                    IsoLot.InfoHeaders.put((String)object[i], lotHeader);
                    IsoLot.InfoHeaderNames.add((String)object[i]);
                    continue;
                }
                if (object[i].endsWith(".lotpack")) {
                    IsoLot.InfoFileNames.put(object[i], file.getAbsolutePath() + File.separator + object[i]);
                    continue;
                }
                if (!object[i].startsWith("chunkdata_")) continue;
                IsoLot.InfoFileNames.put(object[i], file.getAbsolutePath() + File.separator + object[i]);
            }
        }
        if (this.maxX < this.minX || this.maxY < this.minY) {
            throw new IllegalStateException("Failed to find any .lotheader files");
        }
        this.Grid = new IsoMetaCell[this.maxX - this.minX + 1][this.maxY - this.minY + 1];
        this.width = this.maxX - this.minX + 1;
        this.height = this.maxY - this.minY + 1;
        long l2 = System.currentTimeMillis() - l;
        DebugLog.log("IsoMetaGrid.Create: finished scanning directories in " + (float)l2 / 1000.0f + " seconds");
        DebugLog.log("IsoMetaGrid.Create: begin loading");
        this.createStartTime = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            object = new MetaGridLoaderThread(this.minY + i);
            ((Thread)object).setDaemon(true);
            ((Thread)object).setName("MetaGridLoaderThread" + i);
            ((Thread)object).start();
            this.threads[i] = object;
        }
    }

    public void CreateStep2() {
        int n;
        boolean bl = true;
        block2: while (bl) {
            bl = false;
            for (n = 0; n < 8; ++n) {
                if (!this.threads[n].isAlive()) continue;
                bl = true;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue block2;
            }
        }
        for (n = 0; n < 8; ++n) {
            this.threads[n].postLoad();
            this.threads[n] = null;
        }
        for (n = 0; n < this.Buildings.size(); ++n) {
            BuildingDef buildingDef = this.Buildings.get(n);
            if (Core.GameMode.equals("LastStand") || buildingDef.rooms.size() <= 2) continue;
            int n2 = 11;
            if (SandboxOptions.instance.getElecShutModifier() > -1 && GameTime.instance.NightsSurvived < SandboxOptions.instance.getElecShutModifier()) {
                n2 = 9;
            }
            if (SandboxOptions.instance.Alarm.getValue() == 1) {
                n2 = -1;
            } else if (SandboxOptions.instance.Alarm.getValue() == 2) {
                n2 += 5;
            } else if (SandboxOptions.instance.Alarm.getValue() == 3) {
                n2 += 3;
            } else if (SandboxOptions.instance.Alarm.getValue() == 5) {
                n2 -= 3;
            } else if (SandboxOptions.instance.Alarm.getValue() == 6) {
                n2 -= 5;
            }
            if (n2 <= -1) continue;
            buildingDef.bAlarmed = Rand.Next(n2) == 0;
        }
        long l = System.currentTimeMillis() - this.createStartTime;
        DebugLog.log("IsoMetaGrid.Create: finished loading in " + (float)l / 1000.0f + " seconds");
    }

    public void Dispose() {
        if (this.Grid == null) {
            return;
        }
        for (int i = 0; i < this.Grid.length; ++i) {
            Object[] object = this.Grid[i];
            for (int j = 0; j < object.length; ++j) {
                IsoMetaCell isoMetaCell = object[j];
                if (isoMetaCell == null) continue;
                isoMetaCell.Dispose();
            }
            Arrays.fill(object, null);
        }
        Arrays.fill((Object[])this.Grid, null);
        this.Grid = null;
        for (BuildingDef buildingDef : this.Buildings) {
            buildingDef.Dispose();
        }
        this.Buildings.clear();
        this.VehiclesZones.clear();
        for (Zone zone : this.Zones) {
            zone.Dispose();
        }
        this.Zones.clear();
        this.sharedStrings.clear();
    }

    public Vector2 getRandomIndoorCoord() {
        return null;
    }

    public RoomDef getRandomRoomBetweenRange(float f, float f2, float f3, float f4) {
        RoomDef roomDef = null;
        float f5 = 0.0f;
        roomChoices.clear();
        LotHeader lotHeader = null;
        for (int i = 0; i < IsoLot.InfoHeaderNames.size(); ++i) {
            lotHeader = IsoLot.InfoHeaders.get(IsoLot.InfoHeaderNames.get(i));
            if (lotHeader.RoomList.isEmpty()) continue;
            for (int j = 0; j < lotHeader.RoomList.size(); ++j) {
                roomDef = lotHeader.RoomList.get(j);
                f5 = IsoUtils.DistanceManhatten(f, f2, roomDef.x, roomDef.y);
                if (!(f5 > f3) || !(f5 < f4)) continue;
                roomChoices.add(roomDef);
            }
        }
        if (!roomChoices.isEmpty()) {
            return roomChoices.get(Rand.Next(roomChoices.size()));
        }
        return null;
    }

    public RoomDef getRandomRoomNotInRange(float f, float f2, int n) {
        LotHeader lotHeader;
        RoomDef roomDef = null;
        do {
            lotHeader = null;
            do {
                lotHeader = IsoLot.InfoHeaders.get(IsoLot.InfoHeaderNames.get(Rand.Next(IsoLot.InfoHeaderNames.size())));
            } while (lotHeader.RoomList.isEmpty());
        } while ((roomDef = lotHeader.RoomList.get(Rand.Next(lotHeader.RoomList.size()))) == null || IsoUtils.DistanceManhatten(f, f2, roomDef.x, roomDef.y) < (float)n);
        return roomDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            Object object;
            OutputStream outputStream;
            File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_meta.bin");
            try (Object object2 = new FileOutputStream(file);){
                outputStream = new BufferedOutputStream((OutputStream)object2);
                try {
                    object = SliceY.SliceBufferLock;
                    synchronized (object) {
                        SliceY.SliceBuffer.clear();
                        this.save(SliceY.SliceBuffer);
                        ((BufferedOutputStream)outputStream).write(SliceY.SliceBuffer.array(), 0, SliceY.SliceBuffer.position());
                    }
                }
                finally {
                    ((FilterOutputStream)outputStream).close();
                }
            }
            object2 = ZomboidFileSystem.instance.getFileInCurrentSave("map_zone.bin");
            outputStream = new FileOutputStream((File)object2);
            try {
                object = new BufferedOutputStream(outputStream);
                try {
                    Object object3 = SliceY.SliceBufferLock;
                    synchronized (object3) {
                        SliceY.SliceBuffer.clear();
                        this.saveZone(SliceY.SliceBuffer);
                        ((BufferedOutputStream)object).write(SliceY.SliceBuffer.array(), 0, SliceY.SliceBuffer.position());
                    }
                }
                finally {
                    ((FilterOutputStream)object).close();
                }
            }
            finally {
                ((FileOutputStream)outputStream).close();
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadZones() {
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_zone.bin");
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                SliceY.SliceBuffer.clear();
                int n = bufferedInputStream.read(SliceY.SliceBuffer.array());
                SliceY.SliceBuffer.limit(n);
                this.loadZone(SliceY.SliceBuffer, -1);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public void loadZone(ByteBuffer byteBuffer, int n) {
        int n2;
        int n3;
        int n4;
        if (n == -1) {
            n4 = byteBuffer.get();
            byte by = byteBuffer.get();
            n3 = byteBuffer.get();
            n2 = byteBuffer.get();
            if (n4 == 90 && by == 79 && n3 == 78 && n2 == 69) {
                n = byteBuffer.getInt();
            } else {
                DebugLog.log("ERROR: expected 'ZONE' at start of map_zone.bin");
                return;
            }
        }
        n4 = this.Zones.size();
        if (!GameServer.bServer && n >= 34 || GameServer.bServer && n >= 36) {
            int n5;
            int n6;
            for (Zone zone : this.Zones) {
                zone.Dispose();
            }
            this.Zones.clear();
            for (int i = 0; i < this.height; ++i) {
                for (n3 = 0; n3 < this.width; ++n3) {
                    IsoMetaCell isoMetaCell = this.Grid[n3][i];
                    if (isoMetaCell == null) continue;
                    for (n6 = 0; n6 < 30; ++n6) {
                        for (n5 = 0; n5 < 30; ++n5) {
                            isoMetaCell.ChunkMap[n5 + n6 * 30].clearZones();
                        }
                    }
                }
            }
            ZoneGeometryType[] zoneGeometryTypeArray = ZoneGeometryType.values();
            TIntArrayList tIntArrayList = new TIntArrayList();
            if (n >= 141) {
                int n7;
                int n8;
                String string;
                int n9;
                n2 = byteBuffer.getInt();
                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                for (n5 = 0; n5 < n2; ++n5) {
                    String string2 = GameWindow.ReadStringUTF(byteBuffer);
                    hashMap.put(n5, string2);
                }
                n5 = byteBuffer.getInt();
                DebugLog.log("loading " + n5 + " zones from map_zone.bin");
                for (n9 = 0; n9 < n5; ++n9) {
                    int n10;
                    String string3 = (String)hashMap.get(byteBuffer.getShort());
                    string = (String)hashMap.get(byteBuffer.getShort());
                    int n11 = byteBuffer.getInt();
                    n8 = byteBuffer.getInt();
                    n7 = byteBuffer.get();
                    int n12 = byteBuffer.getInt();
                    int n13 = byteBuffer.getInt();
                    ZoneGeometryType zoneGeometryType = ZoneGeometryType.INVALID;
                    tIntArrayList.clear();
                    int n14 = 0;
                    if (n >= 185) {
                        n10 = byteBuffer.get();
                        if (n10 < 0 || n10 >= zoneGeometryTypeArray.length) {
                            n10 = 0;
                        }
                        if ((zoneGeometryType = zoneGeometryTypeArray[n10]) != ZoneGeometryType.INVALID) {
                            if (n >= 186 && zoneGeometryType == ZoneGeometryType.Polyline) {
                                n14 = PZMath.clamp(byteBuffer.get(), 0, 255);
                            }
                            int n15 = byteBuffer.getShort();
                            for (int i = 0; i < n15; ++i) {
                                tIntArrayList.add(byteBuffer.getInt());
                            }
                        }
                    }
                    n10 = byteBuffer.getInt();
                    Zone zone = this.registerZone(string3, string, n11, n8, n7, n12, n13, zoneGeometryType, zoneGeometryType == ZoneGeometryType.INVALID ? null : tIntArrayList, n14);
                    zone.hourLastSeen = n10;
                    zone.haveConstruction = byteBuffer.get() == 1;
                    zone.lastActionTimestamp = byteBuffer.getInt();
                    zone.setOriginalName((String)hashMap.get(byteBuffer.getShort()));
                    zone.id = byteBuffer.getDouble();
                }
                n9 = byteBuffer.getInt();
                for (int i = 0; i < n9; ++i) {
                    string = GameWindow.ReadString(byteBuffer);
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    n8 = byteBuffer.getInt();
                    for (n7 = 0; n7 < n8; ++n7) {
                        arrayList.add(byteBuffer.getDouble());
                    }
                    IsoWorld.instance.getSpawnedZombieZone().put(string, arrayList);
                }
                return;
            }
            n2 = byteBuffer.getInt();
            DebugLog.log("loading " + n2 + " zones from map_zone.bin");
            if (n <= 112 && n2 > n4 * 2) {
                DebugLog.log("ERROR: seems like too many zones in map_zone.bin");
                return;
            }
            for (n6 = 0; n6 < n2; ++n6) {
                int n16;
                String string = GameWindow.ReadString(byteBuffer);
                String string4 = GameWindow.ReadString(byteBuffer);
                int n17 = byteBuffer.getInt();
                int n18 = byteBuffer.getInt();
                int n19 = byteBuffer.getInt();
                int n20 = byteBuffer.getInt();
                int n21 = byteBuffer.getInt();
                int n22 = n < 121 ? byteBuffer.getInt() : 0;
                int n23 = n < 68 ? byteBuffer.getShort() : byteBuffer.getInt();
                Zone zone = this.registerZone(string, string4, n17, n18, n19, n20, n21);
                zone.hourLastSeen = n23;
                if (n >= 35) {
                    zone.haveConstruction = n16 = byteBuffer.get() == 1 ? 1 : 0;
                }
                if (n >= 41) {
                    zone.lastActionTimestamp = byteBuffer.getInt();
                }
                if (n >= 98) {
                    zone.setOriginalName(GameWindow.ReadString(byteBuffer));
                }
                if (n >= 110 && n < 121) {
                    n16 = byteBuffer.getInt();
                }
                zone.id = byteBuffer.getDouble();
            }
        }
    }

    public void saveZone(ByteBuffer byteBuffer) {
        int n;
        Object object;
        byteBuffer.put((byte)90);
        byteBuffer.put((byte)79);
        byteBuffer.put((byte)78);
        byteBuffer.put((byte)69);
        byteBuffer.putInt(195);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.Zones.size(); ++i) {
            object = this.Zones.get(i);
            hashSet.add(((Zone)object).getName());
            hashSet.add(((Zone)object).getOriginalName());
            hashSet.add(((Zone)object).getType());
        }
        ArrayList arrayList = new ArrayList(hashSet);
        object = new HashMap();
        for (n = 0; n < arrayList.size(); ++n) {
            ((HashMap)object).put((String)arrayList.get(n), n);
        }
        if (arrayList.size() > Short.MAX_VALUE) {
            throw new IllegalStateException("IsoMetaGrid.saveZone() string table is too large");
        }
        byteBuffer.putInt(arrayList.size());
        for (n = 0; n < arrayList.size(); ++n) {
            GameWindow.WriteString(byteBuffer, (String)arrayList.get(n));
        }
        byteBuffer.putInt(this.Zones.size());
        for (n = 0; n < this.Zones.size(); ++n) {
            Zone object2 = this.Zones.get(n);
            byteBuffer.putShort(((Integer)((HashMap)object).get(object2.getName())).shortValue());
            byteBuffer.putShort(((Integer)((HashMap)object).get(object2.getType())).shortValue());
            byteBuffer.putInt(object2.x);
            byteBuffer.putInt(object2.y);
            byteBuffer.put((byte)object2.z);
            byteBuffer.putInt(object2.w);
            byteBuffer.putInt(object2.h);
            byteBuffer.put((byte)object2.geometryType.ordinal());
            if (!object2.isRectangle()) {
                if (object2.isPolyline()) {
                    byteBuffer.put((byte)object2.polylineWidth);
                }
                byteBuffer.putShort((short)object2.points.size());
                for (int arrayList2 = 0; arrayList2 < object2.points.size(); ++arrayList2) {
                    byteBuffer.putInt(object2.points.get(arrayList2));
                }
            }
            byteBuffer.putInt(object2.hourLastSeen);
            byteBuffer.put(object2.haveConstruction ? (byte)1 : 0);
            byteBuffer.putInt(object2.lastActionTimestamp);
            byteBuffer.putShort(((Integer)((HashMap)object).get(object2.getOriginalName())).shortValue());
            byteBuffer.putDouble(object2.id);
        }
        hashSet.clear();
        arrayList.clear();
        ((HashMap)object).clear();
        byteBuffer.putInt(IsoWorld.instance.getSpawnedZombieZone().size());
        for (String string : IsoWorld.instance.getSpawnedZombieZone().keySet()) {
            ArrayList<Double> arrayList2 = IsoWorld.instance.getSpawnedZombieZone().get(string);
            GameWindow.WriteString(byteBuffer, string);
            byteBuffer.putInt(arrayList2.size());
            for (int i = 0; i < arrayList2.size(); ++i) {
                byteBuffer.putDouble(arrayList2.get(i));
            }
        }
    }

    private void getLotDirectories(String string, ArrayList<String> arrayList) {
        if (arrayList.contains(string)) {
            return;
        }
        ChooseGameInfo.Map map = ChooseGameInfo.getMapDetails(string);
        if (map == null) {
            return;
        }
        arrayList.add(string);
        for (String string2 : map.getLotDirectories()) {
            this.getLotDirectories(string2, arrayList);
        }
    }

    public ArrayList<String> getLotDirectories() {
        Object object;
        if (GameClient.bClient) {
            Core.GameMap = GameClient.GameMap;
        }
        if (GameServer.bServer) {
            Core.GameMap = GameServer.GameMap;
        }
        if (Core.GameMap.equals("DEFAULT")) {
            object = new MapGroups();
            ((MapGroups)object).createGroups();
            if (((MapGroups)object).getNumberOfGroups() != 1) {
                throw new RuntimeException("GameMap is DEFAULT but there are multiple worlds to choose from");
            }
            ((MapGroups)object).setWorld(0);
        }
        object = new ArrayList();
        if (Core.GameMap.contains(";")) {
            String[] stringArray = Core.GameMap.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                if (string.isEmpty() || ((ArrayList)object).contains(string)) continue;
                ((ArrayList)object).add(string);
            }
        } else {
            this.getLotDirectories(Core.GameMap, (ArrayList<String>)object);
        }
        return object;
    }

    public static boolean isPreferredZoneForSquare(String string) {
        return s_PreferredZoneTypes.contains(string);
    }

    static {
        s_PreferredZoneTypes.add("DeepForest");
        s_PreferredZoneTypes.add("Farm");
        s_PreferredZoneTypes.add("FarmLand");
        s_PreferredZoneTypes.add("Forest");
        s_PreferredZoneTypes.add("Vegitation");
        s_PreferredZoneTypes.add("Nav");
        s_PreferredZoneTypes.add("TownZone");
        s_PreferredZoneTypes.add("TrailerPark");
    }

    private final class MetaGridLoaderThread
    extends Thread {
        final SharedStrings sharedStrings = new SharedStrings();
        final ArrayList<BuildingDef> Buildings = new ArrayList();
        final ArrayList<RoomDef> tempRooms = new ArrayList();
        int wY;

        MetaGridLoaderThread(int n) {
            this.wY = n;
        }

        @Override
        public void run() {
            try {
                this.runInner();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }

        void runInner() {
            for (int i = this.wY; i <= IsoMetaGrid.this.maxY; i += 8) {
                for (int j = IsoMetaGrid.this.minX; j <= IsoMetaGrid.this.maxX; ++j) {
                    this.loadCell(j, i);
                }
            }
        }

        void loadCell(int n, int n2) {
            IsoMetaCell isoMetaCell;
            IsoMetaGrid.this.Grid[n - IsoMetaGrid.this.minX][n2 - IsoMetaGrid.this.minY] = isoMetaCell = new IsoMetaCell(n, n2);
            String string = n + "_" + n2 + ".lotheader";
            if (!IsoLot.InfoFileNames.containsKey(string)) {
                return;
            }
            LotHeader lotHeader = IsoLot.InfoHeaders.get(string);
            if (lotHeader == null) {
                return;
            }
            File file = new File(IsoLot.InfoFileNames.get(string));
            if (!file.exists()) {
                return;
            }
            isoMetaCell.info = lotHeader;
            try (BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(file.getAbsolutePath(), "r", 4096);){
                int n3;
                int n4;
                int n5;
                Object object;
                int n6;
                int n7;
                lotHeader.version = IsoLot.readInt(bufferedRandomAccessFile);
                int n8 = IsoLot.readInt(bufferedRandomAccessFile);
                for (n7 = 0; n7 < n8; ++n7) {
                    String string2 = IsoLot.readString(bufferedRandomAccessFile);
                    lotHeader.tilesUsed.add(this.sharedStrings.get(string2.trim()));
                }
                bufferedRandomAccessFile.read();
                lotHeader.width = IsoLot.readInt(bufferedRandomAccessFile);
                lotHeader.height = IsoLot.readInt(bufferedRandomAccessFile);
                lotHeader.levels = IsoLot.readInt(bufferedRandomAccessFile);
                n7 = IsoLot.readInt(bufferedRandomAccessFile);
                for (n6 = 0; n6 < n7; ++n6) {
                    String string3 = IsoLot.readString(bufferedRandomAccessFile);
                    object = new RoomDef(n6, this.sharedStrings.get(string3));
                    ((RoomDef)object).level = IsoLot.readInt(bufferedRandomAccessFile);
                    n5 = IsoLot.readInt(bufferedRandomAccessFile);
                    for (n4 = 0; n4 < n5; ++n4) {
                        RoomDef.RoomRect roomRect = new RoomDef.RoomRect(IsoLot.readInt(bufferedRandomAccessFile) + n * 300, IsoLot.readInt(bufferedRandomAccessFile) + n2 * 300, IsoLot.readInt(bufferedRandomAccessFile), IsoLot.readInt(bufferedRandomAccessFile));
                        ((RoomDef)object).rects.add(roomRect);
                    }
                    ((RoomDef)object).CalculateBounds();
                    ((RoomDef)object).metaID = ((RoomDef)object).calculateMetaID(n, n2);
                    lotHeader.Rooms.put(((RoomDef)object).ID, (RoomDef)object);
                    if (lotHeader.RoomByMetaID.contains(((RoomDef)object).metaID)) {
                        DebugLog.General.error("duplicate RoomDef.metaID for room at %d,%d,%d", ((RoomDef)object).x, ((RoomDef)object).y, ((RoomDef)object).level);
                    }
                    lotHeader.RoomByMetaID.put(((RoomDef)object).metaID, object);
                    lotHeader.RoomList.add((RoomDef)object);
                    isoMetaCell.addRoom((RoomDef)object, n * 300, n2 * 300);
                    n4 = IsoLot.readInt(bufferedRandomAccessFile);
                    for (int i = 0; i < n4; ++i) {
                        int n9 = IsoLot.readInt(bufferedRandomAccessFile);
                        int n10 = IsoLot.readInt(bufferedRandomAccessFile);
                        int n11 = IsoLot.readInt(bufferedRandomAccessFile);
                        ((RoomDef)object).objects.add(new MetaObject(n9, n10 + n * 300 - ((RoomDef)object).x, n11 + n2 * 300 - ((RoomDef)object).y, (RoomDef)object));
                    }
                    ((RoomDef)object).bLightsActive = Rand.Next(2) == 0;
                }
                n6 = IsoLot.readInt(bufferedRandomAccessFile);
                for (n3 = 0; n3 < n6; ++n3) {
                    object = new BuildingDef();
                    n5 = IsoLot.readInt(bufferedRandomAccessFile);
                    ((BuildingDef)object).ID = n3;
                    for (n4 = 0; n4 < n5; ++n4) {
                        RoomDef roomDef = lotHeader.Rooms.get(IsoLot.readInt(bufferedRandomAccessFile));
                        roomDef.building = object;
                        if (roomDef.isEmptyOutside()) {
                            ((BuildingDef)object).emptyoutside.add(roomDef);
                            continue;
                        }
                        ((BuildingDef)object).rooms.add(roomDef);
                    }
                    ((BuildingDef)object).CalculateBounds(this.tempRooms);
                    ((BuildingDef)object).metaID = ((BuildingDef)object).calculateMetaID(n, n2);
                    lotHeader.Buildings.add((BuildingDef)object);
                    lotHeader.BuildingByMetaID.put(((BuildingDef)object).metaID, object);
                    this.Buildings.add((BuildingDef)object);
                }
                for (n3 = 0; n3 < 30; ++n3) {
                    for (int i = 0; i < 30; ++i) {
                        n5 = bufferedRandomAccessFile.read();
                        IsoMetaChunk isoMetaChunk = isoMetaCell.getChunk(n3, i);
                        isoMetaChunk.setZombieIntensity(n5);
                    }
                }
            }
            catch (Exception exception) {
                DebugLog.log("ERROR loading " + file.getAbsolutePath());
                ExceptionLogger.logException(exception);
            }
        }

        void postLoad() {
            IsoMetaGrid.this.Buildings.addAll(this.Buildings);
            this.Buildings.clear();
            this.sharedStrings.clear();
            this.tempRooms.clear();
        }
    }

    public static class Zone {
        public Double id = 0.0;
        public int hourLastSeen = 0;
        public int lastActionTimestamp = 0;
        public boolean haveConstruction = false;
        public final HashMap<String, Integer> spawnedZombies = new HashMap();
        public String zombiesTypeToSpawn = null;
        public Boolean spawnSpecialZombies = null;
        public String name;
        public String type;
        public int x;
        public int y;
        public int z;
        public int w;
        public int h;
        public ZoneGeometryType geometryType = ZoneGeometryType.INVALID;
        public final TIntArrayList points = new TIntArrayList();
        private boolean bTriangulateFailed = false;
        public int polylineWidth = 0;
        public float[] polylineOutlinePoints;
        public float[] triangles;
        public float[] triangleAreas;
        public float totalArea = 0.0f;
        public int pickedXForZoneStory;
        public int pickedYForZoneStory;
        public RandomizedZoneStoryBase pickedRZStory;
        private String originalName;
        public boolean isPreferredZoneForSquare = false;
        static final PolygonalMap2.LiangBarsky LIANG_BARSKY = new PolygonalMap2.LiangBarsky();
        static final Vector2 L_lineSegmentIntersects = new Vector2();

        public Zone(String string, String string2, int n, int n2, int n3, int n4, int n5) {
            this.id = (double)Rand.Next(9999999) + 100000.0;
            this.originalName = string;
            this.name = string;
            this.type = string2;
            this.x = n;
            this.y = n2;
            this.z = n3;
            this.w = n4;
            this.h = n5;
        }

        public void setX(int n) {
            this.x = n;
        }

        public void setY(int n) {
            this.y = n;
        }

        public void setW(int n) {
            this.w = n;
        }

        public void setH(int n) {
            this.h = n;
        }

        public boolean isPoint() {
            return this.geometryType == ZoneGeometryType.Point;
        }

        public boolean isPolygon() {
            return this.geometryType == ZoneGeometryType.Polygon;
        }

        public boolean isPolyline() {
            return this.geometryType == ZoneGeometryType.Polyline;
        }

        public boolean isRectangle() {
            return this.geometryType == ZoneGeometryType.INVALID;
        }

        public void setPickedXForZoneStory(int n) {
            this.pickedXForZoneStory = n;
        }

        public void setPickedYForZoneStory(int n) {
            this.pickedYForZoneStory = n;
        }

        public float getHoursSinceLastSeen() {
            return (float)GameTime.instance.getWorldAgeHours() - (float)this.hourLastSeen;
        }

        public void setHourSeenToCurrent() {
            this.hourLastSeen = (int)GameTime.instance.getWorldAgeHours();
        }

        public void setHaveConstruction(boolean bl) {
            this.haveConstruction = bl;
            if (GameClient.bClient) {
                ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
                PacketTypes.PacketType.ConstructedZone.doPacket(byteBufferWriter);
                byteBufferWriter.putInt(this.x);
                byteBufferWriter.putInt(this.y);
                byteBufferWriter.putInt(this.z);
                PacketTypes.PacketType.ConstructedZone.send(GameClient.connection);
            }
        }

        public boolean haveCons() {
            return this.haveConstruction;
        }

        public int getZombieDensity() {
            IsoMetaChunk isoMetaChunk = IsoWorld.instance.MetaGrid.getChunkDataFromTile(this.x, this.y);
            if (isoMetaChunk != null) {
                return isoMetaChunk.getUnadjustedZombieIntensity();
            }
            return 0;
        }

        public boolean contains(int n, int n2, int n3) {
            if (n3 != this.z) {
                return false;
            }
            if (n < this.x || n >= this.x + this.w) {
                return false;
            }
            if (n2 < this.y || n2 >= this.y + this.h) {
                return false;
            }
            if (this.isPoint()) {
                return false;
            }
            if (this.isPolyline()) {
                if (this.polylineWidth > 0) {
                    this.checkPolylineOutline();
                    return this.isPointInPolyline_WindingNumber((float)n + 0.5f, (float)n2 + 0.5f, 0) == PolygonHit.Inside;
                }
                return false;
            }
            if (this.isPolygon()) {
                return this.isPointInPolygon_WindingNumber((float)n + 0.5f, (float)n2 + 0.5f, 0) == PolygonHit.Inside;
            }
            return true;
        }

        public boolean intersects(int n, int n2, int n3, int n4, int n5) {
            if (this.z != n3) {
                return false;
            }
            if (n + n4 <= this.x || n >= this.x + this.w) {
                return false;
            }
            if (n2 + n5 <= this.y || n2 >= this.y + this.h) {
                return false;
            }
            if (this.isPolygon()) {
                return this.polygonRectIntersect(n, n2, n4, n5);
            }
            if (this.isPolyline()) {
                if (this.polylineWidth > 0) {
                    this.checkPolylineOutline();
                    return this.polylineOutlineRectIntersect(n, n2, n4, n5);
                }
                for (int i = 0; i < this.points.size() - 2; i += 2) {
                    int n6;
                    int n7;
                    int n8;
                    int n9 = this.points.getQuick(i);
                    if (!LIANG_BARSKY.lineRectIntersect(n9, n8 = this.points.getQuick(i + 1), (n7 = this.points.getQuick(i + 2)) - n9, (n6 = this.points.getQuick(i + 3)) - n8, n, n2, n + n4, n2 + n5)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public boolean difference(int n, int n2, int n3, int n4, int n5, ArrayList<Zone> arrayList) {
            arrayList.clear();
            if (!this.intersects(n, n2, n3, n4, n5)) {
                return false;
            }
            if (this.isRectangle()) {
                int n6;
                int n7;
                if (this.x < n) {
                    n7 = Math.max(n2, this.y);
                    n6 = Math.min(n2 + n5, this.y + this.h);
                    arrayList.add(new Zone(this.name, this.type, this.x, n7, n3, n - this.x, n6 - n7));
                }
                if (n + n4 < this.x + this.w) {
                    n7 = Math.max(n2, this.y);
                    n6 = Math.min(n2 + n5, this.y + this.h);
                    arrayList.add(new Zone(this.name, this.type, n + n4, n7, n3, this.x + this.w - (n + n4), n6 - n7));
                }
                if (this.y < n2) {
                    arrayList.add(new Zone(this.name, this.type, this.x, this.y, n3, this.w, n2 - this.y));
                }
                if (n2 + n5 < this.y + this.h) {
                    arrayList.add(new Zone(this.name, this.type, this.x, n2 + n5, n3, this.w, this.y + this.h - (n2 + n5)));
                }
                return true;
            }
            if (this.isPolygon()) {
                int n8;
                if (s_clipper == null) {
                    s_clipper = new Clipper();
                    s_clipperBuffer = ByteBuffer.allocateDirect(3072);
                }
                Clipper clipper = s_clipper;
                ByteBuffer byteBuffer = s_clipperBuffer;
                byteBuffer.clear();
                for (n8 = 0; n8 < this.points.size(); n8 += 2) {
                    byteBuffer.putFloat(this.points.getQuick(n8));
                    byteBuffer.putFloat(this.points.getQuick(n8 + 1));
                }
                clipper.clear();
                clipper.addPath(this.points.size() / 2, byteBuffer, false);
                clipper.clipAABB(n, n2, n + n4, n2 + n5);
                n8 = clipper.generatePolygons();
                for (int i = 0; i < n8; ++i) {
                    byteBuffer.clear();
                    clipper.getPolygon(i, byteBuffer);
                    int n9 = byteBuffer.getShort();
                    if (n9 < 3) {
                        byteBuffer.position(byteBuffer.position() + n9 * 4 * 2);
                        continue;
                    }
                    Zone zone = new Zone(this.name, this.type, this.x, this.y, this.z, this.w, this.h);
                    zone.geometryType = ZoneGeometryType.Polygon;
                    for (int j = 0; j < n9; ++j) {
                        zone.points.add((int)byteBuffer.getFloat());
                        zone.points.add((int)byteBuffer.getFloat());
                    }
                    arrayList.add(zone);
                }
            }
            if (this.isPolyline()) {
                // empty if block
            }
            return true;
        }

        private int pickRandomTriangle() {
            float[] fArray;
            Object object = this.isPolygon() ? this.getPolygonTriangles() : (fArray = (Object)(this.isPolyline() ? this.getPolylineOutlineTriangles() : null));
            if (fArray == null) {
                return -1;
            }
            int n = fArray.length / 6;
            float f = Rand.Next(0.0f, this.totalArea);
            float f2 = 0.0f;
            for (int i = 0; i < this.triangleAreas.length; ++i) {
                if (!((f2 += this.triangleAreas[i]) >= f)) continue;
                return i;
            }
            return Rand.Next(n);
        }

        private Vector2 pickRandomPointInTriangle(int n, Vector2 vector22) {
            float f;
            boolean bl;
            float f2 = this.triangles[n * 3 * 2];
            float f3 = this.triangles[n * 3 * 2 + 1];
            float f4 = this.triangles[n * 3 * 2 + 2];
            float f5 = this.triangles[n * 3 * 2 + 3];
            float f6 = this.triangles[n * 3 * 2 + 4];
            float f7 = this.triangles[n * 3 * 2 + 5];
            float f8 = Rand.Next(0.0f, 1.0f);
            boolean bl2 = bl = f8 + (f = Rand.Next(0.0f, 1.0f)) <= 1.0f;
            if (bl) {
                var11_12 = f8 * (f4 - f2) + f * (f6 - f2);
                var12_13 = f8 * (f5 - f3) + f * (f7 - f3);
            } else {
                var11_12 = (1.0f - f8) * (f4 - f2) + (1.0f - f) * (f6 - f2);
                var12_13 = (1.0f - f8) * (f5 - f3) + (1.0f - f) * (f7 - f3);
            }
            return vector22.set(var11_12 += f2, var12_13 += f3);
        }

        public IsoGameCharacter.Location pickRandomLocation(IsoGameCharacter.Location location) {
            if (this.isPolygon() || this.isPolyline() && this.polylineWidth > 0) {
                int n = this.pickRandomTriangle();
                if (n == -1) {
                    return null;
                }
                for (int i = 0; i < 20; ++i) {
                    Vector2 vector22 = this.pickRandomPointInTriangle(n, BaseVehicle.allocVector2());
                    if (!this.contains((int)vector22.x, (int)vector22.y, this.z)) continue;
                    location.set((int)vector22.x, (int)vector22.y, this.z);
                    BaseVehicle.releaseVector2(vector22);
                    return location;
                }
                return null;
            }
            if (this.isPoint() || this.isPolyline()) {
                return null;
            }
            return location.set(Rand.Next(this.x, this.x + this.w), Rand.Next(this.y, this.y + this.h), this.z);
        }

        public IsoGridSquare getRandomSquareInZone() {
            IsoGameCharacter.Location location = this.pickRandomLocation(TL_Location.get());
            if (location == null) {
                return null;
            }
            return IsoWorld.instance.CurrentCell.getGridSquare(location.x, location.y, location.z);
        }

        public IsoGridSquare getRandomUnseenSquareInZone() {
            return null;
        }

        public void addSquare(IsoGridSquare isoGridSquare) {
        }

        public ArrayList<IsoGridSquare> getSquares() {
            return null;
        }

        public void removeSquare(IsoGridSquare isoGridSquare) {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public int getLastActionTimestamp() {
            return this.lastActionTimestamp;
        }

        public void setLastActionTimestamp(int n) {
            this.lastActionTimestamp = n;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public int getHeight() {
            return this.h;
        }

        public int getWidth() {
            return this.w;
        }

        public float getTotalArea() {
            if (this.isRectangle() || this.isPoint() || this.isPolyline() && this.polylineWidth <= 0) {
                return this.getWidth() * this.getHeight();
            }
            this.getPolygonTriangles();
            this.getPolylineOutlineTriangles();
            return this.totalArea;
        }

        public void sendToServer() {
            if (GameClient.bClient) {
                GameClient.registerZone(this, true);
            }
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public void setOriginalName(String string) {
            this.originalName = string;
        }

        public int getClippedSegmentOfPolyline(int n, int n2, int n3, int n4, double[] dArray) {
            if (!this.isPolyline()) {
                return -1;
            }
            float f = this.polylineWidth % 2 == 0 ? 0.0f : 0.5f;
            for (int i = 0; i < this.points.size() - 2; i += 2) {
                int n5;
                int n6;
                int n7;
                int n8 = this.points.getQuick(i);
                if (!LIANG_BARSKY.lineRectIntersect((float)n8 + f, (float)(n7 = this.points.getQuick(i + 1)) + f, (n6 = this.points.getQuick(i + 2)) - n8, (n5 = this.points.getQuick(i + 3)) - n7, n, n2, n3, n4, dArray)) continue;
                return i / 2;
            }
            return -1;
        }

        private void checkPolylineOutline() {
            int n;
            int n2;
            int n3;
            if (this.polylineOutlinePoints != null) {
                return;
            }
            if (!this.isPolyline()) {
                return;
            }
            if (this.polylineWidth <= 0) {
                return;
            }
            if (s_clipperOffset == null) {
                s_clipperOffset = new ClipperOffset();
                s_clipperBuffer = ByteBuffer.allocateDirect(3072);
            }
            ClipperOffset clipperOffset = s_clipperOffset;
            ByteBuffer byteBuffer = s_clipperBuffer;
            clipperOffset.clear();
            byteBuffer.clear();
            float f = this.polylineWidth % 2 == 0 ? 0.0f : 0.5f;
            for (n3 = 0; n3 < this.points.size(); n3 += 2) {
                n2 = this.points.get(n3);
                n = this.points.get(n3 + 1);
                byteBuffer.putFloat((float)n2 + f);
                byteBuffer.putFloat((float)n + f);
            }
            byteBuffer.flip();
            clipperOffset.addPath(this.points.size() / 2, byteBuffer, ClipperOffset.JoinType.jtMiter.ordinal(), ClipperOffset.EndType.etOpenButt.ordinal());
            clipperOffset.execute((float)this.polylineWidth / 2.0f);
            n3 = clipperOffset.getPolygonCount();
            if (n3 < 1) {
                DebugLog.General.warn("Failed to generate polyline outline");
                return;
            }
            byteBuffer.clear();
            clipperOffset.getPolygon(0, byteBuffer);
            n2 = byteBuffer.getShort();
            this.polylineOutlinePoints = new float[n2 * 2];
            for (n = 0; n < n2; ++n) {
                this.polylineOutlinePoints[n * 2] = byteBuffer.getFloat();
                this.polylineOutlinePoints[n * 2 + 1] = byteBuffer.getFloat();
            }
        }

        float isLeft(float f, float f2, float f3, float f4, float f5, float f6) {
            return (f3 - f) * (f6 - f2) - (f5 - f) * (f4 - f2);
        }

        PolygonHit isPointInPolygon_WindingNumber(float f, float f2, int n) {
            int n2 = 0;
            for (int i = 0; i < this.points.size(); i += 2) {
                int n3 = this.points.getQuick(i);
                int n4 = this.points.getQuick(i + 1);
                int n5 = this.points.getQuick((i + 2) % this.points.size());
                int n6 = this.points.getQuick((i + 3) % this.points.size());
                if ((float)n4 <= f2) {
                    if (!((float)n6 > f2) || !(this.isLeft(n3, n4, n5, n6, f, f2) > 0.0f)) continue;
                    ++n2;
                    continue;
                }
                if (!((float)n6 <= f2) || !(this.isLeft(n3, n4, n5, n6, f, f2) < 0.0f)) continue;
                --n2;
            }
            return n2 == 0 ? PolygonHit.Outside : PolygonHit.Inside;
        }

        PolygonHit isPointInPolyline_WindingNumber(float f, float f2, int n) {
            int n2 = 0;
            float[] fArray = this.polylineOutlinePoints;
            if (fArray == null) {
                return PolygonHit.Outside;
            }
            for (int i = 0; i < fArray.length; i += 2) {
                float f3 = fArray[i];
                float f4 = fArray[i + 1];
                float f5 = fArray[(i + 2) % fArray.length];
                float f6 = fArray[(i + 3) % fArray.length];
                if (f4 <= f2) {
                    if (!(f6 > f2) || !(this.isLeft(f3, f4, f5, f6, f, f2) > 0.0f)) continue;
                    ++n2;
                    continue;
                }
                if (!(f6 <= f2) || !(this.isLeft(f3, f4, f5, f6, f, f2) < 0.0f)) continue;
                --n2;
            }
            return n2 == 0 ? PolygonHit.Outside : PolygonHit.Inside;
        }

        boolean polygonRectIntersect(int n, int n2, int n3, int n4) {
            if (this.x >= n && this.x + this.w <= n + n3 && this.y >= n2 && this.y + this.h <= n2 + n4) {
                return true;
            }
            return this.lineSegmentIntersects(n, n2, n + n3, n2) || this.lineSegmentIntersects(n + n3, n2, n + n3, n2 + n4) || this.lineSegmentIntersects(n + n3, n2 + n4, n, n2 + n4) || this.lineSegmentIntersects(n, n2 + n4, n, n2);
        }

        boolean lineSegmentIntersects(float f, float f2, float f3, float f4) {
            L_lineSegmentIntersects.set(f3 - f, f4 - f2);
            float f5 = L_lineSegmentIntersects.getLength();
            L_lineSegmentIntersects.normalize();
            float f6 = Zone.L_lineSegmentIntersects.x;
            float f7 = Zone.L_lineSegmentIntersects.y;
            for (int i = 0; i < this.points.size(); i += 2) {
                float f8;
                float f9;
                float f10;
                float f11;
                float f12;
                float f13;
                float f14;
                float f15;
                float f16;
                float f17 = this.points.getQuick(i);
                float f18 = this.points.getQuick(i + 1);
                float f19 = this.points.getQuick((i + 2) % this.points.size());
                float f20 = f19;
                float f21 = f20 - (f16 = f17);
                float f22 = (f21 * (f15 = f2 - (f14 = f18)) - (f13 = (f12 = (f11 = (float)this.points.getQuick((i + 3) % this.points.size()))) - f14) * (f10 = f - f16)) * (f9 = 1.0f / (f13 * f6 - f21 * f7));
                if (!(f22 >= 0.0f) || !(f22 <= f5) || !((f8 = (f15 * f6 - f10 * f7) * f9) >= 0.0f) || !(f8 <= 1.0f)) continue;
                return true;
            }
            return this.isPointInPolygon_WindingNumber((f + f3) / 2.0f, (f2 + f4) / 2.0f, 0) != PolygonHit.Outside;
        }

        boolean polylineOutlineRectIntersect(int n, int n2, int n3, int n4) {
            if (this.polylineOutlinePoints == null) {
                return false;
            }
            if (this.x >= n && this.x + this.w <= n + n3 && this.y >= n2 && this.y + this.h <= n2 + n4) {
                return true;
            }
            return this.polylineOutlineSegmentIntersects(n, n2, n + n3, n2) || this.polylineOutlineSegmentIntersects(n + n3, n2, n + n3, n2 + n4) || this.polylineOutlineSegmentIntersects(n + n3, n2 + n4, n, n2 + n4) || this.polylineOutlineSegmentIntersects(n, n2 + n4, n, n2);
        }

        boolean polylineOutlineSegmentIntersects(float f, float f2, float f3, float f4) {
            L_lineSegmentIntersects.set(f3 - f, f4 - f2);
            float f5 = L_lineSegmentIntersects.getLength();
            L_lineSegmentIntersects.normalize();
            float f6 = Zone.L_lineSegmentIntersects.x;
            float f7 = Zone.L_lineSegmentIntersects.y;
            float[] fArray = this.polylineOutlinePoints;
            for (int i = 0; i < fArray.length; i += 2) {
                float f8;
                float f9 = fArray[(i + 2) % fArray.length];
                float f10 = f9;
                float f11 = fArray[i];
                float f12 = f11;
                float f13 = f10 - f12;
                float f14 = fArray[i + 1];
                float f15 = f14;
                float f16 = f2 - f15;
                float f17 = fArray[(i + 3) % fArray.length];
                float f18 = f17;
                float f19 = f18 - f15;
                float f20 = f - f12;
                float f21 = 1.0f / (f19 * f6 - f13 * f7);
                float f22 = (f13 * f16 - f19 * f20) * f21;
                if (!(f22 >= 0.0f) || !(f22 <= f5) || !((f8 = (f16 * f6 - f20 * f7) * f21) >= 0.0f) || !(f8 <= 1.0f)) continue;
                return true;
            }
            return this.isPointInPolyline_WindingNumber((f + f3) / 2.0f, (f2 + f4) / 2.0f, 0) != PolygonHit.Outside;
        }

        private boolean isClockwise() {
            if (!this.isPolygon()) {
                return false;
            }
            float f = 0.0f;
            for (int i = 0; i < this.points.size(); i += 2) {
                int n = this.points.getQuick(i);
                int n2 = this.points.getQuick(i + 1);
                int n3 = this.points.getQuick((i + 2) % this.points.size());
                int n4 = this.points.getQuick((i + 3) % this.points.size());
                f += (float)((n3 - n) * (n4 + n2));
            }
            return (double)f > 0.0;
        }

        public float[] getPolygonTriangles() {
            int n;
            if (this.triangles != null) {
                return this.triangles;
            }
            if (this.bTriangulateFailed) {
                return null;
            }
            if (!this.isPolygon()) {
                return null;
            }
            if (s_clipper == null) {
                s_clipper = new Clipper();
                s_clipperBuffer = ByteBuffer.allocateDirect(3072);
            }
            Clipper clipper = s_clipper;
            ByteBuffer byteBuffer = s_clipperBuffer;
            byteBuffer.clear();
            if (this.isClockwise()) {
                for (n = this.points.size() - 1; n > 0; n -= 2) {
                    byteBuffer.putFloat(this.points.getQuick(n - 1));
                    byteBuffer.putFloat(this.points.getQuick(n));
                }
            } else {
                for (n = 0; n < this.points.size(); n += 2) {
                    byteBuffer.putFloat(this.points.getQuick(n));
                    byteBuffer.putFloat(this.points.getQuick(n + 1));
                }
            }
            clipper.clear();
            clipper.addPath(this.points.size() / 2, byteBuffer, false);
            n = clipper.generatePolygons();
            if (n < 1) {
                this.bTriangulateFailed = true;
                return null;
            }
            byteBuffer.clear();
            int n2 = clipper.triangulate(0, byteBuffer);
            this.triangles = new float[n2 * 2];
            for (int i = 0; i < n2; ++i) {
                this.triangles[i * 2] = byteBuffer.getFloat();
                this.triangles[i * 2 + 1] = byteBuffer.getFloat();
            }
            this.initTriangleAreas();
            return this.triangles;
        }

        private float triangleArea(float f, float f2, float f3, float f4, float f5, float f6) {
            float f7 = Vector2f.length((float)(f3 - f), (float)(f4 - f2));
            float f8 = Vector2f.length((float)(f5 - f3), (float)(f6 - f4));
            float f9 = Vector2f.length((float)(f - f5), (float)(f2 - f6));
            float f10 = (f7 + f8 + f9) / 2.0f;
            return (float)Math.sqrt(f10 * (f10 - f7) * (f10 - f8) * (f10 - f9));
        }

        private void initTriangleAreas() {
            int n = this.triangles.length / 6;
            this.triangleAreas = new float[n];
            this.totalArea = 0.0f;
            for (int i = 0; i < this.triangles.length; i += 6) {
                float f;
                float f2 = this.triangles[i];
                float f3 = this.triangles[i + 1];
                float f4 = this.triangles[i + 2];
                float f5 = this.triangles[i + 3];
                float f6 = this.triangles[i + 4];
                float f7 = this.triangles[i + 5];
                this.triangleAreas[i / 6] = f = this.triangleArea(f2, f3, f4, f5, f6, f7);
                this.totalArea += f;
            }
        }

        public float[] getPolylineOutlineTriangles() {
            int n;
            if (this.triangles != null) {
                return this.triangles;
            }
            if (!this.isPolyline() || this.polylineWidth <= 0) {
                return null;
            }
            if (this.bTriangulateFailed) {
                return null;
            }
            this.checkPolylineOutline();
            float[] fArray = this.polylineOutlinePoints;
            if (fArray == null) {
                this.bTriangulateFailed = true;
                return null;
            }
            if (s_clipper == null) {
                s_clipper = new Clipper();
                s_clipperBuffer = ByteBuffer.allocateDirect(3072);
            }
            Clipper clipper = s_clipper;
            ByteBuffer byteBuffer = s_clipperBuffer;
            byteBuffer.clear();
            if (this.isClockwise()) {
                for (n = fArray.length - 1; n > 0; n -= 2) {
                    byteBuffer.putFloat(fArray[n - 1]);
                    byteBuffer.putFloat(fArray[n]);
                }
            } else {
                for (n = 0; n < fArray.length; n += 2) {
                    byteBuffer.putFloat(fArray[n]);
                    byteBuffer.putFloat(fArray[n + 1]);
                }
            }
            clipper.clear();
            clipper.addPath(fArray.length / 2, byteBuffer, false);
            n = clipper.generatePolygons();
            if (n < 1) {
                this.bTriangulateFailed = true;
                return null;
            }
            byteBuffer.clear();
            int n2 = clipper.triangulate(0, byteBuffer);
            this.triangles = new float[n2 * 2];
            for (int i = 0; i < n2; ++i) {
                this.triangles[i * 2] = byteBuffer.getFloat();
                this.triangles[i * 2 + 1] = byteBuffer.getFloat();
            }
            this.initTriangleAreas();
            return this.triangles;
        }

        public float getPolylineLength() {
            if (!this.isPolyline() || this.points.isEmpty()) {
                return 0.0f;
            }
            float f = 0.0f;
            for (int i = 0; i < this.points.size() - 2; i += 2) {
                int n = this.points.get(i);
                int n2 = this.points.get(i + 1);
                int n3 = this.points.get(i + 2);
                int n4 = this.points.get(i + 3);
                f += Vector2f.length((float)(n3 - n), (float)(n4 - n2));
            }
            return f;
        }

        public void Dispose() {
            this.pickedRZStory = null;
            this.points.clear();
            this.polylineOutlinePoints = null;
            this.spawnedZombies.clear();
            this.triangles = null;
        }

        private static enum PolygonHit {
            OnEdge,
            Inside,
            Outside;

        }
    }

    public static final class VehicleZone
    extends Zone {
        public static final short VZF_FaceDirection = 1;
        public IsoDirections dir = IsoDirections.Max;
        public short flags = 0;

        public VehicleZone(String string, String string2, int n, int n2, int n3, int n4, int n5, KahluaTable kahluaTable) {
            super(string, string2, n, n2, n3, n4, n5);
            if (kahluaTable != null) {
                Object object = kahluaTable.rawget((Object)"Direction");
                if (object instanceof String) {
                    this.dir = IsoDirections.valueOf((String)object);
                }
                if ((object = kahluaTable.rawget((Object)"FaceDirection")) == Boolean.TRUE) {
                    this.flags = (short)(this.flags | 1);
                }
            }
        }

        public boolean isFaceDirection() {
            return (this.flags & 1) != 0;
        }
    }

    public static enum ZoneGeometryType {
        INVALID,
        Point,
        Polyline,
        Polygon;

    }

    public static final class RoomTone {
        public int x;
        public int y;
        public int z;
        public String enumValue;
        public boolean entireBuilding;
    }

    public static final class Trigger {
        public BuildingDef def;
        public int triggerRange;
        public int zombieExclusionRange;
        public String type;
        public boolean triggered = false;
        public KahluaTable data;

        public Trigger(BuildingDef buildingDef, int n, int n2, String string) {
            this.def = buildingDef;
            this.triggerRange = n;
            this.zombieExclusionRange = n2;
            this.type = string;
            this.data = LuaManager.platform.newTable();
        }

        public KahluaTable getModData() {
            return this.data;
        }
    }
}

