/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import zombie.characters.IsoPlayer;
import zombie.core.opengl.RenderSettings;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.objects.IsoLightSwitch;

public class IsoLightSource {
    public static int NextID = 1;
    public int ID;
    public int x;
    public int y;
    public int z;
    public float r;
    public float g;
    public float b;
    public float rJNI;
    public float gJNI;
    public float bJNI;
    public int radius;
    public boolean bActive;
    public boolean bWasActive;
    public boolean bActiveJNI;
    public int life = -1;
    public int startlife = -1;
    public IsoBuilding localToBuilding;
    public boolean bHydroPowered = false;
    public ArrayList<IsoLightSwitch> switches = new ArrayList(0);
    public IsoChunk chunk;
    public Object lightMap;

    public IsoLightSource(int n, int n2, int n3, float f, float f2, float f3, int n4) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.radius = n4;
        this.bActive = true;
    }

    public IsoLightSource(int n, int n2, int n3, float f, float f2, float f3, int n4, IsoBuilding isoBuilding) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.radius = n4;
        this.bActive = true;
        this.localToBuilding = isoBuilding;
    }

    public IsoLightSource(int n, int n2, int n3, float f, float f2, float f3, int n4, int n5) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.radius = n4;
        this.bActive = true;
        this.startlife = this.life = n5;
    }

    public void update() {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y, this.z);
        if (!(!this.bHydroPowered || IsoWorld.instance.isHydroPowerOn() || isoGridSquare != null && isoGridSquare.haveElectricity())) {
            this.bActive = false;
            return;
        }
        if (!this.bActive) {
            return;
        }
        if (this.localToBuilding != null) {
            this.r = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.7f;
            this.g = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.7f;
            this.b = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.7f;
        }
        if (this.life > 0) {
            --this.life;
        }
        if (this.localToBuilding != null && isoGridSquare != null) {
            this.r = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.8f * IsoGridSquare.rmod * 0.7f;
            this.g = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.8f * IsoGridSquare.gmod * 0.7f;
            this.b = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.8f * IsoGridSquare.bmod * 0.7f;
        }
        for (int i = this.x - this.radius; i < this.x + this.radius; ++i) {
            for (int j = this.y - this.radius; j < this.y + this.radius; ++j) {
                for (int k = 0; k < 8; ++k) {
                    isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null || this.localToBuilding != null && this.localToBuilding != isoGridSquare.getBuilding()) continue;
                    LosUtil.TestResults testResults = LosUtil.lineClear(isoGridSquare.getCell(), this.x, this.y, this.z, isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ(), false);
                    if ((isoGridSquare.getX() != this.x || isoGridSquare.getY() != this.y || isoGridSquare.getZ() != this.z) && testResults == LosUtil.TestResults.Blocked) continue;
                    float f = 0.0f;
                    float f2 = Math.abs(isoGridSquare.getZ() - this.z) <= 1 ? IsoUtils.DistanceTo(this.x, this.y, 0.0f, isoGridSquare.getX(), isoGridSquare.getY(), 0.0f) : IsoUtils.DistanceTo(this.x, this.y, this.z, isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ());
                    if (f2 > (float)this.radius) continue;
                    f = f2 / (float)this.radius;
                    f = 1.0f - f;
                    f *= f;
                    if (this.life > -1) {
                        f *= (float)this.life / (float)this.startlife;
                    }
                    float f3 = f * this.r * 2.0f;
                    float f4 = f * this.g * 2.0f;
                    float f5 = f * this.b * 2.0f;
                    isoGridSquare.setLampostTotalR(isoGridSquare.getLampostTotalR() + f3);
                    isoGridSquare.setLampostTotalG(isoGridSquare.getLampostTotalG() + f4);
                    isoGridSquare.setLampostTotalB(isoGridSquare.getLampostTotalB() + f5);
                }
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int n) {
        this.z = n;
    }

    public float getR() {
        return this.r;
    }

    public void setR(float f) {
        this.r = f;
    }

    public float getG() {
        return this.g;
    }

    public void setG(float f) {
        this.g = f;
    }

    public float getB() {
        return this.b;
    }

    public void setB(float f) {
        this.b = f;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public boolean isActive() {
        return this.bActive;
    }

    public void setActive(boolean bl) {
        this.bActive = bl;
    }

    public boolean wasActive() {
        return this.bWasActive;
    }

    public void setWasActive(boolean bl) {
        this.bWasActive = bl;
    }

    public ArrayList<IsoLightSwitch> getSwitches() {
        return this.switches;
    }

    public void setSwitches(ArrayList<IsoLightSwitch> arrayList) {
        this.switches = arrayList;
    }

    public void clearInfluence() {
        for (int i = this.x - this.radius; i < this.x + this.radius; ++i) {
            for (int j = this.y - this.radius; j < this.y + this.radius; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null) continue;
                    isoGridSquare.setLampostTotalR(0.0f);
                    isoGridSquare.setLampostTotalG(0.0f);
                    isoGridSquare.setLampostTotalB(0.0f);
                }
            }
        }
    }

    public boolean isInBounds(int n, int n2, int n3, int n4) {
        return this.x >= n && this.x < n3 && this.y >= n2 && this.y < n4;
    }

    public boolean isInBounds() {
        IsoChunkMap[] isoChunkMapArray = IsoWorld.instance.CurrentCell.ChunkMap;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            int n;
            if (isoChunkMapArray[i].ignore) continue;
            int n2 = isoChunkMapArray[i].getWorldXMinTiles();
            int n3 = isoChunkMapArray[i].getWorldXMaxTiles();
            int n4 = isoChunkMapArray[i].getWorldYMinTiles();
            if (!this.isInBounds(n2, n4, n3, n = isoChunkMapArray[i].getWorldYMaxTiles())) continue;
            return true;
        }
        return false;
    }

    public boolean isHydroPowered() {
        return this.bHydroPowered;
    }

    public IsoBuilding getLocalToBuilding() {
        return this.localToBuilding;
    }
}

