/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.opengl.GL20;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.IndieGL;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.MapCollisionData;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.ZomboidBitFlag;
import zombie.ai.states.ZombieIdleState;
import zombie.audio.BaseSoundEmitter;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.characters.Moodles.MoodleType;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.opengl.RenderSettings;
import zombie.core.opengl.Shader;
import zombie.core.opengl.ShaderProgram;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.properties.PropertyContainer;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.erosion.ErosionData;
import zombie.erosion.categories.ErosionCategory;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoFloorBloodSplat;
import zombie.iso.IsoGridOcclusionData;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoPuddlesCompute;
import zombie.iso.IsoPuddlesGeometry;
import zombie.iso.IsoPushableObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWallBloodSplat;
import zombie.iso.IsoWaterGeometry;
import zombie.iso.IsoWorld;
import zombie.iso.LightingJNI;
import zombie.iso.LosUtil;
import zombie.iso.SliceY;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.areas.IsoRoom;
import zombie.iso.areas.NonPvpZone;
import zombie.iso.areas.SafeHouse;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.areas.isoregion.regions.IWorldRegion;
import zombie.iso.areas.isoregion.regions.IsoWorldRegion;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoBrokenGlass;
import zombie.iso.objects.IsoCarBatteryCharger;
import zombie.iso.objects.IsoCompost;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoFire;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.objects.IsoLightSwitch;
import zombie.iso.objects.IsoMannequin;
import zombie.iso.objects.IsoRainSplash;
import zombie.iso.objects.IsoRaindrop;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoTrap;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoWaveSignal;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.objects.RainManager;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.iso.sprite.shapers.FloorShaper;
import zombie.iso.sprite.shapers.FloorShaperAttachedSprites;
import zombie.iso.sprite.shapers.FloorShaperDeDiamond;
import zombie.iso.sprite.shapers.FloorShaperDiamond;
import zombie.iso.sprite.shapers.WallShaperN;
import zombie.iso.sprite.shapers.WallShaperW;
import zombie.iso.sprite.shapers.WallShaperWhole;
import zombie.iso.weather.fx.WeatherFxMask;
import zombie.meta.Meta;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.ServerLOS;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.popman.ObjectPool;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.io.BitHeader;
import zombie.util.io.BitHeaderRead;
import zombie.util.io.BitHeaderWrite;
import zombie.util.list.PZArrayList;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PolygonalMap2;

public final class IsoGridSquare {
    private boolean hasTree;
    private ArrayList<Float> LightInfluenceB;
    private ArrayList<Float> LightInfluenceG;
    private ArrayList<Float> LightInfluenceR;
    public final IsoGridSquare[] nav = new IsoGridSquare[8];
    public int collideMatrix = -1;
    public int pathMatrix = -1;
    public int visionMatrix = -1;
    public IsoRoom room = null;
    public IsoGridSquare w;
    public IsoGridSquare nw;
    public IsoGridSquare sw;
    public IsoGridSquare s;
    public IsoGridSquare n;
    public IsoGridSquare ne;
    public IsoGridSquare se;
    public IsoGridSquare e;
    public boolean haveSheetRope = false;
    private IWorldRegion isoWorldRegion;
    private boolean hasSetIsoWorldRegion = false;
    public int ObjectsSyncCount = 0;
    public IsoBuilding roofHideBuilding;
    public boolean bFlattenGrassEtc;
    private static final long VisiFlagTimerPeriod_ms = 750L;
    private final boolean[] playerCutawayFlags = new boolean[4];
    private final long[] playerCutawayFlagLockUntilTimes = new long[4];
    private final boolean[] targetPlayerCutawayFlags = new boolean[4];
    private final boolean[] playerIsDissolvedFlags = new boolean[4];
    private final long[] playerIsDissolvedFlagLockUntilTimes = new long[4];
    private final boolean[] targetPlayerIsDissolvedFlags = new boolean[4];
    private IsoWaterGeometry water = null;
    private IsoPuddlesGeometry puddles = null;
    private float puddlesCacheSize = -1.0f;
    private float puddlesCacheLevel = -1.0f;
    public final ILighting[] lighting = new ILighting[4];
    public int x;
    public int y;
    public int z;
    private int CachedScreenValue = -1;
    public float CachedScreenX;
    public float CachedScreenY;
    private static long torchTimer = 0L;
    public boolean SolidFloorCached = false;
    public boolean SolidFloor = false;
    private boolean CacheIsFree = false;
    private boolean CachedIsFree = false;
    public IsoChunk chunk;
    public int roomID = -1;
    public Integer ID = -999;
    public IsoMetaGrid.Zone zone;
    private final ArrayList<IsoGameCharacter> DeferedCharacters = new ArrayList();
    private int DeferredCharacterTick = -1;
    private final ArrayList<IsoMovingObject> StaticMovingObjects = new ArrayList(0);
    private final ArrayList<IsoMovingObject> MovingObjects = new ArrayList(0);
    protected final PZArrayList<IsoObject> Objects = new PZArrayList<IsoObject>(IsoObject.class, 2);
    protected final PZArrayList<IsoObject> localTemporaryObjects = new PZArrayList<IsoObject>(IsoObject.class, 2);
    private final ArrayList<IsoWorldInventoryObject> WorldObjects = new ArrayList();
    final ZomboidBitFlag hasTypes = new ZomboidBitFlag(IsoObjectType.MAX.index());
    private final PropertyContainer Properties = new PropertyContainer();
    private final ArrayList<IsoObject> SpecialObjects = new ArrayList(0);
    public boolean haveRoof = false;
    private boolean burntOut = false;
    private boolean bHasFlies = false;
    private IsoGridOcclusionData OcclusionDataCache = null;
    private static final PZArrayList<IsoWorldInventoryObject> tempWorldInventoryObjects = new PZArrayList<IsoWorldInventoryObject>(IsoWorldInventoryObject.class, 16);
    public static final ConcurrentLinkedQueue<IsoGridSquare> isoGridSquareCache = new ConcurrentLinkedQueue();
    public static ArrayDeque<IsoGridSquare> loadGridSquareCache;
    private boolean overlayDone = false;
    private KahluaTable table = null;
    private int trapPositionX = -1;
    private int trapPositionY = -1;
    private int trapPositionZ = -1;
    private boolean haveElectricity = false;
    public static int gridSquareCacheEmptyTimer;
    private static float darkStep;
    public static int RecalcLightTime;
    private static int lightcache;
    public static final ArrayList<IsoGridSquare> choices;
    public static boolean USE_WALL_SHADER;
    private static final int cutawayY = 0;
    private static final int cutawayNWWidth = 66;
    private static final int cutawayNWHeight = 226;
    private static final int cutawaySEXCut = 1084;
    private static final int cutawaySEXUncut = 1212;
    private static final int cutawaySEWidth = 6;
    private static final int cutawaySEHeight = 196;
    private static final int cutawayNXFullyCut = 700;
    private static final int cutawayNXCutW = 444;
    private static final int cutawayNXUncut = 828;
    private static final int cutawayNXCutE = 956;
    private static final int cutawayWXFullyCut = 512;
    private static final int cutawayWXCutS = 768;
    private static final int cutawayWXUncut = 896;
    private static final int cutawayWXCutN = 256;
    private static final int cutawayFenceXOffset = 1;
    private static final int cutawayLogWallXOffset = 1;
    private static final int cutawayMedicalCurtainWXOffset = -3;
    private static final int cutawaySpiffoWindowXOffset = -24;
    private static final int cutawayRoof4XOffset = -60;
    private static final int cutawayRoof17XOffset = -46;
    private static final int cutawayRoof28XOffset = -60;
    private static final int cutawayRoof41XOffset = -46;
    private static final ColorInfo lightInfoTemp;
    private static final float doorWindowCutawayLightMin = 0.3f;
    private static boolean bWallCutawayW;
    private static boolean bWallCutawayN;
    public boolean isSolidFloorCache;
    public boolean isExteriorCache;
    public boolean isVegitationCache;
    public int hourLastSeen = Integer.MIN_VALUE;
    static IsoGridSquare lastLoaded;
    public static int IDMax;
    static int col;
    static int path;
    static int pathdoor;
    static int vision;
    public long hashCodeObjects;
    static final Color tr;
    static final Color tl;
    static final Color br;
    static final Color bl;
    static final Color interp1;
    static final Color interp2;
    static final Color finalCol;
    public static final CellGetSquare cellGetSquare;
    public boolean propertiesDirty = true;
    public static boolean UseSlowCollision;
    private static boolean bDoSlowPathfinding;
    private static final Comparator<IsoMovingObject> comp;
    public static boolean isOnScreenLast;
    private float splashX;
    private float splashY;
    private float splashFrame = -1.0f;
    private int splashFrameNum;
    private final ColorInfo[] lightInfo = new ColorInfo[4];
    static String[] rainsplashCache;
    private static final ColorInfo defColorInfo;
    private static final ColorInfo blackColorInfo;
    static int colu;
    static int coll;
    static int colr;
    static int colu2;
    static int coll2;
    static int colr2;
    public static boolean CircleStencil;
    public static float rmod;
    public static float gmod;
    public static float bmod;
    static final Vector2 tempo;
    static final Vector2 tempo2;
    private IsoRaindrop RainDrop = null;
    private IsoRainSplash RainSplash = null;
    private ErosionData.Square erosion;
    private static final int[] SURFACE_OFFSETS;
    public static final int WALL_TYPE_N = 1;
    public static final int WALL_TYPE_S = 2;
    public static final int WALL_TYPE_W = 4;
    public static final int WALL_TYPE_E = 8;

    public static boolean getMatrixBit(int n, int n2, int n3, int n4) {
        return IsoGridSquare.getMatrixBit(n, (byte)n2, (byte)n3, (byte)n4);
    }

    public static boolean getMatrixBit(int n, byte by, byte by2, byte by3) {
        return (n >> by + by2 * 3 + by3 * 9 & 1) != 0;
    }

    public static int setMatrixBit(int n, int n2, int n3, int n4, boolean bl) {
        return IsoGridSquare.setMatrixBit(n, (byte)n2, (byte)n3, (byte)n4, bl);
    }

    public static int setMatrixBit(int n, byte by, byte by2, byte by3, boolean bl) {
        if (bl) {
            return n | 1 << by + by2 * 3 + by3 * 9;
        }
        return n & ~(1 << by + by2 * 3 + by3 * 9);
    }

    public void setPlayerCutawayFlag(int n, boolean bl, long l) {
        this.targetPlayerCutawayFlags[n] = bl;
        if (l > this.playerCutawayFlagLockUntilTimes[n] && this.playerCutawayFlags[n] != this.targetPlayerCutawayFlags[n]) {
            this.playerCutawayFlags[n] = this.targetPlayerCutawayFlags[n];
            this.playerCutawayFlagLockUntilTimes[n] = l + 750L;
        }
    }

    public boolean getPlayerCutawayFlag(int n, long l) {
        if (l > this.playerCutawayFlagLockUntilTimes[n]) {
            return this.targetPlayerCutawayFlags[n];
        }
        return this.playerCutawayFlags[n];
    }

    public void setIsDissolved(int n, boolean bl, long l) {
        this.targetPlayerIsDissolvedFlags[n] = bl;
        if (l > this.playerIsDissolvedFlagLockUntilTimes[n] && this.playerIsDissolvedFlags[n] != this.targetPlayerIsDissolvedFlags[n]) {
            this.playerIsDissolvedFlags[n] = this.targetPlayerIsDissolvedFlags[n];
            this.playerIsDissolvedFlagLockUntilTimes[n] = l + 750L;
        }
    }

    public boolean getIsDissolved(int n, long l) {
        if (l > this.playerIsDissolvedFlagLockUntilTimes[n]) {
            return this.targetPlayerIsDissolvedFlags[n];
        }
        return this.playerIsDissolvedFlags[n];
    }

    public IsoWaterGeometry getWater() {
        if (this.water != null && this.water.m_adjacentChunkLoadedCounter != this.chunk.m_adjacentChunkLoadedCounter) {
            this.water.m_adjacentChunkLoadedCounter = this.chunk.m_adjacentChunkLoadedCounter;
            if (this.water.hasWater || this.water.bShore) {
                this.clearWater();
            }
        }
        if (this.water == null) {
            try {
                this.water = IsoWaterGeometry.pool.alloc();
                this.water.m_adjacentChunkLoadedCounter = this.chunk.m_adjacentChunkLoadedCounter;
                if (this.water.init(this) == null) {
                    IsoWaterGeometry.pool.release(this.water);
                    this.water = null;
                }
            }
            catch (Exception exception) {
                this.clearWater();
            }
        }
        return this.water;
    }

    public void clearWater() {
        if (this.water != null) {
            IsoWaterGeometry.pool.release(this.water);
            this.water = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IsoPuddlesGeometry getPuddles() {
        if (this.puddles == null) {
            try {
                ObjectPool<IsoPuddlesGeometry> objectPool = IsoPuddlesGeometry.pool;
                synchronized (objectPool) {
                    this.puddles = IsoPuddlesGeometry.pool.alloc();
                }
                this.puddles.square = this;
                this.puddles.bRecalc = true;
            }
            catch (Exception exception) {
                this.clearPuddles();
            }
        }
        return this.puddles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPuddles() {
        if (this.puddles != null) {
            this.puddles.square = null;
            ObjectPool<IsoPuddlesGeometry> objectPool = IsoPuddlesGeometry.pool;
            synchronized (objectPool) {
                IsoPuddlesGeometry.pool.release(this.puddles);
            }
            this.puddles = null;
        }
    }

    public float getPuddlesInGround() {
        if (this.isInARoom()) {
            return -1.0f;
        }
        if ((double)Math.abs(IsoPuddles.getInstance().getPuddlesSize() + (float)Core.getInstance().getPerfPuddles() + (float)IsoCamera.frameState.OffscreenWidth - this.puddlesCacheSize) > 0.01) {
            this.puddlesCacheSize = IsoPuddles.getInstance().getPuddlesSize() + (float)Core.getInstance().getPerfPuddles() + (float)IsoCamera.frameState.OffscreenWidth;
            this.puddlesCacheLevel = IsoPuddlesCompute.computePuddle(this);
        }
        return this.puddlesCacheLevel;
    }

    public IsoGridOcclusionData getOcclusionData() {
        return this.OcclusionDataCache;
    }

    public IsoGridOcclusionData getOrCreateOcclusionData() {
        assert (!GameServer.bServer);
        if (this.OcclusionDataCache == null) {
            this.OcclusionDataCache = new IsoGridOcclusionData(this);
        }
        return this.OcclusionDataCache;
    }

    public void softClear() {
        this.zone = null;
        this.room = null;
        this.w = null;
        this.nw = null;
        this.sw = null;
        this.s = null;
        this.n = null;
        this.ne = null;
        this.se = null;
        this.e = null;
        this.isoWorldRegion = null;
        this.hasSetIsoWorldRegion = false;
        for (int i = 0; i < 8; ++i) {
            this.nav[i] = null;
        }
    }

    public float getGridSneakModifier(boolean bl) {
        if (!bl) {
            if (this.Properties.Is("CloseSneakBonus")) {
                return (float)Integer.parseInt(this.Properties.Val("CloseSneakBonus")) / 100.0f;
            }
            if (this.Properties.Is(IsoFlagType.collideN) || this.Properties.Is(IsoFlagType.collideW) || this.Properties.Is(IsoFlagType.WindowN) || this.Properties.Is(IsoFlagType.WindowW) || this.Properties.Is(IsoFlagType.doorN) || this.Properties.Is(IsoFlagType.doorW)) {
                return 8.0f;
            }
        } else if (this.Properties.Is(IsoFlagType.solidtrans)) {
            return 4.0f;
        }
        return 1.0f;
    }

    public boolean isSomethingTo(IsoGridSquare isoGridSquare) {
        return this.isWallTo(isoGridSquare) || this.isWindowTo(isoGridSquare) || this.isDoorTo(isoGridSquare);
    }

    public IsoObject getTransparentWallTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this || !this.isWallTo(isoGridSquare)) {
            return null;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.Properties.Is(IsoFlagType.SpearOnlyAttackThrough) && !isoGridSquare.Properties.Is(IsoFlagType.WindowW)) {
            return isoGridSquare.getWall();
        }
        if (this.x > isoGridSquare.x && this.Properties.Is(IsoFlagType.SpearOnlyAttackThrough) && !this.Properties.Is(IsoFlagType.WindowW)) {
            return this.getWall();
        }
        if (isoGridSquare.y > this.y && isoGridSquare.Properties.Is(IsoFlagType.SpearOnlyAttackThrough) && !isoGridSquare.Properties.Is(IsoFlagType.WindowN)) {
            return isoGridSquare.getWall();
        }
        if (this.y > isoGridSquare.y && this.Properties.Is(IsoFlagType.SpearOnlyAttackThrough) && !this.Properties.Is(IsoFlagType.WindowN)) {
            return this.getWall();
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            IsoObject isoObject = this.getTransparentWallTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z));
            IsoObject isoObject2 = this.getTransparentWallTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z));
            if (isoObject != null) {
                return isoObject;
            }
            if (isoObject2 != null) {
                return isoObject2;
            }
            isoObject = isoGridSquare.getTransparentWallTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z));
            isoObject2 = isoGridSquare.getTransparentWallTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z));
            if (isoObject != null) {
                return isoObject;
            }
            if (isoObject2 != null) {
                return isoObject2;
            }
        }
        return null;
    }

    public boolean isWallTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return false;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.Properties.Is(IsoFlagType.collideW) && !isoGridSquare.Properties.Is(IsoFlagType.WindowW)) {
            return true;
        }
        if (this.x > isoGridSquare.x && this.Properties.Is(IsoFlagType.collideW) && !this.Properties.Is(IsoFlagType.WindowW)) {
            return true;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.Properties.Is(IsoFlagType.collideN) && !isoGridSquare.Properties.Is(IsoFlagType.WindowN)) {
            return true;
        }
        if (this.y > isoGridSquare.y && this.Properties.Is(IsoFlagType.collideN) && !this.Properties.Is(IsoFlagType.WindowN)) {
            return true;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            if (this.isWallTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z)) || this.isWallTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z))) {
                return true;
            }
            if (isoGridSquare.isWallTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z)) || isoGridSquare.isWallTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z))) {
                return true;
            }
        }
        return false;
    }

    public boolean isWindowTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return false;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.Properties.Is(IsoFlagType.windowW)) {
            return true;
        }
        if (this.x > isoGridSquare.x && this.Properties.Is(IsoFlagType.windowW)) {
            return true;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.Properties.Is(IsoFlagType.windowN)) {
            return true;
        }
        if (this.y > isoGridSquare.y && this.Properties.Is(IsoFlagType.windowN)) {
            return true;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            if (this.isWindowTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z)) || this.isWindowTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z))) {
                return true;
            }
            if (isoGridSquare.isWindowTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z)) || isoGridSquare.isWindowTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z))) {
                return true;
            }
        }
        return false;
    }

    public boolean haveDoor() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            if (!(this.Objects.get(i) instanceof IsoDoor)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDoorOnEdge(IsoDirections isoDirections, boolean bl) {
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoDoor isoDoor = Type.tryCastTo(this.SpecialObjects.get(i), IsoDoor.class);
            if (isoDoor != null && isoDoor.getSpriteEdge(bl) == isoDirections) {
                return true;
            }
            IsoThumpable isoThumpable = Type.tryCastTo(this.SpecialObjects.get(i), IsoThumpable.class);
            if (isoThumpable == null || isoThumpable.getSpriteEdge(bl) != isoDirections) continue;
            return true;
        }
        return false;
    }

    public boolean hasClosedDoorOnEdge(IsoDirections isoDirections) {
        boolean bl = false;
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoDoor isoDoor = Type.tryCastTo(this.SpecialObjects.get(i), IsoDoor.class);
            if (isoDoor != null && !isoDoor.IsOpen() && isoDoor.getSpriteEdge(bl) == isoDirections) {
                return true;
            }
            IsoThumpable isoThumpable = Type.tryCastTo(this.SpecialObjects.get(i), IsoThumpable.class);
            if (isoThumpable == null || isoThumpable.IsOpen() || isoThumpable.getSpriteEdge(bl) != isoDirections) continue;
            return true;
        }
        return false;
    }

    public boolean hasOpenDoorOnEdge(IsoDirections isoDirections) {
        boolean bl = false;
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoDoor isoDoor = Type.tryCastTo(this.SpecialObjects.get(i), IsoDoor.class);
            if (isoDoor != null && isoDoor.IsOpen() && isoDoor.getSpriteEdge(bl) == isoDirections) {
                return true;
            }
            IsoThumpable isoThumpable = Type.tryCastTo(this.SpecialObjects.get(i), IsoThumpable.class);
            if (isoThumpable == null || !isoThumpable.IsOpen() || isoThumpable.getSpriteEdge(bl) != isoDirections) continue;
            return true;
        }
        return false;
    }

    public boolean isDoorTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return false;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.Properties.Is(IsoFlagType.doorW)) {
            return true;
        }
        if (this.x > isoGridSquare.x && this.Properties.Is(IsoFlagType.doorW)) {
            return true;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.Properties.Is(IsoFlagType.doorN)) {
            return true;
        }
        if (this.y > isoGridSquare.y && this.Properties.Is(IsoFlagType.doorN)) {
            return true;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            if (this.isDoorTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z)) || this.isDoorTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z))) {
                return true;
            }
            if (isoGridSquare.isDoorTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z)) || isoGridSquare.isDoorTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z))) {
                return true;
            }
        }
        return false;
    }

    public boolean isBlockedTo(IsoGridSquare isoGridSquare) {
        return this.isWallTo(isoGridSquare) || this.isWindowBlockedTo(isoGridSquare) || this.isDoorBlockedTo(isoGridSquare);
    }

    public boolean isWindowBlockedTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.hasBlockedWindow(false)) {
            return true;
        }
        if (this.x > isoGridSquare.x && this.hasBlockedWindow(false)) {
            return true;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.hasBlockedWindow(true)) {
            return true;
        }
        if (this.y > isoGridSquare.y && this.hasBlockedWindow(true)) {
            return true;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            if (this.isWindowBlockedTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z)) || this.isWindowBlockedTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z))) {
                return true;
            }
            if (isoGridSquare.isWindowBlockedTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z)) || isoGridSquare.isWindowBlockedTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z))) {
                return true;
            }
        }
        return false;
    }

    public boolean hasBlockedWindow(boolean bl) {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoWindow isoWindow;
            IsoObject isoObject = this.Objects.get(i);
            if (!(isoObject instanceof IsoWindow) || (isoWindow = (IsoWindow)isoObject).getNorth() != bl) continue;
            return !isoWindow.isDestroyed() && !isoWindow.open || isoWindow.isBarricaded();
        }
        return false;
    }

    public boolean isDoorBlockedTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.hasBlockedDoor(false)) {
            return true;
        }
        if (this.x > isoGridSquare.x && this.hasBlockedDoor(false)) {
            return true;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.hasBlockedDoor(true)) {
            return true;
        }
        if (this.y > isoGridSquare.y && this.hasBlockedDoor(true)) {
            return true;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            if (this.isDoorBlockedTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z)) || this.isDoorBlockedTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z))) {
                return true;
            }
            if (isoGridSquare.isDoorBlockedTo(IsoWorld.instance.CurrentCell.getGridSquare(isoGridSquare.x, this.y, this.z)) || isoGridSquare.isDoorBlockedTo(IsoWorld.instance.CurrentCell.getGridSquare(this.x, isoGridSquare.y, this.z))) {
                return true;
            }
        }
        return false;
    }

    public boolean hasBlockedDoor(boolean bl) {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject;
            IsoObject isoObject2 = this.Objects.get(i);
            if (isoObject2 instanceof IsoDoor && ((IsoDoor)(isoObject = (IsoDoor)isoObject2)).getNorth() == bl) {
                return !((IsoDoor)isoObject).open || ((IsoDoor)isoObject).isBarricaded();
            }
            if (!(isoObject2 instanceof IsoThumpable) || !((IsoThumpable)(isoObject = (IsoThumpable)isoObject2)).isDoor() || ((IsoThumpable)isoObject).getNorth() != bl) continue;
            return !((IsoThumpable)isoObject).open || ((IsoThumpable)isoObject).isBarricaded();
        }
        return false;
    }

    public IsoCurtain getCurtain(IsoObjectType isoObjectType) {
        for (int i = 0; i < this.getSpecialObjects().size(); ++i) {
            IsoCurtain isoCurtain = Type.tryCastTo(this.getSpecialObjects().get(i), IsoCurtain.class);
            if (isoCurtain == null || isoCurtain.getType() != isoObjectType) continue;
            return isoCurtain;
        }
        return null;
    }

    public IsoObject getHoppable(boolean bl) {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            PropertyContainer propertyContainer = isoObject.getProperties();
            if (propertyContainer != null && propertyContainer.Is(bl ? IsoFlagType.HoppableN : IsoFlagType.HoppableW)) {
                return isoObject;
            }
            if (propertyContainer == null || !propertyContainer.Is(bl ? IsoFlagType.WindowN : IsoFlagType.WindowW)) continue;
            return isoObject;
        }
        return null;
    }

    public IsoObject getHoppableTo(IsoGridSquare isoGridSquare) {
        IsoObject isoObject;
        if (isoGridSquare == null || isoGridSquare == this) {
            return null;
        }
        if (isoGridSquare.x < this.x && isoGridSquare.y == this.y && (isoObject = this.getHoppable(false)) != null) {
            return isoObject;
        }
        if (isoGridSquare.x == this.x && isoGridSquare.y < this.y && (isoObject = this.getHoppable(true)) != null) {
            return isoObject;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.y == this.y && (isoObject = isoGridSquare.getHoppable(false)) != null) {
            return isoObject;
        }
        if (isoGridSquare.x == this.x && isoGridSquare.y > this.y && (isoObject = isoGridSquare.getHoppable(true)) != null) {
            return isoObject;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            IsoGridSquare isoGridSquare2 = this.getCell().getGridSquare(this.x, isoGridSquare.y, this.z);
            IsoGridSquare isoGridSquare3 = this.getCell().getGridSquare(isoGridSquare.x, this.y, this.z);
            isoObject = this.getHoppableTo(isoGridSquare2);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = this.getHoppableTo(isoGridSquare3);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = isoGridSquare.getHoppableTo(isoGridSquare2);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = isoGridSquare.getHoppableTo(isoGridSquare3);
            if (isoObject != null) {
                return isoObject;
            }
        }
        return null;
    }

    public boolean isHoppableTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            return false;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.Properties.Is(IsoFlagType.HoppableW)) {
            return true;
        }
        if (this.x > isoGridSquare.x && this.Properties.Is(IsoFlagType.HoppableW)) {
            return true;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.Properties.Is(IsoFlagType.HoppableN)) {
            return true;
        }
        return this.y > isoGridSquare.y && this.Properties.Is(IsoFlagType.HoppableN);
    }

    public void discard() {
        this.hourLastSeen = Short.MIN_VALUE;
        this.chunk = null;
        this.zone = null;
        this.LightInfluenceB = null;
        this.LightInfluenceG = null;
        this.LightInfluenceR = null;
        this.room = null;
        this.w = null;
        this.nw = null;
        this.sw = null;
        this.s = null;
        this.n = null;
        this.ne = null;
        this.se = null;
        this.e = null;
        this.isoWorldRegion = null;
        this.hasSetIsoWorldRegion = false;
        this.nav[0] = null;
        this.nav[1] = null;
        this.nav[2] = null;
        this.nav[3] = null;
        this.nav[4] = null;
        this.nav[5] = null;
        this.nav[6] = null;
        this.nav[7] = null;
        for (int i = 0; i < 4; ++i) {
            if (this.lighting[i] == null) continue;
            this.lighting[i].reset();
        }
        this.SolidFloorCached = false;
        this.SolidFloor = false;
        this.CacheIsFree = false;
        this.CachedIsFree = false;
        this.chunk = null;
        this.roomID = -1;
        this.DeferedCharacters.clear();
        this.DeferredCharacterTick = -1;
        this.StaticMovingObjects.clear();
        this.MovingObjects.clear();
        this.Objects.clear();
        this.WorldObjects.clear();
        this.hasTypes.clear();
        this.table = null;
        this.Properties.Clear();
        this.SpecialObjects.clear();
        this.RainDrop = null;
        this.RainSplash = null;
        this.overlayDone = false;
        this.haveRoof = false;
        this.burntOut = false;
        this.trapPositionZ = -1;
        this.trapPositionY = -1;
        this.trapPositionX = -1;
        this.haveElectricity = false;
        this.haveSheetRope = false;
        if (this.erosion != null) {
            this.erosion.reset();
        }
        if (this.OcclusionDataCache != null) {
            this.OcclusionDataCache.Reset();
        }
        this.roofHideBuilding = null;
        this.bHasFlies = false;
        isoGridSquareCache.add(this);
    }

    private static boolean validateUser(String string, String string2) throws MalformedURLException, IOException {
        String string3;
        URL uRL = new URL("http://www.projectzomboid.com/scripts/auth.php?username=" + string + "&password=" + string2);
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        while ((string3 = bufferedReader.readLine()) != null) {
            if (!string3.contains("success")) continue;
            return true;
        }
        return false;
    }

    public float DistTo(int n, int n2) {
        return IsoUtils.DistanceManhatten((float)n + 0.5f, (float)n2 + 0.5f, this.x, this.y);
    }

    public float DistTo(IsoGridSquare isoGridSquare) {
        return IsoUtils.DistanceManhatten((float)this.x + 0.5f, (float)this.y + 0.5f, (float)isoGridSquare.x + 0.5f, (float)isoGridSquare.y + 0.5f);
    }

    public float DistToProper(IsoGridSquare isoGridSquare) {
        return IsoUtils.DistanceTo((float)this.x + 0.5f, (float)this.y + 0.5f, (float)isoGridSquare.x + 0.5f, (float)isoGridSquare.y + 0.5f);
    }

    public float DistTo(IsoMovingObject isoMovingObject) {
        return IsoUtils.DistanceManhatten((float)this.x + 0.5f, (float)this.y + 0.5f, isoMovingObject.getX(), isoMovingObject.getY());
    }

    public float DistToProper(IsoMovingObject isoMovingObject) {
        return IsoUtils.DistanceTo((float)this.x + 0.5f, (float)this.y + 0.5f, isoMovingObject.getX(), isoMovingObject.getY());
    }

    public boolean isSafeToSpawn() {
        choices.clear();
        this.isSafeToSpawn(this, 0);
        if (choices.size() > 7) {
            choices.clear();
            return true;
        }
        choices.clear();
        return false;
    }

    public void isSafeToSpawn(IsoGridSquare isoGridSquare, int n) {
        if (n > 5) {
            return;
        }
        choices.add(isoGridSquare);
        if (isoGridSquare.n != null && !choices.contains(isoGridSquare.n)) {
            this.isSafeToSpawn(isoGridSquare.n, n + 1);
        }
        if (isoGridSquare.s != null && !choices.contains(isoGridSquare.s)) {
            this.isSafeToSpawn(isoGridSquare.s, n + 1);
        }
        if (isoGridSquare.e != null && !choices.contains(isoGridSquare.e)) {
            this.isSafeToSpawn(isoGridSquare.e, n + 1);
        }
        if (isoGridSquare.w != null && !choices.contains(isoGridSquare.w)) {
            this.isSafeToSpawn(isoGridSquare.w, n + 1);
        }
    }

    public static boolean auth(String string, char[] cArray) {
        if (string.length() > 64) {
            return false;
        }
        String string2 = cArray.toString();
        if (string2.length() > 64) {
            return false;
        }
        try {
            return IsoGridSquare.validateUser(string, string2);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(IsoGridSquare.class.getName()).log(Level.SEVERE, null, malformedURLException);
        }
        catch (IOException iOException) {
            Logger.getLogger(IsoGridSquare.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return false;
    }

    private void renderAttachedSpritesWithNoWallLighting(IsoObject isoObject, ColorInfo colorInfo) {
        if (isoObject.AttachedAnimSprite == null || isoObject.AttachedAnimSprite.isEmpty()) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < isoObject.AttachedAnimSprite.size(); ++i) {
            IsoSpriteInstance isoSpriteInstance = isoObject.AttachedAnimSprite.get(i);
            if (isoSpriteInstance.parentSprite == null || !isoSpriteInstance.parentSprite.Properties.Is(IsoFlagType.NoWallLighting)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        IsoGridSquare.defColorInfo.r = colorInfo.r;
        IsoGridSquare.defColorInfo.g = colorInfo.g;
        IsoGridSquare.defColorInfo.b = colorInfo.b;
        float f = IsoGridSquare.defColorInfo.a;
        if (CircleStencil) {
            // empty if block
        }
        for (int i = 0; i < isoObject.AttachedAnimSprite.size(); ++i) {
            IsoSpriteInstance isoSpriteInstance = isoObject.AttachedAnimSprite.get(i);
            if (isoSpriteInstance.parentSprite == null || !isoSpriteInstance.parentSprite.Properties.Is(IsoFlagType.NoWallLighting)) continue;
            IsoGridSquare.defColorInfo.a = isoSpriteInstance.alpha;
            isoSpriteInstance.render(isoObject, this.x, this.y, this.z, isoObject.dir, isoObject.offsetX, isoObject.offsetY + isoObject.getRenderYOffset() * (float)Core.TileScale, defColorInfo);
            isoSpriteInstance.update();
        }
        IsoGridSquare.defColorInfo.r = 1.0f;
        IsoGridSquare.defColorInfo.g = 1.0f;
        IsoGridSquare.defColorInfo.b = 1.0f;
        IsoGridSquare.defColorInfo.a = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DoCutawayShader(IsoObject isoObject, IsoDirections isoDirections, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, WallShaperWhole wallShaperWhole) {
        Texture texture = Texture.getSharedTexture("media/wallcutaways.png");
        if (texture == null || texture.getID() == -1) {
            return;
        }
        boolean bl8 = isoObject.sprite.getProperties().Is(IsoFlagType.NoWallLighting);
        int n = IsoCamera.frameState.playerIndex;
        ColorInfo colorInfo = this.lightInfo[n];
        int n2 = 2 / Core.TileScale;
        try {
            int n3;
            int n4;
            int n5;
            int n6;
            Object object;
            Texture texture2 = isoObject.getCurrentFrameTex();
            float f = 0.0f;
            float f2 = isoObject.getCurrentFrameTex().getOffsetY();
            int n7 = 0;
            int n8 = 226 - texture2.getHeight() * n2;
            if (isoDirections != IsoDirections.NW) {
                n7 = 66 - texture2.getWidth() * n2;
            }
            if (isoObject.sprite.getProperties().Is(IsoFlagType.WallSE)) {
                n7 = 6 - texture2.getWidth() * n2;
                n8 = 196 - texture2.getHeight() * n2;
            }
            if (isoObject.sprite.name.contains("fencing_01_11")) {
                f = 1.0f;
            } else if (isoObject.sprite.name.contains("carpentry_02_80")) {
                f = 1.0f;
            } else if (isoObject.sprite.name.contains("spiffos_01_71")) {
                f = -24.0f;
            } else if (isoObject.sprite.name.contains("location_community_medical")) {
                object = isoObject.sprite.name.replaceAll("(.*)_", "");
                n6 = Integer.parseInt((String)object);
                switch (n6) {
                    case 45: 
                    case 46: 
                    case 47: 
                    case 147: 
                    case 148: 
                    case 149: {
                        f = -3.0f;
                    }
                }
            } else if (isoObject.sprite.name.contains("walls_exterior_roofs")) {
                object = isoObject.sprite.name.replaceAll("(.*)_", "");
                n6 = Integer.parseInt((String)object);
                if (n6 == 4) {
                    f = -60.0f;
                } else if (n6 == 17) {
                    f = -46.0f;
                } else if (n6 == 28 && !isoObject.sprite.name.contains("03")) {
                    f = -60.0f;
                } else if (n6 == 41) {
                    f = -46.0f;
                }
            }
            object = CircleStencilShader.instance;
            if (isoDirections == IsoDirections.N || isoDirections == IsoDirections.NW) {
                n6 = 700;
                n5 = 1084;
                if (bl2) {
                    n5 = 1212;
                    if (!bl3) {
                        n6 = 444;
                    }
                } else {
                    n6 = !bl3 ? 828 : 956;
                }
                n4 = 0;
                if (bl4) {
                    n4 = 904;
                    if (isoObject.sprite.name.contains("garage") || isoObject.sprite.name.contains("industry_trucks")) {
                        n3 = isoObject.sprite.tileSheetIndex;
                        if (n3 % 8 == 5) {
                            n4 = 1356;
                        } else if (n3 % 8 == 4) {
                            n4 = 1582;
                        } else if (n3 % 8 == 3) {
                            n4 = 1130;
                        }
                    }
                    if (isoObject.sprite.name.contains("community_church")) {
                        n3 = isoObject.sprite.tileSheetIndex;
                        if (n3 == 19) {
                            n4 = 1356;
                        } else if (n3 == 18) {
                            n4 = 1130;
                        }
                    }
                } else if (bl6) {
                    n4 = 226;
                    if (isoObject.sprite.name.contains("trailer")) {
                        n3 = isoObject.sprite.tileSheetIndex;
                        if (n3 == 14 || n3 == 38) {
                            n4 = 678;
                        } else if (n3 == 15 || n3 == 39) {
                            n4 = 452;
                        }
                    }
                    if (isoObject.sprite.name.contains("sunstarmotel")) {
                        n3 = isoObject.sprite.tileSheetIndex;
                        if (n3 == 22 || n3 == 18) {
                            n4 = 678;
                        } else if (n3 == 23 || n3 == 19) {
                            n4 = 452;
                        }
                    }
                }
                colu = this.getVertLight(0, n);
                coll = this.getVertLight(1, n);
                colu2 = this.getVertLight(4, n);
                coll2 = this.getVertLight(5, n);
                if (Core.bDebug && DebugOptions.instance.DebugDraw_SkipWorldShading.getValue()) {
                    coll2 = -1;
                    colu2 = -1;
                    coll = -1;
                    colu = -1;
                    colorInfo = defColorInfo;
                }
                if (isoObject.sprite.getProperties().Is(IsoFlagType.WallSE)) {
                    SpriteRenderer.instance.setCutawayTexture(texture, n5 + (int)f, n4 + (int)f2, 6 - n7, 196 - n8);
                } else {
                    SpriteRenderer.instance.setCutawayTexture(texture, n6 + (int)f, n4 + (int)f2, 66 - n7, 226 - n8);
                }
                if (isoDirections == IsoDirections.N) {
                    SpriteRenderer.instance.setExtraWallShaderParams(SpriteRenderer.WallShaderTexRender.All);
                } else {
                    SpriteRenderer.instance.setExtraWallShaderParams(SpriteRenderer.WallShaderTexRender.RightOnly);
                }
                wallShaperWhole.col[0] = colu2;
                wallShaperWhole.col[1] = coll2;
                wallShaperWhole.col[2] = coll;
                wallShaperWhole.col[3] = colu;
                isoObject.renderWallTileOnly(this.x, this.y, this.z, bl8 ? colorInfo : defColorInfo, (Shader)object, wallShaperWhole);
            }
            if (isoDirections == IsoDirections.W || isoDirections == IsoDirections.NW) {
                n6 = 512;
                n5 = 1084;
                if (bl) {
                    if (!bl2) {
                        n6 = 768;
                        n5 = 1212;
                    }
                } else if (!bl2) {
                    n6 = 896;
                    n5 = 1212;
                } else {
                    n6 = 256;
                }
                n4 = 0;
                if (bl5) {
                    n4 = 904;
                    if (isoObject.sprite.name.contains("garage") || isoObject.sprite.name.contains("industry_trucks")) {
                        n3 = isoObject.sprite.tileSheetIndex;
                        if (n3 % 8 == 0) {
                            n4 = 1356;
                        } else if (n3 % 8 == 1) {
                            n4 = 1582;
                        } else if (n3 % 8 == 2) {
                            n4 = 1130;
                        }
                    }
                    if (isoObject.sprite.name.contains("community_church")) {
                        n3 = isoObject.sprite.tileSheetIndex;
                        if (n3 == 16) {
                            n4 = 1356;
                        } else if (n3 == 17) {
                            n4 = 1130;
                        }
                    }
                } else if (bl7) {
                    n4 = 226;
                    if (isoObject.sprite.name.contains("trailer")) {
                        n3 = isoObject.sprite.tileSheetIndex;
                        if (n3 == 13 || n3 == 37) {
                            n4 = 678;
                        } else if (n3 == 12 || n3 == 36) {
                            n4 = 452;
                        }
                    }
                    if (isoObject.sprite.name.contains("sunstarmotel")) {
                        n3 = isoObject.sprite.tileSheetIndex;
                        if (n3 == 17) {
                            n4 = 678;
                        } else if (n3 == 16) {
                            n4 = 452;
                        }
                    }
                }
                colu = this.getVertLight(0, n);
                coll = this.getVertLight(3, n);
                colu2 = this.getVertLight(4, n);
                coll2 = this.getVertLight(7, n);
                if (Core.bDebug && DebugOptions.instance.DebugDraw_SkipWorldShading.getValue()) {
                    coll2 = -1;
                    colu2 = -1;
                    coll = -1;
                    colu = -1;
                    colorInfo = defColorInfo;
                }
                if (isoObject.sprite.getProperties().Is(IsoFlagType.WallSE)) {
                    SpriteRenderer.instance.setCutawayTexture(texture, n5 + (int)f, n4 + (int)f2, 6 - n7, 196 - n8);
                } else {
                    SpriteRenderer.instance.setCutawayTexture(texture, n6 + (int)f, n4 + (int)f2, 66 - n7, 226 - n8);
                }
                if (isoDirections == IsoDirections.W) {
                    SpriteRenderer.instance.setExtraWallShaderParams(SpriteRenderer.WallShaderTexRender.All);
                } else {
                    SpriteRenderer.instance.setExtraWallShaderParams(SpriteRenderer.WallShaderTexRender.LeftOnly);
                }
                wallShaperWhole.col[0] = coll2;
                wallShaperWhole.col[1] = colu2;
                wallShaperWhole.col[2] = colu;
                wallShaperWhole.col[3] = coll;
                isoObject.renderWallTileOnly(this.x, this.y, this.z, bl8 ? colorInfo : defColorInfo, (Shader)object, wallShaperWhole);
            }
        }
        finally {
            SpriteRenderer.instance.setExtraWallShaderParams(null);
            SpriteRenderer.instance.clearCutawayTexture();
            SpriteRenderer.instance.clearUseVertColorsArray();
        }
        isoObject.renderAttachedAndOverlaySprites(this.x, this.y, this.z, bl8 ? colorInfo : defColorInfo, false, !bl8, null, wallShaperWhole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DoCutawayShaderSprite(IsoSprite isoSprite2, IsoDirections isoDirections2, boolean bl, boolean bl2, boolean bl3) {
        CircleStencilShader circleStencilShader = CircleStencilShader.instance;
        WallShaperWhole wallShaperWhole2 = WallShaperWhole.instance;
        int n = IsoCamera.frameState.playerIndex;
        Texture texture = Texture.getSharedTexture("media/wallcutaways.png");
        if (texture == null || texture.getID() == -1) {
            return;
        }
        int n2 = 2 / Core.TileScale;
        try {
            int n3;
            Texture texture2 = isoSprite2.CurrentAnim.Frames.get((int)isoSprite2.def.Frame).getTexture(isoDirections2);
            float f = 0.0f;
            float f2 = texture2.getOffsetY();
            int n4 = 0;
            int n5 = 226 - texture2.getHeight() * n2;
            if (isoDirections2 != IsoDirections.NW) {
                n4 = 66 - texture2.getWidth() * n2;
            }
            if (isoSprite2.getProperties().Is(IsoFlagType.WallSE)) {
                n4 = 6 - texture2.getWidth() * n2;
                n5 = 196 - texture2.getHeight() * n2;
            }
            if (isoSprite2.name.contains("fencing_01_11")) {
                f = 1.0f;
            } else if (isoSprite2.name.contains("carpentry_02_80")) {
                f = 1.0f;
            } else if (isoSprite2.name.contains("spiffos_01_71")) {
                f = -24.0f;
            } else if (isoSprite2.name.contains("location_community_medical")) {
                var16_16 = isoSprite2.name.replaceAll("(.*)_", "");
                n3 = Integer.parseInt(var16_16);
                switch (n3) {
                    case 45: 
                    case 46: 
                    case 47: 
                    case 147: 
                    case 148: 
                    case 149: {
                        f = -3.0f;
                    }
                }
            } else if (isoSprite2.name.contains("walls_exterior_roofs")) {
                var16_16 = isoSprite2.name.replaceAll("(.*)_", "");
                n3 = Integer.parseInt(var16_16);
                if (n3 == 4) {
                    f = -60.0f;
                } else if (n3 == 17) {
                    f = -46.0f;
                } else if (n3 == 28 && !isoSprite2.name.contains("03")) {
                    f = -60.0f;
                } else if (n3 == 41) {
                    f = -46.0f;
                }
            }
            if (isoDirections2 == IsoDirections.N || isoDirections2 == IsoDirections.NW) {
                int n6 = 700;
                n3 = 1084;
                if (bl2) {
                    n3 = 1212;
                    if (!bl3) {
                        n6 = 444;
                    }
                } else {
                    n6 = !bl3 ? 828 : 956;
                }
                colu = this.getVertLight(0, n);
                coll = this.getVertLight(1, n);
                colu2 = this.getVertLight(4, n);
                coll2 = this.getVertLight(5, n);
                if (isoSprite2.getProperties().Is(IsoFlagType.WallSE)) {
                    SpriteRenderer.instance.setCutawayTexture(texture, n3 + (int)f, 0 + (int)f2, 6 - n4, 196 - n5);
                } else {
                    SpriteRenderer.instance.setCutawayTexture(texture, n6 + (int)f, 0 + (int)f2, 66 - n4, 226 - n5);
                }
                if (isoDirections2 == IsoDirections.N) {
                    SpriteRenderer.instance.setExtraWallShaderParams(SpriteRenderer.WallShaderTexRender.All);
                } else {
                    SpriteRenderer.instance.setExtraWallShaderParams(SpriteRenderer.WallShaderTexRender.RightOnly);
                }
                wallShaperWhole2.col[0] = colu2;
                wallShaperWhole2.col[1] = coll2;
                wallShaperWhole2.col[2] = coll;
                wallShaperWhole2.col[3] = colu;
                IndieGL.bindShader(circleStencilShader, isoSprite2, isoDirections2, wallShaperWhole2, (isoSprite, isoDirections, wallShaperWhole) -> isoSprite.render(null, this.x, (float)this.y, (float)this.z, (IsoDirections)((Object)((Object)isoDirections)), WeatherFxMask.offsetX, WeatherFxMask.offsetY, defColorInfo, false, (Consumer<TextureDraw>)wallShaperWhole));
            }
            if (isoDirections2 == IsoDirections.W || isoDirections2 == IsoDirections.NW) {
                int n7 = 512;
                n3 = 1084;
                if (bl) {
                    if (!bl2) {
                        n7 = 768;
                        n3 = 1212;
                    }
                } else if (!bl2) {
                    n7 = 896;
                    n3 = 1212;
                } else {
                    n7 = 256;
                }
                colu = this.getVertLight(0, n);
                coll = this.getVertLight(3, n);
                colu2 = this.getVertLight(4, n);
                coll2 = this.getVertLight(7, n);
                if (isoSprite2.getProperties().Is(IsoFlagType.WallSE)) {
                    SpriteRenderer.instance.setCutawayTexture(texture, n3 + (int)f, 0 + (int)f2, 6 - n4, 196 - n5);
                } else {
                    SpriteRenderer.instance.setCutawayTexture(texture, n7 + (int)f, 0 + (int)f2, 66 - n4, 226 - n5);
                }
                if (isoDirections2 == IsoDirections.W) {
                    SpriteRenderer.instance.setExtraWallShaderParams(SpriteRenderer.WallShaderTexRender.All);
                } else {
                    SpriteRenderer.instance.setExtraWallShaderParams(SpriteRenderer.WallShaderTexRender.LeftOnly);
                }
                wallShaperWhole2.col[0] = coll2;
                wallShaperWhole2.col[1] = colu2;
                wallShaperWhole2.col[2] = colu;
                wallShaperWhole2.col[3] = coll;
                IndieGL.bindShader(circleStencilShader, isoSprite2, isoDirections2, wallShaperWhole2, (isoSprite, isoDirections, wallShaperWhole) -> isoSprite.render(null, this.x, (float)this.y, (float)this.z, (IsoDirections)((Object)((Object)isoDirections)), WeatherFxMask.offsetX, WeatherFxMask.offsetY, defColorInfo, false, (Consumer<TextureDraw>)wallShaperWhole));
            }
        }
        finally {
            SpriteRenderer.instance.setExtraWallShaderParams(null);
            SpriteRenderer.instance.clearCutawayTexture();
            SpriteRenderer.instance.clearUseVertColorsArray();
        }
    }

    public int DoWallLightingNW(IsoObject isoObject, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Shader shader) {
        if (!DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.NW.getValue()) {
            return n;
        }
        boolean bl8 = bl || bl2 || bl3;
        IsoDirections isoDirections = IsoDirections.NW;
        int n2 = IsoCamera.frameState.playerIndex;
        colu = this.getVertLight(0, n2);
        coll = this.getVertLight(3, n2);
        colr = this.getVertLight(1, n2);
        colu2 = this.getVertLight(4, n2);
        coll2 = this.getVertLight(7, n2);
        colr2 = this.getVertLight(5, n2);
        if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.LightingDebug.getValue()) {
            colu = -65536;
            coll = -16711936;
            colr = -16711681;
            colu2 = -16776961;
            coll2 = -65281;
            colr2 = -256;
        }
        boolean bl9 = CircleStencil;
        if (this.z != (int)IsoCamera.CamCharacter.z) {
            bl9 = false;
        }
        boolean bl10 = isoObject.sprite.getType() == IsoObjectType.doorFrN || isoObject.sprite.getType() == IsoObjectType.doorN;
        boolean bl11 = isoObject.sprite.getType() == IsoObjectType.doorFrW || isoObject.sprite.getType() == IsoObjectType.doorW;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = (bl10 || bl12 || bl11 || bl12) && bl8 || isoObject.sprite.getProperties().Is(IsoFlagType.NoWallLighting);
        bl9 = this.calculateWallAlphaAndCircleStencilCorner(isoObject, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl9, n2, bl10, bl11, bl12, bl13);
        if (USE_WALL_SHADER && bl9 && bl8) {
            this.DoCutawayShader(isoObject, isoDirections, bl, bl2, bl3, bl4, bl5, bl6, bl7, WallShaperWhole.instance);
            bWallCutawayN = true;
            bWallCutawayW = true;
            return n;
        }
        WallShaperWhole.instance.col[0] = colu2;
        WallShaperWhole.instance.col[1] = colr2;
        WallShaperWhole.instance.col[2] = colr;
        WallShaperWhole.instance.col[3] = colu;
        WallShaperN wallShaperN = WallShaperN.instance;
        wallShaperN.col[0] = colu2;
        wallShaperN.col[1] = colr2;
        wallShaperN.col[2] = colr;
        wallShaperN.col[3] = colu;
        n = this.performDrawWall(isoObject, n, n2, bl14, wallShaperN, shader);
        WallShaperWhole.instance.col[0] = coll2;
        WallShaperWhole.instance.col[1] = colu2;
        WallShaperWhole.instance.col[2] = colu;
        WallShaperWhole.instance.col[3] = coll;
        WallShaperW wallShaperW = WallShaperW.instance;
        wallShaperW.col[0] = coll2;
        wallShaperW.col[1] = colu2;
        wallShaperW.col[2] = colu;
        wallShaperW.col[3] = coll;
        n = this.performDrawWall(isoObject, n, n2, bl14, wallShaperW, shader);
        return n;
    }

    public int DoWallLightingN(IsoObject isoObject, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, Shader shader) {
        if (!DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.N.getValue()) {
            return n;
        }
        boolean bl5 = !bl3;
        boolean bl6 = !bl4;
        IsoObjectType isoObjectType = IsoObjectType.doorFrN;
        IsoObjectType isoObjectType2 = IsoObjectType.doorN;
        boolean bl7 = bl || bl2;
        IsoFlagType isoFlagType = IsoFlagType.transparentN;
        IsoFlagType isoFlagType2 = IsoFlagType.WindowN;
        IsoFlagType isoFlagType3 = IsoFlagType.HoppableN;
        IsoDirections isoDirections = IsoDirections.N;
        boolean bl8 = CircleStencil;
        int n2 = IsoCamera.frameState.playerIndex;
        colu = this.getVertLight(0, n2);
        coll = this.getVertLight(1, n2);
        colu2 = this.getVertLight(4, n2);
        coll2 = this.getVertLight(5, n2);
        if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.LightingDebug.getValue()) {
            colu = -65536;
            coll = -16711936;
            colu2 = -16776961;
            coll2 = -65281;
        }
        WallShaperWhole wallShaperWhole = WallShaperWhole.instance;
        wallShaperWhole.col[0] = colu2;
        wallShaperWhole.col[1] = coll2;
        wallShaperWhole.col[2] = coll;
        wallShaperWhole.col[3] = colu;
        return this.performDrawWallSegmentSingle(isoObject, n, false, bl, false, false, bl2, bl3, bl4, bl5, bl6, isoObjectType, isoObjectType2, bl7, isoFlagType, isoFlagType2, isoFlagType3, isoDirections, bl8, wallShaperWhole, shader);
    }

    public int DoWallLightingW(IsoObject isoObject, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, Shader shader) {
        if (!DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.W.getValue()) {
            return n;
        }
        boolean bl5 = !bl3;
        boolean bl6 = !bl4;
        IsoObjectType isoObjectType = IsoObjectType.doorFrW;
        IsoObjectType isoObjectType2 = IsoObjectType.doorW;
        boolean bl7 = bl || bl2;
        IsoFlagType isoFlagType = IsoFlagType.transparentW;
        IsoFlagType isoFlagType2 = IsoFlagType.WindowW;
        IsoFlagType isoFlagType3 = IsoFlagType.HoppableW;
        IsoDirections isoDirections = IsoDirections.W;
        boolean bl8 = CircleStencil;
        int n2 = IsoCamera.frameState.playerIndex;
        colu = this.getVertLight(0, n2);
        coll = this.getVertLight(3, n2);
        colu2 = this.getVertLight(4, n2);
        coll2 = this.getVertLight(7, n2);
        if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.LightingDebug.getValue()) {
            colu = -65536;
            coll = -16711936;
            colu2 = -16776961;
            coll2 = -65281;
        }
        WallShaperWhole wallShaperWhole = WallShaperWhole.instance;
        wallShaperWhole.col[0] = coll2;
        wallShaperWhole.col[1] = colu2;
        wallShaperWhole.col[2] = colu;
        wallShaperWhole.col[3] = coll;
        return this.performDrawWallSegmentSingle(isoObject, n, bl, bl2, bl3, bl4, false, false, false, bl5, bl6, isoObjectType, isoObjectType2, bl7, isoFlagType, isoFlagType2, isoFlagType3, isoDirections, bl8, wallShaperWhole, shader);
    }

    private int performDrawWallSegmentSingle(IsoObject isoObject, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, IsoObjectType isoObjectType, IsoObjectType isoObjectType2, boolean bl10, IsoFlagType isoFlagType, IsoFlagType isoFlagType2, IsoFlagType isoFlagType3, IsoDirections isoDirections, boolean bl11, WallShaperWhole wallShaperWhole, Shader shader) {
        int n2 = IsoCamera.frameState.playerIndex;
        if (this.z != (int)IsoCamera.CamCharacter.z) {
            bl11 = false;
        }
        boolean bl12 = isoObject.sprite.getType() == isoObjectType || isoObject.sprite.getType() == isoObjectType2;
        boolean bl13 = isoObject instanceof IsoWindow;
        boolean bl14 = (bl12 || bl13) && bl10 || isoObject.sprite.getProperties().Is(IsoFlagType.NoWallLighting);
        bl11 = this.calculateWallAlphaAndCircleStencilEdge(isoObject, bl8, bl9, bl10, isoFlagType, isoFlagType2, isoFlagType3, bl11, n2, bl12, bl13);
        if (USE_WALL_SHADER && bl11 && bl10) {
            this.DoCutawayShader(isoObject, isoDirections, bl, bl2, bl5, bl6, bl3, bl7, bl4, wallShaperWhole);
            bWallCutawayN |= isoDirections == IsoDirections.N;
            bWallCutawayW |= isoDirections == IsoDirections.W;
            return n;
        }
        return this.performDrawWall(isoObject, n, n2, bl14, wallShaperWhole, shader);
    }

    private int performDrawWallOnly(IsoObject isoObject, int n, int n2, boolean bl, Consumer<TextureDraw> consumer, Shader shader) {
        if (n == 0 && !bl) {
            n = this.getCell().getStencilValue(this.x, this.y, this.z);
        }
        IndieGL.enableAlphaTest();
        IndieGL.glAlphaFunc(516, 0.0f);
        IndieGL.glStencilFunc(519, n, 127);
        if (!bl) {
            IndieGL.glStencilOp(7680, 7680, 7681);
        }
        if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.Render.getValue()) {
            isoObject.renderWallTile(this.x, this.y, this.z, bl ? lightInfoTemp : defColorInfo, true, !bl, shader, consumer);
        }
        isoObject.setAlpha(n2, 1.0f);
        if (bl) {
            IndieGL.glStencilFunc(519, 1, 255);
            IndieGL.glStencilOp(7680, 7680, 7680);
            return n;
        }
        this.getCell().setStencilValue(this.x, this.y, this.z, n);
        return n + 1;
    }

    private int performDrawWall(IsoObject isoObject, int n, int n2, boolean bl, Consumer<TextureDraw> consumer, Shader shader) {
        lightInfoTemp.set(this.lightInfo[n2]);
        if (Core.bDebug && DebugOptions.instance.DebugDraw_SkipWorldShading.getValue()) {
            isoObject.render(this.x, this.y, this.z, defColorInfo, true, !bl, null);
            return n;
        }
        int n3 = this.performDrawWallOnly(isoObject, n, n2, bl, consumer, shader);
        if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Walls.AttachedSprites.getValue()) {
            this.renderAttachedSpritesWithNoWallLighting(isoObject, lightInfoTemp);
        }
        return n3;
    }

    private void calculateWallAlphaCommon(IsoObject isoObject, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, boolean bl5) {
        if (!bl4 && !bl5) {
            return;
        }
        if (bl) {
            isoObject.setAlpha(n, 0.4f);
            isoObject.setTargetAlpha(n, 0.4f);
            IsoGridSquare.lightInfoTemp.r = Math.max(0.3f, IsoGridSquare.lightInfoTemp.r);
            IsoGridSquare.lightInfoTemp.g = Math.max(0.3f, IsoGridSquare.lightInfoTemp.g);
            IsoGridSquare.lightInfoTemp.b = Math.max(0.3f, IsoGridSquare.lightInfoTemp.b);
            if (bl4 && !bl2) {
                isoObject.setAlpha(n, 0.0f);
                isoObject.setTargetAlpha(n, 0.0f);
            }
            if (bl5 && !bl3) {
                isoObject.setAlpha(n, 0.0f);
                isoObject.setTargetAlpha(n, 0.0f);
            }
        }
    }

    private boolean calculateWallAlphaAndCircleStencilEdge(IsoObject isoObject, boolean bl, boolean bl2, boolean bl3, IsoFlagType isoFlagType, IsoFlagType isoFlagType2, IsoFlagType isoFlagType3, boolean bl4, int n, boolean bl5, boolean bl6) {
        if (bl5 || bl6) {
            if (!isoObject.sprite.getProperties().Is("GarageDoor")) {
                bl4 = false;
            }
            this.calculateWallAlphaCommon(isoObject, bl3, !bl, !bl2, n, bl5, bl6);
        }
        if (bl4 && isoObject.sprite.getType() == IsoObjectType.wall && isoObject.sprite.getProperties().Is(isoFlagType) && !isoObject.getSprite().getProperties().Is(IsoFlagType.exterior) && !isoObject.sprite.getProperties().Is(isoFlagType2)) {
            bl4 = false;
        }
        return bl4;
    }

    private boolean calculateWallAlphaAndCircleStencilCorner(IsoObject isoObject, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, boolean bl12) {
        this.calculateWallAlphaCommon(isoObject, bl2 || bl3, bl4, bl6, n, bl9, bl11);
        this.calculateWallAlphaCommon(isoObject, bl2 || bl, bl5, bl7, n, bl10, bl12);
        boolean bl13 = bl8 = bl8 && !bl9 && !bl11;
        if (bl8 && isoObject.sprite.getType() == IsoObjectType.wall && (isoObject.sprite.getProperties().Is(IsoFlagType.transparentN) || isoObject.sprite.getProperties().Is(IsoFlagType.transparentW)) && !isoObject.getSprite().getProperties().Is(IsoFlagType.exterior) && !isoObject.sprite.getProperties().Is(IsoFlagType.WindowN) && !isoObject.sprite.getProperties().Is(IsoFlagType.WindowW)) {
            bl8 = false;
        }
        return bl8;
    }

    public KahluaTable getLuaMovingObjectList() {
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        LuaManager.env.rawset((Object)"Objects", (Object)kahluaTable);
        for (int i = 0; i < this.MovingObjects.size(); ++i) {
            kahluaTable.rawset(i + 1, (Object)this.MovingObjects.get(i));
        }
        return kahluaTable;
    }

    public boolean Is(IsoFlagType isoFlagType) {
        return this.Properties.Is(isoFlagType);
    }

    public boolean Is(String string) {
        return this.Properties.Is(string);
    }

    public boolean Has(IsoObjectType isoObjectType) {
        return this.hasTypes.isSet(isoObjectType);
    }

    public void DeleteTileObject(IsoObject isoObject) {
        this.Objects.remove(isoObject);
        this.RecalcAllWithNeighbours(true);
    }

    public KahluaTable getLuaTileObjectList() {
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        LuaManager.env.rawset((Object)"Objects", (Object)kahluaTable);
        for (int i = 0; i < this.Objects.size(); ++i) {
            kahluaTable.rawset(i + 1, (Object)this.Objects.get(i));
        }
        return kahluaTable;
    }

    boolean HasDoor(boolean bl) {
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            if (this.SpecialObjects.get(i) instanceof IsoDoor && ((IsoDoor)this.SpecialObjects.get((int)i)).north == bl) {
                return true;
            }
            if (!(this.SpecialObjects.get(i) instanceof IsoThumpable) || !((IsoThumpable)this.SpecialObjects.get((int)i)).isDoor.booleanValue() || ((IsoThumpable)this.SpecialObjects.get((int)i)).north != bl) continue;
            return true;
        }
        return false;
    }

    public boolean HasStairs() {
        return this.HasStairsNorth() || this.HasStairsWest();
    }

    public boolean HasStairsNorth() {
        return this.Has(IsoObjectType.stairsTN) || this.Has(IsoObjectType.stairsMN) || this.Has(IsoObjectType.stairsBN);
    }

    public boolean HasStairsWest() {
        return this.Has(IsoObjectType.stairsTW) || this.Has(IsoObjectType.stairsMW) || this.Has(IsoObjectType.stairsBW);
    }

    public boolean HasStairsBelow() {
        if (this.z == 0) {
            return false;
        }
        IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.x, this.y, this.z - 1);
        return isoGridSquare != null && isoGridSquare.HasStairs();
    }

    public boolean HasElevatedFloor() {
        return this.Has(IsoObjectType.stairsTN) || this.Has(IsoObjectType.stairsMN) || this.Has(IsoObjectType.stairsTW) || this.Has(IsoObjectType.stairsMW);
    }

    public boolean isSameStaircase(int n, int n2, int n3) {
        if (n3 != this.getZ()) {
            return false;
        }
        int n4 = this.getX();
        int n5 = this.getY();
        int n6 = n4--;
        int n7 = n5--;
        if (this.Has(IsoObjectType.stairsTN)) {
            n7 += 2;
        } else if (this.Has(IsoObjectType.stairsMN)) {
            ++n7;
        } else if (this.Has(IsoObjectType.stairsBN)) {
            n5 -= 2;
        } else if (this.Has(IsoObjectType.stairsTW)) {
            n6 += 2;
        } else if (this.Has(IsoObjectType.stairsMW)) {
            ++n6;
        } else if (this.Has(IsoObjectType.stairsBW)) {
            n4 -= 2;
        } else {
            return false;
        }
        if (n < n4 || n2 < n5 || n > n6 || n2 > n7) {
            return false;
        }
        IsoGridSquare isoGridSquare = this.getCell().getGridSquare(n, n2, n3);
        return isoGridSquare != null && isoGridSquare.HasStairs();
    }

    public boolean HasSlopedRoof() {
        return this.HasSlopedRoofWest() || this.HasSlopedRoofNorth();
    }

    public boolean HasSlopedRoofWest() {
        return this.Has(IsoObjectType.WestRoofB) || this.Has(IsoObjectType.WestRoofM) || this.Has(IsoObjectType.WestRoofT);
    }

    public boolean HasSlopedRoofNorth() {
        return this.Has(IsoObjectType.WestRoofB) || this.Has(IsoObjectType.WestRoofM) || this.Has(IsoObjectType.WestRoofT);
    }

    public boolean HasTree() {
        return this.hasTree;
    }

    public IsoTree getTree() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoTree isoTree = Type.tryCastTo(this.Objects.get(i), IsoTree.class);
            if (isoTree == null) continue;
            return isoTree;
        }
        return null;
    }

    private void fudgeShadowsToAlpha(IsoObject isoObject, Color color) {
        float f = 1.0f - isoObject.getAlpha();
        if (color.r < f) {
            color.r = f;
        }
        if (color.g < f) {
            color.g = f;
        }
        if (color.b < f) {
            color.b = f;
        }
    }

    public boolean shouldSave() {
        return !this.Objects.isEmpty();
    }

    public void save(ByteBuffer byteBuffer, ObjectOutputStream objectOutputStream) throws IOException {
        this.save(byteBuffer, objectOutputStream, false);
    }

    public void save(ByteBuffer byteBuffer, ObjectOutputStream objectOutputStream, boolean bl) throws IOException {
        int n;
        int n2;
        this.getErosionData().save(byteBuffer);
        BitHeaderWrite bitHeaderWrite = BitHeader.allocWrite(BitHeader.HeaderSize.Byte, byteBuffer);
        int n3 = this.Objects.size();
        if (this.Objects.size() > 0) {
            bitHeaderWrite.addFlags(1);
            if (n3 == 2) {
                bitHeaderWrite.addFlags(2);
            } else if (n3 == 3) {
                bitHeaderWrite.addFlags(4);
            } else if (n3 >= 4) {
                bitHeaderWrite.addFlags(8);
            }
            if (bl) {
                GameWindow.WriteString(byteBuffer, "Number of objects (" + n3 + ")");
            }
            if (n3 >= 4) {
                byteBuffer.putShort((short)this.Objects.size());
            }
            for (int i = 0; i < this.Objects.size(); ++i) {
                n2 = byteBuffer.position();
                if (bl) {
                    byteBuffer.putInt(0);
                }
                n = 0;
                if (this.SpecialObjects.contains(this.Objects.get(i))) {
                    n = (byte)(n | 2);
                }
                if (this.WorldObjects.contains(this.Objects.get(i))) {
                    n = (byte)(n | 4);
                }
                byteBuffer.put((byte)n);
                if (bl) {
                    GameWindow.WriteStringUTF(byteBuffer, this.Objects.get(i).getClass().getName());
                }
                this.Objects.get(i).save(byteBuffer, bl);
                if (!bl) continue;
                int n4 = byteBuffer.position();
                byteBuffer.position(n2);
                byteBuffer.putInt(n4 - n2);
                byteBuffer.position(n4);
            }
            if (bl) {
                byteBuffer.put((byte)67);
                byteBuffer.put((byte)82);
                byteBuffer.put((byte)80);
                byteBuffer.put((byte)83);
            }
        }
        if (this.isOverlayDone()) {
            bitHeaderWrite.addFlags(16);
        }
        if (this.haveRoof) {
            bitHeaderWrite.addFlags(32);
        }
        BitHeaderWrite bitHeaderWrite2 = BitHeader.allocWrite(BitHeader.HeaderSize.Byte, byteBuffer);
        n2 = 0;
        for (n = 0; n < this.StaticMovingObjects.size(); ++n) {
            if (!(this.StaticMovingObjects.get(n) instanceof IsoDeadBody)) continue;
            ++n2;
        }
        if (n2 > 0) {
            bitHeaderWrite2.addFlags(1);
            if (bl) {
                GameWindow.WriteString(byteBuffer, "Number of bodies");
            }
            byteBuffer.putShort((short)n2);
            for (n = 0; n < this.StaticMovingObjects.size(); ++n) {
                IsoMovingObject isoMovingObject = this.StaticMovingObjects.get(n);
                if (!(isoMovingObject instanceof IsoDeadBody)) continue;
                if (bl) {
                    GameWindow.WriteStringUTF(byteBuffer, isoMovingObject.getClass().getName());
                }
                isoMovingObject.save(byteBuffer, bl);
            }
        }
        if (this.table != null && !this.table.isEmpty()) {
            bitHeaderWrite2.addFlags(2);
            this.table.save(byteBuffer);
        }
        if (this.burntOut) {
            bitHeaderWrite2.addFlags(4);
        }
        if (this.getTrapPositionX() > 0) {
            bitHeaderWrite2.addFlags(8);
            byteBuffer.putInt(this.getTrapPositionX());
            byteBuffer.putInt(this.getTrapPositionY());
            byteBuffer.putInt(this.getTrapPositionZ());
        }
        if (this.haveSheetRope) {
            bitHeaderWrite2.addFlags(16);
        }
        if (!bitHeaderWrite2.equals(0)) {
            bitHeaderWrite.addFlags(64);
            bitHeaderWrite2.write();
        } else {
            byteBuffer.position(bitHeaderWrite2.getStartPosition());
        }
        bitHeaderWrite.write();
        bitHeaderWrite.release();
        bitHeaderWrite2.release();
    }

    static void loadmatrix(boolean[][][] blArray, DataInputStream dataInputStream) throws IOException {
    }

    static void savematrix(boolean[][][] blArray, DataOutputStream dataOutputStream) throws IOException {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    dataOutputStream.writeBoolean(blArray[i][j][k]);
                }
            }
        }
    }

    public boolean isCommonGrass() {
        if (this.Objects.isEmpty()) {
            return false;
        }
        IsoObject isoObject = this.Objects.get(0);
        return isoObject.sprite.getProperties().Is(IsoFlagType.solidfloor) && ("TileFloorExt_3".equals(isoObject.tile) || "TileFloorExt_4".equals(isoObject.tile));
    }

    public static boolean toBoolean(byte[] byArray) {
        return byArray == null || byArray.length == 0 ? false : byArray[0] != 0;
    }

    public void removeCorpse(IsoDeadBody isoDeadBody, boolean bl) {
        if (GameClient.bClient && !bl) {
            try {
                GameClient.instance.checkAddedRemovedItems(isoDeadBody);
            }
            catch (Exception exception) {
                GameClient.connection.cancelPacket();
                ExceptionLogger.logException(exception);
            }
            GameClient.sendRemoveCorpseFromMap(isoDeadBody);
        }
        isoDeadBody.removeFromWorld();
        isoDeadBody.removeFromSquare();
        if (!GameServer.bServer) {
            LuaEventManager.triggerEvent("OnContainerUpdate", this);
        }
    }

    public IsoDeadBody getDeadBody() {
        for (int i = 0; i < this.StaticMovingObjects.size(); ++i) {
            if (!(this.StaticMovingObjects.get(i) instanceof IsoDeadBody)) continue;
            return (IsoDeadBody)this.StaticMovingObjects.get(i);
        }
        return null;
    }

    public List<IsoDeadBody> getDeadBodys() {
        ArrayList<IsoDeadBody> arrayList = new ArrayList<IsoDeadBody>();
        for (int i = 0; i < this.StaticMovingObjects.size(); ++i) {
            if (!(this.StaticMovingObjects.get(i) instanceof IsoDeadBody)) continue;
            arrayList.add((IsoDeadBody)this.StaticMovingObjects.get(i));
        }
        return arrayList;
    }

    public void addCorpse(IsoDeadBody isoDeadBody, boolean bl) {
        if (GameClient.bClient && !bl) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.AddCorpseToMap.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(isoDeadBody.getObjectID());
            byteBufferWriter.putShort(isoDeadBody.getOnlineID());
            byteBufferWriter.putInt(this.x);
            byteBufferWriter.putInt(this.y);
            byteBufferWriter.putInt(this.z);
            isoDeadBody.writeToRemoteBuffer(byteBufferWriter);
            PacketTypes.PacketType.AddCorpseToMap.send(GameClient.connection);
        }
        if (!this.StaticMovingObjects.contains(isoDeadBody)) {
            this.StaticMovingObjects.add(isoDeadBody);
        }
        isoDeadBody.addToWorld();
        this.burntOut = false;
        this.Properties.UnSet(IsoFlagType.burntOut);
    }

    public IsoBrokenGlass getBrokenGlass() {
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoObject isoObject = this.SpecialObjects.get(i);
            if (!(isoObject instanceof IsoBrokenGlass)) continue;
            return (IsoBrokenGlass)isoObject;
        }
        return null;
    }

    public IsoBrokenGlass addBrokenGlass() {
        if (!this.isFree(false)) {
            return this.getBrokenGlass();
        }
        IsoBrokenGlass isoBrokenGlass = this.getBrokenGlass();
        if (isoBrokenGlass == null) {
            isoBrokenGlass = new IsoBrokenGlass(this.getCell());
            isoBrokenGlass.setSquare(this);
            this.AddSpecialObject(isoBrokenGlass);
            if (GameServer.bServer) {
                GameServer.transmitBrokenGlass(this);
            }
        }
        return isoBrokenGlass;
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        this.load(byteBuffer, n, false);
    }

    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        this.getErosionData().load(byteBuffer, n);
        BitHeaderRead bitHeaderRead = BitHeader.allocRead(BitHeader.HeaderSize.Byte, byteBuffer);
        if (!bitHeaderRead.equals(0)) {
            int n2;
            if (bitHeaderRead.hasFlags(1)) {
                byte by;
                int n3;
                int n4;
                if (bl) {
                    String string = GameWindow.ReadStringUTF(byteBuffer);
                    DebugLog.log(string);
                }
                int n5 = 1;
                if (bitHeaderRead.hasFlags(2)) {
                    n5 = 2;
                } else if (bitHeaderRead.hasFlags(4)) {
                    n5 = 3;
                } else if (bitHeaderRead.hasFlags(8)) {
                    n5 = byteBuffer.getShort();
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    int n6;
                    n2 = byteBuffer.position();
                    n3 = 0;
                    if (bl) {
                        n3 = byteBuffer.getInt();
                    }
                    boolean bl2 = ((by = byteBuffer.get()) & 2) != 0;
                    boolean bl3 = (by & 4) != 0;
                    IsoObject isoObject = null;
                    if (bl) {
                        String string = GameWindow.ReadStringUTF(byteBuffer);
                        DebugLog.log(string);
                    }
                    if ((isoObject = IsoObject.factoryFromFileInput(this.getCell(), byteBuffer)) == null) {
                        int n7;
                        if (!bl || (n7 = byteBuffer.position()) - n2 == n3) continue;
                        DebugLog.log("***** Object loaded size " + (n7 - n2) + " != saved size " + n3 + ", reading obj size: " + n5 + ", Object == null");
                        if (isoObject.getSprite() == null || isoObject.getSprite().getName() == null) continue;
                        DebugLog.log("Obj sprite = " + isoObject.getSprite().getName());
                        continue;
                    }
                    isoObject.square = this;
                    try {
                        isoObject.load(byteBuffer, n, bl);
                    }
                    catch (Exception exception) {
                        this.debugPrintGridSquare();
                        if (lastLoaded != null) {
                            lastLoaded.debugPrintGridSquare();
                        }
                        throw new RuntimeException(exception);
                    }
                    if (bl && (n6 = byteBuffer.position()) - n2 != n3) {
                        DebugLog.log("***** Object loaded size " + (n6 - n2) + " != saved size " + n3 + ", reading obj size: " + n5);
                        if (isoObject.getSprite() != null && isoObject.getSprite().getName() != null) {
                            DebugLog.log("Obj sprite = " + isoObject.getSprite().getName());
                        }
                    }
                    if (isoObject instanceof IsoWorldInventoryObject) {
                        String string;
                        Item item;
                        if (((IsoWorldInventoryObject)isoObject).getItem() == null || (item = ScriptManager.instance.FindItem(string = ((IsoWorldInventoryObject)isoObject).getItem().getFullType())) != null && item.getObsolete()) continue;
                        String[] stringArray = string.split("_");
                        if (((IsoWorldInventoryObject)isoObject).dropTime > -1.0 && SandboxOptions.instance.HoursForWorldItemRemoval.getValue() > 0.0 && (SandboxOptions.instance.WorldItemRemovalList.getValue().contains(stringArray[0]) && !SandboxOptions.instance.ItemRemovalListBlacklistToggle.getValue() || !SandboxOptions.instance.WorldItemRemovalList.getValue().contains(stringArray[0]) && SandboxOptions.instance.ItemRemovalListBlacklistToggle.getValue()) && !((IsoWorldInventoryObject)isoObject).isIgnoreRemoveSandbox() && GameTime.instance.getWorldAgeHours() > ((IsoWorldInventoryObject)isoObject).dropTime + SandboxOptions.instance.HoursForWorldItemRemoval.getValue()) continue;
                    }
                    if (isoObject instanceof IsoWindow && isoObject.getSprite() != null && ("walls_special_01_8".equals(isoObject.getSprite().getName()) || "walls_special_01_9".equals(isoObject.getSprite().getName()))) continue;
                    this.Objects.add(isoObject);
                    if (bl2) {
                        this.SpecialObjects.add(isoObject);
                    }
                    if (!bl3) continue;
                    if (Core.bDebug && !(isoObject instanceof IsoWorldInventoryObject)) {
                        DebugLog.log("Bitflags = " + by + ", obj name = " + isoObject.getObjectName() + ", sprite = " + (isoObject.getSprite() != null ? isoObject.getSprite().getName() : "unknown"));
                    }
                    this.WorldObjects.add((IsoWorldInventoryObject)isoObject);
                    isoObject.square.chunk.recalcHashCodeObjects();
                }
                if (bl) {
                    n4 = byteBuffer.get();
                    n2 = byteBuffer.get();
                    n3 = byteBuffer.get();
                    by = byteBuffer.get();
                    if (n4 != 67 || n2 != 82 || n3 != 80 || by != 83) {
                        DebugLog.log("***** Expected CRPS here");
                    }
                }
            }
            this.setOverlayDone(bitHeaderRead.hasFlags(16));
            this.haveRoof = bitHeaderRead.hasFlags(32);
            if (bitHeaderRead.hasFlags(64)) {
                BitHeaderRead bitHeaderRead2 = BitHeader.allocRead(BitHeader.HeaderSize.Byte, byteBuffer);
                if (bitHeaderRead2.hasFlags(1)) {
                    if (bl) {
                        String string = GameWindow.ReadStringUTF(byteBuffer);
                        DebugLog.log(string);
                    }
                    int n8 = byteBuffer.getShort();
                    for (n2 = 0; n2 < n8; ++n2) {
                        IsoMovingObject isoMovingObject = null;
                        if (bl) {
                            String string = GameWindow.ReadStringUTF(byteBuffer);
                            DebugLog.log(string);
                        }
                        try {
                            isoMovingObject = (IsoMovingObject)IsoObject.factoryFromFileInput(this.getCell(), byteBuffer);
                        }
                        catch (Exception exception) {
                            this.debugPrintGridSquare();
                            if (lastLoaded != null) {
                                lastLoaded.debugPrintGridSquare();
                            }
                            throw new RuntimeException(exception);
                        }
                        if (isoMovingObject == null) continue;
                        isoMovingObject.square = this;
                        isoMovingObject.current = this;
                        try {
                            isoMovingObject.load(byteBuffer, n, bl);
                        }
                        catch (Exception exception) {
                            this.debugPrintGridSquare();
                            if (lastLoaded != null) {
                                lastLoaded.debugPrintGridSquare();
                            }
                            throw new RuntimeException(exception);
                        }
                        this.StaticMovingObjects.add(isoMovingObject);
                        this.recalcHashCodeObjects();
                    }
                }
                if (bitHeaderRead2.hasFlags(2)) {
                    if (this.table == null) {
                        this.table = LuaManager.platform.newTable();
                    }
                    this.table.load(byteBuffer, n);
                }
                this.burntOut = bitHeaderRead2.hasFlags(4);
                if (bitHeaderRead2.hasFlags(8)) {
                    this.setTrapPositionX(byteBuffer.getInt());
                    this.setTrapPositionY(byteBuffer.getInt());
                    this.setTrapPositionZ(byteBuffer.getInt());
                }
                this.haveSheetRope = bitHeaderRead2.hasFlags(16);
                bitHeaderRead2.release();
            }
        }
        bitHeaderRead.release();
        lastLoaded = this;
    }

    private void debugPrintGridSquare() {
        int n;
        System.out.println("x=" + this.x + " y=" + this.y + " z=" + this.z);
        System.out.println("objects");
        for (n = 0; n < this.Objects.size(); ++n) {
            this.Objects.get(n).debugPrintout();
        }
        System.out.println("staticmovingobjects");
        for (n = 0; n < this.StaticMovingObjects.size(); ++n) {
            this.Objects.get(n).debugPrintout();
        }
    }

    public float scoreAsWaypoint(int n, int n2) {
        float f = 2.0f;
        return f -= IsoUtils.DistanceManhatten(n, n2, this.getX(), this.getY()) * 5.0f;
    }

    public void InvalidateSpecialObjectPaths() {
    }

    public boolean isSolid() {
        return this.Properties.Is(IsoFlagType.solid);
    }

    public boolean isSolidTrans() {
        return this.Properties.Is(IsoFlagType.solidtrans);
    }

    public boolean isFree(boolean bl) {
        if (bl && this.MovingObjects.size() > 0) {
            return false;
        }
        if (this.CachedIsFree) {
            return this.CacheIsFree;
        }
        this.CachedIsFree = true;
        this.CacheIsFree = true;
        if (this.Properties.Is(IsoFlagType.solid) || this.Properties.Is(IsoFlagType.solidtrans) || this.Has(IsoObjectType.tree)) {
            this.CacheIsFree = false;
        }
        if (!this.Properties.Is(IsoFlagType.solidfloor)) {
            this.CacheIsFree = false;
        }
        if (this.Has(IsoObjectType.stairsBN) || this.Has(IsoObjectType.stairsMN) || this.Has(IsoObjectType.stairsTN)) {
            this.CacheIsFree = true;
        } else if (this.Has(IsoObjectType.stairsBW) || this.Has(IsoObjectType.stairsMW) || this.Has(IsoObjectType.stairsTW)) {
            this.CacheIsFree = true;
        }
        return this.CacheIsFree;
    }

    public boolean isFreeOrMidair(boolean bl) {
        if (bl && this.MovingObjects.size() > 0) {
            return false;
        }
        boolean bl2 = true;
        if (this.Properties.Is(IsoFlagType.solid) || this.Properties.Is(IsoFlagType.solidtrans) || this.Has(IsoObjectType.tree)) {
            bl2 = false;
        }
        if (this.Has(IsoObjectType.stairsBN) || this.Has(IsoObjectType.stairsMN) || this.Has(IsoObjectType.stairsTN)) {
            bl2 = true;
        } else if (this.Has(IsoObjectType.stairsBW) || this.Has(IsoObjectType.stairsMW) || this.Has(IsoObjectType.stairsTW)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean isFreeOrMidair(boolean bl, boolean bl2) {
        int n;
        if (bl && this.MovingObjects.size() > 0) {
            if (bl2) {
                for (n = 0; n < this.MovingObjects.size(); ++n) {
                    IsoMovingObject isoMovingObject = this.MovingObjects.get(n);
                    if (isoMovingObject instanceof IsoDeadBody) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        n = 1;
        if (this.Properties.Is(IsoFlagType.solid) || this.Properties.Is(IsoFlagType.solidtrans) || this.Has(IsoObjectType.tree)) {
            n = 0;
        }
        if (this.Has(IsoObjectType.stairsBN) || this.Has(IsoObjectType.stairsMN) || this.Has(IsoObjectType.stairsTN)) {
            n = 1;
        } else if (this.Has(IsoObjectType.stairsBW) || this.Has(IsoObjectType.stairsMW) || this.Has(IsoObjectType.stairsTW)) {
            n = 1;
        }
        return n != 0;
    }

    public boolean connectedWithFloor() {
        if (this.getZ() == 0) {
            return true;
        }
        IsoGridSquare isoGridSquare = null;
        isoGridSquare = this.getCell().getGridSquare(this.getX() - 1, this.getY(), this.getZ());
        if (isoGridSquare != null && isoGridSquare.Properties.Is(IsoFlagType.solidfloor)) {
            return true;
        }
        isoGridSquare = this.getCell().getGridSquare(this.getX() + 1, this.getY(), this.getZ());
        if (isoGridSquare != null && isoGridSquare.Properties.Is(IsoFlagType.solidfloor)) {
            return true;
        }
        isoGridSquare = this.getCell().getGridSquare(this.getX(), this.getY() - 1, this.getZ());
        if (isoGridSquare != null && isoGridSquare.Properties.Is(IsoFlagType.solidfloor)) {
            return true;
        }
        isoGridSquare = this.getCell().getGridSquare(this.getX(), this.getY() + 1, this.getZ());
        return isoGridSquare != null && isoGridSquare.Properties.Is(IsoFlagType.solidfloor);
    }

    public boolean hasFloor(boolean bl) {
        if (this.Properties.Is(IsoFlagType.solidfloor)) {
            return true;
        }
        IsoGridSquare isoGridSquare = null;
        isoGridSquare = bl ? this.getCell().getGridSquare(this.getX(), this.getY() - 1, this.getZ()) : this.getCell().getGridSquare(this.getX() - 1, this.getY(), this.getZ());
        return isoGridSquare != null && isoGridSquare.Properties.Is(IsoFlagType.solidfloor);
    }

    public boolean isNotBlocked(boolean bl) {
        if (!this.CachedIsFree) {
            this.CacheIsFree = true;
            this.CachedIsFree = true;
            if (this.Properties.Is(IsoFlagType.solid) || this.Properties.Is(IsoFlagType.solidtrans)) {
                this.CacheIsFree = false;
            }
            if (!this.Properties.Is(IsoFlagType.solidfloor)) {
                this.CacheIsFree = false;
            }
        } else if (!this.CacheIsFree) {
            return false;
        }
        return !bl || this.MovingObjects.size() <= 0;
    }

    public IsoObject getDoor(boolean bl) {
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoObject isoObject;
            IsoObject isoObject2 = this.SpecialObjects.get(i);
            if (isoObject2 instanceof IsoThumpable && (isoObject = (IsoThumpable)isoObject2).isDoor() && bl == isoObject.north) {
                return isoObject;
            }
            if (!(isoObject2 instanceof IsoDoor)) continue;
            isoObject = (IsoDoor)isoObject2;
            if (bl != ((IsoDoor)isoObject).north) continue;
            return isoObject;
        }
        return null;
    }

    public IsoDoor getIsoDoor() {
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoObject isoObject = this.SpecialObjects.get(i);
            if (!(isoObject instanceof IsoDoor)) continue;
            return (IsoDoor)isoObject;
        }
        return null;
    }

    public IsoObject getDoorTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return null;
        }
        IsoObject isoObject = null;
        if (isoGridSquare.x < this.x && (isoObject = this.getDoor(false)) != null) {
            return isoObject;
        }
        if (isoGridSquare.y < this.y && (isoObject = this.getDoor(true)) != null) {
            return isoObject;
        }
        if (isoGridSquare.x > this.x && (isoObject = isoGridSquare.getDoor(false)) != null) {
            return isoObject;
        }
        if (isoGridSquare.y > this.y && (isoObject = isoGridSquare.getDoor(true)) != null) {
            return isoObject;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            IsoGridSquare isoGridSquare2 = this.getCell().getGridSquare(this.x, isoGridSquare.y, this.z);
            IsoGridSquare isoGridSquare3 = this.getCell().getGridSquare(isoGridSquare.x, this.y, this.z);
            isoObject = this.getDoorTo(isoGridSquare2);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = this.getDoorTo(isoGridSquare3);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = isoGridSquare.getDoorTo(isoGridSquare2);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = isoGridSquare.getDoorTo(isoGridSquare3);
            if (isoObject != null) {
                return isoObject;
            }
        }
        return null;
    }

    public IsoWindow getWindow(boolean bl) {
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoObject isoObject = this.SpecialObjects.get(i);
            if (!(isoObject instanceof IsoWindow)) continue;
            IsoWindow isoWindow = (IsoWindow)isoObject;
            if (bl != isoWindow.north) continue;
            return isoWindow;
        }
        return null;
    }

    public IsoWindow getWindow() {
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoObject isoObject = this.SpecialObjects.get(i);
            if (!(isoObject instanceof IsoWindow)) continue;
            return (IsoWindow)isoObject;
        }
        return null;
    }

    public IsoWindow getWindowTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return null;
        }
        IsoWindow isoWindow = null;
        if (isoGridSquare.x < this.x && (isoWindow = this.getWindow(false)) != null) {
            return isoWindow;
        }
        if (isoGridSquare.y < this.y && (isoWindow = this.getWindow(true)) != null) {
            return isoWindow;
        }
        if (isoGridSquare.x > this.x && (isoWindow = isoGridSquare.getWindow(false)) != null) {
            return isoWindow;
        }
        if (isoGridSquare.y > this.y && (isoWindow = isoGridSquare.getWindow(true)) != null) {
            return isoWindow;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            IsoGridSquare isoGridSquare2 = this.getCell().getGridSquare(this.x, isoGridSquare.y, this.z);
            IsoGridSquare isoGridSquare3 = this.getCell().getGridSquare(isoGridSquare.x, this.y, this.z);
            isoWindow = this.getWindowTo(isoGridSquare2);
            if (isoWindow != null) {
                return isoWindow;
            }
            isoWindow = this.getWindowTo(isoGridSquare3);
            if (isoWindow != null) {
                return isoWindow;
            }
            isoWindow = isoGridSquare.getWindowTo(isoGridSquare2);
            if (isoWindow != null) {
                return isoWindow;
            }
            isoWindow = isoGridSquare.getWindowTo(isoGridSquare3);
            if (isoWindow != null) {
                return isoWindow;
            }
        }
        return null;
    }

    public boolean isAdjacentToWindow() {
        if (this.getWindow() != null) {
            return true;
        }
        if (this.hasWindowFrame()) {
            return true;
        }
        if (this.getThumpableWindow(false) != null || this.getThumpableWindow(true) != null) {
            return true;
        }
        IsoGridSquare isoGridSquare = this.nav[IsoDirections.S.index()];
        if (isoGridSquare != null && (isoGridSquare.getWindow(true) != null || isoGridSquare.getWindowFrame(true) != null || isoGridSquare.getThumpableWindow(true) != null)) {
            return true;
        }
        IsoGridSquare isoGridSquare2 = this.nav[IsoDirections.E.index()];
        return isoGridSquare2 != null && (isoGridSquare2.getWindow(false) != null || isoGridSquare2.getWindowFrame(false) != null || isoGridSquare2.getThumpableWindow(false) != null);
    }

    public IsoThumpable getThumpableWindow(boolean bl) {
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoThumpable isoThumpable;
            IsoObject isoObject = this.SpecialObjects.get(i);
            if (!(isoObject instanceof IsoThumpable) || !(isoThumpable = (IsoThumpable)isoObject).isWindow() || bl != isoThumpable.north) continue;
            return isoThumpable;
        }
        return null;
    }

    public IsoThumpable getWindowThumpableTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return null;
        }
        IsoThumpable isoThumpable = null;
        if (isoGridSquare.x < this.x && (isoThumpable = this.getThumpableWindow(false)) != null) {
            return isoThumpable;
        }
        if (isoGridSquare.y < this.y && (isoThumpable = this.getThumpableWindow(true)) != null) {
            return isoThumpable;
        }
        if (isoGridSquare.x > this.x && (isoThumpable = isoGridSquare.getThumpableWindow(false)) != null) {
            return isoThumpable;
        }
        if (isoGridSquare.y > this.y && (isoThumpable = isoGridSquare.getThumpableWindow(true)) != null) {
            return isoThumpable;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            IsoGridSquare isoGridSquare2 = this.getCell().getGridSquare(this.x, isoGridSquare.y, this.z);
            IsoGridSquare isoGridSquare3 = this.getCell().getGridSquare(isoGridSquare.x, this.y, this.z);
            isoThumpable = this.getWindowThumpableTo(isoGridSquare2);
            if (isoThumpable != null) {
                return isoThumpable;
            }
            isoThumpable = this.getWindowThumpableTo(isoGridSquare3);
            if (isoThumpable != null) {
                return isoThumpable;
            }
            isoThumpable = isoGridSquare.getWindowThumpableTo(isoGridSquare2);
            if (isoThumpable != null) {
                return isoThumpable;
            }
            isoThumpable = isoGridSquare.getWindowThumpableTo(isoGridSquare3);
            if (isoThumpable != null) {
                return isoThumpable;
            }
        }
        return null;
    }

    public IsoThumpable getHoppableThumpable(boolean bl) {
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoThumpable isoThumpable;
            IsoObject isoObject = this.SpecialObjects.get(i);
            if (!(isoObject instanceof IsoThumpable) || !(isoThumpable = (IsoThumpable)isoObject).isHoppable() || bl != isoThumpable.north) continue;
            return isoThumpable;
        }
        return null;
    }

    public IsoThumpable getHoppableThumpableTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return null;
        }
        IsoThumpable isoThumpable = null;
        if (isoGridSquare.x < this.x && (isoThumpable = this.getHoppableThumpable(false)) != null) {
            return isoThumpable;
        }
        if (isoGridSquare.y < this.y && (isoThumpable = this.getHoppableThumpable(true)) != null) {
            return isoThumpable;
        }
        if (isoGridSquare.x > this.x && (isoThumpable = isoGridSquare.getHoppableThumpable(false)) != null) {
            return isoThumpable;
        }
        if (isoGridSquare.y > this.y && (isoThumpable = isoGridSquare.getHoppableThumpable(true)) != null) {
            return isoThumpable;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            IsoGridSquare isoGridSquare2 = this.getCell().getGridSquare(this.x, isoGridSquare.y, this.z);
            IsoGridSquare isoGridSquare3 = this.getCell().getGridSquare(isoGridSquare.x, this.y, this.z);
            isoThumpable = this.getHoppableThumpableTo(isoGridSquare2);
            if (isoThumpable != null) {
                return isoThumpable;
            }
            isoThumpable = this.getHoppableThumpableTo(isoGridSquare3);
            if (isoThumpable != null) {
                return isoThumpable;
            }
            isoThumpable = isoGridSquare.getHoppableThumpableTo(isoGridSquare2);
            if (isoThumpable != null) {
                return isoThumpable;
            }
            isoThumpable = isoGridSquare.getHoppableThumpableTo(isoGridSquare3);
            if (isoThumpable != null) {
                return isoThumpable;
            }
        }
        return null;
    }

    public IsoObject getWallHoppable(boolean bl) {
        for (int i = 0; i < this.Objects.size(); ++i) {
            if (!this.Objects.get(i).isHoppable() || bl != this.Objects.get(i).isNorthHoppable()) continue;
            return this.Objects.get(i);
        }
        return null;
    }

    public IsoObject getWallHoppableTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return null;
        }
        IsoObject isoObject = null;
        if (isoGridSquare.x < this.x && (isoObject = this.getWallHoppable(false)) != null) {
            return isoObject;
        }
        if (isoGridSquare.y < this.y && (isoObject = this.getWallHoppable(true)) != null) {
            return isoObject;
        }
        if (isoGridSquare.x > this.x && (isoObject = isoGridSquare.getWallHoppable(false)) != null) {
            return isoObject;
        }
        if (isoGridSquare.y > this.y && (isoObject = isoGridSquare.getWallHoppable(true)) != null) {
            return isoObject;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            IsoGridSquare isoGridSquare2 = this.getCell().getGridSquare(this.x, isoGridSquare.y, this.z);
            IsoGridSquare isoGridSquare3 = this.getCell().getGridSquare(isoGridSquare.x, this.y, this.z);
            isoObject = this.getWallHoppableTo(isoGridSquare2);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = this.getWallHoppableTo(isoGridSquare3);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = isoGridSquare.getWallHoppableTo(isoGridSquare2);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = isoGridSquare.getWallHoppableTo(isoGridSquare3);
            if (isoObject != null) {
                return isoObject;
            }
        }
        return null;
    }

    public IsoObject getBedTo(IsoGridSquare isoGridSquare) {
        ArrayList<IsoObject> arrayList = null;
        arrayList = isoGridSquare.y < this.y || isoGridSquare.x < this.x ? this.SpecialObjects : isoGridSquare.SpecialObjects;
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoObject isoObject = arrayList.get(i);
            if (!isoObject.getProperties().Is(IsoFlagType.bed)) continue;
            return isoObject;
        }
        return null;
    }

    public IsoObject getWindowFrame(boolean bl) {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject instanceof IsoWorldInventoryObject || !IsoWindowFrame.isWindowFrame(isoObject, bl)) continue;
            return isoObject;
        }
        return null;
    }

    public IsoObject getWindowFrameTo(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return null;
        }
        IsoObject isoObject = null;
        if (isoGridSquare.x < this.x && (isoObject = this.getWindowFrame(false)) != null) {
            return isoObject;
        }
        if (isoGridSquare.y < this.y && (isoObject = this.getWindowFrame(true)) != null) {
            return isoObject;
        }
        if (isoGridSquare.x > this.x && (isoObject = isoGridSquare.getWindowFrame(false)) != null) {
            return isoObject;
        }
        if (isoGridSquare.y > this.y && (isoObject = isoGridSquare.getWindowFrame(true)) != null) {
            return isoObject;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y) {
            IsoGridSquare isoGridSquare2 = this.getCell().getGridSquare(this.x, isoGridSquare.y, this.z);
            IsoGridSquare isoGridSquare3 = this.getCell().getGridSquare(isoGridSquare.x, this.y, this.z);
            isoObject = this.getWindowFrameTo(isoGridSquare2);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = this.getWindowFrameTo(isoGridSquare3);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = isoGridSquare.getWindowFrameTo(isoGridSquare2);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = isoGridSquare.getWindowFrameTo(isoGridSquare3);
            if (isoObject != null) {
                return isoObject;
            }
        }
        return null;
    }

    public boolean hasWindowFrame() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject instanceof IsoWorldInventoryObject || !IsoWindowFrame.isWindowFrame(isoObject)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWindowOrWindowFrame() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject instanceof IsoWorldInventoryObject || !this.isWindowOrWindowFrame(isoObject, true) && !this.isWindowOrWindowFrame(isoObject, false)) continue;
            return true;
        }
        return false;
    }

    private IsoObject getSpecialWall(boolean bl) {
        for (int i = this.SpecialObjects.size() - 1; i >= 0; --i) {
            IsoObject isoObject;
            IsoObject isoObject2 = this.SpecialObjects.get(i);
            if (isoObject2 instanceof IsoThumpable) {
                isoObject = (IsoThumpable)isoObject2;
                if (((IsoThumpable)isoObject).isStairs() || !((IsoThumpable)isoObject).isThumpable() && !((IsoThumpable)isoObject).isWindow() && !((IsoThumpable)isoObject).isDoor() || ((IsoThumpable)isoObject).isDoor() && ((IsoThumpable)isoObject).open || ((IsoThumpable)isoObject).isBlockAllTheSquare()) continue;
                if (bl == ((IsoThumpable)isoObject).north && !((IsoThumpable)isoObject).isCorner()) {
                    return isoObject;
                }
            }
            if (isoObject2 instanceof IsoWindow) {
                isoObject = (IsoWindow)isoObject2;
                if (bl == ((IsoWindow)isoObject).north) {
                    return isoObject;
                }
            }
            if (!(isoObject2 instanceof IsoDoor)) continue;
            isoObject = (IsoDoor)isoObject2;
            if (bl != ((IsoDoor)isoObject).north || ((IsoDoor)isoObject).open) continue;
            return isoObject;
        }
        if (bl && !this.Is(IsoFlagType.WindowN) || !bl && !this.Is(IsoFlagType.WindowW)) {
            return null;
        }
        IsoObject isoObject = this.getWindowFrame(bl);
        if (isoObject != null) {
            return isoObject;
        }
        return null;
    }

    public IsoObject getSheetRope() {
        for (int i = 0; i < this.getObjects().size(); ++i) {
            IsoObject isoObject = this.getObjects().get(i);
            if (!isoObject.sheetRope) continue;
            return isoObject;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean damageSpriteSheetRopeFromBottom(IsoPlayer isoPlayer, boolean bl) {
        IsoFlagType isoFlagType;
        IsoGridSquare isoGridSquare = this;
        if (bl) {
            if (this.Is(IsoFlagType.climbSheetN)) {
                isoFlagType = IsoFlagType.climbSheetN;
            } else {
                if (!this.Is(IsoFlagType.climbSheetS)) return false;
                isoFlagType = IsoFlagType.climbSheetS;
            }
        } else if (this.Is(IsoFlagType.climbSheetW)) {
            isoFlagType = IsoFlagType.climbSheetW;
        } else {
            if (!this.Is(IsoFlagType.climbSheetE)) return false;
            isoFlagType = IsoFlagType.climbSheetE;
        }
        while (isoGridSquare != null) {
            for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
                IsoObject isoObject = isoGridSquare.getObjects().get(i);
                if (isoObject.getProperties() == null || !isoObject.getProperties().Is(isoFlagType)) continue;
                int n = Integer.parseInt(isoObject.getSprite().getName().split("_")[2]);
                if (n > 14) {
                    return false;
                }
                String string = isoObject.getSprite().getName().split("_")[0] + "_" + isoObject.getSprite().getName().split("_")[1];
                isoObject.setSprite(IsoSpriteManager.instance.getSprite(string + "_" + (n += 40)));
                isoObject.transmitUpdatedSprite();
                break;
            }
            if (isoGridSquare.getZ() == 7) return true;
            isoGridSquare = isoGridSquare.getCell().getGridSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ() + 1);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeSheetRopeFromBottom(IsoPlayer isoPlayer, boolean bl) {
        IsoGridSquare isoGridSquare;
        Object object;
        int n;
        IsoFlagType isoFlagType;
        IsoFlagType isoFlagType2;
        IsoGridSquare isoGridSquare2 = this;
        if (bl) {
            if (this.Is(IsoFlagType.climbSheetN)) {
                isoFlagType2 = IsoFlagType.climbSheetTopN;
                isoFlagType = IsoFlagType.climbSheetN;
            } else {
                if (!this.Is(IsoFlagType.climbSheetS)) return false;
                isoFlagType2 = IsoFlagType.climbSheetTopS;
                isoFlagType = IsoFlagType.climbSheetS;
                var5_6 = "crafted_01_4";
                for (n = 0; n < isoGridSquare2.getObjects().size(); ++n) {
                    object = isoGridSquare2.getObjects().get(n);
                    if (((IsoObject)object).sprite == null || ((IsoObject)object).sprite.getName() == null || !((IsoObject)object).sprite.getName().equals(var5_6)) continue;
                    isoGridSquare2.transmitRemoveItemFromSquare((IsoObject)object);
                    break;
                }
            }
        } else if (this.Is(IsoFlagType.climbSheetW)) {
            isoFlagType2 = IsoFlagType.climbSheetTopW;
            isoFlagType = IsoFlagType.climbSheetW;
        } else {
            if (!this.Is(IsoFlagType.climbSheetE)) return false;
            isoFlagType2 = IsoFlagType.climbSheetTopE;
            isoFlagType = IsoFlagType.climbSheetE;
            var5_6 = "crafted_01_3";
            for (n = 0; n < isoGridSquare2.getObjects().size(); ++n) {
                object = isoGridSquare2.getObjects().get(n);
                if (((IsoObject)object).sprite == null || ((IsoObject)object).sprite.getName() == null || !((IsoObject)object).sprite.getName().equals(var5_6)) continue;
                isoGridSquare2.transmitRemoveItemFromSquare((IsoObject)object);
                break;
            }
        }
        n = 0;
        object = null;
        while (isoGridSquare2 != null) {
            for (int i = 0; i < isoGridSquare2.getObjects().size(); ++i) {
                IsoObject isoObject = isoGridSquare2.getObjects().get(i);
                if (isoObject.getProperties() == null || !isoObject.getProperties().Is(isoFlagType2) && !isoObject.getProperties().Is(isoFlagType)) continue;
                object = isoGridSquare2;
                n = 1;
                isoGridSquare2.transmitRemoveItemFromSquare(isoObject);
                if (GameServer.bServer) {
                    if (isoPlayer == null) break;
                    isoPlayer.sendObjectChange("addItemOfType", "type", isoObject.getName());
                    break;
                }
                if (isoPlayer == null) break;
                isoPlayer.getInventory().AddItem(isoObject.getName());
                break;
            }
            if (isoGridSquare2.getZ() == 7) break;
            isoGridSquare2 = isoGridSquare2.getCell().getGridSquare(isoGridSquare2.getX(), isoGridSquare2.getY(), isoGridSquare2.getZ() + 1);
            n = 0;
        }
        if (n != 0) return true;
        isoGridSquare2 = ((IsoGridSquare)object).getCell().getGridSquare(((IsoGridSquare)object).getX(), ((IsoGridSquare)object).getY(), ((IsoGridSquare)object).getZ());
        IsoGridSquare isoGridSquare3 = isoGridSquare = bl ? isoGridSquare2.nav[IsoDirections.S.index()] : isoGridSquare2.nav[IsoDirections.E.index()];
        if (isoGridSquare == null) {
            return true;
        }
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (isoObject.getProperties() == null || !isoObject.getProperties().Is(isoFlagType2) && !isoObject.getProperties().Is(isoFlagType)) continue;
            isoGridSquare.transmitRemoveItemFromSquare(isoObject);
            return true;
        }
        return true;
    }

    private IsoObject getSpecialSolid() {
        IsoObject isoObject;
        int n;
        for (n = 0; n < this.SpecialObjects.size(); ++n) {
            IsoThumpable isoThumpable;
            isoObject = this.SpecialObjects.get(n);
            if (!(isoObject instanceof IsoThumpable) || (isoThumpable = (IsoThumpable)isoObject).isStairs() || !isoThumpable.isThumpable() || !isoThumpable.isBlockAllTheSquare()) continue;
            if (isoThumpable.getProperties().Is(IsoFlagType.solidtrans) && this.isAdjacentToWindow()) {
                return null;
            }
            return isoThumpable;
        }
        for (n = 0; n < this.Objects.size(); ++n) {
            isoObject = this.Objects.get(n);
            if (!isoObject.isMovedThumpable()) continue;
            if (this.isAdjacentToWindow()) {
                return null;
            }
            return isoObject;
        }
        return null;
    }

    public IsoObject testCollideSpecialObjects(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return null;
        }
        if (isoGridSquare.x < this.x && isoGridSquare.y == this.y) {
            if (isoGridSquare.z == this.z && this.Has(IsoObjectType.stairsTW)) {
                return null;
            }
            IsoObject isoObject = this.getSpecialWall(false);
            if (isoObject != null) {
                return isoObject;
            }
            if (this.isBlockedTo(isoGridSquare)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialSolid();
            if (isoObject != null) {
                return isoObject;
            }
            return null;
        }
        if (isoGridSquare.x == this.x && isoGridSquare.y < this.y) {
            if (isoGridSquare.z == this.z && this.Has(IsoObjectType.stairsTN)) {
                return null;
            }
            IsoObject isoObject = this.getSpecialWall(true);
            if (isoObject != null) {
                return isoObject;
            }
            if (this.isBlockedTo(isoGridSquare)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialSolid();
            if (isoObject != null) {
                return isoObject;
            }
            return null;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.y == this.y) {
            IsoObject isoObject = isoGridSquare.getSpecialWall(false);
            if (isoObject != null) {
                return isoObject;
            }
            if (this.isBlockedTo(isoGridSquare)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialSolid();
            if (isoObject != null) {
                return isoObject;
            }
            return null;
        }
        if (isoGridSquare.x == this.x && isoGridSquare.y > this.y) {
            IsoObject isoObject = isoGridSquare.getSpecialWall(true);
            if (isoObject != null) {
                return isoObject;
            }
            if (this.isBlockedTo(isoGridSquare)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialSolid();
            if (isoObject != null) {
                return isoObject;
            }
            return null;
        }
        if (isoGridSquare.x < this.x && isoGridSquare.y < this.y) {
            IsoGridSquare isoGridSquare2;
            IsoObject isoObject = this.getSpecialWall(true);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = this.getSpecialWall(false);
            if (isoObject != null) {
                return isoObject;
            }
            IsoGridSquare isoGridSquare3 = this.getCell().getGridSquare(this.x, this.y - 1, this.z);
            if (isoGridSquare3 != null && !this.isBlockedTo(isoGridSquare3)) {
                isoObject = isoGridSquare3.getSpecialSolid();
                if (isoObject != null) {
                    return isoObject;
                }
                isoObject = isoGridSquare3.getSpecialWall(false);
                if (isoObject != null) {
                    return isoObject;
                }
            }
            if ((isoGridSquare2 = this.getCell().getGridSquare(this.x - 1, this.y, this.z)) != null && !this.isBlockedTo(isoGridSquare2)) {
                isoObject = isoGridSquare2.getSpecialSolid();
                if (isoObject != null) {
                    return isoObject;
                }
                isoObject = isoGridSquare2.getSpecialWall(true);
                if (isoObject != null) {
                    return isoObject;
                }
            }
            if (isoGridSquare3 == null || this.isBlockedTo(isoGridSquare3) || isoGridSquare2 == null || this.isBlockedTo(isoGridSquare2)) {
                return null;
            }
            if (isoGridSquare3.isBlockedTo(isoGridSquare) || isoGridSquare2.isBlockedTo(isoGridSquare)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialSolid();
            if (isoObject != null) {
                return isoObject;
            }
            return null;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.y < this.y) {
            IsoObject isoObject = this.getSpecialWall(true);
            if (isoObject != null) {
                return isoObject;
            }
            IsoGridSquare isoGridSquare4 = this.getCell().getGridSquare(this.x, this.y - 1, this.z);
            if (isoGridSquare4 != null && !this.isBlockedTo(isoGridSquare4) && (isoObject = isoGridSquare4.getSpecialSolid()) != null) {
                return isoObject;
            }
            IsoGridSquare isoGridSquare5 = this.getCell().getGridSquare(this.x + 1, this.y, this.z);
            if (isoGridSquare5 != null) {
                isoObject = isoGridSquare5.getSpecialWall(false);
                if (isoObject != null) {
                    return isoObject;
                }
                if (!this.isBlockedTo(isoGridSquare5)) {
                    isoObject = isoGridSquare5.getSpecialSolid();
                    if (isoObject != null) {
                        return isoObject;
                    }
                    isoObject = isoGridSquare5.getSpecialWall(true);
                    if (isoObject != null) {
                        return isoObject;
                    }
                }
            }
            if (isoGridSquare4 == null || this.isBlockedTo(isoGridSquare4) || isoGridSquare5 == null || this.isBlockedTo(isoGridSquare5)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialWall(false);
            if (isoObject != null) {
                return isoObject;
            }
            if (isoGridSquare4.isBlockedTo(isoGridSquare) || isoGridSquare5.isBlockedTo(isoGridSquare)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialSolid();
            if (isoObject != null) {
                return isoObject;
            }
            return null;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.y > this.y) {
            IsoGridSquare isoGridSquare6;
            IsoObject isoObject;
            IsoGridSquare isoGridSquare7 = this.getCell().getGridSquare(this.x, this.y + 1, this.z);
            if (isoGridSquare7 != null) {
                isoObject = isoGridSquare7.getSpecialWall(true);
                if (isoObject != null) {
                    return isoObject;
                }
                if (!this.isBlockedTo(isoGridSquare7) && (isoObject = isoGridSquare7.getSpecialSolid()) != null) {
                    return isoObject;
                }
            }
            if ((isoGridSquare6 = this.getCell().getGridSquare(this.x + 1, this.y, this.z)) != null) {
                isoObject = isoGridSquare6.getSpecialWall(false);
                if (isoObject != null) {
                    return isoObject;
                }
                if (!this.isBlockedTo(isoGridSquare6) && (isoObject = isoGridSquare6.getSpecialSolid()) != null) {
                    return isoObject;
                }
            }
            if (isoGridSquare7 == null || this.isBlockedTo(isoGridSquare7) || isoGridSquare6 == null || this.isBlockedTo(isoGridSquare6)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialWall(false);
            if (isoObject != null) {
                return isoObject;
            }
            isoObject = isoGridSquare.getSpecialWall(true);
            if (isoObject != null) {
                return isoObject;
            }
            if (isoGridSquare7.isBlockedTo(isoGridSquare) || isoGridSquare6.isBlockedTo(isoGridSquare)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialSolid();
            if (isoObject != null) {
                return isoObject;
            }
            return null;
        }
        if (isoGridSquare.x < this.x && isoGridSquare.y > this.y) {
            IsoGridSquare isoGridSquare8;
            IsoObject isoObject = this.getSpecialWall(false);
            if (isoObject != null) {
                return isoObject;
            }
            IsoGridSquare isoGridSquare9 = this.getCell().getGridSquare(this.x, this.y + 1, this.z);
            if (isoGridSquare9 != null) {
                isoObject = isoGridSquare9.getSpecialWall(true);
                if (isoObject != null) {
                    return isoObject;
                }
                if (!this.isBlockedTo(isoGridSquare9) && (isoObject = isoGridSquare9.getSpecialSolid()) != null) {
                    return isoObject;
                }
            }
            if ((isoGridSquare8 = this.getCell().getGridSquare(this.x - 1, this.y, this.z)) != null && !this.isBlockedTo(isoGridSquare8) && (isoObject = isoGridSquare8.getSpecialSolid()) != null) {
                return isoObject;
            }
            if (isoGridSquare9 == null || this.isBlockedTo(isoGridSquare9) || isoGridSquare8 == null || this.isBlockedTo(isoGridSquare8)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialWall(true);
            if (isoObject != null) {
                return isoObject;
            }
            if (isoGridSquare9.isBlockedTo(isoGridSquare) || isoGridSquare8.isBlockedTo(isoGridSquare)) {
                return null;
            }
            isoObject = isoGridSquare.getSpecialSolid();
            if (isoObject != null) {
                return isoObject;
            }
            return null;
        }
        return null;
    }

    public IsoObject getDoorFrameTo(IsoGridSquare isoGridSquare) {
        ArrayList<IsoObject> arrayList = null;
        arrayList = isoGridSquare.y < this.y || isoGridSquare.x < this.x ? this.SpecialObjects : isoGridSquare.SpecialObjects;
        for (int i = 0; i < arrayList.size(); ++i) {
            boolean bl;
            IsoObject isoObject;
            if (arrayList.get(i) instanceof IsoDoor) {
                isoObject = (IsoDoor)arrayList.get(i);
                bl = isoObject.north;
                if (bl && isoGridSquare.y != this.y) {
                    return isoObject;
                }
                if (bl || isoGridSquare.x == this.x) continue;
                return isoObject;
            }
            if (!(arrayList.get(i) instanceof IsoThumpable) || !((IsoThumpable)arrayList.get((int)i)).isDoor.booleanValue()) continue;
            isoObject = (IsoThumpable)arrayList.get(i);
            bl = ((IsoThumpable)isoObject).north;
            if (bl && isoGridSquare.y != this.y) {
                return isoObject;
            }
            if (bl || isoGridSquare.x == this.x) continue;
            return isoObject;
        }
        return null;
    }

    public static void getSquaresForThread(ArrayDeque<IsoGridSquare> arrayDeque, int n) {
        for (int i = 0; i < n; ++i) {
            IsoGridSquare isoGridSquare = isoGridSquareCache.poll();
            if (isoGridSquare == null) {
                arrayDeque.add(new IsoGridSquare(null, null, 0, 0, 0));
                continue;
            }
            arrayDeque.add(isoGridSquare);
        }
    }

    public static IsoGridSquare getNew(IsoCell isoCell, SliceY sliceY, int n, int n2, int n3) {
        IsoGridSquare isoGridSquare = isoGridSquareCache.poll();
        if (isoGridSquare == null) {
            return new IsoGridSquare(isoCell, sliceY, n, n2, n3);
        }
        isoGridSquare.x = n;
        isoGridSquare.y = n2;
        isoGridSquare.z = n3;
        isoGridSquare.CachedScreenValue = -1;
        col = 0;
        path = 0;
        pathdoor = 0;
        vision = 0;
        isoGridSquare.collideMatrix = 0x7FFFFFF;
        isoGridSquare.pathMatrix = 0x7FFFFFF;
        isoGridSquare.visionMatrix = 0;
        return isoGridSquare;
    }

    public static IsoGridSquare getNew(ArrayDeque<IsoGridSquare> arrayDeque, IsoCell isoCell, SliceY sliceY, int n, int n2, int n3) {
        IsoGridSquare isoGridSquare = null;
        if (arrayDeque.isEmpty()) {
            return new IsoGridSquare(isoCell, sliceY, n, n2, n3);
        }
        isoGridSquare = arrayDeque.pop();
        isoGridSquare.x = n;
        isoGridSquare.y = n2;
        isoGridSquare.z = n3;
        isoGridSquare.CachedScreenValue = -1;
        col = 0;
        path = 0;
        pathdoor = 0;
        vision = 0;
        isoGridSquare.collideMatrix = 0x7FFFFFF;
        isoGridSquare.pathMatrix = 0x7FFFFFF;
        isoGridSquare.visionMatrix = 0;
        return isoGridSquare;
    }

    @Deprecated
    public long getHashCodeObjects() {
        this.recalcHashCodeObjects();
        return this.hashCodeObjects;
    }

    @Deprecated
    public int getHashCodeObjectsInt() {
        this.recalcHashCodeObjects();
        return (int)this.hashCodeObjects;
    }

    @Deprecated
    public void recalcHashCodeObjects() {
        long l;
        this.hashCodeObjects = l = 0L;
    }

    @Deprecated
    public int hashCodeNoOverride() {
        int n;
        int n2;
        int n3 = 0;
        this.recalcHashCodeObjects();
        n3 = n3 * 2 + this.Objects.size();
        n3 = (int)((long)n3 + this.getHashCodeObjects());
        for (n2 = 0; n2 < this.Objects.size(); ++n2) {
            n3 = n3 * 2 + this.Objects.get(n2).hashCode();
        }
        n2 = 0;
        for (n = 0; n < this.StaticMovingObjects.size(); ++n) {
            if (!(this.StaticMovingObjects.get(n) instanceof IsoDeadBody)) continue;
            ++n2;
        }
        n3 = n3 * 2 + n2;
        for (n = 0; n < this.StaticMovingObjects.size(); ++n) {
            IsoMovingObject isoMovingObject = this.StaticMovingObjects.get(n);
            if (!(isoMovingObject instanceof IsoDeadBody)) continue;
            n3 = n3 * 2 + isoMovingObject.hashCode();
        }
        if (this.table != null && !this.table.isEmpty()) {
            n3 = n3 * 2 + this.table.hashCode();
        }
        n = 0;
        if (this.isOverlayDone()) {
            n = (byte)(n | 1);
        }
        if (this.haveRoof) {
            n = (byte)(n | 2);
        }
        if (this.burntOut) {
            n = (byte)(n | 4);
        }
        n3 = n3 * 2 + n;
        n3 = n3 * 2 + this.getErosionData().hashCode();
        if (this.getTrapPositionX() > 0) {
            n3 = n3 * 2 + this.getTrapPositionX();
            n3 = n3 * 2 + this.getTrapPositionY();
            n3 = n3 * 2 + this.getTrapPositionZ();
        }
        n3 = n3 * 2 + (this.haveElectricity() ? 1 : 0);
        n3 = n3 * 2 + (this.haveSheetRope ? 1 : 0);
        return n3;
    }

    public IsoGridSquare(IsoCell isoCell, SliceY sliceY, int n, int n2, int n3) {
        this.ID = ++IDMax;
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.CachedScreenValue = -1;
        col = 0;
        path = 0;
        pathdoor = 0;
        vision = 0;
        this.collideMatrix = 0x7FFFFFF;
        this.pathMatrix = 0x7FFFFFF;
        this.visionMatrix = 0;
        for (int i = 0; i < 4; ++i) {
            if (GameServer.bServer) {
                if (i != 0) continue;
                this.lighting[i] = new ServerLOS.ServerLighting();
                continue;
            }
            this.lighting[i] = LightingJNI.init ? new LightingJNI.JNILighting(i, this) : new Lighting();
        }
    }

    public IsoGridSquare getTileInDirection(IsoDirections isoDirections) {
        if (isoDirections == IsoDirections.N) {
            return this.getCell().getGridSquare(this.x, this.y - 1, this.z);
        }
        if (isoDirections == IsoDirections.NE) {
            return this.getCell().getGridSquare(this.x + 1, this.y - 1, this.z);
        }
        if (isoDirections == IsoDirections.NW) {
            return this.getCell().getGridSquare(this.x - 1, this.y - 1, this.z);
        }
        if (isoDirections == IsoDirections.E) {
            return this.getCell().getGridSquare(this.x + 1, this.y, this.z);
        }
        if (isoDirections == IsoDirections.W) {
            return this.getCell().getGridSquare(this.x - 1, this.y, this.z);
        }
        if (isoDirections == IsoDirections.SE) {
            return this.getCell().getGridSquare(this.x + 1, this.y + 1, this.z);
        }
        if (isoDirections == IsoDirections.SW) {
            return this.getCell().getGridSquare(this.x - 1, this.y + 1, this.z);
        }
        if (isoDirections == IsoDirections.S) {
            return this.getCell().getGridSquare(this.x, this.y + 1, this.z);
        }
        return null;
    }

    IsoObject getWall() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject == null || isoObject.sprite == null || !isoObject.sprite.cutW && !isoObject.sprite.cutN) continue;
            return isoObject;
        }
        return null;
    }

    public IsoObject getThumpableWall(boolean bl) {
        IsoObject isoObject = this.getWall(bl);
        if (isoObject != null && isoObject instanceof IsoThumpable) {
            return isoObject;
        }
        return null;
    }

    public IsoObject getHoppableWall(boolean bl) {
        for (int i = 0; i < this.Objects.size(); ++i) {
            boolean bl2;
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject == null || isoObject.sprite == null) continue;
            PropertyContainer propertyContainer = isoObject.getProperties();
            boolean bl3 = propertyContainer.Is(IsoFlagType.TallHoppableW) && !propertyContainer.Is(IsoFlagType.WallWTrans);
            boolean bl4 = bl2 = propertyContainer.Is(IsoFlagType.TallHoppableN) && !propertyContainer.Is(IsoFlagType.WallNTrans);
            if ((!bl3 || bl) && (!bl2 || !bl)) continue;
            return isoObject;
        }
        return null;
    }

    public IsoObject getThumpableWallOrHoppable(boolean bl) {
        IsoObject isoObject = this.getThumpableWall(bl);
        IsoObject isoObject2 = this.getHoppableWall(bl);
        if (isoObject != null && isoObject2 != null && isoObject == isoObject2) {
            return isoObject;
        }
        if (isoObject == null && isoObject2 != null) {
            return isoObject2;
        }
        if (isoObject != null && isoObject2 == null) {
            return isoObject;
        }
        return null;
    }

    public Boolean getWallFull() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject == null || isoObject.sprite == null || !isoObject.sprite.cutN && !isoObject.sprite.cutW && !isoObject.sprite.getProperties().Is(IsoFlagType.WallN) && !isoObject.sprite.getProperties().Is(IsoFlagType.WallW)) continue;
            return true;
        }
        return false;
    }

    public IsoObject getWall(boolean bl) {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject == null || isoObject.sprite == null || (!isoObject.sprite.cutN || !bl) && (!isoObject.sprite.cutW || bl)) continue;
            return isoObject;
        }
        return null;
    }

    public IsoObject getWallSE() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject == null || isoObject.sprite == null || !isoObject.sprite.getProperties().Is(IsoFlagType.WallSE)) continue;
            return isoObject;
        }
        return null;
    }

    public IsoObject getFloor() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject.sprite == null || !isoObject.sprite.getProperties().Is(IsoFlagType.solidfloor)) continue;
            return isoObject;
        }
        return null;
    }

    public IsoObject getPlayerBuiltFloor() {
        if (this.getBuilding() != null || this.roofHideBuilding != null) {
            return null;
        }
        return this.getFloor();
    }

    public void interpolateLight(ColorInfo colorInfo, float f, float f2) {
        IsoCell isoCell = this.getCell();
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        int n = IsoCamera.frameState.playerIndex;
        int n2 = this.getVertLight(0, n);
        int n3 = this.getVertLight(1, n);
        int n4 = this.getVertLight(2, n);
        int n5 = this.getVertLight(3, n);
        tl.fromColor(n2);
        bl.fromColor(n5);
        tr.fromColor(n3);
        br.fromColor(n4);
        tl.interp(tr, f, interp1);
        bl.interp(br, f, interp2);
        interp1.interp(interp2, f2, finalCol);
        colorInfo.r = IsoGridSquare.finalCol.r;
        colorInfo.g = IsoGridSquare.finalCol.g;
        colorInfo.b = IsoGridSquare.finalCol.b;
        colorInfo.a = IsoGridSquare.finalCol.a;
    }

    public void EnsureSurroundNotNull() {
        assert (!GameServer.bServer);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                IsoGridSquare isoGridSquare;
                if (i == 0 && j == 0 || !IsoWorld.instance.isValidSquare(this.x + i, this.y + j, this.z) || this.getCell().getChunkForGridSquare(this.x + i, this.y + j, this.z) == null || (isoGridSquare = this.getCell().getGridSquare(this.x + i, this.y + j, this.z)) != null) continue;
                isoGridSquare = IsoGridSquare.getNew(this.getCell(), null, this.x + i, this.y + j, this.z);
                IsoGridSquare isoGridSquare2 = this.getCell().ConnectNewSquare(isoGridSquare, false);
            }
        }
    }

    public IsoObject addFloor(String string) {
        Object object;
        int n;
        IsoRegions.setPreviousFlags(this);
        IsoObject isoObject = new IsoObject(this.getCell(), this, string);
        boolean bl = false;
        for (n = 0; n < this.getObjects().size(); ++n) {
            object = this.getObjects().get(n);
            IsoSprite isoSprite = ((IsoObject)object).sprite;
            if (isoSprite == null || !isoSprite.getProperties().Is(IsoFlagType.solidfloor) && !isoSprite.getProperties().Is(IsoFlagType.noStart) && (!isoSprite.getProperties().Is(IsoFlagType.vegitation) || ((IsoObject)object).getType() == IsoObjectType.tree) && (isoSprite.getName() == null || !isoSprite.getName().startsWith("blends_grassoverlays"))) continue;
            if (isoSprite.getName() != null && isoSprite.getName().startsWith("floors_rugs")) {
                bl = true;
                continue;
            }
            this.transmitRemoveItemFromSquare((IsoObject)object);
            --n;
        }
        isoObject.sprite.getProperties().Set(IsoFlagType.solidfloor);
        if (bl) {
            this.getObjects().add(0, isoObject);
        } else {
            this.getObjects().add(isoObject);
        }
        this.EnsureSurroundNotNull();
        this.RecalcProperties();
        this.getCell().checkHaveRoof(this.x, this.y);
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            LosUtil.cachecleared[n] = true;
        }
        IsoGridSquare.setRecalcLightTime(-1);
        GameTime.getInstance().lightSourceUpdate = 100.0f;
        isoObject.transmitCompleteItemToServer();
        this.RecalcAllWithNeighbours(true);
        for (n = this.z - 1; n > 0; --n) {
            object = this.getCell().getGridSquare(this.x, this.y, n);
            if (object == null) {
                object = IsoGridSquare.getNew(this.getCell(), null, this.x, this.y, n);
                this.getCell().ConnectNewSquare((IsoGridSquare)object, false);
            }
            ((IsoGridSquare)object).EnsureSurroundNotNull();
            ((IsoGridSquare)object).RecalcAllWithNeighbours(true);
        }
        this.setCachedIsFree(false);
        PolygonalMap2.instance.squareChanged(this);
        IsoGridOcclusionData.SquareChanged();
        IsoRegions.squareChanged(this);
        this.clearWater();
        return isoObject;
    }

    public IsoThumpable AddStairs(boolean bl, int n, String string, String string2, KahluaTable kahluaTable) {
        int n2;
        IsoRegions.setPreviousFlags(this);
        this.EnsureSurroundNotNull();
        boolean bl2 = !this.TreatAsSolidFloor() && !this.HasStairsBelow();
        this.CachedIsFree = false;
        IsoThumpable isoThumpable = new IsoThumpable(this.getCell(), this, string, bl, kahluaTable);
        if (bl) {
            if (n == 0) {
                isoThumpable.setType(IsoObjectType.stairsBN);
            }
            if (n == 1) {
                isoThumpable.setType(IsoObjectType.stairsMN);
            }
            if (n == 2) {
                isoThumpable.setType(IsoObjectType.stairsTN);
                isoThumpable.sprite.getProperties().Set(bl ? IsoFlagType.cutN : IsoFlagType.cutW);
            }
        }
        if (!bl) {
            if (n == 0) {
                isoThumpable.setType(IsoObjectType.stairsBW);
            }
            if (n == 1) {
                isoThumpable.setType(IsoObjectType.stairsMW);
            }
            if (n == 2) {
                isoThumpable.setType(IsoObjectType.stairsTW);
                isoThumpable.sprite.getProperties().Set(bl ? IsoFlagType.cutN : IsoFlagType.cutW);
            }
        }
        this.AddSpecialObject(isoThumpable);
        if (bl2 && n == 2) {
            n2 = this.z - 1;
            IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.x, this.y, n2);
            if (isoGridSquare == null) {
                isoGridSquare = new IsoGridSquare(this.getCell(), null, this.x, this.y, n2);
                this.getCell().ConnectNewSquare(isoGridSquare, true);
            }
            while (n2 >= 0) {
                IsoThumpable isoThumpable2 = new IsoThumpable(this.getCell(), isoGridSquare, string2, bl, kahluaTable);
                isoGridSquare.AddSpecialObject(isoThumpable2);
                isoThumpable2.transmitCompleteItemToServer();
                if (isoGridSquare.TreatAsSolidFloor()) break;
                if (this.getCell().getGridSquare(isoGridSquare.x, isoGridSquare.y, --n2) == null) {
                    isoGridSquare = new IsoGridSquare(this.getCell(), null, isoGridSquare.x, isoGridSquare.y, n2);
                    this.getCell().ConnectNewSquare(isoGridSquare, true);
                    continue;
                }
                isoGridSquare = this.getCell().getGridSquare(isoGridSquare.x, isoGridSquare.y, n2);
            }
        }
        if (n == 2) {
            IsoGridSquare isoGridSquare = null;
            if (bl) {
                if (IsoWorld.instance.isValidSquare(this.x, this.y - 1, this.z + 1)) {
                    isoGridSquare = this.getCell().getGridSquare(this.x, this.y - 1, this.z + 1);
                    if (isoGridSquare == null) {
                        isoGridSquare = new IsoGridSquare(this.getCell(), null, this.x, this.y - 1, this.z + 1);
                        this.getCell().ConnectNewSquare(isoGridSquare, false);
                    }
                    if (!isoGridSquare.Properties.Is(IsoFlagType.solidfloor)) {
                        isoGridSquare.addFloor("carpentry_02_57");
                    }
                }
            } else if (IsoWorld.instance.isValidSquare(this.x - 1, this.y, this.z + 1)) {
                isoGridSquare = this.getCell().getGridSquare(this.x - 1, this.y, this.z + 1);
                if (isoGridSquare == null) {
                    isoGridSquare = new IsoGridSquare(this.getCell(), null, this.x - 1, this.y, this.z + 1);
                    this.getCell().ConnectNewSquare(isoGridSquare, false);
                }
                if (!isoGridSquare.Properties.Is(IsoFlagType.solidfloor)) {
                    isoGridSquare.addFloor("carpentry_02_57");
                }
            }
            isoGridSquare.getModData().rawset((Object)("ConnectedToStairs" + bl), (Object)true);
            isoGridSquare = this.getCell().getGridSquare(this.x, this.y, this.z + 1);
            if (isoGridSquare == null) {
                isoGridSquare = new IsoGridSquare(this.getCell(), null, this.x, this.y, this.z + 1);
                this.getCell().ConnectNewSquare(isoGridSquare, false);
            }
        }
        for (n2 = this.getX() - 1; n2 <= this.getX() + 1; ++n2) {
            for (int i = this.getY() - 1; i <= this.getY() + 1; ++i) {
                for (int j = this.getZ() - 1; j <= this.getZ() + 1; ++j) {
                    if (!IsoWorld.instance.isValidSquare(n2, i, j)) continue;
                    IsoGridSquare isoGridSquare = this.getCell().getGridSquare(n2, i, j);
                    if (isoGridSquare == null) {
                        isoGridSquare = new IsoGridSquare(this.getCell(), null, n2, i, j);
                        this.getCell().ConnectNewSquare(isoGridSquare, false);
                    }
                    isoGridSquare.ReCalculateCollide(this);
                    isoGridSquare.ReCalculateVisionBlocked(this);
                    isoGridSquare.ReCalculatePathFind(this);
                    this.ReCalculateCollide(isoGridSquare);
                    this.ReCalculatePathFind(isoGridSquare);
                    this.ReCalculateVisionBlocked(isoGridSquare);
                    isoGridSquare.CachedIsFree = false;
                }
            }
        }
        return isoThumpable;
    }

    void ReCalculateAll(IsoGridSquare isoGridSquare) {
        this.ReCalculateAll(isoGridSquare, cellGetSquare);
    }

    void ReCalculateAll(IsoGridSquare isoGridSquare, GetSquare getSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return;
        }
        this.SolidFloorCached = false;
        isoGridSquare.SolidFloorCached = false;
        this.RecalcPropertiesIfNeeded();
        isoGridSquare.RecalcPropertiesIfNeeded();
        this.ReCalculateCollide(isoGridSquare, getSquare);
        isoGridSquare.ReCalculateCollide(this, getSquare);
        this.ReCalculatePathFind(isoGridSquare, getSquare);
        isoGridSquare.ReCalculatePathFind(this, getSquare);
        this.ReCalculateVisionBlocked(isoGridSquare, getSquare);
        isoGridSquare.ReCalculateVisionBlocked(this, getSquare);
        this.setBlockedGridPointers(getSquare);
        isoGridSquare.setBlockedGridPointers(getSquare);
    }

    void ReCalculateAll(boolean bl, IsoGridSquare isoGridSquare, GetSquare getSquare) {
        if (isoGridSquare == null || isoGridSquare == this) {
            return;
        }
        this.SolidFloorCached = false;
        isoGridSquare.SolidFloorCached = false;
        this.RecalcPropertiesIfNeeded();
        if (bl) {
            isoGridSquare.RecalcPropertiesIfNeeded();
        }
        this.ReCalculateCollide(isoGridSquare, getSquare);
        if (bl) {
            isoGridSquare.ReCalculateCollide(this, getSquare);
        }
        this.ReCalculatePathFind(isoGridSquare, getSquare);
        if (bl) {
            isoGridSquare.ReCalculatePathFind(this, getSquare);
        }
        this.ReCalculateVisionBlocked(isoGridSquare, getSquare);
        if (bl) {
            isoGridSquare.ReCalculateVisionBlocked(this, getSquare);
        }
        this.setBlockedGridPointers(getSquare);
        if (bl) {
            isoGridSquare.setBlockedGridPointers(getSquare);
        }
    }

    void ReCalculateMineOnly(IsoGridSquare isoGridSquare) {
        this.SolidFloorCached = false;
        this.RecalcProperties();
        this.ReCalculateCollide(isoGridSquare);
        this.ReCalculatePathFind(isoGridSquare);
        this.ReCalculateVisionBlocked(isoGridSquare);
        this.setBlockedGridPointers(cellGetSquare);
    }

    public void RecalcAllWithNeighbours(boolean bl) {
        this.RecalcAllWithNeighbours(bl, cellGetSquare);
    }

    public void RecalcAllWithNeighbours(boolean bl, GetSquare getSquare) {
        this.SolidFloorCached = false;
        this.RecalcPropertiesIfNeeded();
        for (int i = this.getX() - 1; i <= this.getX() + 1; ++i) {
            for (int j = this.getY() - 1; j <= this.getY() + 1; ++j) {
                for (int k = this.getZ() - 1; k <= this.getZ() + 1; ++k) {
                    IsoGridSquare isoGridSquare;
                    if (!IsoWorld.instance.isValidSquare(i, j, k)) continue;
                    int n = i - this.getX();
                    int n2 = j - this.getY();
                    int n3 = k - this.getZ();
                    if (n == 0 && n2 == 0 && n3 == 0 || (isoGridSquare = getSquare.getGridSquare(i, j, k)) == null) continue;
                    isoGridSquare.DirtySlice();
                    this.ReCalculateAll(bl, isoGridSquare, getSquare);
                }
            }
        }
        IsoWorld.instance.CurrentCell.DoGridNav(this, getSquare);
        IsoGridSquare isoGridSquare = this.nav[IsoDirections.N.index()];
        IsoGridSquare isoGridSquare2 = this.nav[IsoDirections.S.index()];
        IsoGridSquare isoGridSquare3 = this.nav[IsoDirections.W.index()];
        IsoGridSquare isoGridSquare4 = this.nav[IsoDirections.E.index()];
        if (isoGridSquare != null && isoGridSquare3 != null) {
            isoGridSquare.ReCalculateAll(isoGridSquare3, getSquare);
        }
        if (isoGridSquare != null && isoGridSquare4 != null) {
            isoGridSquare.ReCalculateAll(isoGridSquare4, getSquare);
        }
        if (isoGridSquare2 != null && isoGridSquare3 != null) {
            isoGridSquare2.ReCalculateAll(isoGridSquare3, getSquare);
        }
        if (isoGridSquare2 != null && isoGridSquare4 != null) {
            isoGridSquare2.ReCalculateAll(isoGridSquare4, getSquare);
        }
    }

    public void RecalcAllWithNeighboursMineOnly() {
        this.SolidFloorCached = false;
        this.RecalcProperties();
        for (int i = this.getX() - 1; i <= this.getX() + 1; ++i) {
            for (int j = this.getY() - 1; j <= this.getY() + 1; ++j) {
                for (int k = this.getZ() - 1; k <= this.getZ() + 1; ++k) {
                    IsoGridSquare isoGridSquare;
                    if (k < 0) continue;
                    int n = i - this.getX();
                    int n2 = j - this.getY();
                    int n3 = k - this.getZ();
                    if (n == 0 && n2 == 0 && n3 == 0 || (isoGridSquare = this.getCell().getGridSquare(i, j, k)) == null) continue;
                    isoGridSquare.DirtySlice();
                    this.ReCalculateMineOnly(isoGridSquare);
                }
            }
        }
    }

    boolean IsWindow(int n, int n2, int n3) {
        IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.x + n, this.y + n2, this.z + n3);
        return this.getWindowTo(isoGridSquare) != null || this.getWindowThumpableTo(isoGridSquare) != null;
    }

    void RemoveAllWith(IsoFlagType isoFlagType) {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject.sprite == null || !isoObject.sprite.getProperties().Is(isoFlagType)) continue;
            this.Objects.remove(isoObject);
            this.SpecialObjects.remove(isoObject);
            --i;
        }
        this.RecalcAllWithNeighbours(true);
    }

    public boolean hasSupport() {
        IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.x, this.y + 1, this.z);
        IsoGridSquare isoGridSquare2 = this.getCell().getGridSquare(this.x + 1, this.y, this.z);
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject.sprite == null || !isoObject.sprite.getProperties().Is(IsoFlagType.solid) && (!isoObject.sprite.getProperties().Is(IsoFlagType.cutW) && !isoObject.sprite.getProperties().Is(IsoFlagType.cutN) || isoObject.sprite.Properties.Is(IsoFlagType.halfheight))) continue;
            return true;
        }
        if (isoGridSquare != null && isoGridSquare.Properties.Is(IsoFlagType.cutN) && !isoGridSquare.Properties.Is(IsoFlagType.halfheight)) {
            return true;
        }
        return isoGridSquare2 != null && isoGridSquare2.Properties.Is(IsoFlagType.cutW) && !isoGridSquare.Properties.Is(IsoFlagType.halfheight);
    }

    public Integer getID() {
        return this.ID;
    }

    public void setID(int n) {
        this.ID = n;
    }

    private int savematrix(boolean[][][] blArray, byte[] byArray, int n) {
        for (int i = 0; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                for (int k = 0; k <= 2; ++k) {
                    byArray[n] = blArray[i][j][k] ? (byte)1 : 0;
                    ++n;
                }
            }
        }
        return n;
    }

    private int loadmatrix(boolean[][][] blArray, byte[] byArray, int n) {
        for (int i = 0; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                for (int k = 0; k <= 2; ++k) {
                    blArray[i][j][k] = byArray[n] != 0;
                    ++n;
                }
            }
        }
        return n;
    }

    private void savematrix(boolean[][][] blArray, ByteBuffer byteBuffer) {
        for (int i = 0; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                for (int k = 0; k <= 2; ++k) {
                    byteBuffer.put(blArray[i][j][k] ? (byte)1 : 0);
                }
            }
        }
    }

    private void loadmatrix(boolean[][][] blArray, ByteBuffer byteBuffer) {
        for (int i = 0; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                for (int k = 0; k <= 2; ++k) {
                    blArray[i][j][k] = byteBuffer.get() != 0;
                }
            }
        }
    }

    public void DirtySlice() {
    }

    public void setHourSeenToCurrent() {
        this.hourLastSeen = (int)GameTime.instance.getWorldAgeHours();
    }

    public void splatBlood(int n, float f) {
        f *= 2.0f;
        if ((f *= 3.0f) > 1.0f) {
            f = 1.0f;
        }
        IsoGridSquare isoGridSquare = this;
        IsoGridSquare isoGridSquare2 = this;
        for (int i = 0; i < n; ++i) {
            int n2;
            IsoGridSquare isoGridSquare3;
            IsoGridSquare isoGridSquare4;
            float f2;
            int n3;
            int n4;
            boolean bl;
            int n5;
            int n6;
            int n7;
            boolean bl2;
            boolean bl3;
            if (isoGridSquare != null) {
                isoGridSquare = this.getCell().getGridSquare(this.getX(), this.getY() - i, this.getZ());
            }
            if (isoGridSquare2 != null) {
                isoGridSquare2 = this.getCell().getGridSquare(this.getX() - i, this.getY(), this.getZ());
            }
            float f3 = 0.0f;
            if (isoGridSquare2 != null && isoGridSquare2.testCollideAdjacent(null, -1, 0, 0)) {
                bl3 = false;
                bl2 = false;
                n7 = 0;
                n6 = 0;
                if (isoGridSquare2.getS() != null && isoGridSquare2.getS().testCollideAdjacent(null, -1, 0, 0)) {
                    bl3 = true;
                }
                if (isoGridSquare2.getN() != null && isoGridSquare2.getN().testCollideAdjacent(null, -1, 0, 0)) {
                    bl2 = true;
                }
                if (bl3) {
                    n7 = -1;
                }
                if (bl2) {
                    n6 = 1;
                }
                n5 = n6 - n7;
                bl = false;
                n4 = 0;
                n3 = 0;
                if (n5 > 0 && Rand.Next(2) == 0) {
                    bl = true;
                    if (n5 > 1) {
                        if (Rand.Next(2) == 0) {
                            n4 = -1;
                            n3 = 0;
                        } else {
                            n4 = 0;
                            n3 = 1;
                        }
                    } else {
                        n4 = n7;
                        n3 = n6;
                    }
                }
                f2 = (float)Rand.Next(100) / 300.0f;
                isoGridSquare4 = this.getCell().getGridSquare(isoGridSquare2.getX(), isoGridSquare2.getY() + n4, isoGridSquare2.getZ());
                isoGridSquare3 = this.getCell().getGridSquare(isoGridSquare2.getX(), isoGridSquare2.getY() + n3, isoGridSquare2.getZ());
                if (isoGridSquare4 == null || isoGridSquare3 == null || !isoGridSquare4.Is(IsoFlagType.cutW) || !isoGridSquare3.Is(IsoFlagType.cutW) || isoGridSquare4.getProperties().Is(IsoFlagType.WallSE) || isoGridSquare3.getProperties().Is(IsoFlagType.WallSE) || isoGridSquare4.Is(IsoFlagType.HoppableW) || isoGridSquare3.Is(IsoFlagType.HoppableW)) {
                    bl = false;
                }
                if (bl) {
                    n2 = 24 + Rand.Next(2) * 2;
                    if (Rand.Next(2) == 0) {
                        n2 += 8;
                    }
                    isoGridSquare4.DoSplat("overlay_blood_wall_01_" + (n2 + 1), false, IsoFlagType.cutW, f3, f2, f);
                    isoGridSquare3.DoSplat("overlay_blood_wall_01_" + (n2 + 0), false, IsoFlagType.cutW, f3, f2, f);
                } else {
                    n2 = 0;
                    switch (Rand.Next(3)) {
                        case 0: {
                            n2 = 0 + Rand.Next(4);
                            break;
                        }
                        case 1: {
                            n2 = 8 + Rand.Next(4);
                            break;
                        }
                        case 2: {
                            n2 = 16 + Rand.Next(4);
                        }
                    }
                    if (n2 == 17 || n2 == 19) {
                        f2 = 0.0f;
                    }
                    if (isoGridSquare2.Is(IsoFlagType.HoppableW)) {
                        isoGridSquare2.DoSplat("overlay_blood_fence_01_" + n2, false, IsoFlagType.HoppableW, f3, 0.0f, f);
                    } else {
                        isoGridSquare2.DoSplat("overlay_blood_wall_01_" + n2, false, IsoFlagType.cutW, f3, f2, f);
                    }
                }
                isoGridSquare2 = null;
            }
            if (isoGridSquare == null || !isoGridSquare.testCollideAdjacent(null, 0, -1, 0)) continue;
            bl3 = false;
            bl2 = false;
            n7 = 0;
            n6 = 0;
            if (isoGridSquare.getW() != null && isoGridSquare.getW().testCollideAdjacent(null, 0, -1, 0)) {
                bl3 = true;
            }
            if (isoGridSquare.getE() != null && isoGridSquare.getE().testCollideAdjacent(null, 0, -1, 0)) {
                bl2 = true;
            }
            if (bl3) {
                n7 = -1;
            }
            if (bl2) {
                n6 = 1;
            }
            n5 = n6 - n7;
            bl = false;
            n4 = 0;
            n3 = 0;
            if (n5 > 0 && Rand.Next(2) == 0) {
                bl = true;
                if (n5 > 1) {
                    if (Rand.Next(2) == 0) {
                        n4 = -1;
                        n3 = 0;
                    } else {
                        n4 = 0;
                        n3 = 1;
                    }
                } else {
                    n4 = n7;
                    n3 = n6;
                }
            }
            f2 = (float)Rand.Next(100) / 300.0f;
            isoGridSquare4 = this.getCell().getGridSquare(isoGridSquare.getX() + n4, isoGridSquare.getY(), isoGridSquare.getZ());
            isoGridSquare3 = this.getCell().getGridSquare(isoGridSquare.getX() + n3, isoGridSquare.getY(), isoGridSquare.getZ());
            if (isoGridSquare4 == null || isoGridSquare3 == null || !isoGridSquare4.Is(IsoFlagType.cutN) || !isoGridSquare3.Is(IsoFlagType.cutN) || isoGridSquare4.getProperties().Is(IsoFlagType.WallSE) || isoGridSquare3.getProperties().Is(IsoFlagType.WallSE) || isoGridSquare4.Is(IsoFlagType.HoppableN) || isoGridSquare3.Is(IsoFlagType.HoppableN)) {
                bl = false;
            }
            if (bl) {
                n2 = 28 + Rand.Next(2) * 2;
                if (Rand.Next(2) == 0) {
                    n2 += 8;
                }
                isoGridSquare4.DoSplat("overlay_blood_wall_01_" + (n2 + 0), false, IsoFlagType.cutN, f3, f2, f);
                isoGridSquare3.DoSplat("overlay_blood_wall_01_" + (n2 + 1), false, IsoFlagType.cutN, f3, f2, f);
            } else {
                n2 = 0;
                switch (Rand.Next(3)) {
                    case 0: {
                        n2 = 4 + Rand.Next(4);
                        break;
                    }
                    case 1: {
                        n2 = 12 + Rand.Next(4);
                        break;
                    }
                    case 2: {
                        n2 = 20 + Rand.Next(4);
                    }
                }
                if (n2 == 20 || n2 == 22) {
                    f2 = 0.0f;
                }
                if (isoGridSquare.Is(IsoFlagType.HoppableN)) {
                    isoGridSquare.DoSplat("overlay_blood_fence_01_" + n2, false, IsoFlagType.HoppableN, f3, f2, f);
                } else {
                    isoGridSquare.DoSplat("overlay_blood_wall_01_" + n2, false, IsoFlagType.cutN, f3, f2, f);
                }
            }
            isoGridSquare = null;
        }
    }

    public boolean haveBlood() {
        Object object;
        int n;
        if (Core.OptionBloodDecals == 0) {
            return false;
        }
        for (n = 0; n < this.getObjects().size(); ++n) {
            object = this.getObjects().get(n);
            if (((IsoObject)object).wallBloodSplats == null || ((IsoObject)object).wallBloodSplats.isEmpty()) continue;
            return true;
        }
        for (n = 0; n < this.getChunk().FloorBloodSplats.size(); ++n) {
            object = this.getChunk().FloorBloodSplats.get(n);
            float f = ((IsoFloorBloodSplat)object).x + (float)(this.getChunk().wx * 10);
            float f2 = ((IsoFloorBloodSplat)object).y + (float)(this.getChunk().wy * 10);
            if ((int)f - 1 > this.x || (int)f + 1 < this.x || (int)f2 - 1 > this.y || (int)f2 + 1 < this.y) continue;
            return true;
        }
        return false;
    }

    public void removeBlood(boolean bl, boolean bl2) {
        Object object;
        int n;
        for (n = 0; n < this.getObjects().size(); ++n) {
            object = this.getObjects().get(n);
            if (((IsoObject)object).wallBloodSplats == null) continue;
            ((IsoObject)object).wallBloodSplats.clear();
        }
        if (!bl2) {
            for (n = 0; n < this.getChunk().FloorBloodSplats.size(); ++n) {
                object = this.getChunk().FloorBloodSplats.get(n);
                int n2 = (int)((float)(this.getChunk().wx * 10) + ((IsoFloorBloodSplat)object).x);
                int n3 = (int)((float)(this.getChunk().wy * 10) + ((IsoFloorBloodSplat)object).y);
                if (n2 < this.getX() - 1 || n2 > this.getX() + 1 || n3 < this.getY() - 1 || n3 > this.getY() + 1) continue;
                this.getChunk().FloorBloodSplats.remove(n);
                --n;
            }
        }
        if (GameClient.bClient && !bl) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.RemoveBlood.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(this.x);
            byteBufferWriter.putInt(this.y);
            byteBufferWriter.putInt(this.z);
            byteBufferWriter.putBoolean(bl2);
            PacketTypes.PacketType.RemoveBlood.send(GameClient.connection);
        }
    }

    public void DoSplat(String string, boolean bl, IsoFlagType isoFlagType, float f, float f2, float f3) {
        for (int i = 0; i < this.getObjects().size(); ++i) {
            IsoObject isoObject = this.getObjects().get(i);
            if (isoObject.sprite == null || !isoObject.sprite.getProperties().Is(isoFlagType) || isoObject instanceof IsoWindow && isoObject.isDestroyed()) continue;
            IsoSprite isoSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, 0);
            if (isoSprite == null) {
                return;
            }
            if (isoObject.wallBloodSplats == null) {
                isoObject.wallBloodSplats = new ArrayList();
            }
            IsoWallBloodSplat isoWallBloodSplat = new IsoWallBloodSplat((float)GameTime.getInstance().getWorldAgeHours(), isoSprite);
            isoObject.wallBloodSplats.add(isoWallBloodSplat);
        }
    }

    public void ClearTileObjects() {
        this.Objects.clear();
        this.RecalcProperties();
    }

    public void ClearTileObjectsExceptFloor() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject.sprite != null && isoObject.sprite.getProperties().Is(IsoFlagType.solidfloor)) continue;
            this.Objects.remove(isoObject);
            --i;
        }
        this.RecalcProperties();
    }

    public int RemoveTileObject(IsoObject isoObject) {
        IsoRegions.setPreviousFlags(this);
        int n = this.Objects.indexOf(isoObject);
        if (!this.Objects.contains(isoObject)) {
            n = this.SpecialObjects.indexOf(isoObject);
        }
        if (isoObject != null && this.Objects.contains(isoObject)) {
            IsoObject isoObject2;
            if (isoObject.isTableSurface()) {
                for (int i = this.Objects.indexOf(isoObject) + 1; i < this.Objects.size(); ++i) {
                    IsoObject isoObject3 = this.Objects.get(i);
                    if (!isoObject3.isTableTopObject() && !isoObject3.isTableSurface()) continue;
                    isoObject3.setRenderYOffset(isoObject3.getRenderYOffset() - isoObject.getSurfaceOffset());
                    isoObject3.sx = 0.0f;
                    isoObject3.sy = 0.0f;
                }
            }
            if (isoObject == (isoObject2 = this.getPlayerBuiltFloor())) {
                IsoGridOcclusionData.SquareChanged();
            }
            LuaEventManager.triggerEvent("OnObjectAboutToBeRemoved", isoObject);
            if (!this.Objects.contains(isoObject)) {
                throw new IllegalArgumentException("OnObjectAboutToBeRemoved not allowed to remove the object");
            }
            n = this.Objects.indexOf(isoObject);
            isoObject.removeFromWorld();
            isoObject.removeFromSquare();
            assert (!this.Objects.contains(isoObject));
            assert (!this.SpecialObjects.contains(isoObject));
            if (!(isoObject instanceof IsoWorldInventoryObject)) {
                this.RecalcAllWithNeighbours(true);
                this.getCell().checkHaveRoof(this.getX(), this.getY());
                for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                    LosUtil.cachecleared[i] = true;
                }
                IsoGridSquare.setRecalcLightTime(-1);
                GameTime.instance.lightSourceUpdate = 100.0f;
            }
            this.fixPlacedItemRenderOffsets();
        }
        MapCollisionData.instance.squareChanged(this);
        LuaEventManager.triggerEvent("OnTileRemoved", isoObject);
        PolygonalMap2.instance.squareChanged(this);
        IsoRegions.squareChanged(this, true);
        return n;
    }

    public int RemoveTileObjectErosionNoRecalc(IsoObject isoObject) {
        int n = this.Objects.indexOf(isoObject);
        IsoGridSquare isoGridSquare = isoObject.square;
        isoObject.removeFromWorld();
        isoObject.removeFromSquare();
        isoGridSquare.RecalcPropertiesIfNeeded();
        assert (!this.Objects.contains(isoObject));
        assert (!this.SpecialObjects.contains(isoObject));
        return n;
    }

    public void AddSpecialObject(IsoObject isoObject) {
        this.AddSpecialObject(isoObject, -1);
    }

    public void AddSpecialObject(IsoObject isoObject, int n) {
        if (isoObject == null) {
            return;
        }
        IsoRegions.setPreviousFlags(this);
        n = this.placeWallAndDoorCheck(isoObject, n);
        if (n != -1 && n >= 0 && n <= this.Objects.size()) {
            this.Objects.add(n, isoObject);
        } else {
            this.Objects.add(isoObject);
        }
        this.SpecialObjects.add(isoObject);
        this.burntOut = false;
        isoObject.addToWorld();
        if (!GameServer.bServer && !GameClient.bClient) {
            this.restackSheetRope();
        }
        this.RecalcAllWithNeighbours(true);
        this.fixPlacedItemRenderOffsets();
        if (!(isoObject instanceof IsoWorldInventoryObject)) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                LosUtil.cachecleared[i] = true;
            }
            IsoGridSquare.setRecalcLightTime(-1);
            GameTime.instance.lightSourceUpdate = 100.0f;
            if (isoObject == this.getPlayerBuiltFloor()) {
                IsoGridOcclusionData.SquareChanged();
            }
        }
        MapCollisionData.instance.squareChanged(this);
        PolygonalMap2.instance.squareChanged(this);
        IsoRegions.squareChanged(this);
    }

    public void AddTileObject(IsoObject isoObject) {
        this.AddTileObject(isoObject, -1);
    }

    public void AddTileObject(IsoObject isoObject, int n) {
        if (isoObject == null) {
            return;
        }
        IsoRegions.setPreviousFlags(this);
        n = this.placeWallAndDoorCheck(isoObject, n);
        if (n != -1 && n >= 0 && n <= this.Objects.size()) {
            this.Objects.add(n, isoObject);
        } else {
            this.Objects.add(isoObject);
        }
        this.burntOut = false;
        isoObject.addToWorld();
        this.RecalcAllWithNeighbours(true);
        this.fixPlacedItemRenderOffsets();
        if (!(isoObject instanceof IsoWorldInventoryObject)) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                LosUtil.cachecleared[i] = true;
            }
            IsoGridSquare.setRecalcLightTime(-1);
            GameTime.instance.lightSourceUpdate = 100.0f;
            if (isoObject == this.getPlayerBuiltFloor()) {
                IsoGridOcclusionData.SquareChanged();
            }
        }
        MapCollisionData.instance.squareChanged(this);
        PolygonalMap2.instance.squareChanged(this);
        IsoRegions.squareChanged(this);
    }

    public int placeWallAndDoorCheck(IsoObject isoObject, int n) {
        int n2 = -1;
        if (isoObject.sprite != null) {
            boolean bl;
            IsoObjectType isoObjectType = isoObject.sprite.getType();
            boolean bl2 = isoObjectType == IsoObjectType.doorN || isoObjectType == IsoObjectType.doorW;
            boolean bl3 = bl = !bl2 && (isoObject.sprite.cutW || isoObject.sprite.cutN || isoObjectType == IsoObjectType.doorFrN || isoObjectType == IsoObjectType.doorFrW || isoObject.sprite.treatAsWallOrder);
            if (bl || bl2) {
                for (int i = 0; i < this.Objects.size(); ++i) {
                    IsoObject isoObject2 = this.Objects.get(i);
                    isoObjectType = IsoObjectType.MAX;
                    if (isoObject2.sprite == null) continue;
                    isoObjectType = isoObject2.sprite.getType();
                    if (bl && (isoObjectType == IsoObjectType.doorN || isoObjectType == IsoObjectType.doorW)) {
                        n2 = i;
                    }
                    if (!bl2 || isoObjectType != IsoObjectType.doorFrN && isoObjectType != IsoObjectType.doorFrW && !isoObject2.sprite.cutW && !isoObject2.sprite.cutN && !isoObject2.sprite.treatAsWallOrder) continue;
                    n2 = i;
                }
                if (bl2 && n2 > n) {
                    n = n2 + 1;
                    return n;
                }
                if (bl && n2 >= 0 && (n2 < n || n < 0)) {
                    n = n2;
                    return n;
                }
            }
        }
        return n;
    }

    public void transmitAddObjectToSquare(IsoObject isoObject, int n) {
        if (isoObject == null || this.Objects.contains(isoObject)) {
            return;
        }
        this.AddTileObject(isoObject, n);
        if (GameClient.bClient) {
            isoObject.transmitCompleteItemToServer();
        }
        if (GameServer.bServer) {
            isoObject.transmitCompleteItemToClients();
        }
    }

    public int transmitRemoveItemFromSquare(IsoObject isoObject) {
        if (isoObject == null || !this.Objects.contains(isoObject)) {
            return -1;
        }
        if (GameClient.bClient) {
            try {
                GameClient.instance.checkAddedRemovedItems(isoObject);
            }
            catch (Exception exception) {
                GameClient.connection.cancelPacket();
                ExceptionLogger.logException(exception);
            }
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.RemoveItemFromSquare.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(this.getX());
            byteBufferWriter.putInt(this.getY());
            byteBufferWriter.putInt(this.getZ());
            byteBufferWriter.putInt(this.Objects.indexOf(isoObject));
            PacketTypes.PacketType.RemoveItemFromSquare.send(GameClient.connection);
        }
        if (GameServer.bServer) {
            return GameServer.RemoveItemFromMap(isoObject);
        }
        return this.RemoveTileObject(isoObject);
    }

    public void transmitRemoveItemFromSquareOnServer(IsoObject isoObject) {
        if (isoObject == null || !this.Objects.contains(isoObject)) {
            return;
        }
        if (GameServer.bServer) {
            GameServer.RemoveItemFromMap(isoObject);
        }
    }

    public void transmitModdata() {
        if (GameClient.bClient) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.SendModData.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(this.getX());
            byteBufferWriter.putInt(this.getY());
            byteBufferWriter.putInt(this.getZ());
            try {
                this.getModData().save(byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            PacketTypes.PacketType.SendModData.send(GameClient.connection);
        } else if (GameServer.bServer) {
            GameServer.loadModData(this);
        }
    }

    public void AddWorldInventoryItem(String string, float f, float f2, float f3, int n) {
        for (int i = 0; i < n; ++i) {
            this.AddWorldInventoryItem(string, f, f2, f3);
        }
    }

    public InventoryItem AddWorldInventoryItem(String string, float f, float f2, float f3) {
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem(string);
        if (inventoryItem == null) {
            return null;
        }
        IsoWorldInventoryObject isoWorldInventoryObject = new IsoWorldInventoryObject(inventoryItem, this, f, f2, f3);
        inventoryItem.setAutoAge();
        inventoryItem.setWorldItem(isoWorldInventoryObject);
        isoWorldInventoryObject.setKeyId(inventoryItem.getKeyId());
        isoWorldInventoryObject.setName(inventoryItem.getName());
        this.Objects.add(isoWorldInventoryObject);
        this.WorldObjects.add(isoWorldInventoryObject);
        isoWorldInventoryObject.square.chunk.recalcHashCodeObjects();
        if (GameClient.bClient) {
            isoWorldInventoryObject.transmitCompleteItemToServer();
        }
        if (GameServer.bServer) {
            isoWorldInventoryObject.transmitCompleteItemToClients();
        }
        return inventoryItem;
    }

    public InventoryItem AddWorldInventoryItem(InventoryItem inventoryItem, float f, float f2, float f3) {
        return this.AddWorldInventoryItem(inventoryItem, f, f2, f3, true);
    }

    public InventoryItem AddWorldInventoryItem(InventoryItem inventoryItem, float f, float f2, float f3, boolean bl) {
        if (inventoryItem.getFullType().contains(".Corpse")) {
            if (inventoryItem.byteData == null) {
                IsoZombie isoZombie = new IsoZombie(IsoWorld.instance.CurrentCell);
                isoZombie.setDir(IsoDirections.fromIndex(Rand.Next(8)));
                isoZombie.getForwardDirection().set(isoZombie.dir.ToVector());
                isoZombie.setFakeDead(false);
                isoZombie.setHealth(0.0f);
                isoZombie.upKillCount = false;
                isoZombie.setX((float)this.x + f);
                isoZombie.setY((float)this.y + f2);
                isoZombie.setZ(this.z);
                isoZombie.square = this;
                isoZombie.current = this;
                isoZombie.dressInRandomOutfit();
                isoZombie.DoZombieInventory();
                IsoDeadBody isoDeadBody = new IsoDeadBody(isoZombie, true);
                this.addCorpse(isoDeadBody, false);
                if (GameServer.bServer) {
                    GameServer.sendCorpse(isoDeadBody);
                }
                return inventoryItem;
            }
            IsoDeadBody isoDeadBody = new IsoDeadBody(IsoWorld.instance.CurrentCell);
            try {
                byte by = inventoryItem.byteData.get();
                byte by2 = inventoryItem.byteData.get();
                byte by3 = inventoryItem.byteData.get();
                byte by4 = inventoryItem.byteData.get();
                int n = 56;
                if (by == 87 && by2 == 86 && by3 == 69 && by4 == 82) {
                    n = inventoryItem.byteData.getInt();
                } else {
                    inventoryItem.byteData.rewind();
                }
                isoDeadBody.load(inventoryItem.byteData, n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                IsoZombie isoZombie = new IsoZombie(null);
                isoZombie.dir = isoDeadBody.dir;
                isoZombie.current = this;
                isoZombie.x = isoDeadBody.x;
                isoZombie.y = isoDeadBody.y;
                isoZombie.z = isoDeadBody.z;
                isoDeadBody = new IsoDeadBody(isoZombie);
            }
            isoDeadBody.setX((float)this.x + f);
            isoDeadBody.setY((float)this.y + f2);
            isoDeadBody.setZ(this.z);
            isoDeadBody.square = this;
            this.addCorpse(isoDeadBody, false);
            if (GameServer.bServer) {
                GameServer.sendCorpse(isoDeadBody);
            }
            return inventoryItem;
        }
        if (inventoryItem.getFullType().contains(".Generator")) {
            new IsoGenerator(inventoryItem, IsoWorld.instance.CurrentCell, this);
            return inventoryItem;
        }
        IsoWorldInventoryObject isoWorldInventoryObject = new IsoWorldInventoryObject(inventoryItem, this, f, f2, f3);
        isoWorldInventoryObject.setName(inventoryItem.getName());
        isoWorldInventoryObject.setKeyId(inventoryItem.getKeyId());
        this.Objects.add(isoWorldInventoryObject);
        this.WorldObjects.add(isoWorldInventoryObject);
        isoWorldInventoryObject.square.chunk.recalcHashCodeObjects();
        inventoryItem.setWorldItem(isoWorldInventoryObject);
        isoWorldInventoryObject.addToWorld();
        if (bl) {
            if (GameClient.bClient) {
                isoWorldInventoryObject.transmitCompleteItemToServer();
            }
            if (GameServer.bServer) {
                isoWorldInventoryObject.transmitCompleteItemToClients();
            }
        }
        return inventoryItem;
    }

    public void restackSheetRope() {
        if (!(this.Is(IsoFlagType.climbSheetW) || this.Is(IsoFlagType.climbSheetN) || this.Is(IsoFlagType.climbSheetE) || this.Is(IsoFlagType.climbSheetS))) {
            return;
        }
        for (int i = 0; i < this.getObjects().size() - 1; ++i) {
            IsoObject isoObject = this.getObjects().get(i);
            if (isoObject.getProperties() == null || !isoObject.getProperties().Is(IsoFlagType.climbSheetW) && !isoObject.getProperties().Is(IsoFlagType.climbSheetN) && !isoObject.getProperties().Is(IsoFlagType.climbSheetE) && !isoObject.getProperties().Is(IsoFlagType.climbSheetS)) continue;
            if (GameServer.bServer) {
                this.transmitRemoveItemFromSquare(isoObject);
                this.Objects.add(isoObject);
                isoObject.transmitCompleteItemToClients();
                break;
            }
            if (GameClient.bClient) break;
            this.Objects.remove(isoObject);
            this.Objects.add(isoObject);
            break;
        }
    }

    public void Burn() {
        if ((GameServer.bServer || GameClient.bClient) && ServerOptions.instance.NoFire.getValue()) {
            return;
        }
        if (this.getCell() == null) {
            return;
        }
        this.BurnWalls(true);
        LuaEventManager.triggerEvent("OnGridBurnt", this);
    }

    public void Burn(boolean bl) {
        if ((GameServer.bServer || GameClient.bClient) && ServerOptions.instance.NoFire.getValue()) {
            return;
        }
        if (this.getCell() == null) {
            return;
        }
        this.BurnWalls(bl);
    }

    public void BurnWalls(boolean bl) {
        IsoObject isoObject;
        int n;
        if (GameClient.bClient) {
            return;
        }
        if (GameServer.bServer && SafeHouse.isSafeHouse(this, null, false) != null) {
            if (ServerOptions.instance.NoFire.getValue()) {
                return;
            }
            if (!ServerOptions.instance.SafehouseAllowFire.getValue()) {
                return;
            }
        }
        for (n = 0; n < this.SpecialObjects.size(); ++n) {
            IsoObject isoObject2 = this.SpecialObjects.get(n);
            if (isoObject2 instanceof IsoThumpable && ((IsoThumpable)isoObject2).haveSheetRope()) {
                ((IsoThumpable)isoObject2).removeSheetRope(null);
            }
            if (isoObject2 instanceof IsoWindow) {
                if (((IsoWindow)isoObject2).haveSheetRope()) {
                    ((IsoWindow)isoObject2).removeSheetRope(null);
                }
                ((IsoWindow)isoObject2).removeSheet(null);
            }
            if (IsoWindowFrame.isWindowFrame(isoObject2) && IsoWindowFrame.haveSheetRope(isoObject2)) {
                IsoWindowFrame.removeSheetRope(isoObject2, null);
            }
            if (!(isoObject2 instanceof BarricadeAble)) continue;
            IsoBarricade isoBarricade = ((BarricadeAble)((Object)isoObject2)).getBarricadeOnSameSquare();
            isoObject = ((BarricadeAble)((Object)isoObject2)).getBarricadeOnOppositeSquare();
            if (isoBarricade != null) {
                if (GameServer.bServer) {
                    GameServer.RemoveItemFromMap(isoBarricade);
                } else {
                    this.RemoveTileObject(isoBarricade);
                }
            }
            if (isoObject == null) continue;
            if (GameServer.bServer) {
                GameServer.RemoveItemFromMap(isoObject);
                continue;
            }
            isoObject.getSquare().RemoveTileObject(isoObject);
        }
        this.SpecialObjects.clear();
        n = 0;
        if (!this.getProperties().Is(IsoFlagType.burntOut)) {
            int n2 = 0;
            for (int i = 0; i < this.Objects.size(); ++i) {
                Object object;
                isoObject = this.Objects.get(i);
                boolean bl2 = false;
                if (isoObject.getSprite() == null || isoObject.getSprite().getName() == null || isoObject.getSprite().getProperties().Is(IsoFlagType.water) || isoObject.getSprite().getName().contains("_burnt_")) continue;
                if (isoObject instanceof IsoThumpable && isoObject.getSprite().burntTile != null) {
                    object = IsoObject.getNew();
                    ((IsoObject)object).setSprite(IsoSpriteManager.instance.getSprite(isoObject.getSprite().burntTile));
                    ((IsoObject)object).setSquare(this);
                    if (GameServer.bServer) {
                        isoObject.sendObjectChange("replaceWith", "object", object);
                    }
                    isoObject.removeFromWorld();
                    this.Objects.set(i, (IsoObject)object);
                    continue;
                }
                if (isoObject.getSprite().burntTile != null) {
                    isoObject.sprite = IsoSpriteManager.instance.getSprite(isoObject.getSprite().burntTile);
                    isoObject.RemoveAttachedAnims();
                    if (isoObject.Children != null) {
                        isoObject.Children.clear();
                    }
                    isoObject.transmitUpdatedSpriteToClients();
                    isoObject.setOverlaySprite(null);
                    continue;
                }
                if (isoObject.getType() == IsoObjectType.tree) {
                    isoObject.sprite = IsoSpriteManager.instance.getSprite("fencing_burnt_01_" + (Rand.Next(15, 19) + 1));
                    isoObject.RemoveAttachedAnims();
                    if (isoObject.Children != null) {
                        isoObject.Children.clear();
                    }
                    isoObject.transmitUpdatedSpriteToClients();
                    isoObject.setOverlaySprite(null);
                    continue;
                }
                if (isoObject instanceof IsoTrap) continue;
                if (isoObject instanceof IsoBarricade || isoObject instanceof IsoMannequin) {
                    if (GameServer.bServer) {
                        GameServer.RemoveItemFromMap(isoObject);
                    } else {
                        this.Objects.remove(isoObject);
                    }
                    --i;
                    continue;
                }
                if (isoObject instanceof IsoGenerator) {
                    object = (IsoGenerator)isoObject;
                    if (((IsoGenerator)object).getFuel() > 0.0f) {
                        n2 += 20;
                    }
                    if (((IsoGenerator)object).isActivated()) {
                        ((IsoGenerator)object).activated = false;
                        ((IsoGenerator)object).setSurroundingElectricity();
                        if (GameServer.bServer) {
                            ((IsoGenerator)object).syncIsoObject(false, (byte)0, null, null);
                        }
                    }
                    if (GameServer.bServer) {
                        GameServer.RemoveItemFromMap(isoObject);
                    } else {
                        this.RemoveTileObject(isoObject);
                    }
                    --i;
                    continue;
                }
                if (!(isoObject.getType() != IsoObjectType.wall || isoObject.getProperties().Is(IsoFlagType.DoorWallW) || isoObject.getProperties().Is(IsoFlagType.DoorWallN) || isoObject.getProperties().Is("WindowN") || isoObject.getProperties().Is(IsoFlagType.WindowW) || isoObject.getSprite().getName().startsWith("walls_exterior_roofs_") || isoObject.getSprite().getName().startsWith("fencing_") || isoObject.getSprite().getName().startsWith("fixtures_railings_"))) {
                    if (isoObject.getSprite().getProperties().Is(IsoFlagType.collideW) && !isoObject.getSprite().getProperties().Is(IsoFlagType.collideN)) {
                        isoObject.sprite = IsoSpriteManager.instance.getSprite("walls_burnt_01_" + (Rand.Next(2) == 0 ? "0" : "4"));
                    } else if (isoObject.getSprite().getProperties().Is(IsoFlagType.collideN) && !isoObject.getSprite().getProperties().Is(IsoFlagType.collideW)) {
                        isoObject.sprite = IsoSpriteManager.instance.getSprite("walls_burnt_01_" + (Rand.Next(2) == 0 ? "1" : "5"));
                    } else if (isoObject.getSprite().getProperties().Is(IsoFlagType.collideW) && isoObject.getSprite().getProperties().Is(IsoFlagType.collideN)) {
                        isoObject.sprite = IsoSpriteManager.instance.getSprite("walls_burnt_01_" + (Rand.Next(2) == 0 ? "2" : "6"));
                    } else if (isoObject.getProperties().Is(IsoFlagType.WallSE)) {
                        isoObject.sprite = IsoSpriteManager.instance.getSprite("walls_burnt_01_" + (Rand.Next(2) == 0 ? "3" : "7"));
                    }
                } else {
                    if (isoObject instanceof IsoDoor || isoObject instanceof IsoWindow || isoObject instanceof IsoCurtain) {
                        if (GameServer.bServer) {
                            GameServer.RemoveItemFromMap(isoObject);
                        } else {
                            this.RemoveTileObject(isoObject);
                            n = 1;
                        }
                        --i;
                        continue;
                    }
                    if (isoObject.getProperties().Is(IsoFlagType.WindowW)) {
                        isoObject.sprite = IsoSpriteManager.instance.getSprite("walls_burnt_01_" + (Rand.Next(2) == 0 ? "8" : "12"));
                    } else if (isoObject.getProperties().Is("WindowN")) {
                        isoObject.sprite = IsoSpriteManager.instance.getSprite("walls_burnt_01_" + (Rand.Next(2) == 0 ? "9" : "13"));
                    } else if (isoObject.getProperties().Is(IsoFlagType.DoorWallW)) {
                        isoObject.sprite = IsoSpriteManager.instance.getSprite("walls_burnt_01_" + (Rand.Next(2) == 0 ? "10" : "14"));
                    } else if (isoObject.getProperties().Is(IsoFlagType.DoorWallN)) {
                        isoObject.sprite = IsoSpriteManager.instance.getSprite("walls_burnt_01_" + (Rand.Next(2) == 0 ? "11" : "15"));
                    } else if (isoObject.getSprite().getProperties().Is(IsoFlagType.solidfloor) && !isoObject.getSprite().getProperties().Is(IsoFlagType.exterior)) {
                        isoObject.sprite = IsoSpriteManager.instance.getSprite("floors_burnt_01_0");
                    } else {
                        if (isoObject instanceof IsoWaveSignal) {
                            if (GameServer.bServer) {
                                GameServer.RemoveItemFromMap(isoObject);
                            } else {
                                this.RemoveTileObject(isoObject);
                                n = 1;
                            }
                            --i;
                            continue;
                        }
                        if (isoObject.getContainer() != null && isoObject.getContainer().getItems() != null) {
                            int n3;
                            object = null;
                            for (n3 = 0; n3 < isoObject.getContainer().getItems().size(); ++n3) {
                                object = isoObject.getContainer().getItems().get(n3);
                                if ((!(object instanceof Food) || !((Food)object).isAlcoholic()) && !((InventoryItem)object).getType().equals("PetrolCan") && !((InventoryItem)object).getType().equals("Bleach") || (n2 += 20) <= 100) continue;
                                n2 = 100;
                                break;
                            }
                            isoObject.sprite = IsoSpriteManager.instance.getSprite("floors_burnt_01_" + Rand.Next(1, 2));
                            for (n3 = 0; n3 < isoObject.getContainerCount(); ++n3) {
                                ItemContainer itemContainer = isoObject.getContainerByIndex(n3);
                                itemContainer.removeItemsFromProcessItems();
                                itemContainer.removeAllItems();
                            }
                            isoObject.removeAllContainers();
                            if (isoObject.getOverlaySprite() != null) {
                                isoObject.setOverlaySprite(null);
                            }
                            bl2 = true;
                        } else if (isoObject.getSprite().getProperties().Is(IsoFlagType.solidtrans) || isoObject.getSprite().getProperties().Is(IsoFlagType.bed) || isoObject.getSprite().getProperties().Is(IsoFlagType.waterPiped)) {
                            isoObject.sprite = IsoSpriteManager.instance.getSprite("floors_burnt_01_" + Rand.Next(1, 2));
                            if (isoObject.getOverlaySprite() != null) {
                                isoObject.setOverlaySprite(null);
                            }
                        } else if (isoObject.getSprite().getName().startsWith("walls_exterior_roofs_")) {
                            isoObject.sprite = IsoSpriteManager.instance.getSprite("walls_burnt_roofs_01_" + isoObject.getSprite().getName().substring(isoObject.getSprite().getName().lastIndexOf("_") + 1, isoObject.getSprite().getName().length()));
                        } else if (!isoObject.getSprite().getName().startsWith("roofs_accents")) {
                            if (isoObject.getSprite().getName().startsWith("roofs_")) {
                                isoObject.sprite = IsoSpriteManager.instance.getSprite("roofs_burnt_01_" + isoObject.getSprite().getName().substring(isoObject.getSprite().getName().lastIndexOf("_") + 1, isoObject.getSprite().getName().length()));
                            } else if ((isoObject.getSprite().getName().startsWith("fencing_") || isoObject.getSprite().getName().startsWith("fixtures_railings_")) && (isoObject.getSprite().getProperties().Is(IsoFlagType.HoppableN) || isoObject.getSprite().getProperties().Is(IsoFlagType.HoppableW))) {
                                isoObject.sprite = isoObject.getSprite().getProperties().Is(IsoFlagType.transparentW) && !isoObject.getSprite().getProperties().Is(IsoFlagType.transparentN) ? IsoSpriteManager.instance.getSprite("fencing_burnt_01_0") : (isoObject.getSprite().getProperties().Is(IsoFlagType.transparentN) && !isoObject.getSprite().getProperties().Is(IsoFlagType.transparentW) ? IsoSpriteManager.instance.getSprite("fencing_burnt_01_1") : IsoSpriteManager.instance.getSprite("fencing_burnt_01_2"));
                            }
                        }
                    }
                }
                if (bl2 || isoObject instanceof IsoThumpable) {
                    object = IsoObject.getNew();
                    ((IsoObject)object).setSprite(isoObject.getSprite());
                    ((IsoObject)object).setSquare(this);
                    if (GameServer.bServer) {
                        isoObject.sendObjectChange("replaceWith", "object", object);
                    }
                    this.Objects.set(i, (IsoObject)object);
                } else {
                    isoObject.RemoveAttachedAnims();
                    isoObject.transmitUpdatedSpriteToClients();
                    isoObject.setOverlaySprite(null);
                }
                if (isoObject.emitter == null) continue;
                isoObject.emitter.stopAll();
                isoObject.emitter = null;
            }
            if (n2 > 0 && bl) {
                if (GameServer.bServer) {
                    GameServer.PlayWorldSoundServer("BurnedObjectExploded", false, this, 0.0f, 50.0f, 1.0f, false);
                } else {
                    SoundManager.instance.PlayWorldSound("BurnedObjectExploded", this, 0.0f, 50.0f, 1.0f, false);
                }
                IsoFireManager.explode(this.getCell(), this, n2);
            }
        }
        if (n == 0) {
            this.RecalcProperties();
        }
        this.getProperties().Set(IsoFlagType.burntOut);
        this.burntOut = true;
        MapCollisionData.instance.squareChanged(this);
        PolygonalMap2.instance.squareChanged(this);
    }

    public void BurnWallsTCOnly() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (isoObject.sprite != null) continue;
        }
    }

    public void BurnTick() {
        if (GameClient.bClient) {
            return;
        }
        for (int i = 0; i < this.StaticMovingObjects.size(); ++i) {
            IsoMovingObject isoMovingObject = this.StaticMovingObjects.get(i);
            if (!(isoMovingObject instanceof IsoDeadBody)) continue;
            ((IsoDeadBody)isoMovingObject).Burn();
            if (this.StaticMovingObjects.contains(isoMovingObject)) continue;
            --i;
        }
    }

    public boolean CalculateCollide(IsoGridSquare isoGridSquare, boolean bl, boolean bl2, boolean bl3) {
        return this.CalculateCollide(isoGridSquare, bl, bl2, bl3, false);
    }

    public boolean CalculateCollide(IsoGridSquare isoGridSquare, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.CalculateCollide(isoGridSquare, bl, bl2, bl3, bl4, cellGetSquare);
    }

    public boolean CalculateCollide(IsoGridSquare isoGridSquare, boolean bl, boolean bl2, boolean bl3, boolean bl4, GetSquare getSquare) {
        boolean bl5;
        boolean bl6;
        if (isoGridSquare == null && bl2) {
            return true;
        }
        if (isoGridSquare == null) {
            return false;
        }
        if (!bl || isoGridSquare.Properties.Is(IsoFlagType.trans)) {
            // empty if block
        }
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        if (isoGridSquare.x < this.x) {
            bl7 = true;
        }
        if (isoGridSquare.y < this.y) {
            bl9 = true;
        }
        if (isoGridSquare.x > this.x) {
            bl8 = true;
        }
        if (isoGridSquare.y > this.y) {
            bl10 = true;
        }
        if (!bl4 && isoGridSquare.Properties.Is(IsoFlagType.solid)) {
            if (this.Has(IsoObjectType.stairsTW) && !bl2 && isoGridSquare.x < this.x && isoGridSquare.y == this.y && isoGridSquare.z == this.z) {
                return false;
            }
            return !this.Has(IsoObjectType.stairsTN) || bl2 || isoGridSquare.x != this.x || isoGridSquare.y >= this.y || isoGridSquare.z != this.z;
        }
        if (!bl3 && isoGridSquare.Properties.Is(IsoFlagType.solidtrans)) {
            IsoGridSquare isoGridSquare2;
            if (this.Has(IsoObjectType.stairsTW) && !bl2 && isoGridSquare.x < this.x && isoGridSquare.y == this.y && isoGridSquare.z == this.z) {
                return false;
            }
            if (this.Has(IsoObjectType.stairsTN) && !bl2 && isoGridSquare.x == this.x && isoGridSquare.y < this.y && isoGridSquare.z == this.z) {
                return false;
            }
            boolean bl11 = false;
            if (isoGridSquare.Properties.Is(IsoFlagType.windowW) || isoGridSquare.Properties.Is(IsoFlagType.windowN)) {
                bl11 = true;
            }
            if (!bl11 && (isoGridSquare.Properties.Is(IsoFlagType.WindowW) || isoGridSquare.Properties.Is(IsoFlagType.WindowN))) {
                bl11 = true;
            }
            if (!bl11 && (isoGridSquare2 = getSquare.getGridSquare(isoGridSquare.x, isoGridSquare.y + 1, this.z)) != null && (isoGridSquare2.Is(IsoFlagType.windowN) || isoGridSquare2.Is(IsoFlagType.WindowN))) {
                bl11 = true;
            }
            if (!bl11 && (isoGridSquare2 = getSquare.getGridSquare(isoGridSquare.x + 1, isoGridSquare.y, this.z)) != null && (isoGridSquare2.Is(IsoFlagType.windowW) || isoGridSquare2.Is(IsoFlagType.WindowW))) {
                bl11 = true;
            }
            if (!bl11) {
                return true;
            }
        }
        if (isoGridSquare.x != this.x && isoGridSquare.y != this.y && this.z != isoGridSquare.z && bl2) {
            return true;
        }
        if (bl2 && isoGridSquare.z < this.z && !(!this.SolidFloorCached ? this.TreatAsSolidFloor() : this.SolidFloor)) {
            return isoGridSquare.Has(IsoObjectType.stairsTN) || isoGridSquare.Has(IsoObjectType.stairsTW);
        }
        if (bl2 && isoGridSquare.z == this.z) {
            if (isoGridSquare.x > this.x && isoGridSquare.y == this.y && isoGridSquare.Properties.Is(IsoFlagType.windowW)) {
                return false;
            }
            if (isoGridSquare.y > this.y && isoGridSquare.x == this.x && isoGridSquare.Properties.Is(IsoFlagType.windowN)) {
                return false;
            }
            if (isoGridSquare.x < this.x && isoGridSquare.y == this.y && this.Properties.Is(IsoFlagType.windowW)) {
                return false;
            }
            if (isoGridSquare.y < this.y && isoGridSquare.x == this.x && this.Properties.Is(IsoFlagType.windowN)) {
                return false;
            }
        }
        if (isoGridSquare.x > this.x && isoGridSquare.z < this.z && isoGridSquare.Has(IsoObjectType.stairsTW)) {
            return false;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.z < this.z && isoGridSquare.Has(IsoObjectType.stairsTN)) {
            return false;
        }
        IsoGridSquare isoGridSquare3 = getSquare.getGridSquare(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z - 1);
        if (isoGridSquare.x != this.x && isoGridSquare.z == this.z && isoGridSquare.Has(IsoObjectType.stairsTN) && (isoGridSquare3 == null || !isoGridSquare3.Has(IsoObjectType.stairsTN) || bl2)) {
            return true;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.x == this.x && isoGridSquare.z == this.z && isoGridSquare.Has(IsoObjectType.stairsTN) && (isoGridSquare3 == null || !isoGridSquare3.Has(IsoObjectType.stairsTN) || bl2)) {
            return true;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.y == this.y && isoGridSquare.z == this.z && isoGridSquare.Has(IsoObjectType.stairsTW) && (isoGridSquare3 == null || !isoGridSquare3.Has(IsoObjectType.stairsTW) || bl2)) {
            return true;
        }
        if (isoGridSquare.y != this.y && isoGridSquare.z == this.z && isoGridSquare.Has(IsoObjectType.stairsTW) && (isoGridSquare3 == null || !isoGridSquare3.Has(IsoObjectType.stairsTW) || bl2)) {
            return true;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.z == this.z && isoGridSquare.Has(IsoObjectType.stairsMN)) {
            return true;
        }
        if (isoGridSquare.y != this.y && isoGridSquare.z == this.z && isoGridSquare.Has(IsoObjectType.stairsMW)) {
            return true;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.z == this.z && isoGridSquare.Has(IsoObjectType.stairsBN)) {
            return true;
        }
        if (isoGridSquare.y != this.y && isoGridSquare.z == this.z && isoGridSquare.Has(IsoObjectType.stairsBW)) {
            return true;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.z == this.z && this.Has(IsoObjectType.stairsTN)) {
            return true;
        }
        if (isoGridSquare.y != this.y && isoGridSquare.z == this.z && this.Has(IsoObjectType.stairsTW)) {
            return true;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.z == this.z && this.Has(IsoObjectType.stairsMN)) {
            return true;
        }
        if (isoGridSquare.y != this.y && isoGridSquare.z == this.z && this.Has(IsoObjectType.stairsMW)) {
            return true;
        }
        if (isoGridSquare.x != this.x && isoGridSquare.z == this.z && this.Has(IsoObjectType.stairsBN)) {
            return true;
        }
        if (isoGridSquare.y != this.y && isoGridSquare.z == this.z && this.Has(IsoObjectType.stairsBW)) {
            return true;
        }
        if (isoGridSquare.y < this.y && isoGridSquare.x == this.x && isoGridSquare.z > this.z && this.Has(IsoObjectType.stairsTN)) {
            return false;
        }
        if (isoGridSquare.x < this.x && isoGridSquare.y == this.y && isoGridSquare.z > this.z && this.Has(IsoObjectType.stairsTW)) {
            return false;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.x == this.x && isoGridSquare.z < this.z && isoGridSquare.Has(IsoObjectType.stairsTN)) {
            return false;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.y == this.y && isoGridSquare.z < this.z && isoGridSquare.Has(IsoObjectType.stairsTW)) {
            return false;
        }
        if (isoGridSquare.z == this.z && !(!isoGridSquare.SolidFloorCached ? isoGridSquare.TreatAsSolidFloor() : isoGridSquare.SolidFloor) && bl2) {
            return true;
        }
        if (isoGridSquare.z == this.z && !(!isoGridSquare.SolidFloorCached ? isoGridSquare.TreatAsSolidFloor() : isoGridSquare.SolidFloor)) {
            if (isoGridSquare.z > 0 && (isoGridSquare3 = getSquare.getGridSquare(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z - 1)) == null) {
                return true;
            }
        }
        if (this.z != isoGridSquare.z) {
            return isoGridSquare.z >= this.z || isoGridSquare.x != this.x || isoGridSquare.y != this.y || (!this.SolidFloorCached ? this.TreatAsSolidFloor() : this.SolidFloor);
        }
        boolean bl12 = bl9 && this.Properties.Is(IsoFlagType.collideN);
        boolean bl13 = bl7 && this.Properties.Is(IsoFlagType.collideW);
        boolean bl14 = bl10 && isoGridSquare.Properties.Is(IsoFlagType.collideN);
        boolean bl15 = bl6 = bl8 && isoGridSquare.Properties.Is(IsoFlagType.collideW);
        if (bl12 && bl2 && this.Properties.Is(IsoFlagType.canPathN)) {
            bl12 = false;
        }
        if (bl13 && bl2 && this.Properties.Is(IsoFlagType.canPathW)) {
            bl13 = false;
        }
        if (bl14 && bl2 && isoGridSquare.Properties.Is(IsoFlagType.canPathN)) {
            bl14 = false;
        }
        if (bl6 && bl2 && isoGridSquare.Properties.Is(IsoFlagType.canPathW)) {
            bl6 = false;
        }
        if (bl13 && this.Has(IsoObjectType.stairsTW) && !bl2) {
            bl13 = false;
        }
        if (bl12 && this.Has(IsoObjectType.stairsTN) && !bl2) {
            bl12 = false;
        }
        if (bl12 || bl13 || bl14 || bl6) {
            return true;
        }
        boolean bl16 = bl5 = isoGridSquare.x != this.x && isoGridSquare.y != this.y;
        if (bl5) {
            IsoGridSquare isoGridSquare4 = getSquare.getGridSquare(this.x, isoGridSquare.y, this.z);
            IsoGridSquare isoGridSquare5 = getSquare.getGridSquare(isoGridSquare.x, this.y, this.z);
            if (isoGridSquare4 != null && isoGridSquare4 != this && isoGridSquare4 != isoGridSquare) {
                isoGridSquare4.RecalcPropertiesIfNeeded();
            }
            if (isoGridSquare5 != null && isoGridSquare5 != this && isoGridSquare5 != isoGridSquare) {
                isoGridSquare5.RecalcPropertiesIfNeeded();
            }
            if (isoGridSquare == this || isoGridSquare4 == isoGridSquare5 || isoGridSquare4 == this || isoGridSquare5 == this || isoGridSquare4 == isoGridSquare || isoGridSquare5 == isoGridSquare) {
                return true;
            }
            if (isoGridSquare.x == this.x + 1 && isoGridSquare.y == this.y + 1 && isoGridSquare4 != null && isoGridSquare5 != null && isoGridSquare4.Is(IsoFlagType.windowN) && isoGridSquare5.Is(IsoFlagType.windowW)) {
                return true;
            }
            if (isoGridSquare.x == this.x - 1 && isoGridSquare.y == this.y - 1 && isoGridSquare4 != null && isoGridSquare5 != null && isoGridSquare4.Is(IsoFlagType.windowW) && isoGridSquare5.Is(IsoFlagType.windowN)) {
                return true;
            }
            if (this.CalculateCollide(isoGridSquare4, bl, bl2, bl3, false, getSquare)) {
                return true;
            }
            if (this.CalculateCollide(isoGridSquare5, bl, bl2, bl3, false, getSquare)) {
                return true;
            }
            if (isoGridSquare.CalculateCollide(isoGridSquare4, bl, bl2, bl3, false, getSquare)) {
                return true;
            }
            if (isoGridSquare.CalculateCollide(isoGridSquare5, bl, bl2, bl3, false, getSquare)) {
                return true;
            }
        }
        return false;
    }

    public boolean CalculateVisionBlocked(IsoGridSquare isoGridSquare) {
        return this.CalculateVisionBlocked(isoGridSquare, cellGetSquare);
    }

    public boolean CalculateVisionBlocked(IsoGridSquare isoGridSquare, GetSquare getSquare) {
        boolean bl;
        boolean bl2;
        if (isoGridSquare == null) {
            return false;
        }
        if (Math.abs(isoGridSquare.getX() - this.getX()) > 1 || Math.abs(isoGridSquare.getY() - this.getY()) > 1) {
            return true;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (isoGridSquare.x < this.x) {
            bl3 = true;
        }
        if (isoGridSquare.y < this.y) {
            bl5 = true;
        }
        if (isoGridSquare.x > this.x) {
            bl4 = true;
        }
        if (isoGridSquare.y > this.y) {
            bl6 = true;
        }
        if (isoGridSquare.Properties.Is(IsoFlagType.trans) || this.Properties.Is(IsoFlagType.trans)) {
            return false;
        }
        if (this.z != isoGridSquare.z) {
            if (isoGridSquare.z > this.z) {
                if ((isoGridSquare.SolidFloorCached ? isoGridSquare.SolidFloor : isoGridSquare.TreatAsSolidFloor()) && !isoGridSquare.getProperties().Is(IsoFlagType.transparentFloor)) {
                    return true;
                }
                if (this.Properties.Is(IsoFlagType.noStart)) {
                    return true;
                }
                var7_7 = getSquare.getGridSquare(this.x, this.y, isoGridSquare.z);
                if (var7_7 == null) {
                    return false;
                }
                if ((var7_7.SolidFloorCached ? var7_7.SolidFloor : var7_7.TreatAsSolidFloor()) && !var7_7.getProperties().Is(IsoFlagType.transparentFloor)) {
                    return true;
                }
            } else {
                if ((this.SolidFloorCached ? this.SolidFloor : this.TreatAsSolidFloor()) && !this.getProperties().Is(IsoFlagType.transparentFloor)) {
                    return true;
                }
                if (this.Properties.Is(IsoFlagType.noStart)) {
                    return true;
                }
                var7_7 = getSquare.getGridSquare(isoGridSquare.x, isoGridSquare.y, this.z);
                if (var7_7 == null) {
                    return false;
                }
                if ((var7_7.SolidFloorCached ? var7_7.SolidFloor : var7_7.TreatAsSolidFloor()) && !var7_7.getProperties().Is(IsoFlagType.transparentFloor)) {
                    return true;
                }
            }
        }
        if (isoGridSquare.x > this.x && isoGridSquare.Properties.Is(IsoFlagType.transparentW)) {
            return false;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.Properties.Is(IsoFlagType.transparentN)) {
            return false;
        }
        if (isoGridSquare.x < this.x && this.Properties.Is(IsoFlagType.transparentW)) {
            return false;
        }
        if (isoGridSquare.y < this.y && this.Properties.Is(IsoFlagType.transparentN)) {
            return false;
        }
        if (isoGridSquare.x > this.x && isoGridSquare.Properties.Is(IsoFlagType.doorW)) {
            return false;
        }
        if (isoGridSquare.y > this.y && isoGridSquare.Properties.Is(IsoFlagType.doorN)) {
            return false;
        }
        if (isoGridSquare.x < this.x && this.Properties.Is(IsoFlagType.doorW)) {
            return false;
        }
        if (isoGridSquare.y < this.y && this.Properties.Is(IsoFlagType.doorN)) {
            return false;
        }
        boolean bl7 = bl5 && this.Properties.Is(IsoFlagType.collideN);
        boolean bl8 = bl3 && this.Properties.Is(IsoFlagType.collideW);
        boolean bl9 = bl6 && isoGridSquare.Properties.Is(IsoFlagType.collideN);
        boolean bl10 = bl2 = bl4 && isoGridSquare.Properties.Is(IsoFlagType.collideW);
        if (bl7 || bl8 || bl9 || bl2) {
            return true;
        }
        boolean bl11 = bl = isoGridSquare.x != this.x && isoGridSquare.y != this.y;
        if (isoGridSquare.Properties.Is(IsoFlagType.solid) || isoGridSquare.Properties.Is(IsoFlagType.blocksight)) {
            return true;
        }
        if (bl) {
            IsoGridSquare isoGridSquare2 = getSquare.getGridSquare(this.x, isoGridSquare.y, this.z);
            IsoGridSquare isoGridSquare3 = getSquare.getGridSquare(isoGridSquare.x, this.y, this.z);
            if (isoGridSquare2 != null && isoGridSquare2 != this && isoGridSquare2 != isoGridSquare) {
                isoGridSquare2.RecalcPropertiesIfNeeded();
            }
            if (isoGridSquare3 != null && isoGridSquare3 != this && isoGridSquare3 != isoGridSquare) {
                isoGridSquare3.RecalcPropertiesIfNeeded();
            }
            if (this.CalculateVisionBlocked(isoGridSquare2)) {
                return true;
            }
            if (this.CalculateVisionBlocked(isoGridSquare3)) {
                return true;
            }
            if (isoGridSquare.CalculateVisionBlocked(isoGridSquare2)) {
                return true;
            }
            if (isoGridSquare.CalculateVisionBlocked(isoGridSquare3)) {
                return true;
            }
        }
        return false;
    }

    public IsoGameCharacter FindFriend(IsoGameCharacter isoGameCharacter, int n, Stack<IsoGameCharacter> stack) {
        IsoMovingObject isoMovingObject;
        Stack<IsoGameCharacter> stack2 = new Stack<IsoGameCharacter>();
        for (int i = 0; i < isoGameCharacter.getLocalList().size(); ++i) {
            isoMovingObject = isoGameCharacter.getLocalList().get(i);
            if (isoMovingObject == isoGameCharacter || isoMovingObject == isoGameCharacter.getFollowingTarget() || !(isoMovingObject instanceof IsoGameCharacter) || isoMovingObject instanceof IsoZombie || stack.contains(isoMovingObject)) continue;
            stack2.add((IsoGameCharacter)isoMovingObject);
        }
        float f = 1000000.0f;
        isoMovingObject = null;
        for (IsoGameCharacter isoGameCharacter2 : stack2) {
            float f2 = 0.0f;
            f2 += Math.abs((float)this.getX() - isoGameCharacter2.getX());
            f2 += Math.abs((float)this.getY() - isoGameCharacter2.getY());
            if ((f2 += Math.abs((float)this.getZ() - isoGameCharacter2.getZ())) < f) {
                isoMovingObject = isoGameCharacter2;
                f = f2;
            }
            if (isoGameCharacter2 != IsoPlayer.getInstance()) continue;
            isoMovingObject = isoGameCharacter2;
            f2 = 0.0f;
        }
        if (f > (float)n) {
            return null;
        }
        return isoMovingObject;
    }

    public IsoGameCharacter FindEnemy(IsoGameCharacter isoGameCharacter, int n, ArrayList<IsoMovingObject> arrayList, IsoGameCharacter isoGameCharacter2, int n2) {
        float f = 1000000.0f;
        IsoGameCharacter isoGameCharacter3 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoGameCharacter isoGameCharacter4 = (IsoGameCharacter)arrayList.get(i);
            float f2 = 0.0f;
            f2 += Math.abs((float)this.getX() - isoGameCharacter4.getX());
            f2 += Math.abs((float)this.getY() - isoGameCharacter4.getY());
            if (!((f2 += Math.abs((float)this.getZ() - isoGameCharacter4.getZ())) < (float)n) || !(f2 < f) || !(isoGameCharacter4.DistTo(isoGameCharacter2) < (float)n2)) continue;
            isoGameCharacter3 = isoGameCharacter4;
            f = f2;
        }
        if (f > (float)n) {
            return null;
        }
        return isoGameCharacter3;
    }

    public IsoGameCharacter FindEnemy(IsoGameCharacter isoGameCharacter, int n, ArrayList<IsoMovingObject> arrayList) {
        float f = 1000000.0f;
        IsoGameCharacter isoGameCharacter2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoGameCharacter isoGameCharacter3 = (IsoGameCharacter)arrayList.get(i);
            float f2 = 0.0f;
            f2 += Math.abs((float)this.getX() - isoGameCharacter3.getX());
            f2 += Math.abs((float)this.getY() - isoGameCharacter3.getY());
            if (!((f2 += Math.abs((float)this.getZ() - isoGameCharacter3.getZ())) < f)) continue;
            isoGameCharacter2 = isoGameCharacter3;
            f = f2;
        }
        if (f > (float)n) {
            return null;
        }
        return isoGameCharacter2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void RecalcProperties() {
        this.CachedIsFree = false;
        String string = null;
        if (this.Properties.Is("waterAmount")) {
            string = this.Properties.Val("waterAmount");
        }
        String string2 = null;
        if (this.Properties.Is("fuelAmount")) {
            string2 = this.Properties.Val("fuelAmount");
        }
        if (this.zone == null) {
            this.zone = IsoWorld.instance.MetaGrid.getZoneAt(this.x, this.y, this.z);
        }
        this.Properties.Clear();
        this.hasTypes.clear();
        this.hasTree = false;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        int n = this.Objects.size();
        IsoObject[] isoObjectArray = this.Objects.getElements();
        for (int i = 0; i < n; ++i) {
            PropertyContainer propertyContainer;
            IsoObject isoObject = isoObjectArray[i];
            if (isoObject == null || (propertyContainer = isoObject.getProperties()) == null || propertyContainer.Is(IsoFlagType.blueprint)) continue;
            if (isoObject.sprite.forceRender) {
                bl8 = true;
            }
            if (isoObject.getType() == IsoObjectType.tree) {
                this.hasTree = true;
            }
            this.hasTypes.set(isoObject.getType(), true);
            this.Properties.AddProperties(propertyContainer);
            if (propertyContainer.Is(IsoFlagType.water)) {
                bl2 = false;
            } else {
                if (!bl2 && propertyContainer.Is(IsoFlagType.solidfloor)) {
                    bl2 = true;
                }
                if (!bl && propertyContainer.Is(IsoFlagType.solidtrans)) {
                    bl = true;
                }
                if (!bl3 && propertyContainer.Is(IsoFlagType.solidfloor) && !propertyContainer.Is(IsoFlagType.transparentFloor)) {
                    bl3 = true;
                }
            }
            if (!bl4 && propertyContainer.Is(IsoFlagType.collideN) && !propertyContainer.Is(IsoFlagType.HoppableN)) {
                bl4 = true;
            }
            if (!bl5 && propertyContainer.Is(IsoFlagType.collideW) && !propertyContainer.Is(IsoFlagType.HoppableW)) {
                bl5 = true;
            }
            if (!bl6 && propertyContainer.Is(IsoFlagType.cutN) && !propertyContainer.Is(IsoFlagType.transparentN)) {
                bl6 = true;
            }
            if (bl7 || !propertyContainer.Is(IsoFlagType.cutW) || propertyContainer.Is(IsoFlagType.transparentW)) continue;
            bl7 = true;
        }
        if (this.roomID != -1 || this.haveRoof) {
            this.getProperties().UnSet(IsoFlagType.exterior);
            try {
                this.getPuddles().bRecalc = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.getProperties().Set(IsoFlagType.exterior);
            try {
                this.getPuddles().bRecalc = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string != null) {
            this.getProperties().Set("waterAmount", string, false);
        }
        if (string2 != null) {
            this.getProperties().Set("fuelAmount", string2, false);
        }
        if (this.RainDrop != null) {
            this.Properties.Set(IsoFlagType.HasRaindrop);
        }
        if (bl8) {
            this.Properties.Set(IsoFlagType.forceRender);
        }
        if (this.RainSplash != null) {
            this.Properties.Set(IsoFlagType.HasRainSplashes);
        }
        if (this.burntOut) {
            this.Properties.Set(IsoFlagType.burntOut);
        }
        if (!bl && bl2 && this.Properties.Is(IsoFlagType.water)) {
            this.Properties.UnSet(IsoFlagType.solidtrans);
        }
        if (bl3 && this.Properties.Is(IsoFlagType.transparentFloor)) {
            this.Properties.UnSet(IsoFlagType.transparentFloor);
        }
        if (bl4 && this.Properties.Is(IsoFlagType.HoppableN)) {
            this.Properties.UnSet(IsoFlagType.canPathN);
            this.Properties.UnSet(IsoFlagType.HoppableN);
        }
        if (bl5 && this.Properties.Is(IsoFlagType.HoppableW)) {
            this.Properties.UnSet(IsoFlagType.canPathW);
            this.Properties.UnSet(IsoFlagType.HoppableW);
        }
        if (bl6 && this.Properties.Is(IsoFlagType.transparentN)) {
            this.Properties.UnSet(IsoFlagType.transparentN);
        }
        if (bl7 && this.Properties.Is(IsoFlagType.transparentW)) {
            this.Properties.UnSet(IsoFlagType.transparentW);
        }
        boolean bl9 = this.propertiesDirty = this.chunk == null || this.chunk.bLoaded;
        if (this.chunk != null) {
            this.chunk.lightCheck[3] = true;
            this.chunk.lightCheck[2] = true;
            this.chunk.lightCheck[1] = true;
            this.chunk.lightCheck[0] = true;
        }
        if (this.chunk != null) {
            this.chunk.physicsCheck = true;
            this.chunk.collision.clear();
        }
        this.isExteriorCache = this.Is(IsoFlagType.exterior);
        this.isSolidFloorCache = this.Is(IsoFlagType.solidfloor);
        this.isVegitationCache = this.Is(IsoFlagType.vegitation);
    }

    public void RecalcPropertiesIfNeeded() {
        if (this.propertiesDirty) {
            this.RecalcProperties();
        }
    }

    public void ReCalculateCollide(IsoGridSquare isoGridSquare) {
        this.ReCalculateCollide(isoGridSquare, cellGetSquare);
    }

    public void ReCalculateCollide(IsoGridSquare isoGridSquare, GetSquare getSquare) {
        if (1 + (isoGridSquare.x - this.x) < 0 || 1 + (isoGridSquare.y - this.y) < 0 || 1 + (isoGridSquare.z - this.z) < 0) {
            DebugLog.log("ERROR");
        }
        boolean bl = this.CalculateCollide(isoGridSquare, false, false, false, false, getSquare);
        this.collideMatrix = IsoGridSquare.setMatrixBit(this.collideMatrix, 1 + (isoGridSquare.x - this.x), 1 + (isoGridSquare.y - this.y), 1 + (isoGridSquare.z - this.z), bl);
    }

    public void ReCalculatePathFind(IsoGridSquare isoGridSquare) {
        this.ReCalculatePathFind(isoGridSquare, cellGetSquare);
    }

    public void ReCalculatePathFind(IsoGridSquare isoGridSquare, GetSquare getSquare) {
        boolean bl = this.CalculateCollide(isoGridSquare, false, true, false, false, getSquare);
        this.pathMatrix = IsoGridSquare.setMatrixBit(this.pathMatrix, 1 + (isoGridSquare.x - this.x), 1 + (isoGridSquare.y - this.y), 1 + (isoGridSquare.z - this.z), bl);
    }

    public void ReCalculateVisionBlocked(IsoGridSquare isoGridSquare) {
        this.ReCalculateVisionBlocked(isoGridSquare, cellGetSquare);
    }

    public void ReCalculateVisionBlocked(IsoGridSquare isoGridSquare, GetSquare getSquare) {
        boolean bl = this.CalculateVisionBlocked(isoGridSquare, getSquare);
        this.visionMatrix = IsoGridSquare.setMatrixBit(this.visionMatrix, 1 + (isoGridSquare.x - this.x), 1 + (isoGridSquare.y - this.y), 1 + (isoGridSquare.z - this.z), bl);
    }

    private static boolean testCollideSpecialObjects(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        for (int i = 0; i < isoGridSquare2.SpecialObjects.size(); ++i) {
            IsoObject isoObject = isoGridSquare2.SpecialObjects.get(i);
            if (!isoObject.TestCollide(isoMovingObject, isoGridSquare, isoGridSquare2)) continue;
            if (isoObject instanceof IsoDoor) {
                isoMovingObject.setCollidedWithDoor(true);
            } else if (isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).isDoor.booleanValue()) {
                isoMovingObject.setCollidedWithDoor(true);
            }
            isoMovingObject.setCollidedObject(isoObject);
            return true;
        }
        return false;
    }

    public boolean testCollideAdjacent(IsoMovingObject isoMovingObject, int n, int n2, int n3) {
        Object object;
        if (isoMovingObject instanceof IsoPlayer && ((IsoPlayer)isoMovingObject).isNoClip()) {
            return false;
        }
        if (this.collideMatrix == -1) {
            return true;
        }
        if (n < -1 || n > 1 || n2 < -1 || n2 > 1 || n3 < -1 || n3 > 1) {
            return true;
        }
        if (this.x + n < 0 || this.y + n2 < 0 || !IsoWorld.instance.MetaGrid.isValidChunk((this.x + n) / 10, (this.y + n2) / 10)) {
            return true;
        }
        IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.x + n, this.y + n2, this.z + n3);
        SafeHouse safeHouse = null;
        if ((GameServer.bServer || GameClient.bClient) && isoMovingObject instanceof IsoPlayer && !ServerOptions.instance.SafehouseAllowTrepass.getValue()) {
            object = this.getCell().getGridSquare(this.x + n, this.y + n2, 0);
            safeHouse = SafeHouse.isSafeHouse((IsoGridSquare)object, ((IsoPlayer)isoMovingObject).getUsername(), true);
        }
        if (safeHouse != null) {
            return true;
        }
        if (isoGridSquare != null && isoMovingObject != null && (object = this.testCollideSpecialObjects(isoGridSquare)) != null) {
            isoMovingObject.collideWith((IsoObject)object);
            if (object instanceof IsoDoor) {
                isoMovingObject.setCollidedWithDoor(true);
            } else if (object instanceof IsoThumpable && ((IsoThumpable)object).isDoor.booleanValue()) {
                isoMovingObject.setCollidedWithDoor(true);
            }
            isoMovingObject.setCollidedObject((IsoObject)object);
            return true;
        }
        if (UseSlowCollision) {
            return this.CalculateCollide(isoGridSquare, false, false, false);
        }
        if (isoMovingObject instanceof IsoPlayer && IsoGridSquare.getMatrixBit(this.collideMatrix, n + 1, n2 + 1, n3 + 1)) {
            this.RecalcAllWithNeighbours(true);
        }
        return IsoGridSquare.getMatrixBit(this.collideMatrix, n + 1, n2 + 1, n3 + 1);
    }

    public boolean testCollideAdjacentAdvanced(int n, int n2, int n3, boolean bl) {
        if (this.collideMatrix == -1) {
            return true;
        }
        if (n < -1 || n > 1 || n2 < -1 || n2 > 1 || n3 < -1 || n3 > 1) {
            return true;
        }
        IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.x + n, this.y + n2, this.z + n3);
        if (isoGridSquare != null) {
            IsoObject isoObject;
            int n4;
            if (!isoGridSquare.SpecialObjects.isEmpty()) {
                for (n4 = 0; n4 < isoGridSquare.SpecialObjects.size(); ++n4) {
                    isoObject = isoGridSquare.SpecialObjects.get(n4);
                    if (!isoObject.TestCollide(null, this, isoGridSquare)) continue;
                    return true;
                }
            }
            if (!this.SpecialObjects.isEmpty()) {
                for (n4 = 0; n4 < this.SpecialObjects.size(); ++n4) {
                    isoObject = this.SpecialObjects.get(n4);
                    if (!isoObject.TestCollide(null, this, isoGridSquare)) continue;
                    return true;
                }
            }
        }
        if (UseSlowCollision) {
            return this.CalculateCollide(isoGridSquare, false, false, false);
        }
        return IsoGridSquare.getMatrixBit(this.collideMatrix, n + 1, n2 + 1, n3 + 1);
    }

    public static void setCollisionMode() {
        UseSlowCollision = !UseSlowCollision;
    }

    public boolean testPathFindAdjacent(IsoMovingObject isoMovingObject, int n, int n2, int n3) {
        return this.testPathFindAdjacent(isoMovingObject, n, n2, n3, cellGetSquare);
    }

    public boolean testPathFindAdjacent(IsoMovingObject isoMovingObject, int n, int n2, int n3, GetSquare getSquare) {
        IsoGridSquare isoGridSquare;
        if (n < -1 || n > 1 || n2 < -1 || n2 > 1 || n3 < -1 || n3 > 1) {
            return true;
        }
        if (this.Has(IsoObjectType.stairsTN) || this.Has(IsoObjectType.stairsTW)) {
            isoGridSquare = getSquare.getGridSquare(n + this.x, n2 + this.y, n3 + this.z);
            if (isoGridSquare == null) {
                return true;
            }
            if (this.Has(IsoObjectType.stairsTN) && isoGridSquare.y < this.y && isoGridSquare.z == this.z) {
                return true;
            }
            if (this.Has(IsoObjectType.stairsTW) && isoGridSquare.x < this.x && isoGridSquare.z == this.z) {
                return true;
            }
        }
        if (bDoSlowPathfinding) {
            isoGridSquare = getSquare.getGridSquare(n + this.x, n2 + this.y, n3 + this.z);
            return this.CalculateCollide(isoGridSquare, false, true, false, false, getSquare);
        }
        return IsoGridSquare.getMatrixBit(this.pathMatrix, n + 1, n2 + 1, n3 + 1);
    }

    public LosUtil.TestResults testVisionAdjacent(int n, int n2, int n3, boolean bl, boolean bl2) {
        Object object;
        if (n < -1 || n > 1 || n2 < -1 || n2 > 1 || n3 < -1 || n3 > 1) {
            return LosUtil.TestResults.Blocked;
        }
        if (n3 == 1 && (n != 0 || n2 != 0) && this.HasElevatedFloor() && (object = this.getCell().getGridSquare(this.x, this.y, this.z + n3)) != null) {
            return ((IsoGridSquare)object).testVisionAdjacent(n, n2, 0, bl, bl2);
        }
        if (n3 == -1 && (n != 0 || n2 != 0) && (object = this.getCell().getGridSquare(this.x + n, this.y + n2, this.z + n3)) != null && ((IsoGridSquare)object).HasElevatedFloor()) {
            return this.testVisionAdjacent(n, n2, 0, bl, bl2);
        }
        object = LosUtil.TestResults.Clear;
        if (n != 0 && n2 != 0 && bl) {
            IsoGridSquare isoGridSquare;
            object = this.DoDiagnalCheck(n, n2, n3, bl2);
            if ((object == LosUtil.TestResults.Clear || object == LosUtil.TestResults.ClearThroughWindow || object == LosUtil.TestResults.ClearThroughOpenDoor || object == LosUtil.TestResults.ClearThroughClosedDoor) && (isoGridSquare = this.getCell().getGridSquare(this.x + n, this.y + n2, this.z + n3)) != null) {
                object = isoGridSquare.DoDiagnalCheck(-n, -n2, -n3, bl2);
            }
        } else {
            IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.x + n, this.y + n2, this.z + n3);
            LosUtil.TestResults testResults = LosUtil.TestResults.Clear;
            if (isoGridSquare != null && isoGridSquare.z == this.z) {
                IsoObject.VisionResult visionResult;
                IsoObject isoObject;
                int n4;
                if (!this.SpecialObjects.isEmpty()) {
                    for (n4 = 0; n4 < this.SpecialObjects.size(); ++n4) {
                        isoObject = this.SpecialObjects.get(n4);
                        if (isoObject == null) {
                            return LosUtil.TestResults.Clear;
                        }
                        visionResult = isoObject.TestVision(this, isoGridSquare);
                        if (visionResult == IsoObject.VisionResult.NoEffect) continue;
                        if (visionResult == IsoObject.VisionResult.Unblocked && isoObject instanceof IsoDoor) {
                            testResults = ((IsoDoor)isoObject).IsOpen() ? LosUtil.TestResults.ClearThroughOpenDoor : LosUtil.TestResults.ClearThroughClosedDoor;
                            continue;
                        }
                        if (visionResult == IsoObject.VisionResult.Unblocked && isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).isDoor.booleanValue()) {
                            testResults = LosUtil.TestResults.ClearThroughOpenDoor;
                            continue;
                        }
                        if (visionResult == IsoObject.VisionResult.Unblocked && isoObject instanceof IsoWindow) {
                            testResults = LosUtil.TestResults.ClearThroughWindow;
                            continue;
                        }
                        if (visionResult == IsoObject.VisionResult.Blocked && isoObject instanceof IsoDoor && !bl2) {
                            return LosUtil.TestResults.Blocked;
                        }
                        if (visionResult == IsoObject.VisionResult.Blocked && isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).isDoor.booleanValue() && !bl2) {
                            return LosUtil.TestResults.Blocked;
                        }
                        if (visionResult == IsoObject.VisionResult.Blocked && isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).isWindow()) {
                            return LosUtil.TestResults.Blocked;
                        }
                        if (visionResult == IsoObject.VisionResult.Blocked && isoObject instanceof IsoCurtain) {
                            return LosUtil.TestResults.Blocked;
                        }
                        if (visionResult == IsoObject.VisionResult.Blocked && isoObject instanceof IsoWindow) {
                            return LosUtil.TestResults.Blocked;
                        }
                        if (visionResult != IsoObject.VisionResult.Blocked || !(isoObject instanceof IsoBarricade)) continue;
                        return LosUtil.TestResults.Blocked;
                    }
                }
                if (!isoGridSquare.SpecialObjects.isEmpty()) {
                    for (n4 = 0; n4 < isoGridSquare.SpecialObjects.size(); ++n4) {
                        isoObject = isoGridSquare.SpecialObjects.get(n4);
                        if (isoObject == null) {
                            return LosUtil.TestResults.Clear;
                        }
                        visionResult = isoObject.TestVision(this, isoGridSquare);
                        if (visionResult == IsoObject.VisionResult.NoEffect) continue;
                        if (visionResult == IsoObject.VisionResult.Unblocked && isoObject instanceof IsoDoor) {
                            testResults = ((IsoDoor)isoObject).IsOpen() ? LosUtil.TestResults.ClearThroughOpenDoor : LosUtil.TestResults.ClearThroughClosedDoor;
                            continue;
                        }
                        if (visionResult == IsoObject.VisionResult.Unblocked && isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).isDoor.booleanValue()) {
                            testResults = LosUtil.TestResults.ClearThroughOpenDoor;
                            continue;
                        }
                        if (visionResult == IsoObject.VisionResult.Unblocked && isoObject instanceof IsoWindow) {
                            testResults = LosUtil.TestResults.ClearThroughWindow;
                            continue;
                        }
                        if (visionResult == IsoObject.VisionResult.Blocked && isoObject instanceof IsoDoor && !bl2) {
                            return LosUtil.TestResults.Blocked;
                        }
                        if (visionResult == IsoObject.VisionResult.Blocked && isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).isDoor.booleanValue() && !bl2) {
                            return LosUtil.TestResults.Blocked;
                        }
                        if (visionResult == IsoObject.VisionResult.Blocked && isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).isWindow()) {
                            return LosUtil.TestResults.Blocked;
                        }
                        if (visionResult == IsoObject.VisionResult.Blocked && isoObject instanceof IsoCurtain) {
                            return LosUtil.TestResults.Blocked;
                        }
                        if (visionResult == IsoObject.VisionResult.Blocked && isoObject instanceof IsoWindow) {
                            return LosUtil.TestResults.Blocked;
                        }
                        if (visionResult != IsoObject.VisionResult.Blocked || !(isoObject instanceof IsoBarricade)) continue;
                        return LosUtil.TestResults.Blocked;
                    }
                }
            }
            object = testResults;
            return !IsoGridSquare.getMatrixBit(this.visionMatrix, n + 1, n2 + 1, n3 + 1) ? object : LosUtil.TestResults.Blocked;
        }
        return object;
    }

    public boolean TreatAsSolidFloor() {
        if (this.SolidFloorCached) {
            return this.SolidFloor;
        }
        this.SolidFloor = this.Properties.Is(IsoFlagType.solidfloor) || this.HasStairs();
        this.SolidFloorCached = true;
        return this.SolidFloor;
    }

    public void AddSpecialTileObject(IsoObject isoObject) {
        this.AddSpecialObject(isoObject);
    }

    public void renderCharacters(int n, boolean bl, boolean bl2) {
        IsoMovingObject isoMovingObject;
        int n2;
        if (this.z >= n) {
            return;
        }
        if (!isOnScreenLast) {
            // empty if block
        }
        if (bl2) {
            IndieGL.glBlendFunc(770, 771);
        }
        if (this.MovingObjects.size() > 1) {
            Collections.sort(this.MovingObjects, comp);
        }
        int n3 = IsoCamera.frameState.playerIndex;
        ColorInfo colorInfo = this.lightInfo[n3];
        int n4 = this.StaticMovingObjects.size();
        for (n2 = 0; n2 < n4; ++n2) {
            isoMovingObject = this.StaticMovingObjects.get(n2);
            if (isoMovingObject.sprite == null && !(isoMovingObject instanceof IsoDeadBody) || bl && (!(isoMovingObject instanceof IsoDeadBody) || this.HasStairs()) || !bl && isoMovingObject instanceof IsoDeadBody && !this.HasStairs()) continue;
            isoMovingObject.render(isoMovingObject.getX(), isoMovingObject.getY(), isoMovingObject.getZ(), colorInfo, true, false, null);
        }
        n4 = this.MovingObjects.size();
        for (n2 = 0; n2 < n4; ++n2) {
            isoMovingObject = this.MovingObjects.get(n2);
            if (isoMovingObject == null || isoMovingObject.sprite == null) continue;
            boolean bl3 = isoMovingObject.bOnFloor;
            if (bl3 && isoMovingObject instanceof IsoZombie) {
                IsoZombie isoZombie = (IsoZombie)isoMovingObject;
                bl3 = isoZombie.isProne();
                if (!BaseVehicle.RENDER_TO_TEXTURE) {
                    bl3 = false;
                }
            }
            if (bl && !bl3 || !bl && bl3) continue;
            isoMovingObject.render(isoMovingObject.getX(), isoMovingObject.getY(), isoMovingObject.getZ(), colorInfo, true, false, null);
        }
    }

    public void renderDeferredCharacters(int n) {
        if (this.DeferedCharacters.isEmpty()) {
            return;
        }
        if (this.DeferredCharacterTick != this.getCell().DeferredCharacterTick) {
            this.DeferedCharacters.clear();
            return;
        }
        if (this.z >= n) {
            this.DeferedCharacters.clear();
            return;
        }
        if (PerformanceSettings.LightingFrameSkip == 3) {
            return;
        }
        short s = this.getCell().getStencilValue2z(this.x, this.y, this.z - 1);
        this.getCell().setStencilValue2z(this.x, this.y, this.z - 1, s);
        IndieGL.enableAlphaTest();
        IndieGL.glAlphaFunc(516, 0.0f);
        IndieGL.glStencilFunc(519, s, 127);
        IndieGL.glStencilOp(7680, 7680, 7681);
        float f = IsoUtils.XToScreen(this.x, this.y, this.z, 0);
        float f2 = IsoUtils.YToScreen(this.x, this.y, this.z, 0);
        IndieGL.glColorMask(false, false, false, false);
        Texture.getWhite().renderwallnw(f -= IsoCamera.frameState.OffX, f2 -= IsoCamera.frameState.OffY, 64 * Core.TileScale, 32 * Core.TileScale, -1, -1, -1, -1, -1, -1);
        IndieGL.glColorMask(true, true, true, true);
        IndieGL.enableAlphaTest();
        IndieGL.glAlphaFunc(516, 0.0f);
        IndieGL.glStencilFunc(514, s, 127);
        IndieGL.glStencilOp(7680, 7680, 7680);
        ColorInfo colorInfo = this.lightInfo[IsoCamera.frameState.playerIndex];
        Collections.sort(this.DeferedCharacters, comp);
        for (int i = 0; i < this.DeferedCharacters.size(); ++i) {
            IsoGameCharacter isoGameCharacter = this.DeferedCharacters.get(i);
            if (isoGameCharacter.sprite == null) continue;
            isoGameCharacter.setbDoDefer(false);
            isoGameCharacter.render(isoGameCharacter.getX(), isoGameCharacter.getY(), isoGameCharacter.getZ(), colorInfo, true, false, null);
            isoGameCharacter.renderObjectPicker(isoGameCharacter.getX(), isoGameCharacter.getY(), isoGameCharacter.getZ(), colorInfo);
            isoGameCharacter.setbDoDefer(true);
        }
        this.DeferedCharacters.clear();
        IndieGL.glAlphaFunc(516, 0.0f);
        IndieGL.glStencilFunc(519, 1, 255);
        IndieGL.glStencilOp(7680, 7680, 7680);
    }

    public void switchLight(boolean bl) {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (!(isoObject instanceof IsoLightSwitch)) continue;
            ((IsoLightSwitch)isoObject).setActive(bl);
        }
    }

    public void removeLightSwitch() {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject = this.Objects.get(i);
            if (!(isoObject instanceof IsoLightSwitch)) continue;
            this.Objects.remove(i);
            --i;
        }
    }

    public boolean IsOnScreen() {
        return this.IsOnScreen(false);
    }

    public boolean IsOnScreen(boolean bl) {
        int n;
        if (this.CachedScreenValue != Core.TileScale) {
            this.CachedScreenX = IsoUtils.XToScreen(this.x, this.y, this.z, 0);
            this.CachedScreenY = IsoUtils.YToScreen(this.x, this.y, this.z, 0);
            this.CachedScreenValue = Core.TileScale;
        }
        float f = this.CachedScreenX;
        float f2 = this.CachedScreenY;
        f -= IsoCamera.frameState.OffX;
        f2 -= IsoCamera.frameState.OffY;
        int n2 = n = bl ? 32 * Core.TileScale : 0;
        if (this.hasTree) {
            int n3 = 384 * Core.TileScale / 2 - 96 * Core.TileScale;
            int n4 = 256 * Core.TileScale - 32 * Core.TileScale;
            if (f + (float)n3 <= (float)(0 - n)) {
                return false;
            }
            if (f2 + (float)(32 * Core.TileScale) <= (float)(0 - n)) {
                return false;
            }
            if (f - (float)n3 >= (float)(IsoCamera.frameState.OffscreenWidth + n)) {
                return false;
            }
            return !(f2 - (float)n4 >= (float)(IsoCamera.frameState.OffscreenHeight + n));
        }
        if (f + (float)(32 * Core.TileScale) <= (float)(0 - n)) {
            return false;
        }
        if (f2 + (float)(32 * Core.TileScale) <= (float)(0 - n)) {
            return false;
        }
        if (f - (float)(32 * Core.TileScale) >= (float)(IsoCamera.frameState.OffscreenWidth + n)) {
            return false;
        }
        return !(f2 - (float)(96 * Core.TileScale) >= (float)(IsoCamera.frameState.OffscreenHeight + n));
    }

    void cacheLightInfo() {
        int n = IsoCamera.frameState.playerIndex;
        this.lightInfo[n] = this.lighting[n].lightInfo();
    }

    public void setLightInfoServerGUIOnly(ColorInfo colorInfo) {
        this.lightInfo[0] = colorInfo;
    }

    int renderFloor(Shader shader) {
        try {
            s_performance.renderFloor.start();
            int n = this.renderFloorInternal(shader);
            return n;
        }
        finally {
            s_performance.renderFloor.end();
        }
    }

    private int renderFloorInternal(Shader shader) {
        Serializable serializable;
        int n;
        int n2;
        int n3;
        int n4 = IsoCamera.frameState.playerIndex;
        ColorInfo colorInfo = this.lightInfo[n4];
        IsoGridSquare isoGridSquare = IsoCamera.frameState.CamCharacterSquare;
        boolean bl = this.lighting[n4].bCouldSee();
        float f = this.lighting[n4].darkMulti();
        boolean bl2 = GameClient.bClient && IsoPlayer.players[n4] != null && IsoPlayer.players[n4].isSeeNonPvpZone();
        boolean bl3 = Core.bDebug && GameClient.bClient && SafeHouse.isSafeHouse(this, null, true) != null;
        boolean bl4 = true;
        float f2 = 1.0f;
        float f3 = 1.0f;
        if (isoGridSquare != null && (n3 = this.getRoomID()) != -1) {
            n2 = IsoWorld.instance.CurrentCell.GetEffectivePlayerRoomId();
            if (n2 == -1 && IsoWorld.instance.CurrentCell.CanBuildingSquareOccludePlayer(this, n4)) {
                bl4 = false;
                f2 = 1.0f;
                f3 = 1.0f;
            } else if (!bl && n3 != n2 && f < 0.5f) {
                bl4 = false;
                f2 = 0.0f;
                f3 = f * 2.0f;
            }
        }
        IsoWaterGeometry isoWaterGeometry = this.z == 0 ? this.getWater() : null;
        n2 = isoWaterGeometry != null && isoWaterGeometry.bShore ? 1 : 0;
        float f4 = isoWaterGeometry == null ? 0.0f : isoWaterGeometry.depth[0];
        float f5 = isoWaterGeometry == null ? 0.0f : isoWaterGeometry.depth[3];
        float f6 = isoWaterGeometry == null ? 0.0f : isoWaterGeometry.depth[2];
        float f7 = isoWaterGeometry == null ? 0.0f : isoWaterGeometry.depth[1];
        int n5 = 0;
        int n6 = this.Objects.size();
        IsoObject[] isoObjectArray = this.Objects.getElements();
        for (n = 0; n < n6; ++n) {
            serializable = isoObjectArray[n];
            if (bl2 && (((IsoObject)serializable).highlightFlags & 1) == 0) {
                ((IsoObject)serializable).setHighlighted(true);
                if (NonPvpZone.getNonPvpZone(this.x, this.y) != null) {
                    ((IsoObject)serializable).setHighlightColor(0.6f, 0.6f, 1.0f, 0.5f);
                } else {
                    ((IsoObject)serializable).setHighlightColor(1.0f, 0.6f, 0.6f, 0.5f);
                }
            }
            if (bl3) {
                ((IsoObject)serializable).setHighlighted(true);
                ((IsoObject)serializable).setHighlightColor(1.0f, 0.0f, 0.0f, 1.0f);
            }
            boolean bl5 = true;
            if (((IsoObject)serializable).sprite != null && !((IsoObject)serializable).sprite.solidfloor && ((IsoObject)serializable).sprite.renderLayer != 1) {
                bl5 = false;
                n5 |= 4;
            }
            if (serializable instanceof IsoFire || serializable instanceof IsoCarBatteryCharger) {
                bl5 = false;
                n5 |= 4;
            }
            if (!bl5) {
                boolean bl6;
                boolean bl7 = bl6 = ((IsoObject)serializable).sprite != null && (((IsoObject)serializable).sprite.isBush || ((IsoObject)serializable).sprite.canBeRemoved || ((IsoObject)serializable).sprite.attachedFloor);
                if (!this.bFlattenGrassEtc || !bl6) continue;
                n5 |= 2;
                continue;
            }
            IndieGL.glAlphaFunc(516, 0.0f);
            ((IsoObject)serializable).setTargetAlpha(n4, f3);
            if (bl4) {
                ((IsoObject)serializable).setAlpha(n4, f2);
            }
            if (DebugOptions.instance.Terrain.RenderTiles.RenderGridSquares.getValue() && ((IsoObject)serializable).sprite != null) {
                IndieGL.StartShader(shader, n4);
                FloorShaperAttachedSprites floorShaperAttachedSprites = FloorShaperAttachedSprites.instance;
                FloorShaper floorShaper = ((IsoObject)serializable).getProperties().Is(IsoFlagType.diamondFloor) || ((IsoObject)serializable).getProperties().Is(IsoFlagType.water) ? FloorShaperDiamond.instance : FloorShaperDeDiamond.instance;
                int n7 = this.getVertLight(0, n4);
                int n8 = this.getVertLight(1, n4);
                int n9 = this.getVertLight(2, n4);
                int n10 = this.getVertLight(3, n4);
                if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Floor.LightingDebug.getValue()) {
                    n7 = -65536;
                    n8 = -65536;
                    n9 = -16776961;
                    n10 = -16776961;
                }
                floorShaperAttachedSprites.setShore(n2 != 0);
                floorShaperAttachedSprites.setWaterDepth(f4, f5, f6, f7);
                floorShaperAttachedSprites.setVertColors(n7, n8, n9, n10);
                floorShaper.setShore(n2 != 0);
                floorShaper.setWaterDepth(f4, f5, f6, f7);
                floorShaper.setVertColors(n7, n8, n9, n10);
                ((IsoObject)serializable).renderFloorTile(this.x, this.y, this.z, PerformanceSettings.LightingFrameSkip < 3 ? defColorInfo : colorInfo, true, false, shader, floorShaper, floorShaperAttachedSprites);
                IndieGL.StartShader(null);
            }
            n5 |= 1;
            if ((((IsoObject)serializable).highlightFlags & 1) == 0) {
                n5 |= 8;
            }
            if ((((IsoObject)serializable).highlightFlags & 2) == 0) continue;
            ((IsoObject)serializable).highlightFlags = (byte)(((IsoObject)serializable).highlightFlags & 0xFFFFFFFC);
        }
        if ((this.getCell().rainIntensity > 0 || RainManager.isRaining().booleanValue() && RainManager.RainIntensity > 0.0f) && this.isExteriorCache && !this.isVegitationCache && this.isSolidFloorCache && this.isCouldSee(n4)) {
            if (!IsoCamera.frameState.Paused) {
                int n11 = n = this.getCell().rainIntensity == 0 ? (int)Math.min(Math.floor(RainManager.RainIntensity / 0.2f) + 1.0, 5.0) : this.getCell().rainIntensity;
                if (this.splashFrame < 0.0f && Rand.Next(Rand.AdjustForFramerate((int)(5.0f / (float)n) * 100)) == 0) {
                    this.splashFrame = 0.0f;
                }
            }
            if (this.splashFrame >= 0.0f) {
                n = (int)(this.splashFrame * 4.0f);
                if (rainsplashCache[n] == null) {
                    IsoGridSquare.rainsplashCache[n] = "RainSplash_00_" + n;
                }
                if ((serializable = Texture.getSharedTexture(rainsplashCache[n])) != null) {
                    float f8 = IsoUtils.XToScreen((float)this.x + this.splashX, (float)this.y + this.splashY, this.z, 0) - IsoCamera.frameState.OffX;
                    float f9 = IsoUtils.YToScreen((float)this.x + this.splashX, (float)this.y + this.splashY, this.z, 0) - IsoCamera.frameState.OffY;
                    float f10 = 0.6f * (this.getCell().rainIntensity > 0 ? 1.0f : RainManager.RainIntensity);
                    float f11 = Core.getInstance().RenderShader != null ? 0.6f : 1.0f;
                    SpriteRenderer.instance.render((Texture)serializable, f8 -= (float)(((Texture)serializable).getWidth() / 2 * Core.TileScale), f9 -= (float)(((Texture)serializable).getHeight() / 2 * Core.TileScale), ((Texture)serializable).getWidth() * Core.TileScale, ((Texture)serializable).getHeight() * Core.TileScale, 0.8f * colorInfo.r, 0.9f * colorInfo.g, 1.0f * colorInfo.b, f10 * f11, null);
                }
                if (!IsoCamera.frameState.Paused && this.splashFrameNum != IsoCamera.frameState.frameCount) {
                    this.splashFrame += 0.08f * (30.0f / (float)PerformanceSettings.getLockFPS());
                    if (this.splashFrame >= 1.0f) {
                        this.splashX = Rand.Next(0.1f, 0.9f);
                        this.splashY = Rand.Next(0.1f, 0.9f);
                        this.splashFrame = -1.0f;
                    }
                    this.splashFrameNum = IsoCamera.frameState.frameCount;
                }
            }
        } else {
            this.splashFrame = -1.0f;
        }
        return n5;
    }

    private boolean isSpriteOnSouthOrEastWall(IsoObject isoObject) {
        if (isoObject instanceof IsoBarricade) {
            return isoObject.getDir() == IsoDirections.S || isoObject.getDir() == IsoDirections.E;
        }
        if (isoObject instanceof IsoCurtain) {
            IsoCurtain isoCurtain = (IsoCurtain)isoObject;
            return isoCurtain.getType() == IsoObjectType.curtainS || isoCurtain.getType() == IsoObjectType.curtainE;
        }
        PropertyContainer propertyContainer = isoObject.getProperties();
        return propertyContainer != null && (propertyContainer.Is(IsoFlagType.attachedE) || propertyContainer.Is(IsoFlagType.attachedS));
    }

    public void RenderOpenDoorOnly() {
        int n = this.Objects.size();
        IsoObject[] isoObjectArray = this.Objects.getElements();
        try {
            int n2 = 0;
            int n3 = n - 1;
            for (int i = n2; i <= n3; ++i) {
                IsoObject isoObject = isoObjectArray[i];
                if (isoObject.sprite == null || !isoObject.sprite.getProperties().Is(IsoFlagType.attachedN) && !isoObject.sprite.getProperties().Is(IsoFlagType.attachedW)) continue;
                isoObject.renderFxMask(this.x, this.y, this.z, false);
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public boolean RenderMinusFloorFxMask(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n2 = this.Objects.size();
        IsoObject[] isoObjectArray = this.Objects.getElements();
        long l = System.currentTimeMillis();
        try {
            int n3 = bl ? n2 - 1 : 0;
            int n4 = bl ? 0 : n2 - 1;
            int n5 = n3;
            while (bl ? n5 >= n4 : n5 <= n4) {
                IsoObject isoObject = isoObjectArray[n5];
                if (isoObject.sprite != null) {
                    boolean bl4;
                    boolean bl5 = true;
                    IsoObjectType isoObjectType = isoObject.sprite.getType();
                    if (isoObject.sprite.solidfloor || isoObject.sprite.renderLayer == 1) {
                        bl5 = false;
                    }
                    if (this.z >= n && !isoObject.sprite.alwaysDraw) {
                        bl5 = false;
                    }
                    boolean bl6 = bl4 = isoObject.sprite.isBush || isoObject.sprite.canBeRemoved || isoObject.sprite.attachedFloor;
                    if ((!bl2 || bl4 && this.bFlattenGrassEtc) && (bl2 || !bl4 || !this.bFlattenGrassEtc)) {
                        if ((isoObjectType == IsoObjectType.WestRoofB || isoObjectType == IsoObjectType.WestRoofM || isoObjectType == IsoObjectType.WestRoofT) && this.z == n - 1 && this.z == (int)IsoCamera.CamCharacter.getZ()) {
                            bl5 = false;
                        }
                        if (this.isSpriteOnSouthOrEastWall(isoObject)) {
                            if (!bl) {
                                bl5 = false;
                            }
                            bl3 = true;
                        } else if (bl) {
                            bl5 = false;
                        }
                        if (bl5) {
                            if (isoObject.sprite.cutW || isoObject.sprite.cutN) {
                                boolean bl7;
                                int n6 = IsoCamera.frameState.playerIndex;
                                boolean bl8 = isoObject.sprite.cutN;
                                boolean bl9 = isoObject.sprite.cutW;
                                IsoGridSquare isoGridSquare = this.nav[IsoDirections.S.index()];
                                IsoGridSquare isoGridSquare2 = this.nav[IsoDirections.E.index()];
                                boolean bl10 = isoGridSquare != null && isoGridSquare.getPlayerCutawayFlag(n6, l);
                                boolean bl11 = this.getPlayerCutawayFlag(n6, l);
                                boolean bl12 = bl7 = isoGridSquare2 != null && isoGridSquare2.getPlayerCutawayFlag(n6, l);
                                IsoDirections isoDirections = bl8 && bl9 ? IsoDirections.NW : (bl8 ? IsoDirections.N : (bl9 ? IsoDirections.W : IsoDirections.W));
                                this.DoCutawayShaderSprite(isoObject.sprite, isoDirections, bl10, bl11, bl7);
                            } else {
                                isoObject.renderFxMask(this.x, this.y, this.z, false);
                            }
                        }
                    }
                }
                n5 += bl ? -1 : 1;
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        return bl3;
    }

    private boolean isWindowOrWindowFrame(IsoObject isoObject, boolean bl) {
        if (isoObject == null || isoObject.sprite == null) {
            return false;
        }
        if (bl && isoObject.sprite.getProperties().Is(IsoFlagType.windowN)) {
            return true;
        }
        if (!bl && isoObject.sprite.getProperties().Is(IsoFlagType.windowW)) {
            return true;
        }
        IsoThumpable isoThumpable = Type.tryCastTo(isoObject, IsoThumpable.class);
        if (isoThumpable != null && isoThumpable.isWindow()) {
            return bl == isoThumpable.getNorth();
        }
        return IsoWindowFrame.isWindowFrame(isoObject, bl);
    }

    boolean renderMinusFloor(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Shader shader) {
        boolean bl6 = false;
        if (!this.localTemporaryObjects.isEmpty()) {
            bl6 = this.renderMinusFloor(this.localTemporaryObjects, n, bl, bl2, bl3, bl4, bl5, shader);
        }
        return this.renderMinusFloor(this.Objects, n, bl, bl2, bl3, bl4, bl5, shader) || bl6;
    }

    boolean renderMinusFloor(PZArrayList<IsoObject> pZArrayList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Shader shader) {
        Object object;
        int n2;
        if (!DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.RenderMinusFloor.getValue()) {
            return false;
        }
        IndieGL.glBlendFunc(770, 771);
        int n3 = 0;
        isOnScreenLast = this.IsOnScreen();
        int n4 = IsoCamera.frameState.playerIndex;
        IsoGridSquare isoGridSquare = IsoCamera.frameState.CamCharacterSquare;
        ColorInfo colorInfo = this.lightInfo[n4];
        boolean bl6 = this.lighting[n4].bCouldSee();
        float f = this.lighting[n4].darkMulti();
        boolean bl7 = IsoWorld.instance.CurrentCell.CanBuildingSquareOccludePlayer(this, n4);
        colorInfo.a = 1.0f;
        IsoGridSquare.defColorInfo.r = 1.0f;
        IsoGridSquare.defColorInfo.g = 1.0f;
        IsoGridSquare.defColorInfo.b = 1.0f;
        IsoGridSquare.defColorInfo.a = 1.0f;
        if (Core.bDebug && DebugOptions.instance.DebugDraw_SkipWorldShading.getValue()) {
            colorInfo = defColorInfo;
        }
        float f2 = this.CachedScreenX - IsoCamera.frameState.OffX;
        float f3 = this.CachedScreenY - IsoCamera.frameState.OffY;
        boolean bl8 = true;
        IsoCell isoCell = this.getCell();
        if (f2 + (float)(32 * Core.TileScale) <= (float)isoCell.StencilX1 || f2 - (float)(32 * Core.TileScale) >= (float)isoCell.StencilX2 || f3 + (float)(32 * Core.TileScale) <= (float)isoCell.StencilY1 || f3 - (float)(96 * Core.TileScale) >= (float)isoCell.StencilY2) {
            bl8 = false;
        }
        boolean bl9 = false;
        int n5 = pZArrayList.size();
        IsoObject[] isoObjectArray = pZArrayList.getElements();
        tempWorldInventoryObjects.clear();
        int n6 = bl ? n5 - 1 : 0;
        int n7 = bl ? 0 : n5 - 1;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        if (!bl) {
            for (n2 = n6; n2 <= n7; ++n2) {
                IsoObject isoObject = isoObjectArray[n2];
                if (this.isWindowOrWindowFrame(isoObject, true) && (bl4 || bl5)) {
                    object = this.nav[IsoDirections.N.index()];
                    boolean bl14 = bl12 = bl6 || object != null && ((IsoGridSquare)object).isCouldSee(n4);
                }
                if (this.isWindowOrWindowFrame(isoObject, false) && (bl4 || bl3)) {
                    object = this.nav[IsoDirections.W.index()];
                    boolean bl15 = bl13 = bl6 || object != null && ((IsoGridSquare)object).isCouldSee(n4);
                }
                if (isoObject.sprite != null && (isoObject.sprite.getType() == IsoObjectType.doorFrN || isoObject.sprite.getType() == IsoObjectType.doorN) && (bl4 || bl5)) {
                    object = this.nav[IsoDirections.N.index()];
                    boolean bl16 = bl10 = bl6 || object != null && ((IsoGridSquare)object).isCouldSee(n4);
                }
                if (isoObject.sprite == null || isoObject.sprite.getType() != IsoObjectType.doorFrW && isoObject.sprite.getType() != IsoObjectType.doorW || !bl4 && !bl3) continue;
                object = this.nav[IsoDirections.W.index()];
                bl11 = bl6 || object != null && ((IsoGridSquare)object).isCouldSee(n4);
            }
        }
        n2 = IsoWorld.instance.CurrentCell.GetEffectivePlayerRoomId();
        bWallCutawayN = false;
        bWallCutawayW = false;
        int n8 = n6;
        while (bl ? n8 >= n7 : n8 <= n7) {
            boolean bl17;
            object = isoObjectArray[n8];
            boolean bl18 = true;
            IsoObjectType isoObjectType = IsoObjectType.MAX;
            if (((IsoObject)object).sprite != null) {
                isoObjectType = ((IsoObject)object).sprite.getType();
            }
            CircleStencil = false;
            if (((IsoObject)object).sprite != null && (((IsoObject)object).sprite.solidfloor || ((IsoObject)object).sprite.renderLayer == 1)) {
                bl18 = false;
            }
            if (object instanceof IsoFire) {
                boolean bl19 = bl18 = !bl2;
            }
            if (!(this.z < n || ((IsoObject)object).sprite != null && ((IsoObject)object).sprite.alwaysDraw)) {
                bl18 = false;
            }
            boolean bl20 = bl17 = ((IsoObject)object).sprite != null && (((IsoObject)object).sprite.isBush || ((IsoObject)object).sprite.canBeRemoved || ((IsoObject)object).sprite.attachedFloor);
            if ((!bl2 || bl17 && this.bFlattenGrassEtc) && (bl2 || !bl17 || !this.bFlattenGrassEtc)) {
                boolean bl21;
                if (((IsoObject)object).sprite != null && (isoObjectType == IsoObjectType.WestRoofB || isoObjectType == IsoObjectType.WestRoofM || isoObjectType == IsoObjectType.WestRoofT) && this.z == n - 1 && this.z == (int)IsoCamera.CamCharacter.getZ()) {
                    bl18 = false;
                }
                boolean bl22 = isoObjectType == IsoObjectType.doorFrW || isoObjectType == IsoObjectType.doorW || ((IsoObject)object).sprite != null && ((IsoObject)object).sprite.cutW;
                boolean bl23 = isoObjectType == IsoObjectType.doorFrN || isoObjectType == IsoObjectType.doorN || ((IsoObject)object).sprite != null && ((IsoObject)object).sprite.cutN;
                boolean bl24 = object instanceof IsoDoor && ((IsoDoor)object).open || object instanceof IsoThumpable && ((IsoThumpable)object).open;
                boolean bl25 = ((IsoObject)object).container != null;
                boolean bl26 = bl21 = ((IsoObject)object).sprite != null && ((IsoObject)object).sprite.getProperties().Is(IsoFlagType.waterPiped);
                if (!(((IsoObject)object).sprite == null || isoObjectType != IsoObjectType.MAX || object instanceof IsoDoor || object instanceof IsoWindow || bl25 || bl21)) {
                    if (!bl22 && ((IsoObject)object).sprite.getProperties().Is(IsoFlagType.attachedW) && (bl7 || bl3 || bl4)) {
                        bl18 = !bWallCutawayW;
                    } else if (!bl23 && ((IsoObject)object).sprite.getProperties().Is(IsoFlagType.attachedN) && (bl7 || bl4 || bl5)) {
                        boolean bl27 = bl18 = !bWallCutawayN;
                    }
                }
                if (((IsoObject)object).sprite != null && !((IsoObject)object).sprite.solidfloor && IsoPlayer.getInstance().isClimbing()) {
                    bl18 = true;
                }
                if (this.isSpriteOnSouthOrEastWall((IsoObject)object)) {
                    if (!bl) {
                        bl18 = false;
                    }
                    bl9 = true;
                } else if (bl) {
                    bl18 = false;
                }
                if (bl18) {
                    IndieGL.glAlphaFunc(516, 0.0f);
                    ((IsoObject)object).bAlphaForced = false;
                    if (bl24) {
                        ((IsoObject)object).setTargetAlpha(n4, 0.6f);
                        ((IsoObject)object).setAlpha(n4, 0.6f);
                    }
                    if (((IsoObject)object).sprite != null && (bl22 || bl23)) {
                        if (PerformanceSettings.LightingFrameSkip < 3) {
                            if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.DoorsAndWalls.getValue()) {
                                CircleStencil = true;
                                if (isoGridSquare != null && this.getRoomID() != -1 && n2 == -1 && bl7) {
                                    ((IsoObject)object).setTargetAlpha(n4, 0.5f);
                                    ((IsoObject)object).setAlpha(n4, 0.5f);
                                } else if (this.getRoomID() != n2 && !bl6 && (((IsoObject)object).getProperties().Is(IsoFlagType.transparentN) || ((IsoObject)object).getProperties().Is(IsoFlagType.transparentW))) {
                                    ((IsoObject)object).setTargetAlpha(n4, 0.0f);
                                    ((IsoObject)object).setAlpha(n4, 0.0f);
                                } else if (!bl24) {
                                    ((IsoObject)object).setTargetAlpha(n4, 1.0f);
                                    ((IsoObject)object).setAlpha(n4, 1.0f);
                                }
                                ((IsoObject)object).bAlphaForced = true;
                                if (((IsoObject)object).sprite.cutW && ((IsoObject)object).sprite.cutN) {
                                    n3 = this.DoWallLightingNW((IsoObject)object, n3, bl3, bl4, bl5, bl10, bl11, bl12, bl13, shader);
                                } else if (((IsoObject)object).sprite.getType() == IsoObjectType.doorFrW || isoObjectType == IsoObjectType.doorW || ((IsoObject)object).sprite.cutW) {
                                    n3 = this.DoWallLightingW((IsoObject)object, n3, bl3, bl4, bl11, bl13, shader);
                                } else if (isoObjectType == IsoObjectType.doorFrN || isoObjectType == IsoObjectType.doorN || ((IsoObject)object).sprite.cutN) {
                                    n3 = this.DoWallLightingN((IsoObject)object, n3, bl4, bl5, bl10, bl12, shader);
                                }
                                if (object instanceof IsoWindow && ((IsoObject)object).getTargetAlpha(n4) < 1.0f) {
                                    bWallCutawayN |= ((IsoObject)object).sprite.cutN;
                                    bWallCutawayW |= ((IsoObject)object).sprite.cutW;
                                }
                            }
                        } else if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.DoorsAndWalls_SimpleLighting.getValue()) {
                            if (this.z != (int)IsoCamera.frameState.CamCharacterZ || isoObjectType == IsoObjectType.doorFrW || isoObjectType == IsoObjectType.doorFrN || object instanceof IsoWindow) {
                                bl8 = false;
                            }
                            if (((IsoObject)object).getTargetAlpha(n4) < 1.0f) {
                                if (!bl8) {
                                    ((IsoObject)object).setTargetAlpha(n4, 1.0f);
                                }
                                ((IsoObject)object).setAlphaToTarget(n4);
                                IsoObject.LowLightingQualityHack = false;
                                ((IsoObject)object).render(this.x, this.y, this.z, colorInfo, true, false, null);
                                if (!IsoObject.LowLightingQualityHack) {
                                    ((IsoObject)object).setTargetAlpha(n4, 1.0f);
                                }
                            } else {
                                ((IsoObject)object).render(this.x, this.y, this.z, colorInfo, true, false, null);
                            }
                        }
                    } else if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Objects.getValue()) {
                        IsoWorldInventoryObject isoWorldInventoryObject3;
                        if (this.getRoomID() != -1 && this.getRoomID() != n2 && IsoPlayer.players[n4].isSeatedInVehicle() && IsoPlayer.players[n4].getVehicle().getCurrentSpeedKmHour() >= 50.0f) break;
                        if ((isoObjectType == IsoObjectType.WestRoofB || isoObjectType == IsoObjectType.WestRoofM || isoObjectType == IsoObjectType.WestRoofT) && (this.getRoomID() == -1 && (bl5 || bl3) && (IsoPlayer.players[n4].getX() < (float)this.x && IsoPlayer.players[n4].getY() < (float)this.y || IsoPlayer.players[n4].getZ() < (float)this.z) || (this.getRoomID() != -1 || n2 != -1) && IsoPlayer.players[n4].getX() + IsoPlayer.players[n4].getY() <= (float)(this.x + this.y + 6) && IsoPlayer.players[n4].getZ() < (float)(this.z + 1))) {
                            ((IsoObject)object).setTargetAlpha(n4, 0.0f);
                        } else if (isoGridSquare != null && !bl6 && this.getRoomID() != n2 && f < 0.5f) {
                            ((IsoObject)object).setTargetAlpha(n4, f * 2.0f);
                        } else {
                            if (!bl24) {
                                ((IsoObject)object).setTargetAlpha(n4, 1.0f);
                            }
                            if (IsoPlayer.getInstance() != null && ((IsoObject)object).getProperties() != null && (((IsoObject)object).getProperties().Is(IsoFlagType.solid) || ((IsoObject)object).getProperties().Is(IsoFlagType.solidtrans) || ((IsoObject)object).getProperties().Is(IsoFlagType.attachedCeiling) || ((IsoObject)object).getSprite().getProperties().Is(IsoFlagType.attachedE) || ((IsoObject)object).getSprite().getProperties().Is(IsoFlagType.attachedS)) || isoObjectType.index() > 2 && isoObjectType.index() < 9 && IsoCamera.frameState.CamCharacterZ <= ((IsoObject)object).getZ()) {
                                IsoZombie isoZombie;
                                int n9 = 2;
                                float f4 = 0.75f;
                                if (isoObjectType.index() > 2 && isoObjectType.index() < 9 || ((IsoObject)object).getSprite().getProperties().Is(IsoFlagType.attachedE) || ((IsoObject)object).getSprite().getProperties().Is(IsoFlagType.attachedS)) {
                                    n9 = 4;
                                    if (isoObjectType.index() > 2 && isoObjectType.index() < 9) {
                                        f4 = 0.5f;
                                    }
                                }
                                int n10 = this.getX() - (int)IsoPlayer.getInstance().getX();
                                int n11 = this.getY() - (int)IsoPlayer.getInstance().getY();
                                if (n10 > 0 && n10 < n9 && n11 >= 0 && n11 < n9 || n11 > 0 && n11 < n9 && n10 >= 0 && n10 < n9) {
                                    ((IsoObject)object).setTargetAlpha(n4, f4);
                                }
                                if ((isoZombie = IsoCell.getInstance().getNearestVisibleZombie(n4)) != null && isoZombie.getCurrentSquare() != null && isoZombie.getCurrentSquare().isCanSee(n4)) {
                                    int n12 = this.getX() - (int)isoZombie.x;
                                    int n13 = this.getY() - (int)isoZombie.y;
                                    if (n12 > 0 && n12 < n9 && n13 >= 0 && n13 < n9 || n13 > 0 && n13 < n9 && n12 >= 0 && n12 < n9) {
                                        ((IsoObject)object).setTargetAlpha(n4, f4);
                                    }
                                }
                            }
                        }
                        if (object instanceof IsoWindow) {
                            IsoGridSquare isoGridSquare2;
                            IsoWindow isoWindow = (IsoWindow)object;
                            if (((IsoObject)object).getTargetAlpha(n4) < 1.0E-4f && (isoGridSquare2 = isoWindow.getOppositeSquare()) != null && isoGridSquare2 != this && isoGridSquare2.lighting[n4].bSeen()) {
                                ((IsoObject)object).setTargetAlpha(n4, isoGridSquare2.lighting[n4].darkMulti() * 2.0f);
                            }
                            if (((IsoObject)object).getTargetAlpha(n4) > 0.4f && bl4 && (bl5 && ((IsoObject)object).sprite.getProperties().Is(IsoFlagType.windowN) || bl3 && ((IsoObject)object).sprite.getProperties().Is(IsoFlagType.windowW))) {
                                float f5 = 0.4f;
                                float f6 = 0.1f;
                                IsoPlayer isoPlayer = IsoPlayer.players[n4];
                                if (isoPlayer != null) {
                                    float f7 = 5.0f;
                                    float f8 = Math.abs(isoPlayer.x - (float)this.x) * Math.abs(isoPlayer.x - (float)this.x) + Math.abs(isoPlayer.y - (float)this.y) * Math.abs(isoPlayer.y - (float)this.y);
                                    float f9 = f5 * (float)(1.0 - Math.sqrt(f8 / f7));
                                    ((IsoObject)object).setTargetAlpha(n4, Math.max(f9, f6));
                                } else {
                                    ((IsoObject)object).setTargetAlpha(n4, f6);
                                }
                                if (bl5) {
                                    bWallCutawayN = true;
                                } else {
                                    bWallCutawayW = true;
                                }
                            }
                        }
                        if (object instanceof IsoTree) {
                            if (bl8 && this.x >= (int)IsoCamera.frameState.CamCharacterX && this.y >= (int)IsoCamera.frameState.CamCharacterY && isoGridSquare != null && isoGridSquare.Is(IsoFlagType.exterior)) {
                                ((IsoTree)object).bRenderFlag = true;
                                ((IsoObject)object).setTargetAlpha(n4, Math.min(0.99f, ((IsoObject)object).getTargetAlpha(n4)));
                            } else {
                                ((IsoTree)object).bRenderFlag = false;
                            }
                        }
                        if ((isoWorldInventoryObject3 = Type.tryCastTo(object, IsoWorldInventoryObject.class)) != null) {
                            tempWorldInventoryObjects.add(isoWorldInventoryObject3);
                        }
                        ((IsoObject)object).render(this.x, this.y, this.z, colorInfo, true, false, null);
                    }
                    if ((((IsoObject)object).highlightFlags & 2) != 0) {
                        ((IsoObject)object).highlightFlags = (byte)(((IsoObject)object).highlightFlags & 0xFFFFFFFC);
                    }
                }
            }
            n8 += bl ? -1 : 1;
        }
        Arrays.sort(tempWorldInventoryObjects.getElements(), 0, tempWorldInventoryObjects.size(), (isoWorldInventoryObject, isoWorldInventoryObject2) -> {
            float f = isoWorldInventoryObject.xoff * isoWorldInventoryObject.xoff + isoWorldInventoryObject.yoff * isoWorldInventoryObject.yoff;
            float f2 = isoWorldInventoryObject2.xoff * isoWorldInventoryObject2.xoff + isoWorldInventoryObject2.yoff * isoWorldInventoryObject2.yoff;
            if (f == f2) {
                return 0;
            }
            return f > f2 ? 1 : -1;
        });
        for (n8 = 0; n8 < tempWorldInventoryObjects.size(); ++n8) {
            object = tempWorldInventoryObjects.get(n8);
            ((IsoWorldInventoryObject)object).render(this.x, this.y, this.z, colorInfo, true, false, null);
        }
        return bl9;
    }

    void RereouteWallMaskTo(IsoObject isoObject) {
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoObject isoObject2 = this.Objects.get(i);
            if (!isoObject2.sprite.getProperties().Is(IsoFlagType.collideW) && !isoObject2.sprite.getProperties().Is(IsoFlagType.collideN)) continue;
            isoObject2.rerouteMask = isoObject;
        }
    }

    void setBlockedGridPointers(GetSquare getSquare) {
        this.w = getSquare.getGridSquare(this.x - 1, this.y, this.z);
        this.e = getSquare.getGridSquare(this.x + 1, this.y, this.z);
        this.s = getSquare.getGridSquare(this.x, this.y + 1, this.z);
        this.n = getSquare.getGridSquare(this.x, this.y - 1, this.z);
        this.ne = getSquare.getGridSquare(this.x + 1, this.y - 1, this.z);
        this.nw = getSquare.getGridSquare(this.x - 1, this.y - 1, this.z);
        this.se = getSquare.getGridSquare(this.x + 1, this.y + 1, this.z);
        this.sw = getSquare.getGridSquare(this.x - 1, this.y + 1, this.z);
        if (this.s != null && this.testPathFindAdjacent(null, this.s.x - this.x, this.s.y - this.y, this.s.z - this.z, getSquare)) {
            this.s = null;
        }
        if (this.w != null && this.testPathFindAdjacent(null, this.w.x - this.x, this.w.y - this.y, this.w.z - this.z, getSquare)) {
            this.w = null;
        }
        if (this.n != null && this.testPathFindAdjacent(null, this.n.x - this.x, this.n.y - this.y, this.n.z - this.z, getSquare)) {
            this.n = null;
        }
        if (this.e != null && this.testPathFindAdjacent(null, this.e.x - this.x, this.e.y - this.y, this.e.z - this.z, getSquare)) {
            this.e = null;
        }
        if (this.sw != null && this.testPathFindAdjacent(null, this.sw.x - this.x, this.sw.y - this.y, this.sw.z - this.z, getSquare)) {
            this.sw = null;
        }
        if (this.se != null && this.testPathFindAdjacent(null, this.se.x - this.x, this.se.y - this.y, this.se.z - this.z, getSquare)) {
            this.se = null;
        }
        if (this.nw != null && this.testPathFindAdjacent(null, this.nw.x - this.x, this.nw.y - this.y, this.nw.z - this.z, getSquare)) {
            this.nw = null;
        }
        if (this.ne != null && this.testPathFindAdjacent(null, this.ne.x - this.x, this.ne.y - this.y, this.ne.z - this.z, getSquare)) {
            this.ne = null;
        }
    }

    public IsoObject getContainerItem(String string) {
        int n = this.getObjects().size();
        IsoObject[] isoObjectArray = this.getObjects().getElements();
        for (int i = 0; i < n; ++i) {
            IsoObject isoObject = isoObjectArray[i];
            if (isoObject.getContainer() == null || !string.equals(isoObject.getContainer().getType())) continue;
            return isoObject;
        }
        return null;
    }

    @Deprecated
    public void StartFire() {
    }

    public void explode() {
        IsoFireManager.explode(this.getCell(), this, 100000);
    }

    public int getHourLastSeen() {
        return this.hourLastSeen;
    }

    public float getHoursSinceLastSeen() {
        return (float)GameTime.instance.getWorldAgeHours() - (float)this.hourLastSeen;
    }

    public void CalcVisibility(int n) {
        float f;
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        ILighting iLighting = this.lighting[n];
        iLighting.bCanSee(false);
        iLighting.bCouldSee(false);
        if (!GameServer.bServer && (isoPlayer == null || isoPlayer.isDead() && isoPlayer.ReanimatedCorpse == null)) {
            iLighting.bSeen(true);
            iLighting.bCanSee(true);
            iLighting.bCouldSee(true);
            return;
        }
        if (isoPlayer == null) {
            return;
        }
        IsoGameCharacter.LightInfo lightInfo = isoPlayer.getLightInfo2();
        IsoGridSquare isoGridSquare = lightInfo.square;
        if (isoGridSquare == null) {
            return;
        }
        IsoChunk isoChunk = this.getChunk();
        if (isoChunk == null) {
            return;
        }
        IsoGridSquare.tempo.x = (float)this.x + 0.5f;
        IsoGridSquare.tempo.y = (float)this.y + 0.5f;
        IsoGridSquare.tempo2.x = lightInfo.x;
        IsoGridSquare.tempo2.y = lightInfo.y;
        IsoGridSquare.tempo2.x -= IsoGridSquare.tempo.x;
        IsoGridSquare.tempo2.y -= IsoGridSquare.tempo.y;
        Vector2 vector22 = tempo;
        float f2 = tempo2.getLength();
        tempo2.normalize();
        if (isoPlayer instanceof IsoSurvivor) {
            isoPlayer.setForwardDirection(vector22);
            lightInfo.angleX = vector22.x;
            lightInfo.angleY = vector22.y;
        }
        vector22.x = lightInfo.angleX;
        vector22.y = lightInfo.angleY;
        vector22.normalize();
        float f3 = tempo2.dot(vector22);
        if (isoGridSquare == this) {
            f3 = -1.0f;
        }
        if (!GameServer.bServer) {
            float f4 = isoPlayer.getStats().fatigue - 0.6f;
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            f4 *= 2.5f;
            if (isoPlayer.Traits.HardOfHearing.isSet() && f4 < 0.7f) {
                f4 = 0.7f;
            }
            f = 2.0f;
            if (isoPlayer.Traits.KeenHearing.isSet()) {
                f += 3.0f;
            }
            if (f2 < f * (1.0f - f4) && !isoPlayer.Traits.Deaf.isSet()) {
                f3 = -1.0f;
            }
        }
        LosUtil.TestResults testResults = LosUtil.lineClearCached(this.getCell(), this.x, this.y, this.z, (int)lightInfo.x, (int)lightInfo.y, (int)lightInfo.z, false, n);
        f = -0.2f;
        if ((f -= isoPlayer.getStats().fatigue - 0.6f) > -0.2f) {
            f = -0.2f;
        }
        if (isoPlayer.getStats().fatigue >= 1.0f) {
            f -= 0.2f;
        }
        if (isoPlayer.getMoodles().getMoodleLevel(MoodleType.Panic) == 4) {
            f -= 0.2f;
        }
        if (f < -0.9f) {
            f = -0.9f;
        }
        if (isoPlayer.Traits.EagleEyed.isSet()) {
            f += 0.2f;
        }
        if (isoPlayer instanceof IsoPlayer && isoPlayer.getVehicle() != null) {
            f = 1.0f;
        }
        if (f3 > f || testResults == LosUtil.TestResults.Blocked) {
            if (testResults == LosUtil.TestResults.Blocked) {
                iLighting.bCouldSee(false);
            } else {
                iLighting.bCouldSee(true);
            }
            if (!GameServer.bServer) {
                if (iLighting.bSeen()) {
                    float f5 = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex());
                    f5 = !iLighting.bCouldSee() ? (f5 *= 0.5f) : (f5 *= 0.94f);
                    if (this.room == null && isoGridSquare.getRoom() == null) {
                        iLighting.targetDarkMulti(f5);
                    } else if (this.room != null && isoGridSquare.getRoom() != null && this.room.building == isoGridSquare.getRoom().building) {
                        if (this.room != isoGridSquare.getRoom() && !iLighting.bCouldSee()) {
                            iLighting.targetDarkMulti(0.0f);
                        } else {
                            iLighting.targetDarkMulti(f5);
                        }
                    } else if (this.room == null) {
                        iLighting.targetDarkMulti(f5 / 2.0f);
                    } else if (iLighting.lampostTotalR() + iLighting.lampostTotalG() + iLighting.lampostTotalB() == 0.0f) {
                        iLighting.targetDarkMulti(0.0f);
                    }
                    if (this.room != null) {
                        iLighting.targetDarkMulti(iLighting.targetDarkMulti() * 0.7f);
                    }
                } else {
                    iLighting.targetDarkMulti(0.0f);
                    iLighting.darkMulti(0.0f);
                }
            }
        } else {
            iLighting.bCouldSee(true);
            if (this.room != null && this.room.def != null && !this.room.def.bExplored) {
                int n2 = 10;
                if (lightInfo.square != null && lightInfo.square.getBuilding() == this.room.building) {
                    n2 = 50;
                }
                if (!(GameServer.bServer && isoPlayer instanceof IsoPlayer && isoPlayer.isGhostMode() || !(IsoUtils.DistanceManhatten(lightInfo.x, lightInfo.y, this.x, this.y) < (float)n2) || this.z != (int)lightInfo.z)) {
                    if (GameServer.bServer) {
                        DebugLog.log(DebugType.Zombie, "bExplored room=" + this.room.def.ID);
                    }
                    this.room.def.bExplored = true;
                    this.room.onSee();
                    this.room.seen = 0;
                }
            }
            if (!GameClient.bClient) {
                Meta.instance.dealWithSquareSeen(this);
            }
            iLighting.bCanSee(true);
            iLighting.bSeen(true);
            iLighting.targetDarkMulti(1.0f);
        }
        if (f3 > f) {
            iLighting.targetDarkMulti(iLighting.targetDarkMulti() * 0.85f);
        }
        if (GameServer.bServer) {
            return;
        }
        for (int i = 0; i < lightInfo.torches.size(); ++i) {
            IsoGameCharacter.TorchInfo torchInfo = lightInfo.torches.get(i);
            IsoGridSquare.tempo2.x = torchInfo.x;
            IsoGridSquare.tempo2.y = torchInfo.y;
            IsoGridSquare.tempo2.x -= (float)this.x + 0.5f;
            IsoGridSquare.tempo2.y -= (float)this.y + 0.5f;
            f2 = tempo2.getLength();
            tempo2.normalize();
            vector22.x = torchInfo.angleX;
            vector22.y = torchInfo.angleY;
            vector22.normalize();
            f3 = tempo2.dot(vector22);
            if ((int)torchInfo.x == this.getX() && (int)torchInfo.y == this.getY() && (int)torchInfo.z == this.getZ()) {
                f3 = -1.0f;
            }
            boolean bl = false;
            if (IsoUtils.DistanceManhatten(this.getX(), this.getY(), torchInfo.x, torchInfo.y) < torchInfo.dist && (torchInfo.bCone && f3 < -torchInfo.dot || f3 == -1.0f || !torchInfo.bCone && f3 < 0.8f)) {
                bl = true;
            }
            if (!(torchInfo.bCone && f2 < torchInfo.dist) && (torchInfo.bCone || !(f2 < torchInfo.dist)) || !iLighting.bCanSee() || !bl || this.z != (int)isoPlayer.getZ()) continue;
            float f6 = f2 / torchInfo.dist;
            if (f6 > 1.0f) {
                f6 = 1.0f;
            }
            if (f6 < 0.0f) {
                f6 = 0.0f;
            }
            iLighting.targetDarkMulti(iLighting.targetDarkMulti() + torchInfo.strength * (1.0f - f6) * 3.0f);
            if (iLighting.targetDarkMulti() > 2.5f) {
                iLighting.targetDarkMulti(2.5f);
            }
            torchTimer = lightInfo.time;
        }
    }

    private LosUtil.TestResults DoDiagnalCheck(int n, int n2, int n3, boolean bl) {
        LosUtil.TestResults testResults = this.testVisionAdjacent(n, 0, n3, false, bl);
        if (testResults == LosUtil.TestResults.Blocked) {
            return LosUtil.TestResults.Blocked;
        }
        LosUtil.TestResults testResults2 = this.testVisionAdjacent(0, n2, n3, false, bl);
        if (testResults2 == LosUtil.TestResults.Blocked) {
            return LosUtil.TestResults.Blocked;
        }
        if (testResults == LosUtil.TestResults.ClearThroughWindow || testResults2 == LosUtil.TestResults.ClearThroughWindow) {
            return LosUtil.TestResults.ClearThroughWindow;
        }
        return this.testVisionAdjacent(n, n2, n3, false, bl);
    }

    boolean HasNoCharacters() {
        int n;
        for (n = 0; n < this.MovingObjects.size(); ++n) {
            if (!(this.MovingObjects.get(n) instanceof IsoGameCharacter)) continue;
            return false;
        }
        for (n = 0; n < this.SpecialObjects.size(); ++n) {
            if (!(this.SpecialObjects.get(n) instanceof IsoBarricade)) continue;
            return false;
        }
        return true;
    }

    public IsoZombie getZombie() {
        for (int i = 0; i < this.MovingObjects.size(); ++i) {
            if (!(this.MovingObjects.get(i) instanceof IsoZombie)) continue;
            return (IsoZombie)this.MovingObjects.get(i);
        }
        return null;
    }

    public IsoPlayer getPlayer() {
        for (int i = 0; i < this.MovingObjects.size(); ++i) {
            if (!(this.MovingObjects.get(i) instanceof IsoPlayer)) continue;
            return (IsoPlayer)this.MovingObjects.get(i);
        }
        return null;
    }

    public static float getDarkStep() {
        return darkStep;
    }

    public static void setDarkStep(float f) {
        darkStep = f;
    }

    public static int getRecalcLightTime() {
        return RecalcLightTime;
    }

    public static void setRecalcLightTime(int n) {
        RecalcLightTime = n;
    }

    public static int getLightcache() {
        return lightcache;
    }

    public static void setLightcache(int n) {
        lightcache = n;
    }

    public boolean isCouldSee(int n) {
        return this.lighting[n].bCouldSee();
    }

    public void setCouldSee(int n, boolean bl) {
        this.lighting[n].bCouldSee(bl);
    }

    public boolean isCanSee(int n) {
        return this.lighting[n].bCanSee();
    }

    public void setCanSee(int n, boolean bl) {
        this.lighting[n].bCanSee(bl);
    }

    public IsoCell getCell() {
        return IsoWorld.instance.CurrentCell;
    }

    public IsoGridSquare getE() {
        return this.e;
    }

    public void setE(IsoGridSquare isoGridSquare) {
        this.e = isoGridSquare;
    }

    public ArrayList<Float> getLightInfluenceB() {
        return this.LightInfluenceB;
    }

    public void setLightInfluenceB(ArrayList<Float> arrayList) {
        this.LightInfluenceB = arrayList;
    }

    public ArrayList<Float> getLightInfluenceG() {
        return this.LightInfluenceG;
    }

    public void setLightInfluenceG(ArrayList<Float> arrayList) {
        this.LightInfluenceG = arrayList;
    }

    public ArrayList<Float> getLightInfluenceR() {
        return this.LightInfluenceR;
    }

    public void setLightInfluenceR(ArrayList<Float> arrayList) {
        this.LightInfluenceR = arrayList;
    }

    public ArrayList<IsoMovingObject> getStaticMovingObjects() {
        return this.StaticMovingObjects;
    }

    public ArrayList<IsoMovingObject> getMovingObjects() {
        return this.MovingObjects;
    }

    public IsoGridSquare getN() {
        return this.n;
    }

    public void setN(IsoGridSquare isoGridSquare) {
        this.n = isoGridSquare;
    }

    public PZArrayList<IsoObject> getObjects() {
        return this.Objects;
    }

    public PropertyContainer getProperties() {
        return this.Properties;
    }

    public IsoRoom getRoom() {
        if (this.roomID == -1) {
            return null;
        }
        return this.room;
    }

    public void setRoom(IsoRoom isoRoom) {
        this.room = isoRoom;
    }

    public IsoBuilding getBuilding() {
        IsoRoom isoRoom = this.getRoom();
        if (isoRoom != null) {
            return isoRoom.getBuilding();
        }
        return null;
    }

    public IsoGridSquare getS() {
        return this.s;
    }

    public void setS(IsoGridSquare isoGridSquare) {
        this.s = isoGridSquare;
    }

    public ArrayList<IsoObject> getSpecialObjects() {
        return this.SpecialObjects;
    }

    public IsoGridSquare getW() {
        return this.w;
    }

    public void setW(IsoGridSquare isoGridSquare) {
        this.w = isoGridSquare;
    }

    public float getLampostTotalR() {
        return this.lighting[0].lampostTotalR();
    }

    public void setLampostTotalR(float f) {
        this.lighting[0].lampostTotalR(f);
    }

    public float getLampostTotalG() {
        return this.lighting[0].lampostTotalG();
    }

    public void setLampostTotalG(float f) {
        this.lighting[0].lampostTotalG(f);
    }

    public float getLampostTotalB() {
        return this.lighting[0].lampostTotalB();
    }

    public void setLampostTotalB(float f) {
        this.lighting[0].lampostTotalB(f);
    }

    public boolean isSeen(int n) {
        return this.lighting[n].bSeen();
    }

    public void setIsSeen(int n, boolean bl) {
        this.lighting[n].bSeen(bl);
    }

    public float getDarkMulti(int n) {
        return this.lighting[n].darkMulti();
    }

    public void setDarkMulti(int n, float f) {
        this.lighting[n].darkMulti(f);
    }

    public float getTargetDarkMulti(int n) {
        return this.lighting[n].targetDarkMulti();
    }

    public void setTargetDarkMulti(int n, float f) {
        this.lighting[n].targetDarkMulti(f);
    }

    public void setX(int n) {
        this.x = n;
        this.CachedScreenValue = -1;
    }

    public void setY(int n) {
        this.y = n;
        this.CachedScreenValue = -1;
    }

    public void setZ(int n) {
        this.z = n;
        this.CachedScreenValue = -1;
    }

    public ArrayList<IsoGameCharacter> getDeferedCharacters() {
        return this.DeferedCharacters;
    }

    public void addDeferredCharacter(IsoGameCharacter isoGameCharacter) {
        if (this.DeferredCharacterTick != this.getCell().DeferredCharacterTick) {
            if (!this.DeferedCharacters.isEmpty()) {
                this.DeferedCharacters.clear();
            }
            this.DeferredCharacterTick = this.getCell().DeferredCharacterTick;
        }
        this.DeferedCharacters.add(isoGameCharacter);
    }

    public boolean isCacheIsFree() {
        return this.CacheIsFree;
    }

    public void setCacheIsFree(boolean bl) {
        this.CacheIsFree = bl;
    }

    public boolean isCachedIsFree() {
        return this.CachedIsFree;
    }

    public void setCachedIsFree(boolean bl) {
        this.CachedIsFree = bl;
    }

    public static boolean isbDoSlowPathfinding() {
        return bDoSlowPathfinding;
    }

    public static void setbDoSlowPathfinding(boolean bl) {
        bDoSlowPathfinding = bl;
    }

    public boolean isSolidFloorCached() {
        return this.SolidFloorCached;
    }

    public void setSolidFloorCached(boolean bl) {
        this.SolidFloorCached = bl;
    }

    public boolean isSolidFloor() {
        return this.SolidFloor;
    }

    public void setSolidFloor(boolean bl) {
        this.SolidFloor = bl;
    }

    public static ColorInfo getDefColorInfo() {
        return defColorInfo;
    }

    public boolean isOutside() {
        return this.Properties.Is(IsoFlagType.exterior);
    }

    public boolean HasPushable() {
        int n = this.MovingObjects.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.MovingObjects.get(i) instanceof IsoPushableObject)) continue;
            return true;
        }
        return false;
    }

    public void setRoomID(int n) {
        this.roomID = n;
        if (n != -1) {
            this.getProperties().UnSet(IsoFlagType.exterior);
            this.room = this.chunk.getRoom(n);
        }
    }

    public int getRoomID() {
        return this.roomID;
    }

    public boolean getCanSee(int n) {
        return this.lighting[n].bCanSee();
    }

    public boolean getSeen(int n) {
        return this.lighting[n].bSeen();
    }

    public IsoChunk getChunk() {
        return this.chunk;
    }

    public IsoObject getDoorOrWindow(boolean bl) {
        for (int i = this.SpecialObjects.size() - 1; i >= 0; --i) {
            IsoObject isoObject = this.SpecialObjects.get(i);
            if (isoObject instanceof IsoDoor && ((IsoDoor)isoObject).north == bl) {
                return isoObject;
            }
            if (isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).north == bl && (((IsoThumpable)isoObject).isDoor() || ((IsoThumpable)isoObject).isWindow())) {
                return isoObject;
            }
            if (!(isoObject instanceof IsoWindow) || ((IsoWindow)isoObject).north != bl) continue;
            return isoObject;
        }
        return null;
    }

    public IsoObject getDoorOrWindowOrWindowFrame(IsoDirections isoDirections, boolean bl) {
        for (int i = this.Objects.size() - 1; i >= 0; --i) {
            IsoObject isoObject = this.Objects.get(i);
            IsoDoor isoDoor = Type.tryCastTo(isoObject, IsoDoor.class);
            IsoThumpable isoThumpable = Type.tryCastTo(isoObject, IsoThumpable.class);
            IsoWindow isoWindow = Type.tryCastTo(isoObject, IsoWindow.class);
            if (isoDoor != null && isoDoor.getSpriteEdge(bl) == isoDirections) {
                return isoObject;
            }
            if (isoThumpable != null && isoThumpable.getSpriteEdge(bl) == isoDirections) {
                return isoObject;
            }
            if (isoWindow != null) {
                if (isoWindow.north && isoDirections == IsoDirections.N) {
                    return isoObject;
                }
                if (!isoWindow.north && isoDirections == IsoDirections.W) {
                    return isoObject;
                }
            }
            if (!IsoWindowFrame.isWindowFrame(isoObject)) continue;
            if (IsoWindowFrame.isWindowFrame(isoObject, true) && isoDirections == IsoDirections.N) {
                return isoObject;
            }
            if (!IsoWindowFrame.isWindowFrame(isoObject, false) || isoDirections != IsoDirections.W) continue;
            return isoObject;
        }
        return null;
    }

    public IsoObject getOpenDoor(IsoDirections isoDirections) {
        for (int i = 0; i < this.SpecialObjects.size(); ++i) {
            IsoObject isoObject = this.SpecialObjects.get(i);
            IsoDoor isoDoor = Type.tryCastTo(isoObject, IsoDoor.class);
            IsoThumpable isoThumpable = Type.tryCastTo(isoObject, IsoThumpable.class);
            if (isoDoor != null && isoDoor.open && isoDoor.getSpriteEdge(false) == isoDirections) {
                return isoDoor;
            }
            if (isoThumpable == null || !isoThumpable.open || isoThumpable.getSpriteEdge(false) != isoDirections) continue;
            return isoThumpable;
        }
        return null;
    }

    public void removeWorldObject(IsoWorldInventoryObject isoWorldInventoryObject) {
        if (isoWorldInventoryObject == null) {
            return;
        }
        isoWorldInventoryObject.removeFromWorld();
        isoWorldInventoryObject.removeFromSquare();
    }

    public void removeAllWorldObjects() {
        for (int i = 0; i < this.getWorldObjects().size(); ++i) {
            IsoObject isoObject = this.getWorldObjects().get(i);
            isoObject.removeFromWorld();
            isoObject.removeFromSquare();
            --i;
        }
    }

    public ArrayList<IsoWorldInventoryObject> getWorldObjects() {
        return this.WorldObjects;
    }

    public PZArrayList<IsoObject> getLocalTemporaryObjects() {
        return this.localTemporaryObjects;
    }

    public KahluaTable getModData() {
        if (this.table == null) {
            this.table = LuaManager.platform.newTable();
        }
        return this.table;
    }

    public boolean hasModData() {
        return this.table != null && !this.table.isEmpty();
    }

    public ZomboidBitFlag getHasTypes() {
        return this.hasTypes;
    }

    public void setVertLight(int n, int n2, int n3) {
        this.lighting[n3].lightverts(n, n2);
    }

    public int getVertLight(int n, int n2) {
        return this.lighting[n2].lightverts(n);
    }

    public void setRainDrop(IsoRaindrop isoRaindrop) {
        this.RainDrop = isoRaindrop;
    }

    public IsoRaindrop getRainDrop() {
        return this.RainDrop;
    }

    public void setRainSplash(IsoRainSplash isoRainSplash) {
        this.RainSplash = isoRainSplash;
    }

    public IsoRainSplash getRainSplash() {
        return this.RainSplash;
    }

    public IsoMetaGrid.Zone getZone() {
        return this.zone;
    }

    public String getZoneType() {
        if (this.zone != null) {
            return this.zone.getType();
        }
        return null;
    }

    public boolean isOverlayDone() {
        return this.overlayDone;
    }

    public void setOverlayDone(boolean bl) {
        this.overlayDone = bl;
    }

    public ErosionData.Square getErosionData() {
        if (this.erosion == null) {
            this.erosion = new ErosionData.Square();
        }
        return this.erosion;
    }

    public void disableErosion() {
        ErosionData.Square square = this.getErosionData();
        if (square != null && !square.doNothing) {
            square.doNothing = true;
        }
    }

    public void removeErosionObject(String string) {
        if (this.erosion == null) {
            return;
        }
        if ("WallVines".equals(string)) {
            for (int i = 0; i < this.erosion.regions.size(); ++i) {
                ErosionCategory.Data data = this.erosion.regions.get(i);
                if (data.regionID != 2 || data.categoryID != 0) continue;
                this.erosion.regions.remove(i);
                break;
            }
        }
    }

    public void syncIsoTrap(HandWeapon handWeapon) {
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.AddExplosiveTrap.doPacket(byteBufferWriter);
        byteBufferWriter.putInt(this.getX());
        byteBufferWriter.putInt(this.getY());
        byteBufferWriter.putInt(this.getZ());
        try {
            handWeapon.saveWithSize(byteBufferWriter.bb, false);
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        PacketTypes.PacketType.AddExplosiveTrap.send(GameClient.connection);
    }

    public void drawCircleExplosion(int n, IsoTrap isoTrap, IsoTrap.ExplosionMode explosionMode) {
        if (n > 15) {
            n = 15;
        }
        for (int i = this.getX() - n; i <= this.getX() + n; ++i) {
            for (int j = this.getY() - n; j <= this.getY() + n; ++j) {
                IsoGridSquare isoGridSquare;
                LosUtil.TestResults testResults;
                if (IsoUtils.DistanceTo((float)i + 0.5f, (float)j + 0.5f, (float)this.getX() + 0.5f, (float)this.getY() + 0.5f) > (float)n || (testResults = LosUtil.lineClear(this.getCell(), (int)isoTrap.getX(), (int)isoTrap.getY(), (int)isoTrap.getZ(), i, j, this.z, false)) == LosUtil.TestResults.Blocked || testResults == LosUtil.TestResults.ClearThroughClosedDoor || (isoGridSquare = this.getCell().getGridSquare(i, j, this.getZ())) == null || NonPvpZone.getNonPvpZone(isoGridSquare.getX(), isoGridSquare.getY()) != null) continue;
                if (explosionMode == IsoTrap.ExplosionMode.Smoke) {
                    if (!GameClient.bClient && Rand.Next(2) == 0) {
                        IsoFireManager.StartSmoke(this.getCell(), isoGridSquare, true, 40, 0);
                    }
                    isoGridSquare.smoke();
                }
                if (explosionMode == IsoTrap.ExplosionMode.Explosion) {
                    if (!GameClient.bClient && isoTrap.getExplosionPower() > 0 && Rand.Next(80 - isoTrap.getExplosionPower()) <= 0) {
                        isoGridSquare.Burn();
                    }
                    isoGridSquare.explosion(isoTrap);
                    if (!GameClient.bClient && isoTrap.getExplosionPower() > 0 && Rand.Next(100 - isoTrap.getExplosionPower()) == 0) {
                        IsoFireManager.StartFire(this.getCell(), isoGridSquare, true, 20);
                    }
                }
                if (explosionMode == IsoTrap.ExplosionMode.Fire && !GameClient.bClient && Rand.Next(100 - isoTrap.getFirePower()) == 0) {
                    IsoFireManager.StartFire(this.getCell(), isoGridSquare, true, 40);
                }
                if (explosionMode != IsoTrap.ExplosionMode.Sensor) continue;
                isoGridSquare.setTrapPositionX(this.getX());
                isoGridSquare.setTrapPositionY(this.getY());
                isoGridSquare.setTrapPositionZ(this.getZ());
            }
        }
    }

    public void explosion(IsoTrap isoTrap) {
        if (GameServer.bServer && isoTrap.isInstantExplosion()) {
            return;
        }
        for (int i = 0; i < this.getMovingObjects().size(); ++i) {
            IsoMovingObject isoMovingObject = this.getMovingObjects().get(i);
            if (!(isoMovingObject instanceof IsoGameCharacter)) continue;
            if (GameServer.bServer || !(isoMovingObject instanceof IsoZombie) || ((IsoZombie)isoMovingObject).isLocal()) {
                int n = Math.min(isoTrap.getExplosionPower(), 80);
                isoMovingObject.Hit((HandWeapon)InventoryItemFactory.CreateItem("Base.Axe"), IsoWorld.instance.CurrentCell.getFakeZombieForHit(), Rand.Next((float)n / 30.0f, (float)n / 30.0f * 2.0f) + isoTrap.getExtraDamage(), false, 1.0f);
                if (isoTrap.getExplosionPower() > 0) {
                    boolean bl;
                    boolean bl2 = bl = !(isoMovingObject instanceof IsoZombie);
                    while (bl) {
                        bl = false;
                        BodyPart bodyPart = ((IsoGameCharacter)isoMovingObject).getBodyDamage().getBodyPart(BodyPartType.FromIndex(Rand.Next(15)));
                        bodyPart.setBurned();
                        if (Rand.Next((100 - n) / 2) != 0) continue;
                        bl = true;
                    }
                }
            }
            if (!GameClient.bClient || !(isoMovingObject instanceof IsoZombie) || !((IsoZombie)isoMovingObject).isRemoteZombie()) continue;
            isoMovingObject.Hit((HandWeapon)InventoryItemFactory.CreateItem("Base.Axe"), IsoWorld.instance.CurrentCell.getFakeZombieForHit(), 0.0f, true, 0.0f);
        }
    }

    public void smoke() {
        for (int i = 0; i < this.getMovingObjects().size(); ++i) {
            IsoMovingObject isoMovingObject = this.getMovingObjects().get(i);
            if (!(isoMovingObject instanceof IsoZombie)) continue;
            ((IsoZombie)isoMovingObject).setTarget(null);
            ((IsoZombie)isoMovingObject).changeState(ZombieIdleState.instance());
        }
    }

    public void explodeTrap() {
        IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.getTrapPositionX(), this.getTrapPositionY(), this.getTrapPositionZ());
        if (isoGridSquare != null) {
            for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
                IsoObject isoObject = isoGridSquare.getObjects().get(i);
                if (!(isoObject instanceof IsoTrap)) continue;
                IsoTrap isoTrap = (IsoTrap)isoObject;
                isoTrap.triggerExplosion(false);
                IsoGridSquare isoGridSquare2 = null;
                int n = isoTrap.getSensorRange();
                for (int j = isoGridSquare.getX() - n; j <= isoGridSquare.getX() + n; ++j) {
                    for (int k = isoGridSquare.getY() - n; k <= isoGridSquare.getY() + n; ++k) {
                        if (!(IsoUtils.DistanceTo((float)j + 0.5f, (float)k + 0.5f, (float)isoGridSquare.getX() + 0.5f, (float)isoGridSquare.getY() + 0.5f) <= (float)n) || (isoGridSquare2 = this.getCell().getGridSquare(j, k, this.getZ())) == null) continue;
                        isoGridSquare2.setTrapPositionX(-1);
                        isoGridSquare2.setTrapPositionY(-1);
                        isoGridSquare2.setTrapPositionZ(-1);
                    }
                }
                return;
            }
        }
    }

    public int getTrapPositionX() {
        return this.trapPositionX;
    }

    public void setTrapPositionX(int n) {
        this.trapPositionX = n;
    }

    public int getTrapPositionY() {
        return this.trapPositionY;
    }

    public void setTrapPositionY(int n) {
        this.trapPositionY = n;
    }

    public int getTrapPositionZ() {
        return this.trapPositionZ;
    }

    public void setTrapPositionZ(int n) {
        this.trapPositionZ = n;
    }

    public boolean haveElectricity() {
        if ((this.chunk == null || !this.chunk.bLoaded) && this.haveElectricity) {
            return true;
        }
        if (!SandboxOptions.getInstance().AllowExteriorGenerator.getValue() && this.Is(IsoFlagType.exterior)) {
            return false;
        }
        return this.chunk != null && this.chunk.isGeneratorPoweringSquare(this.x, this.y, this.z);
    }

    public void setHaveElectricity(boolean bl) {
        if (!bl) {
            this.haveElectricity = false;
        }
        if (this.getObjects() != null) {
            for (int i = 0; i < this.getObjects().size(); ++i) {
                if (!(this.getObjects().get(i) instanceof IsoLightSwitch)) continue;
                ((IsoLightSwitch)this.getObjects().get(i)).update();
            }
        }
    }

    public IsoGenerator getGenerator() {
        if (this.getSpecialObjects() != null) {
            for (int i = 0; i < this.getSpecialObjects().size(); ++i) {
                if (!(this.getSpecialObjects().get(i) instanceof IsoGenerator)) continue;
                return (IsoGenerator)this.getSpecialObjects().get(i);
            }
        }
        return null;
    }

    public void stopFire() {
        IsoFireManager.RemoveAllOn(this);
        this.getProperties().Set(IsoFlagType.burntOut);
        this.getProperties().UnSet(IsoFlagType.burning);
        this.burntOut = true;
    }

    public void transmitStopFire() {
        if (GameClient.bClient) {
            GameClient.sendStopFire(this);
        }
    }

    public long playSound(String string) {
        BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter((float)this.x + 0.5f, (float)this.y + 0.5f, this.z);
        return baseSoundEmitter.playSound(string);
    }

    @Deprecated
    public long playSound(String string, boolean bl) {
        BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter((float)this.x + 0.5f, (float)this.y + 0.5f, this.z);
        return baseSoundEmitter.playSound(string, bl);
    }

    public void FixStackableObjects() {
        IsoObject isoObject = null;
        for (int i = 0; i < this.Objects.size(); ++i) {
            IsoSprite isoSprite;
            IsoObject isoObject2 = this.Objects.get(i);
            if (isoObject2 instanceof IsoWorldInventoryObject || isoObject2.sprite == null) continue;
            PropertyContainer propertyContainer = isoObject2.sprite.getProperties();
            if (propertyContainer.getStackReplaceTileOffset() != 0) {
                isoObject2.sprite = IsoSprite.getSprite(IsoSpriteManager.instance, isoObject2.sprite.ID + propertyContainer.getStackReplaceTileOffset());
                if (isoObject2.sprite == null) continue;
                propertyContainer = isoObject2.sprite.getProperties();
            }
            if (propertyContainer.isTable() || propertyContainer.isTableTop()) {
                float f;
                float f2 = f = propertyContainer.isSurfaceOffset() ? (float)propertyContainer.getSurface() : 0.0f;
                if (isoObject != null) {
                    isoObject2.setRenderYOffset(isoObject.getRenderYOffset() + isoObject.getSurfaceOffset() - f);
                } else {
                    isoObject2.setRenderYOffset(0.0f - f);
                }
            }
            if (propertyContainer.isTable()) {
                isoObject = isoObject2;
            }
            if (!(isoObject2 instanceof IsoLightSwitch) || !propertyContainer.isTableTop() || isoObject == null || propertyContainer.Is("IgnoreSurfaceSnap")) continue;
            int n = PZMath.tryParseInt(propertyContainer.Val("Noffset"), 0);
            int n2 = PZMath.tryParseInt(propertyContainer.Val("Soffset"), 0);
            int n3 = PZMath.tryParseInt(propertyContainer.Val("Woffset"), 0);
            int n4 = PZMath.tryParseInt(propertyContainer.Val("Eoffset"), 0);
            String string = propertyContainer.Val("Facing");
            PropertyContainer propertyContainer2 = isoObject.getProperties();
            String string2 = propertyContainer2.Val("Facing");
            if (StringUtils.isNullOrWhitespace(string2) || string2.equals(string)) continue;
            int n5 = 0;
            if ("N".equals(string2)) {
                if (n != 0) {
                    n5 = n;
                } else if (n2 != 0) {
                    n5 = n2;
                }
            } else if ("S".equals(string2)) {
                if (n2 != 0) {
                    n5 = n2;
                } else if (n != 0) {
                    n5 = n;
                }
            } else if ("W".equals(string2)) {
                if (n3 != 0) {
                    n5 = n3;
                } else if (n4 != 0) {
                    n5 = n4;
                }
            } else if ("E".equals(string2)) {
                if (n4 != 0) {
                    n5 = n4;
                } else if (n3 != 0) {
                    n5 = n3;
                }
            }
            if (n5 == 0 || (isoSprite = IsoSpriteManager.instance.getSprite(isoObject2.sprite.ID + n5)) == null) continue;
            isoObject2.setSprite(isoSprite);
        }
    }

    public void fixPlacedItemRenderOffsets() {
        IsoObject isoObject;
        int n;
        IsoObject[] isoObjectArray = this.Objects.getElements();
        int n2 = this.Objects.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            isoObject = isoObjectArray[n];
            int n4 = PZMath.roundToInt(isoObject.getSurfaceOffsetNoTable());
            if ((float)n4 <= 0.0f || PZArrayUtil.contains(SURFACE_OFFSETS, n3, n4)) continue;
            IsoGridSquare.SURFACE_OFFSETS[n3++] = n4;
        }
        if (n3 == 0) {
            IsoGridSquare.SURFACE_OFFSETS[n3++] = 0;
        }
        for (n = 0; n < n2; ++n) {
            isoObject = isoObjectArray[n];
            IsoWorldInventoryObject isoWorldInventoryObject = Type.tryCastTo(isoObject, IsoWorldInventoryObject.class);
            if (isoWorldInventoryObject == null) continue;
            int n5 = PZMath.roundToInt(isoWorldInventoryObject.zoff * 96.0f);
            int n6 = 0;
            for (int i = 0; i < n3; ++i) {
                if (n5 <= SURFACE_OFFSETS[i]) {
                    n6 = SURFACE_OFFSETS[i];
                    break;
                }
                n6 = SURFACE_OFFSETS[i];
                if (i < n3 - 1 && n5 < SURFACE_OFFSETS[i + 1]) break;
            }
            isoWorldInventoryObject.zoff = (float)n6 / 96.0f;
        }
    }

    public BaseVehicle getVehicleContainer() {
        int n = (int)(((float)this.x - 4.0f) / 10.0f);
        int n2 = (int)(((float)this.y - 4.0f) / 10.0f);
        int n3 = (int)Math.ceil(((float)this.x + 4.0f) / 10.0f);
        int n4 = (int)Math.ceil(((float)this.y + 4.0f) / 10.0f);
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunk(j, i);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if (!baseVehicle.isIntersectingSquare(this.x, this.y, this.z)) continue;
                    return baseVehicle;
                }
            }
        }
        return null;
    }

    public boolean isVehicleIntersecting() {
        int n = (int)(((float)this.x - 4.0f) / 10.0f);
        int n2 = (int)(((float)this.y - 4.0f) / 10.0f);
        int n3 = (int)Math.ceil(((float)this.x + 4.0f) / 10.0f);
        int n4 = (int)Math.ceil(((float)this.y + 4.0f) / 10.0f);
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunk(j, i);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if (!baseVehicle.isIntersectingSquare(this.x, this.y, this.z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public IsoCompost getCompost() {
        if (this.getSpecialObjects() != null) {
            for (int i = 0; i < this.getSpecialObjects().size(); ++i) {
                if (!(this.getSpecialObjects().get(i) instanceof IsoCompost)) continue;
                return (IsoCompost)this.getSpecialObjects().get(i);
            }
        }
        return null;
    }

    public void setIsoWorldRegion(IsoWorldRegion isoWorldRegion) {
        this.hasSetIsoWorldRegion = isoWorldRegion != null;
        this.isoWorldRegion = isoWorldRegion;
    }

    public IWorldRegion getIsoWorldRegion() {
        if (GameServer.bServer) {
            return IsoRegions.getIsoWorldRegion(this.x, this.y, this.z);
        }
        if (!this.hasSetIsoWorldRegion) {
            this.isoWorldRegion = IsoRegions.getIsoWorldRegion(this.x, this.y, this.z);
            this.hasSetIsoWorldRegion = true;
        }
        return this.isoWorldRegion;
    }

    public void ResetIsoWorldRegion() {
        this.isoWorldRegion = null;
        this.hasSetIsoWorldRegion = false;
    }

    public boolean isInARoom() {
        return this.getRoom() != null || this.getIsoWorldRegion() != null && this.getIsoWorldRegion().isPlayerRoom();
    }

    public int getRoomSize() {
        if (this.getRoom() != null) {
            return this.getRoom().getSquares().size();
        }
        if (this.getIsoWorldRegion() != null && this.getIsoWorldRegion().isPlayerRoom()) {
            return this.getIsoWorldRegion().getSquareSize();
        }
        return -1;
    }

    public int getWallType() {
        IsoGridSquare isoGridSquare;
        IsoGridSquare isoGridSquare2;
        int n = 0;
        if (this.getProperties().Is(IsoFlagType.WallN)) {
            n |= 1;
        }
        if (this.getProperties().Is(IsoFlagType.WallW)) {
            n |= 4;
        }
        if (this.getProperties().Is(IsoFlagType.WallNW)) {
            n |= 5;
        }
        if ((isoGridSquare2 = this.nav[IsoDirections.E.index()]) != null && (isoGridSquare2.getProperties().Is(IsoFlagType.WallW) || isoGridSquare2.getProperties().Is(IsoFlagType.WallNW))) {
            n |= 8;
        }
        if ((isoGridSquare = this.nav[IsoDirections.S.index()]) != null && (isoGridSquare.getProperties().Is(IsoFlagType.WallN) || isoGridSquare.getProperties().Is(IsoFlagType.WallNW))) {
            n |= 2;
        }
        return n;
    }

    public int getPuddlesDir() {
        byte by = PuddlesDirection.PUDDLES_DIR_ALL;
        if (this.isInARoom()) {
            return PuddlesDirection.PUDDLES_DIR_NONE;
        }
        for (int i = 0; i < this.getObjects().size(); ++i) {
            IsoObject isoObject = this.getObjects().get(i);
            if (isoObject.AttachedAnimSprite == null) continue;
            for (int j = 0; j < isoObject.AttachedAnimSprite.size(); ++j) {
                IsoSprite isoSprite = isoObject.AttachedAnimSprite.get((int)j).parentSprite;
                if (isoSprite.name == null) continue;
                if (isoSprite.name.equals("street_trafficlines_01_2") || isoSprite.name.equals("street_trafficlines_01_6") || isoSprite.name.equals("street_trafficlines_01_22") || isoSprite.name.equals("street_trafficlines_01_32")) {
                    by = PuddlesDirection.PUDDLES_DIR_NW;
                }
                if (!isoSprite.name.equals("street_trafficlines_01_4") && !isoSprite.name.equals("street_trafficlines_01_0") && !isoSprite.name.equals("street_trafficlines_01_16")) continue;
                by = PuddlesDirection.PUDDLES_DIR_NE;
            }
        }
        return by;
    }

    public boolean haveFire() {
        int n = this.Objects.size();
        IsoObject[] isoObjectArray = this.Objects.getElements();
        for (int i = 0; i < n; ++i) {
            IsoObject isoObject = isoObjectArray[i];
            if (!(isoObject instanceof IsoFire)) continue;
            return true;
        }
        return false;
    }

    public IsoBuilding getRoofHideBuilding() {
        return this.roofHideBuilding;
    }

    public IsoGridSquare getAdjacentSquare(IsoDirections isoDirections) {
        return this.nav[isoDirections.index()];
    }

    public IsoGridSquare getAdjacentPathSquare(IsoDirections isoDirections) {
        switch (isoDirections) {
            case NW: {
                return this.nw;
            }
            case N: {
                return this.n;
            }
            case NE: {
                return this.ne;
            }
            case W: {
                return this.w;
            }
            case E: {
                return this.e;
            }
            case SW: {
                return this.sw;
            }
            case S: {
                return this.s;
            }
            case SE: {
                return this.se;
            }
        }
        return null;
    }

    public float getApparentZ(float f, float f2) {
        f = PZMath.clamp(f, 0.0f, 1.0f);
        f2 = PZMath.clamp(f2, 0.0f, 1.0f);
        if (this.Has(IsoObjectType.stairsTN)) {
            return (float)this.getZ() + PZMath.lerp(0.6666f, 1.0f, 1.0f - f2);
        }
        if (this.Has(IsoObjectType.stairsTW)) {
            return (float)this.getZ() + PZMath.lerp(0.6666f, 1.0f, 1.0f - f);
        }
        if (this.Has(IsoObjectType.stairsMN)) {
            return (float)this.getZ() + PZMath.lerp(0.3333f, 0.6666f, 1.0f - f2);
        }
        if (this.Has(IsoObjectType.stairsMW)) {
            return (float)this.getZ() + PZMath.lerp(0.3333f, 0.6666f, 1.0f - f);
        }
        if (this.Has(IsoObjectType.stairsBN)) {
            return (float)this.getZ() + PZMath.lerp(0.01f, 0.3333f, 1.0f - f2);
        }
        if (this.Has(IsoObjectType.stairsBW)) {
            return (float)this.getZ() + PZMath.lerp(0.01f, 0.3333f, 1.0f - f);
        }
        return this.getZ();
    }

    public float getTotalWeightOfItemsOnFloor() {
        float f = 0.0f;
        for (int i = 0; i < this.WorldObjects.size(); ++i) {
            InventoryItem inventoryItem = this.WorldObjects.get(i).getItem();
            if (inventoryItem == null) continue;
            f += inventoryItem.getUnequippedWeight();
        }
        return f;
    }

    public boolean getCollideMatrix(int n, int n2, int n3) {
        return IsoGridSquare.getMatrixBit(this.collideMatrix, n + 1, n2 + 1, n3 + 1);
    }

    public boolean getPathMatrix(int n, int n2, int n3) {
        return IsoGridSquare.getMatrixBit(this.pathMatrix, n + 1, n2 + 1, n3 + 1);
    }

    public boolean getVisionMatrix(int n, int n2, int n3) {
        return IsoGridSquare.getMatrixBit(this.visionMatrix, n + 1, n2 + 1, n3 + 1);
    }

    public void checkRoomSeen(int n) {
        IsoRoom isoRoom = this.getRoom();
        if (isoRoom == null || isoRoom.def == null || isoRoom.def.bExplored) {
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (isoPlayer == null) {
            return;
        }
        if (this.z != (int)isoPlayer.z) {
            return;
        }
        int n2 = 10;
        if (isoPlayer.getBuilding() == isoRoom.building) {
            n2 = 50;
        }
        if (IsoUtils.DistanceToSquared(isoPlayer.x, isoPlayer.y, (float)this.x + 0.5f, (float)this.y + 0.5f) < (float)(n2 * n2)) {
            isoRoom.def.bExplored = true;
            isoRoom.onSee();
            isoRoom.seen = 0;
        }
    }

    public boolean hasFlies() {
        return this.bHasFlies;
    }

    public void setHasFlies(boolean bl) {
        this.bHasFlies = bl;
    }

    public float getLightLevel(int n) {
        return (this.lighting[n].lightInfo().r + this.lighting[n].lightInfo().g + this.lighting[n].lightInfo().b) / 3.0f;
    }

    static {
        gridSquareCacheEmptyTimer = 0;
        darkStep = 0.06f;
        RecalcLightTime = 0;
        lightcache = 0;
        choices = new ArrayList();
        USE_WALL_SHADER = true;
        lightInfoTemp = new ColorInfo();
        lastLoaded = null;
        IDMax = -1;
        col = -1;
        path = -1;
        pathdoor = -1;
        vision = -1;
        tr = new Color(1, 1, 1, 1);
        tl = new Color(1, 1, 1, 1);
        br = new Color(1, 1, 1, 1);
        bl = new Color(1, 1, 1, 1);
        interp1 = new Color(1, 1, 1, 1);
        interp2 = new Color(1, 1, 1, 1);
        finalCol = new Color(1, 1, 1, 1);
        cellGetSquare = new CellGetSquare();
        UseSlowCollision = false;
        bDoSlowPathfinding = false;
        comp = (isoMovingObject, isoMovingObject2) -> isoMovingObject.compareToY((IsoMovingObject)isoMovingObject2);
        isOnScreenLast = false;
        rainsplashCache = new String[50];
        defColorInfo = new ColorInfo();
        blackColorInfo = new ColorInfo();
        colu = 0;
        coll = 0;
        colr = 0;
        colu2 = 0;
        coll2 = 0;
        colr2 = 0;
        CircleStencil = false;
        rmod = 0.0f;
        gmod = 0.0f;
        bmod = 0.0f;
        tempo = new Vector2();
        tempo2 = new Vector2();
        SURFACE_OFFSETS = new int[8];
    }

    public static interface ILighting {
        public int lightverts(int var1);

        public float lampostTotalR();

        public float lampostTotalG();

        public float lampostTotalB();

        public boolean bSeen();

        public boolean bCanSee();

        public boolean bCouldSee();

        public float darkMulti();

        public float targetDarkMulti();

        public ColorInfo lightInfo();

        public void lightverts(int var1, int var2);

        public void lampostTotalR(float var1);

        public void lampostTotalG(float var1);

        public void lampostTotalB(float var1);

        public void bSeen(boolean var1);

        public void bCanSee(boolean var1);

        public void bCouldSee(boolean var1);

        public void darkMulti(float var1);

        public void targetDarkMulti(float var1);

        public int resultLightCount();

        public ResultLight getResultLight(int var1);

        public void reset();
    }

    public static final class CircleStencilShader
    extends Shader {
        public static final CircleStencilShader instance = new CircleStencilShader();
        public int a_wallShadeColor = -1;

        public CircleStencilShader() {
            super("CircleStencil");
        }

        @Override
        protected void onCompileSuccess(ShaderProgram shaderProgram) {
            this.Start();
            this.a_wallShadeColor = GL20.glGetAttribLocation((int)this.getID(), (CharSequence)"a_wallShadeColor");
            shaderProgram.setSamplerUnit("texture", 0);
            shaderProgram.setSamplerUnit("CutawayStencil", 1);
            this.End();
        }
    }

    public static final class Lighting
    implements ILighting {
        private final int[] lightverts = new int[8];
        private float lampostTotalR = 0.0f;
        private float lampostTotalG = 0.0f;
        private float lampostTotalB = 0.0f;
        private boolean bSeen;
        private boolean bCanSee;
        private boolean bCouldSee;
        private float darkMulti;
        private float targetDarkMulti;
        private final ColorInfo lightInfo = new ColorInfo();

        @Override
        public int lightverts(int n) {
            return this.lightverts[n];
        }

        @Override
        public float lampostTotalR() {
            return this.lampostTotalR;
        }

        @Override
        public float lampostTotalG() {
            return this.lampostTotalG;
        }

        @Override
        public float lampostTotalB() {
            return this.lampostTotalB;
        }

        @Override
        public boolean bSeen() {
            return this.bSeen;
        }

        @Override
        public boolean bCanSee() {
            return this.bCanSee;
        }

        @Override
        public boolean bCouldSee() {
            return this.bCouldSee;
        }

        @Override
        public float darkMulti() {
            return this.darkMulti;
        }

        @Override
        public float targetDarkMulti() {
            return this.targetDarkMulti;
        }

        @Override
        public ColorInfo lightInfo() {
            return this.lightInfo;
        }

        @Override
        public void lightverts(int n, int n2) {
            this.lightverts[n] = n2;
        }

        @Override
        public void lampostTotalR(float f) {
            this.lampostTotalR = f;
        }

        @Override
        public void lampostTotalG(float f) {
            this.lampostTotalG = f;
        }

        @Override
        public void lampostTotalB(float f) {
            this.lampostTotalB = f;
        }

        @Override
        public void bSeen(boolean bl) {
            this.bSeen = bl;
        }

        @Override
        public void bCanSee(boolean bl) {
            this.bCanSee = bl;
        }

        @Override
        public void bCouldSee(boolean bl) {
            this.bCouldSee = bl;
        }

        @Override
        public void darkMulti(float f) {
            this.darkMulti = f;
        }

        @Override
        public void targetDarkMulti(float f) {
            this.targetDarkMulti = f;
        }

        @Override
        public int resultLightCount() {
            return 0;
        }

        @Override
        public ResultLight getResultLight(int n) {
            return null;
        }

        @Override
        public void reset() {
            this.lampostTotalR = 0.0f;
            this.lampostTotalG = 0.0f;
            this.lampostTotalB = 0.0f;
            this.bSeen = false;
            this.bCouldSee = false;
            this.bCanSee = false;
            this.targetDarkMulti = 0.0f;
            this.darkMulti = 0.0f;
            this.lightInfo.r = 0.0f;
            this.lightInfo.g = 0.0f;
            this.lightInfo.b = 0.0f;
            this.lightInfo.a = 1.0f;
        }
    }

    public static class CellGetSquare
    implements GetSquare {
        @Override
        public IsoGridSquare getGridSquare(int n, int n2, int n3) {
            return IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        }
    }

    public static interface GetSquare {
        public IsoGridSquare getGridSquare(int var1, int var2, int var3);
    }

    private static final class s_performance {
        static final PerformanceProfileProbe renderFloor = new PerformanceProfileProbe("IsoGridSquare.renderFloor", false);

        private s_performance() {
        }
    }

    public static class PuddlesDirection {
        public static byte PUDDLES_DIR_NONE = 1;
        public static byte PUDDLES_DIR_NE = (byte)2;
        public static byte PUDDLES_DIR_NW = (byte)4;
        public static byte PUDDLES_DIR_ALL = (byte)8;
    }

    public static final class NoCircleStencilShader {
        public static final NoCircleStencilShader instance = new NoCircleStencilShader();
        private ShaderProgram shaderProgram;
        public int ShaderID = -1;
        public int a_wallShadeColor = -1;

        private void initShader() {
            this.shaderProgram = ShaderProgram.createShaderProgram("NoCircleStencil", false, true);
            if (this.shaderProgram.isCompiled()) {
                this.ShaderID = this.shaderProgram.getShaderID();
                this.a_wallShadeColor = GL20.glGetAttribLocation((int)this.ShaderID, (CharSequence)"a_wallShadeColor");
            }
        }
    }

    private static interface RenderWallCallback {
        public void invoke(Texture var1, float var2, float var3);
    }

    public static final class ResultLight {
        public int id;
        public int x;
        public int y;
        public int z;
        public int radius;
        public float r;
        public float g;
        public float b;
        public static final int RLF_NONE = 0;
        public static final int RLF_ROOMLIGHT = 1;
        public static final int RLF_TORCH = 2;
        public int flags;

        public ResultLight copyFrom(ResultLight resultLight) {
            this.id = resultLight.id;
            this.x = resultLight.x;
            this.y = resultLight.y;
            this.z = resultLight.z;
            this.radius = resultLight.radius;
            this.r = resultLight.r;
            this.g = resultLight.g;
            this.b = resultLight.b;
            this.flags = resultLight.flags;
            return this;
        }
    }
}

