/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.areas.IsoBuilding;

public class IsoGridOcclusionData {
    public static final int MAXBUILDINGOCCLUDERS = 3;
    private static final THashSet<IsoBuilding> _leftBuildings = new THashSet(3);
    private static final THashSet<IsoBuilding> _rightBuildings = new THashSet(3);
    private static final THashSet<IsoBuilding> _allBuildings = new THashSet(3);
    private static int _ObjectEpoch = 0;
    private final ArrayList<IsoBuilding> _leftBuildingsArray = new ArrayList(3);
    private final ArrayList<IsoBuilding> _rightBuildingsArray = new ArrayList(3);
    private final ArrayList<IsoBuilding> _allBuildingsArray = new ArrayList(3);
    private IsoGridSquare _ownerSquare = null;
    private boolean _bSoftInitialized = false;
    private boolean _bLeftOccludedByOrphanStructures = false;
    private boolean _bRightOccludedByOrphanStructures = false;
    private int _objectEpoch = -1;

    public IsoGridOcclusionData(IsoGridSquare isoGridSquare) {
        this._ownerSquare = isoGridSquare;
    }

    public static void SquareChanged() {
        if (++_ObjectEpoch < 0) {
            _ObjectEpoch = 0;
        }
    }

    public void Reset() {
        this._bSoftInitialized = false;
        this._bLeftOccludedByOrphanStructures = false;
        this._bRightOccludedByOrphanStructures = false;
        this._allBuildingsArray.clear();
        this._leftBuildingsArray.clear();
        this._rightBuildingsArray.clear();
        this._objectEpoch = -1;
    }

    public boolean getCouldBeOccludedByOrphanStructures(OcclusionFilter occlusionFilter) {
        if (this._objectEpoch != _ObjectEpoch) {
            if (this._bSoftInitialized) {
                this.Reset();
            }
            this._objectEpoch = _ObjectEpoch;
        }
        if (!this._bSoftInitialized) {
            this.LazyInitializeSoftOccluders();
        }
        if (occlusionFilter == OcclusionFilter.Left) {
            return this._bLeftOccludedByOrphanStructures;
        }
        if (occlusionFilter == OcclusionFilter.Right) {
            return this._bRightOccludedByOrphanStructures;
        }
        return this._bLeftOccludedByOrphanStructures || this._bRightOccludedByOrphanStructures;
    }

    public ArrayList<IsoBuilding> getBuildingsCouldBeOccluders(OcclusionFilter occlusionFilter) {
        if (this._objectEpoch != _ObjectEpoch) {
            if (this._bSoftInitialized) {
                this.Reset();
            }
            this._objectEpoch = _ObjectEpoch;
        }
        if (!this._bSoftInitialized) {
            this.LazyInitializeSoftOccluders();
        }
        if (occlusionFilter == OcclusionFilter.Left) {
            return this._leftBuildingsArray;
        }
        if (occlusionFilter == OcclusionFilter.Right) {
            return this._rightBuildingsArray;
        }
        return this._allBuildingsArray;
    }

    private void LazyInitializeSoftOccluders() {
        boolean bl = false;
        int n = this._ownerSquare.getX();
        int n2 = this._ownerSquare.getY();
        int n3 = this._ownerSquare.getZ();
        _allBuildings.clear();
        _leftBuildings.clear();
        _rightBuildings.clear();
        bl |= this.GetBuildingFloorsProjectedOnSquare(_allBuildings, n, n2, n3);
        bl |= this.GetBuildingFloorsProjectedOnSquare(_allBuildings, n + 1, n2 + 1, n3);
        bl |= this.GetBuildingFloorsProjectedOnSquare(_allBuildings, n + 2, n2 + 2, n3);
        bl |= this.GetBuildingFloorsProjectedOnSquare(_allBuildings, n + 3, n2 + 3, n3);
        this._bLeftOccludedByOrphanStructures |= this.GetBuildingFloorsProjectedOnSquare(_leftBuildings, n, n2 + 1, n3);
        this._bLeftOccludedByOrphanStructures |= this.GetBuildingFloorsProjectedOnSquare(_leftBuildings, n + 1, n2 + 2, n3);
        this._bLeftOccludedByOrphanStructures |= this.GetBuildingFloorsProjectedOnSquare(_leftBuildings, n + 2, n2 + 3, n3);
        this._bRightOccludedByOrphanStructures |= this.GetBuildingFloorsProjectedOnSquare(_rightBuildings, n + 1, n2, n3);
        this._bRightOccludedByOrphanStructures |= this.GetBuildingFloorsProjectedOnSquare(_rightBuildings, n + 2, n2 + 1, n3);
        this._bRightOccludedByOrphanStructures |= this.GetBuildingFloorsProjectedOnSquare(_rightBuildings, n + 3, n2 + 2, n3);
        this._bLeftOccludedByOrphanStructures |= bl;
        _leftBuildings.addAll(_allBuildings);
        this._bRightOccludedByOrphanStructures |= bl;
        _rightBuildings.addAll(_allBuildings);
        _allBuildings.clear();
        _allBuildings.addAll(_leftBuildings);
        _allBuildings.addAll(_rightBuildings);
        this._leftBuildingsArray.addAll((Collection<IsoBuilding>)_leftBuildings);
        this._rightBuildingsArray.addAll((Collection<IsoBuilding>)_rightBuildings);
        this._allBuildingsArray.addAll((Collection<IsoBuilding>)_allBuildings);
        this._bSoftInitialized = true;
    }

    private boolean GetBuildingFloorsProjectedOnSquare(THashSet<IsoBuilding> tHashSet, int n, int n2, int n3) {
        boolean bl = false;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        while (n6 < IsoCell.MaxHeight) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n4, n5, n6);
            if (isoGridSquare != null) {
                IsoBuilding isoBuilding = isoGridSquare.getBuilding();
                if (isoBuilding == null) {
                    isoBuilding = isoGridSquare.roofHideBuilding;
                }
                if (isoBuilding != null) {
                    tHashSet.add((Object)isoBuilding);
                }
                for (int i = n6 - 1; i >= 0 && isoBuilding == null; --i) {
                    IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n4, n5, i);
                    if (isoGridSquare2 == null) continue;
                    isoBuilding = isoGridSquare2.getBuilding();
                    if (isoBuilding == null) {
                        isoBuilding = isoGridSquare2.roofHideBuilding;
                    }
                    if (isoBuilding == null) continue;
                    tHashSet.add((Object)isoBuilding);
                }
                if (isoBuilding == null && !bl && isoGridSquare.getZ() != 0 && isoGridSquare.getPlayerBuiltFloor() != null) {
                    bl = true;
                }
            }
            ++n6;
            n4 += 3;
            n5 += 3;
        }
        return bl;
    }

    public static enum OcclusionFilter {
        Left,
        Right,
        All;

    }

    public static enum OccluderType {
        Unknown,
        NotFull,
        Full;

    }
}

