/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import zombie.core.Rand;
import zombie.iso.Vector2;

public enum IsoDirections {
    N(0),
    NW(1),
    W(2),
    SW(3),
    S(4),
    SE(5),
    E(6),
    NE(7),
    Max(8);

    private static final IsoDirections[] VALUES;
    private static IsoDirections[][] directionLookup;
    private static final Vector2 temp;
    private final int index;

    private IsoDirections(int n2) {
        this.index = n2;
    }

    public static IsoDirections fromIndex(int n) {
        while (n < 0) {
            n += 8;
        }
        return VALUES[n %= 8];
    }

    public IsoDirections RotLeft(int n) {
        IsoDirections isoDirections = IsoDirections.RotLeft(this);
        for (int i = 0; i < n - 1; ++i) {
            isoDirections = IsoDirections.RotLeft(isoDirections);
        }
        return isoDirections;
    }

    public IsoDirections RotRight(int n) {
        IsoDirections isoDirections = IsoDirections.RotRight(this);
        for (int i = 0; i < n - 1; ++i) {
            isoDirections = IsoDirections.RotRight(isoDirections);
        }
        return isoDirections;
    }

    public IsoDirections RotLeft() {
        return IsoDirections.RotLeft(this);
    }

    public IsoDirections RotRight() {
        return IsoDirections.RotRight(this);
    }

    public static IsoDirections RotLeft(IsoDirections isoDirections) {
        switch (isoDirections) {
            case NE: {
                return N;
            }
            case N: {
                return NW;
            }
            case NW: {
                return W;
            }
            case W: {
                return SW;
            }
            case SW: {
                return S;
            }
            case S: {
                return SE;
            }
            case SE: {
                return E;
            }
            case E: {
                return NE;
            }
        }
        return Max;
    }

    public static IsoDirections RotRight(IsoDirections isoDirections) {
        switch (isoDirections) {
            case N: {
                return NE;
            }
            case NE: {
                return E;
            }
            case E: {
                return SE;
            }
            case SE: {
                return S;
            }
            case S: {
                return SW;
            }
            case SW: {
                return W;
            }
            case W: {
                return NW;
            }
            case NW: {
                return N;
            }
        }
        return Max;
    }

    public static void generateTables() {
        directionLookup = new IsoDirections[200][200];
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 200; ++j) {
                int n = i - 100;
                int n2 = j - 100;
                float f = (float)n / 100.0f;
                float f2 = (float)n2 / 100.0f;
                Vector2 vector22 = new Vector2(f, f2);
                vector22.normalize();
                IsoDirections.directionLookup[i][j] = IsoDirections.fromAngleActual(vector22);
            }
        }
    }

    public static IsoDirections fromAngleActual(Vector2 vector22) {
        IsoDirections.temp.x = vector22.x;
        IsoDirections.temp.y = vector22.y;
        temp.normalize();
        float f = temp.getDirectionNeg();
        float f2 = 0.7853982f;
        float f3 = (float)Math.PI * 2;
        f3 = (float)((double)f3 + Math.toRadians(112.5));
        for (int i = 0; i < 8; ++i) {
            if (f >= (f3 += f2) && f <= f3 + f2 || f + (float)Math.PI * 2 >= f3 && f + (float)Math.PI * 2 <= f3 + f2 || f - (float)Math.PI * 2 >= f3 && f - (float)Math.PI * 2 <= f3 + f2) {
                return IsoDirections.fromIndex(i);
            }
            if (!((double)f3 > Math.PI * 2)) continue;
            f3 = (float)((double)f3 - Math.PI * 2);
        }
        if (IsoDirections.temp.x > 0.5f) {
            if (IsoDirections.temp.y < -0.5f) {
                return NE;
            }
            if (IsoDirections.temp.y > 0.5f) {
                return SE;
            }
            return E;
        }
        if (IsoDirections.temp.x < -0.5f) {
            if (IsoDirections.temp.y < -0.5f) {
                return NW;
            }
            if (IsoDirections.temp.y > 0.5f) {
                return SW;
            }
            return W;
        }
        if (IsoDirections.temp.y < -0.5f) {
            return N;
        }
        if (IsoDirections.temp.y > 0.5f) {
            return S;
        }
        return N;
    }

    public static IsoDirections fromAngle(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        return IsoDirections.fromAngle(f2, f3);
    }

    public static IsoDirections fromAngle(Vector2 vector22) {
        return IsoDirections.fromAngle(vector22.x, vector22.y);
    }

    public static IsoDirections fromAngle(float f, float f2) {
        IsoDirections.temp.x = f;
        IsoDirections.temp.y = f2;
        if (temp.getLengthSquared() != 1.0f) {
            temp.normalize();
        }
        if (directionLookup == null) {
            IsoDirections.generateTables();
        }
        int n = (int)((IsoDirections.temp.x + 1.0f) * 100.0f);
        int n2 = (int)((IsoDirections.temp.y + 1.0f) * 100.0f);
        if (n >= 200) {
            n = 199;
        }
        if (n2 >= 200) {
            n2 = 199;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return directionLookup[n][n2];
    }

    public static IsoDirections cardinalFromAngle(Vector2 vector22) {
        boolean bl;
        boolean bl2 = vector22.getX() >= vector22.getY();
        boolean bl3 = bl = vector22.getX() > -vector22.getY();
        if (bl2) {
            if (bl) {
                return E;
            }
            return N;
        }
        if (bl) {
            return S;
        }
        return W;
    }

    public static IsoDirections reverse(IsoDirections isoDirections) {
        switch (isoDirections) {
            case S: {
                return N;
            }
            case SE: {
                return NW;
            }
            case E: {
                return W;
            }
            case NE: {
                return SW;
            }
            case N: {
                return S;
            }
            case NW: {
                return SE;
            }
            case W: {
                return E;
            }
            case SW: {
                return NE;
            }
        }
        return Max;
    }

    public int index() {
        return this.index % 8;
    }

    public String toCompassString() {
        switch (this.index) {
            case 0: {
                return "9";
            }
            case 1: {
                return "8";
            }
            case 2: {
                return "7";
            }
            case 3: {
                return "4";
            }
            case 4: {
                return "1";
            }
            case 5: {
                return "2";
            }
            case 6: {
                return "3";
            }
            case 7: {
                return "6";
            }
        }
        return "";
    }

    public Vector2 ToVector() {
        switch (this) {
            case S: {
                IsoDirections.temp.x = 0.0f;
                IsoDirections.temp.y = 1.0f;
                break;
            }
            case SE: {
                IsoDirections.temp.x = 1.0f;
                IsoDirections.temp.y = 1.0f;
                break;
            }
            case E: {
                IsoDirections.temp.x = 1.0f;
                IsoDirections.temp.y = 0.0f;
                break;
            }
            case NE: {
                IsoDirections.temp.x = 1.0f;
                IsoDirections.temp.y = -1.0f;
                break;
            }
            case N: {
                IsoDirections.temp.x = 0.0f;
                IsoDirections.temp.y = -1.0f;
                break;
            }
            case NW: {
                IsoDirections.temp.x = -1.0f;
                IsoDirections.temp.y = -1.0f;
                break;
            }
            case W: {
                IsoDirections.temp.x = -1.0f;
                IsoDirections.temp.y = 0.0f;
                break;
            }
            case SW: {
                IsoDirections.temp.x = -1.0f;
                IsoDirections.temp.y = 1.0f;
            }
        }
        temp.normalize();
        return temp;
    }

    public float toAngle() {
        float f = 0.7853982f;
        switch (this) {
            case N: {
                return f * 0.0f;
            }
            case NW: {
                return f * 1.0f;
            }
            case W: {
                return f * 2.0f;
            }
            case SW: {
                return f * 3.0f;
            }
            case S: {
                return f * 4.0f;
            }
            case SE: {
                return f * 5.0f;
            }
            case E: {
                return f * 6.0f;
            }
            case NE: {
                return f * 7.0f;
            }
        }
        return 0.0f;
    }

    public static IsoDirections getRandom() {
        return IsoDirections.fromIndex(Rand.Next(0, IsoDirections.Max.index));
    }

    static {
        VALUES = IsoDirections.values();
        temp = new Vector2();
    }
}

