/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import zombie.GameTime;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.physics.WorldSimulation;
import zombie.core.textures.ColorInfo;
import zombie.core.utils.UpdateLimit;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.iso.ChunkSaveWorker;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoFloorBloodSplat;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.LightingJNI;
import zombie.iso.LightingThread;
import zombie.iso.WorldReuserThread;
import zombie.iso.WorldStreamer;
import zombie.iso.areas.IsoRoom;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.MPStatistics;
import zombie.network.PacketTypes;
import zombie.ui.TextManager;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleCache;
import zombie.vehicles.VehicleManager;

public final class IsoChunkMap {
    public static final int LEVELS = 8;
    public static final int ChunksPerWidth = 10;
    public static final HashMap<Integer, IsoChunk> SharedChunks = new HashMap();
    public static int MPWorldXA = 0;
    public static int MPWorldYA = 0;
    public static int MPWorldZA = 0;
    public static int WorldXA = 11702;
    public static int WorldYA = 6896;
    public static int WorldZA = 0;
    public static final int[] SWorldX = new int[4];
    public static final int[] SWorldY = new int[4];
    public static final ConcurrentLinkedQueue<IsoChunk> chunkStore = new ConcurrentLinkedQueue();
    public static final ReentrantLock bSettingChunk = new ReentrantLock(true);
    private static int StartChunkGridWidth;
    public static int ChunkGridWidth;
    public static int ChunkWidthInTiles;
    private static final ColorInfo inf;
    private static final ArrayList<IsoChunk> saveList;
    private static final ArrayList<ArrayList<IsoFloorBloodSplat>> splatByType;
    public int PlayerID = 0;
    public boolean ignore = false;
    public int WorldX = IsoChunkMap.tileToChunk(WorldXA);
    public int WorldY = IsoChunkMap.tileToChunk(WorldYA);
    public final ArrayList<String> filenameServerRequests = new ArrayList();
    protected IsoChunk[] chunksSwapB;
    protected IsoChunk[] chunksSwapA;
    boolean bReadBufferA = true;
    int XMinTiles = -1;
    int YMinTiles = -1;
    int XMaxTiles = -1;
    int YMaxTiles = -1;
    private IsoCell cell;
    private final UpdateLimit checkVehiclesFrequency = new UpdateLimit(3000L);

    public IsoChunkMap(IsoCell isoCell) {
        this.cell = isoCell;
        WorldReuserThread.instance.finished = false;
        this.chunksSwapB = new IsoChunk[ChunkGridWidth * ChunkGridWidth];
        this.chunksSwapA = new IsoChunk[ChunkGridWidth * ChunkGridWidth];
    }

    public static void CalcChunkWidth() {
        if (DebugOptions.instance.WorldChunkMap5x5.getValue()) {
            ChunkGridWidth = 5;
            ChunkWidthInTiles = ChunkGridWidth * 10;
            return;
        }
        float f = Core.getInstance().getScreenWidth();
        float f2 = f / 1920.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if ((ChunkGridWidth = (int)((double)((float)StartChunkGridWidth * f2) * 1.5)) / 2 * 2 == ChunkGridWidth) {
            ++ChunkGridWidth;
        }
        ChunkWidthInTiles = ChunkGridWidth * 10;
    }

    public static void setWorldStartPos(int n, int n2) {
        IsoChunkMap.SWorldX[IsoPlayer.getPlayerIndex()] = IsoChunkMap.tileToChunk(n);
        IsoChunkMap.SWorldY[IsoPlayer.getPlayerIndex()] = IsoChunkMap.tileToChunk(n2);
    }

    public void Dispose() {
        WorldReuserThread.instance.finished = true;
        IsoChunk.loadGridSquare.clear();
        this.chunksSwapA = null;
        this.chunksSwapB = null;
    }

    public void setInitialPos(int n, int n2) {
        this.WorldX = n;
        this.WorldY = n2;
        this.XMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMinTiles = -1;
        this.YMaxTiles = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllLoadGridSquare() {
        IsoChunk isoChunk = IsoChunk.loadGridSquare.poll();
        while (isoChunk != null) {
            bSettingChunk.lock();
            try {
                boolean bl = false;
                for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                    IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[i];
                    if (isoChunkMap.ignore || !isoChunkMap.setChunkDirect(isoChunk, false)) continue;
                    bl = true;
                }
                if (!bl) {
                    WorldReuserThread.instance.addReuseChunk(isoChunk);
                } else {
                    isoChunk.doLoadGridsquare();
                }
            }
            finally {
                bSettingChunk.unlock();
            }
            isoChunk = IsoChunk.loadGridSquare.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        int n;
        int n2;
        IsoChunk isoChunk;
        int n3 = IsoChunk.loadGridSquare.size();
        if (n3 != 0) {
            n3 = 1 + n3 * 3 / ChunkGridWidth;
        }
        while (n3 > 0) {
            isoChunk = IsoChunk.loadGridSquare.poll();
            if (isoChunk != null) {
                Object object;
                n2 = 0;
                for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                    object = IsoWorld.instance.CurrentCell.ChunkMap[n];
                    if (((IsoChunkMap)object).ignore || !((IsoChunkMap)object).setChunkDirect(isoChunk, false)) continue;
                    n2 = 1;
                }
                if (n2 == 0) {
                    WorldReuserThread.instance.addReuseChunk(isoChunk);
                    --n3;
                    continue;
                }
                isoChunk.bLoaded = true;
                bSettingChunk.lock();
                try {
                    isoChunk.doLoadGridsquare();
                    if (GameClient.bClient) {
                        List<VehicleCache> list = VehicleCache.vehicleGet(isoChunk.wx, isoChunk.wy);
                        VehicleManager.instance.sendRequestGetFull(list);
                    }
                }
                finally {
                    bSettingChunk.unlock();
                }
                for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                    object = IsoPlayer.players[n];
                    if (object == null) continue;
                    ((IsoPlayer)object).dirtyRecalcGridStackTime = 20.0f;
                }
            }
            --n3;
        }
        for (n2 = 0; n2 < ChunkGridWidth; ++n2) {
            for (n = 0; n < ChunkGridWidth; ++n) {
                isoChunk = this.getChunk(n, n2);
                if (isoChunk == null) continue;
                isoChunk.update();
            }
        }
        if (this.checkVehiclesFrequency.Check() && GameClient.bClient) {
            this.checkVehicles();
        }
    }

    private void checkVehicles() {
        for (int i = 0; i < ChunkGridWidth; ++i) {
            for (int j = 0; j < ChunkGridWidth; ++j) {
                List<VehicleCache> list;
                IsoChunk isoChunk = this.getChunk(j, i);
                if (isoChunk == null || !isoChunk.bLoaded || (list = VehicleCache.vehicleGet(isoChunk.wx, isoChunk.wy)) == null || isoChunk.vehicles.size() == list.size()) continue;
                for (int k = 0; k < list.size(); ++k) {
                    short s = list.get((int)k).id;
                    boolean bl = false;
                    for (int i2 = 0; i2 < isoChunk.vehicles.size(); ++i2) {
                        if (isoChunk.vehicles.get(i2).getId() != s) continue;
                        bl = true;
                        break;
                    }
                    if (bl || VehicleManager.instance.getVehicleByID(s) != null) continue;
                    VehicleManager.instance.sendRequestGetFull(s, PacketTypes.PacketType.Vehicles);
                }
            }
        }
    }

    public void checkIntegrity() {
        IsoWorld.instance.CurrentCell.ChunkMap[0].XMinTiles = -1;
        for (int i = IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldXMinTiles(); i < IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldXMaxTiles(); ++i) {
            for (int j = IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldYMinTiles(); j < IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldYMaxTiles(); ++j) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i, j, 0);
                if (isoGridSquare == null || isoGridSquare.getX() == i && isoGridSquare.getY() == j) continue;
                int n = i / 10;
                int n2 = j / 10;
                n -= IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldXMin();
                n2 -= IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldYMin();
                IsoChunk isoChunk = null;
                isoChunk = new IsoChunk(IsoWorld.instance.CurrentCell);
                isoChunk.refs.add(IsoWorld.instance.CurrentCell.ChunkMap[0]);
                WorldStreamer.instance.addJob(isoChunk, i / 10, j / 10, false);
                while (!isoChunk.bLoaded) {
                    try {
                        Thread.sleep(13L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
    }

    public void checkIntegrityThread() {
        IsoWorld.instance.CurrentCell.ChunkMap[0].XMinTiles = -1;
        for (int i = IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldXMinTiles(); i < IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldXMaxTiles(); ++i) {
            for (int j = IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldYMinTiles(); j < IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldYMaxTiles(); ++j) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i, j, 0);
                if (isoGridSquare != null && (isoGridSquare.getX() != i || isoGridSquare.getY() != j)) {
                    int n = i / 10;
                    int n2 = j / 10;
                    n -= IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldXMin();
                    n2 -= IsoWorld.instance.CurrentCell.ChunkMap[0].getWorldYMin();
                    IsoChunk isoChunk = new IsoChunk(IsoWorld.instance.CurrentCell);
                    isoChunk.refs.add(IsoWorld.instance.CurrentCell.ChunkMap[0]);
                    WorldStreamer.instance.addJobInstant(isoChunk, i, j, i / 10, j / 10);
                }
                if (isoGridSquare == null) continue;
            }
        }
    }

    public void LoadChunk(int n, int n2, int n3, int n4) {
        IsoChunk isoChunk = null;
        if (SharedChunks.containsKey((n << 16) + n2)) {
            isoChunk = SharedChunks.get((n << 16) + n2);
            isoChunk.setCache();
            this.setChunk(n3, n4, isoChunk);
            isoChunk.refs.add(this);
        } else {
            isoChunk = chunkStore.poll();
            if (isoChunk == null) {
                isoChunk = new IsoChunk(this.cell);
            } else {
                MPStatistics.decreaseStoredChunk();
            }
            SharedChunks.put((n << 16) + n2, isoChunk);
            isoChunk.refs.add(this);
            WorldStreamer.instance.addJob(isoChunk, n, n2, false);
        }
    }

    public IsoChunk LoadChunkForLater(int n, int n2, int n3, int n4) {
        IsoChunk isoChunk;
        if (!IsoWorld.instance.getMetaGrid().isValidChunk(n, n2)) {
            return null;
        }
        if (SharedChunks.containsKey((n << 16) + n2)) {
            isoChunk = SharedChunks.get((n << 16) + n2);
            if (!isoChunk.refs.contains(this)) {
                isoChunk.refs.add(this);
                isoChunk.lightCheck[this.PlayerID] = true;
            }
            if (!isoChunk.bLoaded) {
                return isoChunk;
            }
            this.setChunk(n3, n4, isoChunk);
        } else {
            isoChunk = chunkStore.poll();
            if (isoChunk == null) {
                isoChunk = new IsoChunk(this.cell);
            } else {
                MPStatistics.decreaseStoredChunk();
            }
            SharedChunks.put((n << 16) + n2, isoChunk);
            isoChunk.refs.add(this);
            WorldStreamer.instance.addJob(isoChunk, n, n2, true);
        }
        return isoChunk;
    }

    public IsoChunk getChunkForGridSquare(int n, int n2) {
        n = this.gridSquareToTileX(n);
        n2 = this.gridSquareToTileY(n2);
        if (this.isTileOutOfrange(n) || this.isTileOutOfrange(n2)) {
            return null;
        }
        return this.getChunk(IsoChunkMap.tileToChunk(n), IsoChunkMap.tileToChunk(n2));
    }

    public IsoChunk getChunkCurrent(int n, int n2) {
        if (n < 0 || n >= ChunkGridWidth || n2 < 0 || n2 >= ChunkGridWidth) {
            return null;
        }
        if (!this.bReadBufferA) {
            return this.chunksSwapA[ChunkGridWidth * n2 + n];
        }
        return this.chunksSwapB[ChunkGridWidth * n2 + n];
    }

    public void setGridSquare(IsoGridSquare isoGridSquare, int n, int n2, int n3) {
        assert (isoGridSquare == null || isoGridSquare.x == n && isoGridSquare.y == n2 && isoGridSquare.z == n3);
        int n4 = this.gridSquareToTileX(n);
        int n5 = this.gridSquareToTileY(n2);
        if (this.isTileOutOfrange(n4) || this.isTileOutOfrange(n5) || this.isGridSquareOutOfRangeZ(n3)) {
            return;
        }
        IsoChunk isoChunk = this.getChunk(IsoChunkMap.tileToChunk(n4), IsoChunkMap.tileToChunk(n5));
        if (isoChunk == null) {
            return;
        }
        if (n3 > isoChunk.maxLevel) {
            isoChunk.maxLevel = n3;
        }
        isoChunk.setSquare(this.tileToGridSquare(n4), this.tileToGridSquare(n5), n3, isoGridSquare);
    }

    public IsoGridSquare getGridSquare(int n, int n2, int n3) {
        n = this.gridSquareToTileX(n);
        n2 = this.gridSquareToTileY(n2);
        return this.getGridSquareDirect(n, n2, n3);
    }

    public IsoGridSquare getGridSquareDirect(int n, int n2, int n3) {
        if (this.isTileOutOfrange(n) || this.isTileOutOfrange(n2) || this.isGridSquareOutOfRangeZ(n3)) {
            return null;
        }
        IsoChunk isoChunk = this.getChunk(IsoChunkMap.tileToChunk(n), IsoChunkMap.tileToChunk(n2));
        if (isoChunk == null) {
            return null;
        }
        return isoChunk.getGridSquare(this.tileToGridSquare(n), this.tileToGridSquare(n2), n3);
    }

    private int tileToGridSquare(int n) {
        return n % 10;
    }

    private static int tileToChunk(int n) {
        return n / 10;
    }

    private boolean isTileOutOfrange(int n) {
        return n < 0 || n >= this.getWidthInTiles();
    }

    private boolean isGridSquareOutOfRangeZ(int n) {
        return n < 0 || n >= 8;
    }

    private int gridSquareToTileX(int n) {
        int n2 = n - (this.WorldX - ChunkGridWidth / 2) * 10;
        return n2;
    }

    private int gridSquareToTileY(int n) {
        int n2 = n - (this.WorldY - ChunkGridWidth / 2) * 10;
        return n2;
    }

    public IsoChunk getChunk(int n, int n2) {
        if (n < 0 || n >= ChunkGridWidth || n2 < 0 || n2 >= ChunkGridWidth) {
            return null;
        }
        if (this.bReadBufferA) {
            return this.chunksSwapA[ChunkGridWidth * n2 + n];
        }
        return this.chunksSwapB[ChunkGridWidth * n2 + n];
    }

    private void setChunk(int n, int n2, IsoChunk isoChunk) {
        if (!this.bReadBufferA) {
            this.chunksSwapA[IsoChunkMap.ChunkGridWidth * n2 + n] = isoChunk;
        } else {
            this.chunksSwapB[IsoChunkMap.ChunkGridWidth * n2 + n] = isoChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setChunkDirect(IsoChunk isoChunk, boolean bl) {
        long l = System.nanoTime();
        if (bl) {
            bSettingChunk.lock();
        }
        long l2 = System.nanoTime();
        int n = isoChunk.wx - this.WorldX;
        int n2 = isoChunk.wy - this.WorldY;
        n += ChunkGridWidth / 2;
        n2 += ChunkGridWidth / 2;
        if (isoChunk.jobType == IsoChunk.JobType.Convert) {
            n = 0;
            n2 = 0;
        }
        if (isoChunk.refs.isEmpty() || n < 0 || n2 < 0 || n >= ChunkGridWidth || n2 >= ChunkGridWidth) {
            if (isoChunk.refs.contains(this)) {
                isoChunk.refs.remove(this);
                if (isoChunk.refs.isEmpty()) {
                    SharedChunks.remove((isoChunk.wx << 16) + isoChunk.wy);
                }
            }
            if (bl) {
                bSettingChunk.unlock();
            }
            return false;
        }
        try {
            if (this.bReadBufferA) {
                this.chunksSwapA[IsoChunkMap.ChunkGridWidth * n2 + n] = isoChunk;
            } else {
                this.chunksSwapB[IsoChunkMap.ChunkGridWidth * n2 + n] = isoChunk;
            }
            isoChunk.bLoaded = true;
            if (isoChunk.jobType == IsoChunk.JobType.None) {
                isoChunk.setCache();
                isoChunk.updateBuildings();
            }
            double d = (double)(System.nanoTime() - l2) / 1000000.0;
            double d2 = (double)(System.nanoTime() - l) / 1000000.0;
            if (LightingThread.DebugLockTime && d2 > 10.0) {
                DebugLog.log("setChunkDirect time " + d + "/" + d2 + " ms");
            }
        }
        finally {
            if (bl) {
                bSettingChunk.unlock();
            }
        }
        return true;
    }

    public void drawDebugChunkMap() {
        int n = 64;
        int n2 = 0;
        for (int i = 0; i < ChunkGridWidth; ++i) {
            n2 = 0;
            for (int j = 0; j < ChunkGridWidth; ++j) {
                IsoGridSquare isoGridSquare;
                n2 += 64;
                IsoChunk isoChunk = this.getChunk(i, j);
                if (isoChunk == null || (isoGridSquare = isoChunk.getGridSquare(0, 0, 0)) != null) continue;
                TextManager.instance.DrawString(n, n2, "wx:" + isoChunk.wx + " wy:" + isoChunk.wy);
            }
            n += 128;
        }
    }

    private void LoadLeft() {
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        this.Left();
        WorldSimulation.instance.scrollGroundLeft(this.PlayerID);
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        for (int i = -(ChunkGridWidth / 2); i <= ChunkGridWidth / 2; ++i) {
            this.LoadChunkForLater(this.WorldX - ChunkGridWidth / 2, this.WorldY + i, 0, i + ChunkGridWidth / 2);
        }
        this.SwapChunkBuffers();
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        this.UpdateCellCache();
        LightingThread.instance.scrollLeft(this.PlayerID);
    }

    public void SwapChunkBuffers() {
        for (int i = 0; i < ChunkGridWidth * ChunkGridWidth; ++i) {
            if (this.bReadBufferA) {
                this.chunksSwapA[i] = null;
                continue;
            }
            this.chunksSwapB[i] = null;
        }
        this.XMaxTiles = -1;
        this.XMinTiles = -1;
        this.YMaxTiles = -1;
        this.YMinTiles = -1;
        this.bReadBufferA = !this.bReadBufferA;
    }

    private void setChunk(int n, IsoChunk isoChunk) {
        if (!this.bReadBufferA) {
            this.chunksSwapA[n] = isoChunk;
        } else {
            this.chunksSwapB[n] = isoChunk;
        }
    }

    private IsoChunk getChunk(int n) {
        if (this.bReadBufferA) {
            return this.chunksSwapA[n];
        }
        return this.chunksSwapB[n];
    }

    private void LoadRight() {
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        this.Right();
        WorldSimulation.instance.scrollGroundRight(this.PlayerID);
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        for (int i = -(ChunkGridWidth / 2); i <= ChunkGridWidth / 2; ++i) {
            this.LoadChunkForLater(this.WorldX + ChunkGridWidth / 2, this.WorldY + i, ChunkGridWidth - 1, i + ChunkGridWidth / 2);
        }
        this.SwapChunkBuffers();
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        this.UpdateCellCache();
        LightingThread.instance.scrollRight(this.PlayerID);
    }

    private void LoadUp() {
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        this.Up();
        WorldSimulation.instance.scrollGroundUp(this.PlayerID);
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        for (int i = -(ChunkGridWidth / 2); i <= ChunkGridWidth / 2; ++i) {
            this.LoadChunkForLater(this.WorldX + i, this.WorldY - ChunkGridWidth / 2, i + ChunkGridWidth / 2, 0);
        }
        this.SwapChunkBuffers();
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        this.UpdateCellCache();
        LightingThread.instance.scrollUp(this.PlayerID);
    }

    private void LoadDown() {
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        this.Down();
        WorldSimulation.instance.scrollGroundDown(this.PlayerID);
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        for (int i = -(ChunkGridWidth / 2); i <= ChunkGridWidth / 2; ++i) {
            this.LoadChunkForLater(this.WorldX + i, this.WorldY + ChunkGridWidth / 2, i + ChunkGridWidth / 2, ChunkGridWidth - 1);
        }
        this.SwapChunkBuffers();
        this.XMinTiles = -1;
        this.YMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMaxTiles = -1;
        this.UpdateCellCache();
        LightingThread.instance.scrollDown(this.PlayerID);
    }

    private void UpdateCellCache() {
        int n = this.getWidthInTiles();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = this.getGridSquare(i + this.getWorldXMinTiles(), j + this.getWorldYMinTiles(), k);
                    IsoWorld.instance.CurrentCell.setCacheGridSquareLocal(i, j, k, isoGridSquare, this.PlayerID);
                }
            }
        }
    }

    private void Up() {
        for (int i = 0; i < ChunkGridWidth; ++i) {
            for (int j = ChunkGridWidth - 1; j > 0; --j) {
                int n;
                int n2;
                IsoChunk isoChunk = this.getChunk(i, j);
                if (isoChunk == null && j == ChunkGridWidth - 1 && (isoChunk = SharedChunks.get(((n2 = this.WorldX - ChunkGridWidth / 2 + i) << 16) + (n = this.WorldY - ChunkGridWidth / 2 + j))) != null) {
                    if (isoChunk.refs.contains(this)) {
                        isoChunk.refs.remove(this);
                        if (isoChunk.refs.isEmpty()) {
                            SharedChunks.remove((isoChunk.wx << 16) + isoChunk.wy);
                        }
                    }
                    isoChunk = null;
                }
                if (isoChunk != null && j == ChunkGridWidth - 1) {
                    isoChunk.refs.remove(this);
                    if (isoChunk.refs.isEmpty()) {
                        SharedChunks.remove((isoChunk.wx << 16) + isoChunk.wy);
                        isoChunk.removeFromWorld();
                        ChunkSaveWorker.instance.Add(isoChunk);
                    }
                }
                this.setChunk(i, j, this.getChunk(i, j - 1));
            }
            this.setChunk(i, 0, null);
        }
        --this.WorldY;
    }

    private void Down() {
        for (int i = 0; i < ChunkGridWidth; ++i) {
            for (int j = 0; j < ChunkGridWidth - 1; ++j) {
                int n;
                int n2;
                IsoChunk isoChunk = this.getChunk(i, j);
                if (isoChunk == null && j == 0 && (isoChunk = SharedChunks.get(((n2 = this.WorldX - ChunkGridWidth / 2 + i) << 16) + (n = this.WorldY - ChunkGridWidth / 2 + j))) != null) {
                    if (isoChunk.refs.contains(this)) {
                        isoChunk.refs.remove(this);
                        if (isoChunk.refs.isEmpty()) {
                            SharedChunks.remove((isoChunk.wx << 16) + isoChunk.wy);
                        }
                    }
                    isoChunk = null;
                }
                if (isoChunk != null && j == 0) {
                    isoChunk.refs.remove(this);
                    if (isoChunk.refs.isEmpty()) {
                        SharedChunks.remove((isoChunk.wx << 16) + isoChunk.wy);
                        isoChunk.removeFromWorld();
                        ChunkSaveWorker.instance.Add(isoChunk);
                    }
                }
                this.setChunk(i, j, this.getChunk(i, j + 1));
            }
            this.setChunk(i, ChunkGridWidth - 1, null);
        }
        ++this.WorldY;
    }

    private void Left() {
        for (int i = 0; i < ChunkGridWidth; ++i) {
            for (int j = ChunkGridWidth - 1; j > 0; --j) {
                int n;
                int n2;
                IsoChunk isoChunk = this.getChunk(j, i);
                if (isoChunk == null && j == ChunkGridWidth - 1 && (isoChunk = SharedChunks.get(((n2 = this.WorldX - ChunkGridWidth / 2 + j) << 16) + (n = this.WorldY - ChunkGridWidth / 2 + i))) != null) {
                    if (isoChunk.refs.contains(this)) {
                        isoChunk.refs.remove(this);
                        if (isoChunk.refs.isEmpty()) {
                            SharedChunks.remove((isoChunk.wx << 16) + isoChunk.wy);
                        }
                    }
                    isoChunk = null;
                }
                if (isoChunk != null && j == ChunkGridWidth - 1) {
                    isoChunk.refs.remove(this);
                    if (isoChunk.refs.isEmpty()) {
                        SharedChunks.remove((isoChunk.wx << 16) + isoChunk.wy);
                        isoChunk.removeFromWorld();
                        ChunkSaveWorker.instance.Add(isoChunk);
                    }
                }
                this.setChunk(j, i, this.getChunk(j - 1, i));
            }
            this.setChunk(0, i, null);
        }
        --this.WorldX;
    }

    private void Right() {
        for (int i = 0; i < ChunkGridWidth; ++i) {
            for (int j = 0; j < ChunkGridWidth - 1; ++j) {
                int n;
                int n2;
                IsoChunk isoChunk = this.getChunk(j, i);
                if (isoChunk == null && j == 0 && (isoChunk = SharedChunks.get(((n2 = this.WorldX - ChunkGridWidth / 2 + j) << 16) + (n = this.WorldY - ChunkGridWidth / 2 + i))) != null) {
                    if (isoChunk.refs.contains(this)) {
                        isoChunk.refs.remove(this);
                        if (isoChunk.refs.isEmpty()) {
                            SharedChunks.remove((isoChunk.wx << 16) + isoChunk.wy);
                        }
                    }
                    isoChunk = null;
                }
                if (isoChunk != null && j == 0) {
                    isoChunk.refs.remove(this);
                    if (isoChunk.refs.isEmpty()) {
                        SharedChunks.remove((isoChunk.wx << 16) + isoChunk.wy);
                        isoChunk.removeFromWorld();
                        ChunkSaveWorker.instance.Add(isoChunk);
                    }
                }
                this.setChunk(j, i, this.getChunk(j + 1, i));
            }
            this.setChunk(ChunkGridWidth - 1, i, null);
        }
        ++this.WorldX;
    }

    public int getWorldXMin() {
        return this.WorldX - ChunkGridWidth / 2;
    }

    public int getWorldYMin() {
        return this.WorldY - ChunkGridWidth / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessChunkPos(IsoGameCharacter isoGameCharacter) {
        int n = (int)isoGameCharacter.getX();
        int n2 = (int)isoGameCharacter.getY();
        int n3 = (int)isoGameCharacter.getZ();
        if (IsoPlayer.getInstance() != null && IsoPlayer.getInstance().getVehicle() != null) {
            IsoPlayer isoPlayer = IsoPlayer.getInstance();
            BaseVehicle baseVehicle = isoPlayer.getVehicle();
            float f = baseVehicle.getCurrentSpeedKmHour() / 5.0f;
            if (!isoPlayer.isDriving()) {
                f = Math.min(f * 2.0f, 20.0f);
            }
            n += Math.round(isoPlayer.getForwardDirection().x * f);
            n2 += Math.round(isoPlayer.getForwardDirection().y * f);
        }
        if ((n /= 10) == this.WorldX && (n2 /= 10) == this.WorldY) {
            return;
        }
        long l = System.nanoTime();
        double d = 0.0;
        bSettingChunk.lock();
        long l2 = System.nanoTime();
        try {
            if (Math.abs(n - this.WorldX) >= ChunkGridWidth || Math.abs(n2 - this.WorldY) >= ChunkGridWidth) {
                if (LightingJNI.init) {
                    LightingJNI.teleport(this.PlayerID, n - ChunkGridWidth / 2, n2 - ChunkGridWidth / 2);
                }
                this.Unload();
                IsoPlayer isoPlayer = IsoPlayer.players[this.PlayerID];
                isoPlayer.removeFromSquare();
                isoPlayer.square = null;
                this.WorldX = n;
                this.WorldY = n2;
                if (!GameServer.bServer) {
                    WorldSimulation.instance.activateChunkMap(this.PlayerID);
                }
                int n4 = this.WorldX - ChunkGridWidth / 2;
                int n5 = this.WorldY - ChunkGridWidth / 2;
                int n6 = this.WorldX + ChunkGridWidth / 2;
                int n7 = this.WorldY + ChunkGridWidth / 2;
                for (int i = n4; i <= n6; ++i) {
                    for (int j = n5; j <= n7; ++j) {
                        this.LoadChunkForLater(i, j, i - n4, j - n5);
                    }
                }
                this.SwapChunkBuffers();
                this.UpdateCellCache();
                if (!IsoWorld.instance.getCell().getObjectList().contains(isoPlayer)) {
                    IsoWorld.instance.getCell().getAddList().add(isoPlayer);
                }
            } else if (n != this.WorldX) {
                if (n < this.WorldX) {
                    this.LoadLeft();
                } else {
                    this.LoadRight();
                }
            } else if (n2 != this.WorldY) {
                if (n2 < this.WorldY) {
                    this.LoadUp();
                } else {
                    this.LoadDown();
                }
            }
        }
        finally {
            bSettingChunk.unlock();
        }
        d = (double)(System.nanoTime() - l2) / 1000000.0;
        double d2 = (double)(System.nanoTime() - l) / 1000000.0;
        if (LightingThread.DebugLockTime && d2 > 10.0) {
            DebugLog.log("ProcessChunkPos time " + d + "/" + d2 + " ms");
        }
    }

    public IsoRoom getRoom(int n) {
        return null;
    }

    public int getWidthInTiles() {
        return ChunkWidthInTiles;
    }

    public int getWorldXMinTiles() {
        if (this.XMinTiles != -1) {
            return this.XMinTiles;
        }
        this.XMinTiles = this.getWorldXMin() * 10;
        return this.XMinTiles;
    }

    public int getWorldYMinTiles() {
        if (this.YMinTiles != -1) {
            return this.YMinTiles;
        }
        this.YMinTiles = this.getWorldYMin() * 10;
        return this.YMinTiles;
    }

    public int getWorldXMaxTiles() {
        if (this.XMaxTiles != -1) {
            return this.XMaxTiles;
        }
        this.XMaxTiles = this.getWorldXMin() * 10 + this.getWidthInTiles();
        return this.XMaxTiles;
    }

    public int getWorldYMaxTiles() {
        if (this.YMaxTiles != -1) {
            return this.YMaxTiles;
        }
        this.YMaxTiles = this.getWorldYMin() * 10 + this.getWidthInTiles();
        return this.YMaxTiles;
    }

    public void Save() {
        if (GameServer.bServer) {
            return;
        }
        for (int i = 0; i < ChunkGridWidth; ++i) {
            for (int j = 0; j < ChunkGridWidth; ++j) {
                IsoChunk isoChunk = this.getChunk(i, j);
                if (isoChunk == null || saveList.contains(isoChunk)) continue;
                try {
                    isoChunk.Save(true);
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void renderBloodForChunks(int n) {
        Object object;
        int n2;
        if (!DebugOptions.instance.Terrain.RenderTiles.BloodDecals.getValue()) {
            return;
        }
        if ((float)n > IsoCamera.CamCharacter.z) {
            return;
        }
        if (Core.OptionBloodDecals == 0) {
            return;
        }
        float f = (float)GameTime.getInstance().getWorldAgeHours();
        int n3 = IsoCamera.frameState.playerIndex;
        for (n2 = 0; n2 < IsoFloorBloodSplat.FloorBloodTypes.length; ++n2) {
            splatByType.get(n2).clear();
        }
        for (n2 = 0; n2 < ChunkGridWidth; ++n2) {
            for (int i = 0; i < ChunkGridWidth; ++i) {
                IsoFloorBloodSplat isoFloorBloodSplat;
                int n4;
                object = this.getChunk(n2, i);
                if (object == null) continue;
                for (n4 = 0; n4 < ((IsoChunk)object).FloorBloodSplatsFade.size(); ++n4) {
                    isoFloorBloodSplat = ((IsoChunk)object).FloorBloodSplatsFade.get(n4);
                    if (isoFloorBloodSplat.index >= 1 && isoFloorBloodSplat.index <= 10 && IsoChunk.renderByIndex[Core.OptionBloodDecals - 1][isoFloorBloodSplat.index - 1] == 0 || (int)isoFloorBloodSplat.z != n || isoFloorBloodSplat.Type < 0 || isoFloorBloodSplat.Type >= IsoFloorBloodSplat.FloorBloodTypes.length) continue;
                    isoFloorBloodSplat.chunk = object;
                    splatByType.get(isoFloorBloodSplat.Type).add(isoFloorBloodSplat);
                }
                if (((IsoChunk)object).FloorBloodSplats.isEmpty()) continue;
                for (n4 = 0; n4 < ((IsoChunk)object).FloorBloodSplats.size(); ++n4) {
                    isoFloorBloodSplat = ((IsoChunk)object).FloorBloodSplats.get(n4);
                    if (isoFloorBloodSplat.index >= 1 && isoFloorBloodSplat.index <= 10 && IsoChunk.renderByIndex[Core.OptionBloodDecals - 1][isoFloorBloodSplat.index - 1] == 0 || (int)isoFloorBloodSplat.z != n || isoFloorBloodSplat.Type < 0 || isoFloorBloodSplat.Type >= IsoFloorBloodSplat.FloorBloodTypes.length) continue;
                    isoFloorBloodSplat.chunk = object;
                    splatByType.get(isoFloorBloodSplat.Type).add(isoFloorBloodSplat);
                }
            }
        }
        for (n2 = 0; n2 < splatByType.size(); ++n2) {
            ArrayList<IsoFloorBloodSplat> arrayList = splatByType.get(n2);
            if (arrayList.isEmpty()) continue;
            object = IsoFloorBloodSplat.FloorBloodTypes[n2];
            IsoSprite isoSprite = null;
            if (!IsoFloorBloodSplat.SpriteMap.containsKey(object)) {
                IsoSprite isoSprite2 = IsoSprite.CreateSprite(IsoSpriteManager.instance);
                isoSprite2.LoadFramesPageSimple((String)object, (String)object, (String)object, (String)object);
                IsoFloorBloodSplat.SpriteMap.put((String)object, isoSprite2);
                isoSprite = isoSprite2;
            } else {
                isoSprite = IsoFloorBloodSplat.SpriteMap.get(object);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                IsoGridSquare isoGridSquare;
                IsoFloorBloodSplat isoFloorBloodSplat = arrayList.get(i);
                IsoChunkMap.inf.r = 1.0f;
                IsoChunkMap.inf.g = 1.0f;
                IsoChunkMap.inf.b = 1.0f;
                IsoChunkMap.inf.a = 0.27f;
                float f2 = (isoFloorBloodSplat.x + isoFloorBloodSplat.y / isoFloorBloodSplat.x) * (float)(isoFloorBloodSplat.Type + 1);
                float f3 = f2 * isoFloorBloodSplat.x / isoFloorBloodSplat.y * (float)(isoFloorBloodSplat.Type + 1) / (f2 + isoFloorBloodSplat.y);
                float f4 = f3 * f2 * f3 * isoFloorBloodSplat.x / (isoFloorBloodSplat.y + 2.0f);
                f2 *= 42367.543f;
                f3 *= 6367.123f;
                f4 *= 23367.133f;
                f2 %= 1000.0f;
                f3 %= 1000.0f;
                f4 %= 1000.0f;
                f2 /= 1000.0f;
                f3 /= 1000.0f;
                f4 /= 1000.0f;
                if (f2 > 0.25f) {
                    f2 = 0.25f;
                }
                IsoChunkMap.inf.r -= f2 * 2.0f;
                IsoChunkMap.inf.g -= f2 * 2.0f;
                IsoChunkMap.inf.b -= f2 * 2.0f;
                IsoChunkMap.inf.r += f3 / 3.0f;
                IsoChunkMap.inf.g -= f4 / 3.0f;
                IsoChunkMap.inf.b -= f4 / 3.0f;
                float f5 = f - isoFloorBloodSplat.worldAge;
                if (f5 >= 0.0f && f5 < 72.0f) {
                    float f6 = 1.0f - f5 / 72.0f;
                    IsoChunkMap.inf.r *= 0.2f + f6 * 0.8f;
                    IsoChunkMap.inf.g *= 0.2f + f6 * 0.8f;
                    IsoChunkMap.inf.b *= 0.2f + f6 * 0.8f;
                    IsoChunkMap.inf.a *= 0.25f + f6 * 0.75f;
                } else {
                    IsoChunkMap.inf.r *= 0.2f;
                    IsoChunkMap.inf.g *= 0.2f;
                    IsoChunkMap.inf.b *= 0.2f;
                    IsoChunkMap.inf.a *= 0.25f;
                }
                if (isoFloorBloodSplat.fade > 0) {
                    IsoChunkMap.inf.a *= (float)isoFloorBloodSplat.fade / ((float)PerformanceSettings.getLockFPS() * 5.0f);
                    if (--isoFloorBloodSplat.fade == 0) {
                        isoFloorBloodSplat.chunk.FloorBloodSplatsFade.remove(isoFloorBloodSplat);
                    }
                }
                if ((isoGridSquare = isoFloorBloodSplat.chunk.getGridSquare((int)isoFloorBloodSplat.x, (int)isoFloorBloodSplat.y, (int)isoFloorBloodSplat.z)) != null) {
                    int n5 = isoGridSquare.getVertLight(0, n3);
                    int n6 = isoGridSquare.getVertLight(1, n3);
                    int n7 = isoGridSquare.getVertLight(2, n3);
                    int n8 = isoGridSquare.getVertLight(3, n3);
                    float f7 = Color.getRedChannelFromABGR(n5);
                    float f8 = Color.getGreenChannelFromABGR(n5);
                    float f9 = Color.getBlueChannelFromABGR(n5);
                    float f10 = Color.getRedChannelFromABGR(n6);
                    float f11 = Color.getGreenChannelFromABGR(n6);
                    float f12 = Color.getBlueChannelFromABGR(n6);
                    float f13 = Color.getRedChannelFromABGR(n7);
                    float f14 = Color.getGreenChannelFromABGR(n7);
                    float f15 = Color.getBlueChannelFromABGR(n7);
                    float f16 = Color.getRedChannelFromABGR(n8);
                    float f17 = Color.getGreenChannelFromABGR(n8);
                    float f18 = Color.getBlueChannelFromABGR(n8);
                    IsoChunkMap.inf.r *= (f7 + f10 + f13 + f16) / 4.0f;
                    IsoChunkMap.inf.g *= (f8 + f11 + f14 + f17) / 4.0f;
                    IsoChunkMap.inf.b *= (f9 + f12 + f15 + f18) / 4.0f;
                }
                isoSprite.renderBloodSplat((float)(isoFloorBloodSplat.chunk.wx * 10) + isoFloorBloodSplat.x, (float)(isoFloorBloodSplat.chunk.wy * 10) + isoFloorBloodSplat.y, isoFloorBloodSplat.z, inf);
            }
        }
    }

    public void copy(IsoChunkMap isoChunkMap) {
        IsoChunkMap isoChunkMap2 = this;
        isoChunkMap2.WorldX = isoChunkMap.WorldX;
        isoChunkMap2.WorldY = isoChunkMap.WorldY;
        isoChunkMap2.XMinTiles = -1;
        isoChunkMap2.YMinTiles = -1;
        isoChunkMap2.XMaxTiles = -1;
        isoChunkMap2.YMaxTiles = -1;
        for (int i = 0; i < ChunkGridWidth * ChunkGridWidth; ++i) {
            isoChunkMap2.bReadBufferA = isoChunkMap.bReadBufferA;
            if (isoChunkMap2.bReadBufferA) {
                if (isoChunkMap.chunksSwapA[i] == null) continue;
                isoChunkMap.chunksSwapA[i].refs.add(isoChunkMap2);
                isoChunkMap2.chunksSwapA[i] = isoChunkMap.chunksSwapA[i];
                continue;
            }
            if (isoChunkMap.chunksSwapB[i] == null) continue;
            isoChunkMap.chunksSwapB[i].refs.add(isoChunkMap2);
            isoChunkMap2.chunksSwapB[i] = isoChunkMap.chunksSwapB[i];
        }
    }

    public void Unload() {
        for (int i = 0; i < ChunkGridWidth; ++i) {
            for (int j = 0; j < ChunkGridWidth; ++j) {
                IsoChunk isoChunk = this.getChunk(j, i);
                if (isoChunk == null) continue;
                if (isoChunk.refs.contains(this)) {
                    isoChunk.refs.remove(this);
                    if (isoChunk.refs.isEmpty()) {
                        SharedChunks.remove((isoChunk.wx << 16) + isoChunk.wy);
                        isoChunk.removeFromWorld();
                        ChunkSaveWorker.instance.Add(isoChunk);
                    }
                }
                this.chunksSwapA[i * IsoChunkMap.ChunkGridWidth + j] = null;
                this.chunksSwapB[i * IsoChunkMap.ChunkGridWidth + j] = null;
            }
        }
        WorldSimulation.instance.deactivateChunkMap(this.PlayerID);
        this.XMinTiles = -1;
        this.XMaxTiles = -1;
        this.YMinTiles = -1;
        this.YMaxTiles = -1;
        if (IsoWorld.instance != null && IsoWorld.instance.CurrentCell != null) {
            IsoWorld.instance.CurrentCell.clearCacheGridSquare(this.PlayerID);
        }
    }

    static {
        ChunkGridWidth = StartChunkGridWidth = 13;
        ChunkWidthInTiles = 10 * ChunkGridWidth;
        inf = new ColorInfo();
        saveList = new ArrayList();
        splatByType = new ArrayList();
        for (int i = 0; i < IsoFloorBloodSplat.FloorBloodTypes.length; ++i) {
            splatByType.add(new ArrayList());
        }
    }
}

