/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joml.Vector2i;
import se.krka.kahlua.integration.annotations.LuaMethod;
import se.krka.kahlua.vm.JavaFunction;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.LuaClosure;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.IndieGL;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaHookManager;
import zombie.Lua.LuaManager;
import zombie.MovingObjectUpdateScheduler;
import zombie.ReanimatedPlayers;
import zombie.SandboxOptions;
import zombie.VirtualZombieManager;
import zombie.ZomboidFileSystem;
import zombie.ai.astar.Mover;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.physics.WorldSimulation;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.profiling.PerformanceProfileProbeList;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.core.utils.IntGrid;
import zombie.core.utils.OnceEvery;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.debug.LineDrawer;
import zombie.erosion.utils.Noise2D;
import zombie.gameStates.GameLoadingState;
import zombie.input.JoypadManager;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.iso.BuildingDef;
import zombie.iso.CellLoader;
import zombie.iso.ChunkSaveWorker;
import zombie.iso.DiamondMatrixIterator;
import zombie.iso.IsoCamera;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridOcclusionData;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoGridStack;
import zombie.iso.IsoHeatSource;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoLot;
import zombie.iso.IsoMarkers;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoPushableObject;
import zombie.iso.IsoRoomLight;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWater;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.LotHeader;
import zombie.iso.RoomDef;
import zombie.iso.SliceY;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.WorldMarkers;
import zombie.iso.WorldReuserThread;
import zombie.iso.areas.BuildingScore;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.areas.IsoRoom;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.sprite.CorpseFlies;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.iso.sprite.shapers.FloorShaper;
import zombie.iso.sprite.shapers.FloorShaperAttachedSprites;
import zombie.iso.sprite.shapers.FloorShaperDiamond;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.fog.ImprovedFog;
import zombie.iso.weather.fx.IsoWeatherFX;
import zombie.iso.weather.fx.WeatherFxMask;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.popman.NetworkZombieSimulator;
import zombie.savefile.ClientPlayerDB;
import zombie.savefile.PlayerDB;
import zombie.scripting.objects.VehicleScript;
import zombie.ui.UIManager;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class IsoCell {
    public static int MaxHeight = 8;
    private static Shader m_floorRenderShader;
    private static Shader m_wallRenderShader;
    public ArrayList<IsoGridSquare> Trees = new ArrayList();
    static final ArrayList<IsoGridSquare> stchoices;
    public final IsoChunkMap[] ChunkMap = new IsoChunkMap[4];
    public final ArrayList<IsoBuilding> BuildingList = new ArrayList();
    private final ArrayList<IsoWindow> WindowList = new ArrayList();
    private final ArrayList<IsoMovingObject> ObjectList = new ArrayList();
    private final ArrayList<IsoPushableObject> PushableObjectList = new ArrayList();
    private final HashMap<Integer, BuildingScore> BuildingScores = new HashMap();
    private final ArrayList<IsoRoom> RoomList = new ArrayList();
    private final ArrayList<IsoObject> StaticUpdaterObjectList = new ArrayList();
    private final ArrayList<IsoZombie> ZombieList = new ArrayList();
    private final ArrayList<IsoGameCharacter> RemoteSurvivorList = new ArrayList();
    private final ArrayList<IsoMovingObject> removeList = new ArrayList();
    private final ArrayList<IsoMovingObject> addList = new ArrayList();
    private final ArrayList<IsoObject> ProcessIsoObject = new ArrayList();
    private final ArrayList<IsoObject> ProcessIsoObjectRemove = new ArrayList();
    private final ArrayList<InventoryItem> ProcessItems = new ArrayList();
    private final ArrayList<InventoryItem> ProcessItemsRemove = new ArrayList();
    private final ArrayList<IsoWorldInventoryObject> ProcessWorldItems = new ArrayList();
    public final ArrayList<IsoWorldInventoryObject> ProcessWorldItemsRemove = new ArrayList();
    private final IsoGridSquare[][] gridSquares = new IsoGridSquare[4][IsoChunkMap.ChunkWidthInTiles * IsoChunkMap.ChunkWidthInTiles * 8];
    public static final boolean ENABLE_SQUARE_CACHE = true;
    private int height;
    private int width;
    private int worldX;
    private int worldY;
    public IntGrid DangerScore;
    private boolean safeToAdd = true;
    private final Stack<IsoLightSource> LamppostPositions = new Stack();
    public final ArrayList<IsoRoomLight> roomLights = new ArrayList();
    private final ArrayList<IsoHeatSource> heatSources = new ArrayList();
    public final ArrayList<BaseVehicle> addVehicles = new ArrayList();
    public final ArrayList<BaseVehicle> vehicles = new ArrayList();
    public static final int ISOANGLEFACTOR = 3;
    private static final int ZOMBIESCANBUDGET = 10;
    private static final float NEARESTZOMBIEDISTSQRMAX = 150.0f;
    private int zombieScanCursor = 0;
    private final IsoZombie[] nearestVisibleZombie = new IsoZombie[4];
    private final float[] nearestVisibleZombieDistSqr = new float[4];
    private static Stack<BuildingScore> buildingscores;
    static ArrayList<IsoGridSquare> GridStack;
    public static final int RTF_SolidFloor = 1;
    public static final int RTF_VegetationCorpses = 2;
    public static final int RTF_MinusFloorCharacters = 4;
    public static final int RTF_ShadedFloor = 8;
    public static final int RTF_Shadows = 16;
    private static final ArrayList<IsoGridSquare> ShadowSquares;
    private static final ArrayList<IsoGridSquare> MinusFloorCharacters;
    private static final ArrayList<IsoGridSquare> SolidFloor;
    private static final ArrayList<IsoGridSquare> ShadedFloor;
    private static final ArrayList<IsoGridSquare> VegetationCorpses;
    public static final PerPlayerRender[] perPlayerRender;
    private final int[] StencilXY = new int[]{0, 0, -1, 0, 0, -1, -1, -1, -2, -1, -1, -2, -2, -2, -3, -2, -2, -3, -3, -3};
    private final int[] StencilXY2z = new int[]{0, 0, -1, 0, 0, -1, -1, -1, -2, -1, -1, -2, -2, -2, -3, -2, -2, -3, -3, -3, -4, -3, -3, -4, -4, -4, -5, -4, -4, -5, -5, -5, -6, -5, -5, -6, -6, -6};
    public int StencilX1;
    public int StencilY1;
    public int StencilX2;
    public int StencilY2;
    private Texture m_stencilTexture = null;
    private final DiamondMatrixIterator diamondMatrixIterator = new DiamondMatrixIterator(123);
    private final Vector2i diamondMatrixPos = new Vector2i();
    public int DeferredCharacterTick = 0;
    private boolean hasSetupSnowGrid = false;
    private SnowGridTiles snowGridTiles_Square;
    private SnowGridTiles[] snowGridTiles_Strip;
    private SnowGridTiles[] snowGridTiles_Edge;
    private SnowGridTiles[] snowGridTiles_Cove;
    private SnowGridTiles snowGridTiles_Enclosed;
    private int m_snowFirstNonSquare = -1;
    private Noise2D snowNoise2D = new Noise2D();
    private SnowGrid snowGridCur;
    private SnowGrid snowGridPrev;
    private int snowFracTarget = 0;
    private long snowFadeTime = 0L;
    private float snowTransitionTime = 5000.0f;
    private int raport = 0;
    private static final int SNOWSHORE_NONE = 0;
    private static final int SNOWSHORE_N = 1;
    private static final int SNOWSHORE_E = 2;
    private static final int SNOWSHORE_S = 4;
    private static final int SNOWSHORE_W = 8;
    public boolean recalcFloors = false;
    static int wx;
    static int wy;
    final KahluaTable[] drag = new KahluaTable[4];
    final ArrayList<IsoSurvivor> SurvivorList = new ArrayList();
    private static Texture texWhite;
    private static IsoCell instance;
    private int currentLX = 0;
    private int currentLY = 0;
    private int currentLZ = 0;
    int recalcShading = 30;
    int lastMinX = -1234567;
    int lastMinY = -1234567;
    private float rainScroll;
    private int[] rainX = new int[4];
    private int[] rainY = new int[4];
    private Texture[] rainTextures = new Texture[5];
    private long[] rainFileTime = new long[5];
    private float rainAlphaMax = 0.6f;
    private float[] rainAlpha = new float[4];
    protected int rainIntensity = 0;
    protected int rainSpeed = 6;
    int lightUpdateCount = 11;
    public boolean bRendering = false;
    final boolean[] bHideFloors = new boolean[4];
    final int[] unhideFloorsCounter = new int[4];
    boolean bOccludedByOrphanStructureFlag = false;
    int playerPeekedRoomId = -1;
    final ArrayList<ArrayList<IsoBuilding>> playerOccluderBuildings = new ArrayList(4);
    final IsoBuilding[][] playerOccluderBuildingsArr = new IsoBuilding[4][];
    final int[] playerWindowPeekingRoomId = new int[4];
    final boolean[] playerHidesOrphanStructures = new boolean[4];
    final boolean[] playerCutawaysDirty = new boolean[4];
    final Vector2 tempCutawaySqrVector = new Vector2();
    ArrayList<Integer> tempPrevPlayerCutawayRoomIDs = new ArrayList();
    ArrayList<Integer> tempPlayerCutawayRoomIDs = new ArrayList();
    final IsoGridSquare[] lastPlayerSquare = new IsoGridSquare[4];
    final boolean[] lastPlayerSquareHalf = new boolean[4];
    final IsoDirections[] lastPlayerDir = new IsoDirections[4];
    final Vector2[] lastPlayerAngle = new Vector2[4];
    int hidesOrphanStructuresAbove = MaxHeight;
    final Rectangle buildingRectTemp = new Rectangle();
    final ArrayList<ArrayList<IsoBuilding>> zombieOccluderBuildings = new ArrayList(4);
    final IsoBuilding[][] zombieOccluderBuildingsArr = new IsoBuilding[4][];
    final IsoGridSquare[] lastZombieSquare = new IsoGridSquare[4];
    final boolean[] lastZombieSquareHalf = new boolean[4];
    final ArrayList<ArrayList<IsoBuilding>> otherOccluderBuildings = new ArrayList(4);
    final IsoBuilding[][] otherOccluderBuildingsArr = new IsoBuilding[4][];
    final int mustSeeSquaresRadius = 4;
    final int mustSeeSquaresGridSize = 10;
    final ArrayList<IsoGridSquare> gridSquaresTempLeft = new ArrayList(100);
    final ArrayList<IsoGridSquare> gridSquaresTempRight = new ArrayList(100);
    private IsoWeatherFX weatherFX;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    private OnceEvery dangerUpdate = new OnceEvery(0.4f, false);
    private Thread LightInfoUpdate = null;
    private final Stack<IsoRoom> SpottedRooms = new Stack();
    private IsoZombie fakeZombieForHit;

    public static int getMaxHeight() {
        return MaxHeight;
    }

    public LotHeader getCurrentLotHeader() {
        IsoChunk isoChunk = this.getChunkForGridSquare((int)IsoCamera.CamCharacter.x, (int)IsoCamera.CamCharacter.y, (int)IsoCamera.CamCharacter.z);
        return isoChunk.lotheader;
    }

    public IsoChunkMap getChunkMap(int n) {
        return this.ChunkMap[n];
    }

    public IsoGridSquare getFreeTile(RoomDef roomDef) {
        stchoices.clear();
        for (int i = 0; i < roomDef.rects.size(); ++i) {
            RoomDef.RoomRect roomRect = roomDef.rects.get(i);
            for (int j = roomRect.x; j < roomRect.x + roomRect.w; ++j) {
                for (int k = roomRect.y; k < roomRect.y + roomRect.h; ++k) {
                    IsoGridSquare isoGridSquare = this.getGridSquare(j, k, roomDef.level);
                    if (isoGridSquare == null) continue;
                    isoGridSquare.setCachedIsFree(false);
                    isoGridSquare.setCacheIsFree(false);
                    if (!isoGridSquare.isFree(false)) continue;
                    stchoices.add(isoGridSquare);
                }
            }
        }
        if (stchoices.isEmpty()) {
            return null;
        }
        IsoGridSquare isoGridSquare = stchoices.get(Rand.Next(stchoices.size()));
        stchoices.clear();
        return isoGridSquare;
    }

    public static Stack<BuildingScore> getBuildings() {
        return buildingscores;
    }

    public static void setBuildings(Stack<BuildingScore> stack) {
        buildingscores = stack;
    }

    public IsoZombie getNearestVisibleZombie(int n) {
        return this.nearestVisibleZombie[n];
    }

    public IsoChunk getChunkForGridSquare(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            if (this.ChunkMap[i].ignore) continue;
            n = n4;
            n2 = n5;
            if ((n -= this.ChunkMap[i].getWorldXMinTiles()) < 0 || (n2 -= this.ChunkMap[i].getWorldYMinTiles()) < 0) continue;
            IsoChunkMap cfr_ignored_0 = this.ChunkMap[i];
            IsoChunkMap cfr_ignored_1 = this.ChunkMap[i];
            IsoChunk isoChunk = null;
            isoChunk = this.ChunkMap[i].getChunk(n /= 10, n2 /= 10);
            if (isoChunk == null) continue;
            return isoChunk;
        }
        return null;
    }

    public IsoChunk getChunk(int n, int n2) {
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoChunk isoChunk;
            IsoChunkMap isoChunkMap = this.ChunkMap[i];
            if (isoChunkMap.ignore || (isoChunk = isoChunkMap.getChunk(n - isoChunkMap.getWorldXMin(), n2 - isoChunkMap.getWorldYMin())) == null) continue;
            return isoChunk;
        }
        return null;
    }

    public IsoCell(int n, int n2) {
        IsoWorld.instance.CurrentCell = this;
        instance = this;
        this.width = n;
        this.height = n2;
        for (int i = 0; i < 4; ++i) {
            this.ChunkMap[i] = new IsoChunkMap(this);
            this.ChunkMap[i].PlayerID = i;
            this.ChunkMap[i].ignore = i > 0;
            this.playerOccluderBuildings.add(new ArrayList(5));
            this.zombieOccluderBuildings.add(new ArrayList(5));
            this.otherOccluderBuildings.add(new ArrayList(5));
        }
        WorldReuserThread.instance.run();
    }

    public short getStencilValue(int n, int n2, int n3) {
        short[][][] sArray = IsoCell.perPlayerRender[IsoCamera.frameState.playerIndex].StencilValues;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.StencilXY.length; i += 2) {
            short[] sArray2;
            int n6 = -n3 * 3;
            int n7 = n + n6 + this.StencilXY[i];
            int n8 = n2 + n6 + this.StencilXY[i + 1];
            if (n7 < this.minX || n7 >= this.maxX || n8 < this.minY || n8 >= this.maxY || (sArray2 = sArray[n7 - this.minX][n8 - this.minY])[0] == 0) continue;
            if (n4 == 0) {
                n4 = sArray2[0];
                n5 = sArray2[1];
                continue;
            }
            n4 = Math.min(sArray2[0], n4);
            n5 = Math.max(sArray2[1], n5);
        }
        if (n4 == 0) {
            return 1;
        }
        if (n4 > 10) {
            return (short)(n4 - 10);
        }
        return (short)(n5 + 1);
    }

    public void setStencilValue(int n, int n2, int n3, int n4) {
        short[][][] sArray = IsoCell.perPlayerRender[IsoCamera.frameState.playerIndex].StencilValues;
        for (int i = 0; i < this.StencilXY.length; i += 2) {
            int n5 = -n3 * 3;
            int n6 = n + n5 + this.StencilXY[i];
            int n7 = n2 + n5 + this.StencilXY[i + 1];
            if (n6 < this.minX || n6 >= this.maxX || n7 < this.minY || n7 >= this.maxY) continue;
            short[] sArray2 = sArray[n6 - this.minX][n7 - this.minY];
            if (sArray2[0] == 0) {
                sArray2[0] = (short)n4;
                sArray2[1] = (short)n4;
                continue;
            }
            sArray2[0] = (short)Math.min(sArray2[0], n4);
            sArray2[1] = (short)Math.max(sArray2[1], n4);
        }
    }

    public short getStencilValue2z(int n, int n2, int n3) {
        short[][][] sArray = IsoCell.perPlayerRender[IsoCamera.frameState.playerIndex].StencilValues;
        int n4 = 0;
        int n5 = 0;
        int n6 = -n3 * 3;
        for (int i = 0; i < this.StencilXY2z.length; i += 2) {
            short[] sArray2;
            int n7 = n + n6 + this.StencilXY2z[i];
            int n8 = n2 + n6 + this.StencilXY2z[i + 1];
            if (n7 < this.minX || n7 >= this.maxX || n8 < this.minY || n8 >= this.maxY || (sArray2 = sArray[n7 - this.minX][n8 - this.minY])[0] == 0) continue;
            if (n4 == 0) {
                n4 = sArray2[0];
                n5 = sArray2[1];
                continue;
            }
            n4 = Math.min(sArray2[0], n4);
            n5 = Math.max(sArray2[1], n5);
        }
        if (n4 == 0) {
            return 1;
        }
        if (n4 > 10) {
            return (short)(n4 - 10);
        }
        return (short)(n5 + 1);
    }

    public void setStencilValue2z(int n, int n2, int n3, int n4) {
        short[][][] sArray = IsoCell.perPlayerRender[IsoCamera.frameState.playerIndex].StencilValues;
        int n5 = -n3 * 3;
        for (int i = 0; i < this.StencilXY2z.length; i += 2) {
            int n6 = n + n5 + this.StencilXY2z[i];
            int n7 = n2 + n5 + this.StencilXY2z[i + 1];
            if (n6 < this.minX || n6 >= this.maxX || n7 < this.minY || n7 >= this.maxY) continue;
            short[] sArray2 = sArray[n6 - this.minX][n7 - this.minY];
            if (sArray2[0] == 0) {
                sArray2[0] = (short)n4;
                sArray2[1] = (short)n4;
                continue;
            }
            sArray2[0] = (short)Math.min(sArray2[0], n4);
            sArray2[1] = (short)Math.max(sArray2[1], n4);
        }
    }

    public void CalculateVertColoursForTile(IsoGridSquare isoGridSquare, int n, int n2, int n3, int n4) {
        IsoGridSquare isoGridSquare2 = !IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 0, 0, 1) ? isoGridSquare.nav[IsoDirections.NW.index()] : null;
        IsoGridSquare isoGridSquare3 = !IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 1, 0, 1) ? isoGridSquare.nav[IsoDirections.N.index()] : null;
        IsoGridSquare isoGridSquare4 = !IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 2, 0, 1) ? isoGridSquare.nav[IsoDirections.NE.index()] : null;
        IsoGridSquare isoGridSquare5 = !IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 2, 1, 1) ? isoGridSquare.nav[IsoDirections.E.index()] : null;
        IsoGridSquare isoGridSquare6 = !IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 2, 2, 1) ? isoGridSquare.nav[IsoDirections.SE.index()] : null;
        IsoGridSquare isoGridSquare7 = !IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 1, 2, 1) ? isoGridSquare.nav[IsoDirections.S.index()] : null;
        IsoGridSquare isoGridSquare8 = !IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 0, 2, 1) ? isoGridSquare.nav[IsoDirections.SW.index()] : null;
        IsoGridSquare isoGridSquare9 = !IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 0, 1, 1) ? isoGridSquare.nav[IsoDirections.W.index()] : null;
        this.CalculateColor(isoGridSquare2, isoGridSquare3, isoGridSquare9, isoGridSquare, 0, n4);
        this.CalculateColor(isoGridSquare3, isoGridSquare4, isoGridSquare5, isoGridSquare, 1, n4);
        this.CalculateColor(isoGridSquare6, isoGridSquare7, isoGridSquare5, isoGridSquare, 2, n4);
        this.CalculateColor(isoGridSquare8, isoGridSquare7, isoGridSquare9, isoGridSquare, 3, n4);
    }

    private Texture getStencilTexture() {
        if (this.m_stencilTexture == null) {
            this.m_stencilTexture = Texture.getSharedTexture("media/mask_circledithernew.png");
        }
        return this.m_stencilTexture;
    }

    public void DrawStencilMask() {
        Texture texture = this.getStencilTexture();
        if (texture == null) {
            return;
        }
        IndieGL.glStencilMask(255);
        IndieGL.glClear(1280);
        int n = IsoCamera.getOffscreenWidth(IsoPlayer.getPlayerIndex()) / 2;
        int n2 = IsoCamera.getOffscreenHeight(IsoPlayer.getPlayerIndex()) / 2;
        n -= texture.getWidth() / (2 / Core.TileScale);
        n2 -= texture.getHeight() / (2 / Core.TileScale);
        IndieGL.enableStencilTest();
        IndieGL.enableAlphaTest();
        IndieGL.glAlphaFunc(516, 0.1f);
        IndieGL.glStencilFunc(519, 128, 255);
        IndieGL.glStencilOp(7680, 7680, 7681);
        IndieGL.glColorMask(false, false, false, false);
        texture.renderstrip(n - (int)IsoCamera.getRightClickOffX(), n2 - (int)IsoCamera.getRightClickOffY(), texture.getWidth() * Core.TileScale, texture.getHeight() * Core.TileScale, 1.0f, 1.0f, 1.0f, 1.0f, null);
        IndieGL.glColorMask(true, true, true, true);
        IndieGL.glStencilFunc(519, 0, 255);
        IndieGL.glStencilOp(7680, 7680, 7680);
        IndieGL.glStencilMask(127);
        IndieGL.glAlphaFunc(519, 0.0f);
        this.StencilX1 = n - (int)IsoCamera.getRightClickOffX();
        this.StencilY1 = n2 - (int)IsoCamera.getRightClickOffY();
        this.StencilX2 = this.StencilX1 + texture.getWidth() * Core.TileScale;
        this.StencilY2 = this.StencilY1 + texture.getHeight() * Core.TileScale;
    }

    public void RenderTiles(int n) {
        s_performance.isoCellRenderTiles.invokeAndMeasure(this, n, IsoCell::renderTilesInternal);
    }

    private void renderTilesInternal(int n) {
        if (!DebugOptions.instance.Terrain.RenderTiles.Enable.getValue()) {
            return;
        }
        if (m_floorRenderShader == null) {
            RenderThread.invokeOnRenderContext(this::initTileShaders);
        }
        int n2 = IsoCamera.frameState.playerIndex;
        IsoPlayer isoPlayer = IsoPlayer.players[n2];
        isoPlayer.dirtyRecalcGridStackTime -= GameTime.getInstance().getMultiplier() / 4.0f;
        PerPlayerRender perPlayerRender = this.getPerPlayerRenderAt(n2);
        perPlayerRender.setSize(this.maxX - this.minX + 1, this.maxY - this.minY + 1);
        long l = System.currentTimeMillis();
        if (this.minX != perPlayerRender.minX || this.minY != perPlayerRender.minY || this.maxX != perPlayerRender.maxX || this.maxY != perPlayerRender.maxY) {
            perPlayerRender.minX = this.minX;
            perPlayerRender.minY = this.minY;
            perPlayerRender.maxX = this.maxX;
            perPlayerRender.maxY = this.maxY;
            isoPlayer.dirtyRecalcGridStack = true;
            WeatherFxMask.forceMaskUpdate(n2);
        }
        s_performance.renderTiles.recalculateAnyGridStacks.start();
        boolean bl = isoPlayer.dirtyRecalcGridStack;
        this.recalculateAnyGridStacks(perPlayerRender, n, n2, l);
        s_performance.renderTiles.recalculateAnyGridStacks.end();
        ++this.DeferredCharacterTick;
        s_performance.renderTiles.flattenAnyFoliage.start();
        this.flattenAnyFoliage(perPlayerRender, n2);
        s_performance.renderTiles.flattenAnyFoliage.end();
        if (this.SetCutawayRoomsForPlayer() || bl) {
            IsoGridStack isoGridStack = perPlayerRender.GridStacks;
            for (int i = 0; i < n + 1; ++i) {
                GridStack = isoGridStack.Squares.get(i);
                for (int j = 0; j < GridStack.size(); ++j) {
                    IsoGridSquare isoGridSquare = GridStack.get(j);
                    isoGridSquare.setPlayerCutawayFlag(n2, this.IsCutawaySquare(isoGridSquare, l), l);
                }
            }
        }
        s_performance.renderTiles.performRenderTiles.start();
        this.performRenderTiles(perPlayerRender, n, n2, l);
        s_performance.renderTiles.performRenderTiles.end();
        this.playerCutawaysDirty[n2] = false;
        ShadowSquares.clear();
        MinusFloorCharacters.clear();
        ShadedFloor.clear();
        SolidFloor.clear();
        VegetationCorpses.clear();
        s_performance.renderTiles.renderDebugPhysics.start();
        this.renderDebugPhysics(n2);
        s_performance.renderTiles.renderDebugPhysics.end();
        s_performance.renderTiles.renderDebugLighting.start();
        this.renderDebugLighting(perPlayerRender, n);
        s_performance.renderTiles.renderDebugLighting.end();
    }

    private void initTileShaders() {
        if (DebugLog.isEnabled(DebugType.Shader)) {
            DebugLog.Shader.debugln("Loading shader: \"floorTile\"");
        }
        m_floorRenderShader = new Shader("floorTile");
        if (DebugLog.isEnabled(DebugType.Shader)) {
            DebugLog.Shader.debugln("Loading shader: \"wallTile\"");
        }
        m_wallRenderShader = new Shader("wallTile");
    }

    private PerPlayerRender getPerPlayerRenderAt(int n) {
        if (perPlayerRender[n] == null) {
            IsoCell.perPlayerRender[n] = new PerPlayerRender();
        }
        return perPlayerRender[n];
    }

    private void recalculateAnyGridStacks(PerPlayerRender perPlayerRender, int n, int n2, long l) {
        IsoPlayer isoPlayer = IsoPlayer.players[n2];
        if (!isoPlayer.dirtyRecalcGridStack) {
            return;
        }
        isoPlayer.dirtyRecalcGridStack = false;
        IsoGridStack isoGridStack = perPlayerRender.GridStacks;
        boolean[][][] blArray = perPlayerRender.VisiOccludedFlags;
        boolean[][] blArray2 = perPlayerRender.VisiCulledFlags;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        WeatherFxMask.setDiamondIterDone(n2);
        for (int i = n; i >= 0; --i) {
            int n6;
            Object object;
            GridStack = isoGridStack.Squares.get(i);
            GridStack.clear();
            if (i >= this.maxZ) continue;
            if (DebugOptions.instance.Terrain.RenderTiles.NewRender.getValue()) {
                DiamondMatrixIterator diamondMatrixIterator = this.diamondMatrixIterator.reset(this.maxX - this.minX);
                IsoGridSquare isoGridSquare = null;
                object = this.diamondMatrixPos;
                while (diamondMatrixIterator.next((Vector2i)object)) {
                    if (((Vector2i)object).y >= this.maxY - this.minY + 1) continue;
                    isoGridSquare = this.ChunkMap[n2].getGridSquare(((Vector2i)object).x + this.minX, ((Vector2i)object).y + this.minY, i);
                    if (i == 0) {
                        blArray[((Vector2i)object).x][((Vector2i)object).y][0] = false;
                        blArray[((Vector2i)object).x][((Vector2i)object).y][1] = false;
                        blArray2[((Vector2i)object).x][((Vector2i)object).y] = false;
                    }
                    if (isoGridSquare == null) {
                        WeatherFxMask.addMaskLocation(null, ((Vector2i)object).x + this.minX, ((Vector2i)object).y + this.minY, i);
                        continue;
                    }
                    IsoChunk isoChunk = isoGridSquare.getChunk();
                    if (isoChunk == null || !isoGridSquare.IsOnScreen(true)) continue;
                    WeatherFxMask.addMaskLocation(isoGridSquare, ((Vector2i)object).x + this.minX, ((Vector2i)object).y + this.minY, i);
                    n6 = this.IsDissolvedSquare(isoGridSquare, n2) ? 1 : 0;
                    isoGridSquare.setIsDissolved(n2, n6 != 0, l);
                    if (isoGridSquare.getIsDissolved(n2, l)) continue;
                    isoGridSquare.cacheLightInfo();
                    GridStack.add(isoGridSquare);
                }
                continue;
            }
            for (int j = this.minY; j < this.maxY; ++j) {
                int n7 = this.minX;
                object = this.ChunkMap[n2].getGridSquare(n7, j, i);
                int n8 = IsoDirections.E.index();
                while (n7 < this.maxX) {
                    IsoChunk isoChunk;
                    if (i == 0) {
                        blArray[n7 - this.minX][j - this.minY][0] = false;
                        blArray[n7 - this.minX][j - this.minY][1] = false;
                        blArray2[n7 - this.minX][j - this.minY] = false;
                    }
                    if (object != null && ((IsoGridSquare)object).getY() != j) {
                        object = null;
                    }
                    n6 = -1;
                    int n9 = -1;
                    int n10 = n7;
                    int n11 = j;
                    IsoChunkMap cfr_ignored_0 = this.ChunkMap[n2];
                    IsoChunkMap cfr_ignored_1 = this.ChunkMap[n2];
                    n10 -= (this.ChunkMap[n2].WorldX - IsoChunkMap.ChunkGridWidth / 2) * 10;
                    IsoChunkMap cfr_ignored_2 = this.ChunkMap[n2];
                    IsoChunkMap cfr_ignored_3 = this.ChunkMap[n2];
                    n11 -= (this.ChunkMap[n2].WorldY - IsoChunkMap.ChunkGridWidth / 2) * 10;
                    IsoChunkMap cfr_ignored_4 = this.ChunkMap[n2];
                    IsoChunkMap cfr_ignored_5 = this.ChunkMap[n2];
                    n6 = n10 /= 10;
                    n9 = n11 /= 10;
                    if ((n6 != n3 || n9 != n4) && (isoChunk = this.ChunkMap[n2].getChunkForGridSquare(n7, j)) != null) {
                        n5 = isoChunk.maxLevel;
                    }
                    n3 = n6;
                    n4 = n9;
                    if (n5 < i) {
                        ++n7;
                        continue;
                    }
                    if (object == null && (object = this.getGridSquare(n7, j, i)) == null && (object = this.ChunkMap[n2].getGridSquare(n7, j, i)) == null) {
                        ++n7;
                        continue;
                    }
                    IsoChunk isoChunk2 = ((IsoGridSquare)object).getChunk();
                    if (isoChunk2 != null && ((IsoGridSquare)object).IsOnScreen(true)) {
                        WeatherFxMask.addMaskLocation((IsoGridSquare)object, ((IsoGridSquare)object).x, ((IsoGridSquare)object).y, i);
                        n11 = this.IsDissolvedSquare((IsoGridSquare)object, n2) ? 1 : 0;
                        ((IsoGridSquare)object).setIsDissolved(n2, n11 != 0, l);
                        if (!((IsoGridSquare)object).getIsDissolved(n2, l)) {
                            ((IsoGridSquare)object).cacheLightInfo();
                            GridStack.add((IsoGridSquare)object);
                        }
                    }
                    object = ((IsoGridSquare)object).nav[n8];
                    ++n7;
                }
            }
        }
        this.CullFullyOccludedSquares(isoGridStack, blArray, blArray2);
    }

    private void flattenAnyFoliage(PerPlayerRender perPlayerRender, int n) {
        int n2;
        short[][][] sArray = perPlayerRender.StencilValues;
        boolean[][] blArray = perPlayerRender.FlattenGrassEtc;
        for (n2 = this.minY; n2 <= this.maxY; ++n2) {
            for (int i = this.minX; i <= this.maxX; ++i) {
                sArray[i - this.minX][n2 - this.minY][0] = 0;
                sArray[i - this.minX][n2 - this.minY][1] = 0;
                blArray[i - this.minX][n2 - this.minY] = false;
            }
        }
        for (n2 = 0; n2 < this.vehicles.size(); ++n2) {
            BaseVehicle baseVehicle = this.vehicles.get(n2);
            if (baseVehicle.getAlpha(n) <= 0.0f) continue;
            for (int i = -2; i < 5; ++i) {
                for (int j = -2; j < 5; ++j) {
                    int n3 = (int)baseVehicle.x + j;
                    int n4 = (int)baseVehicle.y + i;
                    if (n3 < this.minX || n3 > this.maxX || n4 < this.minY || n4 > this.maxY) continue;
                    blArray[n3 - this.minX][n4 - this.minY] = true;
                }
            }
        }
    }

    private void performRenderTiles(PerPlayerRender perPlayerRender, int n, int n2, long l) {
        Shader shader;
        Shader shader2;
        IsoGridStack isoGridStack = perPlayerRender.GridStacks;
        boolean[][] blArray = perPlayerRender.FlattenGrassEtc;
        if (!Core.bDebug || DebugOptions.instance.Terrain.RenderTiles.UseShaders.getValue()) {
            shader2 = m_floorRenderShader;
            shader = m_wallRenderShader;
        } else {
            shader2 = null;
            shader = null;
        }
        for (int i = 0; i < n + 1; ++i) {
            boolean bl;
            IsoGridSquare isoGridSquare;
            int n3;
            s_performance.renderTiles.PperformRenderTilesLayer pperformRenderTilesLayer = s_performance.renderTiles.performRenderTilesLayers.start(i);
            GridStack = isoGridStack.Squares.get(i);
            ShadowSquares.clear();
            SolidFloor.clear();
            ShadedFloor.clear();
            VegetationCorpses.clear();
            MinusFloorCharacters.clear();
            IndieGL.glClear(256);
            if (i == 0 && DebugOptions.instance.Terrain.RenderTiles.Water.getValue() && DebugOptions.instance.Terrain.RenderTiles.WaterBody.getValue()) {
                pperformRenderTilesLayer.renderIsoWater.start();
                IsoWater.getInstance().render(GridStack, false);
                pperformRenderTilesLayer.renderIsoWater.end();
            }
            pperformRenderTilesLayer.renderFloor.start();
            for (n3 = 0; n3 < GridStack.size(); ++n3) {
                isoGridSquare = GridStack.get(n3);
                if (isoGridSquare.chunk != null && isoGridSquare.chunk.bLightingNeverDone[n2]) continue;
                isoGridSquare.bFlattenGrassEtc = i == 0 && blArray[isoGridSquare.x - this.minX][isoGridSquare.y - this.minY];
                int n4 = isoGridSquare.renderFloor(shader2);
                if (!isoGridSquare.getStaticMovingObjects().isEmpty()) {
                    n4 |= 2;
                    n4 |= 0x10;
                    if (isoGridSquare.HasStairs()) {
                        n4 |= 4;
                    }
                }
                if (!isoGridSquare.getWorldObjects().isEmpty()) {
                    n4 |= 2;
                }
                if (!isoGridSquare.getLocalTemporaryObjects().isEmpty()) {
                    n4 |= 4;
                }
                for (int j = 0; j < isoGridSquare.getMovingObjects().size(); ++j) {
                    IsoMovingObject isoMovingObject = isoGridSquare.getMovingObjects().get(j);
                    bl = isoMovingObject.bOnFloor;
                    if (bl && isoMovingObject instanceof IsoZombie) {
                        IsoZombie isoZombie = (IsoZombie)isoMovingObject;
                        bl = isoZombie.isProne();
                        if (!BaseVehicle.RENDER_TO_TEXTURE) {
                            bl = false;
                        }
                    }
                    n4 = bl ? (n4 |= 2) : (n4 |= 4);
                    n4 |= 0x10;
                }
                if (!isoGridSquare.getDeferedCharacters().isEmpty()) {
                    n4 |= 4;
                }
                if (isoGridSquare.hasFlies()) {
                    n4 |= 4;
                }
                if ((n4 & 1) != 0) {
                    SolidFloor.add(isoGridSquare);
                }
                if ((n4 & 8) != 0) {
                    ShadedFloor.add(isoGridSquare);
                }
                if ((n4 & 2) != 0) {
                    VegetationCorpses.add(isoGridSquare);
                }
                if ((n4 & 4) != 0) {
                    MinusFloorCharacters.add(isoGridSquare);
                }
                if ((n4 & 0x10) == 0) continue;
                ShadowSquares.add(isoGridSquare);
            }
            pperformRenderTilesLayer.renderFloor.end();
            pperformRenderTilesLayer.renderPuddles.start();
            IsoPuddles.getInstance().render(SolidFloor, i);
            pperformRenderTilesLayer.renderPuddles.end();
            if (i == 0 && DebugOptions.instance.Terrain.RenderTiles.Water.getValue() && DebugOptions.instance.Terrain.RenderTiles.WaterShore.getValue()) {
                pperformRenderTilesLayer.renderShore.start();
                IsoWater.getInstance().render(null, true);
                pperformRenderTilesLayer.renderShore.end();
            }
            if (!SolidFloor.isEmpty()) {
                pperformRenderTilesLayer.renderSnow.start();
                this.RenderSnow(i);
                pperformRenderTilesLayer.renderSnow.end();
            }
            if (!GridStack.isEmpty()) {
                pperformRenderTilesLayer.renderBlood.start();
                this.ChunkMap[n2].renderBloodForChunks(i);
                pperformRenderTilesLayer.renderBlood.end();
            }
            if (!ShadedFloor.isEmpty()) {
                pperformRenderTilesLayer.renderFloorShading.start();
                this.RenderFloorShading(i);
                pperformRenderTilesLayer.renderFloorShading.end();
            }
            WorldMarkers.instance.renderGridSquareMarkers(perPlayerRender, i, n2);
            if (DebugOptions.instance.Terrain.RenderTiles.Shadows.getValue()) {
                pperformRenderTilesLayer.renderShadows.start();
                this.renderShadows();
                pperformRenderTilesLayer.renderShadows.end();
            }
            if (DebugOptions.instance.Terrain.RenderTiles.Lua.getValue()) {
                pperformRenderTilesLayer.luaOnPostFloorLayerDraw.start();
                LuaEventManager.triggerEvent("OnPostFloorLayerDraw", i);
                pperformRenderTilesLayer.luaOnPostFloorLayerDraw.end();
            }
            IsoMarkers.instance.renderIsoMarkers(perPlayerRender, i, n2);
            IsoMarkers.instance.renderCircleIsoMarkers(perPlayerRender, i, n2);
            if (DebugOptions.instance.Terrain.RenderTiles.VegetationCorpses.getValue()) {
                pperformRenderTilesLayer.vegetationCorpses.start();
                for (n3 = 0; n3 < VegetationCorpses.size(); ++n3) {
                    isoGridSquare = VegetationCorpses.get(n3);
                    isoGridSquare.renderMinusFloor(this.maxZ, false, true, false, false, false, shader);
                    isoGridSquare.renderCharacters(this.maxZ, true, true);
                }
                pperformRenderTilesLayer.vegetationCorpses.end();
            }
            ImprovedFog.startRender(n2, i);
            if (DebugOptions.instance.Terrain.RenderTiles.MinusFloorCharacters.getValue()) {
                pperformRenderTilesLayer.minusFloorCharacters.start();
                for (n3 = 0; n3 < MinusFloorCharacters.size(); ++n3) {
                    isoGridSquare = MinusFloorCharacters.get(n3);
                    IsoGridSquare isoGridSquare2 = isoGridSquare.nav[IsoDirections.S.index()];
                    IsoGridSquare isoGridSquare3 = isoGridSquare.nav[IsoDirections.E.index()];
                    boolean bl2 = isoGridSquare2 != null && isoGridSquare2.getPlayerCutawayFlag(n2, l);
                    bl = isoGridSquare.getPlayerCutawayFlag(n2, l);
                    boolean bl3 = isoGridSquare3 != null && isoGridSquare3.getPlayerCutawayFlag(n2, l);
                    this.currentLY = isoGridSquare.getY() - this.minY;
                    this.currentLZ = i;
                    ImprovedFog.renderRowsBehind(isoGridSquare);
                    boolean bl4 = isoGridSquare.renderMinusFloor(this.maxZ, false, false, bl2, bl, bl3, shader);
                    isoGridSquare.renderDeferredCharacters(this.maxZ);
                    isoGridSquare.renderCharacters(this.maxZ, false, true);
                    if (isoGridSquare.hasFlies()) {
                        CorpseFlies.render(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
                    }
                    if (!bl4) continue;
                    isoGridSquare.renderMinusFloor(this.maxZ, true, false, bl2, bl, bl3, shader);
                }
                pperformRenderTilesLayer.minusFloorCharacters.end();
            }
            IsoMarkers.instance.renderIsoMarkersDeferred(perPlayerRender, i, n2);
            ImprovedFog.endRender();
            pperformRenderTilesLayer.end();
        }
    }

    private void renderShadows() {
        boolean bl = Core.getInstance().getOptionCorpseShadows();
        for (int i = 0; i < ShadowSquares.size(); ++i) {
            IsoMovingObject isoMovingObject;
            IsoMovingObject isoMovingObject2;
            int n;
            IsoGridSquare isoGridSquare = ShadowSquares.get(i);
            for (n = 0; n < isoGridSquare.getMovingObjects().size(); ++n) {
                isoMovingObject2 = isoGridSquare.getMovingObjects().get(n);
                isoMovingObject = Type.tryCastTo(isoMovingObject2, IsoGameCharacter.class);
                if (isoMovingObject != null) {
                    ((IsoGameCharacter)isoMovingObject).renderShadow(isoMovingObject.getX(), isoMovingObject.getY(), isoMovingObject.getZ());
                    continue;
                }
                BaseVehicle baseVehicle = Type.tryCastTo(isoMovingObject2, BaseVehicle.class);
                if (baseVehicle == null) continue;
                baseVehicle.renderShadow();
            }
            if (!bl) continue;
            for (n = 0; n < isoGridSquare.getStaticMovingObjects().size(); ++n) {
                isoMovingObject2 = isoGridSquare.getStaticMovingObjects().get(n);
                isoMovingObject = Type.tryCastTo(isoMovingObject2, IsoDeadBody.class);
                if (isoMovingObject == null) continue;
                ((IsoDeadBody)isoMovingObject).renderShadow();
            }
        }
    }

    private void renderDebugPhysics(int n) {
        if (Core.bDebug && DebugOptions.instance.PhysicsRender.getValue()) {
            TextureDraw.GenericDrawer genericDrawer = WorldSimulation.getDrawer(n);
            SpriteRenderer.instance.drawGeneric(genericDrawer);
        }
    }

    private void renderDebugLighting(PerPlayerRender perPlayerRender, int n) {
        if (Core.bDebug && DebugOptions.instance.LightingRender.getValue()) {
            IsoGridStack isoGridStack = perPlayerRender.GridStacks;
            int n2 = 1;
            for (int i = 0; i < n + 1; ++i) {
                GridStack = isoGridStack.Squares.get(i);
                for (int j = 0; j < GridStack.size(); ++j) {
                    IsoGridSquare isoGridSquare = GridStack.get(j);
                    float f = IsoUtils.XToScreenExact((float)isoGridSquare.x + 0.3f, isoGridSquare.y, 0.0f, 0);
                    float f2 = IsoUtils.YToScreenExact((float)isoGridSquare.x + 0.3f, isoGridSquare.y, 0.0f, 0);
                    float f3 = IsoUtils.XToScreenExact((float)isoGridSquare.x + 0.6f, isoGridSquare.y, 0.0f, 0);
                    float f4 = IsoUtils.YToScreenExact((float)isoGridSquare.x + 0.6f, isoGridSquare.y, 0.0f, 0);
                    float f5 = IsoUtils.XToScreenExact(isoGridSquare.x + 1, (float)isoGridSquare.y + 0.3f, 0.0f, 0);
                    float f6 = IsoUtils.YToScreenExact(isoGridSquare.x + 1, (float)isoGridSquare.y + 0.3f, 0.0f, 0);
                    float f7 = IsoUtils.XToScreenExact(isoGridSquare.x + 1, (float)isoGridSquare.y + 0.6f, 0.0f, 0);
                    float f8 = IsoUtils.YToScreenExact(isoGridSquare.x + 1, (float)isoGridSquare.y + 0.6f, 0.0f, 0);
                    float f9 = IsoUtils.XToScreenExact((float)isoGridSquare.x + 0.6f, isoGridSquare.y + 1, 0.0f, 0);
                    float f10 = IsoUtils.YToScreenExact((float)isoGridSquare.x + 0.6f, isoGridSquare.y + 1, 0.0f, 0);
                    float f11 = IsoUtils.XToScreenExact((float)isoGridSquare.x + 0.3f, isoGridSquare.y + 1, 0.0f, 0);
                    float f12 = IsoUtils.YToScreenExact((float)isoGridSquare.x + 0.3f, isoGridSquare.y + 1, 0.0f, 0);
                    float f13 = IsoUtils.XToScreenExact(isoGridSquare.x, (float)isoGridSquare.y + 0.6f, 0.0f, 0);
                    float f14 = IsoUtils.YToScreenExact(isoGridSquare.x, (float)isoGridSquare.y + 0.6f, 0.0f, 0);
                    float f15 = IsoUtils.XToScreenExact(isoGridSquare.x, (float)isoGridSquare.y + 0.3f, 0.0f, 0);
                    float f16 = IsoUtils.YToScreenExact(isoGridSquare.x, (float)isoGridSquare.y + 0.3f, 0.0f, 0);
                    if (IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 0, 0, n2)) {
                        LineDrawer.drawLine(f, f2, f3, f4, 1.0f, 0.0f, 0.0f, 1.0f, 0);
                    }
                    if (IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 0, 1, n2)) {
                        LineDrawer.drawLine(f3, f4, f5, f6, 1.0f, 0.0f, 0.0f, 1.0f, 0);
                    }
                    if (IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 0, 2, n2)) {
                        LineDrawer.drawLine(f5, f6, f7, f8, 1.0f, 0.0f, 0.0f, 1.0f, 0);
                    }
                    if (IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 1, 2, n2)) {
                        LineDrawer.drawLine(f7, f8, f9, f10, 1.0f, 0.0f, 0.0f, 1.0f, 0);
                    }
                    if (IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 2, 2, n2)) {
                        LineDrawer.drawLine(f9, f10, f11, f12, 1.0f, 0.0f, 0.0f, 1.0f, 0);
                    }
                    if (IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 2, 1, n2)) {
                        LineDrawer.drawLine(f11, f12, f13, f14, 1.0f, 0.0f, 0.0f, 1.0f, 0);
                    }
                    if (IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 2, 0, n2)) {
                        LineDrawer.drawLine(f13, f14, f15, f16, 1.0f, 0.0f, 0.0f, 1.0f, 0);
                    }
                    if (!IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 1, 0, n2)) continue;
                    LineDrawer.drawLine(f15, f16, f, f2, 1.0f, 0.0f, 0.0f, 1.0f, 0);
                }
            }
        }
    }

    private void CullFullyOccludedSquares(IsoGridStack isoGridStack, boolean[][][] blArray, boolean[][] blArray2) {
        int n;
        int n2 = 0;
        for (n = 1; n < MaxHeight + 1; ++n) {
            n2 += isoGridStack.Squares.get(n).size();
        }
        if (n2 < 500) {
            return;
        }
        n = 0;
        for (int i = MaxHeight; i >= 0; --i) {
            GridStack = isoGridStack.Squares.get(i);
            for (int j = GridStack.size() - 1; j >= 0; --j) {
                int n3;
                boolean bl;
                IsoGridSquare isoGridSquare = GridStack.get(j);
                int n4 = isoGridSquare.getX() - i * 3 - this.minX;
                int n5 = isoGridSquare.getY() - i * 3 - this.minY;
                if (n4 < 0 || n4 >= blArray2.length) {
                    GridStack.remove(j);
                    continue;
                }
                if (n5 < 0 || n5 >= blArray2[0].length) {
                    GridStack.remove(j);
                    continue;
                }
                if (i < MaxHeight) {
                    boolean bl2 = bl = !blArray2[n4][n5];
                    if (bl) {
                        bl = false;
                        if (n4 > 2) {
                            bl = n5 > 2 ? !blArray[n4 - 3][n5 - 3][0] || !blArray[n4 - 3][n5 - 3][1] || !blArray[n4 - 3][n5 - 2][0] || !blArray[n4 - 2][n5 - 3][1] || !blArray[n4 - 2][n5 - 2][0] || !blArray[n4 - 2][n5 - 2][1] || !blArray[n4 - 2][n5 - 1][0] || !blArray[n4 - 1][n5 - 2][0] || !blArray[n4 - 1][n5 - 1][1] || !blArray[n4 - 1][n5 - 1][0] || !blArray[n4 - 1][n5][0] || !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1] : (n5 > 1 ? !blArray[n4 - 3][n5 - 2][0] || !blArray[n4 - 2][n5 - 2][0] || !blArray[n4 - 2][n5 - 2][1] || !blArray[n4 - 2][n5 - 1][0] || !blArray[n4 - 1][n5 - 2][0] || !blArray[n4 - 1][n5 - 1][1] || !blArray[n4 - 1][n5 - 1][0] || !blArray[n4 - 1][n5][0] || !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1] : (n5 > 0 ? !blArray[n4 - 2][n5 - 1][0] || !blArray[n4 - 1][n5 - 1][1] || !blArray[n4 - 1][n5 - 1][0] || !blArray[n4 - 1][n5][0] || !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1] : !blArray[n4 - 1][n5][0] || !blArray[n4][n5][0] || !blArray[n4][n5][1]));
                        } else if (n4 > 1) {
                            bl = n5 > 2 ? !blArray[n4 - 2][n5 - 3][1] || !blArray[n4 - 2][n5 - 2][0] || !blArray[n4 - 2][n5 - 2][1] || !blArray[n4 - 2][n5 - 1][0] || !blArray[n4 - 1][n5 - 2][0] || !blArray[n4 - 1][n5 - 1][1] || !blArray[n4 - 1][n5 - 1][0] || !blArray[n4 - 1][n5][0] || !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1] : (n5 > 1 ? !blArray[n4 - 2][n5 - 2][0] || !blArray[n4 - 2][n5 - 2][1] || !blArray[n4 - 2][n5 - 1][0] || !blArray[n4 - 1][n5 - 2][0] || !blArray[n4 - 1][n5 - 1][1] || !blArray[n4 - 1][n5 - 1][0] || !blArray[n4 - 1][n5][0] || !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1] : (n5 > 0 ? !blArray[n4 - 2][n5 - 1][0] || !blArray[n4 - 1][n5 - 1][1] || !blArray[n4 - 1][n5 - 1][0] || !blArray[n4 - 1][n5][0] || !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1] : !blArray[n4 - 1][n5][0] || !blArray[n4][n5][0] || !blArray[n4][n5][1]));
                        } else if (n4 > 0) {
                            bl = n5 > 2 ? !blArray[n4 - 1][n5 - 2][0] || !blArray[n4 - 1][n5 - 1][1] || !blArray[n4 - 1][n5 - 1][0] || !blArray[n4 - 1][n5][0] || !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1] : (n5 > 1 ? !blArray[n4 - 1][n5 - 2][0] || !blArray[n4 - 1][n5 - 1][1] || !blArray[n4 - 1][n5 - 1][0] || !blArray[n4 - 1][n5][0] || !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1] : (n5 > 0 ? !blArray[n4 - 1][n5 - 1][1] || !blArray[n4 - 1][n5 - 1][0] || !blArray[n4 - 1][n5][0] || !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1] : !blArray[n4 - 1][n5][0] || !blArray[n4][n5][0] || !blArray[n4][n5][1]));
                        } else if (n5 > 2) {
                            bl = !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1];
                        } else if (n5 > 1) {
                            bl = !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1];
                        } else if (n5 > 0) {
                            bl = !blArray[n4][n5 - 1][1] || !blArray[n4][n5][0] || !blArray[n4][n5][1];
                        } else {
                            boolean bl3 = bl = !blArray[n4][n5][0] || !blArray[n4][n5][1];
                        }
                    }
                    if (!bl) {
                        GridStack.remove(j);
                        blArray2[n4][n5] = true;
                        continue;
                    }
                }
                ++n;
                bl = IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 0, 1, 1) && isoGridSquare.getProperties().Is(IsoFlagType.cutW);
                boolean bl4 = IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 1, 0, 1) && isoGridSquare.getProperties().Is(IsoFlagType.cutN);
                boolean bl5 = false;
                if (bl || bl4) {
                    boolean bl6 = bl5 = ((float)isoGridSquare.x > IsoCamera.frameState.CamCharacterX || (float)isoGridSquare.y > IsoCamera.frameState.CamCharacterY) && isoGridSquare.z >= (int)IsoCamera.frameState.CamCharacterZ;
                    if (bl5) {
                        n3 = (int)(isoGridSquare.CachedScreenX - IsoCamera.frameState.OffX);
                        int n6 = (int)(isoGridSquare.CachedScreenY - IsoCamera.frameState.OffY);
                        if (n3 + 32 * Core.TileScale <= this.StencilX1 || n3 - 32 * Core.TileScale >= this.StencilX2 || n6 + 32 * Core.TileScale <= this.StencilY1 || n6 - 96 * Core.TileScale >= this.StencilY2) {
                            bl5 = false;
                        }
                    }
                }
                n3 = 0;
                if (bl && !bl5) {
                    ++n3;
                    if (n4 > 0) {
                        blArray[n4 - 1][n5][0] = true;
                        if (n5 > 0) {
                            blArray[n4 - 1][n5 - 1][1] = true;
                        }
                    }
                    if (n4 > 1 && n5 > 0) {
                        blArray[n4 - 2][n5 - 1][0] = true;
                        if (n5 > 1) {
                            blArray[n4 - 2][n5 - 2][1] = true;
                        }
                    }
                    if (n4 > 2 && n5 > 1) {
                        blArray[n4 - 3][n5 - 2][0] = true;
                        if (n5 > 2) {
                            blArray[n4 - 3][n5 - 3][1] = true;
                        }
                    }
                }
                if (bl4 && !bl5) {
                    ++n3;
                    if (n5 > 0) {
                        blArray[n4][n5 - 1][1] = true;
                        if (n4 > 0) {
                            blArray[n4 - 1][n5 - 1][0] = true;
                        }
                    }
                    if (n5 > 1 && n4 > 0) {
                        blArray[n4 - 1][n5 - 2][1] = true;
                        if (n4 > 1) {
                            blArray[n4 - 2][n5 - 2][0] = true;
                        }
                    }
                    if (n5 > 2 && n4 > 1) {
                        blArray[n4 - 2][n5 - 3][1] = true;
                        if (n4 > 2) {
                            blArray[n4 - 3][n5 - 3][0] = true;
                        }
                    }
                }
                if (IsoGridSquare.getMatrixBit(isoGridSquare.visionMatrix, 1, 1, 0)) {
                    ++n3;
                    blArray[n4][n5][0] = true;
                    blArray[n4][n5][1] = true;
                }
                if (n3 != 3) continue;
                blArray2[n4][n5] = true;
            }
        }
    }

    public void RenderFloorShading(int n) {
        Texture texture;
        if (!DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Floor.LightingOld.getValue() || DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Floor.Lighting.getValue()) {
            return;
        }
        if (n >= this.maxZ || PerformanceSettings.LightingFrameSkip >= 3) {
            return;
        }
        if (Core.bDebug && DebugOptions.instance.DebugDraw_SkipWorldShading.getValue()) {
            return;
        }
        if (texWhite == null) {
            texWhite = Texture.getWhite();
        }
        if ((texture = texWhite) == null) {
            return;
        }
        int n2 = IsoCamera.frameState.playerIndex;
        int n3 = (int)IsoCamera.frameState.OffX;
        int n4 = (int)IsoCamera.frameState.OffY;
        for (int i = 0; i < ShadedFloor.size(); ++i) {
            IsoGridSquare isoGridSquare = ShadedFloor.get(i);
            if (!isoGridSquare.getProperties().Is(IsoFlagType.solidfloor)) continue;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (isoGridSquare.getProperties().Is(IsoFlagType.FloorHeightOneThird)) {
                f2 = -1.0f;
                f = -1.0f;
            } else if (isoGridSquare.getProperties().Is(IsoFlagType.FloorHeightTwoThirds)) {
                f2 = -2.0f;
                f = -2.0f;
            }
            float f4 = IsoUtils.XToScreen((float)isoGridSquare.getX() + f, (float)isoGridSquare.getY() + f2, (float)n + f3, 0);
            float f5 = IsoUtils.YToScreen((float)isoGridSquare.getX() + f, (float)isoGridSquare.getY() + f2, (float)n + f3, 0);
            f4 -= (float)n3;
            f5 -= (float)n4;
            int n5 = isoGridSquare.getVertLight(0, n2);
            int n6 = isoGridSquare.getVertLight(1, n2);
            int n7 = isoGridSquare.getVertLight(2, n2);
            int n8 = isoGridSquare.getVertLight(3, n2);
            if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Floor.LightingDebug.getValue()) {
                n5 = -65536;
                n6 = -65536;
                n7 = -16776961;
                n8 = -16776961;
            }
            texture.renderdiamond(f4 - (float)(32 * Core.TileScale), f5 + (float)(16 * Core.TileScale), 64 * Core.TileScale, 32 * Core.TileScale, n8, n5, n6, n7);
        }
    }

    public boolean IsPlayerWindowPeeking(int n) {
        return this.playerWindowPeekingRoomId[n] != -1;
    }

    public boolean CanBuildingSquareOccludePlayer(IsoGridSquare isoGridSquare, int n) {
        ArrayList<IsoBuilding> arrayList = this.playerOccluderBuildings.get(n);
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoBuilding isoBuilding = arrayList.get(i);
            int n2 = isoBuilding.getDef().getX();
            int n3 = isoBuilding.getDef().getY();
            int n4 = isoBuilding.getDef().getX2() - n2;
            int n5 = isoBuilding.getDef().getY2() - n3;
            this.buildingRectTemp.setBounds(n2 - 1, n3 - 1, n4 + 2, n5 + 2);
            if (!this.buildingRectTemp.contains(isoGridSquare.getX(), isoGridSquare.getY())) continue;
            return true;
        }
        return false;
    }

    public int GetEffectivePlayerRoomId() {
        int n = IsoCamera.frameState.playerIndex;
        int n2 = this.playerWindowPeekingRoomId[n];
        if (IsoPlayer.players[n] != null && IsoPlayer.players[n].isClimbing()) {
            n2 = -1;
        }
        if (n2 != -1) {
            return n2;
        }
        IsoGridSquare isoGridSquare = IsoPlayer.players[n].current;
        if (isoGridSquare != null) {
            return isoGridSquare.getRoomID();
        }
        return -1;
    }

    private boolean SetCutawayRoomsForPlayer() {
        int n = IsoCamera.frameState.playerIndex;
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        ArrayList<Integer> arrayList = this.tempPrevPlayerCutawayRoomIDs;
        this.tempPrevPlayerCutawayRoomIDs = this.tempPlayerCutawayRoomIDs;
        this.tempPlayerCutawayRoomIDs = arrayList;
        this.tempPlayerCutawayRoomIDs.clear();
        IsoGridSquare isoGridSquare = isoPlayer.getSquare();
        if (isoGridSquare == null) {
            return false;
        }
        IsoBuilding isoBuilding = isoGridSquare.getBuilding();
        int n2 = isoGridSquare.getRoomID();
        boolean bl = false;
        if (n2 == -1) {
            if (this.playerWindowPeekingRoomId[n] != -1) {
                this.tempPlayerCutawayRoomIDs.add(this.playerWindowPeekingRoomId[n]);
            } else {
                bl = this.playerCutawaysDirty[n];
            }
        } else {
            int n3 = (int)(isoPlayer.getX() - 1.5f);
            int n4 = (int)(isoPlayer.getY() - 1.5f);
            int n5 = (int)(isoPlayer.getX() + 1.5f);
            int n6 = (int)(isoPlayer.getY() + 1.5f);
            for (int i = n3; i <= n5; ++i) {
                for (int j = n4; j <= n6; ++j) {
                    IsoGridSquare isoGridSquare2 = this.getGridSquare(i, j, isoGridSquare.getZ());
                    if (isoGridSquare2 == null) continue;
                    int n7 = isoGridSquare2.getRoomID();
                    if (!isoGridSquare2.getCanSee(n) || n7 == -1 || this.tempPlayerCutawayRoomIDs.contains(n7)) continue;
                    this.tempCutawaySqrVector.set((float)isoGridSquare2.getX() + 0.5f - isoPlayer.getX(), (float)isoGridSquare2.getY() + 0.5f - isoPlayer.getY());
                    if (isoGridSquare != isoGridSquare2 && !(isoPlayer.getForwardDirection().dot(this.tempCutawaySqrVector) > 0.0f)) continue;
                    this.tempPlayerCutawayRoomIDs.add(n7);
                }
            }
            Collections.sort(this.tempPlayerCutawayRoomIDs);
        }
        return bl || !this.tempPlayerCutawayRoomIDs.equals(this.tempPrevPlayerCutawayRoomIDs);
    }

    private boolean IsCutawaySquare(IsoGridSquare isoGridSquare, long l) {
        int n = IsoCamera.frameState.playerIndex;
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (isoPlayer.current == null) {
            return false;
        }
        if (isoGridSquare == null) {
            return false;
        }
        IsoGridSquare isoGridSquare2 = isoPlayer.current;
        if (isoGridSquare2.getZ() != isoGridSquare.getZ()) {
            return false;
        }
        if (this.tempPlayerCutawayRoomIDs.isEmpty()) {
            IsoGridSquare isoGridSquare3 = isoGridSquare.nav[IsoDirections.N.index()];
            IsoGridSquare isoGridSquare4 = isoGridSquare.nav[IsoDirections.W.index()];
            if (this.IsCollapsibleBuildingSquare(isoGridSquare)) {
                if (isoPlayer.getZ() == 0.0f) {
                    return true;
                }
                if (isoGridSquare.getBuilding() != null && (isoGridSquare2.getX() < isoGridSquare.getBuilding().def.x || isoGridSquare2.getY() < isoGridSquare.getBuilding().def.y)) {
                    return true;
                }
                IsoGridSquare isoGridSquare5 = isoGridSquare;
                for (int i = 0; i < 3 && (isoGridSquare5 = isoGridSquare5.nav[IsoDirections.NW.index()]) != null; ++i) {
                    if (!isoGridSquare5.isCanSee(n)) continue;
                    return true;
                }
            }
            if (isoGridSquare3 != null && isoGridSquare3.getRoomID() == -1 && isoGridSquare4 != null && isoGridSquare4.getRoomID() == -1) {
                return this.DoesSquareHaveValidCutaways(isoGridSquare2, isoGridSquare, n, l);
            }
        } else {
            int n2;
            int n3;
            IsoGridSquare isoGridSquare6 = isoGridSquare.nav[IsoDirections.N.index()];
            IsoGridSquare isoGridSquare7 = isoGridSquare.nav[IsoDirections.E.index()];
            IsoGridSquare isoGridSquare8 = isoGridSquare.nav[IsoDirections.S.index()];
            IsoGridSquare isoGridSquare9 = isoGridSquare.nav[IsoDirections.W.index()];
            IsoGridSquare isoGridSquare10 = isoGridSquare2.nav[IsoDirections.N.index()];
            IsoGridSquare isoGridSquare11 = isoGridSquare2.nav[IsoDirections.E.index()];
            IsoGridSquare isoGridSquare12 = isoGridSquare2.nav[IsoDirections.S.index()];
            IsoGridSquare isoGridSquare13 = isoGridSquare2.nav[IsoDirections.W.index()];
            boolean bl = false;
            boolean bl2 = false;
            for (n3 = 0; n3 < 8; ++n3) {
                if (isoGridSquare.nav[n3] == null || isoGridSquare.nav[n3].getRoomID() == isoGridSquare.getRoomID()) continue;
                bl = true;
                break;
            }
            if (!this.tempPlayerCutawayRoomIDs.contains(isoGridSquare.getRoomID())) {
                bl2 = true;
            }
            if (bl || bl2 || isoGridSquare.getWall() != null) {
                IsoGridSquare isoGridSquare14 = isoGridSquare;
                for (n2 = 0; n2 < 3 && (isoGridSquare14 = isoGridSquare14.nav[IsoDirections.NW.index()]) != null; ++n2) {
                    if (isoGridSquare14.getRoomID() == -1 || !this.tempPlayerCutawayRoomIDs.contains(isoGridSquare14.getRoomID())) continue;
                    if ((bl || bl2) && isoGridSquare14.getCanSee(n)) {
                        return true;
                    }
                    if (isoGridSquare.getWall() == null || !isoGridSquare14.isCouldSee(n)) continue;
                    return true;
                }
            }
            if (isoGridSquare6 != null && isoGridSquare9 != null && (isoGridSquare6.getThumpableWallOrHoppable(false) != null || isoGridSquare9.getThumpableWallOrHoppable(true) != null || isoGridSquare.getThumpableWallOrHoppable(true) != null || isoGridSquare.getThumpableWallOrHoppable(false) != null)) {
                return this.DoesSquareHaveValidCutaways(isoGridSquare2, isoGridSquare, n, l);
            }
            if (isoGridSquare2.getRoomID() == -1 && (isoGridSquare10 != null && isoGridSquare10.getRoomID() != -1 || isoGridSquare11 != null && isoGridSquare11.getRoomID() != -1 || isoGridSquare12 != null && isoGridSquare12.getRoomID() != -1 || isoGridSquare13 != null && isoGridSquare13.getRoomID() != -1)) {
                n3 = isoGridSquare2.x - isoGridSquare.x;
                n2 = isoGridSquare2.y - isoGridSquare.y;
                if (n3 < 0 && n2 < 0) {
                    if (n3 >= -3) {
                        if (n2 >= -3) {
                            return true;
                        }
                        if (isoGridSquare6 != null && isoGridSquare8 != null && isoGridSquare.getWall(false) != null && isoGridSquare6.getWall(false) != null && isoGridSquare8.getWall(false) != null && isoGridSquare8.getPlayerCutawayFlag(n, l)) {
                            return true;
                        }
                    } else if (isoGridSquare7 != null && isoGridSquare9 != null) {
                        if (isoGridSquare.getWall(true) != null && isoGridSquare9.getWall(true) != null && isoGridSquare7.getWall(true) != null && isoGridSquare7.getPlayerCutawayFlag(n, l)) {
                            return true;
                        }
                        if (isoGridSquare.getWall(true) != null && isoGridSquare9.getWall(true) != null && isoGridSquare7.getWall(true) != null && isoGridSquare7.getPlayerCutawayFlag(n, l)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean DoesSquareHaveValidCutaways(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2, int n, long l) {
        int n2;
        IsoGridSquare isoGridSquare3 = isoGridSquare2.nav[IsoDirections.N.index()];
        IsoGridSquare isoGridSquare4 = isoGridSquare2.nav[IsoDirections.E.index()];
        IsoGridSquare isoGridSquare5 = isoGridSquare2.nav[IsoDirections.S.index()];
        IsoGridSquare isoGridSquare6 = isoGridSquare2.nav[IsoDirections.W.index()];
        IsoObject isoObject = isoGridSquare2.getWall(true);
        IsoObject isoObject2 = isoGridSquare2.getWall(false);
        IsoObject isoObject3 = null;
        IsoObject isoObject4 = null;
        if (isoGridSquare3 != null && isoGridSquare3.nav[IsoDirections.W.index()] != null && isoGridSquare3.nav[IsoDirections.W.index()].getRoomID() == isoGridSquare3.getRoomID()) {
            isoObject4 = isoGridSquare3.getWall(false);
        }
        if (isoGridSquare6 != null && isoGridSquare6.nav[IsoDirections.N.index()] != null && isoGridSquare6.nav[IsoDirections.N.index()].getRoomID() == isoGridSquare6.getRoomID()) {
            isoObject3 = isoGridSquare6.getWall(true);
        }
        if (isoObject2 != null || isoObject != null || isoObject4 != null || isoObject3 != null) {
            IsoGridSquare isoGridSquare7 = isoGridSquare2.nav[IsoDirections.NW.index()];
            for (n2 = 0; n2 < 2 && isoGridSquare7 != null && isoGridSquare7.getRoomID() == isoGridSquare.getRoomID(); ++n2) {
                IsoGridSquare isoGridSquare8 = isoGridSquare7.nav[IsoDirections.S.index()];
                IsoGridSquare isoGridSquare9 = isoGridSquare7.nav[IsoDirections.E.index()];
                if (isoGridSquare8 != null && isoGridSquare8.getBuilding() != null || isoGridSquare9 != null && isoGridSquare9.getBuilding() != null) break;
                if (isoGridSquare7.isCanSee(n) && isoGridSquare7.isCouldSee(n) && isoGridSquare7.DistTo(isoGridSquare) <= (float)(6 - (n2 + 1))) {
                    return true;
                }
                if (isoGridSquare7.getBuilding() != null) continue;
                isoGridSquare7 = isoGridSquare7.nav[IsoDirections.NW.index()];
            }
        }
        int n3 = isoGridSquare.x - isoGridSquare2.x;
        n2 = isoGridSquare.y - isoGridSquare2.y;
        if (isoObject != null && isoObject.sprite.name.contains("fencing") || isoObject2 != null && isoObject2.sprite.name.contains("fencing")) {
            if (isoObject != null && isoObject3 != null && n2 >= -6 && n2 < 0) {
                return true;
            }
            if (isoObject2 != null && isoObject4 != null && n3 >= -6 && n3 < 0) {
                return true;
            }
        } else if (!(!(isoGridSquare2.DistTo(isoGridSquare) <= 6.0f) || isoGridSquare2.nav[IsoDirections.NW.index()] == null || isoGridSquare2.nav[IsoDirections.NW.index()].getRoomID() != isoGridSquare2.getRoomID() || isoGridSquare2.getWall(true) != null && isoGridSquare2.getWall(true) != isoObject || isoGridSquare2.getWall(false) != null && isoGridSquare2.getWall(false) != isoObject2)) {
            if (isoGridSquare5 != null && isoGridSquare3 != null && n2 != 0) {
                if (n2 > 0 && isoObject2 != null && isoGridSquare5.getWall(false) != null && isoGridSquare3.getWall(false) != null && isoGridSquare5.getPlayerCutawayFlag(n, l)) {
                    return true;
                }
                if (n2 < 0 && isoObject2 != null && isoGridSquare3.getWall(false) != null && isoGridSquare3.getPlayerCutawayFlag(n, l)) {
                    return true;
                }
            }
            if (isoGridSquare4 != null && isoGridSquare6 != null && n3 != 0) {
                if (n3 > 0 && isoObject != null && isoGridSquare4.getWall(true) != null && isoGridSquare6.getWall(true) != null && isoGridSquare4.getPlayerCutawayFlag(n, l)) {
                    return true;
                }
                if (n3 < 0 && isoObject != null && isoGridSquare6.getWall(true) != null && isoGridSquare6.getPlayerCutawayFlag(n, l)) {
                    return true;
                }
            }
        }
        if (isoGridSquare2 == isoGridSquare && isoGridSquare2.nav[IsoDirections.NW.index()] != null && isoGridSquare2.nav[IsoDirections.NW.index()].getRoomID() == isoGridSquare2.getRoomID()) {
            if (isoObject != null && isoGridSquare3 != null && isoGridSquare3.getWall(false) == null && isoGridSquare3.isCanSee(n) && isoGridSquare3.isCouldSee(n)) {
                return true;
            }
            if (isoObject2 != null && isoGridSquare6 != null && isoGridSquare6.getWall(true) != null && isoGridSquare6.isCanSee(n) && isoGridSquare6.isCouldSee(n)) {
                return true;
            }
        }
        if (isoGridSquare3 != null && isoGridSquare6 != null && n3 != 0 && n2 != 0 && isoObject4 != null && isoObject3 != null && isoGridSquare3.getPlayerCutawayFlag(n, l) && isoGridSquare6.getPlayerCutawayFlag(n, l)) {
            return true;
        }
        return n3 < 0 && n3 >= -6 && n2 < 0 && n2 >= -6 && (isoObject2 != null && isoGridSquare2.getWall(true) == null || isoObject != null && isoGridSquare2.getWall(false) == null);
    }

    private boolean IsCollapsibleBuildingSquare(IsoGridSquare isoGridSquare) {
        BuildingDef buildingDef;
        IsoBuilding isoBuilding;
        int n;
        int n2;
        if (isoGridSquare.getProperties().Is(IsoFlagType.forceRender)) {
            return false;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            int n3 = 500;
            for (n = 0; n < n3 && this.playerOccluderBuildingsArr[n2] != null && (isoBuilding = this.playerOccluderBuildingsArr[n2][n]) != null; ++n) {
                buildingDef = isoBuilding.getDef();
                if (this.collapsibleBuildingSquareAlgorithm(buildingDef, isoGridSquare, IsoPlayer.players[n2].getSquare())) {
                    return true;
                }
                if (isoGridSquare.getY() - buildingDef.getY2() == 1 && isoGridSquare.getWall(true) != null) {
                    return true;
                }
                if (isoGridSquare.getX() - buildingDef.getX2() != 1 || isoGridSquare.getWall(false) == null) continue;
                return true;
            }
        }
        n2 = IsoCamera.frameState.playerIndex;
        IsoPlayer isoPlayer = IsoPlayer.players[n2];
        if (isoPlayer.getVehicle() != null) {
            return false;
        }
        for (n = 0; n < 500 && this.zombieOccluderBuildingsArr[n2] != null && (isoBuilding = this.zombieOccluderBuildingsArr[n2][n]) != null; ++n) {
            buildingDef = isoBuilding.getDef();
            if (!this.collapsibleBuildingSquareAlgorithm(buildingDef, isoGridSquare, isoPlayer.getSquare())) continue;
            return true;
        }
        for (n = 0; n < 500 && this.otherOccluderBuildingsArr[n2] != null && (isoBuilding = this.otherOccluderBuildingsArr[n2][n]) != null; ++n) {
            buildingDef = isoBuilding.getDef();
            if (!this.collapsibleBuildingSquareAlgorithm(buildingDef, isoGridSquare, isoPlayer.getSquare())) continue;
            return true;
        }
        return false;
    }

    private boolean collapsibleBuildingSquareAlgorithm(BuildingDef buildingDef, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        int n = buildingDef.getX();
        int n2 = buildingDef.getY();
        int n3 = buildingDef.getX2() - n;
        int n4 = buildingDef.getY2() - n2;
        this.buildingRectTemp.setBounds(n, n2, n3, n4);
        if (isoGridSquare2.getRoomID() == -1 && this.buildingRectTemp.contains(isoGridSquare2.getX(), isoGridSquare2.getY())) {
            this.buildingRectTemp.setBounds(n - 1, n2 - 1, n3 + 2, n4 + 2);
            IsoGridSquare isoGridSquare3 = isoGridSquare.nav[IsoDirections.N.index()];
            IsoGridSquare isoGridSquare4 = isoGridSquare.nav[IsoDirections.W.index()];
            IsoGridSquare isoGridSquare5 = isoGridSquare.nav[IsoDirections.NW.index()];
            if (isoGridSquare5 == null || isoGridSquare3 == null || isoGridSquare4 == null) {
                return false;
            }
            boolean bl = isoGridSquare.getRoomID() == -1;
            boolean bl2 = isoGridSquare3.getRoomID() == -1;
            boolean bl3 = isoGridSquare4.getRoomID() == -1;
            boolean bl4 = isoGridSquare5.getRoomID() == -1;
            boolean bl5 = isoGridSquare2.getY() < isoGridSquare.getY();
            boolean bl6 = isoGridSquare2.getX() < isoGridSquare.getX();
            return this.buildingRectTemp.contains(isoGridSquare.getX(), isoGridSquare.getY()) && (isoGridSquare2.getZ() < isoGridSquare.getZ() || bl && (!bl2 && bl5 || !bl3 && bl6) || bl && bl2 && bl3 && !bl4 || !bl && (bl4 || bl2 == bl3 || bl2 && bl6 || bl3 && bl5));
        }
        this.buildingRectTemp.setBounds(n - 1, n2 - 1, n3 + 2, n4 + 2);
        return this.buildingRectTemp.contains(isoGridSquare.getX(), isoGridSquare.getY());
    }

    private boolean IsDissolvedSquare(IsoGridSquare isoGridSquare, int n) {
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (isoPlayer.current == null) {
            return false;
        }
        IsoGridSquare isoGridSquare2 = isoPlayer.current;
        if (isoGridSquare2.getZ() >= isoGridSquare.getZ()) {
            return false;
        }
        if (!PerformanceSettings.NewRoofHiding) {
            return this.bHideFloors[n] && isoGridSquare.getZ() >= this.maxZ;
        }
        if (isoGridSquare.getZ() > this.hidesOrphanStructuresAbove) {
            IsoGridSquare isoGridSquare3;
            IsoBuilding isoBuilding = isoGridSquare.getBuilding();
            if (isoBuilding == null) {
                isoBuilding = isoGridSquare.roofHideBuilding;
            }
            for (int i = isoGridSquare.getZ() - 1; i >= 0 && isoBuilding == null; --i) {
                isoGridSquare3 = this.getGridSquare(isoGridSquare.x, isoGridSquare.y, i);
                if (isoGridSquare3 == null || (isoBuilding = isoGridSquare3.getBuilding()) != null) continue;
                isoBuilding = isoGridSquare3.roofHideBuilding;
            }
            if (isoBuilding == null) {
                IsoGridSquare isoGridSquare4;
                if (isoGridSquare.isSolidFloor()) {
                    return true;
                }
                IsoGridSquare isoGridSquare5 = isoGridSquare.nav[IsoDirections.N.index()];
                if (isoGridSquare5 != null && isoGridSquare5.getBuilding() == null) {
                    if (isoGridSquare5.getPlayerBuiltFloor() != null) {
                        return true;
                    }
                    if (isoGridSquare5.HasStairsBelow()) {
                        return true;
                    }
                }
                if ((isoGridSquare3 = isoGridSquare.nav[IsoDirections.W.index()]) != null && isoGridSquare3.getBuilding() == null) {
                    if (isoGridSquare3.getPlayerBuiltFloor() != null) {
                        return true;
                    }
                    if (isoGridSquare3.HasStairsBelow()) {
                        return true;
                    }
                }
                if (isoGridSquare.Is(IsoFlagType.WallSE) && (isoGridSquare4 = isoGridSquare.nav[IsoDirections.NW.index()]) != null && isoGridSquare4.getBuilding() == null) {
                    if (isoGridSquare4.getPlayerBuiltFloor() != null) {
                        return true;
                    }
                    if (isoGridSquare4.HasStairsBelow()) {
                        return true;
                    }
                }
            }
        }
        return this.IsCollapsibleBuildingSquare(isoGridSquare);
    }

    private int GetBuildingHeightAt(IsoBuilding isoBuilding, int n, int n2, int n3) {
        for (int i = MaxHeight; i > n3; --i) {
            IsoGridSquare isoGridSquare = this.getGridSquare(n, n2, i);
            if (isoGridSquare == null || isoGridSquare.getBuilding() != isoBuilding) continue;
            return i;
        }
        return n3;
    }

    private void updateSnow(int n) {
        if (this.snowGridCur == null) {
            this.snowGridCur = new SnowGrid(n);
            this.snowGridPrev = new SnowGrid(0);
            return;
        }
        if (n != this.snowGridCur.frac) {
            this.snowGridPrev.init(this.snowGridCur.frac);
            this.snowGridCur.init(n);
            this.snowFadeTime = System.currentTimeMillis();
            DebugLog.log("snow from " + this.snowGridPrev.frac + " to " + this.snowGridCur.frac);
        }
    }

    public void setSnowTarget(int n) {
        if (!SandboxOptions.instance.EnableSnowOnGround.getValue()) {
            n = 0;
        }
        this.snowFracTarget = n;
    }

    public boolean gridSquareIsSnow(int n, int n2, int n3) {
        IsoGridSquare isoGridSquare = this.getGridSquare(n, n2, n3);
        if (isoGridSquare != null) {
            if (!isoGridSquare.getProperties().Is(IsoFlagType.solidfloor)) {
                return false;
            }
            if (isoGridSquare.getProperties().Is(IsoFlagType.water)) {
                return false;
            }
            if (!isoGridSquare.getProperties().Is(IsoFlagType.exterior) || isoGridSquare.room != null || isoGridSquare.isInARoom()) {
                return false;
            }
            int n4 = isoGridSquare.getX() % this.snowGridCur.w;
            int n5 = isoGridSquare.getY() % this.snowGridCur.h;
            return this.snowGridCur.check(n4, n5);
        }
        return false;
    }

    private void RenderSnow(int n) {
        if (!DebugOptions.instance.Weather.Snow.getValue()) {
            return;
        }
        this.updateSnow(this.snowFracTarget);
        SnowGrid snowGrid = this.snowGridCur;
        if (snowGrid == null) {
            return;
        }
        SnowGrid snowGrid2 = this.snowGridPrev;
        if (snowGrid.frac <= 0 && snowGrid2.frac <= 0) {
            return;
        }
        float f = 1.0f;
        float f2 = 0.0f;
        long l = System.currentTimeMillis();
        long l2 = l - this.snowFadeTime;
        if ((float)l2 < this.snowTransitionTime) {
            float f3;
            f = f3 = (float)l2 / this.snowTransitionTime;
            f2 = 1.0f - f;
        }
        Shader shader = null;
        if (DebugOptions.instance.Terrain.RenderTiles.UseShaders.getValue()) {
            shader = m_floorRenderShader;
        }
        FloorShaperAttachedSprites.instance.setShore(false);
        FloorShaperDiamond.instance.setShore(false);
        IndieGL.StartShader(shader, IsoCamera.frameState.playerIndex);
        int n2 = (int)IsoCamera.frameState.OffX;
        int n3 = (int)IsoCamera.frameState.OffY;
        for (int i = 0; i < SolidFloor.size(); ++i) {
            int n4;
            IsoGridSquare isoGridSquare = SolidFloor.get(i);
            if (isoGridSquare.room != null || !isoGridSquare.getProperties().Is(IsoFlagType.exterior) || !isoGridSquare.getProperties().Is(IsoFlagType.solidfloor)) continue;
            if (isoGridSquare.getProperties().Is(IsoFlagType.water)) {
                n4 = IsoCell.getShoreInt(isoGridSquare);
                if (n4 == 0) {
                    continue;
                }
            } else {
                n4 = 0;
            }
            int n5 = isoGridSquare.getX() % snowGrid.w;
            int n6 = isoGridSquare.getY() % snowGrid.h;
            float f4 = IsoUtils.XToScreen(isoGridSquare.getX(), isoGridSquare.getY(), n, 0);
            float f5 = IsoUtils.YToScreen(isoGridSquare.getX(), isoGridSquare.getY(), n, 0);
            f4 -= (float)n2;
            f5 -= (float)n3;
            float f6 = 32 * Core.TileScale;
            float f7 = 96 * Core.TileScale;
            f4 -= f6;
            f5 -= f7;
            int n7 = IsoCamera.frameState.playerIndex;
            int n8 = isoGridSquare.getVertLight(0, n7);
            int n9 = isoGridSquare.getVertLight(1, n7);
            int n10 = isoGridSquare.getVertLight(2, n7);
            int n11 = isoGridSquare.getVertLight(3, n7);
            if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Floor.LightingDebug.getValue()) {
                n8 = -65536;
                n9 = -65536;
                n10 = -16776961;
                n11 = -16776961;
            }
            FloorShaperAttachedSprites.instance.setVertColors(n8, n9, n10, n11);
            FloorShaperDiamond.instance.setVertColors(n8, n9, n10, n11);
            for (n7 = 0; n7 < 2; ++n7) {
                if (f2 > f) {
                    this.renderSnowTileGeneral(snowGrid, f, isoGridSquare, n4, n5, n6, (int)f4, (int)f5, n7);
                    this.renderSnowTileGeneral(snowGrid2, f2, isoGridSquare, n4, n5, n6, (int)f4, (int)f5, n7);
                    continue;
                }
                this.renderSnowTileGeneral(snowGrid2, f2, isoGridSquare, n4, n5, n6, (int)f4, (int)f5, n7);
                this.renderSnowTileGeneral(snowGrid, f, isoGridSquare, n4, n5, n6, (int)f4, (int)f5, n7);
            }
        }
        IndieGL.StartShader(null);
    }

    private void renderSnowTileGeneral(SnowGrid snowGrid, float f, IsoGridSquare isoGridSquare, int n, int n2, int n3, int n4, int n5, int n6) {
        if (f <= 0.0f) {
            return;
        }
        Texture texture = snowGrid.grid[n2][n3][n6];
        if (texture == null) {
            return;
        }
        if (n6 == 0) {
            this.renderSnowTile(snowGrid, n2, n3, n6, isoGridSquare, n, texture, n4, n5, f);
        } else if (n == 0) {
            byte by = snowGrid.gridType[n2][n3][n6];
            this.renderSnowTileBase(texture, n4, n5, f, by < this.m_snowFirstNonSquare);
        }
    }

    private void renderSnowTileBase(Texture texture, int n, int n2, float f, boolean bl) {
        FloorShaper floorShaper = bl ? FloorShaperDiamond.instance : FloorShaperAttachedSprites.instance;
        floorShaper.setAlpha4(f);
        texture.render(n, n2, texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 1.0f, f, floorShaper);
    }

    private void renderSnowTile(SnowGrid snowGrid, int n, int n2, int n3, IsoGridSquare isoGridSquare, int n4, Texture texture, int n5, int n6, float f) {
        boolean bl;
        if (n4 == 0) {
            byte by = snowGrid.gridType[n][n2][n3];
            this.renderSnowTileBase(texture, n5, n6, f, by < this.m_snowFirstNonSquare);
            return;
        }
        int n7 = 0;
        boolean bl2 = snowGrid.check(n, n2);
        boolean bl3 = (n4 & 1) == 1 && (bl2 || snowGrid.check(n, n2 - 1));
        boolean bl4 = (n4 & 2) == 2 && (bl2 || snowGrid.check(n + 1, n2));
        boolean bl5 = (n4 & 4) == 4 && (bl2 || snowGrid.check(n, n2 + 1));
        boolean bl6 = bl = (n4 & 8) == 8 && (bl2 || snowGrid.check(n - 1, n2));
        if (bl3) {
            ++n7;
        }
        if (bl5) {
            ++n7;
        }
        if (bl4) {
            ++n7;
        }
        if (bl) {
            ++n7;
        }
        SnowGridTiles snowGridTiles = null;
        SnowGridTiles snowGridTiles2 = null;
        boolean bl7 = false;
        if (n7 == 0) {
            return;
        }
        if (n7 == 1) {
            if (bl3) {
                snowGridTiles = this.snowGridTiles_Strip[0];
            } else if (bl5) {
                snowGridTiles = this.snowGridTiles_Strip[1];
            } else if (bl4) {
                snowGridTiles = this.snowGridTiles_Strip[3];
            } else if (bl) {
                snowGridTiles = this.snowGridTiles_Strip[2];
            }
        } else if (n7 == 2) {
            if (bl3 && bl5) {
                snowGridTiles = this.snowGridTiles_Strip[0];
                snowGridTiles2 = this.snowGridTiles_Strip[1];
            } else if (bl4 && bl) {
                snowGridTiles = this.snowGridTiles_Strip[2];
                snowGridTiles2 = this.snowGridTiles_Strip[3];
            } else if (bl3) {
                snowGridTiles = this.snowGridTiles_Edge[bl ? 0 : 3];
            } else if (bl5) {
                snowGridTiles = this.snowGridTiles_Edge[bl ? 2 : 1];
            } else if (bl) {
                snowGridTiles = this.snowGridTiles_Edge[bl3 ? 0 : 2];
            } else if (bl4) {
                snowGridTiles = this.snowGridTiles_Edge[bl3 ? 3 : 1];
            }
        } else if (n7 == 3) {
            if (!bl3) {
                snowGridTiles = this.snowGridTiles_Cove[1];
            } else if (!bl5) {
                snowGridTiles = this.snowGridTiles_Cove[0];
            } else if (!bl4) {
                snowGridTiles = this.snowGridTiles_Cove[2];
            } else if (!bl) {
                snowGridTiles = this.snowGridTiles_Cove[3];
            }
            bl7 = true;
        } else if (n7 == 4) {
            snowGridTiles = this.snowGridTiles_Enclosed;
            bl7 = true;
        }
        if (snowGridTiles != null) {
            int n8 = (isoGridSquare.getX() + isoGridSquare.getY()) % snowGridTiles.size();
            texture = snowGridTiles.get(n8);
            if (texture != null) {
                this.renderSnowTileBase(texture, n5, n6, f, bl7);
            }
            if (snowGridTiles2 != null && (texture = snowGridTiles2.get(n8)) != null) {
                this.renderSnowTileBase(texture, n5, n6, f, false);
            }
        }
    }

    private static int getShoreInt(IsoGridSquare isoGridSquare) {
        int n = 0;
        if (IsoCell.isSnowShore(isoGridSquare, 0, -1)) {
            n |= 1;
        }
        if (IsoCell.isSnowShore(isoGridSquare, 1, 0)) {
            n |= 2;
        }
        if (IsoCell.isSnowShore(isoGridSquare, 0, 1)) {
            n |= 4;
        }
        if (IsoCell.isSnowShore(isoGridSquare, -1, 0)) {
            n |= 8;
        }
        return n;
    }

    private static boolean isSnowShore(IsoGridSquare isoGridSquare, int n, int n2) {
        IsoGridSquare isoGridSquare2 = IsoWorld.instance.getCell().getGridSquare(isoGridSquare.getX() + n, isoGridSquare.getY() + n2, 0);
        return isoGridSquare2 != null && !isoGridSquare2.getProperties().Is(IsoFlagType.water);
    }

    public IsoBuilding getClosestBuildingExcept(IsoGameCharacter isoGameCharacter, IsoRoom isoRoom) {
        IsoBuilding isoBuilding = null;
        float f = 1000000.0f;
        for (int i = 0; i < this.BuildingList.size(); ++i) {
            IsoBuilding isoBuilding2 = this.BuildingList.get(i);
            for (int j = 0; j < isoBuilding2.Exits.size(); ++j) {
                float f2 = isoGameCharacter.DistTo(isoBuilding2.Exits.get((int)j).x, isoBuilding2.Exits.get((int)j).y);
                if (!(f2 < f) || isoRoom != null && isoRoom.building == isoBuilding2) continue;
                isoBuilding = isoBuilding2;
                f = f2;
            }
        }
        return isoBuilding;
    }

    public int getDangerScore(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 1000000;
        }
        return this.DangerScore.getValue(n, n2);
    }

    private void ObjectDeletionAddition() {
        IsoMovingObject isoMovingObject;
        int n;
        for (n = 0; n < this.removeList.size(); ++n) {
            isoMovingObject = this.removeList.get(n);
            if (isoMovingObject instanceof IsoZombie) {
                VirtualZombieManager.instance.RemoveZombie((IsoZombie)isoMovingObject);
            }
            if (isoMovingObject instanceof IsoPlayer && !((IsoPlayer)isoMovingObject).isDead()) continue;
            MovingObjectUpdateScheduler.instance.removeObject(isoMovingObject);
            this.ObjectList.remove(isoMovingObject);
            if (isoMovingObject.getCurrentSquare() != null) {
                isoMovingObject.getCurrentSquare().getMovingObjects().remove(isoMovingObject);
            }
            if (isoMovingObject.getLastSquare() == null) continue;
            isoMovingObject.getLastSquare().getMovingObjects().remove(isoMovingObject);
        }
        this.removeList.clear();
        for (n = 0; n < this.addList.size(); ++n) {
            isoMovingObject = this.addList.get(n);
            this.ObjectList.add(isoMovingObject);
        }
        this.addList.clear();
        for (n = 0; n < this.addVehicles.size(); ++n) {
            isoMovingObject = this.addVehicles.get(n);
            if (!this.ObjectList.contains(isoMovingObject)) {
                this.ObjectList.add(isoMovingObject);
            }
            if (this.vehicles.contains(isoMovingObject)) continue;
            this.vehicles.add((BaseVehicle)isoMovingObject);
        }
        this.addVehicles.clear();
    }

    private void ProcessItems(Iterator<InventoryItem> iterator) {
        Object object;
        int n;
        int n2 = this.ProcessItems.size();
        for (n = 0; n < n2; ++n) {
            object = this.ProcessItems.get(n);
            ((InventoryItem)object).update();
            if (!((InventoryItem)object).finishupdate()) continue;
            this.ProcessItemsRemove.add((InventoryItem)object);
        }
        n2 = this.ProcessWorldItems.size();
        for (n = 0; n < n2; ++n) {
            object = this.ProcessWorldItems.get(n);
            ((IsoWorldInventoryObject)object).update();
            if (!((IsoWorldInventoryObject)object).finishupdate()) continue;
            this.ProcessWorldItemsRemove.add((IsoWorldInventoryObject)object);
        }
    }

    private void ProcessIsoObject() {
        this.ProcessIsoObject.removeAll(this.ProcessIsoObjectRemove);
        this.ProcessIsoObjectRemove.clear();
        int n = this.ProcessIsoObject.size();
        for (int i = 0; i < n; ++i) {
            IsoObject isoObject = this.ProcessIsoObject.get(i);
            if (isoObject == null) continue;
            isoObject.update();
            if (n <= this.ProcessIsoObject.size()) continue;
            --i;
            --n;
        }
    }

    private void ProcessObjects(Iterator<IsoMovingObject> iterator) {
        MovingObjectUpdateScheduler.instance.update();
        for (int i = 0; i < this.ZombieList.size(); ++i) {
            IsoZombie isoZombie = this.ZombieList.get(i);
            isoZombie.updateVocalProperties();
        }
    }

    private void ProcessRemoveItems(Iterator<InventoryItem> iterator) {
        this.ProcessItems.removeAll(this.ProcessItemsRemove);
        this.ProcessWorldItems.removeAll(this.ProcessWorldItemsRemove);
        this.ProcessItemsRemove.clear();
        this.ProcessWorldItemsRemove.clear();
    }

    private void ProcessStaticUpdaters() {
        int n = this.StaticUpdaterObjectList.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.StaticUpdaterObjectList.get(i).update();
            }
            catch (Exception exception) {
                Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, null, exception);
            }
            if (n <= this.StaticUpdaterObjectList.size()) continue;
            --i;
            --n;
        }
    }

    public void addToProcessIsoObject(IsoObject isoObject) {
        if (isoObject == null) {
            return;
        }
        this.ProcessIsoObjectRemove.remove(isoObject);
        if (!this.ProcessIsoObject.contains(isoObject)) {
            this.ProcessIsoObject.add(isoObject);
        }
    }

    public void addToProcessIsoObjectRemove(IsoObject isoObject) {
        if (isoObject == null) {
            return;
        }
        if (!this.ProcessIsoObject.contains(isoObject)) {
            return;
        }
        if (!this.ProcessIsoObjectRemove.contains(isoObject)) {
            this.ProcessIsoObjectRemove.add(isoObject);
        }
    }

    public void addToStaticUpdaterObjectList(IsoObject isoObject) {
        if (isoObject == null) {
            return;
        }
        if (!this.StaticUpdaterObjectList.contains(isoObject)) {
            this.StaticUpdaterObjectList.add(isoObject);
        }
    }

    public void addToProcessItems(InventoryItem inventoryItem) {
        if (inventoryItem == null) {
            return;
        }
        this.ProcessItemsRemove.remove(inventoryItem);
        if (!this.ProcessItems.contains(inventoryItem)) {
            this.ProcessItems.add(inventoryItem);
        }
    }

    public void addToProcessItems(ArrayList<InventoryItem> arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            InventoryItem inventoryItem = arrayList.get(i);
            if (inventoryItem == null) continue;
            this.ProcessItemsRemove.remove(inventoryItem);
            if (this.ProcessItems.contains(inventoryItem)) continue;
            this.ProcessItems.add(inventoryItem);
        }
    }

    public void addToProcessItemsRemove(InventoryItem inventoryItem) {
        if (inventoryItem == null) {
            return;
        }
        if (!this.ProcessItemsRemove.contains(inventoryItem)) {
            this.ProcessItemsRemove.add(inventoryItem);
        }
    }

    public void addToProcessItemsRemove(ArrayList<InventoryItem> arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            InventoryItem inventoryItem = arrayList.get(i);
            if (inventoryItem == null || this.ProcessItemsRemove.contains(inventoryItem)) continue;
            this.ProcessItemsRemove.add(inventoryItem);
        }
    }

    public void addToProcessWorldItems(IsoWorldInventoryObject isoWorldInventoryObject) {
        if (isoWorldInventoryObject == null) {
            return;
        }
        this.ProcessWorldItemsRemove.remove(isoWorldInventoryObject);
        if (!this.ProcessWorldItems.contains(isoWorldInventoryObject)) {
            this.ProcessWorldItems.add(isoWorldInventoryObject);
        }
    }

    public void addToProcessWorldItemsRemove(IsoWorldInventoryObject isoWorldInventoryObject) {
        if (isoWorldInventoryObject == null) {
            return;
        }
        if (!this.ProcessWorldItemsRemove.contains(isoWorldInventoryObject)) {
            this.ProcessWorldItemsRemove.add(isoWorldInventoryObject);
        }
    }

    public IsoSurvivor getNetworkPlayer(int n) {
        int n2 = this.RemoteSurvivorList.size();
        for (int i = 0; i < n2; ++i) {
            if (this.RemoteSurvivorList.get(i).getRemoteID() != n) continue;
            return (IsoSurvivor)this.RemoteSurvivorList.get(i);
        }
        return null;
    }

    IsoGridSquare ConnectNewSquare(IsoGridSquare isoGridSquare, boolean bl, boolean bl2) {
        int n = isoGridSquare.getX();
        int n2 = isoGridSquare.getY();
        int n3 = isoGridSquare.getZ();
        this.setCacheGridSquare(n, n2, n3, isoGridSquare);
        this.DoGridNav(isoGridSquare, IsoGridSquare.cellGetSquare);
        return isoGridSquare;
    }

    public void DoGridNav(IsoGridSquare isoGridSquare, IsoGridSquare.GetSquare getSquare) {
        int n = isoGridSquare.getX();
        int n2 = isoGridSquare.getY();
        int n3 = isoGridSquare.getZ();
        isoGridSquare.nav[IsoDirections.N.index()] = getSquare.getGridSquare(n, n2 - 1, n3);
        isoGridSquare.nav[IsoDirections.NW.index()] = getSquare.getGridSquare(n - 1, n2 - 1, n3);
        isoGridSquare.nav[IsoDirections.W.index()] = getSquare.getGridSquare(n - 1, n2, n3);
        isoGridSquare.nav[IsoDirections.SW.index()] = getSquare.getGridSquare(n - 1, n2 + 1, n3);
        isoGridSquare.nav[IsoDirections.S.index()] = getSquare.getGridSquare(n, n2 + 1, n3);
        isoGridSquare.nav[IsoDirections.SE.index()] = getSquare.getGridSquare(n + 1, n2 + 1, n3);
        isoGridSquare.nav[IsoDirections.E.index()] = getSquare.getGridSquare(n + 1, n2, n3);
        isoGridSquare.nav[IsoDirections.NE.index()] = getSquare.getGridSquare(n + 1, n2 - 1, n3);
        if (isoGridSquare.nav[IsoDirections.N.index()] != null) {
            isoGridSquare.nav[IsoDirections.N.index()].nav[IsoDirections.S.index()] = isoGridSquare;
        }
        if (isoGridSquare.nav[IsoDirections.NW.index()] != null) {
            isoGridSquare.nav[IsoDirections.NW.index()].nav[IsoDirections.SE.index()] = isoGridSquare;
        }
        if (isoGridSquare.nav[IsoDirections.W.index()] != null) {
            isoGridSquare.nav[IsoDirections.W.index()].nav[IsoDirections.E.index()] = isoGridSquare;
        }
        if (isoGridSquare.nav[IsoDirections.SW.index()] != null) {
            isoGridSquare.nav[IsoDirections.SW.index()].nav[IsoDirections.NE.index()] = isoGridSquare;
        }
        if (isoGridSquare.nav[IsoDirections.S.index()] != null) {
            isoGridSquare.nav[IsoDirections.S.index()].nav[IsoDirections.N.index()] = isoGridSquare;
        }
        if (isoGridSquare.nav[IsoDirections.SE.index()] != null) {
            isoGridSquare.nav[IsoDirections.SE.index()].nav[IsoDirections.NW.index()] = isoGridSquare;
        }
        if (isoGridSquare.nav[IsoDirections.E.index()] != null) {
            isoGridSquare.nav[IsoDirections.E.index()].nav[IsoDirections.W.index()] = isoGridSquare;
        }
        if (isoGridSquare.nav[IsoDirections.NE.index()] != null) {
            isoGridSquare.nav[IsoDirections.NE.index()].nav[IsoDirections.SW.index()] = isoGridSquare;
        }
    }

    public IsoGridSquare ConnectNewSquare(IsoGridSquare isoGridSquare, boolean bl) {
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            if (this.ChunkMap[i].ignore) continue;
            this.ChunkMap[i].setGridSquare(isoGridSquare, isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ());
        }
        IsoGridSquare isoGridSquare2 = this.ConnectNewSquare(isoGridSquare, bl, false);
        return isoGridSquare2;
    }

    public void PlaceLot(String string, int n, int n2, int n3, boolean bl) {
    }

    public void PlaceLot(IsoLot isoLot, int n, int n2, int n3, boolean bl) {
        int n4 = Math.min(n3 + isoLot.info.levels, n3 + 8);
        for (int i = n; i < n + isoLot.info.width; ++i) {
            for (int j = n2; j < n2 + isoLot.info.height; ++j) {
                for (int k = n3; k < n4; ++k) {
                    int n5;
                    int n6;
                    int n7;
                    int n8 = i - n;
                    int n9 = j - n2;
                    int n10 = k - n3;
                    if (i >= this.width || j >= this.height || i < 0 || j < 0 || k < 0 || (n7 = isoLot.m_offsetInData[n6 = n8 + n9 * 10 + n10 * 100]) == -1 || (n5 = isoLot.m_data.getQuick(n7)) <= 0) continue;
                    boolean bl2 = false;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        String string = isoLot.info.tilesUsed.get(isoLot.m_data.getQuick(n7 + 1 + i2));
                        IsoSprite isoSprite = IsoSpriteManager.instance.NamedMap.get(string);
                        if (isoSprite == null) {
                            Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, "Missing tile definition: " + string);
                            continue;
                        }
                        IsoGridSquare isoGridSquare = this.getGridSquare(i, j, k);
                        if (isoGridSquare == null) {
                            isoGridSquare = IsoGridSquare.loadGridSquareCache != null ? IsoGridSquare.getNew(IsoGridSquare.loadGridSquareCache, this, null, i, j, k) : IsoGridSquare.getNew(this, null, i, j, k);
                            this.ChunkMap[IsoPlayer.getPlayerIndex()].setGridSquare(isoGridSquare, i, j, k);
                        } else {
                            if (bl && i2 == 0 && isoSprite.getProperties().Is(IsoFlagType.solidfloor) && (!isoSprite.Properties.Is(IsoFlagType.hidewalls) || n5 > 1)) {
                                bl2 = true;
                            }
                            if (bl2 && i2 == 0) {
                                isoGridSquare.getObjects().clear();
                            }
                        }
                        CellLoader.DoTileObjectCreation(isoSprite, isoSprite.getType(), isoGridSquare, this, i, j, k, string);
                    }
                }
            }
        }
    }

    public void PlaceLot(IsoLot isoLot, int n, int n2, int n3, IsoChunk isoChunk, int n4, int n5) {
        n4 *= 10;
        n5 *= 10;
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.getMetaGrid();
        int n6 = Math.min(n3 + isoLot.info.levels, n3 + 8);
        try {
            for (int i = n4 + n; i < n4 + n + 10; ++i) {
                for (int j = n5 + n2; j < n5 + n2 + 10; ++j) {
                    for (int k = n3; k < n6; ++k) {
                        Object object;
                        int n7;
                        int n8;
                        int n9;
                        int n10;
                        int n11 = i - n4 - n;
                        int n12 = j - n5 - n2;
                        int n13 = k - n3;
                        if (i >= n4 + 10 || j >= n5 + 10 || i < n4 || j < n5 || k < 0 || (n10 = isoLot.m_offsetInData[n9 = n11 + n12 * 10 + n13 * 100]) == -1 || (n8 = isoLot.m_data.getQuick(n10)) <= 0) continue;
                        IsoGridSquare isoGridSquare = isoChunk.getGridSquare(i - n4, j - n5, k);
                        if (isoGridSquare == null) {
                            isoGridSquare = IsoGridSquare.loadGridSquareCache != null ? IsoGridSquare.getNew(IsoGridSquare.loadGridSquareCache, this, null, i, j, k) : IsoGridSquare.getNew(this, null, i, j, k);
                            isoGridSquare.setX(i);
                            isoGridSquare.setY(j);
                            isoGridSquare.setZ(k);
                            isoChunk.setSquare(i - n4, j - n5, k, isoGridSquare);
                        }
                        for (int i2 = -1; i2 <= 1; ++i2) {
                            for (n7 = -1; n7 <= 1; ++n7) {
                                if (i2 == 0 && n7 == 0 || i2 + i - n4 < 0 || i2 + i - n4 >= 10 || n7 + j - n5 < 0 || n7 + j - n5 >= 10 || (object = isoChunk.getGridSquare(i + i2 - n4, j + n7 - n5, k)) != null) continue;
                                object = IsoGridSquare.getNew(this, null, i + i2, j + n7, k);
                                isoChunk.setSquare(i + i2 - n4, j + n7 - n5, k, (IsoGridSquare)object);
                            }
                        }
                        RoomDef roomDef = isoMetaGrid.getRoomAt(i, j, k);
                        n7 = roomDef != null ? roomDef.ID : -1;
                        isoGridSquare.setRoomID(n7);
                        isoGridSquare.ResetIsoWorldRegion();
                        roomDef = isoMetaGrid.getEmptyOutsideAt(i, j, k);
                        if (roomDef != null) {
                            object = isoChunk.getRoom(roomDef.ID);
                            isoGridSquare.roofHideBuilding = object == null ? null : ((IsoRoom)object).building;
                        }
                        boolean bl = true;
                        for (int i3 = 0; i3 < n8; ++i3) {
                            IsoSprite isoSprite;
                            String string = isoLot.info.tilesUsed.get(isoLot.m_data.get(n10 + 1 + i3));
                            if (!isoLot.info.bFixed2x) {
                                string = IsoChunk.Fix2x(string);
                            }
                            if ((isoSprite = IsoSpriteManager.instance.NamedMap.get(string)) == null) {
                                Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, "Missing tile definition: " + string);
                                continue;
                            }
                            if (i3 == 0 && isoSprite.getProperties().Is(IsoFlagType.solidfloor) && (!isoSprite.Properties.Is(IsoFlagType.hidewalls) || n8 > 1)) {
                                bl = true;
                            }
                            if (bl && i3 == 0) {
                                isoGridSquare.getObjects().clear();
                            }
                            CellLoader.DoTileObjectCreation(isoSprite, isoSprite.getType(), isoGridSquare, this, i, j, k, string);
                        }
                        isoGridSquare.FixStackableObjects();
                    }
                }
            }
        }
        catch (Exception exception) {
            DebugLog.log("Failed to load chunk, blocking out area");
            ExceptionLogger.logException(exception);
            for (int i = n4 + n; i < n4 + n + 10; ++i) {
                for (int j = n5 + n2; j < n5 + n2 + 10; ++j) {
                    for (int k = n3; k < n6; ++k) {
                        isoChunk.setSquare(i - n4 - n, j - n5 - n2, k - n3, null);
                        this.setCacheGridSquare(i, j, k, null);
                    }
                }
            }
        }
    }

    public void setDrag(KahluaTable kahluaTable, int n) {
        Object object;
        if (n < 0 || n >= 4) {
            return;
        }
        if (this.drag[n] != null && this.drag[n] != kahluaTable && ((object = this.drag[n].rawget((Object)"deactivate")) instanceof JavaFunction || object instanceof LuaClosure)) {
            LuaManager.caller.pcallvoid(LuaManager.thread, object, (Object)this.drag[n]);
        }
        this.drag[n] = kahluaTable;
    }

    public KahluaTable getDrag(int n) {
        if (n < 0 || n >= 4) {
            return null;
        }
        return this.drag[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean DoBuilding(int n, boolean bl) {
        try {
            s_performance.isoCellDoBuilding.start();
            boolean bl2 = this.doBuildingInternal(n, bl);
            return bl2;
        }
        finally {
            s_performance.isoCellDoBuilding.end();
        }
    }

    private boolean doBuildingInternal(int n, boolean bl) {
        if (UIManager.getPickedTile() != null && this.drag[n] != null && JoypadManager.instance.getFromPlayer(n) == null) {
            if (!IsoWorld.instance.isValidSquare((int)UIManager.getPickedTile().x, (int)UIManager.getPickedTile().y, (int)IsoCamera.CamCharacter.getZ())) {
                return false;
            }
            IsoGridSquare isoGridSquare = this.getGridSquare((int)UIManager.getPickedTile().x, (int)UIManager.getPickedTile().y, (int)IsoCamera.CamCharacter.getZ());
            if (!bl) {
                if (isoGridSquare == null && (isoGridSquare = this.createNewGridSquare((int)UIManager.getPickedTile().x, (int)UIManager.getPickedTile().y, (int)IsoCamera.CamCharacter.getZ(), true)) == null) {
                    return false;
                }
                isoGridSquare.EnsureSurroundNotNull();
            }
            LuaEventManager.triggerEvent("OnDoTileBuilding2", this.drag[n], bl, (int)UIManager.getPickedTile().x, (int)UIManager.getPickedTile().y, (int)IsoCamera.CamCharacter.getZ(), isoGridSquare);
        }
        if (this.drag[n] != null && JoypadManager.instance.getFromPlayer(n) != null) {
            LuaEventManager.triggerEvent("OnDoTileBuilding3", this.drag[n], bl, (int)IsoPlayer.players[n].getX(), (int)IsoPlayer.players[n].getY(), (int)IsoCamera.CamCharacter.getZ());
        }
        if (bl) {
            IndieGL.glBlendFunc(770, 771);
        }
        return false;
    }

    public float DistanceFromSupport(int n, int n2, int n3) {
        return 0.0f;
    }

    public ArrayList<IsoBuilding> getBuildingList() {
        return this.BuildingList;
    }

    public ArrayList<IsoWindow> getWindowList() {
        return this.WindowList;
    }

    public void addToWindowList(IsoWindow isoWindow) {
        if (GameServer.bServer) {
            return;
        }
        if (isoWindow == null) {
            return;
        }
        if (!this.WindowList.contains(isoWindow)) {
            this.WindowList.add(isoWindow);
        }
    }

    public void removeFromWindowList(IsoWindow isoWindow) {
        this.WindowList.remove(isoWindow);
    }

    public ArrayList<IsoMovingObject> getObjectList() {
        return this.ObjectList;
    }

    public IsoRoom getRoom(int n) {
        IsoRoom isoRoom = this.ChunkMap[IsoPlayer.getPlayerIndex()].getRoom(n);
        return isoRoom;
    }

    public ArrayList<IsoPushableObject> getPushableObjectList() {
        return this.PushableObjectList;
    }

    public HashMap<Integer, BuildingScore> getBuildingScores() {
        return this.BuildingScores;
    }

    public ArrayList<IsoRoom> getRoomList() {
        return this.RoomList;
    }

    public ArrayList<IsoObject> getStaticUpdaterObjectList() {
        return this.StaticUpdaterObjectList;
    }

    public ArrayList<IsoZombie> getZombieList() {
        return this.ZombieList;
    }

    public ArrayList<IsoGameCharacter> getRemoteSurvivorList() {
        return this.RemoteSurvivorList;
    }

    public ArrayList<IsoMovingObject> getRemoveList() {
        return this.removeList;
    }

    public ArrayList<IsoMovingObject> getAddList() {
        return this.addList;
    }

    public void addMovingObject(IsoMovingObject isoMovingObject) {
        this.addList.add(isoMovingObject);
    }

    public ArrayList<InventoryItem> getProcessItems() {
        return this.ProcessItems;
    }

    public ArrayList<IsoWorldInventoryObject> getProcessWorldItems() {
        return this.ProcessWorldItems;
    }

    public ArrayList<IsoObject> getProcessIsoObjects() {
        return this.ProcessIsoObject;
    }

    public ArrayList<InventoryItem> getProcessItemsRemove() {
        return this.ProcessItemsRemove;
    }

    public ArrayList<BaseVehicle> getVehicles() {
        return this.vehicles;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWorldX() {
        return this.worldX;
    }

    public void setWorldX(int n) {
        this.worldX = n;
    }

    public int getWorldY() {
        return this.worldY;
    }

    public void setWorldY(int n) {
        this.worldY = n;
    }

    public boolean isSafeToAdd() {
        return this.safeToAdd;
    }

    public void setSafeToAdd(boolean bl) {
        this.safeToAdd = bl;
    }

    public Stack<IsoLightSource> getLamppostPositions() {
        return this.LamppostPositions;
    }

    public IsoLightSource getLightSourceAt(int n, int n2, int n3) {
        for (int i = 0; i < this.LamppostPositions.size(); ++i) {
            IsoLightSource isoLightSource = (IsoLightSource)this.LamppostPositions.get(i);
            if (isoLightSource.getX() != n || isoLightSource.getY() != n2 || isoLightSource.getZ() != n3) continue;
            return isoLightSource;
        }
        return null;
    }

    public void addLamppost(IsoLightSource isoLightSource) {
        if (isoLightSource == null || this.LamppostPositions.contains(isoLightSource)) {
            return;
        }
        this.LamppostPositions.add(isoLightSource);
        IsoGridSquare.RecalcLightTime = -1;
        GameTime.instance.lightSourceUpdate = 100.0f;
    }

    public IsoLightSource addLamppost(int n, int n2, int n3, float f, float f2, float f3, int n4) {
        IsoLightSource isoLightSource = new IsoLightSource(n, n2, n3, f, f2, f3, n4);
        this.LamppostPositions.add(isoLightSource);
        IsoGridSquare.RecalcLightTime = -1;
        GameTime.instance.lightSourceUpdate = 100.0f;
        return isoLightSource;
    }

    public void removeLamppost(int n, int n2, int n3) {
        for (int i = 0; i < this.LamppostPositions.size(); ++i) {
            IsoLightSource isoLightSource = (IsoLightSource)this.LamppostPositions.get(i);
            if (isoLightSource.getX() != n || isoLightSource.getY() != n2 || isoLightSource.getZ() != n3) continue;
            isoLightSource.clearInfluence();
            this.LamppostPositions.remove(isoLightSource);
            IsoGridSquare.RecalcLightTime = -1;
            GameTime.instance.lightSourceUpdate = 100.0f;
            return;
        }
    }

    public void removeLamppost(IsoLightSource isoLightSource) {
        isoLightSource.life = 0;
        IsoGridSquare.RecalcLightTime = -1;
        GameTime.instance.lightSourceUpdate = 100.0f;
    }

    public int getCurrentLightX() {
        return this.currentLX;
    }

    public void setCurrentLightX(int n) {
        this.currentLX = n;
    }

    public int getCurrentLightY() {
        return this.currentLY;
    }

    public void setCurrentLightY(int n) {
        this.currentLY = n;
    }

    public int getCurrentLightZ() {
        return this.currentLZ;
    }

    public void setCurrentLightZ(int n) {
        this.currentLZ = n;
    }

    public int getMinX() {
        return this.minX;
    }

    public void setMinX(int n) {
        this.minX = n;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public void setMaxX(int n) {
        this.maxX = n;
    }

    public int getMinY() {
        return this.minY;
    }

    public void setMinY(int n) {
        this.minY = n;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setMaxY(int n) {
        this.maxY = n;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public void setMinZ(int n) {
        this.minZ = n;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(int n) {
        this.maxZ = n;
    }

    public OnceEvery getDangerUpdate() {
        return this.dangerUpdate;
    }

    public void setDangerUpdate(OnceEvery onceEvery) {
        this.dangerUpdate = onceEvery;
    }

    public Thread getLightInfoUpdate() {
        return this.LightInfoUpdate;
    }

    public void setLightInfoUpdate(Thread thread) {
        this.LightInfoUpdate = thread;
    }

    public ArrayList<IsoSurvivor> getSurvivorList() {
        return this.SurvivorList;
    }

    public static int getRComponent(int n) {
        return n & 0xFF;
    }

    public static int getGComponent(int n) {
        return (n & 0xFF00) >> 8;
    }

    public static int getBComponent(int n) {
        return (n & 0xFF0000) >> 16;
    }

    public static int toIntColor(float f, float f2, float f3, float f4) {
        return (int)(f * 255.0f) << 0 | (int)(f2 * 255.0f) << 8 | (int)(f3 * 255.0f) << 16 | (int)(f4 * 255.0f) << 24;
    }

    public IsoGridSquare getRandomOutdoorTile() {
        IsoGridSquare isoGridSquare = null;
        do {
            if ((isoGridSquare = this.getGridSquare(this.ChunkMap[IsoPlayer.getPlayerIndex()].getWorldXMin() * 10 + Rand.Next(this.width), this.ChunkMap[IsoPlayer.getPlayerIndex()].getWorldYMin() * 10 + Rand.Next(this.height), 0)) == null) continue;
            isoGridSquare.setCachedIsFree(false);
        } while (isoGridSquare == null || !isoGridSquare.isFree(false) || isoGridSquare.getRoom() != null);
        return isoGridSquare;
    }

    private static void InsertAt(int n, BuildingScore buildingScore, BuildingScore[] buildingScoreArray) {
        for (int i = buildingScoreArray.length - 1; i > n; --i) {
            buildingScoreArray[i] = buildingScoreArray[i - 1];
        }
        buildingScoreArray[n] = buildingScore;
    }

    static void Place(BuildingScore buildingScore, BuildingScore[] buildingScoreArray, BuildingSearchCriteria buildingSearchCriteria) {
        for (int i = 0; i < buildingScoreArray.length; ++i) {
            if (buildingScoreArray[i] == null) continue;
            boolean bl = false;
            if (buildingScoreArray[i] == null) {
                bl = true;
            } else {
                switch (buildingSearchCriteria) {
                    case General: {
                        if (!(buildingScoreArray[i].food + buildingScoreArray[i].defense + (float)buildingScoreArray[i].size + buildingScoreArray[i].weapons < buildingScore.food + buildingScore.defense + (float)buildingScore.size + buildingScore.weapons)) break;
                        bl = true;
                        break;
                    }
                    case Food: {
                        if (!(buildingScoreArray[i].food < buildingScore.food)) break;
                        bl = true;
                        break;
                    }
                    case Wood: {
                        if (!(buildingScoreArray[i].wood < buildingScore.wood)) break;
                        bl = true;
                        break;
                    }
                    case Weapons: {
                        if (!(buildingScoreArray[i].weapons < buildingScore.weapons)) break;
                        bl = true;
                        break;
                    }
                    case Defense: {
                        if (!(buildingScoreArray[i].defense < buildingScore.defense)) break;
                        bl = true;
                    }
                }
            }
            if (!bl) continue;
            IsoCell.InsertAt(i, buildingScore, buildingScoreArray);
            return;
        }
    }

    public Stack<BuildingScore> getBestBuildings(BuildingSearchCriteria buildingSearchCriteria, int n) {
        int n2;
        int n3;
        BuildingScore[] buildingScoreArray = new BuildingScore[n];
        if (this.BuildingScores.isEmpty()) {
            n3 = this.BuildingList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.BuildingList.get(n2).update();
            }
        }
        n3 = this.BuildingScores.size();
        for (n2 = 0; n2 < n3; ++n2) {
            BuildingScore buildingScore = this.BuildingScores.get(n2);
            IsoCell.Place(buildingScore, buildingScoreArray, buildingSearchCriteria);
        }
        buildingscores.clear();
        buildingscores.addAll(Arrays.asList(buildingScoreArray));
        return buildingscores;
    }

    public boolean blocked(Mover mover, int n, int n2, int n3, int n4, int n5, int n6) {
        IsoGridSquare isoGridSquare = this.getGridSquare(n4, n5, n6);
        if (isoGridSquare == null) {
            return true;
        }
        return mover instanceof IsoMovingObject ? isoGridSquare.testPathFindAdjacent((IsoMovingObject)mover, n - n4, n2 - n5, n3 - n6) : isoGridSquare.testPathFindAdjacent(null, n - n4, n2 - n5, n3 - n6);
    }

    public void Dispose() {
        int n;
        for (n = 0; n < this.ObjectList.size(); ++n) {
            IsoMovingObject isoMovingObject = this.ObjectList.get(n);
            if (!(isoMovingObject instanceof IsoZombie)) continue;
            isoMovingObject.setCurrent(null);
            isoMovingObject.setLast(null);
            VirtualZombieManager.instance.addToReusable((IsoZombie)isoMovingObject);
        }
        for (n = 0; n < this.RoomList.size(); ++n) {
            this.RoomList.get((int)n).TileList.clear();
            this.RoomList.get((int)n).Exits.clear();
            this.RoomList.get((int)n).WaterSources.clear();
            this.RoomList.get((int)n).lightSwitches.clear();
            this.RoomList.get((int)n).Beds.clear();
        }
        for (n = 0; n < this.BuildingList.size(); ++n) {
            this.BuildingList.get((int)n).Exits.clear();
            this.BuildingList.get((int)n).Rooms.clear();
            this.BuildingList.get((int)n).container.clear();
            this.BuildingList.get((int)n).Windows.clear();
        }
        LuaEventManager.clear();
        LuaHookManager.clear();
        this.LamppostPositions.clear();
        this.ProcessItems.clear();
        this.ProcessItemsRemove.clear();
        this.ProcessWorldItems.clear();
        this.ProcessWorldItemsRemove.clear();
        this.BuildingScores.clear();
        this.BuildingList.clear();
        this.WindowList.clear();
        this.PushableObjectList.clear();
        this.RoomList.clear();
        this.SurvivorList.clear();
        this.ObjectList.clear();
        this.ZombieList.clear();
        for (n = 0; n < this.ChunkMap.length; ++n) {
            this.ChunkMap[n].Dispose();
            this.ChunkMap[n] = null;
        }
        for (n = 0; n < this.gridSquares.length; ++n) {
            if (this.gridSquares[n] == null) continue;
            Arrays.fill(this.gridSquares[n], null);
            this.gridSquares[n] = null;
        }
    }

    @LuaMethod(name="getGridSquare")
    public IsoGridSquare getGridSquare(double d, double d2, double d3) {
        if (GameServer.bServer) {
            return ServerMap.instance.getGridSquare((int)d, (int)d2, (int)d3);
        }
        return this.getGridSquare((int)d, (int)d2, (int)d3);
    }

    @LuaMethod(name="getOrCreateGridSquare")
    public IsoGridSquare getOrCreateGridSquare(double d, double d2, double d3) {
        if (GameServer.bServer) {
            IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare((int)d, (int)d2, (int)d3);
            if (isoGridSquare == null) {
                isoGridSquare = IsoGridSquare.getNew(this, null, (int)d, (int)d2, (int)d3);
                ServerMap.instance.setGridSquare((int)d, (int)d2, (int)d3, isoGridSquare);
                this.ConnectNewSquare(isoGridSquare, true);
            }
            return isoGridSquare;
        }
        IsoGridSquare isoGridSquare = this.getGridSquare((int)d, (int)d2, (int)d3);
        if (isoGridSquare == null) {
            isoGridSquare = IsoGridSquare.getNew(this, null, (int)d, (int)d2, (int)d3);
            this.ConnectNewSquare(isoGridSquare, true);
        }
        return isoGridSquare;
    }

    public void setCacheGridSquare(int n, int n2, int n3, IsoGridSquare isoGridSquare) {
        assert (isoGridSquare == null || n == isoGridSquare.getX() && n2 == isoGridSquare.getY() && n3 == isoGridSquare.getZ());
        if (GameServer.bServer) {
            return;
        }
        assert (this.getChunkForGridSquare(n, n2, n3) != null);
        int n4 = IsoChunkMap.ChunkWidthInTiles;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            if (this.ChunkMap[i].ignore) continue;
            this.ChunkMap[i].YMinTiles = -1;
            this.ChunkMap[i].XMinTiles = -1;
            this.ChunkMap[i].YMaxTiles = -1;
            this.ChunkMap[i].XMaxTiles = -1;
            int n5 = n - this.ChunkMap[i].getWorldXMinTiles();
            int n6 = n2 - this.ChunkMap[i].getWorldYMinTiles();
            if (n3 >= 8 || n3 < 0 || n5 < 0 || n5 >= n4 || n6 < 0 || n6 >= n4) continue;
            this.gridSquares[i][n5 + n6 * n4 + n3 * n4 * n4] = isoGridSquare;
        }
    }

    public void setCacheChunk(IsoChunk isoChunk) {
        if (GameServer.bServer) {
            return;
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            this.setCacheChunk(isoChunk, i);
        }
    }

    public void setCacheChunk(IsoChunk isoChunk, int n) {
        if (GameServer.bServer) {
            return;
        }
        int n2 = IsoChunkMap.ChunkWidthInTiles;
        IsoChunkMap isoChunkMap = this.ChunkMap[n];
        if (isoChunkMap.ignore) {
            return;
        }
        int n3 = isoChunk.wx - isoChunkMap.getWorldXMin();
        int n4 = isoChunk.wy - isoChunkMap.getWorldYMin();
        if (n3 < 0 || n3 >= IsoChunkMap.ChunkGridWidth || n4 < 0 || n4 >= IsoChunkMap.ChunkGridWidth) {
            return;
        }
        IsoGridSquare[] isoGridSquareArray = this.gridSquares[n];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    IsoGridSquare isoGridSquare = isoChunk.squares[i][k + j * 10];
                    int n5 = n3 * 10 + k;
                    int n6 = n4 * 10 + j;
                    isoGridSquareArray[n5 + n6 * n2 + i * n2 * n2] = isoGridSquare;
                }
            }
        }
    }

    public void clearCacheGridSquare(int n) {
        if (GameServer.bServer) {
            return;
        }
        int n2 = IsoChunkMap.ChunkWidthInTiles;
        this.gridSquares[n] = new IsoGridSquare[n2 * n2 * 8];
    }

    public void setCacheGridSquareLocal(int n, int n2, int n3, IsoGridSquare isoGridSquare, int n4) {
        if (GameServer.bServer) {
            return;
        }
        int n5 = IsoChunkMap.ChunkWidthInTiles;
        if (n3 >= 8 || n3 < 0 || n < 0 || n >= n5 || n2 < 0 || n2 >= n5) {
            return;
        }
        this.gridSquares[n4][n + n2 * n5 + n3 * n5 * n5] = isoGridSquare;
    }

    public IsoGridSquare getGridSquare(Double d, Double d2, Double d3) {
        return this.getGridSquare(d.intValue(), d2.intValue(), d3.intValue());
    }

    public IsoGridSquare getGridSquare(int n, int n2, int n3) {
        if (GameServer.bServer) {
            return ServerMap.instance.getGridSquare(n, n2, n3);
        }
        int n4 = IsoChunkMap.ChunkWidthInTiles;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoGridSquare isoGridSquare;
            int n5;
            if (this.ChunkMap[i].ignore) continue;
            if (n3 == 0) {
                n5 = 0;
            }
            n5 = n - this.ChunkMap[i].getWorldXMinTiles();
            int n6 = n2 - this.ChunkMap[i].getWorldYMinTiles();
            if (n3 >= 8 || n3 < 0 || n5 < 0 || n5 >= n4 || n6 < 0 || n6 >= n4 || (isoGridSquare = this.gridSquares[i][n5 + n6 * n4 + n3 * n4 * n4]) == null) continue;
            return isoGridSquare;
        }
        return null;
    }

    public void EnsureSurroundNotNull(int n, int n2, int n3) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                this.createNewGridSquare(n + i, n2 + j, n3, false);
            }
        }
    }

    public void DeleteAllMovingObjects() {
        this.ObjectList.clear();
    }

    @LuaMethod(name="getMaxFloors")
    public int getMaxFloors() {
        return 8;
    }

    public KahluaTable getLuaObjectList() {
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        LuaManager.env.rawset((Object)"Objects", (Object)kahluaTable);
        for (int i = 0; i < this.ObjectList.size(); ++i) {
            kahluaTable.rawset(i + 1, (Object)this.ObjectList.get(i));
        }
        return kahluaTable;
    }

    public int getHeightInTiles() {
        return this.ChunkMap[IsoPlayer.getPlayerIndex()].getWidthInTiles();
    }

    public int getWidthInTiles() {
        return this.ChunkMap[IsoPlayer.getPlayerIndex()].getWidthInTiles();
    }

    public boolean isNull(int n, int n2, int n3) {
        IsoGridSquare isoGridSquare = this.getGridSquare(n, n2, n3);
        return isoGridSquare == null || !isoGridSquare.isFree(false);
    }

    public void Remove(IsoMovingObject isoMovingObject) {
        if (isoMovingObject instanceof IsoPlayer && !((IsoPlayer)isoMovingObject).isDead()) {
            return;
        }
        this.removeList.add(isoMovingObject);
    }

    boolean isBlocked(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        return isoGridSquare.room != isoGridSquare2.room;
    }

    private int CalculateColor(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2, IsoGridSquare isoGridSquare3, IsoGridSquare isoGridSquare4, int n, int n2) {
        ColorInfo colorInfo;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        if (isoGridSquare4 == null) {
            return 0;
        }
        float f5 = 0.0f;
        boolean bl = true;
        if (isoGridSquare != null && isoGridSquare4.room == isoGridSquare.room && isoGridSquare.getChunk() != null) {
            f5 += 1.0f;
            colorInfo = isoGridSquare.lighting[n2].lightInfo();
            f += colorInfo.r;
            f2 += colorInfo.g;
            f3 += colorInfo.b;
        }
        if (isoGridSquare2 != null && isoGridSquare4.room == isoGridSquare2.room && isoGridSquare2.getChunk() != null) {
            f5 += 1.0f;
            colorInfo = isoGridSquare2.lighting[n2].lightInfo();
            f += colorInfo.r;
            f2 += colorInfo.g;
            f3 += colorInfo.b;
        }
        if (isoGridSquare3 != null && isoGridSquare4.room == isoGridSquare3.room && isoGridSquare3.getChunk() != null) {
            f5 += 1.0f;
            colorInfo = isoGridSquare3.lighting[n2].lightInfo();
            f += colorInfo.r;
            f2 += colorInfo.g;
            f3 += colorInfo.b;
        }
        if (isoGridSquare4 != null) {
            f5 += 1.0f;
            colorInfo = isoGridSquare4.lighting[n2].lightInfo();
            f += colorInfo.r;
            f2 += colorInfo.g;
            f3 += colorInfo.b;
        }
        if (f5 != 0.0f) {
            f /= f5;
            f2 /= f5;
            f3 /= f5;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (isoGridSquare4 != null) {
            isoGridSquare4.setVertLight(n, (int)(f * 255.0f) << 0 | (int)(f2 * 255.0f) << 8 | (int)(f3 * 255.0f) << 16 | 0xFF000000, n2);
            isoGridSquare4.setVertLight(n + 4, (int)(f * 255.0f) << 0 | (int)(f2 * 255.0f) << 8 | (int)(f3 * 255.0f) << 16 | 0xFF000000, n2);
        }
        return n;
    }

    public static IsoCell getInstance() {
        return instance;
    }

    public void render() {
        s_performance.isoCellRender.invokeAndMeasure(this, IsoCell::renderInternal);
    }

    private void renderInternal() {
        int n;
        int n2;
        IsoGridSquare isoGridSquare;
        IsoGridSquare isoGridSquare2;
        int n3;
        int n4 = IsoCamera.frameState.playerIndex;
        IsoPlayer isoPlayer = IsoPlayer.players[n4];
        isoPlayer.dirtyRecalcGridStack = isoPlayer.dirtyRecalcGridStackTime > 0.0f;
        if (!PerformanceSettings.NewRoofHiding) {
            if (this.bHideFloors[n4] && this.unhideFloorsCounter[n4] > 0) {
                int n5 = n4;
                this.unhideFloorsCounter[n5] = this.unhideFloorsCounter[n5] - 1;
            }
            if (this.unhideFloorsCounter[n4] <= 0) {
                this.bHideFloors[n4] = false;
                this.unhideFloorsCounter[n4] = 60;
            }
        }
        if ((n3 = 8) < 8) {
            ++n3;
        }
        --this.recalcShading;
        int n6 = 0;
        int n7 = 0;
        int n8 = n6 + IsoCamera.getOffscreenWidth(n4);
        int n9 = n7 + IsoCamera.getOffscreenHeight(n4);
        float f = IsoUtils.XToIso(n6, n7, 0.0f);
        float f2 = IsoUtils.YToIso(n8, n7, 0.0f);
        float f3 = IsoUtils.XToIso(n8, n9, 6.0f);
        float f4 = IsoUtils.YToIso(n6, n9, 6.0f);
        this.minY = (int)f2;
        this.maxY = (int)f4;
        this.minX = (int)f;
        this.maxX = (int)f3;
        this.minX -= 2;
        this.minY -= 2;
        this.maxZ = MaxHeight;
        if (IsoCamera.CamCharacter == null) {
            this.maxZ = 1;
        }
        int n10 = 0;
        n10 = 4;
        if (GameTime.instance.FPSMultiplier > 1.5f) {
            n10 = 6;
        }
        if (this.minX != this.lastMinX || this.minY != this.lastMinY) {
            this.lightUpdateCount = 10;
        }
        if (!PerformanceSettings.NewRoofHiding) {
            IsoGridSquare isoGridSquare3 = isoGridSquare2 = IsoCamera.CamCharacter == null ? null : IsoCamera.CamCharacter.getCurrentSquare();
            if (isoGridSquare2 != null) {
                isoGridSquare = this.getGridSquare((double)Math.round(IsoCamera.CamCharacter.getX()), (double)Math.round(IsoCamera.CamCharacter.getY()), IsoCamera.CamCharacter.getZ());
                if (isoGridSquare != null && this.IsBehindStuff(isoGridSquare)) {
                    this.bHideFloors[n4] = true;
                }
                if (!this.bHideFloors[n4] && isoGridSquare2.getProperties().Is(IsoFlagType.hidewalls) || !isoGridSquare2.getProperties().Is(IsoFlagType.exterior)) {
                    this.bHideFloors[n4] = true;
                }
            }
            if (this.bHideFloors[n4]) {
                this.maxZ = (int)IsoCamera.CamCharacter.getZ() + 1;
            }
        }
        if (PerformanceSettings.LightingFrameSkip < 3) {
            this.DrawStencilMask();
        }
        if (PerformanceSettings.LightingFrameSkip == 3) {
            int n11 = IsoCamera.getOffscreenWidth(n4) / 2;
            int n12 = IsoCamera.getOffscreenHeight(n4) / 2;
            n2 = 409;
            this.StencilX1 = (n11 -= n2 / (2 / Core.TileScale)) - (int)IsoCamera.cameras[n4].RightClickX;
            this.StencilY1 = (n12 -= n2 / (2 / Core.TileScale)) - (int)IsoCamera.cameras[n4].RightClickY;
            this.StencilX2 = this.StencilX1 + n2 * Core.TileScale;
            this.StencilY2 = this.StencilY1 + n2 * Core.TileScale;
        }
        if (PerformanceSettings.NewRoofHiding && isoPlayer.dirtyRecalcGridStack) {
            this.hidesOrphanStructuresAbove = n3;
            isoGridSquare2 = null;
            this.otherOccluderBuildings.get(n4).clear();
            if (this.otherOccluderBuildingsArr[n4] != null) {
                this.otherOccluderBuildingsArr[n4][0] = null;
            } else {
                this.otherOccluderBuildingsArr[n4] = new IsoBuilding[500];
            }
            if (IsoCamera.CamCharacter != null && IsoCamera.CamCharacter.getCurrentSquare() != null) {
                IsoGridSquare isoGridSquare4;
                Object object;
                IsoGridSquare isoGridSquare5;
                isoGridSquare = IsoCamera.CamCharacter.getCurrentSquare();
                n2 = 10;
                if (this.ZombieList.size() < 10) {
                    n2 = this.ZombieList.size();
                }
                if (this.nearestVisibleZombie[n4] != null) {
                    if (this.nearestVisibleZombie[n4].isDead()) {
                        this.nearestVisibleZombie[n4] = null;
                    } else {
                        float f5 = this.nearestVisibleZombie[n4].x - IsoCamera.CamCharacter.x;
                        float f6 = this.nearestVisibleZombie[n4].y - IsoCamera.CamCharacter.y;
                        this.nearestVisibleZombieDistSqr[n4] = f5 * f5 + f6 * f6;
                    }
                }
                int n13 = 0;
                while (n13 < n2) {
                    IsoZombie isoZombie;
                    if (this.zombieScanCursor >= this.ZombieList.size()) {
                        this.zombieScanCursor = 0;
                    }
                    if ((isoZombie = this.ZombieList.get(this.zombieScanCursor)) != null && (isoGridSquare5 = isoZombie.getCurrentSquare()) != null && isoGridSquare.z == isoGridSquare5.z && isoGridSquare5.getCanSee(n4)) {
                        if (this.nearestVisibleZombie[n4] == null) {
                            this.nearestVisibleZombie[n4] = isoZombie;
                            var19_35 = this.nearestVisibleZombie[n4].x - IsoCamera.CamCharacter.x;
                            var20_38 = this.nearestVisibleZombie[n4].y - IsoCamera.CamCharacter.y;
                            this.nearestVisibleZombieDistSqr[n4] = var19_35 * var19_35 + var20_38 * var20_38;
                        } else {
                            var19_35 = isoZombie.x - IsoCamera.CamCharacter.x;
                            var20_38 = isoZombie.y - IsoCamera.CamCharacter.y;
                            float f7 = var19_35 * var19_35 + var20_38 * var20_38;
                            if (f7 < this.nearestVisibleZombieDistSqr[n4]) {
                                this.nearestVisibleZombie[n4] = isoZombie;
                                this.nearestVisibleZombieDistSqr[n4] = f7;
                            }
                        }
                    }
                    ++n13;
                    ++this.zombieScanCursor;
                }
                for (n13 = 0; n13 < 4; ++n13) {
                    Object object2;
                    double d;
                    double d2;
                    boolean bl;
                    IsoPlayer isoPlayer2 = IsoPlayer.players[n13];
                    if (isoPlayer2 == null || isoPlayer2.getCurrentSquare() == null) continue;
                    isoGridSquare5 = isoPlayer2.getCurrentSquare();
                    if (n13 == n4) {
                        isoGridSquare2 = isoGridSquare5;
                    }
                    boolean bl2 = bl = (d2 = (double)isoPlayer2.x - Math.floor(isoPlayer2.x)) > (d = (double)isoPlayer2.y - Math.floor(isoPlayer2.y));
                    if (this.lastPlayerAngle[n13] == null) {
                        this.lastPlayerAngle[n13] = new Vector2(isoPlayer2.getForwardDirection());
                        this.playerCutawaysDirty[n13] = true;
                    } else if (isoPlayer2.getForwardDirection().dot(this.lastPlayerAngle[n13]) < 0.98f) {
                        this.lastPlayerAngle[n13].set(isoPlayer2.getForwardDirection());
                        this.playerCutawaysDirty[n13] = true;
                    }
                    IsoDirections isoDirections = IsoDirections.fromAngle(isoPlayer2.getForwardDirection());
                    if (this.lastPlayerSquare[n13] != isoGridSquare5 || this.lastPlayerSquareHalf[n13] != bl || this.lastPlayerDir[n13] != isoDirections) {
                        this.playerCutawaysDirty[n13] = true;
                        this.lastPlayerSquare[n13] = isoGridSquare5;
                        this.lastPlayerSquareHalf[n13] = bl;
                        this.lastPlayerDir[n13] = isoDirections;
                        object = isoGridSquare5.getBuilding();
                        this.playerWindowPeekingRoomId[n13] = -1;
                        this.GetBuildingsInFrontOfCharacter(this.playerOccluderBuildings.get(n13), isoGridSquare5, bl);
                        if (this.playerOccluderBuildingsArr[n4] == null) {
                            this.playerOccluderBuildingsArr[n4] = new IsoBuilding[500];
                        }
                        this.playerHidesOrphanStructures[n13] = this.bOccludedByOrphanStructureFlag;
                        if (object == null && !isoPlayer2.bRemote && (object = this.GetPeekedInBuilding(isoGridSquare5, isoDirections)) != null) {
                            this.playerWindowPeekingRoomId[n13] = this.playerPeekedRoomId;
                        }
                        if (object != null) {
                            this.AddUniqueToBuildingList(this.playerOccluderBuildings.get(n13), (IsoBuilding)object);
                        }
                        object2 = this.playerOccluderBuildings.get(n13);
                        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                            IsoBuilding isoBuilding;
                            this.playerOccluderBuildingsArr[n4][i] = isoBuilding = (IsoBuilding)((ArrayList)object2).get(i);
                        }
                        this.playerOccluderBuildingsArr[n4][((ArrayList)object2).size()] = null;
                    }
                    if (n13 == n4 && isoGridSquare2 != null) {
                        int n14;
                        this.gridSquaresTempLeft.clear();
                        this.gridSquaresTempRight.clear();
                        this.GetSquaresAroundPlayerSquare(isoPlayer2, isoGridSquare2, this.gridSquaresTempLeft, this.gridSquaresTempRight);
                        for (n14 = 0; n14 < this.gridSquaresTempLeft.size(); ++n14) {
                            object2 = this.gridSquaresTempLeft.get(n14);
                            if (!((IsoGridSquare)object2).getCanSee(n4) || ((IsoGridSquare)object2).getBuilding() != null && ((IsoGridSquare)object2).getBuilding() != isoGridSquare2.getBuilding()) continue;
                            ArrayList<IsoBuilding> arrayList = this.GetBuildingsInFrontOfMustSeeSquare((IsoGridSquare)object2, IsoGridOcclusionData.OcclusionFilter.Right);
                            for (int i = 0; i < arrayList.size(); ++i) {
                                this.AddUniqueToBuildingList(this.otherOccluderBuildings.get(n4), arrayList.get(i));
                            }
                            int n15 = n4;
                            this.playerHidesOrphanStructures[n15] = this.playerHidesOrphanStructures[n15] | this.bOccludedByOrphanStructureFlag;
                        }
                        for (n14 = 0; n14 < this.gridSquaresTempRight.size(); ++n14) {
                            object2 = this.gridSquaresTempRight.get(n14);
                            if (!((IsoGridSquare)object2).getCanSee(n4) || ((IsoGridSquare)object2).getBuilding() != null && ((IsoGridSquare)object2).getBuilding() != isoGridSquare2.getBuilding()) continue;
                            ArrayList<IsoBuilding> arrayList = this.GetBuildingsInFrontOfMustSeeSquare((IsoGridSquare)object2, IsoGridOcclusionData.OcclusionFilter.Left);
                            for (int i = 0; i < arrayList.size(); ++i) {
                                this.AddUniqueToBuildingList(this.otherOccluderBuildings.get(n4), arrayList.get(i));
                            }
                            int n16 = n4;
                            this.playerHidesOrphanStructures[n16] = this.playerHidesOrphanStructures[n16] | this.bOccludedByOrphanStructureFlag;
                        }
                        object = this.otherOccluderBuildings.get(n4);
                        if (this.otherOccluderBuildingsArr[n4] == null) {
                            this.otherOccluderBuildingsArr[n4] = new IsoBuilding[500];
                        }
                        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                            IsoBuilding isoBuilding;
                            this.otherOccluderBuildingsArr[n4][i] = isoBuilding = (IsoBuilding)((ArrayList)object).get(i);
                        }
                        this.otherOccluderBuildingsArr[n4][((ArrayList)object).size()] = null;
                    }
                    if (!this.playerHidesOrphanStructures[n13] || this.hidesOrphanStructuresAbove <= isoGridSquare5.getZ()) continue;
                    this.hidesOrphanStructuresAbove = isoGridSquare5.getZ();
                }
                if (isoGridSquare2 != null && this.hidesOrphanStructuresAbove < isoGridSquare2.getZ()) {
                    this.hidesOrphanStructuresAbove = isoGridSquare2.getZ();
                }
                n13 = 0;
                if (this.nearestVisibleZombie[n4] != null && this.nearestVisibleZombieDistSqr[n4] < 150.0f && (isoGridSquare4 = this.nearestVisibleZombie[n4].getCurrentSquare()) != null && isoGridSquare4.getCanSee(n4)) {
                    double d;
                    double d3 = (double)this.nearestVisibleZombie[n4].x - Math.floor(this.nearestVisibleZombie[n4].x);
                    boolean bl = d3 > (d = (double)this.nearestVisibleZombie[n4].y - Math.floor(this.nearestVisibleZombie[n4].y));
                    n13 = 1;
                    if (this.lastZombieSquare[n4] != isoGridSquare4 || this.lastZombieSquareHalf[n4] != bl) {
                        this.lastZombieSquare[n4] = isoGridSquare4;
                        this.lastZombieSquareHalf[n4] = bl;
                        this.GetBuildingsInFrontOfCharacter(this.zombieOccluderBuildings.get(n4), isoGridSquare4, bl);
                        ArrayList<IsoBuilding> arrayList = this.zombieOccluderBuildings.get(n4);
                        if (this.zombieOccluderBuildingsArr[n4] == null) {
                            this.zombieOccluderBuildingsArr[n4] = new IsoBuilding[500];
                        }
                        for (int i = 0; i < arrayList.size(); ++i) {
                            this.zombieOccluderBuildingsArr[n4][i] = object = arrayList.get(i);
                        }
                        this.zombieOccluderBuildingsArr[n4][arrayList.size()] = null;
                    }
                }
                if (n13 == 0) {
                    this.zombieOccluderBuildings.get(n4).clear();
                    if (this.zombieOccluderBuildingsArr[n4] != null) {
                        this.zombieOccluderBuildingsArr[n4][0] = null;
                    } else {
                        this.zombieOccluderBuildingsArr[n4] = new IsoBuilding[500];
                    }
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    this.playerOccluderBuildings.get(i).clear();
                    if (this.playerOccluderBuildingsArr[i] != null) {
                        this.playerOccluderBuildingsArr[i][0] = null;
                    } else {
                        this.playerOccluderBuildingsArr[i] = new IsoBuilding[500];
                    }
                    this.lastPlayerSquare[i] = null;
                    this.playerCutawaysDirty[i] = true;
                }
                this.playerWindowPeekingRoomId[n4] = -1;
                this.zombieOccluderBuildings.get(n4).clear();
                if (this.zombieOccluderBuildingsArr[n4] != null) {
                    this.zombieOccluderBuildingsArr[n4][0] = null;
                } else {
                    this.zombieOccluderBuildingsArr[n4] = new IsoBuilding[500];
                }
                this.lastZombieSquare[n4] = null;
            }
        }
        if (!PerformanceSettings.NewRoofHiding) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoBuilding isoBuilding;
                this.playerWindowPeekingRoomId[i] = -1;
                IsoPlayer isoPlayer3 = IsoPlayer.players[i];
                if (isoPlayer3 == null || (isoBuilding = isoPlayer3.getCurrentBuilding()) != null) continue;
                IsoDirections isoDirections = IsoDirections.fromAngle(isoPlayer3.getForwardDirection());
                isoBuilding = this.GetPeekedInBuilding(isoPlayer3.getCurrentSquare(), isoDirections);
                if (isoBuilding == null) continue;
                this.playerWindowPeekingRoomId[i] = this.playerPeekedRoomId;
            }
        }
        if (IsoCamera.CamCharacter != null && IsoCamera.CamCharacter.getCurrentSquare() != null && IsoCamera.CamCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.hidewalls)) {
            this.maxZ = (int)IsoCamera.CamCharacter.getZ() + 1;
        }
        this.bRendering = true;
        try {
            this.RenderTiles(n3);
        }
        catch (Exception exception) {
            this.bRendering = false;
            Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, null, exception);
        }
        this.bRendering = false;
        if (IsoGridSquare.getRecalcLightTime() < 0) {
            IsoGridSquare.setRecalcLightTime(60);
        }
        if (IsoGridSquare.getLightcache() <= 0) {
            IsoGridSquare.setLightcache(90);
        }
        for (n = 0; n < this.ObjectList.size(); ++n) {
            IsoMovingObject isoMovingObject = this.ObjectList.get(n);
            isoMovingObject.renderlast();
        }
        for (n = 0; n < this.StaticUpdaterObjectList.size(); ++n) {
            IsoObject isoObject = this.StaticUpdaterObjectList.get(n);
            isoObject.renderlast();
        }
        IsoTree.renderChopTreeIndicators();
        if (Core.bDebug) {
            // empty if block
        }
        this.lastMinX = this.minX;
        this.lastMinY = this.minY;
        this.DoBuilding(IsoPlayer.getPlayerIndex(), true);
        this.renderRain();
    }

    public void invalidatePeekedRoom(int n) {
        this.lastPlayerDir[n] = IsoDirections.Max;
    }

    private boolean initWeatherFx() {
        if (GameServer.bServer) {
            return false;
        }
        if (this.weatherFX == null) {
            this.weatherFX = new IsoWeatherFX();
            this.weatherFX.init();
        }
        return true;
    }

    private void updateWeatherFx() {
        if (this.initWeatherFx()) {
            this.weatherFX.update();
        }
    }

    private void renderWeatherFx() {
        if (this.initWeatherFx()) {
            this.weatherFX.render();
        }
    }

    public IsoWeatherFX getWeatherFX() {
        return this.weatherFX;
    }

    private void renderRain() {
    }

    public void setRainAlpha(int n) {
        this.rainAlphaMax = (float)n / 100.0f;
    }

    public void setRainIntensity(int n) {
        this.rainIntensity = n;
    }

    public void setRainSpeed(int n) {
        this.rainSpeed = n;
    }

    public void reloadRainTextures() {
    }

    private void GetBuildingsInFrontOfCharacter(ArrayList<IsoBuilding> arrayList, IsoGridSquare isoGridSquare, boolean bl) {
        arrayList.clear();
        this.bOccludedByOrphanStructureFlag = false;
        if (isoGridSquare == null) {
            return;
        }
        int n = isoGridSquare.getX();
        int n2 = isoGridSquare.getY();
        int n3 = isoGridSquare.getZ();
        this.GetBuildingsInFrontOfCharacterSquare(n, n2, n3, bl, arrayList);
        if (n3 < MaxHeight) {
            this.GetBuildingsInFrontOfCharacterSquare(n - 1 + 3, n2 - 1 + 3, n3 + 1, bl, arrayList);
            this.GetBuildingsInFrontOfCharacterSquare(n - 2 + 3, n2 - 2 + 3, n3 + 1, bl, arrayList);
            if (bl) {
                this.GetBuildingsInFrontOfCharacterSquare(n + 3, n2 - 1 + 3, n3 + 1, !bl, arrayList);
                this.GetBuildingsInFrontOfCharacterSquare(n - 1 + 3, n2 - 2 + 3, n3 + 1, !bl, arrayList);
            } else {
                this.GetBuildingsInFrontOfCharacterSquare(n - 1 + 3, n2 + 3, n3 + 1, !bl, arrayList);
                this.GetBuildingsInFrontOfCharacterSquare(n - 2 + 3, n2 - 1 + 3, n3 + 1, !bl, arrayList);
            }
        }
    }

    private void GetBuildingsInFrontOfCharacterSquare(int n, int n2, int n3, boolean bl, ArrayList<IsoBuilding> arrayList) {
        IsoGridSquare isoGridSquare = this.getGridSquare(n, n2, n3);
        if (isoGridSquare == null) {
            if (n3 < MaxHeight) {
                this.GetBuildingsInFrontOfCharacterSquare(n + 3, n2 + 3, n3 + 1, bl, arrayList);
            }
            return;
        }
        IsoGridOcclusionData isoGridOcclusionData = isoGridSquare.getOrCreateOcclusionData();
        IsoGridOcclusionData.OcclusionFilter occlusionFilter = bl ? IsoGridOcclusionData.OcclusionFilter.Right : IsoGridOcclusionData.OcclusionFilter.Left;
        this.bOccludedByOrphanStructureFlag |= isoGridOcclusionData.getCouldBeOccludedByOrphanStructures(occlusionFilter);
        ArrayList<IsoBuilding> arrayList2 = isoGridOcclusionData.getBuildingsCouldBeOccluders(occlusionFilter);
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.AddUniqueToBuildingList(arrayList, arrayList2.get(i));
        }
    }

    private ArrayList<IsoBuilding> GetBuildingsInFrontOfMustSeeSquare(IsoGridSquare isoGridSquare, IsoGridOcclusionData.OcclusionFilter occlusionFilter) {
        IsoGridOcclusionData isoGridOcclusionData = isoGridSquare.getOrCreateOcclusionData();
        this.bOccludedByOrphanStructureFlag = isoGridOcclusionData.getCouldBeOccludedByOrphanStructures(IsoGridOcclusionData.OcclusionFilter.All);
        return isoGridOcclusionData.getBuildingsCouldBeOccluders(occlusionFilter);
    }

    private IsoBuilding GetPeekedInBuilding(IsoGridSquare isoGridSquare, IsoDirections isoDirections) {
        IsoBuilding isoBuilding;
        IsoGridSquare isoGridSquare2;
        this.playerPeekedRoomId = -1;
        if (isoGridSquare == null) {
            return null;
        }
        if ((isoDirections == IsoDirections.NW || isoDirections == IsoDirections.N || isoDirections == IsoDirections.NE) && LosUtil.lineClear(this, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, isoGridSquare.x, isoGridSquare.y - 1, isoGridSquare.z, false) != LosUtil.TestResults.Blocked && (isoGridSquare2 = isoGridSquare.nav[IsoDirections.N.index()]) != null && (isoBuilding = isoGridSquare2.getBuilding()) != null) {
            this.playerPeekedRoomId = isoGridSquare2.getRoomID();
            return isoBuilding;
        }
        if ((isoDirections == IsoDirections.SW || isoDirections == IsoDirections.W || isoDirections == IsoDirections.NW) && LosUtil.lineClear(this, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, isoGridSquare.x - 1, isoGridSquare.y, isoGridSquare.z, false) != LosUtil.TestResults.Blocked && (isoGridSquare2 = isoGridSquare.nav[IsoDirections.W.index()]) != null && (isoBuilding = isoGridSquare2.getBuilding()) != null) {
            this.playerPeekedRoomId = isoGridSquare2.getRoomID();
            return isoBuilding;
        }
        if ((isoDirections == IsoDirections.SE || isoDirections == IsoDirections.S || isoDirections == IsoDirections.SW) && LosUtil.lineClear(this, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, isoGridSquare.x, isoGridSquare.y + 1, isoGridSquare.z, false) != LosUtil.TestResults.Blocked && (isoGridSquare2 = isoGridSquare.nav[IsoDirections.S.index()]) != null && (isoBuilding = isoGridSquare2.getBuilding()) != null) {
            this.playerPeekedRoomId = isoGridSquare2.getRoomID();
            return isoBuilding;
        }
        if ((isoDirections == IsoDirections.NE || isoDirections == IsoDirections.E || isoDirections == IsoDirections.SE) && LosUtil.lineClear(this, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, isoGridSquare.x + 1, isoGridSquare.y, isoGridSquare.z, false) != LosUtil.TestResults.Blocked && (isoGridSquare2 = isoGridSquare.nav[IsoDirections.E.index()]) != null && (isoBuilding = isoGridSquare2.getBuilding()) != null) {
            this.playerPeekedRoomId = isoGridSquare2.getRoomID();
            return isoBuilding;
        }
        return null;
    }

    void GetSquaresAroundPlayerSquare(IsoPlayer isoPlayer, IsoGridSquare isoGridSquare, ArrayList<IsoGridSquare> arrayList, ArrayList<IsoGridSquare> arrayList2) {
        float f = isoPlayer.x - 4.0f;
        float f2 = isoPlayer.y - 4.0f;
        int n = (int)f;
        int n2 = (int)f2;
        int n3 = isoGridSquare.getZ();
        for (int i = n2; i < n2 + 10; ++i) {
            for (int j = n; j < n + 10; ++j) {
                IsoGridSquare isoGridSquare2;
                float f3;
                float f4;
                if (j < (int)isoPlayer.x && i < (int)isoPlayer.y || j == (int)isoPlayer.x && i == (int)isoPlayer.y || !((double)(f4 = (float)i - isoPlayer.y) < (double)(f3 = (float)j - isoPlayer.x) + 4.5) || !((double)f4 > (double)f3 - 4.5) || (isoGridSquare2 = this.getGridSquare(j, i, n3)) == null) continue;
                if (f4 >= f3) {
                    arrayList.add(isoGridSquare2);
                }
                if (!(f4 <= f3)) continue;
                arrayList2.add(isoGridSquare2);
            }
        }
    }

    private boolean IsBehindStuff(IsoGridSquare isoGridSquare) {
        if (!isoGridSquare.getProperties().Is(IsoFlagType.exterior)) {
            return true;
        }
        for (int i = 1; i < 8 && isoGridSquare.getZ() + i < MaxHeight; ++i) {
            for (int j = -5; j <= 6; ++j) {
                for (int k = -5; k <= 6; ++k) {
                    IsoGridSquare isoGridSquare2;
                    int n = j;
                    if (k < n - 5 || k > n + 5 || (isoGridSquare2 = this.getGridSquare(isoGridSquare.getX() + k + i * 3, isoGridSquare.getY() + j + i * 3, isoGridSquare.getZ() + i)) == null || isoGridSquare2.getObjects().isEmpty()) continue;
                    if (i == 1 && isoGridSquare2.getObjects().size() == 1) {
                        IsoObject isoObject = isoGridSquare2.getObjects().get(0);
                        if (isoObject.sprite != null && isoObject.sprite.name != null && isoObject.sprite.name.startsWith("lighting_outdoor")) continue;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static IsoDirections FromMouseTile() {
        IsoDirections isoDirections = IsoDirections.N;
        float f = UIManager.getPickedTileLocal().x;
        float f2 = UIManager.getPickedTileLocal().y;
        float f3 = 0.5f - Math.abs(0.5f - f2);
        float f4 = 0.5f - Math.abs(0.5f - f);
        if (f > 0.5f && f4 < f3) {
            isoDirections = IsoDirections.E;
        } else if (f2 > 0.5f && f4 > f3) {
            isoDirections = IsoDirections.S;
        } else if (f < 0.5f && f4 < f3) {
            isoDirections = IsoDirections.W;
        } else if (f2 < 0.5f && f4 > f3) {
            isoDirections = IsoDirections.N;
        }
        return isoDirections;
    }

    public void update() {
        s_performance.isoCellUpdate.invokeAndMeasure(this, IsoCell::updateInternal);
    }

    private void updateInternal() {
        MovingObjectUpdateScheduler.instance.startFrame();
        IsoSprite.alphaStep = 0.075f * (GameTime.getInstance().getMultiplier() / 1.6f);
        ++IsoGridSquare.gridSquareCacheEmptyTimer;
        this.ProcessSpottedRooms();
        if (!GameServer.bServer) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                if (IsoPlayer.players[i] == null || IsoPlayer.players[i].isDead() && IsoPlayer.players[i].ReanimatedCorpse == null) continue;
                IsoPlayer.setInstance(IsoPlayer.players[i]);
                IsoCamera.CamCharacter = IsoPlayer.players[i];
                this.ChunkMap[i].update();
            }
        }
        this.ProcessRemoveItems(null);
        this.ProcessItems(null);
        this.ProcessRemoveItems(null);
        this.ProcessIsoObject();
        this.safeToAdd = false;
        this.ProcessObjects(null);
        if (GameClient.bClient && (NetworkZombieSimulator.getInstance().anyUnknownZombies() && GameClient.instance.sendZombieRequestsTimer.Check() || GameClient.instance.sendZombieTimer.Check())) {
            NetworkZombieSimulator.getInstance().send();
            GameClient.instance.sendZombieTimer.Reset();
            GameClient.instance.sendZombieRequestsTimer.Reset();
        }
        this.safeToAdd = true;
        this.ProcessStaticUpdaters();
        this.ObjectDeletionAddition();
        IsoDeadBody.updateBodies();
        IsoGridSquare.setLightcache(IsoGridSquare.getLightcache() - 1);
        IsoGridSquare.setRecalcLightTime(IsoGridSquare.getRecalcLightTime() - 1);
        if (GameServer.bServer) {
            this.LamppostPositions.clear();
            this.roomLights.clear();
        }
        if (!GameTime.isGamePaused()) {
            this.rainScroll += (float)this.rainSpeed / 10.0f * 0.075f * (30.0f / (float)PerformanceSettings.getLockFPS());
            if (this.rainScroll > 1.0f) {
                this.rainScroll = 0.0f;
            }
        }
        if (!GameServer.bServer) {
            this.updateWeatherFx();
        }
    }

    IsoGridSquare getRandomFreeTile() {
        IsoGridSquare isoGridSquare = null;
        boolean bl = true;
        do {
            bl = true;
            isoGridSquare = this.getGridSquare(Rand.Next(this.width), Rand.Next(this.height), 0);
            if (isoGridSquare == null) {
                bl = false;
                continue;
            }
            if (!isoGridSquare.isFree(false)) {
                bl = false;
                continue;
            }
            if (isoGridSquare.getProperties().Is(IsoFlagType.solid) || isoGridSquare.getProperties().Is(IsoFlagType.solidtrans)) {
                bl = false;
                continue;
            }
            if (isoGridSquare.getMovingObjects().size() > 0) {
                bl = false;
                continue;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsBN) || isoGridSquare.Has(IsoObjectType.stairsMN) || isoGridSquare.Has(IsoObjectType.stairsTN)) {
                bl = false;
                continue;
            }
            if (!isoGridSquare.Has(IsoObjectType.stairsBW) && !isoGridSquare.Has(IsoObjectType.stairsMW) && !isoGridSquare.Has(IsoObjectType.stairsTW)) continue;
            bl = false;
        } while (!bl);
        return isoGridSquare;
    }

    IsoGridSquare getRandomOutdoorFreeTile() {
        IsoGridSquare isoGridSquare = null;
        boolean bl = true;
        do {
            bl = true;
            isoGridSquare = this.getGridSquare(Rand.Next(this.width), Rand.Next(this.height), 0);
            if (isoGridSquare == null) {
                bl = false;
                continue;
            }
            if (!isoGridSquare.isFree(false)) {
                bl = false;
                continue;
            }
            if (isoGridSquare.getRoom() != null) {
                bl = false;
                continue;
            }
            if (isoGridSquare.getProperties().Is(IsoFlagType.solid) || isoGridSquare.getProperties().Is(IsoFlagType.solidtrans)) {
                bl = false;
                continue;
            }
            if (isoGridSquare.getMovingObjects().size() > 0) {
                bl = false;
                continue;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsBN) || isoGridSquare.Has(IsoObjectType.stairsMN) || isoGridSquare.Has(IsoObjectType.stairsTN)) {
                bl = false;
                continue;
            }
            if (!isoGridSquare.Has(IsoObjectType.stairsBW) && !isoGridSquare.Has(IsoObjectType.stairsMW) && !isoGridSquare.Has(IsoObjectType.stairsTW)) continue;
            bl = false;
        } while (!bl);
        return isoGridSquare;
    }

    public IsoGridSquare getRandomFreeTileInRoom() {
        Stack<IsoRoom> stack = new Stack<IsoRoom>();
        for (int i = 0; i < this.RoomList.size(); ++i) {
            if (this.RoomList.get((int)i).TileList.size() <= 9 || this.RoomList.get((int)i).Exits.isEmpty() || !this.RoomList.get((int)i).TileList.get(0).getProperties().Is(IsoFlagType.solidfloor)) continue;
            stack.add(this.RoomList.get(i));
        }
        if (stack.isEmpty()) {
            return null;
        }
        IsoRoom isoRoom = (IsoRoom)stack.get(Rand.Next(stack.size()));
        return isoRoom.getFreeTile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void roomSpotted(IsoRoom isoRoom) {
        Stack<IsoRoom> stack = this.SpottedRooms;
        synchronized (stack) {
            if (!this.SpottedRooms.contains(isoRoom)) {
                this.SpottedRooms.push(isoRoom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessSpottedRooms() {
        Stack<IsoRoom> stack = this.SpottedRooms;
        synchronized (stack) {
            for (int i = 0; i < this.SpottedRooms.size(); ++i) {
                IsoGridSquare isoGridSquare;
                IsoRoom isoRoom = (IsoRoom)this.SpottedRooms.get(i);
                if (isoRoom.def.bDoneSpawn) continue;
                isoRoom.def.bDoneSpawn = true;
                LuaEventManager.triggerEvent("OnSeeNewRoom", isoRoom);
                VirtualZombieManager.instance.roomSpotted(isoRoom);
                if (GameClient.bClient || Core.bLastStand || !"shed".equals(isoRoom.def.name) && !"garagestorage".equals(isoRoom.def.name) && !"storageunit".equals(isoRoom.def.name)) continue;
                int n = 7;
                if ("shed".equals(isoRoom.def.name) || "garagestorage".equals(isoRoom.def.name)) {
                    n = 4;
                }
                switch (SandboxOptions.instance.GeneratorSpawning.getValue()) {
                    case 1: {
                        n += 3;
                        break;
                    }
                    case 2: {
                        n += 2;
                        break;
                    }
                    case 4: {
                        n -= 2;
                        break;
                    }
                    case 5: {
                        n -= 3;
                    }
                }
                if (Rand.Next(n) != 0 || (isoGridSquare = isoRoom.getRandomFreeSquare()) == null) continue;
                IsoGenerator isoGenerator = new IsoGenerator(InventoryItemFactory.CreateItem("Base.Generator"), this, isoGridSquare);
                if (!GameServer.bServer) continue;
                isoGenerator.transmitCompleteItemToClients();
            }
            this.SpottedRooms.clear();
        }
    }

    public void savePlayer() throws IOException {
        if (IsoPlayer.players[0] != null && !IsoPlayer.players[0].isDead()) {
            IsoPlayer.players[0].save();
        }
        GameClient.instance.sendPlayerSave(IsoPlayer.players[0]);
    }

    public void save(DataOutputStream dataOutputStream, boolean bl) throws IOException {
        while (ChunkSaveWorker.instance.bSaving) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            this.ChunkMap[i].Save();
        }
        dataOutputStream.writeInt(this.width);
        dataOutputStream.writeInt(this.height);
        dataOutputStream.writeInt(MaxHeight);
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_t.bin");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        GameTime.instance.save(dataOutputStream);
        dataOutputStream.flush();
        dataOutputStream.close();
        IsoWorld.instance.MetaGrid.save();
        if (PlayerDB.isAllow()) {
            PlayerDB.getInstance().savePlayers();
        }
        ReanimatedPlayers.instance.saveReanimatedPlayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean LoadPlayer(int n) throws FileNotFoundException, IOException {
        if (GameClient.bClient) {
            return ClientPlayerDB.getInstance().loadNetworkPlayer();
        }
        File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_p.bin");
        if (!file.exists()) {
            PlayerDB.getInstance().importPlayersFromVehiclesDB();
            return PlayerDB.getInstance().loadLocalPlayer(1);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        Object object = SliceY.SliceBufferLock;
        synchronized (object) {
            SliceY.SliceBuffer.clear();
            int n2 = bufferedInputStream.read(SliceY.SliceBuffer.array());
            SliceY.SliceBuffer.limit(n2);
            byte by = SliceY.SliceBuffer.get();
            byte by2 = SliceY.SliceBuffer.get();
            byte by3 = SliceY.SliceBuffer.get();
            byte by4 = SliceY.SliceBuffer.get();
            if (by == 80 && by2 == 76 && by3 == 89 && by4 == 82) {
                n = SliceY.SliceBuffer.getInt();
            } else {
                SliceY.SliceBuffer.rewind();
            }
            if (n >= 69) {
                String string = GameWindow.ReadString(SliceY.SliceBuffer);
                if (GameClient.bClient && n < 71) {
                    string = ServerOptions.instance.ServerPlayerID.getValue();
                }
                if (GameClient.bClient && !IsoPlayer.isServerPlayerIDValid(string)) {
                    GameLoadingState.GameLoadingString = Translator.getText("IGUI_MP_ServerPlayerIDMismatch");
                    GameLoadingState.playerWrongIP = true;
                    return false;
                }
            }
            IsoCell.instance.ChunkMap[IsoPlayer.getPlayerIndex()].WorldX = SliceY.SliceBuffer.getInt() + IsoWorld.saveoffsetx * 30;
            IsoCell.instance.ChunkMap[IsoPlayer.getPlayerIndex()].WorldY = SliceY.SliceBuffer.getInt() + IsoWorld.saveoffsety * 30;
            SliceY.SliceBuffer.getInt();
            SliceY.SliceBuffer.getInt();
            SliceY.SliceBuffer.getInt();
            if (IsoPlayer.getInstance() == null) {
                IsoPlayer.setInstance(new IsoPlayer(instance));
                IsoPlayer.players[0] = IsoPlayer.getInstance();
            }
            IsoPlayer.getInstance().load(SliceY.SliceBuffer, n);
            fileInputStream.close();
        }
        PlayerDB.getInstance().saveLocalPlayersForce();
        file.delete();
        PlayerDB.getInstance().uploadLocalPlayers2DB();
        return true;
    }

    public IsoGridSquare getRelativeGridSquare(int n, int n2, int n3) {
        IsoChunkMap cfr_ignored_0 = this.ChunkMap[0];
        int n4 = this.ChunkMap[0].getWorldXMin() * 10;
        IsoChunkMap cfr_ignored_1 = this.ChunkMap[0];
        int n5 = this.ChunkMap[0].getWorldYMin() * 10;
        return this.getGridSquare(n += n4, n2 += n5, n3);
    }

    public IsoGridSquare createNewGridSquare(int n, int n2, int n3, boolean bl) {
        if (!IsoWorld.instance.isValidSquare(n, n2, n3)) {
            return null;
        }
        IsoGridSquare isoGridSquare = this.getGridSquare(n, n2, n3);
        if (isoGridSquare != null) {
            return isoGridSquare;
        }
        if (GameServer.bServer) {
            int n4 = n / 10;
            int n5 = n2 / 10;
            if (ServerMap.instance.getChunk(n4, n5) != null) {
                isoGridSquare = IsoGridSquare.getNew(this, null, n, n2, n3);
                ServerMap.instance.setGridSquare(n, n2, n3, isoGridSquare);
            }
        } else if (this.getChunkForGridSquare(n, n2, n3) != null) {
            isoGridSquare = IsoGridSquare.getNew(this, null, n, n2, n3);
            this.ConnectNewSquare(isoGridSquare, true);
        }
        if (isoGridSquare != null && bl) {
            isoGridSquare.RecalcAllWithNeighbours(true);
        }
        return isoGridSquare;
    }

    public IsoGridSquare getGridSquareDirect(int n, int n2, int n3, int n4) {
        int n5 = IsoChunkMap.ChunkWidthInTiles;
        return this.gridSquares[n4][n + n2 * n5 + n3 * n5 * n5];
    }

    public boolean isInChunkMap(int n, int n2) {
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            int n3 = this.ChunkMap[i].getWorldXMinTiles();
            int n4 = this.ChunkMap[i].getWorldXMaxTiles();
            int n5 = this.ChunkMap[i].getWorldYMinTiles();
            int n6 = this.ChunkMap[i].getWorldYMaxTiles();
            if (n < n3 || n >= n4 || n2 < n5 || n2 >= n6) continue;
            return true;
        }
        return false;
    }

    public ArrayList<IsoObject> getProcessIsoObjectRemove() {
        return this.ProcessIsoObjectRemove;
    }

    public void checkHaveRoof(int n, int n2) {
        boolean bl = false;
        for (int i = 8; i >= 0; --i) {
            IsoGridSquare isoGridSquare = this.getGridSquare(n, n2, i);
            if (isoGridSquare == null) continue;
            if (bl != isoGridSquare.haveRoof) {
                isoGridSquare.haveRoof = bl;
                isoGridSquare.RecalcAllWithNeighbours(true);
            }
            if (!isoGridSquare.Is(IsoFlagType.solidfloor)) continue;
            bl = true;
        }
    }

    public IsoZombie getFakeZombieForHit() {
        if (this.fakeZombieForHit == null) {
            this.fakeZombieForHit = new IsoZombie(this);
        }
        return this.fakeZombieForHit;
    }

    public void addHeatSource(IsoHeatSource isoHeatSource) {
        if (GameServer.bServer) {
            return;
        }
        if (this.heatSources.contains(isoHeatSource)) {
            DebugLog.log("ERROR addHeatSource called again with the same HeatSource");
            return;
        }
        this.heatSources.add(isoHeatSource);
    }

    public void removeHeatSource(IsoHeatSource isoHeatSource) {
        if (GameServer.bServer) {
            return;
        }
        this.heatSources.remove(isoHeatSource);
    }

    public void updateHeatSources() {
        if (GameServer.bServer) {
            return;
        }
        for (int i = this.heatSources.size() - 1; i >= 0; --i) {
            IsoHeatSource isoHeatSource = this.heatSources.get(i);
            if (isoHeatSource.isInBounds()) continue;
            this.heatSources.remove(i);
        }
    }

    public int getHeatSourceTemperature(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < this.heatSources.size(); ++i) {
            LosUtil.TestResults testResults;
            float f;
            IsoHeatSource isoHeatSource = this.heatSources.get(i);
            if (isoHeatSource.getZ() != n3 || !((f = IsoUtils.DistanceToSquared(n, n2, isoHeatSource.getX(), isoHeatSource.getY())) < (float)(isoHeatSource.getRadius() * isoHeatSource.getRadius())) || (testResults = LosUtil.lineClear(this, isoHeatSource.getX(), isoHeatSource.getY(), isoHeatSource.getZ(), n, n2, n3, false)) != LosUtil.TestResults.Clear && testResults != LosUtil.TestResults.ClearThroughOpenDoor) continue;
            n4 = (int)((double)n4 + (double)isoHeatSource.getTemperature() * (1.0 - Math.sqrt(f) / (double)isoHeatSource.getRadius()));
        }
        return n4;
    }

    public float getHeatSourceHighestTemperature(float f, int n, int n2, int n3) {
        float f2;
        float f3 = f2 = f;
        float f4 = 0.0f;
        IsoGridSquare isoGridSquare = null;
        float f5 = 0.0f;
        for (int i = 0; i < this.heatSources.size(); ++i) {
            LosUtil.TestResults testResults;
            IsoHeatSource isoHeatSource = this.heatSources.get(i);
            if (isoHeatSource.getZ() != n3) continue;
            float f6 = IsoUtils.DistanceToSquared(n, n2, isoHeatSource.getX(), isoHeatSource.getY());
            isoGridSquare = this.getGridSquare(isoHeatSource.getX(), isoHeatSource.getY(), isoHeatSource.getZ());
            f5 = 0.0f;
            if (isoGridSquare != null) {
                if (!isoGridSquare.isInARoom()) {
                    f5 = f2 - 30.0f;
                    if (f5 < -15.0f) {
                        f5 = -15.0f;
                    } else if (f5 > 5.0f) {
                        f5 = 5.0f;
                    }
                } else {
                    f5 = f2 - 30.0f;
                    if (f5 < -7.0f) {
                        f5 = -7.0f;
                    } else if (f5 > 7.0f) {
                        f5 = 7.0f;
                    }
                }
            }
            if ((f4 = ClimateManager.lerp((float)(1.0 - Math.sqrt(f6) / (double)isoHeatSource.getRadius()), f2, (float)isoHeatSource.getTemperature() + f5)) <= f3 || !(f6 < (float)(isoHeatSource.getRadius() * isoHeatSource.getRadius())) || (testResults = LosUtil.lineClear(this, isoHeatSource.getX(), isoHeatSource.getY(), isoHeatSource.getZ(), n, n2, n3, false)) != LosUtil.TestResults.Clear && testResults != LosUtil.TestResults.ClearThroughOpenDoor) continue;
            f3 = f4;
        }
        return f3;
    }

    public void putInVehicle(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null || isoGameCharacter.savedVehicleSeat == -1) {
            return;
        }
        int n = ((int)isoGameCharacter.getX() - 4) / 10;
        int n2 = ((int)isoGameCharacter.getY() - 4) / 10;
        int n3 = ((int)isoGameCharacter.getX() + 4) / 10;
        int n4 = ((int)isoGameCharacter.getY() + 4) / 10;
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                IsoChunk isoChunk = this.getChunkForGridSquare(j * 10, i * 10, (int)isoGameCharacter.getZ());
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if ((int)baseVehicle.getZ() != (int)isoGameCharacter.getZ() || !(IsoUtils.DistanceToSquared(baseVehicle.getX(), baseVehicle.getY(), isoGameCharacter.savedVehicleX, isoGameCharacter.savedVehicleY) < 0.010000001f)) continue;
                    if (baseVehicle.VehicleID == -1) {
                        return;
                    }
                    VehicleScript.Position position = baseVehicle.getPassengerPosition(isoGameCharacter.savedVehicleSeat, "inside");
                    if (position != null && !baseVehicle.isSeatOccupied(isoGameCharacter.savedVehicleSeat)) {
                        baseVehicle.enter(isoGameCharacter.savedVehicleSeat, isoGameCharacter, position.offset);
                        LuaEventManager.triggerEvent("OnEnterVehicle", isoGameCharacter);
                        if (baseVehicle.getCharacter(isoGameCharacter.savedVehicleSeat) == isoGameCharacter && isoGameCharacter.savedVehicleRunning) {
                            baseVehicle.resumeRunningAfterLoad();
                        }
                    }
                    return;
                }
            }
        }
    }

    @Deprecated
    public void resumeVehicleSounds(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null || isoGameCharacter.savedVehicleSeat == -1) {
            return;
        }
        int n = ((int)isoGameCharacter.getX() - 4) / 10;
        int n2 = ((int)isoGameCharacter.getY() - 4) / 10;
        int n3 = ((int)isoGameCharacter.getX() + 4) / 10;
        int n4 = ((int)isoGameCharacter.getY() + 4) / 10;
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                IsoChunk isoChunk = this.getChunkForGridSquare(j * 10, i * 10, (int)isoGameCharacter.getZ());
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if (!baseVehicle.lightbarSirenMode.isEnable()) continue;
                    baseVehicle.setLightbarSirenMode(baseVehicle.lightbarSirenMode.get());
                }
            }
        }
    }

    private void AddUniqueToBuildingList(ArrayList<IsoBuilding> arrayList, IsoBuilding isoBuilding) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != isoBuilding) continue;
            return;
        }
        arrayList.add(isoBuilding);
    }

    public IsoSpriteManager getSpriteManager() {
        return IsoSpriteManager.instance;
    }

    static {
        stchoices = new ArrayList();
        buildingscores = new Stack();
        GridStack = null;
        ShadowSquares = new ArrayList(1000);
        MinusFloorCharacters = new ArrayList(1000);
        SolidFloor = new ArrayList(5000);
        ShadedFloor = new ArrayList(5000);
        VegetationCorpses = new ArrayList(5000);
        perPlayerRender = new PerPlayerRender[4];
    }

    public static final class PerPlayerRender {
        public final IsoGridStack GridStacks = new IsoGridStack(9);
        public boolean[][][] VisiOccludedFlags;
        public boolean[][] VisiCulledFlags;
        public short[][][] StencilValues;
        public boolean[][] FlattenGrassEtc;
        public int minX;
        public int minY;
        public int maxX;
        public int maxY;

        public void setSize(int n, int n2) {
            if (this.VisiOccludedFlags == null || this.VisiOccludedFlags.length < n || this.VisiOccludedFlags[0].length < n2) {
                this.VisiOccludedFlags = new boolean[n][n2][2];
                this.VisiCulledFlags = new boolean[n][n2];
                this.StencilValues = new short[n][n2][2];
                this.FlattenGrassEtc = new boolean[n][n2];
            }
        }
    }

    private static class s_performance {
        static final PerformanceProfileProbe isoCellUpdate = new PerformanceProfileProbe("IsoCell.update");
        static final PerformanceProfileProbe isoCellRender = new PerformanceProfileProbe("IsoCell.render");
        static final PerformanceProfileProbe isoCellRenderTiles = new PerformanceProfileProbe("IsoCell.renderTiles");
        static final PerformanceProfileProbe isoCellDoBuilding = new PerformanceProfileProbe("IsoCell.doBuilding");

        private s_performance() {
        }

        static class renderTiles {
            static final PerformanceProfileProbe performRenderTiles = new PerformanceProfileProbe("performRenderTiles");
            static final PerformanceProfileProbe recalculateAnyGridStacks = new PerformanceProfileProbe("recalculateAnyGridStacks");
            static final PerformanceProfileProbe flattenAnyFoliage = new PerformanceProfileProbe("flattenAnyFoliage");
            static final PerformanceProfileProbe renderDebugPhysics = new PerformanceProfileProbe("renderDebugPhysics");
            static final PerformanceProfileProbe renderDebugLighting = new PerformanceProfileProbe("renderDebugLighting");
            static PerformanceProfileProbeList<PperformRenderTilesLayer> performRenderTilesLayers = PerformanceProfileProbeList.construct("performRenderTiles", 8, PperformRenderTilesLayer.class, PperformRenderTilesLayer::new);

            renderTiles() {
            }

            static class PperformRenderTilesLayer
            extends PerformanceProfileProbe {
                final PerformanceProfileProbe renderIsoWater = new PerformanceProfileProbe("renderIsoWater");
                final PerformanceProfileProbe renderFloor = new PerformanceProfileProbe("renderFloor");
                final PerformanceProfileProbe renderPuddles = new PerformanceProfileProbe("renderPuddles");
                final PerformanceProfileProbe renderShore = new PerformanceProfileProbe("renderShore");
                final PerformanceProfileProbe renderSnow = new PerformanceProfileProbe("renderSnow");
                final PerformanceProfileProbe renderBlood = new PerformanceProfileProbe("renderBlood");
                final PerformanceProfileProbe vegetationCorpses = new PerformanceProfileProbe("vegetationCorpses");
                final PerformanceProfileProbe renderFloorShading = new PerformanceProfileProbe("renderFloorShading");
                final PerformanceProfileProbe renderShadows = new PerformanceProfileProbe("renderShadows");
                final PerformanceProfileProbe luaOnPostFloorLayerDraw = new PerformanceProfileProbe("luaOnPostFloorLayerDraw");
                final PerformanceProfileProbe minusFloorCharacters = new PerformanceProfileProbe("minusFloorCharacters");

                PperformRenderTilesLayer(String string) {
                    super(string);
                }
            }
        }
    }

    private class SnowGrid {
        public int w = 256;
        public int h = 256;
        public int frac = 0;
        public static final int N = 0;
        public static final int S = 1;
        public static final int W = 2;
        public static final int E = 3;
        public static final int A = 0;
        public static final int B = 1;
        public final Texture[][][] grid = new Texture[this.w][this.h][2];
        public final byte[][][] gridType = new byte[this.w][this.h][2];

        public SnowGrid(int n) {
            this.init(n);
        }

        public SnowGrid init(int n) {
            int n2;
            int n3;
            int n4;
            byte by;
            if (!IsoCell.this.hasSetupSnowGrid) {
                IsoCell.this.snowNoise2D = new Noise2D();
                IsoCell.this.snowNoise2D.addLayer(16, 0.5f, 3.0f);
                IsoCell.this.snowNoise2D.addLayer(32, 2.0f, 5.0f);
                IsoCell.this.snowNoise2D.addLayer(64, 5.0f, 8.0f);
                byte by2 = by = 0;
                by = (byte)(by + 1);
                IsoCell.this.snowGridTiles_Square = new SnowGridTiles(by2);
                n4 = 40;
                for (n3 = 0; n3 < 4; ++n3) {
                    IsoCell.this.snowGridTiles_Square.add(Texture.getSharedTexture("e_newsnow_ground_1_" + (n4 + n3)));
                }
                byte by3 = by;
                by = (byte)(by + 1);
                IsoCell.this.snowGridTiles_Enclosed = new SnowGridTiles(by3);
                n4 = 0;
                for (n3 = 0; n3 < 4; ++n3) {
                    IsoCell.this.snowGridTiles_Enclosed.add(Texture.getSharedTexture("e_newsnow_ground_1_" + (n4 + n3)));
                }
                IsoCell.this.snowGridTiles_Cove = new SnowGridTiles[4];
                for (n3 = 0; n3 < 4; ++n3) {
                    byte by4 = by;
                    by = (byte)(by + 1);
                    IsoCell.this.snowGridTiles_Cove[n3] = new SnowGridTiles(by4);
                    if (n3 == 0) {
                        n4 = 7;
                    }
                    if (n3 == 2) {
                        n4 = 4;
                    }
                    if (n3 == 1) {
                        n4 = 5;
                    }
                    if (n3 == 3) {
                        n4 = 6;
                    }
                    for (n2 = 0; n2 < 3; ++n2) {
                        IsoCell.this.snowGridTiles_Cove[n3].add(Texture.getSharedTexture("e_newsnow_ground_1_" + (n4 + n2 * 4)));
                    }
                }
                IsoCell.this.m_snowFirstNonSquare = by;
                IsoCell.this.snowGridTiles_Edge = new SnowGridTiles[4];
                for (n3 = 0; n3 < 4; ++n3) {
                    byte by5 = by;
                    by = (byte)(by + 1);
                    IsoCell.this.snowGridTiles_Edge[n3] = new SnowGridTiles(by5);
                    if (n3 == 0) {
                        n4 = 16;
                    }
                    if (n3 == 2) {
                        n4 = 18;
                    }
                    if (n3 == 1) {
                        n4 = 17;
                    }
                    if (n3 == 3) {
                        n4 = 19;
                    }
                    for (n2 = 0; n2 < 3; ++n2) {
                        IsoCell.this.snowGridTiles_Edge[n3].add(Texture.getSharedTexture("e_newsnow_ground_1_" + (n4 + n2 * 4)));
                    }
                }
                IsoCell.this.snowGridTiles_Strip = new SnowGridTiles[4];
                for (n3 = 0; n3 < 4; ++n3) {
                    byte by6 = by;
                    by = (byte)(by + 1);
                    IsoCell.this.snowGridTiles_Strip[n3] = new SnowGridTiles(by6);
                    if (n3 == 0) {
                        n4 = 28;
                    }
                    if (n3 == 2) {
                        n4 = 29;
                    }
                    if (n3 == 1) {
                        n4 = 31;
                    }
                    if (n3 == 3) {
                        n4 = 30;
                    }
                    for (n2 = 0; n2 < 3; ++n2) {
                        IsoCell.this.snowGridTiles_Strip[n3].add(Texture.getSharedTexture("e_newsnow_ground_1_" + (n4 + n2 * 4)));
                    }
                }
                IsoCell.this.hasSetupSnowGrid = true;
            }
            IsoCell.this.snowGridTiles_Square.resetCounter();
            IsoCell.this.snowGridTiles_Enclosed.resetCounter();
            for (by = 0; by < 4; ++by) {
                IsoCell.this.snowGridTiles_Cove[by].resetCounter();
                IsoCell.this.snowGridTiles_Edge[by].resetCounter();
                IsoCell.this.snowGridTiles_Strip[by].resetCounter();
            }
            this.frac = n;
            Noise2D noise2D = IsoCell.this.snowNoise2D;
            for (n4 = 0; n4 < this.h; ++n4) {
                for (n3 = 0; n3 < this.w; ++n3) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        this.grid[n3][n4][n2] = null;
                        this.gridType[n3][n4][n2] = -1;
                    }
                    if (!(noise2D.layeredNoise((float)n3 / 10.0f, (float)n4 / 10.0f) <= (float)n / 100.0f)) continue;
                    this.grid[n3][n4][0] = IsoCell.this.snowGridTiles_Square.getNext();
                    this.gridType[n3][n4][0] = IsoCell.this.snowGridTiles_Square.ID;
                }
            }
            for (int i = 0; i < this.h; ++i) {
                for (int j = 0; j < this.w; ++j) {
                    Texture texture = this.grid[j][i][0];
                    if (texture != null) continue;
                    n3 = this.check(j, i - 1) ? 1 : 0;
                    n2 = this.check(j, i + 1) ? 1 : 0;
                    boolean bl = this.check(j - 1, i);
                    boolean bl2 = this.check(j + 1, i);
                    n4 = 0;
                    if (n3 != 0) {
                        ++n4;
                    }
                    if (n2 != 0) {
                        ++n4;
                    }
                    if (bl2) {
                        ++n4;
                    }
                    if (bl) {
                        ++n4;
                    }
                    if (n4 == 0) continue;
                    if (n4 == 1) {
                        if (n3 != 0) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Strip[0]);
                            continue;
                        }
                        if (n2 != 0) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Strip[1]);
                            continue;
                        }
                        if (bl2) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Strip[3]);
                            continue;
                        }
                        if (!bl) continue;
                        this.set(j, i, 0, IsoCell.this.snowGridTiles_Strip[2]);
                        continue;
                    }
                    if (n4 == 2) {
                        if (n3 != 0 && n2 != 0) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Strip[0]);
                            this.set(j, i, 1, IsoCell.this.snowGridTiles_Strip[1]);
                            continue;
                        }
                        if (bl2 && bl) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Strip[2]);
                            this.set(j, i, 1, IsoCell.this.snowGridTiles_Strip[3]);
                            continue;
                        }
                        if (n3 != 0) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Edge[bl ? 0 : 3]);
                            continue;
                        }
                        if (n2 != 0) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Edge[bl ? 2 : 1]);
                            continue;
                        }
                        if (bl) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Edge[n3 != 0 ? 0 : 2]);
                            continue;
                        }
                        if (!bl2) continue;
                        this.set(j, i, 0, IsoCell.this.snowGridTiles_Edge[n3 != 0 ? 3 : 1]);
                        continue;
                    }
                    if (n4 == 3) {
                        if (n3 == 0) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Cove[1]);
                            continue;
                        }
                        if (n2 == 0) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Cove[0]);
                            continue;
                        }
                        if (!bl2) {
                            this.set(j, i, 0, IsoCell.this.snowGridTiles_Cove[2]);
                            continue;
                        }
                        if (bl) continue;
                        this.set(j, i, 0, IsoCell.this.snowGridTiles_Cove[3]);
                        continue;
                    }
                    if (n4 != 4) continue;
                    this.set(j, i, 0, IsoCell.this.snowGridTiles_Enclosed);
                }
            }
            return this;
        }

        public boolean check(int n, int n2) {
            if (n == this.w) {
                n = 0;
            }
            if (n == -1) {
                n = this.w - 1;
            }
            if (n2 == this.h) {
                n2 = 0;
            }
            if (n2 == -1) {
                n2 = this.h - 1;
            }
            if (n < 0 || n >= this.w) {
                return false;
            }
            if (n2 < 0 || n2 >= this.h) {
                return false;
            }
            Texture texture = this.grid[n][n2][0];
            return IsoCell.this.snowGridTiles_Square.contains(texture);
        }

        public boolean checkAny(int n, int n2) {
            if (n == this.w) {
                n = 0;
            }
            if (n == -1) {
                n = this.w - 1;
            }
            if (n2 == this.h) {
                n2 = 0;
            }
            if (n2 == -1) {
                n2 = this.h - 1;
            }
            if (n < 0 || n >= this.w) {
                return false;
            }
            if (n2 < 0 || n2 >= this.h) {
                return false;
            }
            return this.grid[n][n2][0] != null;
        }

        public void set(int n, int n2, int n3, SnowGridTiles snowGridTiles) {
            if (n == this.w) {
                n = 0;
            }
            if (n == -1) {
                n = this.w - 1;
            }
            if (n2 == this.h) {
                n2 = 0;
            }
            if (n2 == -1) {
                n2 = this.h - 1;
            }
            if (n < 0 || n >= this.w) {
                return;
            }
            if (n2 < 0 || n2 >= this.h) {
                return;
            }
            this.grid[n][n2][n3] = snowGridTiles.getNext();
            this.gridType[n][n2][n3] = snowGridTiles.ID;
        }

        public void subtract(SnowGrid snowGrid) {
            for (int i = 0; i < this.h; ++i) {
                for (int j = 0; j < this.w; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        if (snowGrid.gridType[j][i][k] != this.gridType[j][i][k]) continue;
                        this.grid[j][i][k] = null;
                        this.gridType[j][i][k] = -1;
                    }
                }
            }
        }
    }

    protected class SnowGridTiles {
        protected byte ID = (byte)-1;
        private int counter = -1;
        private final ArrayList<Texture> textures = new ArrayList();

        public SnowGridTiles(byte by) {
            this.ID = by;
        }

        protected void add(Texture texture) {
            this.textures.add(texture);
        }

        protected Texture getNext() {
            ++this.counter;
            if (this.counter >= this.textures.size()) {
                this.counter = 0;
            }
            return this.textures.get(this.counter);
        }

        protected Texture get(int n) {
            return this.textures.get(n);
        }

        protected int size() {
            return this.textures.size();
        }

        protected Texture getRand() {
            return this.textures.get(Rand.Next(4));
        }

        protected boolean contains(Texture texture) {
            return this.textures.contains(texture);
        }

        protected void resetCounter() {
            this.counter = 0;
        }
    }

    public static enum BuildingSearchCriteria {
        Food,
        Defense,
        Wood,
        Weapons,
        General;

    }
}

