/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import fmod.fmod.FMODManager;
import fmod.fmod.FMOD_STUDIO_EVENT_DESCRIPTION;
import fmod.javafmod;
import java.util.ArrayList;
import zombie.GameSounds;
import zombie.GameTime;
import zombie.SoundManager;
import zombie.WorldSoundManager;
import zombie.audio.GameSound;
import zombie.audio.GameSoundClip;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.debug.DebugLog;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoUtils;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.Vector2;
import zombie.network.GameClient;
import zombie.network.GameServer;

public class Helicopter {
    private static float MAX_BOTHER_SECONDS = 60.0f;
    private static float MAX_UNSEEN_SECONDS = 15.0f;
    private static int RADIUS_HOVER = 50;
    private static int RADIUS_SEARCH = 100;
    protected State state;
    public IsoGameCharacter target;
    protected float timeSinceChopperSawPlayer;
    protected float hoverTime;
    protected float searchTime;
    public float x;
    public float y;
    protected float targetX;
    protected float targetY;
    protected Vector2 move = new Vector2();
    protected boolean bActive;
    protected static long inst;
    protected static FMOD_STUDIO_EVENT_DESCRIPTION event;
    protected boolean bSoundStarted;
    protected float volume;
    protected float occlusion;

    public void pickRandomTarget() {
        ArrayList<IsoPlayer> arrayList;
        if (GameServer.bServer) {
            arrayList = GameServer.getPlayers();
        } else {
            if (GameClient.bClient) {
                throw new IllegalStateException("can't call this on the client");
            }
            arrayList = new ArrayList();
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || !isoPlayer.isAlive()) continue;
                arrayList.add(isoPlayer);
            }
        }
        if (arrayList.isEmpty()) {
            this.bActive = false;
            this.target = null;
            return;
        }
        this.setTarget(arrayList.get(Rand.Next(arrayList.size())));
    }

    public void setTarget(IsoGameCharacter isoGameCharacter) {
        this.target = isoGameCharacter;
        this.x = this.target.x + 1000.0f;
        this.y = this.target.y + 1000.0f;
        this.targetX = this.target.x;
        this.targetY = this.target.y;
        this.move.x = this.targetX - this.x;
        this.move.y = this.targetY - this.y;
        this.move.normalize();
        this.move.setLength(0.5f);
        this.state = State.Arriving;
        this.bActive = true;
        DebugLog.log("chopper: activated");
    }

    protected void changeState(State state) {
        DebugLog.log("chopper: state " + this.state + " -> " + state);
        this.state = state;
    }

    /*
     * Unable to fully structure code
     */
    public void update() {
        if (!this.bActive) {
            return;
        }
        if (GameClient.bClient) {
            this.updateSound();
            return;
        }
        var1_1 = 1.0f;
        if (GameServer.bServer) {
            if (!GameServer.Players.contains(this.target)) {
                this.target = null;
            }
        } else {
            var1_1 = GameTime.getInstance().getTrueMultiplier();
        }
        switch (1.$SwitchMap$zombie$iso$Helicopter$State[this.state.ordinal()]) {
            case 1: {
                if (this.target == null || this.target.isDead()) {
                    this.changeState(State.Leaving);
                    break;
                }
                if (IsoUtils.DistanceToSquared(this.x, this.y, this.targetX, this.targetY) < 4.0f) {
                    this.changeState(State.Hovering);
                    this.hoverTime = 0.0f;
                    this.searchTime = 0.0f;
                    this.timeSinceChopperSawPlayer = 0.0f;
                    break;
                }
                this.targetX = this.target.x;
                this.targetY = this.target.y;
                this.move.x = this.targetX - this.x;
                this.move.y = this.targetY - this.y;
                this.move.normalize();
                this.move.setLength(0.75f);
                break;
            }
            case 2: {
                if (this.target == null || this.target.isDead()) {
                    this.changeState(State.Leaving);
                    break;
                }
                this.hoverTime += GameTime.getInstance().getRealworldSecondsSinceLastUpdate() * var1_1;
                if (this.hoverTime + this.searchTime > Helicopter.MAX_BOTHER_SECONDS) {
                    this.changeState(State.Leaving);
                    break;
                }
                if (!this.isTargetVisible()) {
                    this.timeSinceChopperSawPlayer += GameTime.getInstance().getRealworldSecondsSinceLastUpdate() * var1_1;
                    if (this.timeSinceChopperSawPlayer > Helicopter.MAX_UNSEEN_SECONDS) {
                        this.changeState(State.Searching);
                        break;
                    }
                }
                if (!(IsoUtils.DistanceToSquared(this.x, this.y, this.targetX, this.targetY) < 1.0f)) break;
                this.targetX = this.target.x + (float)(Rand.Next(Helicopter.RADIUS_HOVER * 2) - Helicopter.RADIUS_HOVER);
                this.targetY = this.target.y + (float)(Rand.Next(Helicopter.RADIUS_HOVER * 2) - Helicopter.RADIUS_HOVER);
                this.move.x = this.targetX - this.x;
                this.move.y = this.targetY - this.y;
                this.move.normalize();
                this.move.setLength(0.5f);
                break;
            }
            case 3: {
                if (this.target == null || this.target.isDead()) {
                    this.state = State.Leaving;
                    break;
                }
                this.searchTime += GameTime.getInstance().getRealworldSecondsSinceLastUpdate() * var1_1;
                if (this.hoverTime + this.searchTime > Helicopter.MAX_BOTHER_SECONDS) {
                    this.changeState(State.Leaving);
                    break;
                }
                if (this.isTargetVisible()) {
                    this.timeSinceChopperSawPlayer = 0.0f;
                    this.changeState(State.Hovering);
                    break;
                }
                if (!(IsoUtils.DistanceToSquared(this.x, this.y, this.targetX, this.targetY) < 1.0f)) break;
                this.targetX = this.target.x + (float)(Rand.Next(Helicopter.RADIUS_SEARCH * 2) - Helicopter.RADIUS_SEARCH);
                this.targetY = this.target.y + (float)(Rand.Next(Helicopter.RADIUS_SEARCH * 2) - Helicopter.RADIUS_SEARCH);
                this.move.x = this.targetX - this.x;
                this.move.y = this.targetY - this.y;
                this.move.normalize();
                this.move.setLength(0.5f);
                break;
            }
            case 4: {
                var2_2 = false;
                if (!GameServer.bServer) ** GOTO lbl87
                var3_4 = GameServer.getPlayers();
                for (var4_7 = 0; var4_7 < var3_4.size(); ++var4_7) {
                    var5_9 = var3_4.get(var4_7);
                    if (!(IsoUtils.DistanceToSquared(this.x, this.y, var5_9.getX(), var5_9.getY()) < 1000000.0f)) continue;
                    var2_2 = true;
                    ** GOTO lbl92
                }
                ** GOTO lbl92
lbl87:
                // 2 sources

                for (var3_5 = 0; var3_5 < IsoPlayer.numPlayers; ++var3_5) {
                    var4_8 = IsoPlayer.players[var3_5];
                    if (var4_8 == null || !(IsoUtils.DistanceToSquared(this.x, this.y, var4_8.getX(), var4_8.getY()) < 1000000.0f)) continue;
                    var2_2 = true;
                    break;
                }
lbl92:
                // 4 sources

                if (var2_2) break;
                this.deactivate();
                return;
            }
        }
        if (Rand.Next(Rand.AdjustForFramerate(300)) == 0) {
            WorldSoundManager.instance.addSound(null, (int)this.x, (int)this.y, 0, 500, 500);
        }
        var2_3 = this.move.x * (GameTime.getInstance().getMultiplier() / 1.6f);
        var3_6 = this.move.y * (GameTime.getInstance().getMultiplier() / 1.6f);
        if (this.state != State.Leaving && IsoUtils.DistanceToSquared(this.x + var2_3, this.y + var3_6, this.targetX, this.targetY) > IsoUtils.DistanceToSquared(this.x, this.y, this.targetX, this.targetY)) {
            this.x = this.targetX;
            this.y = this.targetY;
        } else {
            this.x += var2_3;
            this.y += var3_6;
        }
        if (GameServer.bServer) {
            GameServer.sendHelicopter(this.x, this.y, this.bActive);
        }
        this.updateSound();
    }

    protected void updateSound() {
        if (GameServer.bServer) {
            return;
        }
        if (Core.SoundDisabled) {
            return;
        }
        if (FMODManager.instance.getNumListeners() == 0) {
            return;
        }
        GameSound gameSound = GameSounds.getSound("Helicopter");
        if (gameSound == null || gameSound.clips.isEmpty()) {
            return;
        }
        if (inst == 0L) {
            GameSoundClip gameSoundClip = gameSound.getRandomClip();
            event = gameSoundClip.eventDescription;
            if (event != null) {
                javafmod.FMOD_Studio_LoadEventSampleData((long)Helicopter.event.address);
                inst = javafmod.FMOD_Studio_System_CreateEventInstance((long)Helicopter.event.address);
            }
        }
        if (inst != 0L) {
            IsoGridSquare isoGridSquare;
            float f = SoundManager.instance.getSoundVolume();
            if ((f *= gameSound.getUserVolume()) != this.volume) {
                javafmod.FMOD_Studio_EventInstance_SetVolume((long)inst, (float)f);
                this.volume = f;
            }
            javafmod.FMOD_Studio_EventInstance3D((long)inst, (float)this.x, (float)this.y, (float)200.0f);
            float f2 = 0.0f;
            if (IsoPlayer.numPlayers == 1 && (isoGridSquare = IsoPlayer.getInstance().getCurrentSquare()) != null && !isoGridSquare.Is(IsoFlagType.exterior)) {
                f2 = 1.0f;
            }
            if (this.occlusion != f2) {
                this.occlusion = f2;
                javafmod.FMOD_Studio_EventInstance_SetParameterByName((long)inst, (String)"Occlusion", (float)this.occlusion);
            }
            if (!this.bSoundStarted) {
                javafmod.FMOD_Studio_StartEvent((long)inst);
                this.bSoundStarted = true;
            }
        }
    }

    protected boolean isTargetVisible() {
        if (this.target == null || this.target.isDead()) {
            return false;
        }
        IsoGridSquare isoGridSquare = this.target.getCurrentSquare();
        if (isoGridSquare == null) {
            return false;
        }
        if (!isoGridSquare.getProperties().Is(IsoFlagType.exterior)) {
            return false;
        }
        IsoMetaGrid.Zone zone = isoGridSquare.getZone();
        if (zone == null) {
            return true;
        }
        return !"Forest".equals(zone.getType()) && !"DeepForest".equals(zone.getType());
    }

    public void deactivate() {
        if (this.bActive) {
            this.bActive = false;
            if (this.bSoundStarted) {
                javafmod.FMOD_Studio_EventInstance_Stop((long)inst, (boolean)false);
                this.bSoundStarted = false;
            }
            if (GameServer.bServer) {
                GameServer.sendHelicopter(this.x, this.y, this.bActive);
            }
            DebugLog.log("chopper: deactivated");
        }
    }

    public boolean isActive() {
        return this.bActive;
    }

    public void clientSync(float f, float f2, boolean bl) {
        if (!GameClient.bClient) {
            return;
        }
        this.x = f;
        this.y = f2;
        if (!bl) {
            this.deactivate();
        }
        this.bActive = bl;
    }

    private static enum State {
        Arriving,
        Hovering,
        Searching,
        Leaving;

    }
}

