/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import zombie.Lua.LuaEventManager;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.properties.PropertyContainer;
import zombie.debug.DebugLog;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoLot;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoPushableObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.WorldStreamer;
import zombie.iso.areas.IsoRoom;
import zombie.iso.objects.IsoBarbecue;
import zombie.iso.objects.IsoClothingDryer;
import zombie.iso.objects.IsoClothingWasher;
import zombie.iso.objects.IsoCombinationWasherDryer;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoFireplace;
import zombie.iso.objects.IsoJukebox;
import zombie.iso.objects.IsoLightSwitch;
import zombie.iso.objects.IsoMannequin;
import zombie.iso.objects.IsoRadio;
import zombie.iso.objects.IsoStove;
import zombie.iso.objects.IsoTelevision;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoWheelieBin;
import zombie.iso.objects.IsoWindow;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class CellLoader {
    public static final ArrayDeque<IsoObject> isoObjectCache = new ArrayDeque();
    public static final ArrayDeque<IsoTree> isoTreeCache = new ArrayDeque();
    static int wanderX = 0;
    static int wanderY = 0;
    static IsoRoom wanderRoom = null;
    static final HashSet<String> missingTiles = new HashSet();
    public static final HashMap<IsoSprite, IsoSprite> smashedWindowSpriteMap = new HashMap();

    public static void DoTileObjectCreation(IsoSprite isoSprite, IsoObjectType isoObjectType, IsoGridSquare isoGridSquare, IsoCell isoCell, int n, int n2, int n3, String string) throws NumberFormatException {
        Object object;
        IsoObject isoObject = null;
        if (isoGridSquare == null) {
            return;
        }
        boolean bl = false;
        if (smashedWindowSpriteMap.containsKey(isoSprite)) {
            isoSprite = smashedWindowSpriteMap.get(isoSprite);
            isoObjectType = isoSprite.getType();
            bl = true;
        }
        PropertyContainer propertyContainer = isoSprite.getProperties();
        if (isoSprite.solidfloor && propertyContainer.Is(IsoFlagType.diamondFloor) && !propertyContainer.Is(IsoFlagType.transparentFloor) && (object = isoGridSquare.getFloor()) != null && ((IsoObject)object).getProperties().Is(IsoFlagType.diamondFloor)) {
            ((IsoObject)object).clearAttachedAnimSprite();
            ((IsoObject)object).setSprite(isoSprite);
            return;
        }
        if (isoObjectType == IsoObjectType.doorW || isoObjectType == IsoObjectType.doorN) {
            object = new IsoDoor(isoCell, isoGridSquare, isoSprite, isoObjectType == IsoObjectType.doorN);
            isoObject = object;
            CellLoader.AddSpecialObject(isoGridSquare, isoObject);
            if (isoSprite.getProperties().Is("DoubleDoor")) {
                ((IsoDoor)object).Locked = false;
                ((IsoDoor)object).lockedByKey = false;
            }
            if (isoSprite.getProperties().Is("GarageDoor")) {
                ((IsoDoor)object).Locked = !((IsoDoor)object).IsOpen();
                ((IsoDoor)object).lockedByKey = false;
            }
            GameClient.instance.objectSyncReq.putRequest(isoGridSquare, isoObject);
        } else if (isoObjectType == IsoObjectType.lightswitch) {
            isoObject = new IsoLightSwitch(isoCell, isoGridSquare, isoSprite, isoGridSquare.getRoomID());
            CellLoader.AddObject(isoGridSquare, isoObject);
            GameClient.instance.objectSyncReq.putRequest(isoGridSquare, isoObject);
            if (isoObject.sprite.getProperties().Is("lightR")) {
                float f = Float.parseFloat(isoObject.sprite.getProperties().Val("lightR")) / 255.0f;
                float f2 = Float.parseFloat(isoObject.sprite.getProperties().Val("lightG")) / 255.0f;
                float f3 = Float.parseFloat(isoObject.sprite.getProperties().Val("lightB")) / 255.0f;
                int n4 = 10;
                if (isoObject.sprite.getProperties().Is("LightRadius") && Integer.parseInt(isoObject.sprite.getProperties().Val("LightRadius")) > 0) {
                    n4 = Integer.parseInt(isoObject.sprite.getProperties().Val("LightRadius"));
                }
                IsoLightSource isoLightSource = new IsoLightSource(isoObject.square.getX(), isoObject.square.getY(), isoObject.square.getZ(), f, f2, f3, n4);
                isoLightSource.bActive = true;
                isoLightSource.bHydroPowered = true;
                isoLightSource.switches.add((IsoLightSwitch)isoObject);
                ((IsoLightSwitch)isoObject).lights.add(isoLightSource);
            } else {
                ((IsoLightSwitch)isoObject).lightRoom = true;
            }
        } else if (isoObjectType == IsoObjectType.curtainN || isoObjectType == IsoObjectType.curtainS || isoObjectType == IsoObjectType.curtainE || isoObjectType == IsoObjectType.curtainW) {
            boolean bl2 = Integer.parseInt(string.substring(string.lastIndexOf("_") + 1)) % 8 <= 3;
            isoObject = new IsoCurtain(isoCell, isoGridSquare, isoSprite, isoObjectType == IsoObjectType.curtainN || isoObjectType == IsoObjectType.curtainS, bl2);
            CellLoader.AddSpecialObject(isoGridSquare, isoObject);
            GameClient.instance.objectSyncReq.putRequest(isoGridSquare, isoObject);
        } else if (isoSprite.getProperties().Is(IsoFlagType.windowW) || isoSprite.getProperties().Is(IsoFlagType.windowN)) {
            isoObject = new IsoWindow(isoCell, isoGridSquare, isoSprite, isoSprite.getProperties().Is(IsoFlagType.windowN));
            if (bl) {
                ((IsoWindow)isoObject).setSmashed(true);
            }
            CellLoader.AddSpecialObject(isoGridSquare, isoObject);
            GameClient.instance.objectSyncReq.putRequest(isoGridSquare, isoObject);
        } else if (isoSprite.getProperties().Is(IsoFlagType.container) && isoSprite.getProperties().Val("container").equals("barbecue")) {
            isoObject = new IsoBarbecue(isoCell, isoGridSquare, isoSprite);
            CellLoader.AddObject(isoGridSquare, isoObject);
        } else if (isoSprite.getProperties().Is(IsoFlagType.container) && isoSprite.getProperties().Val("container").equals("fireplace")) {
            isoObject = new IsoFireplace(isoCell, isoGridSquare, isoSprite);
            CellLoader.AddObject(isoGridSquare, isoObject);
        } else if ("IsoCombinationWasherDryer".equals(isoSprite.getProperties().Val("IsoType"))) {
            isoObject = new IsoCombinationWasherDryer(isoCell, isoGridSquare, isoSprite);
            CellLoader.AddObject(isoGridSquare, isoObject);
        } else if (isoSprite.getProperties().Is(IsoFlagType.container) && isoSprite.getProperties().Val("container").equals("clothingdryer")) {
            isoObject = new IsoClothingDryer(isoCell, isoGridSquare, isoSprite);
            CellLoader.AddObject(isoGridSquare, isoObject);
        } else if (isoSprite.getProperties().Is(IsoFlagType.container) && isoSprite.getProperties().Val("container").equals("clothingwasher")) {
            isoObject = new IsoClothingWasher(isoCell, isoGridSquare, isoSprite);
            CellLoader.AddObject(isoGridSquare, isoObject);
        } else if (isoSprite.getProperties().Is(IsoFlagType.container) && isoSprite.getProperties().Val("container").equals("woodstove")) {
            isoObject = new IsoFireplace(isoCell, isoGridSquare, isoSprite);
            CellLoader.AddObject(isoGridSquare, isoObject);
        } else if (isoSprite.getProperties().Is(IsoFlagType.container) && (isoSprite.getProperties().Val("container").equals("stove") || isoSprite.getProperties().Val("container").equals("microwave"))) {
            isoObject = new IsoStove(isoCell, isoGridSquare, isoSprite);
            CellLoader.AddObject(isoGridSquare, isoObject);
            GameClient.instance.objectSyncReq.putRequest(isoGridSquare, isoObject);
        } else if (isoObjectType == IsoObjectType.jukebox) {
            isoObject = new IsoJukebox(isoCell, isoGridSquare, isoSprite);
            isoObject.OutlineOnMouseover = true;
            CellLoader.AddObject(isoGridSquare, isoObject);
        } else if (isoObjectType == IsoObjectType.radio) {
            isoObject = new IsoRadio(isoCell, isoGridSquare, isoSprite);
            CellLoader.AddObject(isoGridSquare, isoObject);
        } else if (isoSprite.getProperties().Is("signal")) {
            object = isoSprite.getProperties().Val("signal");
            if ("radio".equals(object)) {
                isoObject = new IsoRadio(isoCell, isoGridSquare, isoSprite);
            } else if ("tv".equals(object)) {
                isoObject = new IsoTelevision(isoCell, isoGridSquare, isoSprite);
            }
            CellLoader.AddObject(isoGridSquare, isoObject);
        } else {
            if (isoSprite.getProperties().Is(IsoFlagType.WallOverlay)) {
                object = null;
                if (isoSprite.getProperties().Is(IsoFlagType.attachedSE)) {
                    object = isoGridSquare.getWallSE();
                } else if (isoSprite.getProperties().Is(IsoFlagType.attachedW)) {
                    object = isoGridSquare.getWall(false);
                } else if (isoSprite.getProperties().Is(IsoFlagType.attachedN)) {
                    object = isoGridSquare.getWall(true);
                } else {
                    for (int i = isoGridSquare.getObjects().size() - 1; i >= 0; --i) {
                        IsoObject isoObject2 = isoGridSquare.getObjects().get(i);
                        if (!isoObject2.sprite.getProperties().Is(IsoFlagType.cutW) && !isoObject2.sprite.getProperties().Is(IsoFlagType.cutN)) continue;
                        object = isoObject2;
                        break;
                    }
                }
                if (object != null) {
                    if (((IsoObject)object).AttachedAnimSprite == null) {
                        ((IsoObject)object).AttachedAnimSprite = new ArrayList(4);
                    }
                    ((IsoObject)object).AttachedAnimSprite.add(IsoSpriteInstance.get(isoSprite));
                } else {
                    isoObject = IsoObject.getNew();
                    isoObject.sx = 0.0f;
                    isoObject.sprite = isoSprite;
                    isoObject.square = isoGridSquare;
                    CellLoader.AddObject(isoGridSquare, isoObject);
                }
                return;
            }
            if (isoSprite.getProperties().Is(IsoFlagType.FloorOverlay)) {
                object = isoGridSquare.getFloor();
                if (object != null) {
                    if (((IsoObject)object).AttachedAnimSprite == null) {
                        ((IsoObject)object).AttachedAnimSprite = new ArrayList(4);
                    }
                    ((IsoObject)object).AttachedAnimSprite.add(IsoSpriteInstance.get(isoSprite));
                }
            } else if (IsoMannequin.isMannequinSprite(isoSprite)) {
                isoObject = new IsoMannequin(isoCell, isoGridSquare, isoSprite);
                CellLoader.AddObject(isoGridSquare, isoObject);
            } else if (isoObjectType == IsoObjectType.tree) {
                if (isoSprite.getName() != null && isoSprite.getName().startsWith("vegetation_trees") && ((object = isoGridSquare.getFloor()) == null || ((IsoObject)object).getSprite() == null || ((IsoObject)object).getSprite().getName() == null || !((IsoObject)object).getSprite().getName().startsWith("blends_natural"))) {
                    DebugLog.log("ERROR: removed tree at " + isoGridSquare.x + "," + isoGridSquare.y + "," + isoGridSquare.z + " because floor is not blends_natural");
                    return;
                }
                isoObject = IsoTree.getNew();
                isoObject.sprite = isoSprite;
                isoObject.square = isoGridSquare;
                isoObject.sx = 0.0f;
                ((IsoTree)isoObject).initTree();
                for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
                    IsoObject isoObject3 = isoGridSquare.getObjects().get(i);
                    if (!(isoObject3 instanceof IsoTree)) continue;
                    isoGridSquare.getObjects().remove(i);
                    isoObject3.reset();
                    isoTreeCache.push((IsoTree)isoObject3);
                    break;
                }
                CellLoader.AddObject(isoGridSquare, isoObject);
            } else {
                if ((isoSprite.CurrentAnim.Frames.isEmpty() || isoSprite.CurrentAnim.Frames.get(0).getTexture(IsoDirections.N) == null) && !GameServer.bServer) {
                    if (!missingTiles.contains(string)) {
                        if (Core.bDebug) {
                            DebugLog.General.error("CellLoader> missing tile " + string);
                        }
                        missingTiles.add(string);
                    }
                    isoSprite.LoadFramesNoDirPageSimple(Core.bDebug ? "media/ui/missing-tile-debug.png" : "media/ui/missing-tile.png");
                    if (isoSprite.CurrentAnim.Frames.isEmpty() || isoSprite.CurrentAnim.Frames.get(0).getTexture(IsoDirections.N) == null) {
                        return;
                    }
                }
                object = GameServer.bServer ? null : isoSprite.CurrentAnim.Frames.get(0).getTexture(IsoDirections.N).getName();
                boolean bl3 = true;
                if (!GameServer.bServer && ((String)object).contains("TileObjectsExt") && (((String)object).contains("_5") || ((String)object).contains("_6") || ((String)object).contains("_7") || ((String)object).contains("_8"))) {
                    isoObject = new IsoWheelieBin(isoCell, n, n2, n3);
                    if (((String)object).contains("_5")) {
                        isoObject.dir = IsoDirections.S;
                    }
                    if (((String)object).contains("_6")) {
                        isoObject.dir = IsoDirections.W;
                    }
                    if (((String)object).contains("_7")) {
                        isoObject.dir = IsoDirections.N;
                    }
                    if (((String)object).contains("_8")) {
                        isoObject.dir = IsoDirections.E;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    isoObject = IsoObject.getNew();
                    isoObject.sx = 0.0f;
                    isoObject.sprite = isoSprite;
                    isoObject.square = isoGridSquare;
                    CellLoader.AddObject(isoGridSquare, isoObject);
                    if (isoObject.sprite.getProperties().Is("lightR")) {
                        float f = Float.parseFloat(isoObject.sprite.getProperties().Val("lightR"));
                        float f4 = Float.parseFloat(isoObject.sprite.getProperties().Val("lightG"));
                        float f5 = Float.parseFloat(isoObject.sprite.getProperties().Val("lightB"));
                        isoCell.getLamppostPositions().add(new IsoLightSource(isoObject.square.getX(), isoObject.square.getY(), isoObject.square.getZ(), f, f4, f5, 8));
                    }
                }
            }
        }
        if (isoObject != null) {
            isoObject.tile = string;
            isoObject.createContainersFromSpriteProperties();
            if (isoObject.sprite.getProperties().Is(IsoFlagType.vegitation)) {
                isoObject.tintr = 0.7f + (float)Rand.Next(30) / 100.0f;
                isoObject.tintg = 0.7f + (float)Rand.Next(30) / 100.0f;
                isoObject.tintb = 0.7f + (float)Rand.Next(30) / 100.0f;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean LoadCellBinaryChunk(IsoCell isoCell, int n, int n2, IsoChunk isoChunk) {
        int n3 = n;
        int n4 = n2;
        String string = "world_" + n3 / 30 + "_" + n4 / 30 + ".lotpack";
        if (!IsoLot.InfoFileNames.containsKey(string)) {
            DebugLog.log("LoadCellBinaryChunk: NO SUCH LOT " + string);
            return false;
        }
        File file = new File(IsoLot.InfoFileNames.get(string));
        if (file.exists()) {
            IsoLot isoLot = null;
            try {
                isoLot = IsoLot.get(n3 / 30, n4 / 30, n, n2, isoChunk);
                isoCell.PlaceLot(isoLot, 0, 0, 0, isoChunk, n, n2);
                if (isoLot == null) return true;
            }
            catch (Throwable throwable) {
                if (isoLot == null) throw throwable;
                IsoLot.put(isoLot);
                throw throwable;
            }
            IsoLot.put(isoLot);
            return true;
        }
        DebugLog.log("LoadCellBinaryChunk: NO SUCH LOT " + string);
        return false;
    }

    public static IsoCell LoadCellBinaryChunk(IsoSpriteManager isoSpriteManager, int n, int n2) throws IOException {
        wanderX = 0;
        wanderY = 0;
        wanderRoom = null;
        wanderX = 0;
        wanderY = 0;
        IsoCell isoCell = new IsoCell(300, 300);
        int n3 = IsoPlayer.numPlayers;
        n3 = 1;
        if (!GameServer.bServer) {
            if (GameClient.bClient) {
                WorldStreamer.instance.requestLargeAreaZip(n, n2, IsoChunkMap.ChunkGridWidth / 2 + 2);
                IsoChunk.bDoServerRequests = false;
            }
            for (int i = 0; i < n3; ++i) {
                isoCell.ChunkMap[i].setInitialPos(n, n2);
                IsoPlayer.assumedPlayer = i;
                IsoChunkMap cfr_ignored_0 = isoCell.ChunkMap[i];
                int n4 = n - IsoChunkMap.ChunkGridWidth / 2;
                IsoChunkMap cfr_ignored_1 = isoCell.ChunkMap[i];
                int n5 = n2 - IsoChunkMap.ChunkGridWidth / 2;
                IsoChunkMap cfr_ignored_2 = isoCell.ChunkMap[i];
                int n6 = n + IsoChunkMap.ChunkGridWidth / 2 + 1;
                IsoChunkMap cfr_ignored_3 = isoCell.ChunkMap[i];
                int n7 = n2 + IsoChunkMap.ChunkGridWidth / 2 + 1;
                for (int j = n4; j < n6; ++j) {
                    for (int k = n5; k < n7; ++k) {
                        if (!IsoWorld.instance.getMetaGrid().isValidChunk(j, k)) continue;
                        isoCell.ChunkMap[i].LoadChunk(j, k, j - n4, k - n5);
                    }
                }
            }
        }
        IsoPlayer.assumedPlayer = 0;
        LuaEventManager.triggerEvent("OnPostMapLoad", isoCell, n, n2);
        CellLoader.ConnectMultitileObjects(isoCell);
        return isoCell;
    }

    private static void RecurseMultitileObjects(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2, ArrayList<IsoPushableObject> arrayList) {
        Object object;
        Iterator<IsoMovingObject> iterator = isoGridSquare2.getMovingObjects().iterator();
        Object object2 = null;
        boolean bl = false;
        while (iterator != null && iterator.hasNext()) {
            int n;
            IsoMovingObject isoMovingObject = iterator.next();
            if (!(isoMovingObject instanceof IsoPushableObject)) continue;
            object = (IsoPushableObject)isoMovingObject;
            int n2 = isoGridSquare.getX() - isoGridSquare2.getX();
            int n3 = isoGridSquare.getY() - isoGridSquare2.getY();
            if (n3 != 0 && isoMovingObject.sprite.getProperties().Is("connectY") && (n = Integer.parseInt(isoMovingObject.sprite.getProperties().Val("connectY"))) == n3) {
                ((IsoPushableObject)object).connectList = arrayList;
                arrayList.add((IsoPushableObject)object);
                object2 = object;
                bl = false;
                break;
            }
            if (n2 == 0 || !isoMovingObject.sprite.getProperties().Is("connectX") || (n = Integer.parseInt(isoMovingObject.sprite.getProperties().Val("connectX"))) != n2) continue;
            ((IsoPushableObject)object).connectList = arrayList;
            arrayList.add((IsoPushableObject)object);
            object2 = object;
            bl = true;
            break;
        }
        if (object2 != null) {
            if (((IsoPushableObject)object2).sprite.getProperties().Is("connectY") && bl) {
                int n = Integer.parseInt(((IsoPushableObject)object2).sprite.getProperties().Val("connectY"));
                object = isoCell.getGridSquare(((IsoMovingObject)object2).getCurrentSquare().getX(), ((IsoMovingObject)object2).getCurrentSquare().getY() + n, ((IsoMovingObject)object2).getCurrentSquare().getZ());
                CellLoader.RecurseMultitileObjects(isoCell, ((IsoMovingObject)object2).getCurrentSquare(), (IsoGridSquare)object, ((IsoPushableObject)object2).connectList);
            }
            if (((IsoPushableObject)object2).sprite.getProperties().Is("connectX") && !bl) {
                int n = Integer.parseInt(((IsoPushableObject)object2).sprite.getProperties().Val("connectX"));
                object = isoCell.getGridSquare(((IsoMovingObject)object2).getCurrentSquare().getX() + n, ((IsoMovingObject)object2).getCurrentSquare().getY(), ((IsoMovingObject)object2).getCurrentSquare().getZ());
                CellLoader.RecurseMultitileObjects(isoCell, ((IsoMovingObject)object2).getCurrentSquare(), (IsoGridSquare)object, ((IsoPushableObject)object2).connectList);
            }
        }
    }

    private static void ConnectMultitileObjects(IsoCell isoCell) {
        Iterator<IsoMovingObject> iterator = isoCell.getObjectList().iterator();
        while (iterator != null && iterator.hasNext()) {
            IsoGridSquare isoGridSquare;
            int n;
            IsoMovingObject isoMovingObject = iterator.next();
            if (!(isoMovingObject instanceof IsoPushableObject)) continue;
            IsoPushableObject isoPushableObject = (IsoPushableObject)isoMovingObject;
            if (!isoMovingObject.sprite.getProperties().Is("connectY") && !isoMovingObject.sprite.getProperties().Is("connectX") || isoPushableObject.connectList != null) continue;
            isoPushableObject.connectList = new ArrayList();
            isoPushableObject.connectList.add(isoPushableObject);
            if (isoMovingObject.sprite.getProperties().Is("connectY")) {
                n = Integer.parseInt(isoMovingObject.sprite.getProperties().Val("connectY"));
                isoGridSquare = isoCell.getGridSquare(isoMovingObject.getCurrentSquare().getX(), isoMovingObject.getCurrentSquare().getY() + n, isoMovingObject.getCurrentSquare().getZ());
                if (isoGridSquare == null) {
                    boolean bl = false;
                }
                CellLoader.RecurseMultitileObjects(isoCell, isoPushableObject.getCurrentSquare(), isoGridSquare, isoPushableObject.connectList);
            }
            if (!isoMovingObject.sprite.getProperties().Is("connectX")) continue;
            n = Integer.parseInt(isoMovingObject.sprite.getProperties().Val("connectX"));
            isoGridSquare = isoCell.getGridSquare(isoMovingObject.getCurrentSquare().getX() + n, isoMovingObject.getCurrentSquare().getY(), isoMovingObject.getCurrentSquare().getZ());
            CellLoader.RecurseMultitileObjects(isoCell, isoPushableObject.getCurrentSquare(), isoGridSquare, isoPushableObject.connectList);
        }
    }

    private static void AddObject(IsoGridSquare isoGridSquare, IsoObject isoObject) {
        int n = isoGridSquare.placeWallAndDoorCheck(isoObject, isoGridSquare.getObjects().size());
        if (n != isoGridSquare.getObjects().size() && n >= 0 && n <= isoGridSquare.getObjects().size()) {
            isoGridSquare.getObjects().add(n, isoObject);
        } else {
            isoGridSquare.getObjects().add(isoObject);
        }
    }

    private static void AddSpecialObject(IsoGridSquare isoGridSquare, IsoObject isoObject) {
        int n = isoGridSquare.placeWallAndDoorCheck(isoObject, isoGridSquare.getObjects().size());
        if (n != isoGridSquare.getObjects().size() && n >= 0 && n <= isoGridSquare.getObjects().size()) {
            isoGridSquare.getObjects().add(n, isoObject);
        } else {
            isoGridSquare.getObjects().add(isoObject);
            isoGridSquare.getSpecialObjects().add(isoObject);
        }
    }
}

