/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.MapCollisionData;
import zombie.SoundManager;
import zombie.core.Rand;
import zombie.core.properties.PropertyContainer;
import zombie.inventory.InventoryItemFactory;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameServer;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.PolygonalMap2;

public class BrokenFences {
    private static final BrokenFences instance = new BrokenFences();
    private final THashMap<String, Tile> s_unbrokenMap = new THashMap();
    private final THashMap<String, Tile> s_brokenLeftMap = new THashMap();
    private final THashMap<String, Tile> s_brokenRightMap = new THashMap();
    private final THashMap<String, Tile> s_allMap = new THashMap();

    public static BrokenFences getInstance() {
        return instance;
    }

    private ArrayList<String> tableToTiles(KahluaTableImpl kahluaTableImpl) {
        if (kahluaTableImpl == null) {
            return null;
        }
        ArrayList<String> arrayList = null;
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(kahluaTableIterator.getValue().toString());
        }
        return arrayList;
    }

    private ArrayList<String> tableToTiles(KahluaTable kahluaTable, String string) {
        return this.tableToTiles((KahluaTableImpl)kahluaTable.rawget((Object)string));
    }

    public void addBrokenTiles(KahluaTableImpl kahluaTableImpl) {
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            String string2 = kahluaTableIterator.getKey().toString();
            if ("VERSION".equalsIgnoreCase(string2)) continue;
            KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)kahluaTableIterator.getValue();
            Tile tile = new Tile();
            tile.self = this.tableToTiles((KahluaTable)kahluaTableImpl2, "self");
            tile.left = this.tableToTiles((KahluaTable)kahluaTableImpl2, "left");
            tile.right = this.tableToTiles((KahluaTable)kahluaTableImpl2, "right");
            this.s_unbrokenMap.put((Object)string2, (Object)tile);
            PZArrayUtil.forEach(tile.left, string -> this.s_brokenLeftMap.put(string, (Object)tile));
            PZArrayUtil.forEach(tile.right, string -> this.s_brokenRightMap.put(string, (Object)tile));
        }
        this.s_allMap.putAll(this.s_unbrokenMap);
        this.s_allMap.putAll(this.s_brokenLeftMap);
        this.s_allMap.putAll(this.s_brokenRightMap);
    }

    public void addDebrisTiles(KahluaTableImpl kahluaTableImpl) {
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            String string = kahluaTableIterator.getKey().toString();
            if ("VERSION".equalsIgnoreCase(string)) continue;
            KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)kahluaTableIterator.getValue();
            Tile tile = (Tile)this.s_unbrokenMap.get((Object)string);
            if (tile == null) {
                throw new IllegalArgumentException("addDebrisTiles() with unknown tile");
            }
            tile.debrisN = this.tableToTiles((KahluaTable)kahluaTableImpl2, "north");
            tile.debrisS = this.tableToTiles((KahluaTable)kahluaTableImpl2, "south");
            tile.debrisW = this.tableToTiles((KahluaTable)kahluaTableImpl2, "west");
            tile.debrisE = this.tableToTiles((KahluaTable)kahluaTableImpl2, "east");
        }
    }

    public void setDestroyed(IsoObject isoObject) {
        isoObject.RemoveAttachedAnims();
        isoObject.getSquare().removeBlood(false, true);
        this.updateSprite(isoObject, true, true);
    }

    public void setDamagedLeft(IsoObject isoObject) {
        this.updateSprite(isoObject, true, false);
    }

    public void setDamagedRight(IsoObject isoObject) {
        this.updateSprite(isoObject, false, true);
    }

    public void updateSprite(IsoObject isoObject, boolean bl, boolean bl2) {
        if (!this.isBreakableObject(isoObject)) {
            return;
        }
        Tile tile = (Tile)this.s_allMap.get((Object)isoObject.sprite.name);
        String string = null;
        if (bl && bl2) {
            string = tile.pickRandom(tile.self);
        } else if (bl) {
            string = tile.pickRandom(tile.left);
        } else if (bl2) {
            string = tile.pickRandom(tile.right);
        }
        if (string != null) {
            IsoSprite isoSprite = IsoSpriteManager.instance.getSprite(string);
            isoSprite.name = string;
            isoObject.setSprite(isoSprite);
            isoObject.transmitUpdatedSprite();
            isoObject.getSquare().RecalcAllWithNeighbours(true);
            MapCollisionData.instance.squareChanged(isoObject.getSquare());
            PolygonalMap2.instance.squareChanged(isoObject.getSquare());
            IsoRegions.squareChanged(isoObject.getSquare());
        }
    }

    private boolean isNW(IsoObject isoObject) {
        PropertyContainer propertyContainer = isoObject.getProperties();
        return propertyContainer.Is(IsoFlagType.collideN) && propertyContainer.Is(IsoFlagType.collideW);
    }

    private void damageAdjacent(IsoGridSquare isoGridSquare, IsoDirections isoDirections, IsoDirections isoDirections2) {
        boolean bl;
        IsoGridSquare isoGridSquare2 = isoGridSquare.getAdjacentSquare(isoDirections);
        if (isoGridSquare2 == null) {
            return;
        }
        boolean bl2 = isoDirections == IsoDirections.W || isoDirections == IsoDirections.E;
        IsoObject isoObject = this.getBreakableObject(isoGridSquare2, bl2);
        if (isoObject == null) {
            return;
        }
        boolean bl3 = isoDirections == IsoDirections.N || isoDirections == IsoDirections.E;
        boolean bl4 = bl = isoDirections == IsoDirections.S || isoDirections == IsoDirections.W;
        if (this.isNW(isoObject) && (isoDirections == IsoDirections.S || isoDirections == IsoDirections.E)) {
            return;
        }
        if (bl3 && this.isBrokenRight(isoObject)) {
            this.destroyFence(isoObject, isoDirections2);
            return;
        }
        if (bl && this.isBrokenLeft(isoObject)) {
            this.destroyFence(isoObject, isoDirections2);
            return;
        }
        this.updateSprite(isoObject, bl3, bl);
    }

    public void destroyFence(IsoObject isoObject, IsoDirections isoDirections) {
        if (!this.isBreakableObject(isoObject)) {
            return;
        }
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (GameServer.bServer) {
            GameServer.PlayWorldSoundServer("BreakObject", false, isoGridSquare, 1.0f, 20.0f, 1.0f, true);
        } else {
            SoundManager.instance.PlayWorldSound("BreakObject", isoGridSquare, 1.0f, 20.0f, 1.0f, true);
        }
        boolean bl = isoObject.getProperties().Is(IsoFlagType.collideN);
        boolean bl2 = isoObject.getProperties().Is(IsoFlagType.collideW);
        if (isoObject instanceof IsoThumpable) {
            IsoObject isoObject2 = IsoObject.getNew();
            isoObject2.setSquare(isoGridSquare);
            isoObject2.setSprite(isoObject.getSprite());
            int n = isoObject.getObjectIndex();
            isoGridSquare.transmitRemoveItemFromSquare(isoObject);
            isoGridSquare.transmitAddObjectToSquare(isoObject2, n);
            isoObject = isoObject2;
        }
        this.addDebrisObject(isoObject, isoDirections);
        this.setDestroyed(isoObject);
        if (bl && bl2) {
            this.damageAdjacent(isoGridSquare, IsoDirections.S, isoDirections);
            this.damageAdjacent(isoGridSquare, IsoDirections.E, isoDirections);
        } else if (bl) {
            this.damageAdjacent(isoGridSquare, IsoDirections.W, isoDirections);
            this.damageAdjacent(isoGridSquare, IsoDirections.E, isoDirections);
        } else if (bl2) {
            this.damageAdjacent(isoGridSquare, IsoDirections.N, isoDirections);
            this.damageAdjacent(isoGridSquare, IsoDirections.S, isoDirections);
        }
        isoGridSquare.RecalcAllWithNeighbours(true);
        MapCollisionData.instance.squareChanged(isoGridSquare);
        PolygonalMap2.instance.squareChanged(isoGridSquare);
        IsoRegions.squareChanged(isoGridSquare);
    }

    private boolean isUnbroken(IsoObject isoObject) {
        if (isoObject == null || isoObject.sprite == null || isoObject.sprite.name == null) {
            return false;
        }
        return this.s_unbrokenMap.contains((Object)isoObject.sprite.name);
    }

    private boolean isBrokenLeft(IsoObject isoObject) {
        if (isoObject == null || isoObject.sprite == null || isoObject.sprite.name == null) {
            return false;
        }
        return this.s_brokenLeftMap.contains((Object)isoObject.sprite.name);
    }

    private boolean isBrokenRight(IsoObject isoObject) {
        if (isoObject == null || isoObject.sprite == null || isoObject.sprite.name == null) {
            return false;
        }
        return this.s_brokenRightMap.contains((Object)isoObject.sprite.name);
    }

    public boolean isBreakableObject(IsoObject isoObject) {
        if (isoObject == null || isoObject.sprite == null || isoObject.sprite.name == null) {
            return false;
        }
        return this.s_allMap.containsKey((Object)isoObject.sprite.name);
    }

    private IsoObject getBreakableObject(IsoGridSquare isoGridSquare, boolean bl) {
        for (int i = 0; i < isoGridSquare.Objects.size(); ++i) {
            IsoObject isoObject = isoGridSquare.Objects.get(i);
            if (!this.isBreakableObject(isoObject) || (!bl || !isoObject.getProperties().Is(IsoFlagType.collideN)) && (bl || !isoObject.getProperties().Is(IsoFlagType.collideW))) continue;
            return isoObject;
        }
        return null;
    }

    private void addItems(IsoObject isoObject, IsoGridSquare isoGridSquare) {
        PropertyContainer propertyContainer = isoObject.getProperties();
        if (propertyContainer == null) {
            return;
        }
        String string = propertyContainer.Val("Material");
        String string2 = propertyContainer.Val("Material2");
        String string3 = propertyContainer.Val("Material3");
        if ("Wood".equals(string) || "Wood".equals(string2) || "Wood".equals(string3)) {
            isoGridSquare.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.Plank"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
            if (Rand.NextBool(5)) {
                isoGridSquare.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.Plank"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
            }
        }
        if (("MetalBars".equals(string) || "MetalBars".equals(string2) || "MetalBars".equals(string3)) && Rand.NextBool(2)) {
            isoGridSquare.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.MetalBar"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
        if (("MetalWire".equals(string) || "MetalWire".equals(string2) || "MetalWire".equals(string3)) && Rand.NextBool(3)) {
            isoGridSquare.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.Wire"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
        if (("Nails".equals(string) || "Nails".equals(string2) || "Nails".equals(string3)) && Rand.NextBool(2)) {
            isoGridSquare.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.Nails"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
        if (("Screws".equals(string) || "Screws".equals(string2) || "Screws".equals(string3)) && Rand.NextBool(2)) {
            isoGridSquare.AddWorldInventoryItem(InventoryItemFactory.CreateItem("Base.Screws"), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
    }

    private void addDebrisObject(IsoObject isoObject, IsoDirections isoDirections) {
        String string;
        if (!this.isBreakableObject(isoObject)) {
            return;
        }
        Tile tile = (Tile)this.s_allMap.get((Object)isoObject.sprite.name);
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        switch (isoDirections) {
            case N: {
                string = tile.pickRandom(tile.debrisN);
                isoGridSquare = isoGridSquare.getAdjacentSquare(isoDirections);
                break;
            }
            case S: {
                string = tile.pickRandom(tile.debrisS);
                break;
            }
            case W: {
                string = tile.pickRandom(tile.debrisW);
                isoGridSquare = isoGridSquare.getAdjacentSquare(isoDirections);
                break;
            }
            case E: {
                string = tile.pickRandom(tile.debrisE);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction");
            }
        }
        if (string != null && isoGridSquare != null && isoGridSquare.TreatAsSolidFloor()) {
            IsoObject isoObject2 = IsoObject.getNew(isoGridSquare, string, null, false);
            isoGridSquare.transmitAddObjectToSquare(isoObject2, isoGridSquare == isoObject.getSquare() ? isoObject.getObjectIndex() : -1);
            this.addItems(isoObject, isoGridSquare);
        }
    }

    public void Reset() {
        this.s_unbrokenMap.clear();
        this.s_brokenLeftMap.clear();
        this.s_brokenRightMap.clear();
        this.s_allMap.clear();
    }

    private static final class Tile {
        ArrayList<String> self = null;
        ArrayList<String> left = null;
        ArrayList<String> right = null;
        ArrayList<String> debrisN = null;
        ArrayList<String> debrisS = null;
        ArrayList<String> debrisW = null;
        ArrayList<String> debrisE = null;

        private Tile() {
        }

        String pickRandom(ArrayList<String> arrayList) {
            if (arrayList == null) {
                return null;
            }
            return PZArrayUtil.pickRandom(arrayList);
        }
    }
}

