/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import fmod.fmod.FMODManager;
import fmod.fmod.FMOD_STUDIO_EVENT_DESCRIPTION;
import fmod.fmod.FMOD_STUDIO_PLAYBACK_STATE;
import fmod.javafmod;
import zombie.GameSounds;
import zombie.GameTime;
import zombie.SoundManager;
import zombie.WorldSoundManager;
import zombie.audio.GameSound;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.network.GameClient;
import zombie.network.GameServer;

public class Alarm {
    protected static long inst;
    protected static FMOD_STUDIO_EVENT_DESCRIPTION event;
    public boolean finished = false;
    private int x;
    private int y;
    private float volume;
    private float occlusion;
    private float endGameTime;

    public Alarm(int n, int n2) {
        this.x = n;
        this.y = n2;
        int n3 = 49;
        float f = (float)GameTime.instance.getWorldAgeHours();
        this.endGameTime = f + (float)n3 / 3600.0f * (1440.0f / GameTime.instance.getMinutesPerDay());
    }

    public void update() {
        if (!GameClient.bClient) {
            WorldSoundManager.instance.addSound(this, this.x, this.y, 0, 600, 600);
        }
        if (!GameServer.bServer) {
            this.updateSound();
            if (GameTime.getInstance().getWorldAgeHours() >= (double)this.endGameTime) {
                if (inst != 0L) {
                    javafmod.FMOD_Studio_EventInstance_Stop((long)inst, (boolean)false);
                    inst = 0L;
                }
                this.finished = true;
            }
        }
    }

    protected void updateSound() {
        if (GameServer.bServer || Core.SoundDisabled || this.finished) {
            return;
        }
        if (FMODManager.instance.getNumListeners() == 0) {
            return;
        }
        if (inst == 0L && (event = FMODManager.instance.getEventDescription("event:/Meta/HouseAlarm")) != null) {
            javafmod.FMOD_Studio_LoadEventSampleData((long)Alarm.event.address);
            inst = javafmod.FMOD_Studio_System_CreateEventInstance((long)Alarm.event.address);
        }
        if (inst > 0L) {
            IsoGridSquare isoGridSquare;
            float f = SoundManager.instance.getSoundVolume();
            GameSound gameSound = GameSounds.getSound("HouseAlarm");
            if (gameSound != null) {
                f *= gameSound.getUserVolume();
            }
            if (f != this.volume) {
                javafmod.FMOD_Studio_EventInstance_SetVolume((long)inst, (float)f);
                this.volume = f;
            }
            javafmod.FMOD_Studio_EventInstance3D((long)inst, (float)this.x, (float)this.y, (float)0.0f);
            if (javafmod.FMOD_Studio_GetPlaybackState((long)inst) != FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_PLAYING.index && javafmod.FMOD_Studio_GetPlaybackState((long)inst) != FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STARTING.index) {
                if (javafmod.FMOD_Studio_GetPlaybackState((long)inst) == FMOD_STUDIO_PLAYBACK_STATE.FMOD_STUDIO_PLAYBACK_STOPPING.index) {
                    this.finished = true;
                    return;
                }
                javafmod.FMOD_Studio_StartEvent((long)inst);
                System.out.println(javafmod.FMOD_Studio_GetPlaybackState((long)inst));
            }
            float f2 = 0.0f;
            if (IsoPlayer.numPlayers == 1 && (isoGridSquare = IsoPlayer.getInstance().getCurrentSquare()) != null && !isoGridSquare.Is(IsoFlagType.exterior)) {
                f2 = 0.2f;
                IsoGridSquare isoGridSquare2 = IsoWorld.instance.getCell().getGridSquare(this.x, this.y, 0);
                if (isoGridSquare2 != null && isoGridSquare2.getBuilding() == isoGridSquare.getBuilding()) {
                    f2 = 0.0f;
                }
            }
            if (this.occlusion != f2) {
                this.occlusion = f2;
                javafmod.FMOD_Studio_EventInstance_SetParameterByName((long)inst, (String)"Occlusion", (float)this.occlusion);
            }
        }
    }
}

