/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.util.Arrays;
import java.util.List;
import zombie.characters.IsoGameCharacter;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.HandWeapon;

public enum WeaponType {
    barehand("", Arrays.asList(""), true, false),
    twohanded("2handed", Arrays.asList("default", "default", "overhead", "uppercut"), true, false),
    onehanded("1handed", Arrays.asList("default", "default", "overhead", "uppercut"), true, false),
    heavy("heavy", Arrays.asList("default", "default", "overhead"), true, false),
    knife("knife", Arrays.asList("default", "default", "overhead", "uppercut"), true, false),
    spear("spear", Arrays.asList("default"), true, false),
    handgun("handgun", Arrays.asList(""), false, true),
    firearm("firearm", Arrays.asList(""), false, true),
    throwing("throwing", Arrays.asList(""), false, true),
    chainsaw("chainsaw", Arrays.asList("default"), true, false);

    public String type = "";
    public List<String> possibleAttack;
    public boolean canMiss = true;
    public boolean isRanged = false;

    private WeaponType(String string2, List<String> list, boolean bl, boolean bl2) {
        this.type = string2;
        this.possibleAttack = list;
        this.canMiss = bl;
        this.isRanged = bl2;
    }

    public static WeaponType getWeaponType(HandWeapon handWeapon) {
        WeaponType weaponType = null;
        if (handWeapon.getSwingAnim().equalsIgnoreCase("Stab")) {
            return knife;
        }
        if (handWeapon.getSwingAnim().equalsIgnoreCase("Heavy")) {
            return heavy;
        }
        if (handWeapon.getSwingAnim().equalsIgnoreCase("Throw")) {
            return throwing;
        }
        if (!handWeapon.isRanged()) {
            weaponType = onehanded;
            if (handWeapon.isTwoHandWeapon()) {
                weaponType = twohanded;
                if (handWeapon.getSwingAnim().equalsIgnoreCase("Spear")) {
                    return spear;
                }
                if ("Chainsaw".equals(handWeapon.getType())) {
                    return chainsaw;
                }
            }
        } else {
            weaponType = handgun;
            if (handWeapon.isTwoHandWeapon()) {
                weaponType = firearm;
            }
        }
        if (weaponType == null) {
            weaponType = barehand;
        }
        return weaponType;
    }

    public static WeaponType getWeaponType(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null) {
            return null;
        }
        WeaponType weaponType = null;
        isoGameCharacter.setVariable("rangedWeapon", false);
        InventoryItem inventoryItem = isoGameCharacter.getPrimaryHandItem();
        InventoryItem inventoryItem2 = isoGameCharacter.getSecondaryHandItem();
        if (inventoryItem != null && inventoryItem instanceof HandWeapon) {
            if (inventoryItem.getSwingAnim().equalsIgnoreCase("Stab")) {
                return knife;
            }
            if (inventoryItem.getSwingAnim().equalsIgnoreCase("Heavy")) {
                return heavy;
            }
            if (inventoryItem.getSwingAnim().equalsIgnoreCase("Throw")) {
                isoGameCharacter.setVariable("rangedWeapon", true);
                return throwing;
            }
            if (!((HandWeapon)inventoryItem).isRanged()) {
                weaponType = onehanded;
                if (inventoryItem == inventoryItem2 && inventoryItem.isTwoHandWeapon()) {
                    weaponType = twohanded;
                    if (inventoryItem.getSwingAnim().equalsIgnoreCase("Spear")) {
                        return spear;
                    }
                    if ("Chainsaw".equals(inventoryItem.getType())) {
                        return chainsaw;
                    }
                }
            } else {
                weaponType = handgun;
                if (inventoryItem == inventoryItem2 && inventoryItem.isTwoHandWeapon()) {
                    weaponType = firearm;
                }
            }
        }
        if (weaponType == null) {
            weaponType = barehand;
        }
        isoGameCharacter.setVariable("rangedWeapon", weaponType == handgun || weaponType == firearm);
        return weaponType;
    }

    public String getType() {
        return this.type;
    }
}

