/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.util.ArrayList;
import zombie.core.Translator;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemType;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.ui.ObjectTooltip;

public final class WeaponPart
extends InventoryItem {
    public static final String TYPE_CANON = "Canon";
    public static final String TYPE_CLIP = "Clip";
    public static final String TYPE_RECOILPAD = "RecoilPad";
    public static final String TYPE_SCOPE = "Scope";
    public static final String TYPE_SLING = "Sling";
    public static final String TYPE_STOCK = "Stock";
    private float maxRange = 0.0f;
    private float minRangeRanged = 0.0f;
    private float damage = 0.0f;
    private float recoilDelay = 0.0f;
    private int clipSize = 0;
    private int reloadTime = 0;
    private int aimingTime = 0;
    private int hitChance = 0;
    private float angle = 0.0f;
    private float weightModifier = 0.0f;
    private final ArrayList<String> mountOn = new ArrayList();
    private final ArrayList<String> mountOnDisplayName = new ArrayList();
    private String partType = null;

    public WeaponPart(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.cat = ItemType.Weapon;
    }

    @Override
    public int getSaveType() {
        return Item.Type.WeaponPart.ordinal();
    }

    @Override
    public String getCategory() {
        if (this.mainCategory != null) {
            return this.mainCategory;
        }
        return "WeaponPart";
    }

    @Override
    public void DoTooltip(ObjectTooltip objectTooltip, ObjectTooltip.Layout layout) {
        ObjectTooltip.LayoutItem layoutItem = layout.addItem();
        layoutItem.setLabel(Translator.getText("Tooltip_weapon_Type") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
        layoutItem.setValue(Translator.getText("Tooltip_weapon_" + this.partType), 1.0f, 1.0f, 0.8f, 1.0f);
        layoutItem = layout.addItem();
        String string = Translator.getText("Tooltip_weapon_CanBeMountOn") + this.mountOnDisplayName.toString().replaceAll("\\[", "").replaceAll("\\]", "");
        layoutItem.setLabel(string, 1.0f, 1.0f, 0.8f, 1.0f);
    }

    public float getMinRangeRanged() {
        return this.minRangeRanged;
    }

    public void setMinRangeRanged(float f) {
        this.minRangeRanged = f;
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public void setMaxRange(float f) {
        this.maxRange = f;
    }

    public float getRecoilDelay() {
        return this.recoilDelay;
    }

    public void setRecoilDelay(float f) {
        this.recoilDelay = f;
    }

    public int getClipSize() {
        return this.clipSize;
    }

    public void setClipSize(int n) {
        this.clipSize = n;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float f) {
        this.damage = f;
    }

    public ArrayList<String> getMountOn() {
        return this.mountOn;
    }

    public void setMountOn(ArrayList<String> arrayList) {
        this.mountOn.clear();
        this.mountOnDisplayName.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            Item item;
            Object object = arrayList.get(i);
            if (!((String)object).contains(".")) {
                object = this.getModule() + "." + (String)object;
            }
            if ((item = ScriptManager.instance.getItem((String)object)) == null) continue;
            this.mountOn.add(item.getFullName());
            this.mountOnDisplayName.add(item.getDisplayName());
        }
    }

    public String getPartType() {
        return this.partType;
    }

    public void setPartType(String string) {
        this.partType = string;
    }

    public int getReloadTime() {
        return this.reloadTime;
    }

    public void setReloadTime(int n) {
        this.reloadTime = n;
    }

    public int getAimingTime() {
        return this.aimingTime;
    }

    public void setAimingTime(int n) {
        this.aimingTime = n;
    }

    public int getHitChance() {
        return this.hitChance;
    }

    public void setHitChance(int n) {
        this.hitChance = n;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
    }

    public float getWeightModifier() {
        return this.weightModifier;
    }

    public void setWeightModifier(float f) {
        this.weightModifier = f;
    }
}

