/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.characters.IsoPlayer;
import zombie.characters.Talker;
import zombie.chat.ChatManager;
import zombie.chat.ChatMessage;
import zombie.core.properties.PropertyContainer;
import zombie.interfaces.IUpdater;
import zombie.inventory.types.Moveable;
import zombie.iso.IsoGridSquare;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.radio.ZomboidRadio;
import zombie.radio.devices.DeviceData;
import zombie.radio.devices.WaveSignalDevice;
import zombie.scripting.objects.Item;
import zombie.ui.UIFont;
import zombie.util.StringUtils;

public final class Radio
extends Moveable
implements Talker,
IUpdater,
WaveSignalDevice {
    protected DeviceData deviceData = new DeviceData(this);
    protected GameTime gameTime = GameTime.getInstance();
    protected int lastMin = 0;
    protected boolean doPowerTick = false;
    protected int listenCnt = 0;

    public Radio(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.canBeDroppedOnFloor = true;
    }

    @Override
    public DeviceData getDeviceData() {
        return this.deviceData;
    }

    @Override
    public void setDeviceData(DeviceData deviceData) {
        if (deviceData == null) {
            deviceData = new DeviceData(this);
        }
        this.deviceData = deviceData;
        this.deviceData.setParent(this);
    }

    public void doReceiveSignal(int n) {
        if (this.deviceData != null) {
            this.deviceData.doReceiveSignal(n);
        }
    }

    @Override
    public void AddDeviceText(String string, float f, float f2, float f3, String string2, String string3, int n) {
        IsoPlayer isoPlayer;
        if (!ZomboidRadio.isStaticSound(string)) {
            this.doReceiveSignal(n);
        }
        if ((isoPlayer = this.getPlayer()) != null && this.deviceData != null && this.deviceData.getDeviceVolume() > 0.0f && !isoPlayer.Traits.Deaf.isSet()) {
            isoPlayer.SayRadio(string, f, f2, f3, UIFont.Medium, this.deviceData.getDeviceVolumeRange(), this.deviceData.getChannel(), "radio");
            if (string3 != null) {
                LuaEventManager.triggerEvent("OnDeviceText", string2, string3, -1, -1, -1, string, this);
            }
        }
    }

    public void AddDeviceText(ChatMessage chatMessage, float f, float f2, float f3, String string, String string2, int n) {
        IsoPlayer isoPlayer;
        if (!ZomboidRadio.isStaticSound(chatMessage.getText())) {
            this.doReceiveSignal(n);
        }
        if ((isoPlayer = this.getPlayer()) != null && this.deviceData != null && this.deviceData.getDeviceVolume() > 0.0f) {
            ChatManager.getInstance().showRadioMessage(chatMessage);
            if (string2 != null) {
                LuaEventManager.triggerEvent("OnDeviceText", string, string2, -1, -1, -1, chatMessage, this);
            }
        }
    }

    @Override
    public boolean HasPlayerInRange() {
        return false;
    }

    @Override
    public boolean ReadFromWorldSprite(String string) {
        PropertyContainer propertyContainer;
        if (StringUtils.isNullOrWhitespace(string)) {
            return false;
        }
        IsoSprite isoSprite = IsoSpriteManager.instance.NamedMap.get(string);
        if (isoSprite != null && (propertyContainer = isoSprite.getProperties()).Is("IsMoveAble")) {
            if (propertyContainer.Is("CustomItem")) {
                this.customItem = propertyContainer.Val("CustomItem");
            }
            this.worldSprite = string;
            return true;
        }
        System.out.println("Warning: Radio worldsprite not valid, sprite = " + (string == null ? "null" : string));
        return false;
    }

    @Override
    public int getSaveType() {
        return Item.Type.Radio.ordinal();
    }

    @Override
    public float getDelta() {
        if (this.deviceData != null) {
            return this.deviceData.getPower();
        }
        return 0.0f;
    }

    @Override
    public void setDelta(float f) {
        if (this.deviceData != null) {
            this.deviceData.setPower(f);
        }
    }

    @Override
    public IsoGridSquare getSquare() {
        if (this.container != null && this.container.parent != null && this.container.parent instanceof IsoPlayer) {
            return this.container.parent.getSquare();
        }
        return null;
    }

    @Override
    public float getX() {
        IsoGridSquare isoGridSquare = this.getSquare();
        return isoGridSquare == null ? 0.0f : (float)isoGridSquare.getX();
    }

    @Override
    public float getY() {
        IsoGridSquare isoGridSquare = this.getSquare();
        return isoGridSquare == null ? 0.0f : (float)isoGridSquare.getY();
    }

    @Override
    public float getZ() {
        IsoGridSquare isoGridSquare = this.getSquare();
        return isoGridSquare == null ? 0.0f : (float)isoGridSquare.getZ();
    }

    public IsoPlayer getPlayer() {
        if (this.container != null && this.container.parent != null && this.container.parent instanceof IsoPlayer) {
            return (IsoPlayer)this.container.parent;
        }
        return null;
    }

    @Override
    public void render() {
    }

    @Override
    public void renderlast() {
    }

    @Override
    public void update() {
        if (this.deviceData == null) {
            return;
        }
        if (!GameServer.bServer && !GameClient.bClient || GameClient.bClient) {
            boolean bl = false;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.getEquipedRadio() != this) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.deviceData.update(false, true);
            } else {
                this.deviceData.cleanSoundsAndEmitter();
            }
        }
    }

    @Override
    public boolean IsSpeaking() {
        return false;
    }

    @Override
    public void Say(String string) {
    }

    @Override
    public String getSayLine() {
        return null;
    }

    @Override
    public String getTalkerType() {
        return "radio";
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        if (this.deviceData != null) {
            byteBuffer.put((byte)1);
            this.deviceData.save(byteBuffer, bl);
        } else {
            byteBuffer.put((byte)0);
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        super.load(byteBuffer, n);
        if (this.deviceData == null) {
            this.deviceData = new DeviceData(this);
        }
        if (byteBuffer.get() == 1) {
            this.deviceData.load(byteBuffer, n, false);
        }
        this.deviceData.setParent(this);
    }
}

