/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import zombie.GameWindow;
import zombie.characters.professions.ProfessionFactory;
import zombie.characters.traits.TraitCollection;
import zombie.characters.traits.TraitFactory;
import zombie.core.Translator;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemType;
import zombie.scripting.objects.Item;
import zombie.ui.ObjectTooltip;
import zombie.util.io.BitHeader;
import zombie.util.io.BitHeaderRead;
import zombie.util.io.BitHeaderWrite;

public final class Literature
extends InventoryItem {
    public boolean bAlreadyRead = false;
    public String requireInHandOrInventory = null;
    public String useOnConsume = null;
    private int numberOfPages = -1;
    private String bookName = "";
    private int LvlSkillTrained = -1;
    private int NumLevelsTrained;
    private String SkillTrained = "None";
    private int alreadyReadPages = 0;
    private boolean canBeWrite = false;
    private HashMap<Integer, String> customPages = null;
    private String lockedBy = null;
    private int pageToWrite;
    private List<String> teachedRecipes = null;
    private final int maxTextLength = 16384;

    public Literature(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.setBookName(string2);
        this.cat = ItemType.Literature;
        if (this.staticModel == null) {
            this.staticModel = "Book";
        }
    }

    public Literature(String string, String string2, String string3, Item item) {
        super(string, string2, string3, item);
        this.setBookName(string2);
        this.cat = ItemType.Literature;
        if (this.staticModel == null) {
            this.staticModel = "Book";
        }
    }

    @Override
    public boolean IsLiterature() {
        return true;
    }

    @Override
    public int getSaveType() {
        return Item.Type.Literature.ordinal();
    }

    @Override
    public String getCategory() {
        if (this.mainCategory != null) {
            return this.mainCategory;
        }
        return "Literature";
    }

    @Override
    public void update() {
        if (this.container != null) {
            // empty if block
        }
    }

    @Override
    public boolean finishupdate() {
        return true;
    }

    @Override
    public void DoTooltip(ObjectTooltip objectTooltip, ObjectTooltip.Layout layout) {
        int n;
        ObjectTooltip.LayoutItem layoutItem;
        if (this.getLvlSkillTrained() != -1) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_BookTitle") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValue(Translator.getText("Tooltip_BookTitle_" + this.getLvlSkillTrained(), Translator.getText("Tooltip_BookTitle_" + this.getSkillTrained())), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.getBoredomChange() != 0.0f) {
            layoutItem = layout.addItem();
            n = (int)this.getBoredomChange();
            layoutItem.setLabel(Translator.getText("Tooltip_literature_Boredom_Reduction") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRight(n, false);
        }
        if (this.getStressChange() != 0.0f) {
            layoutItem = layout.addItem();
            n = (int)(this.getStressChange() * 100.0f);
            layoutItem.setLabel(Translator.getText("Tooltip_literature_Stress_Reduction") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRight(n, false);
        }
        if (this.getUnhappyChange() != 0.0f) {
            layoutItem = layout.addItem();
            n = (int)this.getUnhappyChange();
            layoutItem.setLabel(Translator.getText("Tooltip_food_Unhappiness") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRight(n, false);
        }
        if (this.getNumberOfPages() != -1) {
            layoutItem = layout.addItem();
            n = this.getAlreadyReadPages();
            if (objectTooltip.getCharacter() != null) {
                n = objectTooltip.getCharacter().getAlreadyReadPages(this.getFullType());
            }
            layoutItem.setLabel(Translator.getText("Tooltip_literature_Number_of_Pages") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValue(n + " / " + this.getNumberOfPages(), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.getLvlSkillTrained() != -1) {
            layoutItem = layout.addItem();
            String string = "" + this.getLvlSkillTrained();
            if (this.getLvlSkillTrained() != this.getMaxLevelTrained()) {
                string = string + "-" + this.getMaxLevelTrained();
            }
            layoutItem.setLabel(Translator.getText("Tooltip_Literature_XpMultiplier", string), 1.0f, 1.0f, 0.8f, 1.0f);
        }
        if (this.getTeachedRecipes() != null) {
            Object object;
            for (String object2 : this.getTeachedRecipes()) {
                layoutItem = layout.addItem();
                object = Translator.getRecipeName(object2);
                layoutItem.setLabel(Translator.getText("Tooltip_Literature_TeachedRecipes", object), 1.0f, 1.0f, 0.8f, 1.0f);
            }
            if (objectTooltip.getCharacter() != null) {
                layoutItem = layout.addItem();
                Object object3 = Translator.getText("Tooltip_literature_NotBeenRead");
                if (objectTooltip.getCharacter().getKnownRecipes().containsAll(this.getTeachedRecipes())) {
                    object3 = Translator.getText("Tooltip_literature_HasBeenRead");
                }
                layoutItem.setLabel((String)object3, 1.0f, 1.0f, 0.8f, 1.0f);
                if (objectTooltip.getCharacter().getKnownRecipes().containsAll(this.getTeachedRecipes())) {
                    ProfessionFactory.Profession profession = ProfessionFactory.getProfession(objectTooltip.getCharacter().getDescriptor().getProfession());
                    object = objectTooltip.getCharacter().getTraits();
                    int n2 = 0;
                    int n3 = 0;
                    for (int i = 0; i < this.getTeachedRecipes().size(); ++i) {
                        String string = this.getTeachedRecipes().get(i);
                        if (profession != null && profession.getFreeRecipes().contains(string)) {
                            ++n2;
                        }
                        for (int j = 0; j < ((TraitCollection)object).size(); ++j) {
                            TraitFactory.Trait trait = TraitFactory.getTrait(((TraitCollection)object).get(j));
                            if (trait == null || !trait.getFreeRecipes().contains(string)) continue;
                            ++n3;
                        }
                    }
                    if (n2 > 0 || n3 > 0) {
                        layoutItem = layout.addItem();
                        layoutItem.setLabel(Translator.getText("Tooltip_literature_AlreadyKnown"), 0.0f, 1.0f, 0.8f, 1.0f);
                    }
                }
            }
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        BitHeaderWrite bitHeaderWrite = BitHeader.allocWrite(BitHeader.HeaderSize.Byte, byteBuffer);
        int n = 0;
        if (this.numberOfPages >= 127 && this.numberOfPages < Short.MAX_VALUE) {
            n = 1;
        } else if (this.numberOfPages >= Short.MAX_VALUE) {
            n = 2;
        }
        if (this.numberOfPages != -1) {
            bitHeaderWrite.addFlags(1);
            if (n == 1) {
                bitHeaderWrite.addFlags(2);
                byteBuffer.putShort((short)this.numberOfPages);
            } else if (n == 2) {
                bitHeaderWrite.addFlags(4);
                byteBuffer.putInt(this.numberOfPages);
            } else {
                byteBuffer.put((byte)this.numberOfPages);
            }
        }
        if (this.alreadyReadPages != 0) {
            bitHeaderWrite.addFlags(8);
            if (n == 1) {
                byteBuffer.putShort((short)this.alreadyReadPages);
            } else if (n == 2) {
                byteBuffer.putInt(this.alreadyReadPages);
            } else {
                byteBuffer.put((byte)this.alreadyReadPages);
            }
        }
        if (this.canBeWrite) {
            bitHeaderWrite.addFlags(16);
        }
        if (this.customPages != null && this.customPages.size() > 0) {
            bitHeaderWrite.addFlags(32);
            byteBuffer.putInt(this.customPages.size());
            for (String string : this.customPages.values()) {
                GameWindow.WriteString(byteBuffer, string);
            }
        }
        if (this.lockedBy != null) {
            bitHeaderWrite.addFlags(64);
            GameWindow.WriteString(byteBuffer, this.getLockedBy());
        }
        bitHeaderWrite.write();
        bitHeaderWrite.release();
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        super.load(byteBuffer, n);
        this.numberOfPages = -1;
        this.alreadyReadPages = 0;
        this.canBeWrite = false;
        this.customPages = null;
        this.lockedBy = null;
        BitHeaderRead bitHeaderRead = BitHeader.allocRead(BitHeader.HeaderSize.Byte, byteBuffer);
        if (!bitHeaderRead.equals(0)) {
            int n2;
            int n3 = 0;
            if (bitHeaderRead.hasFlags(1)) {
                if (bitHeaderRead.hasFlags(2)) {
                    n3 = 1;
                    this.numberOfPages = byteBuffer.getShort();
                } else if (bitHeaderRead.hasFlags(4)) {
                    n3 = 2;
                    this.numberOfPages = byteBuffer.getInt();
                } else {
                    this.numberOfPages = byteBuffer.get();
                }
            }
            if (bitHeaderRead.hasFlags(8)) {
                this.alreadyReadPages = n3 == 1 ? (int)byteBuffer.getShort() : (n3 == 2 ? byteBuffer.getInt() : (int)byteBuffer.get());
            }
            this.canBeWrite = bitHeaderRead.hasFlags(16);
            if (bitHeaderRead.hasFlags(32) && (n2 = byteBuffer.getInt()) > 0) {
                this.customPages = new HashMap();
                for (int i = 0; i < n2; ++i) {
                    this.customPages.put(i + 1, GameWindow.ReadString(byteBuffer));
                }
            }
            if (bitHeaderRead.hasFlags(64)) {
                this.setLockedBy(GameWindow.ReadString(byteBuffer));
            }
        }
        bitHeaderRead.release();
    }

    @Override
    public float getBoredomChange() {
        if (!this.bAlreadyRead) {
            return this.boredomChange;
        }
        return 0.0f;
    }

    @Override
    public float getUnhappyChange() {
        if (!this.bAlreadyRead) {
            return this.unhappyChange;
        }
        return 0.0f;
    }

    @Override
    public float getStressChange() {
        if (!this.bAlreadyRead) {
            return this.stressChange;
        }
        return 0.0f;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(int n) {
        this.numberOfPages = n;
    }

    public String getBookName() {
        return this.bookName;
    }

    public void setBookName(String string) {
        this.bookName = string;
    }

    public int getLvlSkillTrained() {
        return this.LvlSkillTrained;
    }

    public void setLvlSkillTrained(int n) {
        this.LvlSkillTrained = n;
    }

    public int getNumLevelsTrained() {
        return this.NumLevelsTrained;
    }

    public void setNumLevelsTrained(int n) {
        this.NumLevelsTrained = n;
    }

    public int getMaxLevelTrained() {
        return this.getLvlSkillTrained() + this.getNumLevelsTrained() - 1;
    }

    public String getSkillTrained() {
        return this.SkillTrained;
    }

    public void setSkillTrained(String string) {
        this.SkillTrained = string;
    }

    public int getAlreadyReadPages() {
        return this.alreadyReadPages;
    }

    public void setAlreadyReadPages(int n) {
        this.alreadyReadPages = n;
    }

    public boolean canBeWrite() {
        return this.canBeWrite;
    }

    public void setCanBeWrite(boolean bl) {
        this.canBeWrite = bl;
    }

    public HashMap<Integer, String> getCustomPages() {
        if (this.customPages == null) {
            this.customPages = new HashMap();
            this.customPages.put(1, "");
        }
        return this.customPages;
    }

    public void setCustomPages(HashMap<Integer, String> hashMap) {
        this.customPages = hashMap;
    }

    public void addPage(Integer n, String string) {
        if (string.length() > 16384) {
            string = string.substring(0, Math.min(string.length(), 16384));
        }
        if (this.customPages == null) {
            this.customPages = new HashMap();
        }
        this.customPages.put(n, string);
    }

    public String seePage(Integer n) {
        if (this.customPages == null) {
            this.customPages = new HashMap();
            this.customPages.put(1, "");
        }
        return this.customPages.get(n);
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public void setLockedBy(String string) {
        this.lockedBy = string;
    }

    public int getPageToWrite() {
        return this.pageToWrite;
    }

    public void setPageToWrite(int n) {
        this.pageToWrite = n;
    }

    public List<String> getTeachedRecipes() {
        return this.teachedRecipes;
    }

    public void setTeachedRecipes(List<String> list) {
        this.teachedRecipes = list;
    }
}

