/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemType;
import zombie.scripting.objects.Item;

public final class Key
extends InventoryItem {
    private int keyId = -1;
    private boolean padlock = false;
    private int numberOfKey = 0;
    private boolean digitalPadlock = false;
    public static final Key[] highlightDoor = new Key[4];

    public Key(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.cat = ItemType.Key;
    }

    @Override
    public int getSaveType() {
        return Item.Type.Key.ordinal();
    }

    public void takeKeyId() {
        if (this.getContainer() != null && this.getContainer().getSourceGrid() != null && this.getContainer().getSourceGrid().getBuilding() != null && this.getContainer().getSourceGrid().getBuilding().def != null) {
            this.setKeyId(this.getContainer().getSourceGrid().getBuilding().def.getKeyId());
        }
    }

    public static void setHighlightDoors(int n, InventoryItem inventoryItem) {
        Key.highlightDoor[n] = inventoryItem instanceof Key && !((Key)inventoryItem).isPadlock() && !((Key)inventoryItem).isDigitalPadlock() ? (Key)inventoryItem : null;
    }

    @Override
    public int getKeyId() {
        return this.keyId;
    }

    @Override
    public void setKeyId(int n) {
        this.keyId = n;
    }

    @Override
    public String getCategory() {
        if (this.mainCategory != null) {
            return this.mainCategory;
        }
        return "Key";
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.putInt(this.getKeyId());
        byteBuffer.put((byte)this.numberOfKey);
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        super.load(byteBuffer, n);
        this.setKeyId(byteBuffer.getInt());
        this.numberOfKey = byteBuffer.get();
    }

    public boolean isPadlock() {
        return this.padlock;
    }

    public void setPadlock(boolean bl) {
        this.padlock = bl;
    }

    public int getNumberOfKey() {
        return this.numberOfKey;
    }

    public void setNumberOfKey(int n) {
        this.numberOfKey = n;
    }

    public boolean isDigitalPadlock() {
        return this.digitalPadlock;
    }

    public void setDigitalPadlock(boolean bl) {
        this.digitalPadlock = bl;
    }
}

