/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import fmod.fmod.FMODManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.audio.BaseSoundEmitter;
import zombie.characters.IsoPlayer;
import zombie.characters.SurvivorDesc;
import zombie.characters.skills.PerkFactory;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemSoundManager;
import zombie.inventory.ItemType;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoCompost;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.objects.IsoFireplace;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.ui.ObjectTooltip;
import zombie.util.StringUtils;
import zombie.util.io.BitHeader;
import zombie.util.io.BitHeaderRead;
import zombie.util.io.BitHeaderWrite;

public final class Food
extends InventoryItem {
    protected boolean bBadCold = false;
    protected boolean bGoodHot = false;
    private static final float MIN_HEAT = 0.2f;
    private static final float MAX_HEAT = 3.0f;
    protected float Heat = 1.0f;
    protected float endChange = 0.0f;
    protected float hungChange = 0.0f;
    protected String useOnConsume = null;
    protected boolean rotten = false;
    protected boolean bDangerousUncooked = false;
    protected int LastCookMinute = 0;
    public float thirstChange = 0.0f;
    public boolean Poison = false;
    private List<String> ReplaceOnCooked = null;
    private float baseHunger = 0.0f;
    public ArrayList<String> spices = null;
    private boolean isSpice = false;
    private int poisonDetectionLevel = -1;
    private Integer PoisonLevelForRecipe = 0;
    private int UseForPoison = 0;
    private int PoisonPower = 0;
    private String FoodType = null;
    private String CustomEatSound = null;
    private boolean RemoveNegativeEffectOnCooked = false;
    private String Chef = null;
    private String OnCooked = null;
    private String WorldTextureCooked;
    private String WorldTextureRotten;
    private String WorldTextureOverdone;
    private int fluReduction = 0;
    private int ReduceFoodSickness = 0;
    private float painReduction = 0.0f;
    private String HerbalistType;
    private float carbohydrates = 0.0f;
    private float lipids = 0.0f;
    private float proteins = 0.0f;
    private float calories = 0.0f;
    private boolean packaged = false;
    private float freezingTime = 0.0f;
    private boolean frozen = false;
    private boolean canBeFrozen = true;
    protected float LastFrozenUpdate = -1.0f;
    public static final float FreezerAgeMultiplier = 0.02f;
    private String replaceOnRotten = null;
    private boolean forceFoodTypeAsName = false;
    private float rottenTime = 0.0f;
    private float compostTime = 0.0f;
    private String onEat = null;
    private boolean badInMicrowave = false;
    private boolean cookedInMicrowave = false;
    private long m_cookingSound = 0L;
    private int m_cookingParameter = -1;
    private static final int COOKING_STATE_COOKING = 0;
    private static final int COOKING_STATE_BURNING = 1;

    @Override
    public String getCategory() {
        if (this.mainCategory != null) {
            return this.mainCategory;
        }
        return "Food";
    }

    public Food(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        Texture.WarnFailFindTexture = false;
        this.texturerotten = Texture.trygetTexture(string4 + "Rotten");
        this.textureCooked = Texture.trygetTexture(string4 + "Cooked");
        this.textureBurnt = Texture.trygetTexture(string4 + "Overdone");
        String string5 = "Overdone.png";
        if (this.textureBurnt == null) {
            this.textureBurnt = Texture.trygetTexture(string4 + "Burnt");
            if (this.textureBurnt != null) {
                string5 = "Burnt.png";
            }
        }
        String string6 = "Rotten.png";
        if (this.texturerotten == null) {
            this.texturerotten = Texture.trygetTexture(string4 + "Spoiled");
            if (this.texturerotten != null) {
                string6 = "Spoiled.png";
            }
        }
        Texture.WarnFailFindTexture = true;
        if (this.texturerotten == null) {
            this.texturerotten = this.texture;
        }
        if (this.textureCooked == null) {
            this.textureCooked = this.texture;
        }
        if (this.textureBurnt == null) {
            this.textureBurnt = this.texture;
        }
        this.WorldTextureCooked = this.WorldTexture.replace(".png", "Cooked.png");
        this.WorldTextureOverdone = this.WorldTexture.replace(".png", string5);
        this.WorldTextureRotten = this.WorldTexture.replace(".png", string6);
        this.cat = ItemType.Food;
    }

    public Food(String string, String string2, String string3, Item item) {
        super(string, string2, string3, item);
        String string4 = item.ItemName;
        Texture.WarnFailFindTexture = false;
        this.texture = item.NormalTexture;
        if (item.SpecialTextures.size() == 0) {
            boolean bl = false;
        }
        if (item.SpecialTextures.size() > 0) {
            this.texturerotten = item.SpecialTextures.get(0);
        }
        if (item.SpecialTextures.size() > 1) {
            this.textureCooked = item.SpecialTextures.get(1);
        }
        if (item.SpecialTextures.size() > 2) {
            this.textureBurnt = item.SpecialTextures.get(2);
        }
        Texture.WarnFailFindTexture = true;
        if (this.texturerotten == null) {
            this.texturerotten = this.texture;
        }
        if (this.textureCooked == null) {
            this.textureCooked = this.texture;
        }
        if (this.textureBurnt == null) {
            this.textureBurnt = this.texture;
        }
        if (item.SpecialWorldTextureNames.size() > 0) {
            this.WorldTextureRotten = item.SpecialWorldTextureNames.get(0);
        }
        if (item.SpecialWorldTextureNames.size() > 1) {
            this.WorldTextureCooked = item.SpecialWorldTextureNames.get(1);
        }
        if (item.SpecialWorldTextureNames.size() > 2) {
            this.WorldTextureOverdone = item.SpecialWorldTextureNames.get(2);
        }
        this.cat = ItemType.Food;
    }

    @Override
    public boolean IsFood() {
        return true;
    }

    @Override
    public int getSaveType() {
        return Item.Type.Food.ordinal();
    }

    @Override
    public void update() {
        if (this.hasTag("AlreadyCooked")) {
            this.setCooked(true);
        }
        this.updateTemperature();
        ItemContainer itemContainer = this.getOutermostContainer();
        if (itemContainer != null) {
            int n;
            if (this.IsCookable && !this.isFrozen()) {
                int n2;
                if (this.Heat > 1.6f && (n2 = GameTime.getInstance().getMinutes()) != this.LastCookMinute) {
                    int n3;
                    this.LastCookMinute = n2;
                    float f = this.Heat / 1.5f;
                    if (itemContainer.getTemprature() <= 1.6f) {
                        f *= 0.05f;
                    }
                    this.CookingTime += f;
                    if (this.shouldPlayCookingSound()) {
                        ItemSoundManager.addItem(this);
                    }
                    if (this.isTaintedWater() && this.CookingTime > Math.min(this.MinutesToCook, 10.0f)) {
                        this.setTaintedWater(false);
                    }
                    if (!this.isCooked() && !this.Burnt && this.CookingTime > this.MinutesToCook) {
                        if (this.getReplaceOnCooked() != null && !this.isRotten()) {
                            if (GameClient.bClient) {
                                GameClient.instance.sendReplaceOnCooked(this);
                                this.container.Remove(this);
                                IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this);
                                return;
                            }
                            for (int i = 0; i < this.getReplaceOnCooked().size(); ++i) {
                                InventoryItem inventoryItem = this.container.AddItem(this.getReplaceOnCooked().get(i));
                                if (inventoryItem == null) continue;
                                inventoryItem.copyConditionModData(this);
                                if (!(inventoryItem instanceof Food) || this instanceof Food) {
                                    // empty if block
                                }
                                if (!(inventoryItem instanceof Food) || !((Food)inventoryItem).isBadInMicrowave() || !this.container.isMicrowave()) continue;
                                inventoryItem.setUnhappyChange(5.0f);
                                inventoryItem.setBoredomChange(5.0f);
                                ((Food)inventoryItem).cookedInMicrowave = true;
                            }
                            this.container.Remove(this);
                            IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this);
                            return;
                        }
                        this.setCooked(true);
                        if (this.getScriptItem().RemoveUnhappinessWhenCooked) {
                            this.setUnhappyChange(0.0f);
                        }
                        if (this.type.equals("RicePot") || this.type.equals("PastaPot") || this.type.equals("RicePan") || this.type.equals("PastaPan") || this.type.equals("WaterPotRice") || this.type.equals("WaterPotPasta") || this.type.equals("WaterSaucepanRice") || this.type.equals("WaterSaucepanPasta") || this.type.equals("RiceBowl") || this.type.equals("PastaBowl")) {
                            this.setAge(0.0f);
                            this.setOffAge(1);
                            this.setOffAgeMax(2);
                        }
                        if (this.isRemoveNegativeEffectOnCooked()) {
                            if (this.thirstChange > 0.0f) {
                                this.setThirstChange(0.0f);
                            }
                            if (this.unhappyChange > 0.0f) {
                                this.setUnhappyChange(0.0f);
                            }
                            if (this.boredomChange > 0.0f) {
                                this.setBoredomChange(0.0f);
                            }
                        }
                        if (this.getOnCooked() != null) {
                            LuaManager.caller.protectedCall(LuaManager.thread, LuaManager.env.rawget((Object)this.getOnCooked()), new Object[]{this});
                        }
                        if (this.isBadInMicrowave() && this.container.isMicrowave()) {
                            this.setUnhappyChange(5.0f);
                            this.setBoredomChange(5.0f);
                            this.cookedInMicrowave = true;
                        }
                        if (this.Chef != null && !this.Chef.isEmpty()) {
                            for (n3 = 0; n3 < IsoPlayer.numPlayers; ++n3) {
                                IsoPlayer isoPlayer = IsoPlayer.players[n3];
                                if (isoPlayer == null || isoPlayer.isDead() || !this.Chef.equals(isoPlayer.getFullName())) continue;
                                isoPlayer.getXp().AddXP(PerkFactory.Perks.Cooking, 10.0f);
                                break;
                            }
                        }
                    }
                    if (this.CookingTime > this.MinutesToBurn) {
                        this.Burnt = true;
                        this.setCooked(false);
                    }
                    if (IsoWorld.instance.isHydroPowerOn() && this.Burnt && this.CookingTime >= 50.0f && this.CookingTime >= this.MinutesToCook * 2.0f + this.MinutesToBurn / 2.0f && Rand.Next(Rand.AdjustForFramerate(200)) == 0) {
                        int n4 = n3 = this.container != null && this.container.getParent() != null && this.container.getParent().getName() != null && this.container.getParent().getName().equals("Campfire") ? 1 : 0;
                        if (n3 == 0 && this.container != null && this.container.getParent() != null && this.container.getParent() instanceof IsoFireplace) {
                            n3 = 1;
                        }
                        if (this.container != null && this.container.SourceGrid != null && n3 == 0) {
                            IsoFireManager.StartFire(this.container.SourceGrid.getCell(), this.container.SourceGrid, true, 500000);
                            this.IsCookable = false;
                        }
                    }
                }
            } else if (this.isTaintedWater() && this.Heat > 1.6f && !this.isFrozen() && (n = GameTime.getInstance().getMinutes()) != this.LastCookMinute) {
                this.LastCookMinute = n;
                float f = 1.0f;
                if (itemContainer.getTemprature() <= 1.6f) {
                    f = (float)((double)f * 0.2);
                }
                this.CookingTime += f;
                if (this.CookingTime > 10.0f) {
                    this.setTaintedWater(false);
                }
            }
        }
        this.updateRotting(itemContainer);
    }

    @Override
    public void updateSound(BaseSoundEmitter baseSoundEmitter) {
        if (this.shouldPlayCookingSound()) {
            if (baseSoundEmitter.isPlaying(this.m_cookingSound)) {
                this.setCookingParameter(baseSoundEmitter);
                return;
            }
            ItemContainer itemContainer = this.getOutermostContainer();
            IsoGridSquare isoGridSquare = itemContainer.getParent().getSquare();
            baseSoundEmitter.setPos((float)isoGridSquare.getX() + 0.5f, (float)isoGridSquare.getY() + 0.5f, isoGridSquare.getZ());
            this.m_cookingSound = baseSoundEmitter.playSoundImpl(this.getCookingSound(), (IsoObject)null);
            this.setCookingParameter(baseSoundEmitter);
        } else {
            baseSoundEmitter.stopOrTriggerSound(this.m_cookingSound);
            this.m_cookingSound = 0L;
            this.m_cookingParameter = -1;
            ItemSoundManager.removeItem(this);
        }
    }

    private boolean shouldPlayCookingSound() {
        if (GameServer.bServer) {
            return false;
        }
        if (StringUtils.isNullOrWhitespace(this.getCookingSound())) {
            return false;
        }
        ItemContainer itemContainer = this.getOutermostContainer();
        if (itemContainer == null || itemContainer.getParent() == null || itemContainer.getParent().getObjectIndex() == -1 || itemContainer.getTemprature() <= 1.6f) {
            return false;
        }
        return this.isCookable() && !this.isFrozen() && this.getHeat() > 1.6f;
    }

    private void setCookingParameter(BaseSoundEmitter baseSoundEmitter) {
        int n;
        boolean bl = this.CookingTime > this.MinutesToCook;
        int n2 = n = bl ? 1 : 0;
        if (n != this.m_cookingParameter) {
            this.m_cookingParameter = n;
            baseSoundEmitter.setParameterValue(this.m_cookingSound, FMODManager.instance.getParameterDescription("CookingState"), this.m_cookingParameter);
        }
    }

    private void updateTemperature() {
        float f;
        ItemContainer itemContainer = this.getOutermostContainer();
        float f2 = f = itemContainer == null ? 1.0f : itemContainer.getTemprature();
        if (this.Heat > f) {
            this.Heat -= 0.001f * GameTime.instance.getMultiplier();
            if (this.Heat < Math.max(0.2f, f)) {
                this.Heat = Math.max(0.2f, f);
            }
        }
        if (this.Heat < f) {
            this.Heat += f / 1000.0f * GameTime.instance.getMultiplier();
            if (this.Heat > Math.min(3.0f, f)) {
                this.Heat = Math.min(3.0f, f);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateRotting(ItemContainer itemContainer) {
        if ((double)this.OffAgeMax == 1.0E9) {
            return;
        }
        if (GameClient.bClient && !this.isInLocalPlayerInventory()) {
            return;
        }
        if (GameServer.bServer && this.container != null && this.getOutermostContainer() != this.container) {
            return;
        }
        if (this.replaceOnRotten != null && !this.replaceOnRotten.isEmpty()) {
            this.updateAge();
            if (this.isRotten()) {
                InventoryItem inventoryItem = InventoryItemFactory.CreateItem(this.getModule() + "." + this.replaceOnRotten, this);
                if (inventoryItem == null) {
                    DebugLog.General.warn("ReplaceOnRotten = " + this.replaceOnRotten + " doesn't exist for " + this.getFullType());
                    this.destroyThisItem();
                    return;
                }
                inventoryItem.setAge(this.getAge());
                IsoWorldInventoryObject isoWorldInventoryObject = this.getWorldItem();
                if (isoWorldInventoryObject != null && isoWorldInventoryObject.getSquare() != null) {
                    IsoGridSquare isoGridSquare = isoWorldInventoryObject.getSquare();
                    if (!GameServer.bServer) {
                        isoWorldInventoryObject.item = inventoryItem;
                        inventoryItem.setWorldItem(isoWorldInventoryObject);
                        isoWorldInventoryObject.updateSprite();
                        IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this);
                        LuaEventManager.triggerEvent("OnContainerUpdate");
                        return;
                    }
                    isoGridSquare.AddWorldInventoryItem(inventoryItem, isoWorldInventoryObject.xoff, isoWorldInventoryObject.yoff, isoWorldInventoryObject.zoff, true);
                } else if (this.container != null) {
                    this.container.AddItem(inventoryItem);
                    if (GameServer.bServer) {
                        GameServer.sendAddItemToContainer(this.container, inventoryItem);
                    }
                }
                this.destroyThisItem();
                return;
            }
        }
        if (SandboxOptions.instance.DaysForRottenFoodRemoval.getValue() >= 0) {
            if (itemContainer != null && itemContainer.parent instanceof IsoCompost) {
                return;
            }
            this.updateAge();
            if (this.getAge() > (float)(this.getOffAgeMax() + SandboxOptions.instance.DaysForRottenFoodRemoval.getValue())) {
                this.destroyThisItem();
                return;
            }
        }
    }

    @Override
    public void updateAge() {
        ItemContainer itemContainer = this.getOutermostContainer();
        this.updateFreezing(itemContainer);
        boolean bl = false;
        if (itemContainer != null && itemContainer.getSourceGrid() != null && itemContainer.getSourceGrid().haveElectricity()) {
            bl = true;
        }
        float f = (float)GameTime.getInstance().getWorldAgeHours();
        float f2 = 0.2f;
        if (SandboxOptions.instance.FridgeFactor.getValue() == 1) {
            f2 = 0.4f;
        } else if (SandboxOptions.instance.FridgeFactor.getValue() == 2) {
            f2 = 0.3f;
        } else if (SandboxOptions.instance.FridgeFactor.getValue() == 4) {
            f2 = 0.1f;
        } else if (SandboxOptions.instance.FridgeFactor.getValue() == 5) {
            f2 = 0.03f;
        }
        if (this.LastAged < 0.0f) {
            this.LastAged = f;
        } else if (this.LastAged > f) {
            this.LastAged = f;
        }
        if (f > this.LastAged) {
            boolean bl2;
            float f3;
            double d = f - this.LastAged;
            if (itemContainer != null && this.Heat != itemContainer.getTemprature()) {
                if (d < 0.3333333432674408) {
                    if (!IsoWorld.instance.getCell().getProcessItems().contains(this)) {
                        this.Heat = GameTime.instance.Lerp(this.Heat, itemContainer.getTemprature(), (float)d / 0.33333334f);
                        IsoWorld.instance.getCell().addToProcessItems(this);
                    }
                } else {
                    this.Heat = itemContainer.getTemprature();
                }
            }
            if (this.isFrozen()) {
                d *= (double)0.02f;
            } else if (itemContainer != null && (itemContainer.getType().equals("fridge") || itemContainer.getType().equals("freezer"))) {
                if (bl) {
                    d *= (double)f2;
                } else if (SandboxOptions.instance.getElecShutModifier() > -1 && this.LastAged < (float)(SandboxOptions.instance.getElecShutModifier() * 24)) {
                    f3 = Math.min((float)(SandboxOptions.instance.getElecShutModifier() * 24), f);
                    d = (f3 - this.LastAged) * f2;
                    if (f > (float)(SandboxOptions.instance.getElecShutModifier() * 24)) {
                        d += (double)(f - (float)(SandboxOptions.instance.getElecShutModifier() * 24));
                    }
                }
            }
            f3 = 1.0f;
            if (SandboxOptions.instance.FoodRotSpeed.getValue() == 1) {
                f3 = 1.7f;
            } else if (SandboxOptions.instance.FoodRotSpeed.getValue() == 2) {
                f3 = 1.4f;
            } else if (SandboxOptions.instance.FoodRotSpeed.getValue() == 4) {
                f3 = 0.7f;
            } else if (SandboxOptions.instance.FoodRotSpeed.getValue() == 5) {
                f3 = 0.4f;
            }
            boolean bl3 = !this.Burnt && this.OffAge < 1000000000 && this.Age < (float)this.OffAge;
            boolean bl4 = !this.Burnt && this.OffAgeMax < 1000000000 && this.Age >= (float)this.OffAgeMax;
            this.Age = (float)((double)this.Age + d * (double)f3 / 24.0);
            this.LastAged = f;
            boolean bl5 = !this.Burnt && this.OffAge < 1000000000 && this.Age < (float)this.OffAge;
            boolean bl6 = bl2 = !this.Burnt && this.OffAgeMax < 1000000000 && this.Age >= (float)this.OffAgeMax;
            if (!(GameServer.bServer || bl3 == bl5 && bl4 == bl2)) {
                LuaEventManager.triggerEvent("OnContainerUpdate", this);
            }
        }
    }

    @Override
    public void setAutoAge() {
        float f;
        int n;
        ItemContainer itemContainer = this.getOutermostContainer();
        float f2 = (float)GameTime.getInstance().getWorldAgeHours() / 24.0f;
        float f3 = f2 += (float)((SandboxOptions.instance.TimeSinceApo.getValue() - 1) * 30);
        boolean bl = false;
        if (itemContainer != null && itemContainer.getParent() != null && itemContainer.getParent().getSprite() != null) {
            bl = itemContainer.getParent().getSprite().getProperties().Is("IsFridge");
        }
        if (itemContainer != null && (bl || itemContainer.getType().equals("fridge") || itemContainer.getType().equals("freezer")) && (n = SandboxOptions.instance.ElecShutModifier.getValue()) > -1) {
            f = Math.min((float)n, f2);
            int n2 = SandboxOptions.instance.FridgeFactor.getValue();
            float f4 = 0.2f;
            if (n2 == 1) {
                f4 = 0.4f;
            } else if (n2 == 2) {
                f4 = 0.3f;
            } else if (n2 == 4) {
                f4 = 0.1f;
            } else if (n2 == 5) {
                f4 = 0.03f;
            }
            if (itemContainer.getType().equals("fridge") || !this.canBeFrozen() || bl) {
                f3 -= f;
                f3 += f * f4;
            } else {
                float f5 = f;
                float f6 = 100.0f;
                if (f2 > f) {
                    float f7 = (f2 - f) * 24.0f;
                    float f8 = 0.0095999995f;
                    float f9 = 1440.0f / GameTime.getInstance().getMinutesPerDay() * 60.0f * 5.0f;
                    if ((f6 -= f8 * f9 * f7) > 0.0f) {
                        f5 += f7 / 24.0f;
                    } else {
                        float f10 = 100.0f / (f8 * f9);
                        f5 += f10 / 24.0f;
                        f6 = 0.0f;
                    }
                }
                f3 -= f5;
                f3 += f5 * 0.02f;
                this.setFreezingTime(f6);
            }
        }
        n = SandboxOptions.instance.FoodRotSpeed.getValue();
        f = 1.0f;
        if (n == 1) {
            f = 1.7f;
        } else if (n == 2) {
            f = 1.4f;
        } else if (n == 4) {
            f = 0.7f;
        } else if (n == 5) {
            f = 0.4f;
        }
        this.Age = f3 * f;
        this.LastFrozenUpdate = this.LastAged = (float)GameTime.getInstance().getWorldAgeHours();
        if (itemContainer != null) {
            this.setHeat(itemContainer.getTemprature());
        }
    }

    public void updateFreezing(ItemContainer itemContainer) {
        float f = (float)GameTime.getInstance().getWorldAgeHours();
        if (this.LastFrozenUpdate < 0.0f) {
            this.LastFrozenUpdate = f;
        } else if (this.LastFrozenUpdate > f) {
            this.LastFrozenUpdate = f;
        }
        if (f > this.LastFrozenUpdate) {
            float f2 = f - this.LastFrozenUpdate;
            float f3 = 4.0f;
            float f4 = 1.5f;
            if (this.isFreezing()) {
                this.setFreezingTime(this.getFreezingTime() + f2 / f3 * 100.0f);
            }
            if (this.isThawing()) {
                float f5 = f4;
                if (itemContainer != null && "fridge".equals(itemContainer.getType()) && itemContainer.isPowered()) {
                    f5 *= 2.0f;
                }
                if (itemContainer != null && itemContainer.getTemprature() > 1.0f) {
                    f5 /= 6.0f;
                }
                this.setFreezingTime(this.getFreezingTime() - f2 / f5 * 100.0f);
            }
            this.LastFrozenUpdate = f;
        }
    }

    @Override
    public float getActualWeight() {
        if (this.haveExtraItems()) {
            String string;
            Item item;
            float f = this.getHungChange();
            float f2 = this.getBaseHunger();
            float f3 = f2 == 0.0f ? 0.0f : f / f2;
            float f4 = 0.0f;
            if (this.getReplaceOnUse() != null && (item = ScriptManager.instance.getItem(string = this.getReplaceOnUseFullType())) != null) {
                f4 = item.getActualWeight();
            }
            float f5 = super.getActualWeight() + this.getExtraItemsWeight();
            float f6 = (f5 - f4) * f3 + f4;
            return f6;
        }
        if (this.getReplaceOnUse() != null && !this.isCustomWeight()) {
            String string = this.getReplaceOnUseFullType();
            Item item = ScriptManager.instance.getItem(string);
            if (item != null) {
                float f = 1.0f;
                if (this.getScriptItem().getHungerChange() < 0.0f) {
                    f = this.getHungChange() * 100.0f / this.getScriptItem().getHungerChange();
                } else if (this.getScriptItem().getThirstChange() < 0.0f) {
                    f = this.getThirstChange() * 100.0f / this.getScriptItem().getThirstChange();
                }
                return (this.getScriptItem().getActualWeight() - item.getActualWeight()) * f + item.getActualWeight();
            }
        } else if (!this.isCustomWeight()) {
            float f = 1.0f;
            if (this.getScriptItem().getHungerChange() < 0.0f) {
                f = this.getHungChange() * 100.0f / this.getScriptItem().getHungerChange();
            } else if (this.getScriptItem().getThirstChange() < 0.0f) {
                f = this.getThirstChange() * 100.0f / this.getScriptItem().getThirstChange();
            }
            return this.getScriptItem().getActualWeight() * f;
        }
        return super.getActualWeight();
    }

    @Override
    public float getWeight() {
        if (this.getReplaceOnUse() != null) {
            return this.getActualWeight();
        }
        return super.getWeight();
    }

    @Override
    public boolean CanStack(InventoryItem inventoryItem) {
        return false;
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.putFloat(this.Age);
        byteBuffer.putFloat(this.LastAged);
        BitHeaderWrite bitHeaderWrite = BitHeader.allocWrite(BitHeader.HeaderSize.Byte, byteBuffer);
        if (this.calories != 0.0f || this.proteins != 0.0f || this.lipids != 0.0f || this.carbohydrates != 0.0f) {
            bitHeaderWrite.addFlags(1);
            byteBuffer.putFloat(this.calories);
            byteBuffer.putFloat(this.proteins);
            byteBuffer.putFloat(this.lipids);
            byteBuffer.putFloat(this.carbohydrates);
        }
        if (this.hungChange != 0.0f) {
            bitHeaderWrite.addFlags(2);
            byteBuffer.putFloat(this.hungChange);
        }
        if (this.baseHunger != 0.0f) {
            bitHeaderWrite.addFlags(4);
            byteBuffer.putFloat(this.baseHunger);
        }
        if (this.unhappyChange != 0.0f) {
            bitHeaderWrite.addFlags(8);
            byteBuffer.putFloat(this.unhappyChange);
        }
        if (this.boredomChange != 0.0f) {
            bitHeaderWrite.addFlags(16);
            byteBuffer.putFloat(this.boredomChange);
        }
        if (this.thirstChange != 0.0f) {
            bitHeaderWrite.addFlags(32);
            byteBuffer.putFloat(this.thirstChange);
        }
        BitHeaderWrite bitHeaderWrite2 = BitHeader.allocWrite(BitHeader.HeaderSize.Integer, byteBuffer);
        if (this.Heat != 1.0f) {
            bitHeaderWrite2.addFlags(1);
            byteBuffer.putFloat(this.Heat);
        }
        if (this.LastCookMinute != 0) {
            bitHeaderWrite2.addFlags(2);
            byteBuffer.putInt(this.LastCookMinute);
        }
        if (this.CookingTime != 0.0f) {
            bitHeaderWrite2.addFlags(4);
            byteBuffer.putFloat(this.CookingTime);
        }
        if (this.Cooked) {
            bitHeaderWrite2.addFlags(8);
        }
        if (this.Burnt) {
            bitHeaderWrite2.addFlags(16);
        }
        if (this.IsCookable) {
            bitHeaderWrite2.addFlags(32);
        }
        if (this.bDangerousUncooked) {
            bitHeaderWrite2.addFlags(64);
        }
        if (this.poisonDetectionLevel != -1) {
            bitHeaderWrite2.addFlags(128);
            byteBuffer.put((byte)this.poisonDetectionLevel);
        }
        if (this.spices != null) {
            bitHeaderWrite2.addFlags(256);
            byteBuffer.put((byte)this.spices.size());
            for (String string : this.spices) {
                GameWindow.WriteString(byteBuffer, string);
            }
        }
        if (this.PoisonPower != 0) {
            bitHeaderWrite2.addFlags(512);
            byteBuffer.put((byte)this.PoisonPower);
        }
        if (this.Chef != null) {
            bitHeaderWrite2.addFlags(1024);
            GameWindow.WriteString(byteBuffer, this.Chef);
        }
        if ((double)this.OffAge != 1.0E9) {
            bitHeaderWrite2.addFlags(2048);
            byteBuffer.putInt(this.OffAge);
        }
        if ((double)this.OffAgeMax != 1.0E9) {
            bitHeaderWrite2.addFlags(4096);
            byteBuffer.putInt(this.OffAgeMax);
        }
        if (this.painReduction != 0.0f) {
            bitHeaderWrite2.addFlags(8192);
            byteBuffer.putFloat(this.painReduction);
        }
        if (this.fluReduction != 0) {
            bitHeaderWrite2.addFlags(16384);
            byteBuffer.putInt(this.fluReduction);
        }
        if (this.ReduceFoodSickness != 0) {
            bitHeaderWrite2.addFlags(32768);
            byteBuffer.putInt(this.ReduceFoodSickness);
        }
        if (this.Poison) {
            bitHeaderWrite2.addFlags(65536);
        }
        if (this.UseForPoison != 0) {
            bitHeaderWrite2.addFlags(131072);
            byteBuffer.putShort((short)this.UseForPoison);
        }
        if (this.freezingTime != 0.0f) {
            bitHeaderWrite2.addFlags(262144);
            byteBuffer.putFloat(this.freezingTime);
        }
        if (this.isFrozen()) {
            bitHeaderWrite2.addFlags(524288);
        }
        if (this.LastFrozenUpdate != 0.0f) {
            bitHeaderWrite2.addFlags(0x100000);
            byteBuffer.putFloat(this.LastFrozenUpdate);
        }
        if (this.rottenTime != 0.0f) {
            bitHeaderWrite2.addFlags(0x200000);
            byteBuffer.putFloat(this.rottenTime);
        }
        if (this.compostTime != 0.0f) {
            bitHeaderWrite2.addFlags(0x400000);
            byteBuffer.putFloat(this.compostTime);
        }
        if (this.cookedInMicrowave) {
            bitHeaderWrite2.addFlags(0x800000);
        }
        if (this.fatigueChange != 0.0f) {
            bitHeaderWrite2.addFlags(0x1000000);
            byteBuffer.putFloat(this.fatigueChange);
        }
        if (this.endChange != 0.0f) {
            bitHeaderWrite2.addFlags(0x2000000);
            byteBuffer.putFloat(this.endChange);
        }
        if (!bitHeaderWrite2.equals(0)) {
            bitHeaderWrite.addFlags(64);
            bitHeaderWrite2.write();
        } else {
            byteBuffer.position(bitHeaderWrite2.getStartPosition());
        }
        bitHeaderWrite.write();
        bitHeaderWrite.release();
        bitHeaderWrite2.release();
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        super.load(byteBuffer, n);
        this.calories = 0.0f;
        this.proteins = 0.0f;
        this.lipids = 0.0f;
        this.carbohydrates = 0.0f;
        this.hungChange = 0.0f;
        this.baseHunger = 0.0f;
        this.unhappyChange = 0.0f;
        this.boredomChange = 0.0f;
        this.thirstChange = 0.0f;
        this.Heat = 1.0f;
        this.LastCookMinute = 0;
        this.CookingTime = 0.0f;
        this.Cooked = false;
        this.Burnt = false;
        this.IsCookable = false;
        this.bDangerousUncooked = false;
        this.poisonDetectionLevel = -1;
        this.spices = null;
        this.PoisonPower = 0;
        this.Chef = null;
        this.OffAge = 1000000000;
        this.OffAgeMax = 1000000000;
        this.painReduction = 0.0f;
        this.fluReduction = 0;
        this.ReduceFoodSickness = 0;
        this.Poison = false;
        this.UseForPoison = 0;
        this.freezingTime = 0.0f;
        this.frozen = false;
        this.LastFrozenUpdate = 0.0f;
        this.rottenTime = 0.0f;
        this.compostTime = 0.0f;
        this.cookedInMicrowave = false;
        this.fatigueChange = 0.0f;
        this.endChange = 0.0f;
        this.Age = byteBuffer.getFloat();
        this.LastAged = byteBuffer.getFloat();
        BitHeaderRead bitHeaderRead = BitHeader.allocRead(BitHeader.HeaderSize.Byte, byteBuffer);
        if (!bitHeaderRead.equals(0)) {
            if (bitHeaderRead.hasFlags(1)) {
                this.calories = byteBuffer.getFloat();
                this.proteins = byteBuffer.getFloat();
                this.lipids = byteBuffer.getFloat();
                this.carbohydrates = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(2)) {
                this.hungChange = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(4)) {
                this.baseHunger = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(8)) {
                this.unhappyChange = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(16)) {
                this.boredomChange = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(32)) {
                this.thirstChange = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(64)) {
                BitHeaderRead bitHeaderRead2 = BitHeader.allocRead(BitHeader.HeaderSize.Integer, byteBuffer);
                if (bitHeaderRead2.hasFlags(1)) {
                    this.Heat = byteBuffer.getFloat();
                }
                if (bitHeaderRead2.hasFlags(2)) {
                    this.LastCookMinute = byteBuffer.getInt();
                }
                if (bitHeaderRead2.hasFlags(4)) {
                    this.CookingTime = byteBuffer.getFloat();
                }
                this.Cooked = bitHeaderRead2.hasFlags(8);
                this.Burnt = bitHeaderRead2.hasFlags(16);
                this.IsCookable = bitHeaderRead2.hasFlags(32);
                this.bDangerousUncooked = bitHeaderRead2.hasFlags(64);
                if (bitHeaderRead2.hasFlags(128)) {
                    this.poisonDetectionLevel = byteBuffer.get();
                }
                if (bitHeaderRead2.hasFlags(256)) {
                    this.spices = new ArrayList();
                    int n2 = byteBuffer.get();
                    for (int i = 0; i < n2; ++i) {
                        String string = GameWindow.ReadString(byteBuffer);
                        this.spices.add(string);
                    }
                }
                if (bitHeaderRead2.hasFlags(512)) {
                    this.PoisonPower = byteBuffer.get();
                }
                if (bitHeaderRead2.hasFlags(1024)) {
                    this.Chef = GameWindow.ReadString(byteBuffer);
                }
                if (bitHeaderRead2.hasFlags(2048)) {
                    this.OffAge = byteBuffer.getInt();
                }
                if (bitHeaderRead2.hasFlags(4096)) {
                    this.OffAgeMax = byteBuffer.getInt();
                }
                if (bitHeaderRead2.hasFlags(8192)) {
                    this.painReduction = byteBuffer.getFloat();
                }
                if (bitHeaderRead2.hasFlags(16384)) {
                    this.fluReduction = byteBuffer.getInt();
                }
                if (bitHeaderRead2.hasFlags(32768)) {
                    this.ReduceFoodSickness = byteBuffer.getInt();
                }
                this.Poison = bitHeaderRead2.hasFlags(65536);
                if (bitHeaderRead2.hasFlags(131072)) {
                    this.UseForPoison = byteBuffer.getShort();
                }
                if (bitHeaderRead2.hasFlags(262144)) {
                    this.freezingTime = byteBuffer.getFloat();
                }
                this.setFrozen(bitHeaderRead2.hasFlags(524288));
                if (bitHeaderRead2.hasFlags(0x100000)) {
                    this.LastFrozenUpdate = byteBuffer.getFloat();
                }
                if (bitHeaderRead2.hasFlags(0x200000)) {
                    this.rottenTime = byteBuffer.getFloat();
                }
                if (bitHeaderRead2.hasFlags(0x400000)) {
                    this.compostTime = byteBuffer.getFloat();
                }
                this.cookedInMicrowave = bitHeaderRead2.hasFlags(0x800000);
                if (bitHeaderRead2.hasFlags(0x1000000)) {
                    this.fatigueChange = byteBuffer.getFloat();
                }
                if (bitHeaderRead2.hasFlags(0x2000000)) {
                    this.endChange = byteBuffer.getFloat();
                }
                bitHeaderRead2.release();
            }
        }
        bitHeaderRead.release();
        if (GameServer.bServer && this.LastAged == -1.0f) {
            this.LastAged = (float)GameTime.getInstance().getWorldAgeHours();
        }
    }

    @Override
    public boolean finishupdate() {
        if (this.container == null && (this.getWorldItem() == null || this.getWorldItem().getSquare() == null)) {
            return true;
        }
        if (this.IsCookable) {
            return false;
        }
        if (this.container != null && (this.Heat != this.container.getTemprature() || this.container.isTemperatureChanging())) {
            return false;
        }
        if (this.isTaintedWater() && this.container != null && this.container.getTemprature() > 1.0f) {
            return false;
        }
        if ((!GameClient.bClient || this.isInLocalPlayerInventory()) && (double)this.OffAgeMax != 1.0E9) {
            if (this.replaceOnRotten != null && !this.replaceOnRotten.isEmpty()) {
                return false;
            }
            if (SandboxOptions.instance.DaysForRottenFoodRemoval.getValue() != -1) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean shouldUpdateInWorld() {
        if (!GameClient.bClient && (double)this.OffAgeMax != 1.0E9) {
            if (this.replaceOnRotten != null && !this.replaceOnRotten.isEmpty()) {
                return true;
            }
            if (SandboxOptions.instance.DaysForRottenFoodRemoval.getValue() != -1) {
                return true;
            }
        }
        return this.getHeat() != 1.0f;
    }

    @Override
    public String getName() {
        Object object = "";
        if (this.Burnt) {
            object = (String)object + this.BurntString + " ";
        } else if (this.OffAge < 1000000000 && this.Age < (float)this.OffAge) {
            object = (String)object + this.FreshString + " ";
        } else if (this.OffAgeMax < 1000000000 && this.Age >= (float)this.OffAgeMax) {
            object = (String)object + this.OffString + " ";
        } else if (this.OffAgeMax < 1000000000 && this.Age >= (float)this.OffAge) {
            object = (String)object + this.StaleString + " ";
        }
        if (this.isCooked() && !this.Burnt && !this.hasTag("HideCooked")) {
            object = (String)object + this.CookedString + " ";
        } else if (this.IsCookable && !this.Burnt && !this.hasTag("HideCooked")) {
            object = (String)object + this.UnCookedString + " ";
        }
        if (this.isFrozen()) {
            object = (String)object + this.FrozenString + " ";
        }
        if (((String)(object = ((String)object).trim())).isEmpty()) {
            return this.name;
        }
        return Translator.getText("IGUI_FoodNaming", object, this.name);
    }

    @Override
    public void DoTooltip(ObjectTooltip objectTooltip, ObjectTooltip.Layout layout) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        int n;
        ObjectTooltip.LayoutItem layoutItem;
        if (this.getHungerChange() != 0.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_food_Hunger") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            n = (int)(this.getHungerChange() * 100.0f);
            layoutItem.setValueRight(n, false);
        }
        if (this.getThirstChange() != 0.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_food_Thirst") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            n = (int)(this.getThirstChange() * 100.0f);
            layoutItem.setValueRight(n, false);
        }
        if (this.getEnduranceChange() != 0.0f) {
            layoutItem = layout.addItem();
            n = (int)(this.getEnduranceChange() * 100.0f);
            layoutItem.setLabel(Translator.getText("Tooltip_food_Endurance") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRight(n, true);
        }
        if (this.getStressChange() != 0.0f) {
            layoutItem = layout.addItem();
            n = (int)(this.getStressChange() * 100.0f);
            layoutItem.setLabel(Translator.getText("Tooltip_food_Stress") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRight(n, false);
        }
        if (this.getBoredomChange() != 0.0f) {
            layoutItem = layout.addItem();
            n = (int)this.getBoredomChange();
            layoutItem.setLabel(Translator.getText("Tooltip_food_Boredom") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRight(n, false);
        }
        if (this.getUnhappyChange() != 0.0f) {
            layoutItem = layout.addItem();
            n = (int)this.getUnhappyChange();
            layoutItem.setLabel(Translator.getText("Tooltip_food_Unhappiness") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRight(n, false);
        }
        if (this.isIsCookable() && !this.isFrozen() && !this.Burnt && (double)this.getHeat() > 1.6) {
            float f7 = this.getCookingTime();
            f6 = this.getMinutesToCook();
            f5 = this.getMinutesToBurn();
            f4 = f7 / f6;
            ColorInfo colorInfo = Core.getInstance().getGoodHighlitedColor();
            f3 = colorInfo.getR();
            f2 = colorInfo.getG();
            f = colorInfo.getB();
            float f8 = 1.0f;
            float f9 = colorInfo.getR();
            float f10 = colorInfo.getG();
            float f11 = colorInfo.getB();
            String string = Translator.getText("IGUI_invpanel_Cooking");
            if (f7 > f6) {
                colorInfo = Core.getInstance().getBadHighlitedColor();
                string = Translator.getText("IGUI_invpanel_Burning");
                f9 = colorInfo.getR();
                f10 = colorInfo.getG();
                f11 = colorInfo.getB();
                f4 = (f7 - f6) / (f5 - f6);
                f3 = colorInfo.getR();
                f2 = colorInfo.getG();
                f = colorInfo.getB();
            }
            layoutItem = layout.addItem();
            layoutItem.setLabel(string + ": ", f9, f10, f11, 1.0f);
            layoutItem.setProgress(f4, f3, f2, f, f8);
        }
        if (this.getFreezingTime() < 100.0f && this.getFreezingTime() > 0.0f) {
            float f12 = this.getFreezingTime() / 100.0f;
            f6 = 0.0f;
            f5 = 0.6f;
            f4 = 0.0f;
            float f13 = 0.7f;
            f3 = 1.0f;
            f2 = 1.0f;
            f = 0.8f;
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("IGUI_invpanel_FreezingTime") + ": ", f3, f2, f, 1.0f);
            layoutItem.setProgress(f12, f6, f5, f4, f13);
        }
        if (Core.bDebug && DebugOptions.instance.TooltipInfo.getValue() || this.isPackaged() || objectTooltip.getCharacter() != null && (objectTooltip.getCharacter().Traits.Nutritionist.isSet() || objectTooltip.getCharacter().Traits.Nutritionist2.isSet())) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_food_Calories") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getCalories());
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_food_Carbs") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getCarbohydrates());
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_food_Prots") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getProteins());
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_food_Fat") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getLipids());
        }
        if (this.isbDangerousUncooked() && !this.isCooked() && !this.isBurnt()) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_food_Dangerous_uncooked"), Core.getInstance().getBadHighlitedColor().getR(), Core.getInstance().getBadHighlitedColor().getG(), Core.getInstance().getBadHighlitedColor().getB(), 1.0f);
            if (this.hasTag("Egg")) {
                layoutItem.setLabel(Translator.getText("Tooltip_food_SlightDanger_uncooked"), 1.0f, 0.0f, 0.0f, 1.0f);
            }
        }
        if (this.getScriptItem().RemoveUnhappinessWhenCooked && !this.isCooked()) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_food_CookToRemoveUnhappiness"), Core.getInstance().getBadHighlitedColor().getR(), Core.getInstance().getBadHighlitedColor().getG(), Core.getInstance().getBadHighlitedColor().getB(), 1.0f);
        }
        if ((this.isGoodHot() || this.isBadCold()) && this.Heat < 1.3f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_food_BetterHot"), 1.0f, 0.9f, 0.9f, 1.0f);
        }
        if (this.cookedInMicrowave) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_food_CookedInMicrowave"), 1.0f, 0.9f, 0.9f, 1.0f);
        }
        if (Core.bDebug && DebugOptions.instance.TooltipInfo.getValue()) {
            layoutItem = layout.addItem();
            layoutItem.setLabel("DBG: BaseHunger", 0.0f, 1.0f, 0.0f, 1.0f);
            layoutItem.setValueRight((int)(this.getBaseHunger() * 100.0f), false);
            layoutItem = layout.addItem();
            layoutItem.setLabel("DBG: Age", 0.0f, 1.0f, 0.0f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getAge() * 24.0f);
            if ((double)this.getOffAgeMax() != 1.0E9) {
                layoutItem = layout.addItem();
                layoutItem.setLabel("DBG: Age Fresh", 0.0f, 1.0f, 0.0f, 1.0f);
                layoutItem.setValueRightNoPlus((float)this.getOffAge() * 24.0f);
                layoutItem = layout.addItem();
                layoutItem.setLabel("DBG: Age Rotten", 0.0f, 1.0f, 0.0f, 1.0f);
                layoutItem.setValueRightNoPlus(this.getOffAgeMax() * 24);
            }
            layoutItem = layout.addItem();
            layoutItem.setLabel("DBG: Heat", 0.0f, 1.0f, 0.0f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getHeat());
            layoutItem = layout.addItem();
            layoutItem.setLabel("DBG: Freeze Time", 0.0f, 1.0f, 0.0f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getFreezingTime());
            layoutItem = layout.addItem();
            layoutItem.setLabel("DBG: Compost Time", 0.0f, 1.0f, 0.0f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getCompostTime());
        }
    }

    public float getEnduranceChange() {
        if (this.Burnt) {
            return this.endChange / 3.0f;
        }
        if (this.Age >= (float)this.OffAge && this.Age < (float)this.OffAgeMax) {
            return this.endChange / 2.0f;
        }
        if (this.isCooked()) {
            return this.endChange * 2.0f;
        }
        return this.endChange;
    }

    public void setEnduranceChange(float f) {
        this.endChange = f;
    }

    @Override
    public float getUnhappyChange() {
        float f = this.unhappyChange;
        Boolean bl = "Icecream".equals(this.getType()) || this.hasTag("GoodFrozen");
        if (this.isFrozen() && !bl.booleanValue()) {
            f += 30.0f;
        }
        if (this.Burnt) {
            f += 20.0f;
        }
        if (this.Age >= (float)this.OffAge && this.Age < (float)this.OffAgeMax) {
            f += 10.0f;
        }
        if (this.Age >= (float)this.OffAgeMax) {
            f += 20.0f;
        }
        if (this.isBadCold() && this.IsCookable && this.isCooked() && this.Heat < 1.3f) {
            f += 2.0f;
        }
        if (this.isGoodHot() && this.IsCookable && this.isCooked() && this.Heat > 1.3f) {
            f -= 2.0f;
        }
        return f;
    }

    @Override
    public float getBoredomChange() {
        float f = this.boredomChange;
        Boolean bl = "Icecream".equals(this.getType()) || this.hasTag("GoodFrozen");
        if (this.isFrozen() && !bl.booleanValue()) {
            f += 30.0f;
        }
        if (this.Burnt) {
            f += 20.0f;
        }
        if (this.Age >= (float)this.OffAge && this.Age < (float)this.OffAgeMax) {
            f += 10.0f;
        }
        if (this.Age >= (float)this.OffAgeMax) {
            f += 20.0f;
        }
        return f;
    }

    public float getHungerChange() {
        float f = this.hungChange;
        if (this.Burnt) {
            return f / 3.0f;
        }
        if (this.Age >= (float)this.OffAge && this.Age < (float)this.OffAgeMax) {
            return f / 1.3f;
        }
        if (this.Age >= (float)this.OffAgeMax) {
            return f / 2.2f;
        }
        if (this.isCooked()) {
            return f * 1.3f;
        }
        return f;
    }

    @Override
    public float getStressChange() {
        if (this.Burnt) {
            return this.stressChange / 4.0f;
        }
        if (this.Age >= (float)this.OffAge && this.Age < (float)this.OffAgeMax) {
            return this.stressChange / 1.3f;
        }
        if (this.Age >= (float)this.OffAgeMax) {
            return this.stressChange / 2.0f;
        }
        if (this.isCooked()) {
            return this.stressChange * 1.3f;
        }
        return this.stressChange;
    }

    public float getBoredomChangeUnmodified() {
        return this.boredomChange;
    }

    public float getEnduranceChangeUnmodified() {
        return this.endChange;
    }

    public float getStressChangeUnmodified() {
        return this.stressChange;
    }

    public float getThirstChangeUnmodified() {
        return this.thirstChange;
    }

    public float getUnhappyChangeUnmodified() {
        return this.unhappyChange;
    }

    @Override
    public float getScore(SurvivorDesc survivorDesc) {
        float f = 0.0f;
        return f -= this.getHungerChange() * 100.0f;
    }

    public boolean isBadCold() {
        return this.bBadCold;
    }

    public void setBadCold(boolean bl) {
        this.bBadCold = bl;
    }

    public boolean isGoodHot() {
        return this.bGoodHot;
    }

    public void setGoodHot(boolean bl) {
        this.bGoodHot = bl;
    }

    public boolean isCookedInMicrowave() {
        return this.cookedInMicrowave;
    }

    public void setCookedInMicrowave(boolean bl) {
        this.cookedInMicrowave = bl;
    }

    public float getHeat() {
        return this.Heat;
    }

    @Override
    public float getInvHeat() {
        if (this.Heat > 1.0f) {
            return (this.Heat - 1.0f) / 2.0f;
        }
        return 1.0f - (this.Heat - 0.2f) / 0.8f;
    }

    public void setHeat(float f) {
        this.Heat = f;
    }

    public float getEndChange() {
        return this.endChange;
    }

    public void setEndChange(float f) {
        this.endChange = f;
    }

    @Deprecated
    public float getBaseHungChange() {
        return this.getHungChange();
    }

    public float getHungChange() {
        return this.hungChange;
    }

    public void setHungChange(float f) {
        this.hungChange = f;
    }

    public String getUseOnConsume() {
        return this.useOnConsume;
    }

    public void setUseOnConsume(String string) {
        this.useOnConsume = string;
    }

    public boolean isRotten() {
        return this.Age >= (float)this.OffAgeMax;
    }

    public boolean isFresh() {
        return this.Age < (float)this.OffAge;
    }

    public void setRotten(boolean bl) {
        this.rotten = bl;
    }

    public boolean isbDangerousUncooked() {
        return this.bDangerousUncooked;
    }

    public void setbDangerousUncooked(boolean bl) {
        this.bDangerousUncooked = bl;
    }

    public int getLastCookMinute() {
        return this.LastCookMinute;
    }

    public void setLastCookMinute(int n) {
        this.LastCookMinute = n;
    }

    public float getThirstChange() {
        float f = this.thirstChange;
        if (this.Burnt) {
            return f / 5.0f;
        }
        if (this.isCooked()) {
            return f / 2.0f;
        }
        return f;
    }

    public void setThirstChange(float f) {
        this.thirstChange = f;
    }

    public void setReplaceOnCooked(List<String> list) {
        this.ReplaceOnCooked = list;
    }

    public List<String> getReplaceOnCooked() {
        return this.ReplaceOnCooked;
    }

    public float getBaseHunger() {
        return this.baseHunger;
    }

    public void setBaseHunger(float f) {
        this.baseHunger = f;
    }

    public boolean isSpice() {
        return this.isSpice;
    }

    public void setSpice(boolean bl) {
        this.isSpice = bl;
    }

    public boolean isPoison() {
        return this.Poison;
    }

    public int getPoisonDetectionLevel() {
        return this.poisonDetectionLevel;
    }

    public void setPoisonDetectionLevel(int n) {
        this.poisonDetectionLevel = n;
    }

    public Integer getPoisonLevelForRecipe() {
        return this.PoisonLevelForRecipe;
    }

    public void setPoisonLevelForRecipe(Integer n) {
        this.PoisonLevelForRecipe = n;
    }

    public int getUseForPoison() {
        return this.UseForPoison;
    }

    public void setUseForPoison(int n) {
        this.UseForPoison = n;
    }

    public int getPoisonPower() {
        return this.PoisonPower;
    }

    public void setPoisonPower(int n) {
        this.PoisonPower = n;
    }

    public String getFoodType() {
        return this.FoodType;
    }

    public void setFoodType(String string) {
        this.FoodType = string;
    }

    public boolean isRemoveNegativeEffectOnCooked() {
        return this.RemoveNegativeEffectOnCooked;
    }

    public void setRemoveNegativeEffectOnCooked(boolean bl) {
        this.RemoveNegativeEffectOnCooked = bl;
    }

    public String getCookingSound() {
        return this.getScriptItem().getCookingSound();
    }

    public String getCustomEatSound() {
        return this.CustomEatSound;
    }

    public void setCustomEatSound(String string) {
        this.CustomEatSound = string;
    }

    public String getChef() {
        return this.Chef;
    }

    public void setChef(String string) {
        this.Chef = string;
    }

    public String getOnCooked() {
        return this.OnCooked;
    }

    public void setOnCooked(String string) {
        this.OnCooked = string;
    }

    public String getHerbalistType() {
        return this.HerbalistType;
    }

    public void setHerbalistType(String string) {
        this.HerbalistType = string;
    }

    public ArrayList<String> getSpices() {
        return this.spices;
    }

    public void setSpices(ArrayList<String> arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            if (this.spices != null) {
                this.spices.clear();
            }
            return;
        }
        if (this.spices == null) {
            this.spices = new ArrayList<String>(arrayList);
        } else {
            this.spices.clear();
            this.spices.addAll(arrayList);
        }
    }

    @Override
    public Texture getTex() {
        if (this.Burnt) {
            return this.textureBurnt;
        }
        if (this.Age >= (float)this.OffAgeMax) {
            return this.texturerotten;
        }
        if (this.isCooked()) {
            return this.textureCooked;
        }
        return super.getTex();
    }

    @Override
    public String getWorldTexture() {
        if (this.Burnt) {
            return this.WorldTextureOverdone;
        }
        if (this.Age >= (float)this.OffAgeMax) {
            return this.WorldTextureRotten;
        }
        if (this.isCooked()) {
            return this.WorldTextureCooked;
        }
        return this.WorldTexture;
    }

    public int getReduceFoodSickness() {
        return this.ReduceFoodSickness;
    }

    public void setReduceFoodSickness(int n) {
        this.ReduceFoodSickness = n;
    }

    public int getFluReduction() {
        return this.fluReduction;
    }

    public void setFluReduction(int n) {
        this.fluReduction = n;
    }

    public float getPainReduction() {
        return this.painReduction;
    }

    public void setPainReduction(float f) {
        this.painReduction = f;
    }

    public float getCarbohydrates() {
        return this.carbohydrates;
    }

    public void setCarbohydrates(float f) {
        this.carbohydrates = f;
    }

    public float getLipids() {
        return this.lipids;
    }

    public void setLipids(float f) {
        this.lipids = f;
    }

    public float getProteins() {
        return this.proteins;
    }

    public void setProteins(float f) {
        this.proteins = f;
    }

    public float getCalories() {
        return this.calories;
    }

    public void setCalories(float f) {
        this.calories = f;
    }

    public boolean isPackaged() {
        return this.packaged;
    }

    public void setPackaged(boolean bl) {
        this.packaged = bl;
    }

    public float getFreezingTime() {
        return this.freezingTime;
    }

    public void setFreezingTime(float f) {
        if (f >= 100.0f) {
            this.setFrozen(true);
            f = 100.0f;
        } else if (f <= 0.0f) {
            f = 0.0f;
            this.setFrozen(false);
        }
        this.freezingTime = f;
    }

    public void freeze() {
        this.setFreezingTime(100.0f);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean bl) {
        this.frozen = bl;
    }

    public boolean canBeFrozen() {
        return this.canBeFrozen;
    }

    public void setCanBeFrozen(boolean bl) {
        this.canBeFrozen = bl;
    }

    public boolean isFreezing() {
        if (!this.canBeFrozen() || this.getFreezingTime() >= 100.0f || this.getOutermostContainer() == null || !"freezer".equals(this.getOutermostContainer().getType())) {
            return false;
        }
        return this.getOutermostContainer().isPowered();
    }

    public boolean isThawing() {
        if (!this.canBeFrozen() || this.getFreezingTime() <= 0.0f) {
            return false;
        }
        if (this.getOutermostContainer() == null || !"freezer".equals(this.getOutermostContainer().getType())) {
            return true;
        }
        return !this.getOutermostContainer().isPowered();
    }

    public String getReplaceOnRotten() {
        return this.replaceOnRotten;
    }

    public void setReplaceOnRotten(String string) {
        this.replaceOnRotten = string;
    }

    public void multiplyFoodValues(float f) {
        this.setBoredomChange(this.getBoredomChangeUnmodified() * f);
        this.setUnhappyChange(this.getUnhappyChangeUnmodified() * f);
        this.setHungChange(this.getHungChange() * f);
        this.setFluReduction((int)((float)this.getFluReduction() * f));
        this.setThirstChange(this.getThirstChangeUnmodified() * f);
        this.setPainReduction(this.getPainReduction() * f);
        this.setReduceFoodSickness((int)((float)this.getReduceFoodSickness() * f));
        this.setEndChange(this.getEnduranceChangeUnmodified() * f);
        this.setStressChange(this.getStressChangeUnmodified() * f);
        this.setFatigueChange(this.getFatigueChange() * f);
        this.setCalories(this.getCalories() * f);
        this.setCarbohydrates(this.getCarbohydrates() * f);
        this.setProteins(this.getProteins() * f);
        this.setLipids(this.getLipids() * f);
    }

    public float getRottenTime() {
        return this.rottenTime;
    }

    public void setRottenTime(float f) {
        this.rottenTime = f;
    }

    public float getCompostTime() {
        return this.compostTime;
    }

    public void setCompostTime(float f) {
        this.compostTime = f;
    }

    public String getOnEat() {
        return this.onEat;
    }

    public void setOnEat(String string) {
        this.onEat = string;
    }

    public boolean isBadInMicrowave() {
        return this.badInMicrowave;
    }

    public void setBadInMicrowave(boolean bl) {
        this.badInMicrowave = bl;
    }

    private void destroyThisItem() {
        IsoWorldInventoryObject isoWorldInventoryObject = this.getWorldItem();
        if (isoWorldInventoryObject != null && isoWorldInventoryObject.getSquare() != null) {
            if (GameServer.bServer) {
                GameServer.RemoveItemFromMap(isoWorldInventoryObject);
            } else {
                isoWorldInventoryObject.removeFromWorld();
                isoWorldInventoryObject.removeFromSquare();
            }
            this.setWorldItem(null);
        } else if (this.container != null) {
            IsoObject isoObject = this.container.getParent();
            if (GameServer.bServer) {
                if (!this.isInPlayerInventory()) {
                    GameServer.sendRemoveItemFromContainer(this.container, this);
                }
                this.container.Remove(this);
            } else {
                this.container.Remove(this);
            }
            IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this);
            LuaManager.updateOverlaySprite(isoObject);
        }
        if (!GameServer.bServer) {
            LuaEventManager.triggerEvent("OnContainerUpdate");
        }
    }
}

