/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characterTextures.BloodClothingType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.WornItems.WornItem;
import zombie.characters.WornItems.WornItems;
import zombie.characters.skills.PerkFactory;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.debug.DebugOptions;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoClothingDryer;
import zombie.iso.objects.IsoClothingWasher;
import zombie.iso.objects.IsoCombinationWasherDryer;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameClient;
import zombie.scripting.objects.Item;
import zombie.ui.ObjectTooltip;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.io.BitHeader;
import zombie.util.io.BitHeaderRead;
import zombie.util.io.BitHeaderWrite;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehiclePart;
import zombie.vehicles.VehicleWindow;

public class Clothing
extends InventoryItem {
    private float temperature;
    private float insulation = 0.0f;
    private float windresistance = 0.0f;
    private float waterResistance = 0.0f;
    HashMap<Integer, ClothingPatch> patches;
    protected String SpriteName = null;
    protected String palette;
    public float bloodLevel = 0.0f;
    private float dirtyness = 0.0f;
    private float wetness = 0.0f;
    private float WeightWet = 0.0f;
    private float lastWetnessUpdate = -1.0f;
    private final String dirtyString = Translator.getText("IGUI_ClothingName_Dirty");
    private final String bloodyString = Translator.getText("IGUI_ClothingName_Bloody");
    private final String wetString = Translator.getText("IGUI_ClothingName_Wet");
    private final String soakedString = Translator.getText("IGUI_ClothingName_Soaked");
    private final String wornString = Translator.getText("IGUI_ClothingName_Worn");
    private int ConditionLowerChance = 10000;
    private float stompPower = 1.0f;
    private float runSpeedModifier = 1.0f;
    private float combatSpeedModifier = 1.0f;
    private Boolean removeOnBroken = false;
    private Boolean canHaveHoles = true;
    private float biteDefense = 0.0f;
    private float scratchDefense = 0.0f;
    private float bulletDefense = 0.0f;
    public static final int CONDITION_PER_HOLES = 3;
    private float neckProtectionModifier = 1.0f;
    private int chanceToFall = 0;

    @Override
    public String getCategory() {
        if (this.mainCategory != null) {
            return this.mainCategory;
        }
        return "Clothing";
    }

    public Clothing(String string, String string2, String string3, String string4, String string5, String string6) {
        super(string, string2, string3, string4);
        this.SpriteName = string6;
        this.col = new Color(Rand.Next(255), Rand.Next(255), Rand.Next(255));
        this.palette = string5;
    }

    public Clothing(String string, String string2, String string3, Item item, String string4, String string5) {
        super(string, string2, string3, item);
        this.SpriteName = string5;
        this.col = new Color(Rand.Next(255), Rand.Next(255), Rand.Next(255));
        this.palette = string4;
    }

    @Override
    public boolean IsClothing() {
        return true;
    }

    @Override
    public int getSaveType() {
        return Item.Type.Clothing.ordinal();
    }

    public void Unwear() {
        if (this.container != null && this.container.parent instanceof IsoGameCharacter) {
            IsoGameCharacter isoGameCharacter = (IsoGameCharacter)this.container.parent;
            isoGameCharacter.removeWornItem(this);
            if (isoGameCharacter instanceof IsoPlayer) {
                LuaEventManager.triggerEvent("OnClothingUpdated", isoGameCharacter);
            }
            IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this);
        }
    }

    @Override
    public void DoTooltip(ObjectTooltip objectTooltip, ObjectTooltip.Layout layout) {
        float f;
        ObjectTooltip.LayoutItem layoutItem;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 0.8f;
        float f5 = 1.0f;
        float f6 = 0.0f;
        float f7 = 0.6f;
        float f8 = 0.0f;
        float f9 = 0.7f;
        if (!this.isCosmetic()) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Condition") + ":", f2, f3, f4, f5);
            f = (float)this.Condition / (float)this.ConditionMax;
            layoutItem.setProgress(f, f6, f7, f8, f9);
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_item_Insulation") + ": ", 1.0f, 1.0f, 0.8f, 1.0f);
            f = this.getInsulation();
            if (f > 0.8f) {
                layoutItem.setProgress(f, 0.0f, 0.6f, 0.0f, 0.7f);
            } else if (f > 0.6f) {
                layoutItem.setProgress(f, 0.3f, 0.6f, 0.0f, 0.7f);
            } else if (f > 0.4f) {
                layoutItem.setProgress(f, 0.6f, 0.6f, 0.0f, 0.7f);
            } else if (f > 0.2f) {
                layoutItem.setProgress(f, 0.6f, 0.3f, 0.0f, 0.7f);
            } else {
                layoutItem.setProgress(f, 0.6f, 0.0f, 0.0f, 0.7f);
            }
            f = this.getWindresistance();
            if (f > 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_item_Windresist") + ": ", 1.0f, 1.0f, 0.8f, 1.0f);
                if (f > 0.8f) {
                    layoutItem.setProgress(f, 0.0f, 0.6f, 0.0f, 0.7f);
                } else if (f > 0.6f) {
                    layoutItem.setProgress(f, 0.3f, 0.6f, 0.0f, 0.7f);
                } else if (f > 0.4f) {
                    layoutItem.setProgress(f, 0.6f, 0.6f, 0.0f, 0.7f);
                } else if (f > 0.2f) {
                    layoutItem.setProgress(f, 0.6f, 0.3f, 0.0f, 0.7f);
                } else {
                    layoutItem.setProgress(f, 0.6f, 0.0f, 0.0f, 0.7f);
                }
            }
            if ((f = this.getWaterResistance()) > 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_item_Waterresist") + ": ", 1.0f, 1.0f, 0.8f, 1.0f);
                if (f > 0.8f) {
                    layoutItem.setProgress(f, 0.0f, 0.6f, 0.0f, 0.7f);
                } else if (f > 0.6f) {
                    layoutItem.setProgress(f, 0.3f, 0.6f, 0.0f, 0.7f);
                } else if (f > 0.4f) {
                    layoutItem.setProgress(f, 0.6f, 0.6f, 0.0f, 0.7f);
                } else if (f > 0.2f) {
                    layoutItem.setProgress(f, 0.6f, 0.3f, 0.0f, 0.7f);
                } else {
                    layoutItem.setProgress(f, 0.6f, 0.0f, 0.0f, 0.7f);
                }
            }
        }
        if (this.bloodLevel != 0.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_clothing_bloody") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            f = this.bloodLevel / 100.0f;
            layoutItem.setProgress(f, f6, f7, f8, f9);
        }
        if (this.dirtyness >= 1.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_clothing_dirty") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            f = this.dirtyness / 100.0f;
            layoutItem.setProgress(f, f6, f7, f8, f9);
        }
        if (this.wetness != 0.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_clothing_wet") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            f = this.wetness / 100.0f;
            layoutItem.setProgress(f, f6, f7, f8, f9);
        }
        int n = 0;
        ItemVisual itemVisual = this.getVisual();
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            if (!(itemVisual.getHole(BloodBodyPartType.FromIndex(i)) > 0.0f)) continue;
            ++n;
        }
        if (n > 0) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_clothing_holes") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(n);
        }
        if (!this.isEquipped() && objectTooltip.getCharacter() != null) {
            float f10;
            float f11;
            float f12 = 0.0f;
            float f13 = 0.0f;
            float f14 = 0.0f;
            WornItems wornItems = objectTooltip.getCharacter().getWornItems();
            for (int i = 0; i < wornItems.size(); ++i) {
                WornItem wornItem = wornItems.get(i);
                if (!this.getBodyLocation().equals(wornItem.getLocation()) && !wornItems.getBodyLocationGroup().isExclusive(this.getBodyLocation(), wornItem.getLocation())) continue;
                f12 += ((Clothing)wornItem.getItem()).getBiteDefense();
                f13 += ((Clothing)wornItem.getItem()).getScratchDefense();
                f14 += ((Clothing)wornItem.getItem()).getBulletDefense();
            }
            float f15 = this.getBiteDefense();
            if (f15 != f12) {
                layoutItem = layout.addItem();
                if (f15 > 0.0f || f12 > 0.0f) {
                    layoutItem.setLabel(Translator.getText("Tooltip_BiteDefense") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                    if (f15 > f12) {
                        layoutItem.setValue((int)f15 + " (+" + (int)(f15 - f12) + ")", 0.0f, 1.0f, 0.0f, 1.0f);
                    } else {
                        layoutItem.setValue((int)f15 + " (-" + (int)(f12 - f15) + ")", 1.0f, 0.0f, 0.0f, 1.0f);
                    }
                }
            } else if (this.getBiteDefense() != 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_BiteDefense") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValueRightNoPlus((int)this.getBiteDefense());
            }
            if ((f11 = this.getScratchDefense()) != f13) {
                layoutItem = layout.addItem();
                if (f11 > 0.0f || f13 > 0.0f) {
                    layoutItem.setLabel(Translator.getText("Tooltip_ScratchDefense") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                    if (f11 > f13) {
                        layoutItem.setValue((int)f11 + " (+" + (int)(f11 - f13) + ")", 0.0f, 1.0f, 0.0f, 1.0f);
                    } else {
                        layoutItem.setValue((int)f11 + " (-" + (int)(f13 - f11) + ")", 1.0f, 0.0f, 0.0f, 1.0f);
                    }
                }
            } else if (this.getScratchDefense() != 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_ScratchDefense") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValueRightNoPlus((int)this.getScratchDefense());
            }
            if ((f10 = this.getBulletDefense()) != f14) {
                layoutItem = layout.addItem();
                if (f10 > 0.0f || f14 > 0.0f) {
                    layoutItem.setLabel(Translator.getText("Tooltip_BulletDefense") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                    if (f10 > f14) {
                        layoutItem.setValue((int)f10 + " (+" + (int)(f10 - f14) + ")", 0.0f, 1.0f, 0.0f, 1.0f);
                    } else {
                        layoutItem.setValue((int)f10 + " (-" + (int)(f14 - f10) + ")", 1.0f, 0.0f, 0.0f, 1.0f);
                    }
                }
            } else if (this.getBulletDefense() != 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_BulletDefense") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValueRightNoPlus((int)this.getBulletDefense());
            }
        } else {
            if (this.getBiteDefense() != 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_BiteDefense") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValueRightNoPlus((int)this.getBiteDefense());
            }
            if (this.getScratchDefense() != 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_ScratchDefense") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValueRightNoPlus((int)this.getScratchDefense());
            }
            if (this.getBulletDefense() != 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_BulletDefense") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValueRightNoPlus((int)this.getBulletDefense());
            }
        }
        if (this.getRunSpeedModifier() != 1.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_RunSpeedModifier") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getRunSpeedModifier());
        }
        if (this.getCombatSpeedModifier() != 1.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_CombatSpeedModifier") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getCombatSpeedModifier());
        }
        if (Core.bDebug && DebugOptions.instance.TooltipInfo.getValue()) {
            if (this.bloodLevel != 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel("DBG: bloodLevel:", 1.0f, 1.0f, 0.8f, 1.0f);
                int n2 = (int)Math.ceil(this.bloodLevel);
                layoutItem.setValueRight(n2, false);
            }
            if (this.dirtyness != 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel("DBG: dirtyness:", 1.0f, 1.0f, 0.8f, 1.0f);
                int n3 = (int)Math.ceil(this.dirtyness);
                layoutItem.setValueRight(n3, false);
            }
            if (this.wetness != 0.0f) {
                layoutItem = layout.addItem();
                layoutItem.setLabel("DBG: wetness:", 1.0f, 1.0f, 0.8f, 1.0f);
                int n4 = (int)Math.ceil(this.wetness);
                layoutItem.setValueRight(n4, false);
            }
        }
    }

    public boolean isDirty() {
        return this.dirtyness > 15.0f;
    }

    public boolean isBloody() {
        return this.bloodLevel > 25.0f;
    }

    @Override
    public String getName() {
        Object object = "";
        if (this.isDirty()) {
            object = (String)object + this.dirtyString + ", ";
        }
        if (this.isBloody()) {
            object = (String)object + this.bloodyString + ", ";
        }
        if (this.getWetness() >= 100.0f) {
            object = (String)object + this.soakedString + ", ";
        } else if (this.getWetness() > 25.0f) {
            object = (String)object + this.wetString + ", ";
        }
        if (this.getCondition() < this.getConditionMax() / 3) {
            object = (String)object + this.wornString + ", ";
        }
        if (((String)object).length() > 2) {
            object = ((String)object).substring(0, ((String)object).length() - 2);
        }
        if (((String)(object = ((String)object).trim())).isEmpty()) {
            return this.name;
        }
        return Translator.getText("IGUI_ClothingNaming", object, this.name);
    }

    @Override
    public void update() {
        if (this.container == null || SandboxOptions.instance.ClothingDegradation.getValue() == 1) {
            return;
        }
    }

    public void updateWetness() {
        this.updateWetness(false);
    }

    public void updateWetness(boolean bl) {
        if (!bl && this.isEquipped()) {
            return;
        }
        if (this.getBloodClothingType() == null) {
            this.setWetness(0.0f);
            return;
        }
        float f = (float)GameTime.getInstance().getWorldAgeHours();
        if (this.lastWetnessUpdate < 0.0f) {
            this.lastWetnessUpdate = f;
        } else if (this.lastWetnessUpdate > f) {
            this.lastWetnessUpdate = f;
        }
        float f2 = f - this.lastWetnessUpdate;
        if (f2 < 0.016666668f) {
            return;
        }
        this.lastWetnessUpdate = f;
        switch (this.getWetDryState()) {
            case Invalid: {
                break;
            }
            case Dryer: {
                if (!(this.getWetness() > 0.0f)) break;
                float f3 = f2 * 20.0f;
                if (this.isEquipped()) {
                    f3 *= 2.0f;
                }
                this.setWetness(this.getWetness() - f3);
                break;
            }
            case Wetter: {
                if (!(this.getWetness() < 100.0f)) break;
                float f4 = ClimateManager.getInstance().getRainIntensity();
                if (f4 < 0.1f) {
                    f4 = 0.0f;
                }
                float f5 = f4 * f2 * 100.0f;
                this.setWetness(this.getWetness() + f5);
            }
        }
    }

    public float getBulletDefense() {
        return this.bulletDefense;
    }

    public void setBulletDefense(float f) {
        this.bulletDefense = f;
    }

    private WetDryState getWetDryState() {
        if (this.getWorldItem() == null) {
            if (this.container == null) {
                return WetDryState.Invalid;
            }
            if (this.container.parent instanceof IsoDeadBody) {
                IsoDeadBody isoDeadBody = (IsoDeadBody)this.container.parent;
                if (isoDeadBody.getSquare() == null) {
                    return WetDryState.Invalid;
                }
                if (isoDeadBody.getSquare().isInARoom()) {
                    return WetDryState.Dryer;
                }
                if (ClimateManager.getInstance().isRaining()) {
                    return WetDryState.Wetter;
                }
                return WetDryState.Dryer;
            }
            if (this.container.parent instanceof IsoGameCharacter) {
                IsoGameCharacter isoGameCharacter = (IsoGameCharacter)this.container.parent;
                if (isoGameCharacter.getCurrentSquare() == null) {
                    return WetDryState.Invalid;
                }
                if (isoGameCharacter.getCurrentSquare().isInARoom() || isoGameCharacter.getCurrentSquare().haveRoof) {
                    return WetDryState.Dryer;
                }
                if (ClimateManager.getInstance().isRaining()) {
                    VehicleWindow vehicleWindow;
                    VehiclePart vehiclePart;
                    if (!this.isEquipped()) {
                        return WetDryState.Dryer;
                    }
                    if (isoGameCharacter.isAsleep() && isoGameCharacter.getBed() != null && "Tent".equals(isoGameCharacter.getBed().getName())) {
                        return WetDryState.Dryer;
                    }
                    BaseVehicle baseVehicle = isoGameCharacter.getVehicle();
                    if (baseVehicle != null && baseVehicle.hasRoof(baseVehicle.getSeat(isoGameCharacter)) && (vehiclePart = baseVehicle.getPartById("Windshield")) != null && (vehicleWindow = vehiclePart.getWindow()) != null && vehicleWindow.isHittable()) {
                        return WetDryState.Dryer;
                    }
                    return WetDryState.Wetter;
                }
                return WetDryState.Dryer;
            }
            if (this.container.parent == null) {
                return WetDryState.Dryer;
            }
            if (this.container.parent instanceof IsoClothingDryer && ((IsoClothingDryer)this.container.parent).isActivated()) {
                return WetDryState.Invalid;
            }
            if (this.container.parent instanceof IsoClothingWasher && ((IsoClothingWasher)this.container.parent).isActivated()) {
                return WetDryState.Invalid;
            }
            IsoCombinationWasherDryer isoCombinationWasherDryer = Type.tryCastTo(this.container.parent, IsoCombinationWasherDryer.class);
            if (isoCombinationWasherDryer != null && isoCombinationWasherDryer.isActivated()) {
                return WetDryState.Invalid;
            }
            return WetDryState.Dryer;
        }
        if (this.getWorldItem().getSquare() == null) {
            return WetDryState.Invalid;
        }
        if (this.getWorldItem().getSquare().isInARoom()) {
            return WetDryState.Dryer;
        }
        if (ClimateManager.getInstance().isRaining()) {
            return WetDryState.Wetter;
        }
        return WetDryState.Dryer;
    }

    public void flushWetness() {
        if (this.lastWetnessUpdate < 0.0f) {
            return;
        }
        this.updateWetness(true);
        this.lastWetnessUpdate = -1.0f;
    }

    @Override
    public boolean finishupdate() {
        if (this.container == null || !(this.container.parent instanceof IsoGameCharacter)) {
            return true;
        }
        return !this.isEquipped();
    }

    @Override
    public void Use(boolean bl, boolean bl2) {
        if (this.uses <= 1) {
            this.Unwear();
        }
        super.Use(bl, bl2);
    }

    @Override
    public boolean CanStack(InventoryItem inventoryItem) {
        return this.ModDataMatches(inventoryItem) && this.palette == null && ((Clothing)inventoryItem).palette == null || this.palette.equals(((Clothing)inventoryItem).palette);
    }

    public static Clothing CreateFromSprite(String string) {
        try {
            Clothing clothing = null;
            clothing = (Clothing)InventoryItemFactory.CreateItem(string, 1.0f);
            return clothing;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            return null;
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        BitHeaderWrite bitHeaderWrite = BitHeader.allocWrite(BitHeader.HeaderSize.Byte, byteBuffer);
        if (this.getSpriteName() != null) {
            bitHeaderWrite.addFlags(1);
            GameWindow.WriteString(byteBuffer, this.getSpriteName());
        }
        if (this.dirtyness != 0.0f) {
            bitHeaderWrite.addFlags(2);
            byteBuffer.putFloat(this.dirtyness);
        }
        if (this.bloodLevel != 0.0f) {
            bitHeaderWrite.addFlags(4);
            byteBuffer.putFloat(this.bloodLevel);
        }
        if (this.wetness != 0.0f) {
            bitHeaderWrite.addFlags(8);
            byteBuffer.putFloat(this.wetness);
        }
        if (this.lastWetnessUpdate != 0.0f) {
            bitHeaderWrite.addFlags(16);
            byteBuffer.putFloat(this.lastWetnessUpdate);
        }
        if (this.patches != null) {
            bitHeaderWrite.addFlags(32);
            byteBuffer.put((byte)this.patches.size());
            for (int n : this.patches.keySet()) {
                byteBuffer.put((byte)n);
                this.patches.get(n).save(byteBuffer, false);
            }
        }
        bitHeaderWrite.write();
        bitHeaderWrite.release();
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        super.load(byteBuffer, n);
        BitHeaderRead bitHeaderRead = BitHeader.allocRead(BitHeader.HeaderSize.Byte, byteBuffer);
        if (!bitHeaderRead.equals(0)) {
            if (bitHeaderRead.hasFlags(1)) {
                this.setSpriteName(GameWindow.ReadString(byteBuffer));
            }
            if (bitHeaderRead.hasFlags(2)) {
                this.dirtyness = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(4)) {
                this.bloodLevel = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(8)) {
                this.wetness = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(16)) {
                this.lastWetnessUpdate = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(32)) {
                int n2 = byteBuffer.get();
                for (int i = 0; i < n2; ++i) {
                    byte by = byteBuffer.get();
                    ClothingPatch clothingPatch = new ClothingPatch();
                    clothingPatch.load(byteBuffer, n);
                    if (this.patches == null) {
                        this.patches = new HashMap();
                    }
                    this.patches.put(Integer.valueOf(by), clothingPatch);
                }
            }
        }
        bitHeaderRead.release();
        this.synchWithVisual();
    }

    public String getSpriteName() {
        return this.SpriteName;
    }

    public void setSpriteName(String string) {
        this.SpriteName = string;
    }

    public String getPalette() {
        if (this.palette == null) {
            return "Trousers_White";
        }
        return this.palette;
    }

    public void setPalette(String string) {
        this.palette = string;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float f) {
        this.temperature = f;
    }

    public void setDirtyness(float f) {
        this.dirtyness = PZMath.clamp(f, 0.0f, 100.0f);
    }

    public void setBloodLevel(float f) {
        this.bloodLevel = PZMath.clamp(f, 0.0f, 100.0f);
    }

    public float getDirtyness() {
        return this.dirtyness;
    }

    public float getBloodlevel() {
        return this.bloodLevel;
    }

    public float getBloodlevelForPart(BloodBodyPartType bloodBodyPartType) {
        return this.getVisual().getBlood(bloodBodyPartType);
    }

    public float getBloodLevel() {
        return this.bloodLevel;
    }

    public float getBloodLevelForPart(BloodBodyPartType bloodBodyPartType) {
        return this.getVisual().getBlood(bloodBodyPartType);
    }

    @Override
    public float getWeight() {
        float f = this.getActualWeight();
        float f2 = this.getWeightWet();
        if (f2 <= 0.0f) {
            f2 = f * 1.25f;
        }
        return PZMath.lerp(f, f2, this.getWetness() / 100.0f);
    }

    public void setWetness(float f) {
        this.wetness = PZMath.clamp(f, 0.0f, 100.0f);
    }

    public float getWetness() {
        return this.wetness;
    }

    public float getWeightWet() {
        return this.WeightWet;
    }

    public void setWeightWet(float f) {
        this.WeightWet = f;
    }

    public int getConditionLowerChance() {
        return this.ConditionLowerChance;
    }

    public void setConditionLowerChance(int n) {
        this.ConditionLowerChance = n;
    }

    @Override
    public void setCondition(int n) {
        this.setCondition(n, true);
        if (n <= 0) {
            this.Unwear();
            if (this.getContainer() != null) {
                this.getContainer().setDrawDirty(true);
            }
            if (this.isRemoveOnBroken().booleanValue() && this.getContainer() != null) {
                this.container.Remove(this);
            }
        }
    }

    public float getClothingDirtynessIncreaseLevel() {
        if (SandboxOptions.instance.ClothingDegradation.getValue() == 2) {
            return 2.5E-4f;
        }
        if (SandboxOptions.instance.ClothingDegradation.getValue() == 4) {
            return 0.025f;
        }
        return 0.0025f;
    }

    public float getInsulation() {
        return this.insulation;
    }

    public void setInsulation(float f) {
        this.insulation = f;
    }

    public float getStompPower() {
        return this.stompPower;
    }

    public void setStompPower(float f) {
        this.stompPower = f;
    }

    public float getRunSpeedModifier() {
        return this.runSpeedModifier;
    }

    public void setRunSpeedModifier(float f) {
        this.runSpeedModifier = f;
    }

    public float getCombatSpeedModifier() {
        return this.combatSpeedModifier;
    }

    public void setCombatSpeedModifier(float f) {
        this.combatSpeedModifier = f;
    }

    public Boolean isRemoveOnBroken() {
        return this.removeOnBroken;
    }

    public void setRemoveOnBroken(Boolean bl) {
        this.removeOnBroken = bl;
    }

    public Boolean getCanHaveHoles() {
        return this.canHaveHoles;
    }

    public void setCanHaveHoles(Boolean bl) {
        this.canHaveHoles = bl;
    }

    public boolean isCosmetic() {
        return this.getScriptItem().isCosmetic();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ clothingItemName=\"" + this.getClothingItemName() + "\" }";
    }

    public float getBiteDefense() {
        if (this.getCondition() <= 0) {
            return 0.0f;
        }
        return this.biteDefense;
    }

    public void setBiteDefense(float f) {
        this.biteDefense = f;
    }

    public float getScratchDefense() {
        if (this.getCondition() <= 0) {
            return 0.0f;
        }
        return this.scratchDefense;
    }

    public void setScratchDefense(float f) {
        this.scratchDefense = f;
    }

    public float getNeckProtectionModifier() {
        return this.neckProtectionModifier;
    }

    public void setNeckProtectionModifier(float f) {
        this.neckProtectionModifier = f;
    }

    public int getChanceToFall() {
        return this.chanceToFall;
    }

    public void setChanceToFall(int n) {
        this.chanceToFall = n;
    }

    public float getWindresistance() {
        return this.windresistance;
    }

    public void setWindresistance(float f) {
        this.windresistance = f;
    }

    public float getWaterResistance() {
        return this.waterResistance;
    }

    public void setWaterResistance(float f) {
        this.waterResistance = f;
    }

    public int getHolesNumber() {
        if (this.getVisual() != null) {
            return this.getVisual().getHolesNumber();
        }
        return 0;
    }

    public int getPatchesNumber() {
        return this.patches.size();
    }

    public float getDefForPart(BloodBodyPartType bloodBodyPartType, boolean bl, boolean bl2) {
        if (this.getVisual().getHole(bloodBodyPartType) > 0.0f) {
            return 0.0f;
        }
        ClothingPatch clothingPatch = this.getPatchType(bloodBodyPartType);
        float f = this.getScratchDefense();
        if (bl) {
            f = this.getBiteDefense();
        }
        if (bl2) {
            f = this.getBulletDefense();
        }
        if (bloodBodyPartType == BloodBodyPartType.Neck && this.getScriptItem().neckProtectionModifier < 1.0f) {
            f *= this.getScriptItem().neckProtectionModifier;
        }
        if (clothingPatch != null) {
            int n = clothingPatch.scratchDefense;
            if (bl) {
                n = clothingPatch.biteDefense;
            }
            if (bl2) {
                n = clothingPatch.biteDefense;
            }
            f = !clothingPatch.hasHole ? (f += (float)n) : (float)n;
        }
        return f;
    }

    public static int getBiteDefenseFromItem(IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem) {
        int n = Math.max(1, isoGameCharacter.getPerkLevel(PerkFactory.Perks.Tailoring));
        ClothingPatchFabricType clothingPatchFabricType = ClothingPatchFabricType.fromType(inventoryItem.getFabricType());
        if (clothingPatchFabricType.maxBiteDef > 0) {
            return (int)Math.max(1.0f, (float)clothingPatchFabricType.maxBiteDef * ((float)n / 10.0f));
        }
        return 0;
    }

    public static int getScratchDefenseFromItem(IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem) {
        int n = Math.max(1, isoGameCharacter.getPerkLevel(PerkFactory.Perks.Tailoring));
        ClothingPatchFabricType clothingPatchFabricType = ClothingPatchFabricType.fromType(inventoryItem.getFabricType());
        return (int)Math.max(1.0f, (float)clothingPatchFabricType.maxScratchDef * ((float)n / 10.0f));
    }

    public ClothingPatch getPatchType(BloodBodyPartType bloodBodyPartType) {
        if (this.patches != null) {
            return this.patches.get(bloodBodyPartType.index());
        }
        return null;
    }

    public void removePatch(BloodBodyPartType bloodBodyPartType) {
        if (this.patches == null) {
            return;
        }
        this.getVisual().removePatch(bloodBodyPartType.index());
        ClothingPatch clothingPatch = this.patches.get(bloodBodyPartType.index());
        if (clothingPatch != null && clothingPatch.hasHole) {
            this.getVisual().setHole(bloodBodyPartType);
            this.setCondition(this.getCondition() - clothingPatch.conditionGain);
        }
        this.patches.remove(bloodBodyPartType.index());
        if (GameClient.bClient && this.getContainer() != null && this.getContainer().getParent() instanceof IsoPlayer) {
            GameClient.instance.sendClothing((IsoPlayer)this.getContainer().getParent(), "", null);
        }
    }

    public boolean canFullyRestore(IsoGameCharacter isoGameCharacter, BloodBodyPartType bloodBodyPartType, InventoryItem inventoryItem) {
        return isoGameCharacter.getPerkLevel(PerkFactory.Perks.Tailoring) > 7 && inventoryItem.getFabricType().equals(this.getFabricType()) && this.getVisual().getHole(bloodBodyPartType) > 0.0f;
    }

    public void addPatch(IsoGameCharacter isoGameCharacter, BloodBodyPartType bloodBodyPartType, InventoryItem inventoryItem) {
        ClothingPatchFabricType clothingPatchFabricType = ClothingPatchFabricType.fromType(inventoryItem.getFabricType());
        if (this.canFullyRestore(isoGameCharacter, bloodBodyPartType, inventoryItem)) {
            this.getVisual().removeHole(bloodBodyPartType.index());
            this.setCondition(this.getCondition() + this.getCondLossPerHole());
            return;
        }
        if (clothingPatchFabricType == ClothingPatchFabricType.Cotton) {
            this.getVisual().setBasicPatch(bloodBodyPartType);
        } else if (clothingPatchFabricType == ClothingPatchFabricType.Denim) {
            this.getVisual().setDenimPatch(bloodBodyPartType);
        } else {
            this.getVisual().setLeatherPatch(bloodBodyPartType);
        }
        if (this.patches == null) {
            this.patches = new HashMap();
        }
        int n = Math.max(1, isoGameCharacter.getPerkLevel(PerkFactory.Perks.Tailoring));
        float f = this.getVisual().getHole(bloodBodyPartType);
        int n2 = this.getCondLossPerHole();
        if (n < 3) {
            n2 -= 2;
        } else if (n < 6) {
            --n2;
        }
        ClothingPatch clothingPatch = new ClothingPatch(n, clothingPatchFabricType.index, f > 0.0f);
        if (f > 0.0f) {
            n2 = Math.max(1, n2);
            this.setCondition(this.getCondition() + n2);
            clothingPatch.conditionGain = n2;
        }
        this.patches.put(bloodBodyPartType.index(), clothingPatch);
        this.getVisual().removeHole(bloodBodyPartType.index());
        if (GameClient.bClient && isoGameCharacter instanceof IsoPlayer) {
            GameClient.instance.sendClothing((IsoPlayer)isoGameCharacter, "", null);
        }
    }

    public ArrayList<BloodBodyPartType> getCoveredParts() {
        ArrayList<BloodClothingType> arrayList = this.getScriptItem().getBloodClothingType();
        return BloodClothingType.getCoveredParts(arrayList);
    }

    public int getNbrOfCoveredParts() {
        ArrayList<BloodClothingType> arrayList = this.getScriptItem().getBloodClothingType();
        return BloodClothingType.getCoveredPartCount(arrayList);
    }

    public int getCondLossPerHole() {
        int n = this.getNbrOfCoveredParts();
        int n2 = PZMath.max(1, this.getConditionMax() / n);
        return n2;
    }

    public void copyPatchesTo(Clothing clothing) {
        clothing.patches = this.patches;
    }

    public String getClothingExtraSubmenu() {
        return this.ScriptItem.clothingExtraSubmenu;
    }

    public boolean canBe3DRender() {
        if (!StringUtils.isNullOrEmpty(this.getWorldStaticItem())) {
            return true;
        }
        return "Bip01_Head".equalsIgnoreCase(this.getClothingItem().m_AttachBone) && (!this.isCosmetic() || "Eyes".equals(this.getBodyLocation()));
    }

    public boolean isWorn() {
        return this.container.parent instanceof IsoGameCharacter && ((IsoGameCharacter)this.container.parent).getWornItems().contains(this);
    }

    private static enum WetDryState {
        Invalid,
        Dryer,
        Wetter;

    }

    public class ClothingPatch {
        public int tailorLvl = 0;
        public int fabricType = 0;
        public int scratchDefense = 0;
        public int biteDefense = 0;
        public boolean hasHole;
        public int conditionGain = 0;

        public String getFabricTypeName() {
            return Translator.getText("IGUI_FabricType_" + this.fabricType);
        }

        public int getScratchDefense() {
            return this.scratchDefense;
        }

        public int getBiteDefense() {
            return this.biteDefense;
        }

        public int getFabricType() {
            return this.fabricType;
        }

        public ClothingPatch() {
        }

        public ClothingPatch(int n, int n2, boolean bl) {
            this.tailorLvl = n;
            this.fabricType = n2;
            this.hasHole = bl;
            ClothingPatchFabricType clothingPatchFabricType = ClothingPatchFabricType.fromIndex(n2);
            this.scratchDefense = (int)Math.max(1.0f, (float)clothingPatchFabricType.maxScratchDef * ((float)n / 10.0f));
            if (clothingPatchFabricType.maxBiteDef > 0) {
                this.biteDefense = (int)Math.max(1.0f, (float)clothingPatchFabricType.maxBiteDef * ((float)n / 10.0f));
            }
        }

        public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
            byteBuffer.put((byte)this.tailorLvl);
            byteBuffer.put((byte)this.fabricType);
            byteBuffer.put((byte)this.scratchDefense);
            byteBuffer.put((byte)this.biteDefense);
            byteBuffer.put(this.hasHole ? (byte)1 : 0);
            byteBuffer.putShort((short)this.conditionGain);
        }

        public void load(ByteBuffer byteBuffer, int n) throws IOException {
            this.tailorLvl = byteBuffer.get();
            this.fabricType = n < 178 ? (int)byteBuffer.getShort() : (int)byteBuffer.get();
            this.scratchDefense = byteBuffer.get();
            this.biteDefense = byteBuffer.get();
            this.hasHole = byteBuffer.get() == 1;
            this.conditionGain = byteBuffer.getShort();
        }

        @Deprecated
        public void save_old(ByteBuffer byteBuffer, boolean bl) throws IOException {
            byteBuffer.putInt(this.tailorLvl);
            byteBuffer.putInt(this.fabricType);
            byteBuffer.putInt(this.scratchDefense);
            byteBuffer.putInt(this.biteDefense);
            byteBuffer.put(this.hasHole ? (byte)1 : 0);
            byteBuffer.putInt(this.conditionGain);
        }

        @Deprecated
        public void load_old(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
            this.tailorLvl = byteBuffer.getInt();
            this.fabricType = byteBuffer.getInt();
            this.scratchDefense = byteBuffer.getInt();
            this.biteDefense = byteBuffer.getInt();
            this.hasHole = byteBuffer.get() == 1;
            this.conditionGain = byteBuffer.getInt();
        }
    }

    public static enum ClothingPatchFabricType {
        Cotton(1, "Cotton", 5, 0),
        Denim(2, "Denim", 10, 5),
        Leather(3, "Leather", 20, 10);

        public int index;
        public String type;
        public int maxScratchDef;
        public int maxBiteDef;

        private ClothingPatchFabricType(int n2, String string2, int n3, int n4) {
            this.index = n2;
            this.type = string2;
            this.maxScratchDef = n3;
            this.maxBiteDef = n4;
        }

        public String getType() {
            return this.type;
        }

        public static ClothingPatchFabricType fromType(String string) {
            if (StringUtils.isNullOrEmpty(string)) {
                return null;
            }
            if (ClothingPatchFabricType.Cotton.type.equals(string)) {
                return Cotton;
            }
            if (ClothingPatchFabricType.Denim.type.equals(string)) {
                return Denim;
            }
            if (ClothingPatchFabricType.Leather.type.equals(string)) {
                return Leather;
            }
            return null;
        }

        public static ClothingPatchFabricType fromIndex(int n) {
            if (n == 1) {
                return Cotton;
            }
            if (n == 2) {
                return Denim;
            }
            if (n == 3) {
                return Leather;
            }
            return null;
        }
    }
}

