/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory;

import java.util.ArrayList;
import zombie.audio.BaseSoundEmitter;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.iso.IsoWorld;

public final class ItemSoundManager {
    private static final ArrayList<InventoryItem> items = new ArrayList();
    private static final ArrayList<BaseSoundEmitter> emitters = new ArrayList();
    private static final ArrayList<InventoryItem> toAdd = new ArrayList();
    private static final ArrayList<InventoryItem> toRemove = new ArrayList();
    private static final ArrayList<InventoryItem> toStopItems = new ArrayList();
    private static final ArrayList<BaseSoundEmitter> toStopEmitters = new ArrayList();

    public static void addItem(InventoryItem inventoryItem) {
        if (inventoryItem == null || items.contains(inventoryItem)) {
            return;
        }
        toRemove.remove(inventoryItem);
        int n = toStopItems.indexOf(inventoryItem);
        if (n != -1) {
            toStopItems.remove(n);
            BaseSoundEmitter baseSoundEmitter = toStopEmitters.remove(n);
            items.add(inventoryItem);
            emitters.add(baseSoundEmitter);
            return;
        }
        if (toAdd.contains(inventoryItem)) {
            return;
        }
        toAdd.add(inventoryItem);
    }

    public static void removeItem(InventoryItem inventoryItem) {
        toAdd.remove(inventoryItem);
        int n = items.indexOf(inventoryItem);
        if (inventoryItem == null || n == -1) {
            return;
        }
        if (toRemove.contains(inventoryItem)) {
            return;
        }
        toRemove.add(inventoryItem);
    }

    public static void removeItems(ArrayList<InventoryItem> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ItemSoundManager.removeItem(arrayList.get(i));
        }
    }

    public static void update() {
        Object object;
        Object object2;
        int n;
        if (!toStopItems.isEmpty()) {
            for (n = 0; n < toStopItems.size(); ++n) {
                object2 = toStopEmitters.get(n);
                ((BaseSoundEmitter)object2).stopAll();
                IsoWorld.instance.returnOwnershipOfEmitter((BaseSoundEmitter)object2);
            }
            toStopItems.clear();
            toStopEmitters.clear();
        }
        if (!toAdd.isEmpty()) {
            for (n = 0; n < toAdd.size(); ++n) {
                object2 = toAdd.get(n);
                assert (!items.contains(object2));
                items.add((InventoryItem)object2);
                BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter();
                IsoWorld.instance.takeOwnershipOfEmitter(baseSoundEmitter);
                emitters.add(baseSoundEmitter);
            }
            toAdd.clear();
        }
        if (!toRemove.isEmpty()) {
            for (n = 0; n < toRemove.size(); ++n) {
                object2 = toRemove.get(n);
                assert (items.contains(object2));
                int n2 = items.indexOf(object2);
                items.remove(n2);
                object = emitters.get(n2);
                emitters.remove(n2);
                toStopItems.add((InventoryItem)object2);
                toStopEmitters.add((BaseSoundEmitter)object);
            }
            toRemove.clear();
        }
        for (n = 0; n < items.size(); ++n) {
            object2 = items.get(n);
            BaseSoundEmitter baseSoundEmitter = emitters.get(n);
            object = ((InventoryItem)object2).getOutermostContainer();
            if (object != null) {
                if (((ItemContainer)object).containingItem != null && ((ItemContainer)object).containingItem.getWorldItem() != null) {
                    if (((ItemContainer)object).containingItem.getWorldItem().getWorldObjectIndex() == -1) {
                        object = null;
                    }
                } else if (((ItemContainer)object).parent != null) {
                    if (((ItemContainer)object).parent.getObjectIndex() == -1 && ((ItemContainer)object).parent.getMovingObjectIndex() == -1 && ((ItemContainer)object).parent.getStaticMovingObjectIndex() == -1) {
                        object = null;
                    }
                } else {
                    object = null;
                }
            }
            if (object == null && (((InventoryItem)object2).getWorldItem() == null || ((InventoryItem)object2).getWorldItem().getWorldObjectIndex() == -1)) {
                ItemSoundManager.removeItem((InventoryItem)object2);
                continue;
            }
            ((InventoryItem)object2).updateSound(baseSoundEmitter);
            baseSoundEmitter.tick();
        }
    }

    public static void Reset() {
        items.clear();
        emitters.clear();
        toAdd.clear();
        toRemove.clear();
        toStopItems.clear();
        toStopEmitters.clear();
    }
}

