/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory;

import java.util.ArrayList;
import java.util.List;
import zombie.characters.IsoGameCharacter;
import zombie.characters.skills.PerkFactory;
import zombie.core.Rand;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.HandWeapon;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Fixing;

public final class FixingManager {
    public static ArrayList<Fixing> getFixes(InventoryItem inventoryItem) {
        ArrayList<Fixing> arrayList = new ArrayList<Fixing>();
        List<Fixing> list = ScriptManager.instance.getAllFixing(new ArrayList<Fixing>());
        for (int i = 0; i < list.size(); ++i) {
            Fixing fixing = list.get(i);
            if (!fixing.getRequiredItem().contains(inventoryItem.getType())) continue;
            arrayList.add(fixing);
        }
        return arrayList;
    }

    public static InventoryItem fixItem(InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter, Fixing fixing, Fixing.Fixer fixer) {
        if ((double)Rand.Next(100) >= FixingManager.getChanceOfFail(inventoryItem, isoGameCharacter, fixing, fixer)) {
            double d = FixingManager.getCondRepaired(inventoryItem, isoGameCharacter, fixing, fixer);
            int n = inventoryItem.getConditionMax() - inventoryItem.getCondition();
            Double d2 = new Double((double)n * (d / 100.0));
            int n2 = (int)Math.round(d2);
            if (n2 == 0) {
                n2 = 1;
            }
            inventoryItem.setCondition(inventoryItem.getCondition() + n2);
            inventoryItem.setHaveBeenRepaired(inventoryItem.getHaveBeenRepaired() + 1);
        } else if (inventoryItem.getCondition() > 0 && Rand.Next(5) == 0) {
            inventoryItem.setCondition(inventoryItem.getCondition() - 1);
            isoGameCharacter.getEmitter().playSound("FixingItemFailed");
        }
        FixingManager.useFixer(isoGameCharacter, fixer, inventoryItem);
        if (fixing.getGlobalItem() != null) {
            FixingManager.useFixer(isoGameCharacter, fixing.getGlobalItem(), inventoryItem);
        }
        FixingManager.addXp(isoGameCharacter, fixer);
        return inventoryItem;
    }

    private static void addXp(IsoGameCharacter isoGameCharacter, Fixing.Fixer fixer) {
        if (fixer.getFixerSkills() == null) {
            return;
        }
        for (int i = 0; i < fixer.getFixerSkills().size(); ++i) {
            Fixing.FixerSkill fixerSkill = fixer.getFixerSkills().get(i);
            isoGameCharacter.getXp().AddXP(PerkFactory.Perks.FromString(fixerSkill.getSkillName()), (float)Rand.Next(3, 6));
        }
    }

    public static void useFixer(IsoGameCharacter isoGameCharacter, Fixing.Fixer fixer, InventoryItem inventoryItem) {
        int n = fixer.getNumberOfUse();
        for (int i = 0; i < isoGameCharacter.getInventory().getItems().size(); ++i) {
            if (inventoryItem == isoGameCharacter.getInventory().getItems().get(i)) continue;
            InventoryItem inventoryItem2 = isoGameCharacter.getInventory().getItems().get(i);
            if (inventoryItem2 != null && inventoryItem2.getType().equals(fixer.getFixerName())) {
                if (inventoryItem2 instanceof DrainableComboItem) {
                    if ("DuctTape".equals(inventoryItem2.getType()) || "Scotchtape".equals(inventoryItem2.getType())) {
                        isoGameCharacter.getEmitter().playSound("FixWithTape");
                    }
                    int n2 = ((DrainableComboItem)inventoryItem2).getDrainableUsesInt();
                    var7_8 = Math.min(n2, n);
                    for (int j = 0; j < var7_8; ++j) {
                        inventoryItem2.Use();
                        --n;
                        if (isoGameCharacter.getInventory().getItems().contains(inventoryItem2)) continue;
                        --i;
                        break;
                    }
                } else {
                    if (inventoryItem2 instanceof HandWeapon) {
                        HandWeapon handWeapon;
                        if (isoGameCharacter.getSecondaryHandItem() == inventoryItem2) {
                            isoGameCharacter.setSecondaryHandItem(null);
                        }
                        if (isoGameCharacter.getPrimaryHandItem() == inventoryItem2) {
                            isoGameCharacter.setPrimaryHandItem(null);
                        }
                        if ((handWeapon = (HandWeapon)inventoryItem2).getScope() != null) {
                            isoGameCharacter.getInventory().AddItem(handWeapon.getScope());
                        }
                        if (handWeapon.getClip() != null) {
                            isoGameCharacter.getInventory().AddItem(handWeapon.getClip());
                        }
                        if (handWeapon.getSling() != null) {
                            isoGameCharacter.getInventory().AddItem(handWeapon.getSling());
                        }
                        if (handWeapon.getStock() != null) {
                            isoGameCharacter.getInventory().AddItem(handWeapon.getStock());
                        }
                        if (handWeapon.getCanon() != null) {
                            isoGameCharacter.getInventory().AddItem(handWeapon.getCanon());
                        }
                        if (handWeapon.getRecoilpad() != null) {
                            isoGameCharacter.getInventory().AddItem(handWeapon.getRecoilpad());
                        }
                        var7_8 = 0;
                        if (handWeapon.getMagazineType() != null && handWeapon.isContainsClip()) {
                            InventoryItem inventoryItem3 = InventoryItemFactory.CreateItem(handWeapon.getMagazineType());
                            inventoryItem3.setCurrentAmmoCount(handWeapon.getCurrentAmmoCount());
                            isoGameCharacter.getInventory().AddItem(inventoryItem3);
                        } else if (handWeapon.getCurrentAmmoCount() > 0) {
                            var7_8 += handWeapon.getCurrentAmmoCount();
                        }
                        if (handWeapon.haveChamber() && handWeapon.isRoundChambered()) {
                            ++var7_8;
                        }
                        if (var7_8 > 0) {
                            for (int j = 0; j < var7_8; ++j) {
                                InventoryItem inventoryItem4 = InventoryItemFactory.CreateItem(handWeapon.getAmmoType());
                                isoGameCharacter.getInventory().AddItem(inventoryItem4);
                            }
                        }
                    }
                    isoGameCharacter.getInventory().Remove(inventoryItem2);
                    --i;
                    --n;
                }
            }
            if (n == 0) break;
        }
    }

    public static double getChanceOfFail(InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter, Fixing fixing, Fixing.Fixer fixer) {
        double d = 3.0;
        if (fixer.getFixerSkills() != null) {
            for (int i = 0; i < fixer.getFixerSkills().size(); ++i) {
                if (isoGameCharacter.getPerkLevel(PerkFactory.Perks.FromString(fixer.getFixerSkills().get(i).getSkillName())) < fixer.getFixerSkills().get(i).getSkillLevel()) {
                    d += (double)((fixer.getFixerSkills().get(i).getSkillLevel() - isoGameCharacter.getPerkLevel(PerkFactory.Perks.FromString(fixer.getFixerSkills().get(i).getSkillName()))) * 30);
                    continue;
                }
                d -= (double)((isoGameCharacter.getPerkLevel(PerkFactory.Perks.FromString(fixer.getFixerSkills().get(i).getSkillName())) - fixer.getFixerSkills().get(i).getSkillLevel()) * 5);
            }
        }
        d += (double)(inventoryItem.getHaveBeenRepaired() * 2);
        if (isoGameCharacter.Traits.Lucky.isSet()) {
            d -= 5.0;
        }
        if (isoGameCharacter.Traits.Unlucky.isSet()) {
            d += 5.0;
        }
        if (d > 100.0) {
            d = 100.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    public static double getCondRepaired(InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter, Fixing fixing, Fixing.Fixer fixer) {
        double d = 0.0;
        switch (fixing.getFixers().indexOf(fixer)) {
            case 0: {
                d = 50.0 * (1.0 / (double)inventoryItem.getHaveBeenRepaired());
                break;
            }
            case 1: {
                d = 20.0 * (1.0 / (double)inventoryItem.getHaveBeenRepaired());
                break;
            }
            default: {
                d = 10.0 * (1.0 / (double)inventoryItem.getHaveBeenRepaired());
            }
        }
        if (fixer.getFixerSkills() != null) {
            for (int i = 0; i < fixer.getFixerSkills().size(); ++i) {
                Fixing.FixerSkill fixerSkill = fixer.getFixerSkills().get(i);
                int n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.FromString(fixerSkill.getSkillName()));
                if (n > fixerSkill.getSkillLevel()) {
                    d += (double)Math.min((n - fixerSkill.getSkillLevel()) * 5, 25);
                    continue;
                }
                d -= (double)((fixerSkill.getSkillLevel() - n) * 15);
            }
        }
        d *= (double)fixing.getConditionModifier();
        d = Math.max(0.0, d);
        d = Math.min(100.0, d);
        return d;
    }
}

