/*
 * Decompiled with CFR 0.152.
 */
package zombie.input;

import org.lwjglx.input.Controller;
import org.lwjglx.input.Controllers;
import org.lwjglx.input.GamepadState;

public class ControllerState {
    private boolean m_isCreated = false;
    private boolean m_wasPolled = false;
    private final Controller[] m_controllers = new Controller[16];
    private final GamepadState[] m_gamepadState = new GamepadState[16];

    ControllerState() {
        for (int i = 0; i < this.m_controllers.length; ++i) {
            this.m_gamepadState[i] = new GamepadState();
        }
    }

    public void poll() {
        boolean bl = !this.m_isCreated;
        boolean bl2 = this.m_isCreated = this.m_isCreated || Controllers.isCreated();
        if (!this.m_isCreated) {
            return;
        }
        if (bl) {
            // empty if block
        }
        this.m_wasPolled = true;
        Controllers.poll((GamepadState[])this.m_gamepadState);
        for (int i = 0; i < Controllers.getControllerCount(); ++i) {
            this.m_controllers[i] = Controllers.getController((int)i);
        }
    }

    public boolean wasPolled() {
        return this.m_wasPolled;
    }

    public void set(ControllerState controllerState) {
        this.m_isCreated = controllerState.m_isCreated;
        for (int i = 0; i < this.m_controllers.length; ++i) {
            this.m_controllers[i] = controllerState.m_controllers[i];
            if (this.m_controllers[i] == null) continue;
            this.m_gamepadState[i].set(controllerState.m_gamepadState[i]);
            this.m_controllers[i].gamepadState = this.m_gamepadState[i];
        }
        this.m_wasPolled = controllerState.m_wasPolled;
    }

    public void reset() {
        this.m_wasPolled = false;
    }

    public boolean isCreated() {
        return this.m_isCreated;
    }

    public Controller getController(int n) {
        return this.m_controllers[n];
    }

    public void quit() {
        for (int i = 0; i < this.m_controllers.length; ++i) {
            this.m_gamepadState[i].quit();
        }
    }
}

