/*
 * Decompiled with CFR 0.152.
 */
package zombie.globalObjects;

import java.util.ArrayDeque;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.globalObjects.GlobalObject;
import zombie.globalObjects.GlobalObjectLookup;

public abstract class GlobalObjectSystem {
    private static final ArrayDeque<ArrayList<GlobalObject>> objectListPool = new ArrayDeque();
    protected final String name;
    protected final KahluaTable modData;
    protected final ArrayList<GlobalObject> objects = new ArrayList();
    protected final GlobalObjectLookup lookup = new GlobalObjectLookup(this);

    GlobalObjectSystem(String string) {
        this.name = string;
        this.modData = LuaManager.platform.newTable();
    }

    public String getName() {
        return this.name;
    }

    public final KahluaTable getModData() {
        return this.modData;
    }

    protected abstract GlobalObject makeObject(int var1, int var2, int var3);

    public final GlobalObject newObject(int n, int n2, int n3) {
        if (this.getObjectAt(n, n2, n3) != null) {
            throw new IllegalStateException("already an object at " + n + "," + n2 + "," + n3);
        }
        GlobalObject globalObject = this.makeObject(n, n2, n3);
        this.objects.add(globalObject);
        this.lookup.addObject(globalObject);
        return globalObject;
    }

    public final void removeObject(GlobalObject globalObject) throws IllegalArgumentException, IllegalStateException {
        if (globalObject == null) {
            throw new NullPointerException("object is null");
        }
        if (globalObject.system != this) {
            throw new IllegalStateException("object not in this system");
        }
        this.objects.remove(globalObject);
        this.lookup.removeObject(globalObject);
        globalObject.Reset();
    }

    public final GlobalObject getObjectAt(int n, int n2, int n3) {
        return this.lookup.getObjectAt(n, n2, n3);
    }

    public final boolean hasObjectsInChunk(int n, int n2) {
        return this.lookup.hasObjectsInChunk(n, n2);
    }

    public final ArrayList<GlobalObject> getObjectsInChunk(int n, int n2) {
        return this.lookup.getObjectsInChunk(n, n2, this.allocList());
    }

    public final ArrayList<GlobalObject> getObjectsAdjacentTo(int n, int n2, int n3) {
        return this.lookup.getObjectsAdjacentTo(n, n2, n3, this.allocList());
    }

    public final int getObjectCount() {
        return this.objects.size();
    }

    public final GlobalObject getObjectByIndex(int n) {
        if (n < 0 || n >= this.objects.size()) {
            return null;
        }
        return this.objects.get(n);
    }

    public final ArrayList<GlobalObject> allocList() {
        return objectListPool.isEmpty() ? new ArrayList() : objectListPool.pop();
    }

    public final void finishedWithList(ArrayList<GlobalObject> arrayList) {
        if (arrayList != null && !objectListPool.contains(arrayList)) {
            arrayList.clear();
            objectListPool.add(arrayList);
        }
    }

    public void Reset() {
        for (int i = 0; i < this.objects.size(); ++i) {
            GlobalObject globalObject = this.objects.get(i);
            globalObject.Reset();
        }
        this.objects.clear();
        this.modData.wipe();
    }
}

