/*
 * Decompiled with CFR 0.152.
 */
package zombie.globalObjects;

import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.core.BoxedStaticValues;
import zombie.globalObjects.CGlobalObject;
import zombie.globalObjects.CGlobalObjectNetwork;
import zombie.globalObjects.GlobalObject;
import zombie.globalObjects.GlobalObjectSystem;

public final class CGlobalObjectSystem
extends GlobalObjectSystem {
    public CGlobalObjectSystem(String string) {
        super(string);
    }

    @Override
    protected GlobalObject makeObject(int n, int n2, int n3) {
        return new CGlobalObject(this, n, n2, n3);
    }

    public void sendCommand(String string, IsoPlayer isoPlayer, KahluaTable kahluaTable) {
        CGlobalObjectNetwork.sendClientCommand(isoPlayer, this.name, string, kahluaTable);
    }

    public void receiveServerCommand(String string, KahluaTable kahluaTable) {
        Object object = this.modData.rawget((Object)"OnServerCommand");
        if (object == null) {
            throw new IllegalStateException("OnServerCommand method undefined for system '" + this.name + "'");
        }
        LuaManager.caller.pcallvoid(LuaManager.thread, object, (Object)this.modData, (Object)string, (Object)kahluaTable);
    }

    public void receiveNewLuaObjectAt(int n, int n2, int n3, KahluaTable kahluaTable) {
        Object object = this.modData.rawget((Object)"newLuaObjectAt");
        if (object == null) {
            throw new IllegalStateException("newLuaObjectAt method undefined for system '" + this.name + "'");
        }
        LuaManager.caller.pcall(LuaManager.thread, object, new Object[]{this.modData, BoxedStaticValues.toDouble(n), BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3)});
        GlobalObject globalObject = this.getObjectAt(n, n2, n3);
        if (globalObject == null) {
            return;
        }
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            globalObject.getModData().rawset(kahluaTableIterator.getKey(), kahluaTableIterator.getValue());
        }
    }

    public void receiveRemoveLuaObjectAt(int n, int n2, int n3) {
        Object object = this.modData.rawget((Object)"removeLuaObjectAt");
        if (object == null) {
            throw new IllegalStateException("removeLuaObjectAt method undefined for system '" + this.name + "'");
        }
        LuaManager.caller.pcall(LuaManager.thread, object, new Object[]{this.modData, BoxedStaticValues.toDouble(n), BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3)});
    }

    public void receiveUpdateLuaObjectAt(int n, int n2, int n3, KahluaTable kahluaTable) {
        GlobalObject globalObject = this.getObjectAt(n, n2, n3);
        if (globalObject == null) {
            return;
        }
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            globalObject.getModData().rawset(kahluaTableIterator.getKey(), kahluaTableIterator.getValue());
        }
        Object object = this.modData.rawget((Object)"OnLuaObjectUpdated");
        if (object == null) {
            throw new IllegalStateException("OnLuaObjectUpdated method undefined for system '" + this.name + "'");
        }
        LuaManager.caller.pcall(LuaManager.thread, object, new Object[]{this.modData, globalObject.getModData()});
    }

    @Override
    public void Reset() {
        super.Reset();
        this.modData.wipe();
    }
}

