/*
 * Decompiled with CFR 0.152.
 */
package zombie.globalObjects;

import java.io.IOException;
import java.nio.ByteBuffer;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.debug.DebugLog;
import zombie.globalObjects.CGlobalObjectSystem;
import zombie.globalObjects.CGlobalObjects;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.TableNetworkUtils;
import zombie.spnetwork.SinglePlayerClient;

public final class CGlobalObjectNetwork {
    private static final ByteBuffer BYTE_BUFFER = ByteBuffer.allocate(0x100000);
    private static final ByteBufferWriter BYTE_BUFFER_WRITER = new ByteBufferWriter(BYTE_BUFFER);
    private static KahluaTable tempTable;

    public static void receive(ByteBuffer byteBuffer) throws IOException {
        byte by = byteBuffer.get();
        switch (by) {
            case 1: {
                CGlobalObjectNetwork.receiveServerCommand(byteBuffer);
                break;
            }
            case 3: {
                CGlobalObjectNetwork.receiveNewLuaObjectAt(byteBuffer);
                break;
            }
            case 4: {
                CGlobalObjectNetwork.receiveRemoveLuaObjectAt(byteBuffer);
                break;
            }
            case 5: {
                CGlobalObjectNetwork.receiveUpdateLuaObjectAt(byteBuffer);
            }
        }
    }

    private static void receiveServerCommand(ByteBuffer byteBuffer) {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        boolean bl = byteBuffer.get() == 1;
        KahluaTable kahluaTable = null;
        if (bl) {
            kahluaTable = LuaManager.platform.newTable();
            try {
                TableNetworkUtils.load(kahluaTable, byteBuffer);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
                return;
            }
        }
        CGlobalObjects.receiveServerCommand(string, string2, kahluaTable);
    }

    private static void receiveNewLuaObjectAt(ByteBuffer byteBuffer) throws IOException {
        String string = GameWindow.ReadStringUTF(byteBuffer);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        byte by = byteBuffer.get();
        if (tempTable == null) {
            tempTable = LuaManager.platform.newTable();
        }
        TableNetworkUtils.load(tempTable, byteBuffer);
        CGlobalObjectSystem cGlobalObjectSystem = CGlobalObjects.getSystemByName(string);
        if (cGlobalObjectSystem == null) {
            return;
        }
        cGlobalObjectSystem.receiveNewLuaObjectAt(n, n2, by, tempTable);
    }

    private static void receiveRemoveLuaObjectAt(ByteBuffer byteBuffer) {
        String string = GameWindow.ReadStringUTF(byteBuffer);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        byte by = byteBuffer.get();
        CGlobalObjectSystem cGlobalObjectSystem = CGlobalObjects.getSystemByName(string);
        if (cGlobalObjectSystem == null) {
            return;
        }
        cGlobalObjectSystem.receiveRemoveLuaObjectAt(n, n2, by);
    }

    private static void receiveUpdateLuaObjectAt(ByteBuffer byteBuffer) throws IOException {
        String string = GameWindow.ReadStringUTF(byteBuffer);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        byte by = byteBuffer.get();
        if (tempTable == null) {
            tempTable = LuaManager.platform.newTable();
        }
        TableNetworkUtils.load(tempTable, byteBuffer);
        CGlobalObjectSystem cGlobalObjectSystem = CGlobalObjects.getSystemByName(string);
        if (cGlobalObjectSystem == null) {
            return;
        }
        cGlobalObjectSystem.receiveUpdateLuaObjectAt(n, n2, by, tempTable);
    }

    private static void sendPacket(ByteBuffer byteBuffer) {
        if (GameServer.bServer) {
            throw new IllegalStateException("can't call this method on the server");
        }
        if (GameClient.bClient) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            byteBuffer.flip();
            byteBufferWriter.bb.put(byteBuffer);
            PacketTypes.PacketType.GlobalObjects.send(GameClient.connection);
        } else {
            ByteBufferWriter byteBufferWriter = SinglePlayerClient.connection.startPacket();
            byteBuffer.flip();
            byteBufferWriter.bb.put(byteBuffer);
            SinglePlayerClient.connection.endPacketImmediate();
        }
    }

    public static void sendClientCommand(IsoPlayer isoPlayer, String string, String string2, KahluaTable kahluaTable) {
        BYTE_BUFFER.clear();
        CGlobalObjectNetwork.writeClientCommand(isoPlayer, string, string2, kahluaTable, BYTE_BUFFER_WRITER);
        CGlobalObjectNetwork.sendPacket(BYTE_BUFFER);
    }

    private static void writeClientCommand(IsoPlayer isoPlayer, String string, String string2, KahluaTable kahluaTable, ByteBufferWriter byteBufferWriter) {
        PacketTypes.PacketType.GlobalObjects.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)(isoPlayer != null ? isoPlayer.PlayerIndex : -1));
        byteBufferWriter.putByte((byte)2);
        byteBufferWriter.putUTF(string);
        byteBufferWriter.putUTF(string2);
        if (kahluaTable == null || kahluaTable.isEmpty()) {
            byteBufferWriter.putByte((byte)0);
        } else {
            byteBufferWriter.putByte((byte)1);
            try {
                KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
                while (kahluaTableIterator.advance()) {
                    if (TableNetworkUtils.canSave(kahluaTableIterator.getKey(), kahluaTableIterator.getValue())) continue;
                    DebugLog.log("ERROR: sendClientCommand: can't save key,value=" + kahluaTableIterator.getKey() + "," + kahluaTableIterator.getValue());
                }
                TableNetworkUtils.save(kahluaTable, byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
            }
        }
    }

    public static void Reset() {
        if (tempTable != null) {
            tempTable.wipe();
            tempTable = null;
        }
    }
}

