/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import zombie.GameTime;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.textures.Texture;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.input.GameKeyboard;
import zombie.input.Mouse;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.ui.UIManager;

public final class TISLogoState
extends GameState {
    public float alpha = 0.0f;
    public float alphaStep = 0.02f;
    public float logoDisplayTime = 20.0f;
    public int screenNumber = 1;
    public int stage = 0;
    public float targetAlpha = 0.0f;
    private boolean bNoRender = false;
    private final LogoElement logoTIS = new LogoElement("media/ui/TheIndieStoneLogo_Lineart_White.png");
    private final LogoElement logoFMOD = new LogoElement("media/ui/FMODLogo.png");
    private final LogoElement logoGA = new LogoElement("media/ui/GA-1280-white.png");
    private final LogoElement logoNW = new LogoElement("media/ui/NW_Logo_Combined.png");
    private static final int SCREEN_TIS = 1;
    private static final int SCREEN_OTHER = 2;
    private static final int STAGE_FADING_IN_LOGO = 0;
    private static final int STAGE_HOLDING_LOGO = 1;
    private static final int STAGE_FADING_OUT_LOGO = 2;
    private static final int STAGE_EXIT = 3;

    @Override
    public void enter() {
        UIManager.bSuspend = true;
        this.alpha = 0.0f;
        this.targetAlpha = 1.0f;
    }

    @Override
    public void exit() {
        UIManager.bSuspend = false;
    }

    @Override
    public void render() {
        if (this.bNoRender) {
            Core.getInstance().StartFrame();
            SpriteRenderer.instance.renderi(null, 0, 0, Core.getInstance().getOffscreenWidth(0), Core.getInstance().getOffscreenHeight(0), 0.0f, 0.0f, 0.0f, 1.0f, null);
            Core.getInstance().EndFrame();
            return;
        }
        Core.getInstance().StartFrame();
        Core.getInstance().EndFrame();
        boolean bl = UIManager.useUIFBO;
        UIManager.useUIFBO = false;
        Core.getInstance().StartFrameUI();
        SpriteRenderer.instance.renderi(null, 0, 0, Core.getInstance().getOffscreenWidth(0), Core.getInstance().getOffscreenHeight(0), 0.0f, 0.0f, 0.0f, 1.0f, null);
        if (this.screenNumber == 1) {
            this.logoTIS.centerOnScreen();
            this.logoTIS.render(this.alpha);
        }
        if (this.screenNumber == 2) {
            this.renderAttribution();
        }
        Core.getInstance().EndFrameUI();
        UIManager.useUIFBO = bl;
    }

    private void renderAttribution() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = Core.getInstance().getScreenWidth();
        int n6 = Core.getInstance().getScreenHeight();
        int n7 = 50;
        int n8 = 3;
        int n9 = (n6 - (n8 + 1) * n7) / 3;
        int n10 = n7;
        Texture texture = this.logoGA.m_texture;
        if (texture != null && texture.isReady()) {
            int n11 = (int)((float)(texture.getWidth() * n9) / (float)texture.getHeight());
            n4 = (n5 - n11) / 2;
            this.logoGA.setPos(n4, n10);
            this.logoGA.setSize(n11, n9);
            this.logoGA.render(this.alpha);
        }
        n10 += n9 + n7;
        n10 = (int)((float)n10 + (float)n9 * 0.15f);
        texture = this.logoNW.m_texture;
        if (texture != null && texture.isReady()) {
            float f = 0.5f;
            n4 = (int)((float)texture.getWidth() * f * (float)n9 / (float)texture.getHeight());
            n3 = (int)((float)n9 * f);
            n2 = (n5 - n4) / 2;
            n = (n9 - n3) / 2;
            this.logoNW.setPos(n2, n10 + n);
            this.logoNW.setSize(n4, n3);
            this.logoNW.render(this.alpha);
        }
        n10 += n9 + n7;
        texture = this.logoFMOD.m_texture;
        if (texture != null && texture.isReady()) {
            float f = 0.35f;
            n4 = TextManager.instance.getFontHeight(UIFont.Small);
            n3 = (int)((float)n9 * f - 16.0f - (float)n4);
            n2 = (int)((float)texture.getWidth() * ((float)n3 / (float)texture.getHeight()));
            n = (n5 - n2) / 2;
            int n12 = (n9 - n3) / 2;
            int n13 = n10 + n12 + n3 + 16;
            this.logoFMOD.setPos(n, n10 + n12);
            this.logoFMOD.setSize(n2, n3);
            this.logoFMOD.render(this.alpha);
            String string = "Made with FMOD Studio by Firelight Technologies Pty Ltd.";
            TextManager.instance.DrawStringCentre((double)n5 / 2.0, n13, string, 1.0, 1.0, 1.0, this.alpha);
        }
    }

    @Override
    public GameStateMachine.StateAction update() {
        if (Mouse.isLeftDown() || GameKeyboard.isKeyDown(28) || GameKeyboard.isKeyDown(57) || GameKeyboard.isKeyDown(1)) {
            this.stage = 3;
        }
        if (this.stage == 0) {
            this.targetAlpha = 1.0f;
            if (this.alpha == 1.0f) {
                this.stage = 1;
                this.logoDisplayTime = 20.0f;
            }
        }
        if (this.stage == 1) {
            this.logoDisplayTime -= GameTime.getInstance().getMultiplier() / 1.6f;
            if (this.logoDisplayTime <= 0.0f) {
                this.stage = 2;
            }
        }
        if (this.stage == 2) {
            this.targetAlpha = 0.0f;
            if (this.alpha == 0.0f) {
                if (this.screenNumber == 1) {
                    this.screenNumber = 2;
                    this.stage = 0;
                } else {
                    this.stage = 3;
                }
            }
        }
        if (this.stage == 3) {
            this.targetAlpha = 0.0f;
            if (this.alpha == 0.0f) {
                this.bNoRender = true;
                return GameStateMachine.StateAction.Continue;
            }
        }
        if (this.alpha < this.targetAlpha) {
            this.alpha += this.alphaStep * GameTime.getInstance().getMultiplier();
            if (this.alpha > this.targetAlpha) {
                this.alpha = this.targetAlpha;
            }
        } else if (this.alpha > this.targetAlpha) {
            this.alpha -= this.alphaStep * GameTime.getInstance().getMultiplier();
            if (this.stage == 3) {
                this.alpha -= this.alphaStep * GameTime.getInstance().getMultiplier();
            }
            if (this.alpha < this.targetAlpha) {
                this.alpha = this.targetAlpha;
            }
        }
        return GameStateMachine.StateAction.Remain;
    }

    private static final class LogoElement {
        Texture m_texture;
        int m_x;
        int m_y;
        int m_width;
        int m_height;

        LogoElement(String string) {
            this.m_texture = Texture.getSharedTexture(string);
            if (this.m_texture != null) {
                this.m_width = this.m_texture.getWidth();
                this.m_height = this.m_texture.getHeight();
            }
        }

        void centerOnScreen() {
            this.m_x = (Core.getInstance().getScreenWidth() - this.m_width) / 2;
            this.m_y = (Core.getInstance().getScreenHeight() - this.m_height) / 2;
        }

        void setPos(int n, int n2) {
            this.m_x = n;
            this.m_y = n2;
        }

        void setSize(int n, int n2) {
            this.m_width = n;
            this.m_height = n2;
        }

        void render(float f) {
            if (this.m_texture == null || !this.m_texture.isReady()) {
                return;
            }
            SpriteRenderer.instance.renderi(this.m_texture, this.m_x, this.m_y, this.m_width, this.m_height, 1.0f, 1.0f, 1.0f, f, null);
        }
    }
}

