/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import fmod.fmod.Audio;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.Struct;
import org.lwjglx.opengl.Display;
import org.lwjglx.opengl.OpenGLException;
import zombie.DebugFileWatcher;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.IndieGL;
import zombie.Lua.LuaEventManager;
import zombie.SoundManager;
import zombie.ZomboidFileSystem;
import zombie.asset.AssetManagers;
import zombie.characters.IsoPlayer;
import zombie.core.BoxedStaticValues;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.ProxyPrintStream;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.logger.LoggerManager;
import zombie.core.logger.ZipLogs;
import zombie.core.opengl.RenderThread;
import zombie.core.raknet.VoiceManager;
import zombie.core.skinnedmodel.advancedanimation.AnimNodeAsset;
import zombie.core.skinnedmodel.advancedanimation.AnimNodeAssetManager;
import zombie.core.skinnedmodel.model.AiSceneAsset;
import zombie.core.skinnedmodel.model.AiSceneAssetManager;
import zombie.core.skinnedmodel.model.AnimationAsset;
import zombie.core.skinnedmodel.model.AnimationAssetManager;
import zombie.core.skinnedmodel.model.MeshAssetManager;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelAssetManager;
import zombie.core.skinnedmodel.model.ModelMesh;
import zombie.core.skinnedmodel.model.jassimp.JAssImpImporter;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.ClothingItemAssetManager;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureAssetManager;
import zombie.core.textures.TextureID;
import zombie.core.textures.TextureIDAssetManager;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.gameStates.ConnectToServerState;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.input.JoypadManager;
import zombie.modding.ActiveMods;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.ui.UIManager;
import zombie.worldMap.UIWorldMap;
import zombie.worldMap.WorldMapData;
import zombie.worldMap.WorldMapDataAssetManager;

public final class MainScreenState
extends GameState {
    public static String Version = "RC 3";
    public static Audio ambient;
    public static float totalScale;
    public float alpha = 1.0f;
    public float alphaStep = 0.03f;
    private int RestartDebounceClickTimer = 10;
    public final ArrayList<ScreenElement> Elements = new ArrayList(16);
    public float targetAlpha = 1.0f;
    int lastH;
    int lastW;
    ScreenElement Logo;
    public static MainScreenState instance;
    public boolean showLogo = false;
    private float FadeAlpha = 0.0f;
    public boolean lightningTimelineMarker = false;
    float lightningTime = 0.0f;
    public UIWorldMap m_worldMap;
    public float lightningDelta = 0.0f;
    public float lightningTargetDelta = 0.0f;
    public float lightningFullTimer = 0.0f;
    public float lightningCount = 0.0f;
    public float lightOffCount = 0.0f;
    private ConnectToServerState connectToServerState;
    private static GLFWImage windowIcon1;
    private static GLFWImage windowIcon2;
    private static ByteBuffer windowIconBB1;
    private static ByteBuffer windowIconBB2;

    public static void main(String[] stringArray) {
        String[] stringArray2;
        Object object;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !stringArray[i].startsWith("-cachedir=")) continue;
            ZomboidFileSystem.instance.setCacheDir(stringArray[i].replace("-cachedir=", "").trim());
        }
        ZipLogs.addZipFile(false);
        try {
            object = ZomboidFileSystem.instance.getCacheDir() + File.separator + "console.txt";
            FileOutputStream fileOutputStream = new FileOutputStream((String)object);
            stringArray2 = new PrintStream(fileOutputStream, true);
            System.setOut(new ProxyPrintStream(System.out, (PrintStream)stringArray2));
            System.setErr(new ProxyPrintStream(System.err, (PrintStream)stringArray2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        Rand.init();
        DebugLog.init();
        LoggerManager.init();
        DebugLog.log("cachedir set to \"" + ZomboidFileSystem.instance.getCacheDir() + "\"");
        JAssImpImporter.Init();
        object = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        System.out.println(((DateFormat)object).format(Calendar.getInstance().getTime()));
        System.out.println("cachedir is \"" + ZomboidFileSystem.instance.getCacheDir() + "\"");
        System.out.println("LogFileDir is \"" + LoggerManager.getLogsDir() + "\"");
        MainScreenState.printSpecs();
        System.getProperties().list(System.out);
        System.out.println("-----");
        System.out.println("version=" + Core.getInstance().getVersion() + " demo=false");
        Display.setIcon((GLFWImage.Buffer)MainScreenState.loadIcons());
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].contains("safemode")) {
                Core.SafeMode = true;
                Core.SafeModeForced = true;
                continue;
            }
            if (stringArray[i].equals("-nosound")) {
                Core.SoundDisabled = true;
                continue;
            }
            if (stringArray[i].equals("-aitest")) {
                IsoPlayer.isTestAIMode = true;
                continue;
            }
            if (stringArray[i].equals("-novoip")) {
                VoiceManager.VoipDisabled = true;
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                Core.bDebug = true;
                continue;
            }
            if (stringArray[i].startsWith("-debuglog=")) {
                for (String string : stringArray[i].replace("-debuglog=", "").split(",")) {
                    try {
                        char c = string.charAt(0);
                        string = c == '+' || c == '-' ? string.substring(1) : string;
                        DebugLog.setLogEnabled(DebugType.valueOf(string), c != '-');
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (stringArray[i].startsWith("-cachedir=")) continue;
            if (stringArray[i].equals("+connect")) {
                if (i + 1 < stringArray.length) {
                    System.setProperty("args.server.connect", stringArray[i + 1]);
                }
                ++i;
                continue;
            }
            if (stringArray[i].equals("+password")) {
                if (i + 1 < stringArray.length) {
                    System.setProperty("args.server.password", stringArray[i + 1]);
                }
                ++i;
                continue;
            }
            if (stringArray[i].contains("-debugtranslation")) {
                Translator.debug = true;
                continue;
            }
            if ("-modfolders".equals(stringArray[i])) {
                if (i + 1 < stringArray.length) {
                    ZomboidFileSystem.instance.setModFoldersOrder(stringArray[i + 1]);
                }
                ++i;
                continue;
            }
            if (stringArray[i].equals("-nosteam")) {
                System.setProperty("zomboid.steam", "0");
                continue;
            }
            DebugLog.log("unknown option \"" + stringArray[i] + "\"");
        }
        try {
            RenderThread.init();
            AssetManagers assetManagers = GameWindow.assetManagers;
            AiSceneAssetManager.instance.create(AiSceneAsset.ASSET_TYPE, assetManagers);
            AnimationAssetManager.instance.create(AnimationAsset.ASSET_TYPE, assetManagers);
            AnimNodeAssetManager.instance.create(AnimNodeAsset.ASSET_TYPE, assetManagers);
            ClothingItemAssetManager.instance.create(ClothingItem.ASSET_TYPE, assetManagers);
            MeshAssetManager.instance.create(ModelMesh.ASSET_TYPE, assetManagers);
            ModelAssetManager.instance.create(Model.ASSET_TYPE, assetManagers);
            TextureIDAssetManager.instance.create(TextureID.ASSET_TYPE, assetManagers);
            TextureAssetManager.instance.create(Texture.ASSET_TYPE, assetManagers);
            WorldMapDataAssetManager.instance.create(WorldMapData.ASSET_TYPE, assetManagers);
            GameWindow.InitGameThread();
            RenderThread.renderLoop();
        }
        catch (OpenGLException openGLException) {
            stringArray2 = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "options2.bin");
            stringArray2.delete();
            openGLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void DrawTexture(Texture texture, int n, int n2, int n3, int n4, float f) {
        SpriteRenderer.instance.renderi(texture, n, n2, n3, n4, 1.0f, 1.0f, 1.0f, f, null);
    }

    public static void DrawTexture(Texture texture, int n, int n2, int n3, int n4, Color color) {
        SpriteRenderer.instance.renderi(texture, n, n2, n3, n4, color.r, color.g, color.b, color.a, null);
    }

    @Override
    public void enter() {
        DebugLog.log("EXITDEBUG: MainScreenState.enter 1");
        this.Elements.clear();
        this.targetAlpha = 1.0f;
        TextureID.UseFiltering = true;
        this.RestartDebounceClickTimer = 100;
        totalScale = (float)Core.getInstance().getOffscreenHeight(0) / 1080.0f;
        this.lastW = Core.getInstance().getOffscreenWidth(0);
        this.lastH = Core.getInstance().getOffscreenHeight(0);
        this.alpha = 1.0f;
        this.showLogo = false;
        SoundManager.instance.setMusicState("MainMenu");
        int n = (int)((float)Core.getInstance().getOffscreenHeight(0) * 0.7f);
        ScreenElement screenElement = new ScreenElement(Texture.getSharedTexture("media/ui/PZ_Logo.png"), Core.getInstance().getOffscreenWidth(0) / 2 - (int)((float)Texture.getSharedTexture("media/ui/PZ_Logo.png").getWidth() * totalScale) / 2, n - (int)(350.0f * totalScale), 0.0f, 0.0f, 1);
        screenElement.targetAlpha = 1.0f;
        screenElement.alphaStep *= 0.9f;
        this.Logo = screenElement;
        this.Elements.add(screenElement);
        TextureID.UseFiltering = false;
        LuaEventManager.triggerEvent("OnMainMenuEnter");
        instance = this;
        float f = TextureID.totalMemUsed / 1024.0f;
        float f2 = f / 1024.0f;
        DebugLog.log("EXITDEBUG: MainScreenState.enter 2");
    }

    public static MainScreenState getInstance() {
        return instance;
    }

    public boolean ShouldShowLogo() {
        return this.showLogo;
    }

    @Override
    public void exit() {
        DebugLog.log("EXITDEBUG: MainScreenState.exit 1");
        DebugLog.log("LOADED UP A TOTAL OF " + Texture.totalTextureID + " TEXTURES");
        float f = (float)Core.getInstance().getOptionMusicVolume() / 10.0f;
        long l = Calendar.getInstance().getTimeInMillis();
        while (true) {
            this.FadeAlpha = Math.min(1.0f, (float)(Calendar.getInstance().getTimeInMillis() - l) / 250.0f);
            this.render();
            if (this.FadeAlpha >= 1.0f) break;
            try {
                Thread.sleep(33L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SoundManager.instance.Update();
        }
        SoundManager.instance.stopMusic("");
        SoundManager.instance.setMusicVolume(f);
        DebugLog.log("EXITDEBUG: MainScreenState.exit 2");
    }

    @Override
    public void render() {
        this.lightningTime += 1.0f * GameTime.instance.getMultipliedSecondsSinceLastUpdate();
        Core.getInstance().StartFrame();
        Core.getInstance().EndFrame();
        boolean bl = UIManager.useUIFBO;
        UIManager.useUIFBO = false;
        Core.getInstance().StartFrameUI();
        IndieGL.glBlendFunc(770, 771);
        SpriteRenderer.instance.renderi(null, 0, 0, Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), 0.0f, 0.0f, 0.0f, 1.0f, null);
        IndieGL.glBlendFunc(770, 770);
        this.renderBackground();
        UIManager.render();
        if (GameWindow.DrawReloadingLua) {
            int n = TextManager.instance.MeasureStringX(UIFont.Small, "Reloading Lua") + 32;
            int n2 = TextManager.instance.font.getLineHeight();
            int n3 = (int)Math.ceil((double)n2 * 1.5);
            SpriteRenderer.instance.renderi(null, Core.getInstance().getScreenWidth() - n - 12, 12, n, n3, 0.0f, 0.5f, 0.75f, 1.0f, null);
            TextManager.instance.DrawStringCentre(Core.getInstance().getScreenWidth() - n / 2 - 12, 12 + (n3 - n2) / 2, "Reloading Lua", 1.0, 1.0, 1.0, 1.0);
        }
        if (this.FadeAlpha > 0.0f) {
            UIManager.DrawTexture(UIManager.getBlack(), 0.0, 0.0, Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), this.FadeAlpha);
        }
        ActiveMods.renderUI();
        JoypadManager.instance.renderUI();
        Core.getInstance().EndFrameUI();
        UIManager.useUIFBO = bl;
    }

    public void renderBackground() {
        if (this.lightningTargetDelta == 0.0f && this.lightningDelta != 0.0f && this.lightningDelta < 0.6f && this.lightningCount == 0.0f) {
            this.lightningTargetDelta = 1.0f;
            this.lightningCount = 1.0f;
        }
        if (this.lightningTimelineMarker) {
            this.lightningTimelineMarker = false;
            this.lightningTargetDelta = 1.0f;
        }
        if (this.lightningTargetDelta == 1.0f && this.lightningDelta == 1.0f && (this.lightningFullTimer > 1.0f && this.lightningCount == 0.0f || this.lightningFullTimer > 10.0f)) {
            this.lightningTargetDelta = 0.0f;
            this.lightningFullTimer = 0.0f;
        }
        if (this.lightningTargetDelta == 1.0f && this.lightningDelta == 1.0f) {
            this.lightningFullTimer += GameTime.getInstance().getMultiplier();
        }
        if (this.lightningDelta != this.lightningTargetDelta) {
            if (this.lightningDelta < this.lightningTargetDelta) {
                this.lightningDelta += 0.17f * GameTime.getInstance().getMultiplier();
                if (this.lightningDelta > this.lightningTargetDelta) {
                    this.lightningDelta = this.lightningTargetDelta;
                    if (this.lightningDelta == 1.0f) {
                        this.showLogo = true;
                    }
                }
            }
            if (this.lightningDelta > this.lightningTargetDelta) {
                this.lightningDelta -= 0.025f * GameTime.getInstance().getMultiplier();
                if (this.lightningCount == 0.0f) {
                    this.lightningDelta -= 0.1f;
                }
                if (this.lightningDelta < this.lightningTargetDelta) {
                    this.lightningDelta = this.lightningTargetDelta;
                    this.lightningCount = 0.0f;
                }
            }
        }
        Texture texture = Texture.getSharedTexture("media/ui/Title.png");
        Texture texture2 = Texture.getSharedTexture("media/ui/Title2.png");
        Texture texture3 = Texture.getSharedTexture("media/ui/Title3.png");
        Texture texture4 = Texture.getSharedTexture("media/ui/Title4.png");
        if (Rand.Next(150) == 0) {
            this.lightOffCount = 10.0f;
        }
        Texture texture5 = Texture.getSharedTexture("media/ui/Title_lightning.png");
        Texture texture6 = Texture.getSharedTexture("media/ui/Title_lightning2.png");
        Texture texture7 = Texture.getSharedTexture("media/ui/Title_lightning3.png");
        Texture texture8 = Texture.getSharedTexture("media/ui/Title_lightning4.png");
        float f = (float)Core.getInstance().getScreenHeight() / 1080.0f;
        float f2 = (float)texture.getWidth() * f;
        float f3 = (float)texture2.getWidth() * f;
        float f4 = (float)Core.getInstance().getScreenWidth() - (f2 + f3);
        if (f4 >= 0.0f) {
            f4 = 0.0f;
        }
        float f5 = 1.0f - this.lightningDelta * 0.6f;
        float f6 = 1024.0f * f;
        float f7 = 56.0f * f;
        MainScreenState.DrawTexture(texture, (int)f4, 0, (int)f2, (int)f6, f5);
        MainScreenState.DrawTexture(texture2, (int)f4 + (int)f2, 0, (int)f2, (int)f6, f5);
        MainScreenState.DrawTexture(texture3, (int)f4, (int)f6, (int)f2, (int)((float)texture3.getHeight() * f), f5);
        MainScreenState.DrawTexture(texture4, (int)f4 + (int)f2, (int)f6, (int)f2, (int)((float)texture3.getHeight() * f), f5);
        IndieGL.glBlendFunc(770, 1);
        MainScreenState.DrawTexture(texture5, (int)f4, 0, (int)f2, (int)f6, this.lightningDelta);
        MainScreenState.DrawTexture(texture6, (int)f4 + (int)f2, 0, (int)f2, (int)f6, this.lightningDelta);
        MainScreenState.DrawTexture(texture7, (int)f4, (int)f6, (int)f2, (int)f6, this.lightningDelta);
        MainScreenState.DrawTexture(texture8, (int)f4 + (int)f2, (int)f6, (int)f2, (int)f6, this.lightningDelta);
        IndieGL.glBlendFunc(770, 771);
    }

    @Override
    public GameStateMachine.StateAction update() {
        GameStateMachine.StateAction stateAction;
        if (this.connectToServerState != null && (stateAction = this.connectToServerState.update()) == GameStateMachine.StateAction.Continue) {
            this.connectToServerState.exit();
            this.connectToServerState = null;
            return GameStateMachine.StateAction.Remain;
        }
        LuaEventManager.triggerEvent("OnFETick", BoxedStaticValues.toDouble(0.0));
        if (this.RestartDebounceClickTimer > 0) {
            --this.RestartDebounceClickTimer;
        }
        for (int i = 0; i < this.Elements.size(); ++i) {
            ScreenElement screenElement = this.Elements.get(i);
            screenElement.update();
        }
        this.lastW = Core.getInstance().getOffscreenWidth(0);
        this.lastH = Core.getInstance().getOffscreenHeight(0);
        DebugFileWatcher.instance.update();
        ZomboidFileSystem.instance.update();
        try {
            Core.getInstance().CheckDelayResetLua();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        return GameStateMachine.StateAction.Remain;
    }

    public void setConnectToServerState(ConnectToServerState connectToServerState) {
        this.connectToServerState = connectToServerState;
    }

    @Override
    public GameState redirectState() {
        return null;
    }

    public static GLFWImage.Buffer loadIcons() {
        GLFWImage.Buffer buffer = null;
        String string = System.getProperty("os.name").toUpperCase(Locale.ENGLISH);
        if (string.contains("WIN")) {
            try {
                GLFWImage gLFWImage;
                ByteBuffer byteBuffer;
                buffer = GLFWImage.create((int)2);
                BufferedImage bufferedImage = ImageIO.read(new File("media" + File.separator + "ui" + File.separator + "zomboidIcon16.png").getAbsoluteFile());
                windowIconBB1 = byteBuffer = MainScreenState.loadInstance(bufferedImage, 16);
                windowIcon1 = gLFWImage = GLFWImage.create().set(16, 16, byteBuffer);
                buffer.put(0, (Struct)gLFWImage);
                bufferedImage = ImageIO.read(new File("media" + File.separator + "ui" + File.separator + "zomboidIcon32.png").getAbsoluteFile());
                windowIconBB2 = byteBuffer = MainScreenState.loadInstance(bufferedImage, 32);
                windowIcon2 = gLFWImage = GLFWImage.create().set(32, 32, byteBuffer);
                buffer.put(1, (Struct)gLFWImage);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (string.contains("MAC")) {
            try {
                GLFWImage gLFWImage;
                ByteBuffer byteBuffer;
                buffer = GLFWImage.create((int)1);
                BufferedImage bufferedImage = ImageIO.read(new File("media" + File.separator + "ui" + File.separator + "zomboidIcon128.png").getAbsoluteFile());
                windowIconBB1 = byteBuffer = MainScreenState.loadInstance(bufferedImage, 128);
                windowIcon1 = gLFWImage = GLFWImage.create().set(128, 128, byteBuffer);
                buffer.put(0, (Struct)gLFWImage);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            try {
                GLFWImage gLFWImage;
                ByteBuffer byteBuffer;
                buffer = GLFWImage.create((int)1);
                BufferedImage bufferedImage = ImageIO.read(new File("media" + File.separator + "ui" + File.separator + "zomboidIcon32.png").getAbsoluteFile());
                windowIconBB1 = byteBuffer = MainScreenState.loadInstance(bufferedImage, 32);
                windowIcon1 = gLFWImage = GLFWImage.create().set(32, 32, byteBuffer);
                buffer.put(0, (Struct)gLFWImage);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return buffer;
    }

    private static ByteBuffer loadInstance(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        double d = MainScreenState.getIconRatio(bufferedImage, bufferedImage2);
        double d2 = (double)bufferedImage.getWidth() * d;
        double d3 = (double)bufferedImage.getHeight() * d;
        graphics2D.drawImage(bufferedImage, (int)(((double)bufferedImage2.getWidth() - d2) / 2.0), (int)(((double)bufferedImage2.getHeight() - d3) / 2.0), (int)d2, (int)d3, null);
        graphics2D.dispose();
        return MainScreenState.convertToByteBuffer(bufferedImage2);
    }

    private static double getIconRatio(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        double d = 1.0;
        d = bufferedImage.getWidth() > bufferedImage2.getWidth() ? (double)bufferedImage2.getWidth() / (double)bufferedImage.getWidth() : (double)(bufferedImage2.getWidth() / bufferedImage.getWidth());
        if (bufferedImage.getHeight() > bufferedImage2.getHeight()) {
            double d2 = (double)bufferedImage2.getHeight() / (double)bufferedImage.getHeight();
            if (d2 < d) {
                d = d2;
            }
        } else {
            double d3 = bufferedImage2.getHeight() / bufferedImage.getHeight();
            if (d3 < d) {
                d = d3;
            }
        }
        return d;
    }

    public static ByteBuffer convertToByteBuffer(BufferedImage bufferedImage) {
        byte[] byArray = new byte[bufferedImage.getWidth() * bufferedImage.getHeight() * 4];
        int n = 0;
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int n2 = bufferedImage.getRGB(j, i);
                byArray[n + 0] = (byte)(n2 << 8 >> 24);
                byArray[n + 1] = (byte)(n2 << 16 >> 24);
                byArray[n + 2] = (byte)(n2 << 24 >> 24);
                byArray[n + 3] = (byte)(n2 >> 24);
                n += 4;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }

    private static void printSpecs() {
        try {
            File[] fileArray;
            System.out.println("===== System specs =====");
            long l = 1024L;
            long l2 = l * 1024L;
            long l3 = l2 * 1024L;
            Map<String, String> map = System.getenv();
            System.out.println("OS: " + System.getProperty("os.name") + ", version: " + System.getProperty("os.version") + ", arch: " + System.getProperty("os.arch"));
            if (map.containsKey("PROCESSOR_IDENTIFIER")) {
                System.out.println("Processor: " + map.get("PROCESSOR_IDENTIFIER"));
            }
            if (map.containsKey("NUMBER_OF_PROCESSORS")) {
                System.out.println("Processor cores: " + map.get("NUMBER_OF_PROCESSORS"));
            }
            System.out.println("Available processors (cores): " + Runtime.getRuntime().availableProcessors());
            System.out.println("Memory free: " + (float)Runtime.getRuntime().freeMemory() / (float)l2 + " MB");
            long l4 = Runtime.getRuntime().maxMemory();
            System.out.println("Memory max: " + (Serializable)(l4 == Long.MAX_VALUE ? "no limit" : Float.valueOf((float)l4 / (float)l2)) + " MB");
            System.out.println("Memory  total available to JVM: " + (float)Runtime.getRuntime().totalMemory() / (float)l2 + " MB");
            for (File file : fileArray = File.listRoots()) {
                System.out.println(file.getAbsolutePath() + ", Total: " + (float)file.getTotalSpace() / (float)l3 + " GB, Free: " + (float)file.getFreeSpace() / (float)l3 + " GB");
            }
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                System.out.println("Mobo = " + MainScreenState.wmic("baseboard", new String[]{"Product"}));
                System.out.println("CPU = " + MainScreenState.wmic("cpu", new String[]{"Manufacturer", "MaxClockSpeed", "Name"}));
                System.out.println("Graphics = " + MainScreenState.wmic("path Win32_videocontroller", new String[]{"AdapterRAM", "DriverVersion", "Name"}));
                System.out.println("VideoMode = " + MainScreenState.wmic("path Win32_videocontroller", new String[]{"VideoModeDescription"}));
                System.out.println("Sound = " + MainScreenState.wmic("path Win32_sounddevice", new String[]{"Manufacturer", "Name"}));
                System.out.println("Memory RAM = " + MainScreenState.wmic("memorychip", new String[]{"Capacity", "Manufacturer"}));
            }
            System.out.println("========================");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String wmic(String string, String[] stringArray) {
        Object object = "";
        try {
            String string2;
            String string3 = "WMIC " + string + " GET";
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = string3 + " " + stringArray[i];
                if (i >= stringArray.length - 1) continue;
                string3 = string3 + ",";
            }
            Process process = Runtime.getRuntime().exec(new String[]{"CMD", "/C", string3});
            process.getOutputStream().close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Object object2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                object2 = (String)object2 + string2;
            }
            for (String string4 : stringArray) {
                object2 = ((String)object2).replaceAll(string4, "");
            }
            String[] stringArray2 = ((String)(object2 = ((String)object2).trim().replaceAll(" ( )+", "="))).split("=");
            if (stringArray2.length > stringArray.length) {
                object = "{ ";
                var9_11 = stringArray2.length / stringArray.length;
                for (int i = 0; i < var9_11; ++i) {
                    object = (String)object + "[";
                    for (int j = 0; j < stringArray.length; ++j) {
                        int n = i * stringArray.length + j;
                        object = (String)object + stringArray[j] + "=" + stringArray2[n];
                        if (j >= stringArray.length - 1) continue;
                        object = (String)object + ",";
                    }
                    object = (String)object + "]";
                    if (i >= var9_11 - 1) continue;
                    object = (String)object + ", ";
                }
                object = (String)object + " }";
            } else {
                object = "[";
                for (var9_11 = 0; var9_11 < stringArray2.length; ++var9_11) {
                    object = (String)object + stringArray[var9_11] + "=" + stringArray2[var9_11];
                    if (var9_11 >= stringArray2.length - 1) continue;
                    object = (String)object + ",";
                }
                object = (String)object + "]";
            }
            return object;
        }
        catch (Exception exception) {
            return "Couldnt get info...";
        }
    }

    static {
        totalScale = 1.0f;
    }

    public static class ScreenElement {
        public float alpha = 0.0f;
        public float alphaStep = 0.2f;
        public boolean jumpBack = true;
        public float sx = 0.0f;
        public float sy = 0.0f;
        public float targetAlpha = 0.0f;
        public Texture tex;
        public int TicksTillTargetAlpha = 0;
        public float x = 0.0f;
        public int xCount = 1;
        public float xVel = 0.0f;
        public float xVelO = 0.0f;
        public float y = 0.0f;
        public float yVel = 0.0f;
        public float yVelO = 0.0f;

        public ScreenElement(Texture texture, int n, int n2, float f, float f2, int n3) {
            this.x = this.sx = (float)n;
            this.y = this.sy = (float)n2 - (float)texture.getHeight() * totalScale;
            this.xVel = f;
            this.yVel = f2;
            this.tex = texture;
            this.xCount = n3;
        }

        public void render() {
            int n = (int)this.x;
            int n2 = (int)this.y;
            for (int i = 0; i < this.xCount; ++i) {
                MainScreenState.DrawTexture(this.tex, n, n2, (int)((float)this.tex.getWidth() * totalScale), (int)((float)this.tex.getHeight() * totalScale), this.alpha);
                n = (int)((float)n + (float)this.tex.getWidth() * totalScale);
            }
            TextManager.instance.DrawStringRight(Core.getInstance().getOffscreenWidth(0) - 5, Core.getInstance().getOffscreenHeight(0) - 15, "Version: " + Version, 1.0, 1.0, 1.0, 1.0);
        }

        public void setY(float f) {
            this.y = this.sy = f - (float)this.tex.getHeight() * totalScale;
        }

        public void update() {
            this.x += this.xVel * totalScale;
            this.y += this.yVel * totalScale;
            --this.TicksTillTargetAlpha;
            if (this.TicksTillTargetAlpha <= 0) {
                this.targetAlpha = 1.0f;
            }
            if (this.jumpBack && this.sx - this.x > (float)this.tex.getWidth() * totalScale) {
                this.x += (float)this.tex.getWidth() * totalScale;
            }
            if (this.alpha < this.targetAlpha) {
                this.alpha += this.alphaStep;
                if (this.alpha > this.targetAlpha) {
                    this.alpha = this.targetAlpha;
                }
            } else if (this.alpha > this.targetAlpha) {
                this.alpha -= this.alphaStep;
                if (this.alpha < this.targetAlpha) {
                    this.alpha = this.targetAlpha;
                }
            }
        }
    }

    public class Credit {
        public int disappearDelay = 200;
        public Texture name;
        public float nameAlpha = 0.0f;
        public float nameAppearDelay = 40.0f;
        public float nameTargetAlpha = 0.0f;
        public Texture title;
        public float titleAlpha = 0.0f;
        public float titleTargetAlpha = 1.0f;

        public Credit(Texture texture, Texture texture2) {
            this.title = texture;
            this.name = texture2;
        }
    }
}

