/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.lwjglx.input.Keyboard;
import zombie.AmbientStreamManager;
import zombie.ChunkMapFilenames;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SoundManager;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatManager;
import zombie.chat.ChatUtility;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.ThreadGroups;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.raknet.UdpConnection;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.skinnedmodel.runtime.RuntimeAnimationScript;
import zombie.core.textures.Texture;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.gameStates.IngameState;
import zombie.globalObjects.CGlobalObjects;
import zombie.globalObjects.SGlobalObjects;
import zombie.input.GameKeyboard;
import zombie.input.JoypadManager;
import zombie.input.Mouse;
import zombie.inventory.RecipeManager;
import zombie.iso.IsoCamera;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoObjectPicker;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoWater;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.WorldStreamer;
import zombie.iso.areas.SafeHouse;
import zombie.iso.sprite.SkyBox;
import zombie.iso.weather.ClimateManager;
import zombie.modding.ActiveMods;
import zombie.modding.ActiveModsFile;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.NetworkAIParams;
import zombie.network.ServerOptions;
import zombie.scripting.ScriptManager;
import zombie.ui.TextManager;
import zombie.ui.TutorialManager;
import zombie.ui.UIFont;
import zombie.ui.UIManager;
import zombie.vehicles.BaseVehicle;
import zombie.world.WorldDictionary;

public final class GameLoadingState
extends GameState {
    public static Thread loader = null;
    public static boolean newGame = true;
    private static long startTime;
    public static boolean build23Stop;
    public static boolean unexpectedError;
    public static String GameLoadingString;
    public static boolean playerWrongIP;
    private static boolean bShowedUI;
    private static boolean bShowedClickToSkip;
    public static boolean mapDownloadFailed;
    private volatile boolean bWaitForAssetLoadingToFinish1 = false;
    private volatile boolean bWaitForAssetLoadingToFinish2 = false;
    private final Object assetLock1 = "Asset Lock 1";
    private final Object assetLock2 = "Asset Lock 2";
    private String text;
    private float width;
    public static boolean playerCreated;
    public static boolean bDone;
    public static boolean convertingWorld;
    public static int convertingFileCount;
    public static int convertingFileMax;
    public int Stage = 0;
    float TotalTime = 33.0f;
    float loadingDotTick = 0.0f;
    String loadingDot = "";
    private float clickToSkipAlpha = 1.0f;
    private boolean clickToSkipFadeIn = false;
    public float Time = 0.0f;
    public boolean bForceDone = false;

    @Override
    public void enter() {
        Object object;
        File file;
        if (GameClient.bClient) {
            this.text = Translator.getText("UI_DirectConnectionPortWarning", ServerOptions.getInstance().UDPPort.getValue());
            this.width = TextManager.instance.MeasureStringX(UIFont.NewMedium, this.text) + 8;
        }
        GameWindow.bLoadedAsClient = GameClient.bClient;
        GameWindow.OkToSaveOnExit = false;
        bShowedUI = false;
        ChunkMapFilenames.instance.clear();
        DebugLog.log("Savefile name is \"" + Core.GameSaveWorld + "\"");
        GameLoadingString = "";
        try {
            LuaManager.LoadDirBase("server");
            LuaManager.finishChecksum();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        RecipeManager.LoadedAfterLua();
        Core.getInstance().initFBOs();
        Core.getInstance().initShaders();
        SkyBox.getInstance();
        IsoPuddles.getInstance();
        IsoWater.getInstance();
        GameWindow.bServerDisconnected = false;
        if (GameClient.bClient && !GameClient.instance.bConnected) {
            GameClient.instance.init();
            Core.GameMode = "Multiplayer";
            while (GameClient.instance.ID == -1) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                GameClient.instance.update();
            }
            Core.GameSaveWorld = "clienttest" + GameClient.instance.ID;
            LuaManager.GlobalObject.deleteSave("clienttest" + GameClient.instance.ID);
            LuaManager.GlobalObject.createWorld("clienttest" + GameClient.instance.ID);
        }
        if (Core.GameSaveWorld.isEmpty()) {
            DebugLog.log("No savefile directory was specified.  It's a bug.");
            GameWindow.DoLoadingText("No savefile directory was specified.  The game will now close.  Sorry!");
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(-1);
        }
        if (!(file = new File(ZomboidFileSystem.instance.getCurrentSaveDir())).exists() && !Core.getInstance().isNoSave()) {
            DebugLog.log("The savefile directory doesn't exist.  It's a bug.");
            GameWindow.DoLoadingText("The savefile directory doesn't exist.  The game will now close.  Sorry!");
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(-1);
        }
        try {
            if (!(GameClient.bClient || GameServer.bServer || Core.bTutorial || Core.isLastStand() || "Multiplayer".equals(Core.GameMode))) {
                object = new FileWriter(new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "latestSave.ini"));
                ((Writer)object).write(IsoWorld.instance.getWorld() + "\r\n");
                ((Writer)object).write(Core.getInstance().getGameMode() + "\r\n");
                ((Writer)object).write(IsoWorld.instance.getDifficulty() + "\r\n");
                ((OutputStreamWriter)object).flush();
                ((OutputStreamWriter)object).close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        bDone = false;
        this.bForceDone = false;
        IsoChunkMap.CalcChunkWidth();
        LosUtil.init(IsoChunkMap.ChunkGridWidth * 10, IsoChunkMap.ChunkGridWidth * 10);
        this.Time = 0.0f;
        this.Stage = 0;
        this.clickToSkipAlpha = 1.0f;
        this.clickToSkipFadeIn = false;
        startTime = System.currentTimeMillis();
        SoundManager.instance.Purge();
        SoundManager.instance.setMusicState("Loading");
        LuaEventManager.triggerEvent("OnPreMapLoad");
        newGame = true;
        build23Stop = false;
        unexpectedError = false;
        mapDownloadFailed = false;
        playerCreated = false;
        convertingWorld = false;
        convertingFileCount = 0;
        convertingFileMax = -1;
        object = ZomboidFileSystem.instance.getFileInCurrentSave("map_ver.bin");
        if (((File)object).exists()) {
            newGame = false;
        }
        if (GameClient.bClient) {
            newGame = false;
        }
        WorldDictionary.setIsNewGame(newGame);
        GameKeyboard.bNoEventsWhileLoading = true;
        loader = new Thread(ThreadGroups.Workers, new Runnable(){

            @Override
            public void run() {
                try {
                    this.runInner();
                }
                catch (Throwable throwable) {
                    unexpectedError = true;
                    ExceptionLogger.logException(throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void runInner() throws Exception {
                GameLoadingState.this.bWaitForAssetLoadingToFinish1 = true;
                Object object = GameLoadingState.this.assetLock1;
                synchronized (object) {
                    while (GameLoadingState.this.bWaitForAssetLoadingToFinish1) {
                        try {
                            GameLoadingState.this.assetLock1.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                boolean bl = new File(ZomboidFileSystem.instance.getGameModeCacheDir() + File.separator).mkdir();
                BaseVehicle.LoadAllVehicleTextures();
                if (GameClient.bClient) {
                    GameClient.instance.GameLoadingRequestData();
                }
                TutorialManager.instance = new TutorialManager();
                GameTime.setInstance(new GameTime());
                ClimateManager.setInstance(new ClimateManager());
                IsoWorld.instance = new IsoWorld();
                DebugOptions.testThreadCrash(0);
                IsoWorld.instance.init();
                if (GameWindow.bServerDisconnected) {
                    bDone = true;
                    return;
                }
                if (playerWrongIP) {
                    return;
                }
                if (build23Stop) {
                    return;
                }
                LuaEventManager.triggerEvent("OnGameTimeLoaded");
                SGlobalObjects.initSystems();
                CGlobalObjects.initSystems();
                IsoObjectPicker.Instance.Init();
                TutorialManager.instance.init();
                TutorialManager.instance.CreateQuests();
                File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_t.bin");
                if (file.exists()) {
                    // empty if block
                }
                if (!GameServer.bServer) {
                    boolean bl2;
                    file = ZomboidFileSystem.instance.getFileInCurrentSave("map_ver.bin");
                    boolean bl3 = bl2 = !file.exists();
                    if (bl2 || IsoWorld.SavedWorldVersion != 195) {
                        if (!bl2 && IsoWorld.SavedWorldVersion != 195) {
                            GameLoadingString = "Saving converted world.";
                        }
                        try {
                            GameWindow.save(true);
                        }
                        catch (Throwable throwable) {
                            ExceptionLogger.logException(throwable);
                        }
                    }
                }
                ChatUtility.InitAllowedChatIcons();
                ChatManager.getInstance().init(true, IsoPlayer.getInstance());
                GameLoadingState.this.bWaitForAssetLoadingToFinish2 = true;
                Object object2 = GameLoadingState.this.assetLock2;
                synchronized (object2) {
                    while (GameLoadingState.this.bWaitForAssetLoadingToFinish2) {
                        try {
                            GameLoadingState.this.assetLock2.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                UIManager.bSuspend = false;
                playerCreated = true;
                GameLoadingString = "";
                GameLoadingState.SendDone();
            }
        });
        UIManager.bSuspend = true;
        loader.setName("GameLoadingThread");
        loader.setUncaughtExceptionHandler(GameWindow::uncaughtException);
        loader.start();
    }

    public static void SendDone() {
        DebugLog.log("game loading took " + (System.currentTimeMillis() - startTime + 999L) / 1000L + " seconds");
        if (!GameClient.bClient) {
            bDone = true;
            GameKeyboard.bNoEventsWhileLoading = false;
            return;
        }
        GameClient.instance.sendLoginQueueDone2(System.currentTimeMillis() - startTime);
    }

    public static void Done() {
        bDone = true;
        GameKeyboard.bNoEventsWhileLoading = false;
    }

    @Override
    public GameState redirectState() {
        return new IngameState();
    }

    @Override
    public void exit() {
        Object object;
        if (GameClient.bClient) {
            NetworkAIParams.Init();
        }
        UIManager.init();
        LuaEventManager.triggerEvent("OnCreatePlayer", 0, IsoPlayer.players[0]);
        loader = null;
        bDone = false;
        this.Stage = 0;
        IsoCamera.SetCharacterToFollow(IsoPlayer.getInstance());
        if (GameClient.bClient && !ServerOptions.instance.SafehouseAllowTrepass.getValue() && (object = SafeHouse.isSafeHouse(IsoPlayer.getInstance().getCurrentSquare(), GameClient.username, true)) != null) {
            IsoPlayer.getInstance().setX(((SafeHouse)object).getX() - 1);
            IsoPlayer.getInstance().setY(((SafeHouse)object).getY() - 1);
        }
        SoundManager.instance.stopMusic("");
        AmbientStreamManager.instance.init();
        if (IsoPlayer.getInstance() != null && IsoPlayer.getInstance().isAsleep()) {
            UIManager.setFadeBeforeUI(IsoPlayer.getInstance().getPlayerNum(), true);
            UIManager.FadeOut(IsoPlayer.getInstance().getPlayerNum(), 2.0);
            UIManager.setFadeTime(IsoPlayer.getInstance().getPlayerNum(), 0.0);
            UIManager.getSpeedControls().SetCurrentGameSpeed(3);
        }
        if (!GameClient.bClient) {
            object = ActiveMods.getById("currentGame");
            ((ActiveMods)object).checkMissingMods();
            ((ActiveMods)object).checkMissingMaps();
            ActiveMods.setLoadedMods((ActiveMods)object);
            String string = ZomboidFileSystem.instance.getFileNameInCurrentSave("mods.txt");
            ActiveModsFile activeModsFile = new ActiveModsFile();
            activeModsFile.write(string, (ActiveMods)object);
        }
        GameWindow.OkToSaveOnExit = true;
    }

    @Override
    public void render() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        this.loadingDotTick += GameTime.getInstance().getMultiplier();
        if (this.loadingDotTick > 20.0f) {
            this.loadingDot = ".";
        }
        if (this.loadingDotTick > 40.0f) {
            this.loadingDot = "..";
        }
        if (this.loadingDotTick > 60.0f) {
            this.loadingDot = "...";
        }
        if (this.loadingDotTick > 80.0f) {
            this.loadingDot = "";
            this.loadingDotTick = 0.0f;
        }
        this.Time += GameTime.instance.getTimeDelta();
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (this.Stage == 0) {
            f6 = this.Time;
            f5 = 0.0f;
            f4 = 1.0f;
            f3 = 5.0f;
            f2 = 7.0f;
            f = 0.0f;
            if (f6 > f5 && f6 < f4) {
                f = (f6 - f5) / (f4 - f5);
            }
            if (f6 >= f4 && f6 <= f3) {
                f = 1.0f;
            }
            if (f6 > f3 && f6 < f2) {
                f = 1.0f - (f6 - f3) / (f2 - f3);
            }
            if (f6 >= f2) {
                ++this.Stage;
            }
            f7 = f;
        }
        if (this.Stage == 1) {
            f6 = this.Time;
            f5 = 7.0f;
            f4 = 8.0f;
            f3 = 13.0f;
            f2 = 15.0f;
            f = 0.0f;
            if (f6 > f5 && f6 < f4) {
                f = (f6 - f5) / (f4 - f5);
            }
            if (f6 >= f4 && f6 <= f3) {
                f = 1.0f;
            }
            if (f6 > f3 && f6 < f2) {
                f = 1.0f - (f6 - f3) / (f2 - f3);
            }
            if (f6 >= f2) {
                ++this.Stage;
            }
            f8 = f;
        }
        if (this.Stage == 2) {
            f6 = this.Time;
            f5 = 15.0f;
            f4 = 16.0f;
            f3 = 31.0f;
            f2 = this.TotalTime;
            f = 0.0f;
            if (f6 > f5 && f6 < f4) {
                f = (f6 - f5) / (f4 - f5);
            }
            if (f6 >= f4 && f6 <= f3) {
                f = 1.0f;
            }
            if (f6 > f3 && f6 < f2) {
                f = 1.0f - (f6 - f3) / (f2 - f3);
            }
            if (f6 >= f2) {
                ++this.Stage;
            }
            f9 = f;
        }
        Core.getInstance().StartFrame();
        Core.getInstance().EndFrame();
        boolean bl = UIManager.useUIFBO;
        UIManager.useUIFBO = false;
        Core.getInstance().StartFrameUI();
        SpriteRenderer.instance.renderi(null, 0, 0, Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), 0.0f, 0.0f, 0.0f, 1.0f, null);
        if (mapDownloadFailed) {
            int n = Core.getInstance().getScreenWidth() / 2;
            int n2 = Core.getInstance().getScreenHeight() / 2;
            int n3 = TextManager.instance.getFontFromEnum(UIFont.Medium).getLineHeight();
            int n4 = n2 - n3 / 2;
            String string = Translator.getText("UI_GameLoad_MapDownloadFailed");
            TextManager.instance.DrawStringCentre(UIFont.Medium, n, n4, string, 0.8, 0.1, 0.1, 1.0);
            UIManager.render();
            Core.getInstance().EndFrameUI();
            return;
        }
        if (unexpectedError) {
            int n = TextManager.instance.getFontFromEnum(UIFont.Medium).getLineHeight();
            int n5 = TextManager.instance.getFontFromEnum(UIFont.Small).getLineHeight();
            int n6 = 8;
            int n7 = 2;
            int n8 = n + n6 + n5 + n7 + n5;
            int n9 = Core.getInstance().getScreenWidth() / 2;
            int n10 = Core.getInstance().getScreenHeight() / 2;
            int n11 = n10 - n8 / 2;
            TextManager.instance.DrawStringCentre(UIFont.Medium, n9, n11, Translator.getText("UI_GameLoad_UnexpectedError1"), 0.8, 0.1, 0.1, 1.0);
            TextManager.instance.DrawStringCentre(UIFont.Small, n9, n11 + n + n6, Translator.getText("UI_GameLoad_UnexpectedError2"), 1.0, 1.0, 1.0, 1.0);
            String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "console.txt";
            TextManager.instance.DrawStringCentre(UIFont.Small, n9, n11 + n + n6 + n5 + n7, string, 1.0, 1.0, 1.0, 1.0);
            UIManager.render();
            Core.getInstance().EndFrameUI();
            return;
        }
        if (GameWindow.bServerDisconnected) {
            int n = Core.getInstance().getScreenWidth() / 2;
            int n12 = Core.getInstance().getScreenHeight() / 2;
            int n13 = TextManager.instance.getFontFromEnum(UIFont.Medium).getLineHeight();
            int n14 = 2;
            int n15 = n12 - (n13 + n14 + n13) / 2;
            String string = GameWindow.kickReason;
            if (string == null) {
                string = Translator.getText("UI_OnConnectFailed_ConnectionLost");
            }
            TextManager.instance.DrawStringCentre(UIFont.Medium, n, n15, string, 0.8, 0.1, 0.1, 1.0);
            UIManager.render();
            Core.getInstance().EndFrameUI();
            return;
        }
        if (build23Stop) {
            TextManager.instance.DrawStringCentre(UIFont.Small, Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() - 100, "This save is incompatible. Please switch to Steam branch \"build23\" to continue this save.", 0.8, 0.1, 0.1, 1.0);
        } else if (convertingWorld) {
            TextManager.instance.DrawStringCentre(UIFont.Small, Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() - 100, Translator.getText("UI_ConvertWorld"), 0.5, 0.5, 0.5, 1.0);
            if (convertingFileMax != -1) {
                TextManager.instance.DrawStringCentre(UIFont.Small, Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() - 100 + TextManager.instance.getFontFromEnum(UIFont.Small).getLineHeight() + 8, convertingFileCount + " / " + convertingFileMax, 0.5, 0.5, 0.5, 1.0);
            }
        }
        if (playerWrongIP) {
            int n = Core.getInstance().getScreenWidth() / 2;
            int n16 = Core.getInstance().getScreenHeight() / 2;
            int n17 = TextManager.instance.getFontFromEnum(UIFont.Medium).getLineHeight();
            int n18 = 2;
            int n19 = n16 - (n17 + n18 + n17) / 2;
            String string = GameLoadingString;
            if (GameLoadingString == null) {
                string = "";
            }
            TextManager.instance.DrawStringCentre(UIFont.Medium, n, n19, string, 0.8, 0.1, 0.1, 1.0);
            UIManager.render();
            Core.getInstance().EndFrameUI();
            return;
        }
        if (GameClient.bClient) {
            String string = GameLoadingString;
            if (GameLoadingString == null) {
                string = "";
            }
            TextManager.instance.DrawStringCentre(UIFont.Small, Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() - 60, string, 0.5, 0.5, 0.5, 1.0);
            if (GameClient.connection.getConnectionType() == UdpConnection.ConnectionType.Steam) {
                SpriteRenderer.instance.render(null, ((float)Core.getInstance().getScreenWidth() - this.width) / 2.0f, Core.getInstance().getScreenHeight() - 32, this.width, 18.0f, 1.0f, 0.4f, 0.35f, 0.8f, null);
                TextManager.instance.DrawStringCentre(UIFont.Medium, Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() - 32, this.text, 0.1, 0.1, 0.1, 1.0);
            }
        } else if (!playerCreated && newGame && !Core.isLastStand()) {
            TextManager.instance.DrawStringCentre(UIFont.Small, Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() - 60, Translator.getText("UI_Loading").replace(".", ""), 0.5, 0.5, 0.5, 1.0);
            TextManager.instance.DrawString(UIFont.Small, Core.getInstance().getScreenWidth() / 2 + TextManager.instance.MeasureStringX(UIFont.Small, Translator.getText("UI_Loading").replace(".", "")) / 2 + 1, Core.getInstance().getScreenHeight() - 60, this.loadingDot, 0.5, 0.5, 0.5, 1.0);
        }
        if (this.Stage == 0) {
            int n = Core.getInstance().getScreenWidth() / 2;
            int n20 = Core.getInstance().getScreenHeight() / 2 - TextManager.instance.getFontFromEnum(UIFont.Intro).getLineHeight() / 2;
            TextManager.instance.DrawStringCentre(UIFont.Intro, n, n20, Translator.getText("UI_Intro1"), 1.0, 1.0, 1.0, f7);
        }
        if (this.Stage == 1) {
            int n = Core.getInstance().getScreenWidth() / 2;
            int n21 = Core.getInstance().getScreenHeight() / 2 - TextManager.instance.getFontFromEnum(UIFont.Intro).getLineHeight() / 2;
            TextManager.instance.DrawStringCentre(UIFont.Intro, n, n21, Translator.getText("UI_Intro2"), 1.0, 1.0, 1.0, f8);
        }
        if (this.Stage == 2) {
            int n = Core.getInstance().getScreenWidth() / 2;
            int n22 = Core.getInstance().getScreenHeight() / 2 - TextManager.instance.getFontFromEnum(UIFont.Intro).getLineHeight() / 2;
            TextManager.instance.DrawStringCentre(UIFont.Intro, n, n22, Translator.getText("UI_Intro3"), 1.0, 1.0, 1.0, f9);
        }
        if (Core.getInstance().getDebug()) {
            bShowedClickToSkip = true;
        }
        if (bDone && playerCreated && (!newGame || this.Time >= this.TotalTime || Core.isLastStand() || "Tutorial".equals(Core.GameMode))) {
            if (this.clickToSkipFadeIn) {
                this.clickToSkipAlpha += GameTime.getInstance().getMultiplier() / 1.6f / 30.0f;
                if (this.clickToSkipAlpha > 1.0f) {
                    this.clickToSkipAlpha = 1.0f;
                    this.clickToSkipFadeIn = false;
                }
            } else {
                bShowedClickToSkip = true;
                this.clickToSkipAlpha -= GameTime.getInstance().getMultiplier() / 1.6f / 30.0f;
                if (this.clickToSkipAlpha < 0.25f) {
                    this.clickToSkipFadeIn = true;
                }
            }
            if (GameWindow.ActivatedJoyPad == null || JoypadManager.instance.JoypadList.isEmpty()) {
                TextManager.instance.DrawStringCentre(UIFont.NewLarge, Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() - 60, Translator.getText("UI_ClickToSkip"), 1.0, 1.0, 1.0, this.clickToSkipAlpha);
            } else {
                Texture texture = Texture.getSharedTexture("media/ui/xbox/XBOX_A.png");
                if (texture != null) {
                    int n = TextManager.instance.getFontFromEnum(UIFont.Small).getLineHeight();
                    SpriteRenderer.instance.renderi(texture, Core.getInstance().getScreenWidth() / 2 - TextManager.instance.MeasureStringX(UIFont.Small, Translator.getText("UI_PressAToStart")) / 2 - 8 - texture.getWidth(), Core.getInstance().getScreenHeight() - 60 + n / 2 - texture.getHeight() / 2, texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 1.0f, this.clickToSkipAlpha, null);
                }
                TextManager.instance.DrawStringCentre(UIFont.Small, Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() - 60, Translator.getText("UI_PressAToStart"), 1.0, 1.0, 1.0, this.clickToSkipAlpha);
            }
        }
        ActiveMods.renderUI();
        Core.getInstance().EndFrameUI();
        UIManager.useUIFBO = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GameStateMachine.StateAction update() {
        Object object;
        if (this.bWaitForAssetLoadingToFinish1 && !OutfitManager.instance.isLoadingClothingItems()) {
            if (Core.bDebug) {
                OutfitManager.instance.debugOutfits();
            }
            object = this.assetLock1;
            synchronized (object) {
                this.bWaitForAssetLoadingToFinish1 = false;
                this.assetLock1.notifyAll();
            }
        }
        if (this.bWaitForAssetLoadingToFinish2 && !ModelManager.instance.isLoadingAnimations() && !GameWindow.fileSystem.hasWork()) {
            object = this.assetLock2;
            synchronized (object) {
                this.bWaitForAssetLoadingToFinish2 = false;
                this.assetLock2.notifyAll();
                ArrayList<RuntimeAnimationScript> arrayList = ScriptManager.instance.getAllRuntimeAnimationScripts();
                for (RuntimeAnimationScript runtimeAnimationScript : arrayList) {
                    runtimeAnimationScript.exec();
                }
            }
        }
        if (unexpectedError || GameWindow.bServerDisconnected || playerWrongIP) {
            if (!bShowedUI) {
                bShowedUI = true;
                IsoPlayer.setInstance(null);
                IsoPlayer.players[0] = null;
                UIManager.UI.clear();
                LuaEventManager.Reset();
                LuaManager.call("ISGameLoadingUI_OnGameLoadingUI", "");
                UIManager.bSuspend = false;
            }
            if (Keyboard.isKeyDown((int)1)) {
                GameClient.instance.Shutdown();
                SteamUtils.shutdown();
                System.exit(1);
            }
            return GameStateMachine.StateAction.Remain;
        }
        if (!bDone) {
            return GameStateMachine.StateAction.Remain;
        }
        if (WorldStreamer.instance.isBusy()) {
            return GameStateMachine.StateAction.Remain;
        }
        if (ModelManager.instance.isLoadingAnimations()) {
            return GameStateMachine.StateAction.Remain;
        }
        if (!bShowedClickToSkip) {
            return GameStateMachine.StateAction.Remain;
        }
        if (Mouse.isButtonDown(0)) {
            this.bForceDone = true;
        }
        if (GameWindow.ActivatedJoyPad != null && GameWindow.ActivatedJoyPad.isAPressed()) {
            this.bForceDone = true;
        }
        if (this.bForceDone) {
            SoundManager.instance.playUISound("UIClickToStart");
            this.bForceDone = false;
            return GameStateMachine.StateAction.Continue;
        }
        return GameStateMachine.StateAction.Remain;
    }

    static {
        build23Stop = false;
        unexpectedError = false;
        GameLoadingString = "";
        playerWrongIP = false;
        bShowedUI = false;
        bShowedClickToSkip = false;
        mapDownloadFailed = false;
        playerCreated = false;
        bDone = false;
        convertingWorld = false;
        convertingFileCount = -1;
        convertingFileMax = -1;
    }
}

