/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.skinnedmodel.ModelManager;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.input.GameKeyboard;
import zombie.scripting.ScriptManager;
import zombie.scripting.ScriptParser;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.ModelScript;
import zombie.ui.UIElement;
import zombie.ui.UIManager;
import zombie.vehicles.EditVehicleState;

public final class AttachmentEditorState
extends GameState {
    public static AttachmentEditorState instance;
    private EditVehicleState.LuaEnvironment m_luaEnv;
    private boolean bExit = false;
    private final ArrayList<UIElement> m_gameUI = new ArrayList();
    private final ArrayList<UIElement> m_selfUI = new ArrayList();
    private boolean m_bSuspendUI;
    private KahluaTable m_table = null;

    @Override
    public void enter() {
        instance = this;
        if (this.m_luaEnv == null) {
            this.m_luaEnv = new EditVehicleState.LuaEnvironment(LuaManager.platform, LuaManager.converterManager, LuaManager.env);
        }
        this.saveGameUI();
        if (this.m_selfUI.size() == 0) {
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_luaEnv.env.rawget((Object)"AttachmentEditorState_InitUI"), new Object[0]);
            if (this.m_table != null && this.m_table.getMetatable() != null) {
                this.m_table.getMetatable().rawset((Object)"_LUA_RELOADED_CHECK", (Object)Boolean.FALSE);
            }
        } else {
            UIManager.UI.addAll(this.m_selfUI);
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_table.rawget((Object)"showUI"), (Object)this.m_table);
        }
        this.bExit = false;
    }

    @Override
    public void yield() {
        this.restoreGameUI();
    }

    @Override
    public void reenter() {
        this.saveGameUI();
    }

    @Override
    public void exit() {
        this.restoreGameUI();
    }

    @Override
    public void render() {
        int n = 0;
        Core.getInstance().StartFrame(n, true);
        this.renderScene();
        Core.getInstance().EndFrame(n);
        Core.getInstance().RenderOffScreenBuffer();
        if (Core.getInstance().StartFrameUI()) {
            this.renderUI();
        }
        Core.getInstance().EndFrameUI();
    }

    @Override
    public GameStateMachine.StateAction update() {
        if (this.bExit || GameKeyboard.isKeyPressed(65)) {
            return GameStateMachine.StateAction.Continue;
        }
        this.updateScene();
        return GameStateMachine.StateAction.Remain;
    }

    public static AttachmentEditorState checkInstance() {
        if (instance != null) {
            if (AttachmentEditorState.instance.m_table == null || AttachmentEditorState.instance.m_table.getMetatable() == null) {
                instance = null;
            } else if (AttachmentEditorState.instance.m_table.getMetatable().rawget((Object)"_LUA_RELOADED_CHECK") == null) {
                instance = null;
            }
        }
        if (instance == null) {
            return new AttachmentEditorState();
        }
        return instance;
    }

    private void saveGameUI() {
        this.m_gameUI.clear();
        this.m_gameUI.addAll(UIManager.UI);
        UIManager.UI.clear();
        this.m_bSuspendUI = UIManager.bSuspend;
        UIManager.bSuspend = false;
        UIManager.setShowPausedMessage(false);
        UIManager.defaultthread = this.m_luaEnv.thread;
    }

    private void restoreGameUI() {
        this.m_selfUI.clear();
        this.m_selfUI.addAll(UIManager.UI);
        UIManager.UI.clear();
        UIManager.UI.addAll(this.m_gameUI);
        UIManager.bSuspend = this.m_bSuspendUI;
        UIManager.setShowPausedMessage(true);
        UIManager.defaultthread = LuaManager.thread;
    }

    private void updateScene() {
        ModelManager.instance.update();
        if (GameKeyboard.isKeyPressed(17)) {
            DebugOptions.instance.ModelRenderWireframe.setValue(!DebugOptions.instance.ModelRenderWireframe.getValue());
        }
    }

    private void renderScene() {
    }

    private void renderUI() {
        UIManager.render();
    }

    public void setTable(KahluaTable kahluaTable) {
        this.m_table = kahluaTable;
    }

    public Object fromLua0(String string) {
        switch (string) {
            case "exit": {
                this.bExit = true;
                return null;
            }
        }
        throw new IllegalArgumentException("unhandled \"" + string + "\"");
    }

    public Object fromLua1(String string, Object object) {
        switch (string) {
            case "writeScript": {
                ModelScript modelScript = ScriptManager.instance.getModelScript((String)object);
                if (modelScript == null) {
                    throw new NullPointerException("model script \"" + object + "\" not found");
                }
                ArrayList<String> arrayList = this.readScript(modelScript.getFileName());
                if (arrayList != null) {
                    this.updateScript(modelScript.getFileName(), arrayList, modelScript);
                }
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\"", string, object));
    }

    private ArrayList<String> readScript(String string) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        string = ZomboidFileSystem.instance.getString(string);
        File file = new File(string);
        try {
            object = new FileReader(file);
            try (BufferedReader bufferedReader = new BufferedReader((Reader)object);){
                String string2;
                String string3 = System.lineSeparator();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append(string3);
                }
            }
            finally {
                ((InputStreamReader)object).close();
            }
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
            return null;
        }
        object = ScriptParser.stripComments(stringBuilder.toString());
        return ScriptParser.parseTokens((String)object);
    }

    private void updateScript(String string, ArrayList<String> arrayList, ModelScript modelScript) {
        string = ZomboidFileSystem.instance.getString(string);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            String string2;
            String string3 = arrayList.get(i).trim();
            int n = string3.indexOf("{");
            int n2 = string3.lastIndexOf("}");
            String string4 = string3.substring(0, n);
            if (!string4.startsWith("module")) continue;
            string4 = string3.substring(0, n).trim();
            String[] stringArray = string4.split("\\s+");
            String string5 = string2 = stringArray.length > 1 ? stringArray[1].trim() : "";
            if (!string2.equals(modelScript.getModule().getName())) continue;
            String string6 = string3.substring(n + 1, n2).trim();
            ArrayList<String> arrayList2 = ScriptParser.parseTokens(string6);
            for (int j = arrayList2.size() - 1; j >= 0; --j) {
                String string7;
                String string8 = arrayList2.get(j).trim();
                if (!string8.startsWith("model")) continue;
                n = string8.indexOf("{");
                string4 = string8.substring(0, n).trim();
                stringArray = string4.split("\\s+");
                String string9 = string7 = stringArray.length > 1 ? stringArray[1].trim() : "";
                if (!string7.equals(modelScript.getName())) continue;
                string8 = this.modelScriptToText(modelScript, string8).trim();
                arrayList2.set(j, string8);
                String string10 = System.lineSeparator();
                Object object = String.join((CharSequence)(string10 + "\t"), arrayList2);
                object = "module " + string2 + string10 + "{" + string10 + "\t" + (String)object + string10 + "}" + string10;
                arrayList.set(i, (String)object);
                this.writeScript(string, arrayList);
                return;
            }
        }
    }

    private String modelScriptToText(ModelScript modelScript, String string) {
        Object object;
        int n;
        ScriptParser.Block block = ScriptParser.parse(string);
        block = block.children.get(0);
        for (n = block.children.size() - 1; n >= 0; --n) {
            object = block.children.get(n);
            if (!"attachment".equals(((ScriptParser.Block)object).type)) continue;
            block.elements.remove(object);
            block.children.remove(n);
        }
        for (n = 0; n < modelScript.getAttachmentCount(); ++n) {
            object = modelScript.getAttachment(n);
            ScriptParser.Block block2 = block.getBlock("attachment", ((ModelAttachment)object).getId());
            if (block2 == null) {
                block2 = new ScriptParser.Block();
                block2.type = "attachment";
                block2.id = ((ModelAttachment)object).getId();
                block2.setValue("offset", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(((ModelAttachment)object).getOffset().x()), Float.valueOf(((ModelAttachment)object).getOffset().y()), Float.valueOf(((ModelAttachment)object).getOffset().z())));
                block2.setValue("rotate", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(((ModelAttachment)object).getRotate().x()), Float.valueOf(((ModelAttachment)object).getRotate().y()), Float.valueOf(((ModelAttachment)object).getRotate().z())));
                if (((ModelAttachment)object).getBone() != null) {
                    block2.setValue("bone", ((ModelAttachment)object).getBone());
                }
                block.elements.add(block2);
                block.children.add(block2);
                continue;
            }
            block2.setValue("offset", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(((ModelAttachment)object).getOffset().x()), Float.valueOf(((ModelAttachment)object).getOffset().y()), Float.valueOf(((ModelAttachment)object).getOffset().z())));
            block2.setValue("rotate", String.format(Locale.US, "%.4f %.4f %.4f", Float.valueOf(((ModelAttachment)object).getRotate().x()), Float.valueOf(((ModelAttachment)object).getRotate().y()), Float.valueOf(((ModelAttachment)object).getRotate().z())));
        }
        StringBuilder stringBuilder = new StringBuilder();
        object = System.lineSeparator();
        block.prettyPrint(1, stringBuilder, (String)object);
        return stringBuilder.toString();
    }

    private void writeScript(String string, ArrayList<String> arrayList) {
        String string2 = ZomboidFileSystem.instance.getString(string);
        File file = new File(string2);
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            DebugLog.General.printf("writing %s\n", string);
            for (String string3 : arrayList) {
                bufferedWriter.write(string3);
            }
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_table.rawget((Object)"wroteScript"), new Object[]{this.m_table, string2});
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
    }
}

