/*
 * Decompiled with CFR 0.152.
 */
package zombie.gameStates;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.ZomboidFileSystem;
import zombie.config.BooleanConfigOption;
import zombie.config.ConfigFile;
import zombie.config.ConfigOption;
import zombie.core.Core;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.debug.DebugOptions;
import zombie.gameStates.GameState;
import zombie.gameStates.GameStateMachine;
import zombie.input.GameKeyboard;
import zombie.ui.UIElement;
import zombie.ui.UIManager;
import zombie.vehicles.EditVehicleState;

public final class AnimationViewerState
extends GameState {
    public static AnimationViewerState instance;
    private EditVehicleState.LuaEnvironment m_luaEnv;
    private boolean bExit = false;
    private final ArrayList<UIElement> m_gameUI = new ArrayList();
    private final ArrayList<UIElement> m_selfUI = new ArrayList();
    private boolean m_bSuspendUI;
    private KahluaTable m_table = null;
    private final ArrayList<String> m_clipNames = new ArrayList();
    private static final int VERSION = 1;
    private final ArrayList<ConfigOption> options = new ArrayList();
    private BooleanDebugOption DrawGrid = new BooleanDebugOption("DrawGrid", false);
    private BooleanDebugOption Isometric = new BooleanDebugOption("Isometric", false);
    private BooleanDebugOption UseDeferredMovement = new BooleanDebugOption("UseDeferredMovement", false);

    @Override
    public void enter() {
        instance = this;
        this.load();
        if (this.m_luaEnv == null) {
            this.m_luaEnv = new EditVehicleState.LuaEnvironment(LuaManager.platform, LuaManager.converterManager, LuaManager.env);
        }
        this.saveGameUI();
        if (this.m_selfUI.size() == 0) {
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_luaEnv.env.rawget((Object)"AnimationViewerState_InitUI"), new Object[0]);
            if (this.m_table != null && this.m_table.getMetatable() != null) {
                this.m_table.getMetatable().rawset((Object)"_LUA_RELOADED_CHECK", (Object)Boolean.FALSE);
            }
        } else {
            UIManager.UI.addAll(this.m_selfUI);
            this.m_luaEnv.caller.pcall(this.m_luaEnv.thread, this.m_table.rawget((Object)"showUI"), (Object)this.m_table);
        }
        this.bExit = false;
    }

    @Override
    public void yield() {
        this.restoreGameUI();
    }

    @Override
    public void reenter() {
        this.saveGameUI();
    }

    @Override
    public void exit() {
        this.save();
        this.restoreGameUI();
    }

    @Override
    public void render() {
        int n = 0;
        Core.getInstance().StartFrame(n, true);
        this.renderScene();
        Core.getInstance().EndFrame(n);
        Core.getInstance().RenderOffScreenBuffer();
        boolean bl = UIManager.useUIFBO = Core.getInstance().supportsFBO() && Core.OptionUIFBO;
        if (Core.getInstance().StartFrameUI()) {
            this.renderUI();
        }
        Core.getInstance().EndFrameUI();
    }

    @Override
    public GameStateMachine.StateAction update() {
        if (this.bExit || GameKeyboard.isKeyPressed(65)) {
            return GameStateMachine.StateAction.Continue;
        }
        this.updateScene();
        return GameStateMachine.StateAction.Remain;
    }

    public static AnimationViewerState checkInstance() {
        if (instance != null) {
            if (AnimationViewerState.instance.m_table == null || AnimationViewerState.instance.m_table.getMetatable() == null) {
                instance = null;
            } else if (AnimationViewerState.instance.m_table.getMetatable().rawget((Object)"_LUA_RELOADED_CHECK") == null) {
                instance = null;
            }
        }
        if (instance == null) {
            return new AnimationViewerState();
        }
        return instance;
    }

    private void saveGameUI() {
        this.m_gameUI.clear();
        this.m_gameUI.addAll(UIManager.UI);
        UIManager.UI.clear();
        this.m_bSuspendUI = UIManager.bSuspend;
        UIManager.bSuspend = false;
        UIManager.setShowPausedMessage(false);
        UIManager.defaultthread = this.m_luaEnv.thread;
    }

    private void restoreGameUI() {
        this.m_selfUI.clear();
        this.m_selfUI.addAll(UIManager.UI);
        UIManager.UI.clear();
        UIManager.UI.addAll(this.m_gameUI);
        UIManager.bSuspend = this.m_bSuspendUI;
        UIManager.setShowPausedMessage(true);
        UIManager.defaultthread = LuaManager.thread;
    }

    private void updateScene() {
        ModelManager.instance.update();
        if (GameKeyboard.isKeyPressed(17)) {
            DebugOptions.instance.ModelRenderWireframe.setValue(!DebugOptions.instance.ModelRenderWireframe.getValue());
        }
    }

    private void renderScene() {
    }

    private void renderUI() {
        UIManager.render();
    }

    public void setTable(KahluaTable kahluaTable) {
        this.m_table = kahluaTable;
    }

    public Object fromLua0(String string) {
        switch (string) {
            case "exit": {
                this.bExit = true;
                return null;
            }
            case "getClipNames": {
                if (this.m_clipNames.isEmpty()) {
                    Collection<AnimationClip> collection = ModelManager.instance.getAllAnimationClips();
                    for (AnimationClip animationClip : collection) {
                        this.m_clipNames.add(animationClip.Name);
                    }
                    this.m_clipNames.sort(Comparator.naturalOrder());
                }
                return this.m_clipNames;
            }
        }
        throw new IllegalArgumentException("unhandled \"" + string + "\"");
    }

    public Object fromLua1(String string, Object object) {
        switch (string) {
            default: 
        }
        throw new IllegalArgumentException(String.format("unhandled \"%s\" \"%s\"", string, object));
    }

    public ConfigOption getOptionByName(String string) {
        for (int i = 0; i < this.options.size(); ++i) {
            ConfigOption configOption = this.options.get(i);
            if (!configOption.getName().equals(string)) continue;
            return configOption;
        }
        return null;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public ConfigOption getOptionByIndex(int n) {
        return this.options.get(n);
    }

    public void setBoolean(String string, boolean bl) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            ((BooleanConfigOption)configOption).setValue(bl);
        }
    }

    public boolean getBoolean(String string) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            return ((BooleanConfigOption)configOption).getValue();
        }
        return false;
    }

    public void save() {
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "animationViewerState-options.ini";
        ConfigFile configFile = new ConfigFile();
        configFile.write(string, 1, this.options);
    }

    public void load() {
        ConfigFile configFile = new ConfigFile();
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "animationViewerState-options.ini";
        if (configFile.read(string)) {
            for (int i = 0; i < configFile.getOptions().size(); ++i) {
                ConfigOption configOption = configFile.getOptions().get(i);
                ConfigOption configOption2 = this.getOptionByName(configOption.getName());
                if (configOption2 == null) continue;
                configOption2.parse(configOption.getValueAsString());
            }
        }
    }

    public class BooleanDebugOption
    extends BooleanConfigOption {
        public BooleanDebugOption(String string, boolean bl) {
            super(string, bl);
            AnimationViewerState.this.options.add(this);
        }
    }
}

