/*
 * Decompiled with CFR 0.152.
 */
package zombie.fileSystem;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import zombie.ZomboidFileSystem;
import zombie.core.textures.TexturePackPage;
import zombie.fileSystem.FileSystem;
import zombie.fileSystem.IFile;
import zombie.fileSystem.IFileDevice;

public final class TexturePackDevice
implements IFileDevice {
    static final int VERSION1 = 1;
    static final int VERSION_LATEST = 1;
    String m_name;
    String m_filename;
    int m_version = -1;
    final ArrayList<Page> m_pages = new ArrayList();
    final HashMap<String, Page> m_pagemap = new HashMap();
    final HashMap<String, SubTexture> m_submap = new HashMap();
    int m_textureFlags;

    private static long skipInput(InputStream inputStream, long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            long l3 = inputStream.skip(l - l2);
            if (l3 <= 0L) continue;
            l2 += l3;
        }
        return l2;
    }

    public TexturePackDevice(String string, int n) {
        this.m_name = string;
        this.m_filename = ZomboidFileSystem.instance.getString("media/texturepacks/" + string + ".pack");
        this.m_textureFlags = n;
    }

    @Override
    public IFile createFile(IFile iFile) {
        return null;
    }

    @Override
    public void destroyFile(IFile iFile) {
    }

    @Override
    public InputStream createStream(String string, InputStream inputStream) throws IOException {
        this.initMetaData();
        return new TexturePackInputStream(string, this);
    }

    @Override
    public void destroyStream(InputStream inputStream) {
        if (inputStream instanceof TexturePackInputStream) {
            // empty if block
        }
    }

    @Override
    public String name() {
        return this.m_name;
    }

    public void getSubTextureInfo(FileSystem.TexturePackTextures texturePackTextures) throws IOException {
        this.initMetaData();
        for (SubTexture subTexture : this.m_submap.values()) {
            FileSystem.SubTexture subTexture2 = new FileSystem.SubTexture(this.name(), subTexture.m_page.m_name, subTexture.m_info);
            texturePackTextures.put(subTexture.m_info.name, subTexture2);
        }
    }

    private void initMetaData() throws IOException {
        if (!this.m_pages.isEmpty()) {
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(this.m_filename);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
             PositionInputStream positionInputStream = new PositionInputStream(bufferedInputStream);){
            positionInputStream.mark(4);
            int n = positionInputStream.read();
            int n2 = positionInputStream.read();
            int n3 = positionInputStream.read();
            int n4 = positionInputStream.read();
            if (n == 80 && n2 == 90 && n3 == 80 && n4 == 75) {
                this.m_version = TexturePackPage.readInt(positionInputStream);
                if (this.m_version < 1 || this.m_version > 1) {
                    throw new IOException("invalid .pack file version " + this.m_version);
                }
            } else {
                positionInputStream.reset();
                this.m_version = 0;
            }
            int n5 = TexturePackPage.readInt(positionInputStream);
            for (int i = 0; i < n5; ++i) {
                Page page = this.readPage(positionInputStream);
                this.m_pages.add(page);
                this.m_pagemap.put(page.m_name, page);
                for (TexturePackPage.SubTextureInfo subTextureInfo : page.m_sub) {
                    this.m_submap.put(subTextureInfo.name, new SubTexture(page, subTextureInfo));
                }
            }
        }
    }

    private Page readPage(PositionInputStream positionInputStream) throws IOException {
        int n;
        Page page = new Page();
        String string = TexturePackPage.ReadString(positionInputStream);
        int n2 = TexturePackPage.readInt(positionInputStream);
        boolean bl = TexturePackPage.readInt(positionInputStream) != 0;
        page.m_name = string;
        page.m_has_alpha = bl;
        for (n = 0; n < n2; ++n) {
            String string2 = TexturePackPage.ReadString(positionInputStream);
            int n3 = TexturePackPage.readInt(positionInputStream);
            int n4 = TexturePackPage.readInt(positionInputStream);
            int n5 = TexturePackPage.readInt(positionInputStream);
            int n6 = TexturePackPage.readInt(positionInputStream);
            int n7 = TexturePackPage.readInt(positionInputStream);
            int n8 = TexturePackPage.readInt(positionInputStream);
            int n9 = TexturePackPage.readInt(positionInputStream);
            int n10 = TexturePackPage.readInt(positionInputStream);
            page.m_sub.add(new TexturePackPage.SubTextureInfo(n3, n4, n5, n6, n7, n8, n9, n10, string2));
        }
        page.m_png_start = positionInputStream.getPosition();
        if (this.m_version == 0) {
            n = 0;
            while ((n = TexturePackPage.readIntByte(positionInputStream)) != -559038737) {
            }
        } else {
            n = TexturePackPage.readInt(positionInputStream);
            TexturePackDevice.skipInput(positionInputStream, n);
        }
        return page;
    }

    public boolean isAlpha(String string) {
        Page page = this.m_pagemap.get(string);
        return page.m_has_alpha;
    }

    public int getTextureFlags() {
        return this.m_textureFlags;
    }

    static class TexturePackInputStream
    extends FileInputStream {
        TexturePackDevice m_device;

        TexturePackInputStream(String string, TexturePackDevice texturePackDevice) throws IOException {
            super(texturePackDevice.m_filename);
            this.m_device = texturePackDevice;
            Page page = this.m_device.m_pagemap.get(string);
            if (page == null) {
                throw new FileNotFoundException();
            }
            TexturePackDevice.skipInput(this, page.m_png_start);
            if (texturePackDevice.m_version >= 1) {
                int n = TexturePackPage.readInt(this);
            }
        }
    }

    static final class SubTexture {
        final Page m_page;
        final TexturePackPage.SubTextureInfo m_info;

        SubTexture(Page page, TexturePackPage.SubTextureInfo subTextureInfo) {
            this.m_page = page;
            this.m_info = subTextureInfo;
        }
    }

    static final class Page {
        String m_name;
        boolean m_has_alpha = false;
        long m_png_start = -1L;
        final ArrayList<TexturePackPage.SubTextureInfo> m_sub = new ArrayList();

        Page() {
        }
    }

    public final class PositionInputStream
    extends FilterInputStream {
        private long pos;
        private long mark;

        public PositionInputStream(InputStream inputStream) {
            super(inputStream);
            this.pos = 0L;
            this.mark = 0L;
        }

        public synchronized long getPosition() {
            return this.pos;
        }

        @Override
        public synchronized int read() throws IOException {
            int n = super.read();
            if (n >= 0) {
                ++this.pos;
            }
            return n;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 > 0) {
                this.pos += (long)n3;
            }
            return n3;
        }

        @Override
        public synchronized long skip(long l) throws IOException {
            long l2 = super.skip(l);
            if (l2 > 0L) {
                this.pos += l2;
            }
            return l2;
        }

        @Override
        public synchronized void mark(int n) {
            super.mark(n);
            this.mark = this.pos;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (!this.markSupported()) {
                throw new IOException("Mark not supported.");
            }
            super.reset();
            this.pos = this.mark;
        }
    }
}

