/*
 * Decompiled with CFR 0.152.
 */
package zombie.fileSystem;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import zombie.GameWindow;
import zombie.core.logger.ExceptionLogger;
import zombie.fileSystem.DeviceList;
import zombie.fileSystem.DiskFileDevice;
import zombie.fileSystem.FileSystem;
import zombie.fileSystem.FileTask;
import zombie.fileSystem.IFile;
import zombie.fileSystem.IFileDevice;
import zombie.fileSystem.IFileTask2Callback;
import zombie.fileSystem.MemoryFileDevice;
import zombie.fileSystem.TexturePackDevice;
import zombie.gameStates.GameLoadingState;

public final class FileSystemImpl
extends FileSystem {
    private final ArrayList<DeviceList> m_devices = new ArrayList();
    private final ArrayList<AsyncItem> m_in_progress = new ArrayList();
    private final ArrayList<AsyncItem> m_pending = new ArrayList();
    private int m_last_id = 0;
    private DiskFileDevice m_disk_device;
    private MemoryFileDevice m_memory_device;
    private final HashMap<String, TexturePackDevice> m_texturepack_devices = new HashMap();
    private final HashMap<String, DeviceList> m_texturepack_devicelists = new HashMap();
    private DeviceList m_default_device;
    private final ExecutorService executor;
    private final AtomicBoolean lock = new AtomicBoolean(false);
    private final ArrayList<AsyncItem> m_added = new ArrayList();
    public static final HashMap<String, Boolean> TexturePackCompression = new HashMap();

    public FileSystemImpl() {
        this.m_disk_device = new DiskFileDevice("disk");
        this.m_memory_device = new MemoryFileDevice();
        this.m_default_device = new DeviceList();
        this.m_default_device.add(this.m_disk_device);
        this.m_default_device.add(this.m_memory_device);
        int n = Runtime.getRuntime().availableProcessors() <= 4 ? 2 : 4;
        this.executor = Executors.newFixedThreadPool(n);
    }

    @Override
    public boolean mount(IFileDevice iFileDevice) {
        return true;
    }

    @Override
    public boolean unMount(IFileDevice iFileDevice) {
        return this.m_devices.remove(iFileDevice);
    }

    @Override
    public IFile open(DeviceList deviceList, String string, int n) {
        IFile iFile = deviceList.createFile();
        if (iFile != null) {
            if (iFile.open(string, n)) {
                return iFile;
            }
            iFile.release();
            return null;
        }
        return null;
    }

    @Override
    public void close(IFile iFile) {
        iFile.close();
        iFile.release();
    }

    @Override
    public int openAsync(DeviceList deviceList, String string, int n, IFileTask2Callback iFileTask2Callback) {
        IFile iFile = deviceList.createFile();
        if (iFile != null) {
            OpenTask openTask = new OpenTask(this);
            openTask.m_file = iFile;
            openTask.m_path = string;
            openTask.m_mode = n;
            openTask.m_cb = iFileTask2Callback;
            return this.runAsync(openTask);
        }
        return -1;
    }

    @Override
    public void closeAsync(IFile iFile, IFileTask2Callback iFileTask2Callback) {
        CloseTask closeTask = new CloseTask(this);
        closeTask.m_file = iFile;
        closeTask.m_cb = iFileTask2Callback;
        this.runAsync(closeTask);
    }

    @Override
    public void cancelAsync(int n) {
        AsyncItem asyncItem;
        int n2;
        if (n == -1) {
            return;
        }
        for (n2 = 0; n2 < this.m_pending.size(); ++n2) {
            asyncItem = this.m_pending.get(n2);
            if (asyncItem.m_id != n) continue;
            asyncItem.m_future.cancel(false);
            return;
        }
        for (n2 = 0; n2 < this.m_in_progress.size(); ++n2) {
            asyncItem = this.m_in_progress.get(n2);
            if (asyncItem.m_id != n) continue;
            asyncItem.m_future.cancel(false);
            return;
        }
        while (true) {
            if (this.lock.compareAndSet(false, true)) {
                for (n2 = 0; n2 < this.m_added.size(); ++n2) {
                    asyncItem = this.m_added.get(n2);
                    if (asyncItem.m_id != n) continue;
                    asyncItem.m_future.cancel(false);
                    break;
                }
                break;
            }
            Thread.onSpinWait();
        }
        this.lock.set(false);
    }

    @Override
    public InputStream openStream(DeviceList deviceList, String string) throws IOException {
        return deviceList.createStream(string);
    }

    @Override
    public void closeStream(InputStream inputStream) {
    }

    private int runAsync(AsyncItem asyncItem) {
        Thread thread = Thread.currentThread();
        if (thread != GameWindow.GameThread && thread != GameLoadingState.loader) {
            boolean bl = true;
        }
        while (true) {
            if (this.lock.compareAndSet(false, true)) {
                asyncItem.m_id = this.m_last_id++;
                if (this.m_last_id < 0) {
                    this.m_last_id = 0;
                }
                break;
            }
            Thread.onSpinWait();
        }
        this.m_added.add(asyncItem);
        this.lock.set(false);
        return asyncItem.m_id;
    }

    @Override
    public int runAsync(FileTask fileTask) {
        AsyncItem asyncItem = new AsyncItem();
        asyncItem.m_task = fileTask;
        asyncItem.m_future = new FutureTask<Object>(fileTask);
        return this.runAsync(asyncItem);
    }

    @Override
    public void updateAsyncTransactions() {
        int n;
        int n2 = Math.min(this.m_in_progress.size(), 16);
        for (n = 0; n < n2; ++n) {
            AsyncItem asyncItem = this.m_in_progress.get(n);
            if (!asyncItem.m_future.isDone()) continue;
            this.m_in_progress.remove(n--);
            --n2;
            if (asyncItem.m_future.isCancelled()) {
                boolean bl = true;
            } else {
                Object object = null;
                try {
                    object = asyncItem.m_future.get();
                }
                catch (Throwable throwable) {
                    ExceptionLogger.logException(throwable, asyncItem.m_task.getErrorMessage());
                }
                asyncItem.m_task.handleResult(object);
            }
            asyncItem.m_task.done();
            asyncItem.m_task = null;
            asyncItem.m_future = null;
        }
        while (true) {
            if (this.lock.compareAndSet(false, true)) {
                n = 1;
                if (n != 0) {
                    for (int i = 0; i < this.m_added.size(); ++i) {
                        AsyncItem asyncItem = this.m_added.get(i);
                        int n3 = this.m_pending.size();
                        for (int j = 0; j < this.m_pending.size(); ++j) {
                            AsyncItem asyncItem2 = this.m_pending.get(j);
                            if (asyncItem.m_task.m_priority <= asyncItem2.m_task.m_priority) continue;
                            n3 = j;
                            break;
                        }
                        this.m_pending.add(n3, asyncItem);
                    }
                    break;
                }
                this.m_pending.addAll(this.m_added);
                break;
            }
            Thread.onSpinWait();
        }
        this.m_added.clear();
        this.lock.set(false);
        n = 16 - this.m_in_progress.size();
        while (n > 0 && !this.m_pending.isEmpty()) {
            AsyncItem asyncItem = this.m_pending.remove(0);
            if (asyncItem.m_future.isCancelled()) continue;
            this.m_in_progress.add(asyncItem);
            this.executor.submit(asyncItem.m_future);
            --n;
        }
    }

    @Override
    public boolean hasWork() {
        if (!this.m_pending.isEmpty() || !this.m_in_progress.isEmpty()) {
            return true;
        }
        while (true) {
            if (this.lock.compareAndSet(false, true)) {
                boolean bl = !this.m_added.isEmpty();
                this.lock.set(false);
                return bl;
            }
            Thread.onSpinWait();
        }
    }

    @Override
    public DeviceList getDefaultDevice() {
        return this.m_default_device;
    }

    @Override
    public void mountTexturePack(String string, FileSystem.TexturePackTextures texturePackTextures, int n) {
        TexturePackDevice texturePackDevice = new TexturePackDevice(string, n);
        if (texturePackTextures != null) {
            try {
                texturePackDevice.getSubTextureInfo(texturePackTextures);
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
            }
        }
        this.m_texturepack_devices.put(string, texturePackDevice);
        DeviceList deviceList = new DeviceList();
        deviceList.add(texturePackDevice);
        this.m_texturepack_devicelists.put(texturePackDevice.name(), deviceList);
    }

    @Override
    public DeviceList getTexturePackDevice(String string) {
        return this.m_texturepack_devicelists.get(string);
    }

    @Override
    public int getTexturePackFlags(String string) {
        return this.m_texturepack_devices.get(string).getTextureFlags();
    }

    @Override
    public boolean getTexturePackAlpha(String string, String string2) {
        return this.m_texturepack_devices.get(string).isAlpha(string2);
    }

    private static final class OpenTask
    extends FileTask {
        IFile m_file;
        String m_path;
        int m_mode;
        IFileTask2Callback m_cb;

        OpenTask(FileSystem fileSystem) {
            super(fileSystem);
        }

        @Override
        public Object call() throws Exception {
            return this.m_file.open(this.m_path, this.m_mode);
        }

        @Override
        public void handleResult(Object object) {
            if (this.m_cb != null) {
                this.m_cb.onFileTaskFinished(this.m_file, object);
            }
        }

        @Override
        public void done() {
            if ((this.m_mode & 5) == 5) {
                this.m_file_system.closeAsync(this.m_file, null);
            }
            this.m_file = null;
            this.m_path = null;
            this.m_cb = null;
        }
    }

    private static final class CloseTask
    extends FileTask {
        IFile m_file;
        IFileTask2Callback m_cb;

        CloseTask(FileSystem fileSystem) {
            super(fileSystem);
        }

        @Override
        public Object call() throws Exception {
            this.m_file.close();
            this.m_file.release();
            return null;
        }

        @Override
        public void handleResult(Object object) {
            if (this.m_cb != null) {
                this.m_cb.onFileTaskFinished(this.m_file, object);
            }
        }

        @Override
        public void done() {
            this.m_file = null;
            this.m_cb = null;
        }
    }

    private static final class AsyncItem {
        int m_id;
        FileTask m_task;
        FutureTask<Object> m_future;

        private AsyncItem() {
        }
    }
}

