/*
 * Decompiled with CFR 0.152.
 */
package zombie.fileSystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import zombie.core.logger.ExceptionLogger;
import zombie.fileSystem.FileOpenMode;
import zombie.fileSystem.FileSeekMode;
import zombie.fileSystem.IFile;
import zombie.fileSystem.IFileDevice;

public final class DiskFileDevice
implements IFileDevice {
    private final String m_name;

    public DiskFileDevice(String string) {
        this.m_name = string;
    }

    @Override
    public IFile createFile(IFile iFile) {
        return new DiskFile(iFile, this);
    }

    @Override
    public void destroyFile(IFile iFile) {
    }

    @Override
    public InputStream createStream(String string, InputStream inputStream) throws IOException {
        return new FileInputStream(string);
    }

    @Override
    public void destroyStream(InputStream inputStream) {
    }

    @Override
    public String name() {
        return this.m_name;
    }

    private static final class DiskFile
    implements IFile {
        final DiskFileDevice m_device;
        RandomAccessFile m_file;
        InputStream m_inputStream;
        final IFile m_fallthrough;
        boolean m_use_fallthrough;

        DiskFile(IFile iFile, DiskFileDevice diskFileDevice) {
            this.m_device = diskFileDevice;
            this.m_fallthrough = iFile;
            this.m_use_fallthrough = false;
        }

        @Override
        public boolean open(String string, int n) {
            boolean bl;
            File file = new File(string);
            boolean bl2 = bl = (n & 1) != 0;
            if (bl && !file.exists() && this.m_fallthrough != null) {
                this.m_use_fallthrough = true;
                return this.m_fallthrough.open(string, n);
            }
            try {
                if ((n & 0x10) == 0) {
                    this.m_file = new RandomAccessFile(string, FileOpenMode.toStringMode(n));
                } else {
                    this.m_inputStream = new FileInputStream(string);
                }
                return true;
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
                return false;
            }
        }

        @Override
        public void close() {
            if (this.m_fallthrough != null) {
                this.m_fallthrough.close();
            }
            if (this.m_file == null && this.m_inputStream == null) {
                return;
            }
            try {
                if (this.m_file != null) {
                    this.m_file.close();
                }
                if (this.m_inputStream != null) {
                    this.m_inputStream.close();
                }
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
            }
            this.m_file = null;
            this.m_inputStream = null;
            this.m_use_fallthrough = false;
        }

        @Override
        public boolean read(byte[] byArray, long l) {
            if (this.m_use_fallthrough) {
                return this.m_fallthrough.read(byArray, l);
            }
            if (this.m_file == null) {
                return false;
            }
            try {
                return (long)this.m_file.read(byArray, 0, (int)l) == l;
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
                return false;
            }
        }

        @Override
        public boolean write(byte[] byArray, long l) {
            if (this.m_use_fallthrough) {
                return this.m_fallthrough.write(byArray, l);
            }
            if (this.m_file == null) {
                return false;
            }
            try {
                this.m_file.write(byArray, 0, (int)l);
                return true;
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
                return false;
            }
        }

        @Override
        public byte[] getBuffer() {
            if (this.m_use_fallthrough) {
                return this.m_fallthrough.getBuffer();
            }
            return null;
        }

        @Override
        public long size() {
            if (this.m_use_fallthrough) {
                return this.m_fallthrough.size();
            }
            if (this.m_file == null) {
                return 0L;
            }
            try {
                return this.m_file.length();
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
                return 0L;
            }
        }

        @Override
        public boolean seek(FileSeekMode fileSeekMode, long l) {
            if (this.m_use_fallthrough) {
                return this.m_fallthrough.seek(fileSeekMode, l);
            }
            if (this.m_file == null) {
                return false;
            }
            try {
                switch (fileSeekMode) {
                    case BEGIN: {
                        break;
                    }
                    case CURRENT: {
                        l += this.m_file.getFilePointer();
                        break;
                    }
                    case END: {
                        l = this.m_file.length() + l;
                    }
                }
                this.m_file.seek(l);
                return true;
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
                return false;
            }
        }

        @Override
        public long pos() {
            if (this.m_use_fallthrough) {
                return this.m_fallthrough.pos();
            }
            if (this.m_file == null) {
                return 0L;
            }
            try {
                return this.m_file.getFilePointer();
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
                return 0L;
            }
        }

        @Override
        public InputStream getInputStream() {
            return this.m_inputStream;
        }

        @Override
        public IFileDevice getDevice() {
            return this.m_device;
        }

        @Override
        public void release() {
            this.getDevice().destroyFile(this);
        }
    }
}

