/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.utils;

import java.util.ArrayList;

public class Noise2D {
    private ArrayList<Layer> layers = new ArrayList(3);
    private static final int[] perm = new int[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};

    private float lerp(float f, float f2, float f3) {
        return f2 + f * (f3 - f2);
    }

    private float fade(float f) {
        return f * f * f * (f * (f * 6.0f - 15.0f) + 10.0f);
    }

    private float noise(float f, float f2, int[] nArray) {
        int n = (int)Math.floor((double)f - Math.floor(f / 255.0f) * 255.0);
        int n2 = (int)Math.floor((double)f2 - Math.floor(f2 / 255.0f) * 255.0);
        float f3 = this.fade(f - (float)Math.floor(f));
        float f4 = this.fade(f2 - (float)Math.floor(f2));
        int n3 = nArray[n] + n2;
        int n4 = nArray[n] + n2 + 1;
        int n5 = nArray[n + 1] + n2;
        int n6 = nArray[n + 1] + n2 + 1;
        return this.lerp(f4, this.lerp(f3, perm[nArray[n3]], perm[nArray[n5]]), this.lerp(f3, perm[nArray[n4]], perm[nArray[n6]]));
    }

    public float layeredNoise(float f, float f2) {
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = this.layers.get(i);
            f4 += layer.amp;
            f3 += this.noise(f * layer.freq, f2 * layer.freq, layer.p) * layer.amp;
        }
        return f3 / f4 / 255.0f;
    }

    public void addLayer(int n, float f, float f2) {
        int n2 = (int)Math.floor((double)n - Math.floor((float)n / 256.0f) * 256.0);
        Layer layer = new Layer();
        layer.freq = f;
        layer.amp = f2;
        for (int i = 0; i < 256; ++i) {
            int n3 = (int)Math.floor((double)(n2 + i) - Math.floor((float)(n2 + i) / 256.0f) * 256.0);
            layer.p[n3] = perm[i];
            layer.p[256 + n3] = layer.p[n3];
        }
        this.layers.add(layer);
    }

    public void reset() {
        if (this.layers.size() > 0) {
            this.layers.clear();
        }
    }

    private class Layer {
        public float freq;
        public float amp;
        public int[] p = new int[512];

        private Layer() {
        }
    }
}

