/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.season;

import java.util.GregorianCalendar;
import zombie.debug.DebugLog;
import zombie.erosion.utils.Noise2D;

public final class ErosionSeason {
    public static final int SEASON_DEFAULT = 0;
    public static final int SEASON_SPRING = 1;
    public static final int SEASON_SUMMER = 2;
    public static final int SEASON_SUMMER2 = 3;
    public static final int SEASON_AUTUMN = 4;
    public static final int SEASON_WINTER = 5;
    public static final int NUM_SEASONS = 6;
    private int lat = 38;
    private int tempMax = 25;
    private int tempMin = 0;
    private int tempDiff = 7;
    private float highNoon = 12.5f;
    private float highNoonCurrent = 12.5f;
    private int seasonLag = 31;
    private final float[] rain = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private double suSol;
    private double wiSol;
    private final GregorianCalendar zeroDay = new GregorianCalendar(1970, 0, 1, 0, 0);
    private int day;
    private int month;
    private int year;
    private boolean isH1;
    private YearData[] yearData = new YearData[3];
    private int curSeason;
    private float curSeasonDay;
    private float curSeasonDays;
    private float curSeasonStrength;
    private float curSeasonProgression;
    private float dayMeanTemperature;
    private float dayTemperature;
    private float dayNoiseVal;
    private boolean isRainDay;
    private float rainYearAverage;
    private float rainDayStrength;
    private boolean isThunderDay;
    private boolean isSunnyDay;
    private float dayDusk;
    private float dayDawn;
    private float dayDaylight;
    private float winterMod;
    private float summerMod;
    private float summerTilt;
    private float curDayPercent = 0.0f;
    private Noise2D per = new Noise2D();
    private int seedA = 64;
    private int seedB = 128;
    private int seedC = 255;
    String[] names = new String[]{"Default", "Spring", "Early Summer", "Late Summer", "Autumn", "Winter"};

    public void init(int n, int n2, int n3, int n4, int n5, float f, int n6, int n7, int n8) {
        this.lat = n;
        this.tempMax = n2;
        this.tempMin = n3;
        this.tempDiff = n4;
        this.seasonLag = n5;
        this.highNoon = f;
        this.highNoonCurrent = f;
        this.seedA = n6;
        this.seedB = n7;
        this.seedC = n8;
        this.summerTilt = 2.0f;
        this.winterMod = this.tempMin < 0 ? 0.05f * (float)(-this.tempMin) : 0.02f * (float)(-this.tempMin);
        this.summerMod = this.tempMax < 0 ? 0.05f * (float)this.tempMax : 0.02f * (float)this.tempMax;
        this.suSol = 2.0 * this.degree(Math.acos(-Math.tan(this.radian(this.lat)) * Math.tan(this.radian(23.44)))) / 15.0;
        this.wiSol = 2.0 * this.degree(Math.acos(Math.tan(this.radian(this.lat)) * Math.tan(this.radian(23.44)))) / 15.0;
        this.per.reset();
        this.per.addLayer(n6, 8.0f, 2.0f);
        this.per.addLayer(n7, 6.0f, 4.0f);
        this.per.addLayer(n8, 4.0f, 6.0f);
        this.yearData[0] = new YearData();
        this.yearData[1] = new YearData();
        this.yearData[2] = new YearData();
    }

    public int getLat() {
        return this.lat;
    }

    public int getTempMax() {
        return this.tempMax;
    }

    public int getTempMin() {
        return this.tempMin;
    }

    public int getTempDiff() {
        return this.tempDiff;
    }

    public int getSeasonLag() {
        return this.seasonLag;
    }

    public float getHighNoon() {
        return this.highNoon;
    }

    public int getSeedA() {
        return this.seedA;
    }

    public int getSeedB() {
        return this.seedB;
    }

    public int getSeedC() {
        return this.seedC;
    }

    public void setRain(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.rain[0] = f;
        this.rain[1] = f2;
        this.rain[2] = f3;
        this.rain[3] = f4;
        this.rain[4] = f5;
        this.rain[5] = f6;
        this.rain[6] = f7;
        this.rain[7] = f8;
        this.rain[8] = f9;
        this.rain[9] = f10;
        this.rain[10] = f11;
        this.rain[11] = f12;
        float f13 = 0.0f;
        for (float f14 : this.rain) {
            f13 += f14;
        }
        this.rainYearAverage = (int)Math.floor(365.0f * (f13 / (float)this.rain.length));
    }

    public ErosionSeason clone() {
        ErosionSeason erosionSeason = new ErosionSeason();
        erosionSeason.init(this.lat, this.tempMax, this.tempMin, this.tempDiff, this.seasonLag, this.highNoon, this.seedA, this.seedB, this.seedC);
        erosionSeason.setRain(this.rain[0], this.rain[1], this.rain[2], this.rain[3], this.rain[4], this.rain[5], this.rain[6], this.rain[7], this.rain[8], this.rain[9], this.rain[10], this.rain[11]);
        return erosionSeason;
    }

    public float getCurDayPercent() {
        return this.curDayPercent;
    }

    public double getMaxDaylightWinter() {
        return this.wiSol;
    }

    public double getMaxDaylightSummer() {
        return this.suSol;
    }

    public float getDusk() {
        return this.dayDusk;
    }

    public float getDawn() {
        return this.dayDawn;
    }

    public float getDaylight() {
        return this.dayDaylight;
    }

    public float getDayTemperature() {
        return this.dayTemperature;
    }

    public float getDayMeanTemperature() {
        return this.dayMeanTemperature;
    }

    public int getSeason() {
        return this.curSeason;
    }

    public float getDayHighNoon() {
        return this.highNoonCurrent;
    }

    public String getSeasonName() {
        return this.names[this.curSeason];
    }

    public boolean isSeason(int n) {
        return n == this.curSeason;
    }

    public GregorianCalendar getWinterStartDay(int n, int n2, int n3) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n3, n2, n);
        long l = gregorianCalendar.getTime().getTime();
        if (l < this.yearData[0].winterEndDayUnx) {
            return this.yearData[0].winterStartDay;
        }
        return this.yearData[1].winterStartDay;
    }

    public float getSeasonDay() {
        return this.curSeasonDay;
    }

    public float getSeasonDays() {
        return this.curSeasonDays;
    }

    public float getSeasonStrength() {
        return this.curSeasonStrength;
    }

    public float getSeasonProgression() {
        return this.curSeasonProgression;
    }

    public float getDayNoiseVal() {
        return this.dayNoiseVal;
    }

    public boolean isRainDay() {
        return this.isRainDay;
    }

    public float getRainDayStrength() {
        return this.rainDayStrength;
    }

    public float getRainYearAverage() {
        return this.rainYearAverage;
    }

    public boolean isThunderDay() {
        return this.isThunderDay;
    }

    public boolean isSunnyDay() {
        return this.isSunnyDay;
    }

    public void setDay(int n, int n2, int n3) {
        if (n3 == 0) {
            DebugLog.log("NOTICE: year value is 0?");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n3, n2, n, 0, 0);
        long l = gregorianCalendar.getTime().getTime();
        this.setYearData(n3);
        this.setSeasonData(l, gregorianCalendar, n3, n2);
        this.setDaylightData(l, gregorianCalendar);
    }

    private void setYearData(int n) {
        if (this.yearData[1].year == n) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int n2;
            int n3 = i - 1;
            this.yearData[i].year = n2 = n + n3;
            this.yearData[i].winSols = new GregorianCalendar(n2, 11, 22);
            this.yearData[i].sumSols = new GregorianCalendar(n2, 5, 22);
            this.yearData[i].winSolsUnx = this.yearData[i].winSols.getTime().getTime();
            this.yearData[i].sumSolsUnx = this.yearData[i].sumSols.getTime().getTime();
            this.yearData[i].hottestDay = new GregorianCalendar(n2, 5, 22);
            this.yearData[i].coldestDay = new GregorianCalendar(n2, 11, 22);
            this.yearData[i].hottestDay.add(5, this.seasonLag);
            this.yearData[i].coldestDay.add(5, this.seasonLag);
            this.yearData[i].hottestDayUnx = this.yearData[i].hottestDay.getTime().getTime();
            this.yearData[i].coldestDayUnx = this.yearData[i].coldestDay.getTime().getTime();
            this.yearData[i].winterS = this.per.layeredNoise(64 + n2, 64.0f);
            this.yearData[i].winterE = this.per.layeredNoise(64.0f, 64 + n2);
            this.yearData[i].winterStartDay = new GregorianCalendar(n2, 11, 22);
            this.yearData[i].winterEndDay = new GregorianCalendar(n2, 11, 22);
            this.yearData[i].winterStartDay.add(5, (int)(-Math.floor(40.0f + 40.0f * this.winterMod + 20.0f * this.yearData[i].winterS)));
            this.yearData[i].winterEndDay.add(5, (int)Math.floor(40.0f + 40.0f * this.winterMod + 20.0f * this.yearData[i].winterE));
            this.yearData[i].winterStartDayUnx = this.yearData[i].winterStartDay.getTime().getTime();
            this.yearData[i].winterEndDayUnx = this.yearData[i].winterEndDay.getTime().getTime();
            this.yearData[i].summerS = this.per.layeredNoise(128 + n2, 128.0f);
            this.yearData[i].summerE = this.per.layeredNoise(128.0f, 128 + n2);
            this.yearData[i].summerStartDay = new GregorianCalendar(n2, 5, 22);
            this.yearData[i].summerEndDay = new GregorianCalendar(n2, 5, 22);
            this.yearData[i].summerStartDay.add(5, (int)(-Math.floor(40.0f + 40.0f * this.summerMod + 20.0f * this.yearData[i].summerS)));
            this.yearData[i].summerEndDay.add(5, (int)Math.floor(40.0f + 40.0f * this.summerMod + 20.0f * this.yearData[i].summerE));
            this.yearData[i].summerStartDayUnx = this.yearData[i].summerStartDay.getTime().getTime();
            this.yearData[i].summerEndDayUnx = this.yearData[i].summerEndDay.getTime().getTime();
        }
        this.yearData[1].lastSummerStr = this.yearData[0].summerS + this.yearData[0].summerE - 1.0f;
        this.yearData[1].lastWinterStr = this.yearData[0].winterS + this.yearData[0].winterE - 1.0f;
        this.yearData[1].summerStr = this.yearData[1].summerS + this.yearData[1].summerE - 1.0f;
        this.yearData[1].winterStr = this.yearData[1].winterS + this.yearData[1].winterE - 1.0f;
        this.yearData[1].nextSummerStr = this.yearData[2].summerS + this.yearData[2].summerE - 1.0f;
        this.yearData[1].nextWinterStr = this.yearData[2].winterS + this.yearData[2].winterE - 1.0f;
    }

    private void setSeasonData(float f, GregorianCalendar gregorianCalendar, int n, int n2) {
        float f2;
        float f3;
        float f4;
        float f5;
        GregorianCalendar gregorianCalendar2;
        GregorianCalendar gregorianCalendar3;
        if (f < (float)this.yearData[0].winterEndDayUnx) {
            this.curSeason = 5;
            gregorianCalendar3 = this.yearData[0].winterStartDay;
            gregorianCalendar2 = this.yearData[0].winterEndDay;
        } else if (f < (float)this.yearData[1].summerStartDayUnx) {
            this.curSeason = 1;
            gregorianCalendar3 = this.yearData[0].winterEndDay;
            gregorianCalendar2 = this.yearData[1].summerStartDay;
        } else if (f < (float)this.yearData[1].summerEndDayUnx) {
            this.curSeason = 2;
            gregorianCalendar3 = this.yearData[1].summerStartDay;
            gregorianCalendar2 = this.yearData[1].summerEndDay;
        } else if (f < (float)this.yearData[1].winterStartDayUnx) {
            this.curSeason = 4;
            gregorianCalendar3 = this.yearData[1].summerEndDay;
            gregorianCalendar2 = this.yearData[1].winterStartDay;
        } else {
            this.curSeason = 5;
            gregorianCalendar3 = this.yearData[1].winterStartDay;
            gregorianCalendar2 = this.yearData[1].winterEndDay;
        }
        this.curSeasonDay = this.dayDiff(gregorianCalendar, gregorianCalendar3);
        this.curSeasonDays = this.dayDiff(gregorianCalendar3, gregorianCalendar2);
        this.curSeasonStrength = this.curSeasonDays / 90.0f - 1.0f;
        this.curSeasonProgression = this.curSeasonDay / this.curSeasonDays;
        if (f < (float)this.yearData[0].coldestDayUnx && f >= (float)this.yearData[0].hottestDayUnx) {
            f5 = (float)this.tempMax + (float)(this.tempDiff / 2) * this.yearData[1].lastSummerStr;
            f4 = (float)this.tempMin + (float)(this.tempDiff / 2) * this.yearData[1].lastWinterStr;
            f3 = this.dayDiff(gregorianCalendar, this.yearData[0].hottestDay) / this.dayDiff(this.yearData[0].hottestDay, this.yearData[0].coldestDay);
        } else if (f < (float)this.yearData[1].hottestDayUnx && f >= (float)this.yearData[0].coldestDayUnx) {
            f5 = (float)this.tempMin + (float)(this.tempDiff / 2) * this.yearData[1].lastWinterStr;
            f4 = (float)this.tempMax + (float)(this.tempDiff / 2) * this.yearData[1].summerStr;
            f3 = this.dayDiff(gregorianCalendar, this.yearData[0].coldestDay) / this.dayDiff(this.yearData[1].hottestDay, this.yearData[0].coldestDay);
        } else if (f < (float)this.yearData[1].coldestDayUnx && f >= (float)this.yearData[1].hottestDayUnx) {
            f5 = (float)this.tempMax + (float)(this.tempDiff / 2) * this.yearData[1].summerStr;
            f4 = (float)this.tempMin + (float)(this.tempDiff / 2) * this.yearData[1].winterStr;
            f3 = this.dayDiff(gregorianCalendar, this.yearData[1].hottestDay) / this.dayDiff(this.yearData[1].hottestDay, this.yearData[1].coldestDay);
        } else {
            f5 = (float)this.tempMin + (float)(this.tempDiff / 2) * this.yearData[1].winterStr;
            f4 = (float)this.tempMax + (float)(this.tempDiff / 2) * this.yearData[1].nextSummerStr;
            f3 = this.dayDiff(gregorianCalendar, this.yearData[1].coldestDay) / this.dayDiff(this.yearData[1].coldestDay, this.yearData[2].hottestDay);
        }
        float f6 = (float)this.clerp(f3, f5, f4);
        float f7 = this.dayDiff(this.zeroDay, gregorianCalendar) / 20.0f;
        this.dayNoiseVal = this.per.layeredNoise(f7, 0.0f);
        float f8 = this.dayNoiseVal * 2.0f - 1.0f;
        this.dayTemperature = f6 + (float)this.tempDiff * f8;
        this.dayMeanTemperature = f6;
        this.isThunderDay = false;
        this.isRainDay = false;
        this.isSunnyDay = false;
        float f9 = f2 = 0.1f + this.rain[n2] <= 1.0f ? 0.1f + this.rain[n2] : 1.0f;
        if (f2 > 0.0f && this.dayNoiseVal < f2) {
            this.isRainDay = true;
            this.rainDayStrength = 1.0f - this.dayNoiseVal / f2;
            float f10 = this.per.layeredNoise(0.0f, f7);
            if ((double)f10 > 0.6) {
                this.isThunderDay = true;
            }
        }
        if ((double)this.dayNoiseVal > 0.6) {
            this.isSunnyDay = true;
        }
    }

    private void setDaylightData(long l, GregorianCalendar gregorianCalendar) {
        float f;
        GregorianCalendar gregorianCalendar2;
        GregorianCalendar gregorianCalendar3;
        if (l < this.yearData[1].winSolsUnx && l >= this.yearData[1].sumSolsUnx) {
            this.isH1 = false;
            gregorianCalendar3 = this.yearData[1].sumSols;
            gregorianCalendar2 = this.yearData[1].winSols;
        } else {
            this.isH1 = true;
            if (l >= this.yearData[1].winSolsUnx) {
                gregorianCalendar3 = this.yearData[1].winSols;
                gregorianCalendar2 = this.yearData[2].sumSols;
            } else {
                gregorianCalendar3 = this.yearData[0].winSols;
                gregorianCalendar2 = this.yearData[1].sumSols;
            }
        }
        float f2 = f = this.dayDiff(gregorianCalendar, gregorianCalendar3) / this.dayDiff(gregorianCalendar3, gregorianCalendar2);
        if (this.isH1) {
            this.dayDaylight = (float)this.clerp(f, this.wiSol, this.suSol);
        } else {
            this.dayDaylight = (float)this.clerp(f, this.suSol, this.wiSol);
            f2 = 1.0f - f2;
        }
        this.curDayPercent = f2;
        this.highNoonCurrent = this.highNoon + this.summerTilt * f2;
        this.dayDawn = this.highNoonCurrent - this.dayDaylight / 2.0f;
        this.dayDusk = this.highNoonCurrent + this.dayDaylight / 2.0f;
    }

    private float dayDiff(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) {
        long l = gregorianCalendar.getTime().getTime() - gregorianCalendar2.getTime().getTime();
        return Math.abs(l / 86400000L);
    }

    private double clerp(double d, double d2, double d3) {
        double d4 = (1.0 - Math.cos(d * Math.PI)) / 2.0;
        return d2 * (1.0 - d4) + d3 * d4;
    }

    private double lerp(double d, double d2, double d3) {
        return d2 + d * (d3 - d2);
    }

    private double radian(double d) {
        return d * (Math.PI / 180);
    }

    private double degree(double d) {
        return d * 57.29577951308232;
    }

    public static void Reset() {
    }

    public void setCurSeason(int n) {
        this.curSeason = n;
    }

    private static class YearData {
        public int year = Integer.MIN_VALUE;
        public GregorianCalendar winSols;
        public GregorianCalendar sumSols;
        public long winSolsUnx;
        public long sumSolsUnx;
        public GregorianCalendar hottestDay;
        public GregorianCalendar coldestDay;
        public long hottestDayUnx;
        public long coldestDayUnx;
        public float winterS;
        public float winterE;
        public GregorianCalendar winterStartDay;
        public GregorianCalendar winterEndDay;
        public long winterStartDayUnx;
        public long winterEndDayUnx;
        public float summerS;
        public float summerE;
        public GregorianCalendar summerStartDay;
        public GregorianCalendar summerEndDay;
        public long summerStartDayUnx;
        public long summerEndDayUnx;
        public float lastSummerStr;
        public float lastWinterStr;
        public float summerStr;
        public float winterStr;
        public float nextSummerStr;
        public float nextWinterStr;

        private YearData() {
        }
    }
}

