/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.obj;

import java.util.ArrayList;
import zombie.core.Core;
import zombie.debug.DebugLog;
import zombie.iso.IsoDirections;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameServer;

public final class ErosionObjSprites {
    public static final int SECTION_BASE = 0;
    public static final int SECTION_SNOW = 1;
    public static final int SECTION_FLOWER = 2;
    public static final int SECTION_CHILD = 3;
    public static final int NUM_SECTIONS = 4;
    public String name;
    public int stages;
    public boolean hasSnow;
    public boolean hasFlower;
    public boolean hasChildSprite;
    public boolean noSeasonBase;
    public int cycleTime = 1;
    private Stage[] sprites;

    public ErosionObjSprites(int n, String string, boolean bl, boolean bl2, boolean bl3) {
        this.name = string;
        this.stages = n;
        this.hasSnow = bl;
        this.hasFlower = bl2;
        this.hasChildSprite = bl3;
        this.sprites = new Stage[n];
        for (int i = 0; i < n; ++i) {
            this.sprites[i] = new Stage();
            this.sprites[i].sections[0] = new Section();
            if (this.hasSnow) {
                this.sprites[i].sections[1] = new Section();
            }
            if (this.hasFlower) {
                this.sprites[i].sections[2] = new Section();
            }
            if (!this.hasChildSprite) continue;
            this.sprites[i].sections[3] = new Section();
        }
    }

    private String getSprite(int n, int n2, int n3) {
        if (this.sprites[n] != null && this.sprites[n].sections[n2] != null && this.sprites[n].sections[n2].seasons[n3] != null) {
            return this.sprites[n].sections[n2].seasons[n3].getNext();
        }
        return null;
    }

    public String getBase(int n, int n2) {
        return this.getSprite(n, 0, n2);
    }

    public String getFlower(int n) {
        if (this.hasFlower) {
            return this.getSprite(n, 2, 0);
        }
        return null;
    }

    public String getChildSprite(int n, int n2) {
        if (this.hasChildSprite) {
            return this.getSprite(n, 3, n2);
        }
        return null;
    }

    private void setSprite(int n, int n2, String string, int n3) {
        if (this.sprites[n] != null && this.sprites[n].sections[n2] != null) {
            this.sprites[n].sections[n2].seasons[n3] = new Sprites(string);
        }
    }

    private void setSprite(int n, int n2, ArrayList<String> arrayList, int n3) {
        assert (!arrayList.isEmpty());
        if (this.sprites[n] != null && this.sprites[n].sections[n2] != null) {
            this.sprites[n].sections[n2].seasons[n3] = new Sprites(arrayList);
        }
    }

    public void setBase(int n, String string, int n2) {
        this.setSprite(n, 0, string, n2);
    }

    public void setBase(int n, ArrayList<String> arrayList, int n2) {
        this.setSprite(n, 0, arrayList, n2);
    }

    public void setFlower(int n, String string) {
        this.setSprite(n, 2, string, 0);
    }

    public void setFlower(int n, ArrayList<String> arrayList) {
        this.setSprite(n, 2, arrayList, 0);
    }

    public void setChildSprite(int n, String string, int n2) {
        this.setSprite(n, 3, string, n2);
    }

    public void setChildSprite(int n, ArrayList<String> arrayList, int n2) {
        this.setSprite(n, 3, arrayList, n2);
    }

    private static class Stage {
        public Section[] sections = new Section[4];

        private Stage() {
        }
    }

    private static class Section {
        public Sprites[] seasons = new Sprites[6];

        private Section() {
        }
    }

    private static final class Sprites {
        public final ArrayList<String> sprites = new ArrayList();
        private int index = -1;

        public Sprites(String string) {
            if (Core.bDebug || GameServer.bServer && GameServer.bDebug) {
                IsoSprite isoSprite = IsoSpriteManager.instance.getSprite(string);
                if (isoSprite.CurrentAnim.Frames.size() == 0 || !GameServer.bServer && isoSprite.CurrentAnim.Frames.get(0).getTexture(IsoDirections.N) == null || isoSprite.ID < 10000) {
                    DebugLog.log("EMPTY SPRITE " + string);
                }
            }
            this.sprites.add(string);
        }

        public Sprites(ArrayList<String> arrayList) {
            if (Core.bDebug || GameServer.bServer && GameServer.bDebug) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    IsoSprite isoSprite = IsoSpriteManager.instance.getSprite(arrayList.get(i));
                    if (isoSprite.CurrentAnim.Frames.size() != 0 && (GameServer.bServer || isoSprite.CurrentAnim.Frames.get(0).getTexture(IsoDirections.N) != null) && isoSprite.ID >= 10000) continue;
                    DebugLog.log("EMPTY SPRITE " + arrayList.get(i));
                }
            }
            this.sprites.addAll(arrayList);
        }

        public String getNext() {
            if (++this.index >= this.sprites.size()) {
                this.index = 0;
            }
            return this.sprites.get(this.index);
        }
    }
}

