/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.obj;

import java.util.ArrayList;
import zombie.erosion.obj.ErosionObjOverlaySprites;
import zombie.iso.IsoObject;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;

public final class ErosionObjOverlay {
    private final ErosionObjOverlaySprites sprites;
    public String name;
    public int stages;
    public boolean applyAlpha;
    public int cycleTime;

    public ErosionObjOverlay(ErosionObjOverlaySprites erosionObjOverlaySprites, int n, boolean bl) {
        this.sprites = erosionObjOverlaySprites;
        this.name = erosionObjOverlaySprites.name;
        this.stages = erosionObjOverlaySprites.stages;
        this.applyAlpha = bl;
        this.cycleTime = n;
    }

    public int setOverlay(IsoObject isoObject, int n, int n2, int n3, float f) {
        if (n2 >= 0 && n2 < this.stages && isoObject != null) {
            if (n >= 0) {
                this.removeOverlay(isoObject, n);
            }
            IsoSprite isoSprite = this.sprites.getSprite(n2, n3);
            IsoSpriteInstance isoSpriteInstance = isoSprite.newInstance();
            if (isoObject.AttachedAnimSprite == null) {
                isoObject.AttachedAnimSprite = new ArrayList();
            }
            isoObject.AttachedAnimSprite.add(isoSpriteInstance);
            return isoSpriteInstance.getID();
        }
        return -1;
    }

    public boolean removeOverlay(IsoObject isoObject, int n) {
        int n2;
        if (isoObject == null) {
            return false;
        }
        ArrayList<IsoSpriteInstance> arrayList = isoObject.AttachedAnimSprite;
        if (arrayList == null || arrayList.isEmpty()) {
            return false;
        }
        for (n2 = 0; n2 < isoObject.AttachedAnimSprite.size(); ++n2) {
            if (isoObject.AttachedAnimSprite.get((int)n2).parentSprite.ID != n) continue;
            isoObject.AttachedAnimSprite.remove(n2--);
        }
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            if (arrayList.get(n2).getID() != n) continue;
            arrayList.remove(n2);
            return true;
        }
        return false;
    }
}

