/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.categories;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.erosion.ErosionData;
import zombie.erosion.categories.ErosionCategory;
import zombie.erosion.obj.ErosionObj;
import zombie.erosion.obj.ErosionObjOverlay;
import zombie.erosion.obj.ErosionObjOverlaySprites;
import zombie.erosion.obj.ErosionObjSprites;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;

public final class StreetCracks
extends ErosionCategory {
    private ArrayList<ErosionObj> objs = new ArrayList();
    private ArrayList<ErosionObjOverlay> crackObjs = new ArrayList();
    private int[] spawnChance = new int[100];

    @Override
    public boolean replaceExistingObject(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean validateSpawn(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2, boolean bl3) {
        int n = square.noiseMainInt;
        int n2 = this.spawnChance[n];
        if (n2 == 0) {
            return false;
        }
        if (square.rand(isoGridSquare.x, isoGridSquare.y, 101) >= n2) {
            return false;
        }
        CategoryData categoryData = (CategoryData)this.setCatModData(square);
        categoryData.gameObj = square.rand(isoGridSquare.x, isoGridSquare.y, this.crackObjs.size());
        categoryData.maxStage = n > 65 ? 2 : (n > 55 ? 1 : 0);
        categoryData.stage = 0;
        categoryData.spawnTime = 50 + (100 - n);
        if (square.magicNum > 0.5f) {
            categoryData.hasGrass = true;
        }
        return true;
    }

    @Override
    public void update(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionCategory.Data data, ErosionData.Chunk chunk, int n) {
        CategoryData categoryData = (CategoryData)data;
        if (n < categoryData.spawnTime || categoryData.doNothing) {
            return;
        }
        IsoObject isoObject = isoGridSquare.getFloor();
        if (categoryData.gameObj >= 0 && categoryData.gameObj < this.crackObjs.size() && isoObject != null) {
            ErosionObj erosionObj;
            int n2;
            ErosionObjOverlay erosionObjOverlay = this.crackObjs.get(categoryData.gameObj);
            int n3 = categoryData.maxStage;
            int n4 = (int)Math.floor((float)(n - categoryData.spawnTime) / ((float)erosionObjOverlay.cycleTime / ((float)n3 + 1.0f)));
            if (n4 < categoryData.stage) {
                n4 = categoryData.stage;
            }
            if (n4 >= erosionObjOverlay.stages) {
                n4 = erosionObjOverlay.stages - 1;
            }
            if (n4 != categoryData.stage) {
                int n5 = categoryData.curID;
                n2 = erosionObjOverlay.setOverlay(isoObject, n5, n4, 0, 0.0f);
                if (n2 >= 0) {
                    categoryData.curID = n2;
                }
                categoryData.stage = n4;
            } else if (!categoryData.hasGrass && n4 == erosionObjOverlay.stages - 1) {
                categoryData.doNothing = true;
            }
            if (categoryData.hasGrass && (erosionObj = this.objs.get(categoryData.gameObj)) != null) {
                n2 = this.currentSeason(square.magicNum, erosionObj);
                boolean bl = false;
                boolean bl2 = false;
                this.updateObj(square, data, isoGridSquare, erosionObj, bl, n4, n2, bl2);
            }
        } else {
            categoryData.doNothing = true;
        }
    }

    @Override
    public void init() {
        for (int i = 0; i < 100; ++i) {
            this.spawnChance[i] = i >= 40 ? (int)this.clerp((float)(i - 40) / 60.0f, 0.0f, 60.0f) : 0;
        }
        this.seasonDisp[5].season1 = 5;
        this.seasonDisp[5].season2 = 0;
        this.seasonDisp[5].split = false;
        this.seasonDisp[1].season1 = 1;
        this.seasonDisp[1].season2 = 0;
        this.seasonDisp[1].split = false;
        this.seasonDisp[2].season1 = 2;
        this.seasonDisp[2].season2 = 4;
        this.seasonDisp[2].split = true;
        this.seasonDisp[4].season1 = 4;
        this.seasonDisp[4].season2 = 5;
        this.seasonDisp[4].split = true;
        String string = "d_streetcracks_1_";
        int[] nArray = new int[]{5, 1, 2, 4};
        for (int i = 0; i <= 7; ++i) {
            ErosionObjOverlaySprites erosionObjOverlaySprites = new ErosionObjOverlaySprites(3, "StreeCracks");
            ErosionObjSprites erosionObjSprites = new ErosionObjSprites(3, "CrackGrass", false, false, false);
            for (int j = 0; j <= 2; ++j) {
                for (int k = 0; k <= nArray.length; ++k) {
                    int n = k * 24 + j * 8 + i;
                    if (k == 0) {
                        erosionObjOverlaySprites.setSprite(j, string + n, 0);
                        continue;
                    }
                    erosionObjSprites.setBase(j, string + n, nArray[k - 1]);
                }
            }
            this.crackObjs.add(new ErosionObjOverlay(erosionObjOverlaySprites, 60, false));
            this.objs.add(new ErosionObj(erosionObjSprites, 60, 0.0f, 0.0f, false));
        }
    }

    @Override
    protected ErosionCategory.Data allocData() {
        return new CategoryData();
    }

    @Override
    public void getObjectNames(ArrayList<String> arrayList) {
        for (int i = 0; i < this.objs.size(); ++i) {
            if (this.objs.get((int)i).name == null || arrayList.contains(this.objs.get((int)i).name)) continue;
            arrayList.add(this.objs.get((int)i).name);
        }
    }

    private static final class CategoryData
    extends ErosionCategory.Data {
        public int gameObj;
        public int maxStage;
        public int spawnTime;
        public int curID = -999999;
        public boolean hasGrass;

        private CategoryData() {
        }

        @Override
        public void save(ByteBuffer byteBuffer) {
            super.save(byteBuffer);
            byteBuffer.put((byte)this.gameObj);
            byteBuffer.put((byte)this.maxStage);
            byteBuffer.putShort((short)this.spawnTime);
            byteBuffer.putInt(this.curID);
            byteBuffer.put(this.hasGrass ? (byte)1 : 0);
        }

        @Override
        public void load(ByteBuffer byteBuffer, int n) {
            super.load(byteBuffer, n);
            this.gameObj = byteBuffer.get();
            this.maxStage = byteBuffer.get();
            this.spawnTime = byteBuffer.getShort();
            this.curID = byteBuffer.getInt();
            this.hasGrass = byteBuffer.get() == 1;
        }
    }
}

