/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.categories;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.erosion.ErosionData;
import zombie.erosion.categories.ErosionCategory;
import zombie.erosion.obj.ErosionObj;
import zombie.erosion.obj.ErosionObjSprites;
import zombie.erosion.season.ErosionIceQueen;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.sprite.IsoSprite;

public final class NatureTrees
extends ErosionCategory {
    private final int[][] soilRef = new int[][]{{2, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5}, {1, 1, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5}, {2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 3, 3, 4, 4, 4, 5}, {1, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9}, {2, 2, 1, 1, 1, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9}, {1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 7, 7, 7, 9}, {1, 2, 8, 8, 8, 6, 6, 6, 6, 6, 6, 6, 6}, {1, 1, 2, 2, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 6, 6, 6, 6, 6}, {1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 8, 8, 8, 6}, {3, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11}, {1, 1, 3, 3, 3, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11}, {1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 10, 10, 10, 11}};
    private final TreeInit[] trees = new TreeInit[]{new TreeInit("American Holly", "e_americanholly_1", true), new TreeInit("Canadian Hemlock", "e_canadianhemlock_1", true), new TreeInit("Virginia Pine", "e_virginiapine_1", true), new TreeInit("Riverbirch", "e_riverbirch_1", false), new TreeInit("Cockspur Hawthorn", "e_cockspurhawthorn_1", false), new TreeInit("Dogwood", "e_dogwood_1", false), new TreeInit("Carolina Silverbell", "e_carolinasilverbell_1", false), new TreeInit("Yellowwood", "e_yellowwood_1", false), new TreeInit("Eastern Redbud", "e_easternredbud_1", false), new TreeInit("Redmaple", "e_redmaple_1", false), new TreeInit("American Linden", "e_americanlinden_1", false)};
    private int[] spawnChance = new int[100];
    private ArrayList<ErosionObj> objs = new ArrayList();

    @Override
    public boolean replaceExistingObject(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2) {
        int n = isoGridSquare.getObjects().size();
        for (int i = n - 1; i >= 1; --i) {
            int n2;
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            IsoSprite isoSprite = isoObject.getSprite();
            if (isoSprite == null || isoSprite.getName() == null) continue;
            if (isoSprite.getName().startsWith("jumbo_tree_01")) {
                n2 = square.soil;
                if (n2 < 0 || n2 >= this.soilRef.length) {
                    n2 = square.rand(isoGridSquare.x, isoGridSquare.y, this.soilRef.length);
                }
                int[] nArray = this.soilRef[n2];
                int n3 = square.noiseMainInt;
                CategoryData categoryData = (CategoryData)this.setCatModData(square);
                categoryData.gameObj = nArray[square.rand(isoGridSquare.x, isoGridSquare.y, nArray.length)] - 1;
                categoryData.stage = categoryData.maxStage = 5 + (int)Math.floor((float)n3 / 51.0f) - 1;
                categoryData.spawnTime = 0;
                categoryData.dispSeason = -1;
                ErosionObj erosionObj = this.objs.get(categoryData.gameObj);
                isoObject.setName(erosionObj.name);
                categoryData.hasSpawned = true;
                return true;
            }
            if (isoSprite.getName().startsWith("vegetation_trees")) {
                n2 = square.soil;
                if (n2 < 0 || n2 >= this.soilRef.length) {
                    n2 = square.rand(isoGridSquare.x, isoGridSquare.y, this.soilRef.length);
                }
                int[] nArray = this.soilRef[n2];
                int n4 = square.noiseMainInt;
                CategoryData categoryData = (CategoryData)this.setCatModData(square);
                categoryData.gameObj = nArray[square.rand(isoGridSquare.x, isoGridSquare.y, nArray.length)] - 1;
                categoryData.stage = categoryData.maxStage = 3 + (int)Math.floor((float)n4 / 51.0f) - 1;
                categoryData.spawnTime = 0;
                categoryData.dispSeason = -1;
                ErosionObj erosionObj = this.objs.get(categoryData.gameObj);
                isoObject.setName(erosionObj.name);
                categoryData.hasSpawned = true;
                return true;
            }
            for (n2 = 0; n2 < this.trees.length; ++n2) {
                if (!isoSprite.getName().startsWith(this.trees[n2].tile)) continue;
                CategoryData categoryData = (CategoryData)this.setCatModData(square);
                categoryData.gameObj = n2;
                categoryData.stage = categoryData.maxStage = 3;
                categoryData.spawnTime = 0;
                isoGridSquare.RemoveTileObject(isoObject);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean validateSpawn(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2, boolean bl3) {
        if (isoGridSquare.getObjects().size() > (bl2 ? 2 : 1)) {
            return false;
        }
        if (square.soil < 0 || square.soil >= this.soilRef.length) {
            return false;
        }
        int[] nArray = this.soilRef[square.soil];
        int n = square.noiseMainInt;
        int n2 = this.spawnChance[n];
        if (n2 > 0 && square.rand(isoGridSquare.x, isoGridSquare.y, 101) < n2) {
            CategoryData categoryData = (CategoryData)this.setCatModData(square);
            categoryData.gameObj = nArray[square.rand(isoGridSquare.x, isoGridSquare.y, nArray.length)] - 1;
            categoryData.maxStage = 2 + (int)Math.floor((n - 50) / 17) - 1;
            categoryData.stage = 0;
            categoryData.spawnTime = 30 + (100 - n);
            return true;
        }
        return false;
    }

    @Override
    public void update(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionCategory.Data data, ErosionData.Chunk chunk, int n) {
        CategoryData categoryData = (CategoryData)data;
        if (n < categoryData.spawnTime || categoryData.doNothing) {
            return;
        }
        if (categoryData.gameObj >= 0 && categoryData.gameObj < this.objs.size()) {
            ErosionObj erosionObj = this.objs.get(categoryData.gameObj);
            int n2 = categoryData.maxStage;
            int n3 = (int)Math.floor((float)(n - categoryData.spawnTime) / ((float)erosionObj.cycleTime / ((float)n2 + 1.0f)));
            if (n3 < data.stage) {
                n3 = data.stage;
            }
            if (n3 > n2) {
                n3 = n2;
            }
            boolean bl = true;
            int n4 = this.currentSeason(square.magicNum, erosionObj);
            boolean bl2 = false;
            this.updateObj(square, data, isoGridSquare, erosionObj, bl, n3, n4, bl2);
        } else {
            this.clearCatModData(square);
        }
    }

    @Override
    public void init() {
        for (int i = 0; i < 100; ++i) {
            this.spawnChance[i] = i >= 50 ? (int)this.clerp((float)(i - 50) / 50.0f, 0.0f, 90.0f) : 0;
        }
        int[] nArray = new int[]{0, 5, 1, 2, 3, 4};
        this.seasonDisp[5].season1 = 0;
        this.seasonDisp[5].season2 = 0;
        this.seasonDisp[5].split = false;
        this.seasonDisp[1].season1 = 1;
        this.seasonDisp[1].season2 = 0;
        this.seasonDisp[1].split = false;
        this.seasonDisp[2].season1 = 2;
        this.seasonDisp[2].season2 = 3;
        this.seasonDisp[2].split = true;
        this.seasonDisp[4].season1 = 4;
        this.seasonDisp[4].season2 = 0;
        this.seasonDisp[4].split = true;
        String string = null;
        ErosionIceQueen erosionIceQueen = ErosionIceQueen.instance;
        for (int i = 0; i < this.trees.length; ++i) {
            String string2 = this.trees[i].name;
            String string3 = this.trees[i].tile;
            boolean bl = !this.trees[i].evergreen;
            ErosionObjSprites erosionObjSprites = new ErosionObjSprites(6, string2, true, false, bl);
            for (int j = 0; j < 6; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    int n;
                    if (j > 3) {
                        n = 0 + k * 2 + (j - 4);
                        if (k == 0) {
                            string = string3.replace("_1", "JUMBO_1") + "_" + n;
                            erosionObjSprites.setBase(j, string, 0);
                            continue;
                        }
                        if (k == 1) {
                            erosionIceQueen.addSprite(string, string3.replace("_1", "JUMBO_1") + "_" + n);
                            continue;
                        }
                        if (!bl) continue;
                        erosionObjSprites.setChildSprite(j, string3.replace("_1", "JUMBO_1") + "_" + n, nArray[k]);
                        continue;
                    }
                    n = 0 + k * 4 + j;
                    if (k == 0) {
                        string = string3 + "_" + n;
                        erosionObjSprites.setBase(j, string, 0);
                        continue;
                    }
                    if (k == 1) {
                        erosionIceQueen.addSprite(string, string3 + "_" + n);
                        continue;
                    }
                    if (!bl) continue;
                    erosionObjSprites.setChildSprite(j, string3 + "_" + n, nArray[k]);
                }
            }
            ErosionObj erosionObj = new ErosionObj(erosionObjSprites, 60, 0.0f, 0.0f, true);
            this.objs.add(erosionObj);
        }
    }

    @Override
    protected ErosionCategory.Data allocData() {
        return new CategoryData();
    }

    @Override
    public void getObjectNames(ArrayList<String> arrayList) {
        for (int i = 0; i < this.objs.size(); ++i) {
            if (this.objs.get((int)i).name == null || arrayList.contains(this.objs.get((int)i).name)) continue;
            arrayList.add(this.objs.get((int)i).name);
        }
    }

    private class TreeInit {
        public String name;
        public String tile;
        public boolean evergreen;

        public TreeInit(String string, String string2, boolean bl) {
            this.name = string;
            this.tile = string2;
            this.evergreen = bl;
        }
    }

    private static final class CategoryData
    extends ErosionCategory.Data {
        public int gameObj;
        public int maxStage;
        public int spawnTime;

        private CategoryData() {
        }

        @Override
        public void save(ByteBuffer byteBuffer) {
            super.save(byteBuffer);
            byteBuffer.put((byte)this.gameObj);
            byteBuffer.put((byte)this.maxStage);
            byteBuffer.putShort((short)this.spawnTime);
        }

        @Override
        public void load(ByteBuffer byteBuffer, int n) {
            super.load(byteBuffer, n);
            this.gameObj = byteBuffer.get();
            this.maxStage = byteBuffer.get();
            this.spawnTime = byteBuffer.getShort();
        }
    }
}

