/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.categories;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.core.Rand;
import zombie.erosion.ErosionData;
import zombie.erosion.categories.ErosionCategory;
import zombie.erosion.obj.ErosionObj;
import zombie.erosion.obj.ErosionObjSprites;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.sprite.IsoSprite;

public final class NaturePlants
extends ErosionCategory {
    private final int[][] soilRef = new int[][]{{17, 17, 17, 17, 17, 17, 17, 17, 17, 1, 2, 8, 8}, {11, 12, 1, 2, 8, 1, 2, 8, 1, 2, 8, 1, 2, 8, 1, 2, 8}, {11, 12, 11, 12, 11, 12, 11, 12, 15, 16, 18, 19}, {22, 22, 22, 22, 22, 22, 22, 22, 22, 3, 4, 14}, {15, 16, 3, 4, 14, 3, 4, 14, 3, 4, 14, 3, 4, 14}, {11, 12, 15, 16, 15, 16, 15, 16, 15, 16, 21}, {13, 13, 13, 13, 13, 13, 13, 13, 13, 5, 6, 24}, {18, 19, 5, 6, 24, 5, 6, 24, 5, 6, 24, 5, 6, 24}, {18, 19, 18, 19, 18, 19, 18, 19, 20, 21}, {7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 10, 23}, {19, 20, 9, 10, 23, 9, 10, 23, 9, 10, 23, 9, 10, 23}, {15, 16, 18, 19, 20, 19, 20, 19, 20}};
    private int[] spawnChance = new int[100];
    private ArrayList<ErosionObj> objs = new ArrayList();
    private final PlantInit[] plants = new PlantInit[]{new PlantInit("Butterfly Weed", true, 0.05f, 0.25f), new PlantInit("Butterfly Weed", true, 0.05f, 0.25f), new PlantInit("Swamp Sunflower", true, 0.2f, 0.45f), new PlantInit("Swamp Sunflower", true, 0.2f, 0.45f), new PlantInit("Purple Coneflower", true, 0.1f, 0.35f), new PlantInit("Purple Coneflower", true, 0.1f, 0.35f), new PlantInit("Joe-Pye Weed", true, 0.8f, 1.0f), new PlantInit("Blazing Star", true, 0.25f, 0.65f), new PlantInit("Wild Bergamot", true, 0.45f, 0.6f), new PlantInit("Wild Bergamot", true, 0.45f, 0.6f), new PlantInit("White Beard-tongue", true, 0.2f, 0.65f), new PlantInit("White Beard-tongue", true, 0.2f, 0.65f), new PlantInit("Ironweed", true, 0.75f, 0.85f), new PlantInit("White Baneberry", true, 0.4f, 0.8f), new PlantInit("Wild Columbine", true, 0.85f, 1.0f), new PlantInit("Wild Columbine", true, 0.85f, 1.0f), new PlantInit("Jack-in-the-pulpit", false, 0.0f, 0.0f), new PlantInit("Wild Ginger", true, 0.1f, 0.9f), new PlantInit("Wild Ginger", true, 0.1f, 0.9f), new PlantInit("Wild Geranium", true, 0.65f, 0.9f), new PlantInit("Alumroot", true, 0.35f, 0.75f), new PlantInit("Wild Blue Phlox", true, 0.15f, 0.55f), new PlantInit("Polemonium Reptans", true, 0.4f, 0.6f), new PlantInit("Foamflower", true, 0.45f, 1.0f)};

    @Override
    public boolean replaceExistingObject(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2) {
        int n = isoGridSquare.getObjects().size();
        for (int i = n - 1; i >= 1; --i) {
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            IsoSprite isoSprite = isoObject.getSprite();
            if (isoSprite == null || isoSprite.getName() == null) continue;
            if (isoSprite.getName().startsWith("d_plants_1_")) {
                int n2 = Integer.parseInt(isoSprite.getName().replace("d_plants_1_", ""));
                CategoryData categoryData = (CategoryData)this.setCatModData(square);
                categoryData.gameObj = n2 < 32 ? n2 % 8 : (n2 < 48 ? n2 % 8 + 8 : n2 % 8 + 16);
                categoryData.stage = 0;
                categoryData.spawnTime = 0;
                isoGridSquare.RemoveTileObjectErosionNoRecalc(isoObject);
                return true;
            }
            if ("vegetation_groundcover_01_16".equals(isoSprite.getName()) || "vegetation_groundcover_01_17".equals(isoSprite.getName())) {
                CategoryData categoryData = (CategoryData)this.setCatModData(square);
                categoryData.gameObj = 21;
                categoryData.stage = 0;
                categoryData.spawnTime = 0;
                isoGridSquare.RemoveTileObjectErosionNoRecalc(isoObject);
                while (--i > 0) {
                    isoObject = isoGridSquare.getObjects().get(i);
                    isoSprite = isoObject.getSprite();
                    if (isoSprite == null || isoSprite.getName() == null || !isoSprite.getName().startsWith("vegetation_groundcover_01_")) continue;
                    isoGridSquare.RemoveTileObjectErosionNoRecalc(isoObject);
                }
                return true;
            }
            if (!"vegetation_groundcover_01_18".equals(isoSprite.getName()) && !"vegetation_groundcover_01_19".equals(isoSprite.getName()) && !"vegetation_groundcover_01_20".equals(isoSprite.getName()) && !"vegetation_groundcover_01_21".equals(isoSprite.getName()) && !"vegetation_groundcover_01_22".equals(isoSprite.getName()) && !"vegetation_groundcover_01_23".equals(isoSprite.getName())) continue;
            CategoryData categoryData = (CategoryData)this.setCatModData(square);
            categoryData.gameObj = Rand.Next(this.plants.length);
            categoryData.stage = 0;
            categoryData.spawnTime = 0;
            isoGridSquare.RemoveTileObjectErosionNoRecalc(isoObject);
            while (--i > 0) {
                isoObject = isoGridSquare.getObjects().get(i);
                isoSprite = isoObject.getSprite();
                if (isoSprite == null || isoSprite.getName() == null || !isoSprite.getName().startsWith("vegetation_groundcover_01_")) continue;
                isoGridSquare.RemoveTileObjectErosionNoRecalc(isoObject);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validateSpawn(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2, boolean bl3) {
        if (isoGridSquare.getObjects().size() > (bl2 ? 2 : 1)) {
            return false;
        }
        if (square.soil < 0 || square.soil >= this.soilRef.length) {
            return false;
        }
        int[] nArray = this.soilRef[square.soil];
        int n = square.noiseMainInt;
        if (square.rand(isoGridSquare.x, isoGridSquare.y, 101) < this.spawnChance[n]) {
            CategoryData categoryData = (CategoryData)this.setCatModData(square);
            categoryData.gameObj = nArray[square.rand(isoGridSquare.x, isoGridSquare.y, nArray.length)] - 1;
            categoryData.stage = 0;
            categoryData.spawnTime = 100 - n;
            return true;
        }
        return false;
    }

    @Override
    public void update(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionCategory.Data data, ErosionData.Chunk chunk, int n) {
        CategoryData categoryData = (CategoryData)data;
        if (n < categoryData.spawnTime || categoryData.doNothing) {
            return;
        }
        if (categoryData.gameObj >= 0 && categoryData.gameObj < this.objs.size()) {
            ErosionObj erosionObj = this.objs.get(categoryData.gameObj);
            boolean bl = false;
            int n2 = 0;
            int n3 = this.currentSeason(square.magicNum, erosionObj);
            boolean bl2 = this.currentBloom(square.magicNum, erosionObj);
            this.updateObj(square, data, isoGridSquare, erosionObj, bl, n2, n3, bl2);
        } else {
            this.clearCatModData(square);
        }
    }

    @Override
    public void init() {
        int n;
        for (int i = 0; i < 100; ++i) {
            if (i >= 20 && i < 50) {
                this.spawnChance[i] = (int)this.clerp((float)(i - 20) / 30.0f, 0.0f, 8.0f);
                continue;
            }
            if (i < 50 || i >= 80) continue;
            this.spawnChance[i] = (int)this.clerp((float)(i - 50) / 30.0f, 8.0f, 0.0f);
        }
        this.seasonDisp[5].season1 = 0;
        this.seasonDisp[5].season2 = 0;
        this.seasonDisp[5].split = false;
        this.seasonDisp[1].season1 = 1;
        this.seasonDisp[1].season2 = 0;
        this.seasonDisp[1].split = false;
        this.seasonDisp[2].season1 = 2;
        this.seasonDisp[2].season2 = 2;
        this.seasonDisp[2].split = true;
        this.seasonDisp[4].season1 = 4;
        this.seasonDisp[4].season2 = 0;
        this.seasonDisp[4].split = true;
        String string = "d_plants_1_";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i <= 7; ++i) {
            arrayList.add(string + i);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 8; n <= 15; ++n) {
            arrayList2.add(string + n);
        }
        n = 16;
        for (int i = 0; i < this.plants.length; ++i) {
            if (i >= 8) {
                n = 24;
            }
            if (i >= 16) {
                n = 32;
            }
            PlantInit plantInit = this.plants[i];
            ErosionObjSprites erosionObjSprites = new ErosionObjSprites(1, plantInit.name, false, plantInit.hasFlower, false);
            erosionObjSprites.setBase(0, arrayList, 1);
            erosionObjSprites.setBase(0, arrayList2, 4);
            erosionObjSprites.setBase(0, string + (n + i), 2);
            erosionObjSprites.setFlower(0, string + (n + i + 8));
            float f = plantInit.hasFlower ? plantInit.bloomstart : 0.0f;
            float f2 = plantInit.hasFlower ? plantInit.bloomend : 0.0f;
            ErosionObj erosionObj = new ErosionObj(erosionObjSprites, 30, f, f2, false);
            this.objs.add(erosionObj);
        }
    }

    @Override
    protected ErosionCategory.Data allocData() {
        return new CategoryData();
    }

    @Override
    public void getObjectNames(ArrayList<String> arrayList) {
        for (int i = 0; i < this.objs.size(); ++i) {
            if (this.objs.get((int)i).name == null || arrayList.contains(this.objs.get((int)i).name)) continue;
            arrayList.add(this.objs.get((int)i).name);
        }
    }

    private class PlantInit {
        public String name;
        public boolean hasFlower;
        public float bloomstart;
        public float bloomend;

        public PlantInit(String string, boolean bl, float f, float f2) {
            this.name = string;
            this.hasFlower = bl;
            this.bloomstart = f;
            this.bloomend = f2;
        }
    }

    private static final class CategoryData
    extends ErosionCategory.Data {
        public int gameObj;
        public int spawnTime;

        private CategoryData() {
        }

        @Override
        public void save(ByteBuffer byteBuffer) {
            super.save(byteBuffer);
            byteBuffer.put((byte)this.gameObj);
            byteBuffer.putShort((short)this.spawnTime);
        }

        @Override
        public void load(ByteBuffer byteBuffer, int n) {
            super.load(byteBuffer, n);
            this.gameObj = byteBuffer.get();
            this.spawnTime = byteBuffer.getShort();
        }
    }
}

