/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.categories;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.erosion.ErosionData;
import zombie.erosion.categories.ErosionCategory;
import zombie.erosion.obj.ErosionObj;
import zombie.erosion.obj.ErosionObjSprites;
import zombie.erosion.season.ErosionIceQueen;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.sprite.IsoSprite;

public final class NatureGeneric
extends ErosionCategory {
    private ArrayList<ErosionObj> objs = new ArrayList();
    private static final int GRASS = 0;
    private static final int FERNS = 1;
    private static final int GENERIC = 2;
    private ArrayList<ArrayList<Integer>> objsRef = new ArrayList();
    private int[] spawnChance = new int[100];

    @Override
    public boolean replaceExistingObject(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2) {
        int n = isoGridSquare.getObjects().size();
        for (int i = n - 1; i >= 1; --i) {
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            IsoSprite isoSprite = isoObject.getSprite();
            if (isoSprite == null || isoSprite.getName() == null || !isoSprite.getName().startsWith("blends_grassoverlays")) continue;
            float f = 0.3f;
            float f2 = 12.0f;
            if ("Forest".equals(isoGridSquare.getZoneType())) {
                f = 0.5f;
                f2 = 6.0f;
            } else if ("DeepForest".equals(isoGridSquare.getZoneType())) {
                f = 0.7f;
                f2 = 3.0f;
            }
            CategoryData categoryData = (CategoryData)this.setCatModData(square);
            ArrayList<Integer> arrayList = this.objsRef.get(0);
            int n2 = square.noiseMainInt;
            int n3 = square.rand(isoGridSquare.x, isoGridSquare.y, 101);
            if ((float)n3 < (float)n2 / f2) {
                arrayList = square.magicNum < f ? this.objsRef.get(1) : this.objsRef.get(2);
                categoryData.notGrass = true;
                categoryData.maxStage = n2 > 60 ? 1 : 0;
            } else {
                categoryData.maxStage = n2 > 67 ? 2 : (n2 > 50 ? 1 : 0);
            }
            categoryData.gameObj = arrayList.get(square.rand(isoGridSquare.x, isoGridSquare.y, arrayList.size()));
            categoryData.stage = categoryData.maxStage;
            categoryData.spawnTime = 0;
            categoryData.dispSeason = -1;
            ErosionObj erosionObj = this.objs.get(categoryData.gameObj);
            isoObject.setName(erosionObj.name);
            isoObject.doNotSync = true;
            categoryData.hasSpawned = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean validateSpawn(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2, boolean bl3) {
        if (isoGridSquare.getObjects().size() > (bl2 ? 2 : 1)) {
            return false;
        }
        int n = square.noiseMainInt;
        if (square.rand(isoGridSquare.x, isoGridSquare.y, 101) < this.spawnChance[n]) {
            float f = 0.3f;
            float f2 = 12.0f;
            if ("Forest".equals(isoGridSquare.getZoneType())) {
                f = 0.5f;
                f2 = 6.0f;
            } else if ("DeepForest".equals(isoGridSquare.getZoneType())) {
                f = 0.7f;
                f2 = 3.0f;
            }
            CategoryData categoryData = (CategoryData)this.setCatModData(square);
            ArrayList<Integer> arrayList = this.objsRef.get(0);
            int n2 = square.rand(isoGridSquare.x, isoGridSquare.y, 101);
            if ((float)n2 < (float)n / f2) {
                arrayList = square.magicNum < f ? this.objsRef.get(1) : this.objsRef.get(2);
                categoryData.notGrass = true;
                categoryData.maxStage = n > 60 ? 1 : 0;
            } else {
                categoryData.maxStage = n > 67 ? 2 : (n > 50 ? 1 : 0);
            }
            categoryData.gameObj = arrayList.get(square.rand(isoGridSquare.x, isoGridSquare.y, arrayList.size()));
            categoryData.stage = 0;
            categoryData.spawnTime = 100 - n;
            return true;
        }
        return false;
    }

    @Override
    public void update(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionCategory.Data data, ErosionData.Chunk chunk, int n) {
        CategoryData categoryData = (CategoryData)data;
        if (n < categoryData.spawnTime || categoryData.doNothing) {
            return;
        }
        if (categoryData.gameObj >= 0 && categoryData.gameObj < this.objs.size()) {
            int n2;
            ErosionObj erosionObj = this.objs.get(categoryData.gameObj);
            int n3 = categoryData.maxStage;
            int n4 = (int)Math.floor((float)(n - categoryData.spawnTime) / ((float)erosionObj.cycleTime / ((float)n3 + 1.0f)));
            if (n4 > n3) {
                n4 = n3;
            }
            if (n4 >= erosionObj.stages) {
                n4 = erosionObj.stages - 1;
            }
            if (categoryData.stage == categoryData.maxStage) {
                n4 = categoryData.maxStage;
            }
            int n5 = 0;
            if (!categoryData.notGrass) {
                n5 = this.currentSeason(square.magicNum, erosionObj);
                n2 = this.getGroundGrassType(isoGridSquare);
                if (n2 == 2) {
                    n5 = Math.max(n5, 3);
                } else if (n2 == 3) {
                    n5 = Math.max(n5, 4);
                }
            }
            n2 = 0;
            boolean bl = false;
            this.updateObj(square, data, isoGridSquare, erosionObj, n2 != 0, n4, n5, bl);
        } else {
            categoryData.doNothing = true;
        }
    }

    @Override
    public void init() {
        Object object;
        int n;
        int n2;
        ErosionObjSprites erosionObjSprites;
        int n3;
        for (int i = 0; i < 100; ++i) {
            this.spawnChance[i] = (int)this.clerp((float)(i - 0) / 100.0f, 0.0f, 99.0f);
        }
        this.seasonDisp[5].season1 = 5;
        this.seasonDisp[5].season2 = 0;
        this.seasonDisp[5].split = false;
        this.seasonDisp[1].season1 = 1;
        this.seasonDisp[1].season2 = 0;
        this.seasonDisp[1].split = false;
        this.seasonDisp[2].season1 = 2;
        this.seasonDisp[2].season2 = 3;
        this.seasonDisp[2].split = true;
        this.seasonDisp[4].season1 = 4;
        this.seasonDisp[4].season2 = 5;
        this.seasonDisp[4].split = true;
        int[] nArray = new int[]{1, 2, 3, 4, 5};
        int[] nArray2 = new int[]{2, 1, 0};
        for (n3 = 0; n3 < 3; ++n3) {
            this.objsRef.add(new ArrayList());
        }
        for (n3 = 0; n3 <= 5; ++n3) {
            erosionObjSprites = new ErosionObjSprites(3, "Grass", false, false, false);
            for (int i = 0; i < nArray.length; ++i) {
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    n = 0 + i * 18 + n2 * 6 + n3;
                    erosionObjSprites.setBase(nArray2[n2], "e_newgrass_1_" + n, nArray[i]);
                }
            }
            object = new ErosionObj(erosionObjSprites, 60, 0.0f, 0.0f, false);
            this.objs.add((ErosionObj)object);
            this.objsRef.get(0).add(this.objs.size() - 1);
        }
        for (n3 = 0; n3 <= 15; ++n3) {
            erosionObjSprites = new ErosionObjSprites(2, "Generic", false, false, false);
            for (int i = 0; i <= 1; ++i) {
                n2 = i * 16 + n3;
                erosionObjSprites.setBase(i, "d_generic_1_" + n2, 0);
            }
            object = new ErosionObj(erosionObjSprites, 60, 0.0f, 0.0f, true);
            this.objs.add((ErosionObj)object);
            this.objsRef.get(2).add(this.objs.size() - 1);
        }
        ErosionIceQueen erosionIceQueen = ErosionIceQueen.instance;
        for (int i = 0; i <= 7; ++i) {
            object = new ErosionObjSprites(2, "Fern", true, false, false);
            for (int j = 0; j <= 1; ++j) {
                n = 48 + j * 32 + i;
                ((ErosionObjSprites)object).setBase(j, "d_generic_1_" + n, 0);
                erosionIceQueen.addSprite("d_generic_1_" + n, "d_generic_1_" + (n + 16));
            }
            ErosionObj erosionObj = new ErosionObj((ErosionObjSprites)object, 60, 0.0f, 0.0f, true);
            this.objs.add(erosionObj);
            this.objsRef.get(1).add(this.objs.size() - 1);
        }
    }

    @Override
    protected ErosionCategory.Data allocData() {
        return new CategoryData();
    }

    private int toInt(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return 0;
    }

    private int getGroundGrassType(IsoGridSquare isoGridSquare) {
        IsoObject isoObject = isoGridSquare.getFloor();
        if (isoObject == null) {
            return 0;
        }
        IsoSprite isoSprite = isoObject.getSprite();
        if (isoSprite != null && isoSprite.getName() != null && isoSprite.getName().startsWith("blends_natural_01_")) {
            int n;
            int n2 = 0;
            for (n = 18; n < isoSprite.getName().length(); ++n) {
                n2 += this.toInt(isoSprite.getName().charAt(n));
                if (n >= isoSprite.getName().length() - 1) continue;
                n2 *= 10;
            }
            n = n2 / 8;
            int n3 = n2 % 8;
            if (n == 2 && (n3 == 0 || n3 >= 5)) {
                return 1;
            }
            if (n == 4 && (n3 == 0 || n3 >= 5)) {
                return 2;
            }
            if (n == 6 && (n3 == 0 || n3 >= 5)) {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public void getObjectNames(ArrayList<String> arrayList) {
        for (int i = 0; i < this.objs.size(); ++i) {
            if (this.objs.get((int)i).name == null || arrayList.contains(this.objs.get((int)i).name)) continue;
            arrayList.add(this.objs.get((int)i).name);
        }
    }

    private static final class CategoryData
    extends ErosionCategory.Data {
        public int gameObj;
        public int maxStage;
        public int spawnTime;
        public boolean notGrass;

        private CategoryData() {
        }

        @Override
        public void save(ByteBuffer byteBuffer) {
            super.save(byteBuffer);
            byteBuffer.put((byte)this.gameObj);
            byteBuffer.put((byte)this.maxStage);
            byteBuffer.putShort((short)this.spawnTime);
            byteBuffer.put(this.notGrass ? (byte)1 : 0);
        }

        @Override
        public void load(ByteBuffer byteBuffer, int n) {
            super.load(byteBuffer, n);
            this.gameObj = byteBuffer.get();
            this.maxStage = byteBuffer.get();
            this.spawnTime = byteBuffer.getShort();
            this.notGrass = byteBuffer.get() == 1;
        }
    }
}

