/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion.categories;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.erosion.ErosionData;
import zombie.erosion.categories.ErosionCategory;
import zombie.erosion.obj.ErosionObj;
import zombie.erosion.obj.ErosionObjSprites;
import zombie.erosion.season.ErosionIceQueen;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.sprite.IsoSprite;

public final class NatureBush
extends ErosionCategory {
    private final int[][] soilRef = new int[][]{{11, 11, 12, 13}, {5, 5, 7, 8, 11, 11, 12, 13, 11, 11, 12, 13}, {5, 5, 7, 8, 5, 5, 7, 8, 11, 11, 12, 13}, {1, 1, 4, 5}, {5, 5, 7, 8, 1, 1, 4, 5, 1, 1, 4, 5}, {5, 5, 7, 8, 5, 5, 7, 8, 1, 1, 4, 5}, {9, 10, 14, 15}, {5, 5, 7, 8, 9, 10, 14, 15, 9, 10, 14, 15}, {5, 5, 7, 8, 5, 5, 7, 8, 9, 10, 14, 15}, {2, 3, 16, 16}, {5, 5, 7, 8, 2, 3, 16, 16, 2, 3, 16, 16}, {5, 5, 7, 8, 5, 5, 7, 8, 2, 3, 16, 16}};
    private ArrayList<ErosionObj> objs = new ArrayList();
    private int[] spawnChance = new int[100];
    private BushInit[] bush = new BushInit[]{new BushInit("Spicebush", 0.05f, 0.35f, false), new BushInit("Ninebark", 0.65f, 0.75f, true), new BushInit("Ninebark", 0.65f, 0.75f, true), new BushInit("Blueberry", 0.4f, 0.5f, true), new BushInit("Blackberry", 0.4f, 0.5f, true), new BushInit("Piedmont azalea", 0.0f, 0.15f, true), new BushInit("Piedmont azalea", 0.0f, 0.15f, true), new BushInit("Arrowwood viburnum", 0.3f, 0.8f, true), new BushInit("Red chokeberry", 0.9f, 1.0f, true), new BushInit("Red chokeberry", 0.9f, 1.0f, true), new BushInit("Beautyberry", 0.7f, 0.85f, true), new BushInit("New jersey tea", 0.4f, 0.8f, true), new BushInit("New jersey tea", 0.4f, 0.8f, true), new BushInit("Wild hydrangea", 0.2f, 0.35f, true), new BushInit("Wild hydrangea", 0.2f, 0.35f, true), new BushInit("Shrubby St. John's wort", 0.35f, 0.75f, true)};

    @Override
    public boolean replaceExistingObject(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2) {
        int n = isoGridSquare.getObjects().size();
        boolean bl3 = false;
        for (int i = n - 1; i >= 1; --i) {
            Object object;
            int n2;
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            IsoSprite isoSprite = isoObject.getSprite();
            if (isoSprite == null || isoSprite.getName() == null) continue;
            if (isoSprite.getName().startsWith("vegetation_foliage")) {
                n2 = square.soil;
                if (n2 < 0 || n2 >= this.soilRef.length) {
                    n2 = square.rand(isoGridSquare.x, isoGridSquare.y, this.soilRef.length);
                }
                object = this.soilRef[n2];
                int n3 = square.noiseMainInt;
                CategoryData categoryData = (CategoryData)this.setCatModData(square);
                categoryData.gameObj = object[square.rand(isoGridSquare.x, isoGridSquare.y, ((int[])object).length)] - 1;
                categoryData.stage = categoryData.maxStage = (int)Math.floor((float)n3 / 60.0f);
                categoryData.spawnTime = 0;
                isoGridSquare.RemoveTileObject(isoObject);
                bl3 = true;
            }
            if (!isoSprite.getName().startsWith("f_bushes_1_")) continue;
            n2 = Integer.parseInt(isoSprite.getName().replace("f_bushes_1_", ""));
            object = (CategoryData)this.setCatModData(square);
            object.gameObj = n2 % 16;
            object.stage = object.maxStage = 1;
            object.spawnTime = 0;
            isoGridSquare.RemoveTileObject(isoObject);
            bl3 = true;
        }
        return bl3;
    }

    @Override
    public boolean validateSpawn(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, boolean bl, boolean bl2, boolean bl3) {
        if (isoGridSquare.getObjects().size() > (bl2 ? 2 : 1)) {
            return false;
        }
        if (square.soil < 0 || square.soil >= this.soilRef.length) {
            return false;
        }
        int[] nArray = this.soilRef[square.soil];
        int n = square.noiseMainInt;
        int n2 = square.rand(isoGridSquare.x, isoGridSquare.y, 101);
        if (n2 < this.spawnChance[n]) {
            CategoryData categoryData = (CategoryData)this.setCatModData(square);
            categoryData.gameObj = nArray[square.rand(isoGridSquare.x, isoGridSquare.y, nArray.length)] - 1;
            categoryData.maxStage = (int)Math.floor((float)n / 60.0f);
            categoryData.stage = 0;
            categoryData.spawnTime = 100 - n;
            return true;
        }
        return false;
    }

    @Override
    public void update(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionCategory.Data data, ErosionData.Chunk chunk, int n) {
        CategoryData categoryData = (CategoryData)data;
        if (n < categoryData.spawnTime || categoryData.doNothing) {
            return;
        }
        if (categoryData.gameObj >= 0 && categoryData.gameObj < this.objs.size()) {
            ErosionObj erosionObj = this.objs.get(categoryData.gameObj);
            int n2 = categoryData.maxStage;
            int n3 = (int)Math.floor((float)(n - categoryData.spawnTime) / ((float)erosionObj.cycleTime / ((float)n2 + 1.0f)));
            if (n3 < categoryData.stage) {
                n3 = categoryData.stage;
            }
            if (n3 > n2) {
                n3 = n2;
            }
            int n4 = this.currentSeason(square.magicNum, erosionObj);
            boolean bl = this.currentBloom(square.magicNum, erosionObj);
            boolean bl2 = false;
            this.updateObj(square, data, isoGridSquare, erosionObj, bl2, n3, n4, bl);
        } else {
            categoryData.doNothing = true;
        }
    }

    @Override
    public void init() {
        for (int i = 0; i < 100; ++i) {
            if (i >= 45 && i < 60) {
                this.spawnChance[i] = (int)this.clerp((float)(i - 45) / 15.0f, 0.0f, 20.0f);
            }
            if (i < 60 || i >= 90) continue;
            this.spawnChance[i] = (int)this.clerp((float)(i - 60) / 30.0f, 20.0f, 0.0f);
        }
        this.seasonDisp[5].season1 = 0;
        this.seasonDisp[5].season2 = 0;
        this.seasonDisp[5].split = false;
        this.seasonDisp[1].season1 = 1;
        this.seasonDisp[1].season2 = 0;
        this.seasonDisp[1].split = false;
        this.seasonDisp[2].season1 = 2;
        this.seasonDisp[2].season2 = 2;
        this.seasonDisp[2].split = true;
        this.seasonDisp[4].season1 = 4;
        this.seasonDisp[4].season2 = 0;
        this.seasonDisp[4].split = true;
        ErosionIceQueen erosionIceQueen = ErosionIceQueen.instance;
        String string = "f_bushes_1_";
        for (int i = 1; i <= this.bush.length; ++i) {
            int n = i - 1;
            int n2 = n - (int)Math.floor((float)n / 8.0f) * 8;
            BushInit bushInit = this.bush[n];
            ErosionObjSprites erosionObjSprites = new ErosionObjSprites(2, bushInit.name, true, bushInit.hasFlower, true);
            int n3 = 0 + n2;
            int n4 = n3 + 16;
            int n5 = n4 + 16;
            int n6 = n5 + 16;
            int n7 = 64 + n;
            int n8 = n7 + 16;
            erosionObjSprites.setBase(0, string + n3, 0);
            erosionObjSprites.setBase(1, string + (n3 + 8), 0);
            erosionIceQueen.addSprite(string + n3, string + n4);
            erosionIceQueen.addSprite(string + (n3 + 8), string + (n4 + 8));
            erosionObjSprites.setChildSprite(0, string + n5, 1);
            erosionObjSprites.setChildSprite(1, string + (n5 + 8), 1);
            erosionObjSprites.setChildSprite(0, string + n6, 4);
            erosionObjSprites.setChildSprite(1, string + (n6 + 8), 4);
            erosionObjSprites.setChildSprite(0, string + n7, 2);
            erosionObjSprites.setChildSprite(1, string + (n7 + 32), 2);
            if (bushInit.hasFlower) {
                erosionObjSprites.setFlower(0, string + n8);
                erosionObjSprites.setFlower(1, string + (n8 + 32));
            }
            float f = bushInit.hasFlower ? bushInit.bloomstart : 0.0f;
            float f2 = bushInit.hasFlower ? bushInit.bloomend : 0.0f;
            ErosionObj erosionObj = new ErosionObj(erosionObjSprites, 60, f, f2, true);
            this.objs.add(erosionObj);
        }
    }

    @Override
    protected ErosionCategory.Data allocData() {
        return new CategoryData();
    }

    @Override
    public void getObjectNames(ArrayList<String> arrayList) {
        for (int i = 0; i < this.objs.size(); ++i) {
            if (this.objs.get((int)i).name == null || arrayList.contains(this.objs.get((int)i).name)) continue;
            arrayList.add(this.objs.get((int)i).name);
        }
    }

    private class BushInit {
        public String name;
        public float bloomstart;
        public float bloomend;
        public boolean hasFlower;

        public BushInit(String string, float f, float f2, boolean bl) {
            this.name = string;
            this.bloomstart = f;
            this.bloomend = f2;
            this.hasFlower = bl;
        }
    }

    private static final class CategoryData
    extends ErosionCategory.Data {
        public int gameObj;
        public int maxStage;
        public int spawnTime;

        private CategoryData() {
        }

        @Override
        public void save(ByteBuffer byteBuffer) {
            super.save(byteBuffer);
            byteBuffer.put((byte)this.gameObj);
            byteBuffer.put((byte)this.maxStage);
            byteBuffer.putShort((short)this.spawnTime);
        }

        @Override
        public void load(ByteBuffer byteBuffer, int n) {
            super.load(byteBuffer, n);
            this.gameObj = byteBuffer.get();
            this.maxStage = byteBuffer.get();
            this.spawnTime = byteBuffer.getShort();
        }
    }
}

