/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion;

import zombie.erosion.ErosionData;
import zombie.erosion.ErosionRegions;
import zombie.erosion.categories.ErosionCategory;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;

public final class ErosionWorld {
    public boolean init() {
        ErosionRegions.init();
        return true;
    }

    public void validateSpawn(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk) {
        String string;
        boolean bl = isoGridSquare.Is(IsoFlagType.exterior);
        boolean bl2 = isoGridSquare.Has(IsoObjectType.wall);
        IsoObject isoObject = isoGridSquare.getFloor();
        String string2 = string = isoObject != null && isoObject.getSprite() != null ? isoObject.getSprite().getName() : null;
        if (string == null) {
            square.doNothing = true;
            return;
        }
        boolean bl3 = false;
        block0: for (int i = 0; i < ErosionRegions.regions.size(); ++i) {
            ErosionRegions.Region region = ErosionRegions.regions.get(i);
            String string3 = region.tileNameMatch;
            if (string3 != null && !string.startsWith(string3) || region.checkExterior && region.isExterior != bl || region.hasWall && region.hasWall != bl2) continue;
            for (int j = 0; j < region.categories.size(); ++j) {
                ErosionCategory erosionCategory = region.categories.get(j);
                boolean bl4 = erosionCategory.replaceExistingObject(isoGridSquare, square, chunk, bl, bl2);
                if (!bl4) {
                    bl4 = erosionCategory.validateSpawn(isoGridSquare, square, chunk, bl, bl2, false);
                }
                if (!bl4) continue;
                bl3 = true;
                continue block0;
            }
        }
        if (!bl3) {
            square.doNothing = true;
        }
    }

    public void update(IsoGridSquare isoGridSquare, ErosionData.Square square, ErosionData.Chunk chunk, int n) {
        if (square.regions == null) {
            return;
        }
        for (int i = 0; i < square.regions.size(); ++i) {
            ErosionCategory.Data data = square.regions.get(i);
            ErosionCategory erosionCategory = ErosionRegions.getCategory(data.regionID, data.categoryID);
            int n2 = square.regions.size();
            erosionCategory.update(isoGridSquare, square, data, chunk, n);
            if (n2 <= square.regions.size()) continue;
            --i;
        }
    }
}

