/*
 * Decompiled with CFR 0.152.
 */
package zombie.erosion;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.utils.Bits;
import zombie.debug.DebugLog;
import zombie.erosion.ErosionConfig;
import zombie.erosion.ErosionData;
import zombie.erosion.ErosionWorld;
import zombie.erosion.season.ErosionIceQueen;
import zombie.erosion.season.ErosionSeason;
import zombie.erosion.utils.Noise2D;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;

public final class ErosionMain {
    private static ErosionMain instance;
    private ErosionConfig cfg;
    private boolean debug;
    private IsoSpriteManager sprMngr;
    private ErosionIceQueen IceQueen;
    private boolean isSnow;
    private String world;
    private String cfgPath;
    private IsoChunk chunk;
    private ErosionData.Chunk chunkModData;
    private Noise2D noiseMain;
    private Noise2D noiseMoisture;
    private Noise2D noiseMinerals;
    private Noise2D noiseKudzu;
    private ErosionWorld World;
    private ErosionSeason Season;
    private int tickUnit = 144;
    private int ticks = 0;
    private int eTicks = 0;
    private int day = 0;
    private int month = 0;
    private int year = 0;
    private int epoch = 0;
    private static final int[][] soilTable;
    private int snowFrac = 0;
    private int snowFracYesterday = 0;
    private int[] snowFracOnDay;

    public static ErosionMain getInstance() {
        return instance;
    }

    public ErosionMain(IsoSpriteManager isoSpriteManager, boolean bl) {
        instance = this;
        this.sprMngr = isoSpriteManager;
        this.debug = bl;
        this.start();
    }

    public ErosionConfig getConfig() {
        return this.cfg;
    }

    public ErosionSeason getSeasons() {
        return this.Season;
    }

    public int getEtick() {
        return this.eTicks;
    }

    public IsoSpriteManager getSpriteManager() {
        return this.sprMngr;
    }

    public void mainTimer() {
        GameTime gameTime;
        if (GameClient.bClient) {
            if (Core.bDebug) {
                this.cfg.writeFile(this.cfgPath);
            }
            return;
        }
        int n = SandboxOptions.instance.ErosionDays.getValue();
        if (this.debug) {
            ++this.eTicks;
        } else if (n < 0) {
            this.eTicks = 0;
        } else if (n > 0) {
            ++this.ticks;
            this.eTicks = (int)((float)this.ticks / 144.0f / (float)n * 100.0f);
        } else {
            ++this.ticks;
            if (this.ticks >= this.tickUnit) {
                this.ticks = 0;
                ++this.eTicks;
            }
        }
        if (this.eTicks < 0) {
            this.eTicks = Integer.MAX_VALUE;
        }
        if ((gameTime = GameTime.getInstance()).getDay() != this.day || gameTime.getMonth() != this.month || gameTime.getYear() != this.year) {
            this.month = gameTime.getMonth();
            this.year = gameTime.getYear();
            this.day = gameTime.getDay();
            ++this.epoch;
            this.Season.setDay(this.day, this.month, this.year);
            this.snowCheck();
        }
        if (GameServer.bServer) {
            for (int i = 0; i < ServerMap.instance.LoadedCells.size(); ++i) {
                ServerMap.ServerCell serverCell = ServerMap.instance.LoadedCells.get(i);
                if (!serverCell.bLoaded) continue;
                for (int j = 0; j < 5; ++j) {
                    for (int k = 0; k < 5; ++k) {
                        IsoChunk isoChunk = serverCell.chunks[k][j];
                        if (isoChunk == null) continue;
                        ErosionData.Chunk chunk = isoChunk.getErosionData();
                        if (chunk.eTickStamp == this.eTicks && chunk.epoch == this.epoch) continue;
                        for (int i2 = 0; i2 < 10; ++i2) {
                            for (int i3 = 0; i3 < 10; ++i3) {
                                IsoGridSquare isoGridSquare = isoChunk.getGridSquare(i3, i2, 0);
                                if (isoGridSquare == null) continue;
                                this.loadGridsquare(isoGridSquare);
                            }
                        }
                        chunk.eTickStamp = this.eTicks;
                        chunk.epoch = this.epoch;
                    }
                }
            }
        }
        this.cfg.time.ticks = this.ticks;
        this.cfg.time.eticks = this.eTicks;
        this.cfg.time.epoch = this.epoch;
        this.cfg.writeFile(this.cfgPath);
    }

    public void snowCheck() {
    }

    public int getSnowFraction() {
        return this.snowFrac;
    }

    public int getSnowFractionYesterday() {
        return this.snowFracYesterday;
    }

    public boolean isSnow() {
        return this.isSnow;
    }

    public void sendState(ByteBuffer byteBuffer) {
        if (!GameServer.bServer) {
            return;
        }
        byteBuffer.putInt(this.eTicks);
        byteBuffer.putInt(this.ticks);
        byteBuffer.putInt(this.epoch);
        byteBuffer.put((byte)this.getSnowFraction());
        byteBuffer.put((byte)this.getSnowFractionYesterday());
        byteBuffer.putFloat(GameTime.getInstance().getTimeOfDay());
    }

    public void receiveState(ByteBuffer byteBuffer) {
        if (!GameClient.bClient) {
            return;
        }
        int n = this.eTicks;
        int n2 = this.epoch;
        this.eTicks = byteBuffer.getInt();
        this.ticks = byteBuffer.getInt();
        this.epoch = byteBuffer.getInt();
        this.cfg.time.ticks = this.ticks;
        this.cfg.time.eticks = this.eTicks;
        this.cfg.time.epoch = this.epoch;
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        float f = byteBuffer.getFloat();
        GameTime gameTime = GameTime.getInstance();
        if (gameTime.getDay() != this.day || gameTime.getMonth() != this.month || gameTime.getYear() != this.year) {
            this.month = gameTime.getMonth();
            this.year = gameTime.getYear();
            this.day = gameTime.getDay();
            this.Season.setDay(this.day, this.month, this.year);
        }
        if (n != this.eTicks || n2 != this.epoch) {
            this.updateMapNow();
        }
    }

    private void loadGridsquare(IsoGridSquare isoGridSquare) {
        if (isoGridSquare != null && isoGridSquare.chunk != null && isoGridSquare.getZ() == 0) {
            this.getChunk(isoGridSquare);
            ErosionData.Square square = isoGridSquare.getErosionData();
            if (!square.init) {
                this.initGridSquare(isoGridSquare, square);
                this.World.validateSpawn(isoGridSquare, square, this.chunkModData);
            }
            if (square.doNothing) {
                return;
            }
            if (this.chunkModData.eTickStamp >= this.eTicks && this.chunkModData.epoch == this.epoch) {
                return;
            }
            this.World.update(isoGridSquare, square, this.chunkModData, this.eTicks);
        }
    }

    private void initGridSquare(IsoGridSquare isoGridSquare, ErosionData.Square square) {
        int n = isoGridSquare.getX();
        int n2 = isoGridSquare.getY();
        float f = this.noiseMain.layeredNoise((float)n / 10.0f, (float)n2 / 10.0f);
        square.noiseMainByte = Bits.packFloatUnitToByte(f);
        square.noiseMain = f;
        square.noiseMainInt = (int)Math.floor(square.noiseMain * 100.0f);
        square.noiseKudzu = this.noiseKudzu.layeredNoise((float)n / 10.0f, (float)n2 / 10.0f);
        square.soil = this.chunkModData.soil;
        float f2 = (float)square.rand(n, n2, 100) / 100.0f;
        square.magicNumByte = Bits.packFloatUnitToByte(f2);
        square.magicNum = f2;
        square.regions.clear();
        square.init = true;
    }

    private void getChunk(IsoGridSquare isoGridSquare) {
        this.chunk = isoGridSquare.getChunk();
        this.chunkModData = this.chunk.getErosionData();
        if (this.chunkModData.init) {
            return;
        }
        this.initChunk(this.chunk, this.chunkModData);
    }

    private void initChunk(IsoChunk isoChunk, ErosionData.Chunk chunk) {
        chunk.set(isoChunk);
        float f = (float)chunk.x / 5.0f;
        float f2 = (float)chunk.y / 5.0f;
        float f3 = this.noiseMoisture.layeredNoise(f, f2);
        float f4 = this.noiseMinerals.layeredNoise(f, f2);
        int n = f3 < 1.0f ? (int)Math.floor(f3 * 10.0f) : 9;
        int n2 = f4 < 1.0f ? (int)Math.floor(f4 * 10.0f) : 9;
        chunk.init = true;
        chunk.eTickStamp = -1;
        chunk.epoch = -1;
        chunk.moisture = f3;
        chunk.minerals = f4;
        chunk.soil = soilTable[n][n2] - 1;
    }

    private boolean initConfig() {
        File file;
        String string = "erosion.ini";
        if (GameClient.bClient) {
            this.cfg = GameClient.instance.erosionConfig;
            assert (this.cfg != null);
            GameClient.instance.erosionConfig = null;
            this.cfgPath = ZomboidFileSystem.instance.getFileNameInCurrentSave(string);
            return true;
        }
        this.cfg = new ErosionConfig();
        this.cfgPath = ZomboidFileSystem.instance.getFileNameInCurrentSave(string);
        File file2 = new File(this.cfgPath);
        if (file2.exists()) {
            DebugLog.log("erosion: reading " + file2.getAbsolutePath());
            if (this.cfg.readFile(file2.getAbsolutePath())) {
                return true;
            }
            this.cfg = new ErosionConfig();
        }
        if (!(file2 = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + string)).exists() && !Core.getInstance().isNoSave() && (file = ZomboidFileSystem.instance.getMediaFile("data" + File.separator + string)).exists()) {
            try {
                DebugLog.log("erosion: copying " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
                Files.copy(file.toPath(), file2.toPath(), new CopyOption[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (file2.exists()) {
            DebugLog.log("erosion: reading " + file2.getAbsolutePath());
            if (!this.cfg.readFile(file2.getAbsolutePath())) {
                this.cfg = new ErosionConfig();
            }
        }
        int n = SandboxOptions.instance.getErosionSpeed();
        switch (n) {
            case 1: {
                this.cfg.time.tickunit /= 5;
                break;
            }
            case 2: {
                this.cfg.time.tickunit /= 2;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.cfg.time.tickunit *= 2;
                break;
            }
            case 5: {
                this.cfg.time.tickunit *= 5;
            }
        }
        float f = (float)(this.cfg.time.tickunit * 100) / 144.0f;
        float f2 = (SandboxOptions.instance.TimeSinceApo.getValue() - 1) * 30;
        this.cfg.time.eticks = (int)Math.floor(Math.min(1.0f, f2 / f) * 100.0f);
        int n2 = SandboxOptions.instance.ErosionDays.getValue();
        if (n2 > 0) {
            this.cfg.time.tickunit = 144;
            this.cfg.time.eticks = (int)Math.floor(Math.min(1.0f, f2 / (float)n2) * 100.0f);
        }
        return true;
    }

    public void start() {
        if (!this.initConfig()) {
            return;
        }
        this.world = Core.GameSaveWorld;
        this.tickUnit = this.cfg.time.tickunit;
        this.ticks = this.cfg.time.ticks;
        this.eTicks = this.cfg.time.eticks;
        this.month = GameTime.getInstance().getMonth();
        this.year = GameTime.getInstance().getYear();
        this.day = GameTime.getInstance().getDay();
        this.debug = !GameServer.bServer && this.cfg.debug.enabled;
        this.cfg.consolePrint();
        this.noiseMain = new Noise2D();
        this.noiseMain.addLayer(this.cfg.seeds.seedMain_0, 0.5f, 3.0f);
        this.noiseMain.addLayer(this.cfg.seeds.seedMain_1, 2.0f, 5.0f);
        this.noiseMain.addLayer(this.cfg.seeds.seedMain_2, 5.0f, 8.0f);
        this.noiseMoisture = new Noise2D();
        this.noiseMoisture.addLayer(this.cfg.seeds.seedMoisture_0, 2.0f, 3.0f);
        this.noiseMoisture.addLayer(this.cfg.seeds.seedMoisture_1, 1.6f, 5.0f);
        this.noiseMoisture.addLayer(this.cfg.seeds.seedMoisture_2, 0.6f, 8.0f);
        this.noiseMinerals = new Noise2D();
        this.noiseMinerals.addLayer(this.cfg.seeds.seedMinerals_0, 2.0f, 3.0f);
        this.noiseMinerals.addLayer(this.cfg.seeds.seedMinerals_1, 1.6f, 5.0f);
        this.noiseMinerals.addLayer(this.cfg.seeds.seedMinerals_2, 0.6f, 8.0f);
        this.noiseKudzu = new Noise2D();
        this.noiseKudzu.addLayer(this.cfg.seeds.seedKudzu_0, 6.0f, 3.0f);
        this.noiseKudzu.addLayer(this.cfg.seeds.seedKudzu_1, 3.0f, 5.0f);
        this.noiseKudzu.addLayer(this.cfg.seeds.seedKudzu_2, 0.5f, 8.0f);
        this.Season = new ErosionSeason();
        ErosionConfig.Season season = this.cfg.season;
        int n = season.tempMin;
        int n2 = season.tempMax;
        if (SandboxOptions.instance.getTemperatureModifier() == 1) {
            n -= 10;
            n2 -= 10;
        } else if (SandboxOptions.instance.getTemperatureModifier() == 2) {
            n -= 5;
            n2 -= 5;
        } else if (SandboxOptions.instance.getTemperatureModifier() == 4) {
            n = (int)((double)n + 7.5);
            n2 += 4;
        } else if (SandboxOptions.instance.getTemperatureModifier() == 5) {
            n += 15;
            n2 += 8;
        }
        this.Season.init(season.lat, n2, n, season.tempDiff, season.seasonLag, season.noon, season.seedA, season.seedB, season.seedC);
        this.Season.setRain(season.jan, season.feb, season.mar, season.apr, season.may, season.jun, season.jul, season.aug, season.sep, season.oct, season.nov, season.dec);
        this.Season.setDay(this.day, this.month, this.year);
        LuaEventManager.triggerEvent("OnInitSeasons", this.Season);
        this.IceQueen = new ErosionIceQueen(this.sprMngr);
        this.World = new ErosionWorld();
        if (!this.World.init()) {
            return;
        }
        this.snowCheck();
        if (this.debug) {
            // empty if block
        }
        if (GameServer.bServer) {
            // empty if block
        }
    }

    private void loadChunk(IsoChunk isoChunk) {
        ErosionData.Chunk chunk = isoChunk.getErosionData();
        if (!chunk.init) {
            this.initChunk(isoChunk, chunk);
        }
        chunk.eTickStamp = this.eTicks;
        chunk.epoch = this.epoch;
    }

    public void DebugUpdateMapNow() {
        this.updateMapNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMapNow() {
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.getChunkMap(i);
            if (isoChunkMap.ignore) continue;
            IsoChunkMap.bSettingChunk.lock();
            try {
                for (int j = 0; j < IsoChunkMap.ChunkGridWidth; ++j) {
                    for (int k = 0; k < IsoChunkMap.ChunkGridWidth; ++k) {
                        IsoChunk isoChunk = isoChunkMap.getChunk(k, j);
                        if (isoChunk == null) continue;
                        ErosionData.Chunk chunk = isoChunk.getErosionData();
                        if (chunk.eTickStamp == this.eTicks && chunk.epoch == this.epoch) continue;
                        for (int i2 = 0; i2 < 10; ++i2) {
                            for (int i3 = 0; i3 < 10; ++i3) {
                                IsoGridSquare isoGridSquare = isoChunk.getGridSquare(i3, i2, 0);
                                if (isoGridSquare == null) continue;
                                this.loadGridsquare(isoGridSquare);
                            }
                        }
                        chunk.eTickStamp = this.eTicks;
                        chunk.epoch = this.epoch;
                    }
                }
                continue;
            }
            finally {
                IsoChunkMap.bSettingChunk.unlock();
            }
        }
    }

    public static void LoadGridsquare(IsoGridSquare isoGridSquare) {
        instance.loadGridsquare(isoGridSquare);
    }

    public static void ChunkLoaded(IsoChunk isoChunk) {
        instance.loadChunk(isoChunk);
    }

    public static void EveryTenMinutes() {
        instance.mainTimer();
    }

    public static void Reset() {
        instance = null;
    }

    static {
        soilTable = new int[][]{{1, 1, 1, 1, 1, 4, 4, 4, 4, 4}, {1, 1, 1, 1, 2, 5, 4, 4, 4, 4}, {1, 1, 1, 2, 2, 5, 5, 4, 4, 4}, {1, 1, 2, 2, 3, 6, 5, 5, 4, 4}, {1, 2, 2, 3, 3, 6, 6, 5, 5, 4}, {7, 8, 8, 9, 9, 12, 12, 11, 11, 10}, {7, 7, 8, 8, 9, 12, 11, 11, 10, 10}, {7, 7, 7, 8, 8, 11, 11, 10, 10, 10}, {7, 7, 7, 7, 8, 11, 10, 10, 10, 10}, {7, 7, 7, 7, 7, 10, 10, 10, 10, 10}};
    }
}

