/*
 * Decompiled with CFR 0.152.
 */
package zombie.debug.options;

import java.util.ArrayList;
import zombie.debug.BooleanDebugOption;
import zombie.debug.options.IDebugOption;
import zombie.debug.options.IDebugOptionGroup;

public class OptionGroup
implements IDebugOptionGroup {
    public final IDebugOptionGroup Group;
    private IDebugOptionGroup m_parentGroup;
    private final String m_groupName;
    private final ArrayList<IDebugOption> m_children = new ArrayList();

    public OptionGroup(String string) {
        this.m_groupName = string;
        this.Group = this;
    }

    public OptionGroup(IDebugOptionGroup iDebugOptionGroup, String string) {
        this.m_groupName = OptionGroup.getCombinedName(iDebugOptionGroup, string);
        this.Group = this;
        iDebugOptionGroup.addChild(this);
    }

    @Override
    public String getName() {
        return this.m_groupName;
    }

    @Override
    public IDebugOptionGroup getParent() {
        return this.m_parentGroup;
    }

    @Override
    public void setParent(IDebugOptionGroup iDebugOptionGroup) {
        this.m_parentGroup = iDebugOptionGroup;
    }

    @Override
    public Iterable<IDebugOption> getChildren() {
        return this.m_children;
    }

    @Override
    public void addChild(IDebugOption iDebugOption) {
        this.m_children.add(iDebugOption);
        iDebugOption.setParent(this);
        this.onChildAdded(iDebugOption);
    }

    @Override
    public void onChildAdded(IDebugOption iDebugOption) {
        this.onDescendantAdded(iDebugOption);
    }

    @Override
    public void onDescendantAdded(IDebugOption iDebugOption) {
        if (this.m_parentGroup != null) {
            this.m_parentGroup.onDescendantAdded(iDebugOption);
        }
    }

    public static BooleanDebugOption newOption(String string, boolean bl) {
        return OptionGroup.newOptionInternal(null, string, false, bl);
    }

    public static BooleanDebugOption newDebugOnlyOption(String string, boolean bl) {
        return OptionGroup.newOptionInternal(null, string, true, bl);
    }

    public static BooleanDebugOption newOption(IDebugOptionGroup iDebugOptionGroup, String string, boolean bl) {
        return OptionGroup.newOptionInternal(iDebugOptionGroup, string, false, bl);
    }

    public static BooleanDebugOption newDebugOnlyOption(IDebugOptionGroup iDebugOptionGroup, String string, boolean bl) {
        return OptionGroup.newOptionInternal(iDebugOptionGroup, string, true, bl);
    }

    private static BooleanDebugOption newOptionInternal(IDebugOptionGroup iDebugOptionGroup, String string, boolean bl, boolean bl2) {
        String string2 = OptionGroup.getCombinedName(iDebugOptionGroup, string);
        BooleanDebugOption booleanDebugOption = new BooleanDebugOption(string2, bl, bl2);
        if (iDebugOptionGroup != null) {
            iDebugOptionGroup.addChild(booleanDebugOption);
        }
        return booleanDebugOption;
    }

    private static String getCombinedName(IDebugOptionGroup iDebugOptionGroup, String string) {
        String string2 = iDebugOptionGroup != null ? String.format("%s.%s", iDebugOptionGroup.getName(), string) : string;
        return string2;
    }
}

