/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.znet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import zombie.Lua.LuaEventManager;
import zombie.ZomboidFileSystem;
import zombie.core.znet.ISteamWorkshopCallback;
import zombie.core.znet.SteamUGCDetails;
import zombie.core.znet.SteamUtils;
import zombie.core.znet.SteamWorkshopItem;
import zombie.debug.DebugLog;
import zombie.network.GameServer;

public class SteamWorkshop
implements ISteamWorkshopCallback {
    public static final SteamWorkshop instance = new SteamWorkshop();
    private ArrayList<SteamWorkshopItem> stagedItems = new ArrayList();
    private ArrayList<ISteamWorkshopCallback> callbacks = new ArrayList();

    public static void init() {
        if (SteamUtils.isSteamModeEnabled()) {
            instance.n_Init();
        }
        if (!GameServer.bServer) {
            instance.initWorkshopFolder();
        }
    }

    public static void shutdown() {
        if (SteamUtils.isSteamModeEnabled()) {
            instance.n_Shutdown();
        }
    }

    private void copyFile(File file, File file2) {
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            fileOutputStream.getChannel().transferFrom(fileInputStream.getChannel(), 0L, file.length());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void copyFileOrFolder(File file, File file2) {
        if (file.isDirectory()) {
            if (!file2.mkdirs()) {
                return;
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.copyFileOrFolder(new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            this.copyFile(file, file2);
        }
    }

    private void initWorkshopFolder() {
        File file = new File(this.getWorkshopFolder());
        if (!file.exists() && !file.mkdirs()) {
            return;
        }
        File file2 = new File("Workshop" + File.separator + "ModTemplate");
        File file3 = new File(this.getWorkshopFolder() + File.separator + "ModTemplate");
        if (file2.exists() && !file3.exists()) {
            this.copyFileOrFolder(file2, file3);
        }
    }

    public ArrayList<SteamWorkshopItem> loadStagedItems() {
        this.stagedItems.clear();
        for (String string : this.getStageFolders()) {
            SteamWorkshopItem steamWorkshopItem = new SteamWorkshopItem(string);
            steamWorkshopItem.readWorkshopTxt();
            this.stagedItems.add(steamWorkshopItem);
        }
        return this.stagedItems;
    }

    public String getWorkshopFolder() {
        return ZomboidFileSystem.instance.getCacheDir() + File.separator + "Workshop";
    }

    public ArrayList<String> getStageFolders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = FileSystems.getDefault().getPath(this.getWorkshopFolder(), new String[0]);
        try {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return arrayList;
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) throws IOException {
                return Files.isDirectory(path, new LinkOption[0]);
            }
        };
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
            for (Path path2 : directoryStream) {
                String string = path2.toAbsolutePath().toString();
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public boolean CreateWorkshopItem(SteamWorkshopItem steamWorkshopItem) {
        if (steamWorkshopItem.getID() != null) {
            throw new RuntimeException("can't recreate an existing item");
        }
        return this.n_CreateItem();
    }

    public boolean SubmitWorkshopItem(SteamWorkshopItem steamWorkshopItem) {
        if (steamWorkshopItem.getID() == null || !SteamUtils.isValidSteamID(steamWorkshopItem.getID())) {
            throw new RuntimeException("workshop ID is required");
        }
        long l = SteamUtils.convertStringToSteamID(steamWorkshopItem.getID());
        if (!this.n_StartItemUpdate(l)) {
            return false;
        }
        if (!this.n_SetItemTitle(steamWorkshopItem.getTitle())) {
            return false;
        }
        if (!this.n_SetItemDescription(steamWorkshopItem.getSubmitDescription())) {
            return false;
        }
        int n = steamWorkshopItem.getVisibilityInteger();
        if ("Mod Template".equals(steamWorkshopItem.getTitle())) {
            n = 2;
        }
        if (!this.n_SetItemVisibility(n)) {
            return false;
        }
        if (!this.n_SetItemTags(steamWorkshopItem.getSubmitTags())) {
            // empty if block
        }
        if (!this.n_SetItemContent(steamWorkshopItem.getContentFolder())) {
            return false;
        }
        if (!this.n_SetItemPreview(steamWorkshopItem.getPreviewImage())) {
            return false;
        }
        return this.n_SubmitItemUpdate(steamWorkshopItem.getChangeNote());
    }

    public boolean GetItemUpdateProgress(long[] lArray) {
        return this.n_GetItemUpdateProgress(lArray);
    }

    public String[] GetInstalledItemFolders() {
        if (GameServer.bServer) {
            return GameServer.WorkshopInstallFolders;
        }
        return this.n_GetInstalledItemFolders();
    }

    public long GetItemState(long l) {
        return this.n_GetItemState(l);
    }

    public String GetItemInstallFolder(long l) {
        return this.n_GetItemInstallFolder(l);
    }

    public long GetItemInstallTimeStamp(long l) {
        return this.n_GetItemInstallTimeStamp(l);
    }

    public boolean SubscribeItem(long l, ISteamWorkshopCallback iSteamWorkshopCallback) {
        if (!this.callbacks.contains(iSteamWorkshopCallback)) {
            this.callbacks.add(iSteamWorkshopCallback);
        }
        return this.n_SubscribeItem(l);
    }

    public boolean DownloadItem(long l, boolean bl, ISteamWorkshopCallback iSteamWorkshopCallback) {
        if (!this.callbacks.contains(iSteamWorkshopCallback)) {
            this.callbacks.add(iSteamWorkshopCallback);
        }
        return this.n_DownloadItem(l, bl);
    }

    public boolean GetItemDownloadInfo(long l, long[] lArray) {
        return this.n_GetItemDownloadInfo(l, lArray);
    }

    public long CreateQueryUGCDetailsRequest(long[] lArray, ISteamWorkshopCallback iSteamWorkshopCallback) {
        if (!this.callbacks.contains(iSteamWorkshopCallback)) {
            this.callbacks.add(iSteamWorkshopCallback);
        }
        return this.n_CreateQueryUGCDetailsRequest(lArray);
    }

    public SteamUGCDetails GetQueryUGCResult(long l, int n) {
        return this.n_GetQueryUGCResult(l, n);
    }

    public long[] GetQueryUGCChildren(long l, int n) {
        return this.n_GetQueryUGCChildren(l, n);
    }

    public boolean ReleaseQueryUGCRequest(long l) {
        return this.n_ReleaseQueryUGCRequest(l);
    }

    public void RemoveCallback(ISteamWorkshopCallback iSteamWorkshopCallback) {
        this.callbacks.remove(iSteamWorkshopCallback);
    }

    public String getIDFromItemInstallFolder(String string) {
        if (string != null && string.replace("\\", "/").contains("/workshop/content/108600/")) {
            File file = new File(string);
            String string2 = file.getName();
            if (SteamUtils.isValidSteamID(string2)) {
                return string2;
            }
            DebugLog.log("ERROR: " + string2 + " isn't a valid workshop item ID");
        }
        return null;
    }

    private native void n_Init();

    private native void n_Shutdown();

    private native boolean n_CreateItem();

    private native boolean n_StartItemUpdate(long var1);

    private native boolean n_SetItemTitle(String var1);

    private native boolean n_SetItemDescription(String var1);

    private native boolean n_SetItemVisibility(int var1);

    private native boolean n_SetItemTags(String[] var1);

    private native boolean n_SetItemContent(String var1);

    private native boolean n_SetItemPreview(String var1);

    private native boolean n_SubmitItemUpdate(String var1);

    private native boolean n_GetItemUpdateProgress(long[] var1);

    private native String[] n_GetInstalledItemFolders();

    private native long n_GetItemState(long var1);

    private native boolean n_SubscribeItem(long var1);

    private native boolean n_DownloadItem(long var1, boolean var3);

    private native String n_GetItemInstallFolder(long var1);

    private native long n_GetItemInstallTimeStamp(long var1);

    private native boolean n_GetItemDownloadInfo(long var1, long[] var3);

    private native long n_CreateQueryUGCDetailsRequest(long[] var1);

    private native SteamUGCDetails n_GetQueryUGCResult(long var1, int var3);

    private native long[] n_GetQueryUGCChildren(long var1, int var3);

    private native boolean n_ReleaseQueryUGCRequest(long var1);

    @Override
    public void onItemCreated(long l, boolean bl) {
        LuaEventManager.triggerEvent("OnSteamWorkshopItemCreated", SteamUtils.convertSteamIDToString(l), bl);
    }

    @Override
    public void onItemNotCreated(int n) {
        LuaEventManager.triggerEvent("OnSteamWorkshopItemNotCreated", n);
    }

    @Override
    public void onItemUpdated(boolean bl) {
        LuaEventManager.triggerEvent("OnSteamWorkshopItemUpdated", bl);
    }

    @Override
    public void onItemNotUpdated(int n) {
        LuaEventManager.triggerEvent("OnSteamWorkshopItemNotUpdated", n);
    }

    @Override
    public void onItemSubscribed(long l) {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onItemSubscribed(l);
        }
    }

    @Override
    public void onItemNotSubscribed(long l, int n) {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onItemNotSubscribed(l, n);
        }
    }

    @Override
    public void onItemDownloaded(long l) {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onItemDownloaded(l);
        }
    }

    @Override
    public void onItemNotDownloaded(long l, int n) {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onItemNotDownloaded(l, n);
        }
    }

    @Override
    public void onItemQueryCompleted(long l, int n) {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onItemQueryCompleted(l, n);
        }
    }

    @Override
    public void onItemQueryNotCompleted(long l, int n) {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onItemQueryNotCompleted(l, n);
        }
    }
}

